/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.helper;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.property.EntryProp;
import kd.imc.sim.common.model.invoice.TaxedTypeEnum;
import org.apache.commons.collections.CollectionUtils;

public class SimOpenApiHelper {
    private static final ImmutableMap<String, String[]> SPECIAL_ITEMS = new ImmutableMap.Builder().put((Object)"E04", (Object)new String[]{"freights"}).put((Object)"E09", (Object)new String[]{"travelers"}).put((Object)"E07", (Object)new String[]{"vehichevesselships"}).put((Object)"E05", (Object)new String[]{"estatesales", "cobuyers"}).put((Object)"E06", (Object)new String[]{"estatesales"}).build();
    private static final ImmutableSet<String> EXCLUDE_KEY = new ImmutableSet.Builder().add((Object)"sim_original_bill_item").add((Object)"items").build();

    public void setSpecialItemsSeqAndClearSpecialItems(DynamicObject obj) {
        this.dealClearSpecialItemsMethod(obj);
        this.setSpecialItemSeq(obj);
    }

    private void dealClearSpecialItemsMethod(DynamicObject obj) {
        ArrayList<String> specialItemKey = new ArrayList<String>(4);
        boolean isBill = "sim_original_bill".equals(obj.getDynamicObjectType().getName());
        if (isBill) {
            specialItemKey.add("sim_original_bill_item");
        } else {
            specialItemKey.add("items");
        }
        specialItemKey.add("deductions");
        specialItemKey.add("extra");
        String[] specialItems = (String[])SPECIAL_ITEMS.get((Object)obj.getString("specialtype"));
        if (specialItems != null) {
            specialItemKey.addAll(Arrays.asList(specialItems));
        }
        DataEntityPropertyCollection properties = obj.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : properties) {
            if (!(property instanceof EntryProp) || specialItemKey.contains(property.getName())) continue;
            obj.getDynamicObjectCollection(property.getName()).clear();
        }
        if (!"E05".equals(obj.getString("specialtype"))) {
            obj.set("cobuyerflag", null);
        }
        if (isBill) {
            if (!TaxedTypeEnum.all_e_deduction.getValue().equals(obj.getString("taxationstyle"))) {
                obj.getDynamicObjectCollection("deductions").clear();
            }
        } else if (!TaxedTypeEnum.all_e_deduction.getValue().equals(obj.getString("taxedtype"))) {
            obj.getDynamicObjectCollection("deductions").clear();
        }
    }

    private void setSpecialItemSeq(DynamicObject obj) {
        DataEntityPropertyCollection properties = obj.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : properties) {
            DynamicObjectCollection items;
            if (!(property instanceof EntryProp) || EXCLUDE_KEY.contains((Object)property.getName()) || !CollectionUtils.isNotEmpty((Collection)(items = obj.getDynamicObjectCollection(property.getName())))) continue;
            for (int i = 0; i < items.size(); ++i) {
                ((DynamicObject)items.get(i)).set("seq", (Object)(i + 1));
            }
        }
    }
}

