/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.alle;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.ImmutableSet;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.IUserService;
import kd.bos.permission.model.UserParam;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.EncryptUtils;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.PermissionEnum;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.util.RandomSingleton;
import kd.imc.bdm.common.util.UUID;
import kd.imc.bdm.formplugin.org.webapi.AddorgService;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.openapi.constant.AllESystemSource;
import kd.imc.sim.formplugin.openapi.dto.AllEAddCompanyDTO;
import kd.imc.sim.formplugin.openapi.dto.AllEAddOrgResponseDTO;
import kd.imc.sim.formplugin.openapi.service.OpenApiService;

public class AllEAddOrgAndCompanyImpl
implements OpenApiService {
    private static final Log log = LogFactory.getLog(AllEAddOrgAndCompanyImpl.class);
    private static final String PRODUCT_ISSUE_INVOICE = "1";
    private static final String PRODUCT_COLLECT_INVOICE = "2";

    @Override
    public ApiResult processer(RequestVo requestVo) {
        AllEAddOrgResponseDTO allEAddOrgResponseDTO;
        Long rootId;
        DynamicObject org;
        if (null == requestVo) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6570\u636e\u4f20\u5165\u4e3a\u7a7a", (String)"AllEAddOrgAndCompanyImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        AllEAddCompanyDTO allEAddCompanyDTO = (AllEAddCompanyDTO)JSON.parseObject((String)requestVo.getData(), AllEAddCompanyDTO.class);
        log.info(String.format("\u6570\u7535api AllEAddOrgAndCompanyImpl requestData\uff1a%s", JSON.toJSONString((Object)allEAddCompanyDTO)));
        if (StringUtils.isEmpty((CharSequence)allEAddCompanyDTO.getTaxNo())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"AllEAddOrgAndCompanyImpl_1", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)allEAddCompanyDTO.getCompanyName())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u4f01\u4e1a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"AllEAddOrgAndCompanyImpl_2", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)allEAddCompanyDTO.getTaxChannel())) {
            allEAddCompanyDTO.setTaxChannel(PRODUCT_ISSUE_INVOICE);
        }
        if (StringUtils.isEmpty((CharSequence)allEAddCompanyDTO.getProductName())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u8ba2\u9605\u4ea7\u54c1\u4e0d\u80fd\u4e3a\u7a7a", (String)"AllEAddOrgAndCompanyImpl_3", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        ImmutableSet productKeySet = ImmutableSet.of((Object)PRODUCT_ISSUE_INVOICE, (Object)PRODUCT_COLLECT_INVOICE);
        if (!productKeySet.contains((Object)allEAddCompanyDTO.getProductName())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u8ba2\u9605\u4ea7\u54c1\u4e0d\u5b58\u5728", (String)"AllEAddOrgAndCompanyImpl_4", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (allEAddCompanyDTO.getTaxUserList() == null || allEAddCompanyDTO.getTaxUserList().isEmpty()) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u7535\u5b50\u7a0e\u5c40\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"AllEAddOrgAndCompanyImpl_5", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (!StringUtils.isEmpty((CharSequence)allEAddCompanyDTO.getCallbackUrl()) && allEAddCompanyDTO.getCallbackUrl().length() > 100) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u56de\u8c03\u5730\u5740\u8d85\u957f", (String)"AllEAddOrgAndCompanyImpl_6", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        String orgCode = allEAddCompanyDTO.getSystemSource();
        DynamicObject enterpriseDO = BusinessDataServiceHelper.loadSingle((String)"bdm_enterprise_baseinfo", (String)"id,number,org,issuechannel,authtype", (QFilter[])new QFilter("number", "=", (Object)allEAddCompanyDTO.getTaxNo()).toArray());
        boolean existProduct = false;
        if (enterpriseDO != null) {
            if (AllESystemSource.FPY.getOrgCode().equals(orgCode)) {
                orgCode = allEAddCompanyDTO.getTaxNo();
            }
            if (PRODUCT_ISSUE_INVOICE.equals(allEAddCompanyDTO.getProductName()) && !StringUtils.isEmpty((CharSequence)enterpriseDO.getString("issuechannel"))) {
                existProduct = true;
            } else if (PRODUCT_COLLECT_INVOICE.equals(allEAddCompanyDTO.getProductName()) && !StringUtils.isEmpty((CharSequence)enterpriseDO.getString("authtype"))) {
                existProduct = true;
            }
            org = enterpriseDO.getDynamicObject("org");
            org = BusinessDataServiceHelper.loadSingle((Object)org.getPkValue(), (String)"bdm_org");
            org = BusinessDataServiceHelper.loadSingle((Object)org.get("parent"), (String)"bdm_org");
            if (!orgCode.equals(org.getString("number"))) {
                return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u7a0e\u53f7\u5df2\u5b58\u5728\uff0c\u4f20\u5165systemSource\u4e0e\u7a0e\u53f7\u6240\u5c5e\u7ec4\u7ec7\u4e0d\u4e00\u81f4", (String)"AllEAddOrgAndCompanyImpl_7", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            if (existProduct) {
                AllEAddOrgResponseDTO allEAddOrgResponseDTO2 = this.buildAddOrgResponseDTO(orgCode);
                if (allEAddOrgResponseDTO2 == null) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u7a0e\u53f7\u672a\u901a\u8fc7\u6b64api\u6ce8\u518c\uff0c\u65e0\u4e1a\u52a1\u7cfb\u7edf\u4fe1\u606f", (String)"AllEAddOrgAndCompanyImpl_8", (String)"imc-sim-webapi", (Object[])new Object[0]));
                }
                return ResponseVo.success((String)SerializationUtils.toJsonString((Object)allEAddOrgResponseDTO2));
            }
        }
        if (AllESystemSource.FPY.getOrgCode().equals(orgCode)) {
            Long orgId = this.addChildOrg(allEAddCompanyDTO.getTaxNo(), allEAddCompanyDTO.getCompanyName(), allEAddCompanyDTO.getTaxNo(), allEAddCompanyDTO.getCompanyName(), 0L);
            this.addCompanyAndPermission(orgId, allEAddCompanyDTO.getTaxNo(), allEAddCompanyDTO.getTaxUserList(), allEAddCompanyDTO.getProductName());
            AllEAddOrgResponseDTO allEAddOrgResponseDTO3 = this.add3rdAppsAndAesKey(allEAddCompanyDTO.getTaxNo(), allEAddCompanyDTO.getCompanyName(), allEAddCompanyDTO.getCallbackUrl());
            return ResponseVo.success((String)SerializationUtils.toJsonString((Object)allEAddOrgResponseDTO3));
        }
        org = BusinessDataServiceHelper.loadSingle((String)"bdm_org", (String)"", (QFilter[])new QFilter("number", "=", (Object)orgCode).toArray());
        if (org == null) {
            String orgName = allEAddCompanyDTO.getSystemSource();
            rootId = this.addRootOrg(orgCode, orgName);
            allEAddOrgResponseDTO = this.add3rdAppsAndAesKey(orgCode, orgName, allEAddCompanyDTO.getCallbackUrl());
        } else {
            rootId = org.getLong("id");
            allEAddOrgResponseDTO = this.buildAddOrgResponseDTO(orgCode);
        }
        Long orgId = this.addChildOrg(allEAddCompanyDTO.getTaxNo(), allEAddCompanyDTO.getCompanyName(), allEAddCompanyDTO.getTaxNo(), allEAddCompanyDTO.getCompanyName(), rootId);
        this.addCompanyAndPermission(orgId, allEAddCompanyDTO.getTaxNo(), allEAddCompanyDTO.getTaxUserList(), allEAddCompanyDTO.getProductName());
        return ResponseVo.success((String)SerializationUtils.toJsonString((Object)allEAddOrgResponseDTO));
    }

    private AllEAddOrgResponseDTO buildAddOrgResponseDTO(String orgCode) {
        DynamicObject appAccessConfig = BusinessDataServiceHelper.loadSingle((String)"invsm_app_access_config", (String)"aes_pwds", (QFilter[])new QFilter("code", "=", (Object)orgCode).toArray());
        if (appAccessConfig == null) {
            return null;
        }
        AllEAddOrgResponseDTO allEAddOrgResponseDTO = new AllEAddOrgResponseDTO();
        allEAddOrgResponseDTO.setAccountId(RequestContext.get().getAccountId());
        allEAddOrgResponseDTO.setRequestUrl(RequestContext.get().getClientUrl());
        allEAddOrgResponseDTO.setAppId(orgCode);
        allEAddOrgResponseDTO.setAppSecuret(appAccessConfig.getString("aes_pwds"));
        allEAddOrgResponseDTO.setAesKey(appAccessConfig.getString("aes_pwds"));
        allEAddOrgResponseDTO.setUser(orgCode);
        allEAddOrgResponseDTO.setBusinessSystemCode(orgCode);
        return allEAddOrgResponseDTO;
    }

    private AllEAddOrgResponseDTO add3rdAppsAndAesKey(String taxNo, String taxName, String callBackUrl) {
        DynamicObject thirdApps = BusinessDataServiceHelper.newDynamicObject((String)"openapi_3rdapps");
        thirdApps.set("number", (Object)taxNo);
        thirdApps.set("name", (Object)"\u53d1\u7968\u4e91api");
        thirdApps.set("enable", (Object)PRODUCT_ISSUE_INVOICE);
        String appSecret = this.randomPWD16();
        thirdApps.set("syspwd", (Object)EncryptUtils.encryptPSW((String)appSecret));
        thirdApps.set("allowip", (Object)Boolean.TRUE);
        DynamicObjectCollection items = thirdApps.getDynamicObjectCollection("entryentity");
        DynamicObject item = items.addNew();
        QFilter filter = new QFilter("appid", "=", (Object)"0QHC5B1PZ/Z3");
        filter.and("enable", "=", (Object)PRODUCT_ISSUE_INVOICE);
        DynamicObject addIdDO = BusinessDataServiceHelper.loadSingle((String)"open_apiservice_new", (String)"id", (QFilter[])filter.toArray());
        item.set("apiservice", addIdDO.getPkValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{thirdApps});
        Map<String, Object> userMap = this.getUserMap(taxNo, taxName);
        if (!CollectionUtils.isEmpty(userMap)) {
            Long userId = (Long)userMap.get("userId");
            this.addOpenServiceAuth(userId);
        }
        DynamicObject appAccessConfig = BusinessDataServiceHelper.newDynamicObject((String)"invsm_app_access_config");
        appAccessConfig.set("code", (Object)taxNo);
        appAccessConfig.set("name", (Object)taxName);
        appAccessConfig.set("encryption_type", (Object)"0");
        appAccessConfig.set("aes_pwds", (Object)appSecret);
        appAccessConfig.set("callback_url", (Object)callBackUrl);
        appAccessConfig.set("is_valid", (Object)PRODUCT_ISSUE_INVOICE);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{appAccessConfig});
        AllEAddOrgResponseDTO allEAddOrgResponseDTO = new AllEAddOrgResponseDTO();
        allEAddOrgResponseDTO.setAccountId(RequestContext.get().getAccountId());
        allEAddOrgResponseDTO.setRequestUrl(RequestContext.get().getClientUrl());
        allEAddOrgResponseDTO.setAppId(taxNo);
        allEAddOrgResponseDTO.setAppSecuret(appSecret);
        allEAddOrgResponseDTO.setAesKey(appSecret);
        allEAddOrgResponseDTO.setUser(taxNo);
        allEAddOrgResponseDTO.setBusinessSystemCode(taxNo);
        return allEAddOrgResponseDTO;
    }

    private String randomPWD16() {
        char[] charArray = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890".toCharArray();
        StringBuilder sb = new StringBuilder();
        SecureRandom r = RandomSingleton.getInstance();
        for (int x = 0; x < 16; ++x) {
            sb.append(charArray[r.nextInt(charArray.length)]);
        }
        return sb.toString();
    }

    private void addCompanyAndPermission(Long orgId, String taxNo, List<AllEAddCompanyDTO.AllETaxAccount> taxAccountList, String productName) {
        DynamicObject epBaseInfo = BusinessDataServiceHelper.loadSingle((String)"bdm_enterprise_baseinfo", (String)"id,issuechannel,authtype,number,org", (QFilter[])new QFilter("org", "=", (Object)orgId).toArray());
        if (PRODUCT_ISSUE_INVOICE.equals(productName)) {
            epBaseInfo.set("issuechannel", (Object)"0");
        } else if (PRODUCT_COLLECT_INVOICE.equals(productName)) {
            epBaseInfo.set("authtype", (Object)"4");
        }
        ImcSaveServiceHelper.update((DynamicObject)epBaseInfo);
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"bdm_invoice_permission");
        obj.set("orginfo", (Object)orgId);
        obj.set("epinfo", (Object)epBaseInfo);
        obj.set("authstate", (Object)PRODUCT_ISSUE_INVOICE);
        if (PRODUCT_ISSUE_INVOICE.equals(productName)) {
            obj.set("servergroup", (Object)PermissionEnum.ISSUE_INVOICE_SERVICE.getPermissionNo());
        } else if (PRODUCT_COLLECT_INVOICE.equals(productName)) {
            obj.set("servergroup", (Object)PermissionEnum.COLLECT_INVOICE_SERVICE.getPermissionNo());
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
        for (AllEAddCompanyDTO.AllETaxAccount allETaxAccount : taxAccountList) {
            QFilter qFilter = new QFilter("taxno", "=", (Object)taxNo);
            qFilter.and("alleinvoiceaccount", "=", (Object)allETaxAccount.getEtaxAccount());
            boolean exists = QueryServiceHelper.exists((String)"bdm_einvoice_account", (QFilter[])qFilter.toArray());
            if (exists) continue;
            DynamicObject bdmEInvoiceAccount = BusinessDataServiceHelper.newDynamicObject((String)"bdm_einvoice_account");
            bdmEInvoiceAccount.set("epinfo", epBaseInfo.getPkValue());
            bdmEInvoiceAccount.set("taxno", (Object)taxNo);
            bdmEInvoiceAccount.set("alleinvoiceaccount", (Object)allETaxAccount.getEtaxAccount());
            bdmEInvoiceAccount.set("enable", (Object)PRODUCT_ISSUE_INVOICE);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bdmEInvoiceAccount});
        }
    }

    private Long addRootOrg(String orgCode, String orgName) {
        AddorgService service = new AddorgService();
        Long rootId = service.addOrg(orgCode, orgName, null, Long.valueOf(0L));
        service.addBdmOrg(Long.valueOf(0L), rootId, orgCode, orgName, null, null);
        return rootId;
    }

    private Long addChildOrg(String orgCode, String orgName, String taxNo, String taxName, Long rootId) {
        AddorgService service = new AddorgService();
        Long orgId = service.addOrg(orgCode, orgName, taxNo, rootId);
        service.addBdmOrg(rootId, orgId, orgName, orgName, taxNo, taxName);
        return orgId;
    }

    private Map<String, Object> getUserMap(String number, String name) {
        QFilter filter = new QFilter("number", "=", (Object)number);
        DynamicObject userObject = QueryServiceHelper.queryOne((String)"bos_user", (String)"id", (QFilter[])new QFilter[]{filter});
        long id = 0L;
        if (userObject != null) {
            log.info("\u7528\u6237\u5df2\u7ecf\u5b58\u5728number:{},phone:{},email:{}", (Object)number);
            id = userObject.getLong("id");
        }
        ArrayList<UserParam> paramList = new ArrayList<UserParam>();
        UserParam user = new UserParam();
        user.setId(id);
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("number", number);
        dataMap.put("name", name);
        dataMap.put("username", number);
        dataMap.put("usertype", PRODUCT_ISSUE_INVOICE);
        dataMap.put("idcard", "");
        dataMap.put("birthday", "1993-8-8");
        dataMap.put("gender", PRODUCT_ISSUE_INVOICE);
        dataMap.put("picturefield", "");
        dataMap.put("email", UUID.next() + "@qq.com");
        ArrayList posList = new ArrayList(4);
        dataMap.put("entryentity", posList);
        user.setDataMap(dataMap);
        paramList.add(user);
        IUserService userService = (IUserService)ServiceFactory.getService(IUserService.class);
        userService.addOrUpdate(paramList);
        Iterator iterator = paramList.iterator();
        if (iterator.hasNext()) {
            UserParam result1 = (UserParam)iterator.next();
            if (!result1.isSuccess()) {
                throw new KDBizException(new ErrorCode("0001", result1.getMsg()), new Object[0]);
            }
            HashMap<String, Object> userInfo = new HashMap<String, Object>();
            userInfo.put("userId", result1.getId());
            userInfo.put("userName", number);
            userInfo.put("name", name);
            return userInfo;
        }
        throw new KDBizException(new ErrorCode("0002", ResManager.loadKDString((String)"\u521b\u5efa\u7528\u6237\u5931\u8d25", (String)"AllEAddOrgAndCompanyImpl_9", (String)"imc-sim-webapi", (Object[])new Object[0])), new Object[0]);
    }

    private void addOpenServiceAuth(Long userId) {
        QFilter filter = new QFilter("appid", "in", (Object)new String[]{"0QHC5B1PZ/Z3", "0QHC=8NRINCF", "0QHC8968SM1T"});
        QFilter status = new QFilter("enable", "=", (Object)PRODUCT_ISSUE_INVOICE);
        DynamicObjectCollection serviceList = QueryServiceHelper.query((String)"open_apiservice_new", (String)"id,number", (QFilter[])new QFilter[]{filter, status});
        if (!CollectionUtils.isEmpty((Collection)serviceList)) {
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"open_apiauthorize");
            ArrayList<DynamicObject> objects = new ArrayList<DynamicObject>(serviceList.size());
            for (DynamicObject value : serviceList) {
                DynamicObjectCollection userCollection;
                Long addUserId;
                Object pk = null;
                String apiNumber = value.getString("number");
                QFilter[] filters = new QFilter[]{new QFilter("api_number", "=", (Object)apiNumber)};
                DynamicObject object = QueryServiceHelper.queryOne((String)"open_apiauthorize", (String)"id,api_number", (QFilter[])filters);
                if (object != null) {
                    pk = object.get("id");
                    object = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"open_apiauthorize");
                } else {
                    object = new DynamicObject((DynamicObjectType)type);
                }
                if ((addUserId = this.getApiUsers(userCollection = object.getDynamicObjectCollection("api_users"), userId)) == null) continue;
                DynamicObject obj = userCollection.addNew();
                obj.set("fbasedataid_id", (Object)addUserId);
                object.set("api_number", (Object)apiNumber);
                object.set("api_users", (Object)userCollection);
                objects.add(object);
            }
            if (!CollectionUtils.isEmpty(objects)) {
                SaveServiceHelper.save((DynamicObject[])objects.toArray(new DynamicObject[0]));
            }
        }
    }

    private Long getApiUsers(DynamicObjectCollection userCollection, Long userId) {
        for (DynamicObject obj : userCollection) {
            Long user = obj.getLong("fbasedataid_id");
            if (!user.equals(userId)) continue;
            return null;
        }
        return userId;
    }
}

