/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.alle;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.allele.AllEleInterfaceTypeEnum;
import kd.imc.bdm.common.constant.allele.AllEleLonType;
import kd.imc.bdm.common.dto.allele.AllEleLoginRequestDTO;
import kd.imc.bdm.common.dto.allele.AllEleLoginResponseDTO;
import kd.imc.bdm.common.dto.allele.AllEleRequestDTO;
import kd.imc.bdm.common.dto.allele.AllEleResponseDTO;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.AllEleServiceHelper;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.openapi.service.OpenApiService;

public class AllELoginCheckServiceImpl
implements OpenApiService {
    private static final Log log = LogFactory.getLog(AllELoginCheckServiceImpl.class);

    @Override
    public ApiResult processer(RequestVo requestVo) {
        if (null == requestVo) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6570\u636e\u4f20\u5165\u4e3a\u7a7a", (String)"AllELoginCheckServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        try {
            AllEleLoginResponseDTO loginResponse;
            JSONObject jsonObject = JSON.parseObject((String)requestVo.getData());
            log.info("\u6570\u7535\u7535\u5b50\u7a0e\u5c40\u767b\u5f55\u68c0\u6d4b\u4f20\u8f93\u7684\u53c2\u6570\u4e3a\uff1a{}", (Object)jsonObject.toJSONString());
            String taxpayerId = jsonObject.getString("taxpayerId");
            if (StringUtils.isEmpty((CharSequence)taxpayerId)) {
                return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u5f00\u7968\u4f01\u4e1a\u7a0e\u53f7\u4e3a\u7a7a", (String)"AllELoginCheckServiceImpl_1", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            if (!EnterpriseHelper.isLqptChannel((String)taxpayerId)) {
                String msg;
                Boolean checkAuth = jsonObject.getBoolean("checkAuth");
                if (checkAuth == null) {
                    checkAuth = Boolean.FALSE;
                }
                AllEleLoginRequestDTO eleIssue = new AllEleLoginRequestDTO();
                eleIssue.setRequest_path(AllEleInterfaceTypeEnum.LOGIN_CHECK.getRequestPath());
                eleIssue.setLongLinkName("");
                String account = jsonObject.getString("account");
                if (StringUtils.isNotBlank((CharSequence)account) && StringUtils.isNotBlank((CharSequence)(msg = AllEleAuthHelper.checkIssueAccount((String)taxpayerId, (String)account)))) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)msg);
                }
                eleIssue.setAccount(account);
                eleIssue.setCheckAuth(checkAuth);
                AllEleResponseDTO result = AllEleServiceHelper.doPost((String)taxpayerId, (AllEleRequestDTO)eleIssue, AllEleLoginResponseDTO.class);
                log.info("\u6570\u7535\u7535\u5b50\u7a0e\u5c40\u767b\u5f55\u68c0\u6d4b\u8fd4\u56de\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)result));
                if (!result.getSuccess().booleanValue()) {
                    String description = result.getDescription();
                    return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)(StringUtils.isBlank((CharSequence)description) ? ResManager.loadKDString((String)"\u6570\u7535\u7535\u5b50\u7a0e\u5c40\u767b\u5f55\u68c0\u6d4b\u5931\u8d25", (String)"AllELoginCheckServiceImpl_2", (String)"imc-sim-webapi", (Object[])new Object[0]) : description));
                }
                loginResponse = (AllEleLoginResponseDTO)result.getData();
            } else {
                loginResponse = new AllEleLoginResponseDTO();
                loginResponse.setLoginType(Integer.valueOf(1));
                loginResponse.setNeedAuth(Boolean.FALSE);
                loginResponse.setLoginWebUrl("");
                loginResponse.setEtaxAccountType(Integer.valueOf(1));
                loginResponse.setCompanyName("");
                loginResponse.setTaxNo(taxpayerId);
            }
            JSONObject json = new JSONObject();
            json.put("canOperateIssue", (Object)(loginResponse.getNeedAuth() == false && (AllEleLonType.AUTO_LOGIN.equals(loginResponse.getLoginType()) || loginResponse.getEtaxAccountType() != -1) ? 1 : 0));
            json.put("loginType", (Object)loginResponse.getLoginType());
            json.put("needAuth", (Object)loginResponse.getNeedAuth());
            json.put("loginWebUrl", (Object)loginResponse.getLoginWebUrl());
            json.put("etaxAccountType", (Object)loginResponse.getEtaxAccountType());
            json.put("companyName", (Object)loginResponse.getCompanyName());
            json.put("taxNo", (Object)loginResponse.getTaxNo());
            return ResponseVo.success((String)json.toJSONString());
        }
        catch (MsgException e) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u6570\u7535\u7535\u5b50\u7a0e\u5c40\u767b\u5f55\u68c0\u6d4b\u5931\u8d25\uff1a%s", (String)"AllELoginCheckServiceImpl_3", (String)"imc-sim-webapi", (Object[])new Object[0]), e.getErrorMsg()));
        }
        catch (Exception e) {
            log.error("\u6570\u7535\u7535\u5b50\u7a0e\u5c40\u767b\u5f55\u68c0\u6d4b\u5931\u8d25", (Throwable)e);
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6570\u7535\u7535\u5b50\u7a0e\u5c40\u767b\u5f55\u68c0\u6d4b\u5931\u8d25", (String)"AllELoginCheckServiceImpl_2", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
    }
}

