/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.alle;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.google.common.collect.ImmutableSet;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.BillStatusEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.constant.OperationConstant;
import kd.imc.bdm.common.constant.table.RedInfoConstant;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.UUID;
import kd.imc.bdm.file.fpy.enums.SpecialTypeEnum;
import kd.imc.bdm.lqpt.model.request.base.redconfirmdownload.RedConfirmDetailRequest;
import kd.imc.bdm.lqpt.model.request.base.redconfirmdownload.RedConfirmDownloadHeadRequest;
import kd.imc.bdm.lqpt.model.response.base.redconfirmdownload.RedConfirmDetailItemResponse;
import kd.imc.bdm.lqpt.model.response.base.redconfirmdownload.RedConfirmDetailResponse;
import kd.imc.bdm.lqpt.model.response.base.redconfirmdownload.RedConfirmDownloadHeadItem;
import kd.imc.bdm.lqpt.model.response.base.redconfirmdownload.RedConfirmDownloadHeadResponse;
import kd.imc.sim.common.constant.OpenApiInterfaceCodeEnum;
import kd.imc.sim.common.constant.RedConfirmStatusEnum;
import kd.imc.sim.common.constant.RiskControlRecordConstant;
import kd.imc.sim.common.helper.OriginalBillValidateHelper;
import kd.imc.sim.common.helper.allele.ApiAllEHelper;
import kd.imc.sim.common.helper.issueinvoice.IssueInvoiceMqHelper;
import kd.imc.sim.common.model.invoice.InvoiceSpecialType;
import kd.imc.sim.common.service.InvoiceCheckService;
import kd.imc.sim.common.utils.ApiVerifyUtil;
import kd.imc.sim.common.utils.InvoiceQFilterUtil;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.match.MinusBillMatchHelper;
import kd.imc.sim.formplugin.openapi.dto.AllEQuickRedRequestDTO;
import kd.imc.sim.formplugin.openapi.dto.AllEQuickRedRequestItemsDTO;
import kd.imc.sim.formplugin.openapi.service.OpenApiService;
import kd.imc.sim.formplugin.openapi.service.impl.alle.constant.EInvoiceErrCodeEnum;
import kd.imc.sim.formplugin.openapi.service.impl.alle.service.ApiRedService;
import kd.imc.sim.formplugin.openapi.service.impl.alle.service.PartRedService;
import kd.imc.sim.formplugin.redconfirm.helper.RedConfirmBillHelper;
import kd.imc.sim.formplugin.risk.control.BillRiskControlService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class AllEQuickRedInvoiceServiceImpl
implements OpenApiService {
    private static final Log log = LogFactory.getLog(AllEQuickRedInvoiceServiceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiResult processer(RequestVo requestVo) {
        ApiResult apiResult;
        ImmutableSet blueSets;
        String sellerTel;
        String sellerAddr;
        String sellerBank;
        DynamicObject blueInvoiceDO;
        ApiResult existResult;
        boolean isLeqiChannel;
        ImmutableSet keySet;
        if (null == requestVo) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6570\u636e\u4f20\u5165\u4e3a\u7a7a", (String)"AllEQuickRedInvoiceServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        AllEQuickRedRequestDTO allEQuickRedRequestDTO = (AllEQuickRedRequestDTO)JSON.parseObject((String)requestVo.getData(), AllEQuickRedRequestDTO.class);
        log.info("\u6570\u7535\u5feb\u6377\u7ea2\u51b2\u8bf7\u6c42\u7684\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)allEQuickRedRequestDTO));
        allEQuickRedRequestDTO.setBuyerTaxpayerId(allEQuickRedRequestDTO.getBuyerTaxpayerId().replaceAll(" ", "").toUpperCase());
        String billNo = allEQuickRedRequestDTO.getSerialNo();
        if (StringUtils.isEmpty((CharSequence)billNo)) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"AllEQuickRedInvoiceServiceImpl_1", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isNotEmpty((CharSequence)allEQuickRedRequestDTO.getInvoiceNum())) {
            allEQuickRedRequestDTO.setInvoiceNo(allEQuickRedRequestDTO.getInvoiceNum());
        }
        if (!(keySet = ImmutableSet.of((Object)"01", (Object)"02")).contains((Object)allEQuickRedRequestDTO.getInvoiceType())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u53d1\u7968\u79cd\u7c7b\u4e0d\u6b63\u786e", (String)"AllEQuickRedInvoiceServiceImpl_2", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        ApiResult errorResult = OriginalBillValidateHelper.dealCheckBuyerInfoByQuickRed((String)allEQuickRedRequestDTO.getBuyerName(), (String)allEQuickRedRequestDTO.getBuyerTaxpayerId(), (String)allEQuickRedRequestDTO.getBuyerBank(), (String)allEQuickRedRequestDTO.getBuyerBankAccount(), (String)allEQuickRedRequestDTO.getBuyerTel(), (String)allEQuickRedRequestDTO.getBuyerAddress());
        if (errorResult != null) {
            return errorResult;
        }
        errorResult = OriginalBillValidateHelper.dealCheckSellerInfoByQuickRed((String)allEQuickRedRequestDTO.getSellerName(), (String)allEQuickRedRequestDTO.getSellerTaxpayerId(), (String)allEQuickRedRequestDTO.getSellerBank(), (String)allEQuickRedRequestDTO.getSellerBankAccount(), (String)allEQuickRedRequestDTO.getSellerTel(), (String)allEQuickRedRequestDTO.getSellerAddress());
        if (errorResult != null) {
            return errorResult;
        }
        SaleInfo saleInfo = this.getSaleInfo(allEQuickRedRequestDTO.getOrgCode(), allEQuickRedRequestDTO.getSellerTaxpayerId());
        String account = allEQuickRedRequestDTO.getAccount();
        String specialType = allEQuickRedRequestDTO.getSpecialType();
        String sellerTaxpayerId = allEQuickRedRequestDTO.getSellerTaxpayerId();
        String buyerTaxpayerId = allEQuickRedRequestDTO.getBuyerTaxpayerId();
        String taxNo = sellerTaxpayerId;
        if ("E12".equals(specialType)) {
            taxNo = buyerTaxpayerId;
        }
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            taxNo = saleInfo.getSaleTaxNo();
        }
        if (!(isLeqiChannel = EnterpriseHelper.isLqptChannel((String)taxNo))) {
            if (StringUtils.isNotBlank((CharSequence)account)) {
                String msg = AllEleAuthHelper.checkIssueAccount((String)taxNo, (String)account);
                if (StringUtils.isNotBlank((CharSequence)msg)) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)msg);
                }
            } else {
                account = AllEleAuthHelper.getEleAccount((String)taxNo, (boolean)true);
                if (StringUtils.isNotEmpty((CharSequence)account)) {
                    allEQuickRedRequestDTO.setAccount(account);
                }
            }
            allEQuickRedRequestDTO.setDrawer(AllEleAuthHelper.getDrawerByAccount((String)taxNo, (String)account));
        } else if (String.valueOf(allEQuickRedRequestDTO.getDrawer()).length() > 16) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ALLE_DRAWER_LENGTH_ERROR.getCode(), (String)ApiErrCodeEnum.ALLE_DRAWER_LENGTH_ERROR.getMsg());
        }
        if (String.valueOf(allEQuickRedRequestDTO.getRemark()).length() > 450) {
            if (InvoiceUtils.isCutRemark((Long)saleInfo.getOrgId())) {
                String cutRemark = InvoiceUtils.cutRemarkChar((String)allEQuickRedRequestDTO.getRemark(), (int)450);
                allEQuickRedRequestDTO.setRemark(cutRemark);
            } else {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_REMARK_OVER.getCode(), (String)ApiErrCodeEnum.BILL_PUSH_REMARK_OVER.getMsg());
            }
        }
        if ((existResult = this.existWaitInvoice(billNo, saleInfo)) != null) {
            return existResult;
        }
        if (StringUtils.isEmpty((CharSequence)allEQuickRedRequestDTO.getRedReason())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u7ea2\u51b2\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a", (String)"AllEQuickRedInvoiceServiceImpl_3", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)allEQuickRedRequestDTO.getInvoiceNo())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"AllEQuickRedInvoiceServiceImpl_4", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        String erorMsg = this.checkFarmProduceSaleItems(allEQuickRedRequestDTO);
        if (StringUtils.isNotBlank((CharSequence)erorMsg)) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)erorMsg);
        }
        erorMsg = this.checkBuyerEmail(allEQuickRedRequestDTO.getBuyerRecipientMail());
        if (StringUtils.isNotBlank((CharSequence)erorMsg)) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)erorMsg);
        }
        if (GBKUtils.getGBKLength((String)allEQuickRedRequestDTO.getBuyerRecipientPhone()) > 80) {
            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BUYERRPHONE_ERROR_LEN.getCode(), (String)ApiErrCodeEnum.BILL_PUSH_BUYERRPHONE_ERROR_LEN.getMsg());
        }
        boolean isLogin = true;
        ApiResult result = ApiAllEHelper.alleLoginCheck((String)saleInfo.getSaleTaxNo(), (String)allEQuickRedRequestDTO.getAccount());
        if (result != null) {
            if ("0".equals(ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.API_CHECK_LOGIN))) {
                isLogin = false;
            } else {
                return result;
            }
        }
        if ((blueInvoiceDO = ApiRedService.queryBlueInvoice(allEQuickRedRequestDTO.getInvoiceCode(), allEQuickRedRequestDTO.getInvoiceNo())) == null) {
            if (EnterpriseHelper.isLqptChannel((String)saleInfo.getSaleTaxNo()) && !isLogin) {
                return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u539f\u84dd\u7968\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728", (String)"AllEQuickRedInvoiceServiceImpl_16", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            ApiResult apiResult2 = ApiRedService.downloadBlueInvoice(saleInfo.getOrgId(), allEQuickRedRequestDTO);
            if (apiResult2 != null) {
                return apiResult2;
            }
            blueInvoiceDO = ApiRedService.queryBlueInvoice(allEQuickRedRequestDTO.getInvoiceCode(), allEQuickRedRequestDTO.getInvoiceNo());
        } else {
            if ("02".equals(blueInvoiceDO.getString("specialtype"))) {
                String sellerTaxNo = blueInvoiceDO.getString("buyertaxno");
                String sellerName = blueInvoiceDO.getString("buyername");
                sellerBank = blueInvoiceDO.getString("buyerbank");
                String sellerBankAcc = blueInvoiceDO.getString("buyerbankacc");
                sellerAddr = blueInvoiceDO.getString("buyeraddr");
                sellerTel = blueInvoiceDO.getString("buyertelno");
                blueInvoiceDO.set("buyername", blueInvoiceDO.get("salername"));
                blueInvoiceDO.set("buyertaxno", blueInvoiceDO.get("salertaxno"));
                blueInvoiceDO.set("buyerbank", blueInvoiceDO.get("salerbank"));
                blueInvoiceDO.set("buyerbankacc", blueInvoiceDO.get("salerbankacc"));
                blueInvoiceDO.set("buyeraddr", blueInvoiceDO.get("saleraddr"));
                blueInvoiceDO.set("buyertelno", blueInvoiceDO.get("salertelno"));
                blueInvoiceDO.set("salername", (Object)sellerName);
                blueInvoiceDO.set("salertaxno", (Object)sellerTaxNo);
                blueInvoiceDO.set("salerbank", (Object)sellerBank);
                blueInvoiceDO.set("salerbankacc", (Object)sellerBankAcc);
                blueInvoiceDO.set("saleraddr", (Object)sellerAddr);
                blueInvoiceDO.set("salertelno", (Object)sellerTel);
            }
            if (!saleInfo.getSaleTaxNo().equals(blueInvoiceDO.getString("salertaxno"))) {
                return ResponseVo.fail((String)EInvoiceErrCodeEnum.AllE_RED_20028.getCode(), (String)EInvoiceErrCodeEnum.AllE_RED_20028.getMsg());
            }
        }
        if (StringUtils.isEmpty((CharSequence)allEQuickRedRequestDTO.getRedInfoBillNo()) && blueInvoiceDO == null) {
            return ResponseVo.fail((String)EInvoiceErrCodeEnum.AllE_RED_20026.getCode(), (String)EInvoiceErrCodeEnum.AllE_RED_20026.getMsg());
        }
        String blueInvoiceType = blueInvoiceDO.getString("invoicetype");
        if (InvoiceType.ALL_E_NORMAL.getLqptCode().equals(allEQuickRedRequestDTO.getInvoiceType())) {
            blueSets = ImmutableSet.of((Object)"004", (Object)"028", (Object)"08xdp");
            if (blueSets.contains((Object)blueInvoiceType)) {
                return ResponseVo.fail((String)EInvoiceErrCodeEnum.AllE_RED_20029.getCode(), (String)EInvoiceErrCodeEnum.AllE_RED_20029.getMsg());
            }
        } else if (InvoiceType.ALL_E_SPECIAL.getLqptCode().equals(allEQuickRedRequestDTO.getInvoiceType()) && (blueSets = ImmutableSet.of((Object)"007", (Object)"026", (Object)"10xdp")).contains((Object)blueInvoiceType)) {
            return ResponseVo.fail((String)EInvoiceErrCodeEnum.AllE_RED_20030.getCode(), (String)EInvoiceErrCodeEnum.AllE_RED_20030.getMsg());
        }
        DLock lock = null;
        try {
            boolean isLqpt;
            Object redTotalAmount;
            lock = DLock.create((String)(allEQuickRedRequestDTO.getSerialNo() + '_' + "alle_invoice_red"));
            if (!lock.tryLock()) {
                sellerBank = ResponseVo.fail((String)ApiErrCodeEnum.BILL_HANDLER_ING.getCode(), (String)ApiErrCodeEnum.BILL_HANDLER_ING.getMsg());
                return sellerBank;
            }
            List<AllEQuickRedRequestItemsDTO> itemsList = allEQuickRedRequestDTO.getInvoiceDetail();
            if (StringUtils.isBlank((CharSequence)allEQuickRedRequestDTO.getSellerAddress()) && StringUtils.isBlank((CharSequence)allEQuickRedRequestDTO.getSellerTel())) {
                allEQuickRedRequestDTO.setSellerAddress(blueInvoiceDO.getString("saleraddr"));
                allEQuickRedRequestDTO.setBuyerTel(blueInvoiceDO.getString("salertelno"));
            }
            if (StringUtils.isBlank((CharSequence)allEQuickRedRequestDTO.getSellerBank()) && StringUtils.isBlank((CharSequence)allEQuickRedRequestDTO.getSellerBankAccount())) {
                allEQuickRedRequestDTO.setSellerBank(blueInvoiceDO.getString("salerbank"));
                allEQuickRedRequestDTO.setSellerBankAccount(blueInvoiceDO.getString("salerbankacc"));
            }
            if (StringUtils.isBlank((CharSequence)allEQuickRedRequestDTO.getBuyerTel()) && StringUtils.isBlank((CharSequence)allEQuickRedRequestDTO.getBuyerAddress())) {
                allEQuickRedRequestDTO.setBuyerAddress(blueInvoiceDO.getString("buyeraddr"));
                allEQuickRedRequestDTO.setBuyerTel(blueInvoiceDO.getString("buyertelno"));
            }
            if (StringUtils.isBlank((CharSequence)allEQuickRedRequestDTO.getBuyerBank()) && StringUtils.isBlank((CharSequence)allEQuickRedRequestDTO.getBuyerBankAccount())) {
                allEQuickRedRequestDTO.setBuyerBank(blueInvoiceDO.getString("buyerbank"));
                allEQuickRedRequestDTO.setBuyerBankAccount(blueInvoiceDO.getString("buyerbankacc"));
            }
            if (StringUtils.isBlank((CharSequence)allEQuickRedRequestDTO.getBuyerRecipientPhone())) {
                allEQuickRedRequestDTO.setBuyerRecipientPhone(blueInvoiceDO.getString("buyerphone"));
            }
            if (StringUtils.isBlank((CharSequence)allEQuickRedRequestDTO.getBuyerRecipientMail())) {
                allEQuickRedRequestDTO.setBuyerRecipientMail(blueInvoiceDO.getString("buyeremail"));
            }
            if (StringUtils.isEmpty((CharSequence)allEQuickRedRequestDTO.getRedInfoBillNo()) && StringUtils.isEmpty((CharSequence)allEQuickRedRequestDTO.getGovRedConfirmBillUuid()) && CollectionUtils.isNotEmpty(itemsList)) {
                BigDecimal limitRed = blueInvoiceDO.getBigDecimal("remainredamount");
                if (MathUtils.isZero((BigDecimal)limitRed)) {
                    sellerAddr = ResponseVo.fail((String)EInvoiceErrCodeEnum.AllE_RED_20025.getCode(), (String)EInvoiceErrCodeEnum.AllE_RED_20025.getMsg());
                    return sellerAddr;
                }
                if (limitRed.compareTo(allEQuickRedRequestDTO.getTotalAmount().abs()) < 0) {
                    sellerAddr = ResponseVo.fail((String)EInvoiceErrCodeEnum.AllE_RED_20019.getCode(), (String)String.format(ResManager.loadKDString((String)"\u8d85\u8fc7\u53ef\u7ea2\u51b2\u9650\u989d\uff0c\u5269\u4f59\u53ef\u7ea2\u51b2\u91d1\u989d\uff08\u4e0d\u542b\u7a0e\uff09\u4e3a:%s", (String)"AllEQuickRedInvoiceServiceImpl_5", (String)"imc-sim-webapi", (Object[])new Object[0]), limitRed.setScale(2, 4).toPlainString()));
                    return sellerAddr;
                }
                redTotalAmount = ApiRedService.checkRedItems(allEQuickRedRequestDTO.getInvoiceDetail());
                if (!MathUtils.isZero((BigDecimal)allEQuickRedRequestDTO.getTotalAmount()) && allEQuickRedRequestDTO.getTotalAmount().compareTo((BigDecimal)redTotalAmount) != 0) {
                    sellerTel = ResponseVo.fail((String)EInvoiceErrCodeEnum.AllE_RED_20031.getCode(), (String)EInvoiceErrCodeEnum.AllE_RED_20031.getMsg());
                    return sellerTel;
                }
                if (((BigDecimal)redTotalAmount).abs().compareTo(blueInvoiceDO.getBigDecimal("invoiceamount")) == 0) {
                    log.info("\u5168\u989d\u7ea2\u51b2\uff0c\u91d1\u989d\u4e3a" + ((BigDecimal)redTotalAmount).setScale(2, 4));
                } else {
                    sellerTel = new PartRedService().doPartRed(blueInvoiceDO, requestVo.getBusinessSystemCode(), allEQuickRedRequestDTO, saleInfo, isLogin);
                    return sellerTel;
                }
            }
            if ((isLqpt = EnterpriseHelper.isLqptChannel((String)saleInfo.getSaleTaxNo())) && StringUtils.isNotEmpty((CharSequence)allEQuickRedRequestDTO.getRedInfoBillNo())) {
                redTotalAmount = this.quickRedConfirmByLqNo(requestVo.getBusinessSystemCode(), saleInfo, allEQuickRedRequestDTO, blueInvoiceDO);
                return redTotalAmount;
            }
            if (StringUtils.isNotEmpty((CharSequence)allEQuickRedRequestDTO.getRedInfoBillNo()) || StringUtils.isNotEmpty((CharSequence)allEQuickRedRequestDTO.getGovRedConfirmBillUuid())) {
                DynamicObject redConfirmBill = null;
                if (StringUtils.isNotEmpty((CharSequence)allEQuickRedRequestDTO.getRedInfoBillNo())) {
                    redConfirmBill = BusinessDataServiceHelper.loadSingle((String)"sim_red_confirm_bill", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_red_confirm_bill", (boolean)true), (QFilter[])new QFilter("number", "=", (Object)allEQuickRedRequestDTO.getRedInfoBillNo()).toArray());
                } else if (StringUtils.isNotEmpty((CharSequence)allEQuickRedRequestDTO.getGovRedConfirmBillUuid())) {
                    redConfirmBill = BusinessDataServiceHelper.loadSingle((String)"sim_red_confirm_bill", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_red_confirm_bill", (boolean)true), (QFilter[])new QFilter("govuuid", "=", (Object)allEQuickRedRequestDTO.getGovRedConfirmBillUuid()).toArray());
                }
                if (redConfirmBill == null) {
                    sellerTel = ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6570\u7535\u7ea2\u51b2\u6709\u8bef\uff0c\u8bf7\u5148\u65b0\u589e\u7ea2\u5b57\u786e\u8ba4\u5355", (String)"AllEQuickRedInvoiceServiceImpl_6", (String)"imc-sim-webapi", (Object[])new Object[0]));
                    return sellerTel;
                }
                if (StringUtils.isNotEmpty((CharSequence)allEQuickRedRequestDTO.getInvoiceNum()) && !StringUtils.equals((CharSequence)redConfirmBill.getString("originalinvoiceno"), (CharSequence)allEQuickRedRequestDTO.getInvoiceNum())) {
                    sellerTel = ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u4f20\u8f93\u7684\u539f\u84dd\u7968\u53f7\u7801\u4e0e\u5b58\u5728\u7684\u7ea2\u5b57\u786e\u8ba4\u5355\u539f\u84dd\u7968\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"AllEQuickRedInvoiceServiceImpl_7", (String)"imc-sim-webapi", (Object[])new Object[0]));
                    return sellerTel;
                }
                String totalRemark = allEQuickRedRequestDTO.getRemark();
                if (StringUtils.isNotBlank((CharSequence)totalRemark)) {
                    redConfirmBill.set("remark", (Object)totalRemark);
                }
                PartRedService.setAddrBankInfo(redConfirmBill, allEQuickRedRequestDTO);
                String redConfirmBillNo = redConfirmBill.getString("billno");
                if (StringUtils.isEmpty((CharSequence)redConfirmBillNo)) {
                    redConfirmBill.set("billno", (Object)allEQuickRedRequestDTO.getSerialNo());
                } else if (!redConfirmBillNo.equals(allEQuickRedRequestDTO.getSerialNo()) && !"4".equals(redConfirmBill.getString("source"))) {
                    ApiResult apiResult3 = ResponseVo.fail((String)ApiErrCodeEnum.REDCONFIRMBILL_BILLNO_FAIL.getCode(), (String)String.format(ApiErrCodeEnum.REDCONFIRMBILL_BILLNO_FAIL.getMsg(), redConfirmBillNo));
                    return apiResult3;
                }
                ApiResult apiResult4 = this.quickRedConfirmByNumber(requestVo.getBusinessSystemCode(), saleInfo, allEQuickRedRequestDTO, redConfirmBill, blueInvoiceDO);
                return apiResult4;
            }
            this.checkAllRedAmount(blueInvoiceDO);
            apiResult = this.allEQuickRedInvoiceByInvoiceNo(requestVo.getBusinessSystemCode(), allEQuickRedRequestDTO, blueInvoiceDO, isLogin, saleInfo);
            return apiResult;
        }
        catch (Exception e) {
            log.error("\u6570\u7535api\u7ea2\u51b2\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            String errorMsg = e.getMessage();
            if (e instanceof JSONException) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u63a5\u6536\u7684\u6570\u636e\u8f6c\u6362\u5f02\u5e38:%s", (String)"BillPushServiceImpl_46", (String)"imc-sim-webapi", (Object[])new Object[0]), e.getMessage());
            }
            apiResult = ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)errorMsg);
            return apiResult;
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    private String checkBuyerEmail(String buyerRecipientMail) {
        try {
            InvoiceCheckService.checkBuyerEmail((String)buyerRecipientMail);
        }
        catch (MsgException e) {
            return e.getErrorMsg().replace("\u8d2d\u4e70\u65b9", "\u6536\u7968");
        }
        return null;
    }

    private String checkFarmProduceSaleItems(AllEQuickRedRequestDTO allEQuickRedRequestDTO) {
        List<AllEQuickRedRequestItemsDTO> details = allEQuickRedRequestDTO.getInvoiceDetail();
        if (null == details || details.size() == 0) {
            return "";
        }
        for (int i = 0; i < details.size(); ++i) {
            AllEQuickRedRequestItemsDTO detail = details.get(i);
            String taxRate = detail.getTaxRate();
            BigDecimal taxRateDecimalValue = null;
            try {
                taxRateDecimalValue = new BigDecimal(taxRate);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String standardTaxRate = ApiVerifyUtil.getStandardTaxRate(taxRateDecimalValue);
            if (null == standardTaxRate) {
                return String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7a0e\u7387\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5", (String)"AllEQuickRedInvoiceServiceImpl_17", (String)"imc-sim-webapi", (Object[])new Object[0]), i + 1);
            }
            detail.setTaxRate(standardTaxRate);
        }
        String specialType = allEQuickRedRequestDTO.getSpecialType();
        if (!"12".equals(specialType)) {
            return "";
        }
        if (!"02".equals(allEQuickRedRequestDTO.getInvoiceType())) {
            return ResManager.loadKDString((String)"\u5f53\u524d\u53d1\u7968\u7c7b\u578b\u4e0d\u652f\u6301\u5f00\u5177\u81ea\u4ea7\u519c\u4ea7\u54c1\u9500\u552e\u53d1\u7968", (String)"AllEQuickRedInvoiceServiceImpl_18", (String)"imc-sim-webapi", (Object[])new Object[0]);
        }
        for (int i = 0; i < details.size(); ++i) {
            AllEQuickRedRequestItemsDTO detail = details.get(i);
            String taxRate = detail.getTaxRate();
            String privilegeType = detail.getPrivilegeType();
            BigDecimal taxRateDecimalValue = BigDecimal.TEN;
            try {
                taxRateDecimalValue = new BigDecimal(taxRate);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!StringUtils.isNotBlank((CharSequence)privilegeType) || !StringUtils.isNotBlank((CharSequence)privilegeType) || "03".equals(privilegeType) && taxRateDecimalValue.compareTo(BigDecimal.ZERO) == 0) continue;
            return String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u660e\u7ec6\u660e\u7ec6\u7a0e\u7387\u5fc5\u987b\u4e3a\uff1a0,\uff0c\u4f18\u60e0\u653f\u7b56\u5185\u5bb9\u4e3a\uff1a\u514d\u7a0e\uff08\u81ea\u4ea7\u519c\u4ea7\u54c1\u9500\u552e\u53d1\u7968\u660e\u7ec6\u7a0e\u7387\u8981\u6c42\u5fc5\u987b\u4e3a\u514d\u7a0e\uff09", (String)"AllEQuickRedInvoiceServiceImpl_19", (String)"imc-sim-webapi", (Object[])new Object[0]), i + 1);
        }
        return "";
    }

    private void checkAllRedAmount(DynamicObject blueInvoiceDO) {
        String invoiceStatus = blueInvoiceDO.getString("invoicestatus");
        if (StringUtils.equals((CharSequence)invoiceStatus, (CharSequence)"3")) {
            throw new MsgException(EInvoiceErrCodeEnum.AllE_RED_20037.getCode(), EInvoiceErrCodeEnum.AllE_RED_20037.getMsg());
        }
        BigDecimal limitRed = blueInvoiceDO.getBigDecimal("remainredamount");
        BigDecimal invoiceAmount = blueInvoiceDO.getBigDecimal("invoiceamount");
        if (!MathUtils.isNullOrZero((BigDecimal)limitRed) && limitRed.compareTo(invoiceAmount) < 0) {
            throw new MsgException(EInvoiceErrCodeEnum.AllE_RED_20019.getCode(), String.format(ResManager.loadKDString((String)"\u539f\u84dd\u7968\u5df2\u88ab\u90e8\u5206\u7ea2\u51b2\uff0c\u4e0d\u53ef\u8fdb\u884c\u5168\u989d\u7ea2\u51b2\uff0c\u5269\u4f59\u53ef\u7ea2\u51b2\u91d1\u989d\uff08\u4e0d\u542b\u7a0e\uff09\u4e3a:%s", (String)"AllEQuickRedInvoiceServiceImpl_8", (String)"imc-sim-webapi", (Object[])new Object[0]), limitRed.setScale(2, 4).toPlainString()));
        }
    }

    private ApiResult quickRedConfirmByNumber(String systemCode, SaleInfo saleInfo, AllEQuickRedRequestDTO allEQuickRedRequestDTO, DynamicObject redConfirm, DynamicObject blueInvoiceDO) {
        String orderNo = StringUtils.isEmpty((CharSequence)redConfirm.getString("orderno")) ? UUID.randomUUID() : redConfirm.getString("orderno");
        redConfirm.set("orderno", (Object)orderNo);
        log.info("\u6d41\u6c34\u53f7\u4e3a\uff1a{}", (Object)orderNo);
        redConfirm.set("billno", (Object)allEQuickRedRequestDTO.getSerialNo());
        redConfirm.set("systemsource", (Object)systemCode);
        redConfirm.set("interfacecode", (Object)OpenApiInterfaceCodeEnum.ALLE_INVOICE_RED.getCode());
        if (StringUtils.isNotBlank((CharSequence)allEQuickRedRequestDTO.getDrawer())) {
            redConfirm.set("drawer", (Object)allEQuickRedRequestDTO.getDrawer());
        }
        if (StringUtils.isNotBlank((CharSequence)allEQuickRedRequestDTO.getAccount())) {
            redConfirm.set("account", (Object)allEQuickRedRequestDTO.getAccount());
        }
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{redConfirm});
        String confirmStatus = redConfirm.getString("confirmstatus");
        if (!RedConfirmStatusEnum.isQuickRedByNumber((String)confirmStatus)) {
            return ApiRedService.createReturnFail(redConfirm);
        }
        if (StringUtils.isNotEmpty((CharSequence)redConfirm.getString("invoiceno"))) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u8be5\u7ea2\u5b57\u786e\u8ba4\u5355\u5df2\u7ecf\u5f00\u5177\u53d1\u7968\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"AllEQuickRedInvoiceServiceImpl_9", (String)"imc-sim-webapi", (Object[])new Object[0]), (String)ApiErrCodeEnum.NON_INV_CODE_NUM.getCode());
        }
        DynamicObject redDynamicObject = RedConfirmBillHelper.createWaitInvoice((DynamicObject)redConfirm);
        new PartRedService().warpRedInvoiceByRedConfirm(systemCode, redConfirm, allEQuickRedRequestDTO, redDynamicObject);
        ImcSaveServiceHelper.save((DynamicObject)redDynamicObject);
        ApiResult riskControlResult = BillRiskControlService.riskControlSingleApi((DynamicObject)redDynamicObject, (String)"sim_vatinvoice", (RiskControlRecordConstant.ExecuteActionEnum)RiskControlRecordConstant.ExecuteActionEnum.EXECUTE_ACTION_REVERSAL);
        if (riskControlResult != null) {
            return riskControlResult;
        }
        IssueInvoiceMqHelper.submitInvoice2MQ((DynamicObject[])new DynamicObject[]{redDynamicObject});
        return ResponseVo.success((String)ResManager.loadKDString((String)"\u63d0\u4ea4\u7ea2\u51b2\u6210\u529f", (String)"AllEQuickRedInvoiceServiceImpl_10", (String)"imc-sim-webapi", (Object[])new Object[0]));
    }

    private void dealGetTravelerDataMethod(String invoiceCode, String invoiceNum, DynamicObject redConfirm) {
        QFilter qFilter = InvoiceQFilterUtil.getInvoiceByCodeAndNo((String)invoiceCode, (String)invoiceNum);
        DynamicObject blueInvoiceObject = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "invoicestatus", "invoiceamount"), (QFilter[])qFilter.toArray());
        if (blueInvoiceObject != null) {
            blueInvoiceObject = BusinessDataServiceHelper.loadSingle((Object)blueInvoiceObject.getPkValue(), (String)"sim_vatinvoice");
            RedConfirmBillHelper.dealGetTravlerDataMethod((DynamicObject)redConfirm, (DynamicObject)blueInvoiceObject);
        }
    }

    private void dealGetVesselShipDataMethod(String invoiceCode, String invoiceNum, DynamicObject redConfirm) {
        QFilter qFilter = InvoiceQFilterUtil.getInvoiceByCodeAndNo((String)invoiceCode, (String)invoiceNum);
        DynamicObject blueInvoiceObject = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "invoicestatus", "invoiceamount"), (QFilter[])qFilter.toArray());
        if (blueInvoiceObject != null) {
            blueInvoiceObject = BusinessDataServiceHelper.loadSingle((Object)blueInvoiceObject.getPkValue(), (String)"sim_vatinvoice");
            RedConfirmBillHelper.dealGetVesselShipDataMethod((DynamicObject)redConfirm, (DynamicObject)blueInvoiceObject);
        }
    }

    private ApiResult quickRedConfirmByLqNo(String systemCode, SaleInfo saleInfo, AllEQuickRedRequestDTO allEQuickRedRequestDTO, DynamicObject blueInvoiceDO) {
        String redBillNo = allEQuickRedRequestDTO.getRedInfoBillNo();
        String billNo = allEQuickRedRequestDTO.getSerialNo();
        RedConfirmDownloadHeadRequest downloadRequest = new RedConfirmDownloadHeadRequest();
        downloadRequest.setYhjslx("0");
        downloadRequest.setXsfmc(saleInfo.getSaleName());
        downloadRequest.setXsfnsrsbh(saleInfo.getSaleTaxNo());
        downloadRequest.setHzfpxxqrdbh(redBillNo);
        downloadRequest.setNsrsbh(saleInfo.getSaleTaxNo());
        RedConfirmDownloadHeadResponse downloadResponse = RedConfirmBillHelper.queryRedConfirmListByLq((RedConfirmDownloadHeadRequest)downloadRequest);
        List list = downloadResponse.getList();
        if (list == null || list.isEmpty()) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u901a\u8fc7\u7f16\u53f7\u672a\u67e5\u8be2\u5230\u7ea2\u5b57\u786e\u8ba4\u5355\u4fe1\u606f", (String)"AllEQuickRedInvoiceServiceImpl_11", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        RedConfirmDetailRequest detailRequest = new RedConfirmDetailRequest();
        detailRequest.setNsrsbh(saleInfo.getSaleTaxNo());
        detailRequest.setXsfnsrsbh(saleInfo.getSaleTaxNo());
        detailRequest.setUuid(((RedConfirmDownloadHeadItem)list.get(0)).getUuid());
        detailRequest.setHzqrdbh(redBillNo);
        RedConfirmDetailResponse detailResponse = RedConfirmBillHelper.queryRedConfirmDetailByLq((RedConfirmDetailRequest)detailRequest);
        DynamicObject org = TaxUtils.getOrgDynamicObject((Long)saleInfo.getOrgId());
        QFilter filter = new QFilter("number", "=", (Object)detailResponse.getHzfpxxqrdbh());
        DynamicObject redConfirm = BusinessDataServiceHelper.loadSingle((String)"sim_red_confirm_bill", (String)"", (QFilter[])filter.toArray());
        if (redConfirm != null) {
            redConfirm = BusinessDataServiceHelper.loadSingle((Object)redConfirm.getPkValue(), (String)"sim_red_confirm_bill");
            String issueStatus = redConfirm.getString("issuestatus");
            String description = null;
            if (IssueStatusEnum.ok.getCode().equals(issueStatus)) {
                description = ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355\u5df2\u5f00\u7968\uff0c\u65e0\u6cd5\u518d\u6b21\u5f00\u7968", (String)"AllEQuickRedInvoiceServiceImpl_21", (String)"imc-sim-webapi", (Object[])new Object[0]);
            }
            if (IssueStatusEnum.submit.getCode().equals(issueStatus)) {
                description = ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355\u5df2\u63d0\u4ea4\uff0c\u65e0\u6cd5\u518d\u6b21\u5f00\u7968", (String)"AllEQuickRedInvoiceServiceImpl_22", (String)"imc-sim-webapi", (Object[])new Object[0]);
            }
            if (IssueStatusEnum.underway.getCode().equals(issueStatus)) {
                description = ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355\u6b63\u5728\u5f00\u7968\u4e2d\uff0c\u65e0\u6cd5\u518d\u6b21\u5f00\u7968", (String)"AllEQuickRedInvoiceServiceImpl_23", (String)"imc-sim-webapi", (Object[])new Object[0]);
            }
            if (IssueStatusEnum.failed.getCode().equals(issueStatus)) {
                QFilter qFilter;
                String taxNo = redConfirm.getString("salertaxno");
                if ("02".equals(redConfirm.getString("specialtype"))) {
                    taxNo = redConfirm.getString("buyertaxno");
                }
                if (QueryServiceHelper.exists((String)"sim_vatinvoice", (QFilter[])(qFilter = new QFilter("infocode", "=", (Object)detailResponse.getHzfpxxqrdbh()).and("salertaxno", "=", (Object)taxNo)).toArray())) {
                    description = ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355\u5df2\u88ab\u63d0\u4ea4\u5f00\u7968\uff0c\u72b6\u6001\u4e3a\u5f00\u7968\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5", (String)"AllEQuickRedInvoiceServiceImpl_24", (String)"imc-sim-webapi", (Object[])new Object[0]);
                }
            }
            if (description != null) {
                return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)description);
            }
            String totalRemark = allEQuickRedRequestDTO.getRemark();
            if (StringUtils.isNotBlank((CharSequence)totalRemark)) {
                redConfirm.set("remark", (Object)totalRemark);
            }
            PartRedService.setAddrBankInfo(redConfirm, allEQuickRedRequestDTO);
            String redConfirmBillNo = redConfirm.getString("billno");
            if (StringUtils.isEmpty((CharSequence)redConfirmBillNo)) {
                redConfirm.set("billno", (Object)allEQuickRedRequestDTO.getSerialNo());
            } else if (!redConfirmBillNo.equals(allEQuickRedRequestDTO.getSerialNo()) && !"4".equals(redConfirm.getString("source"))) {
                return ResponseVo.fail((String)ApiErrCodeEnum.REDCONFIRMBILL_BILLNO_FAIL.getCode(), (String)String.format(ApiErrCodeEnum.REDCONFIRMBILL_BILLNO_FAIL.getMsg(), redConfirmBillNo));
            }
        } else {
            log.info(String.format("\u4e0d\u5b58\u5728\u7684\u7ea2\u5b57\u786e\u8ba4\u5355\u6570\u636e\uff1a%s\uff0c\u65b0\u589e\u7ea2\u5b57\u786e\u8ba4\u5355", detailResponse.getHzfpxxqrdbh()));
            redConfirm = BusinessDataServiceHelper.newDynamicObject((String)"sim_red_confirm_bill");
            DynamicObjectUtil.bean2DynamicObject((Object)detailResponse, (DynamicObject)redConfirm);
            if (StringUtils.isNotBlank((CharSequence)allEQuickRedRequestDTO.getRemark())) {
                redConfirm.set("remark", (Object)allEQuickRedRequestDTO.getRemark());
            }
            redConfirm.set("orderno", (Object)UUID.randomUUID());
            redConfirm.set("applicant", (Object)RedInfoConstant.ApplicantEnum.SALER.getCode());
            redConfirm.set("source", (Object)"4");
            redConfirm.set("enable", (Object)"1");
            redConfirm.set("status", (Object)BillStatusEnum.NO_APPROVAL_REQUIRED.getCode());
            redConfirm.set("creator", (Object)RequestContext.get().getUserId());
            redConfirm.set("totalamount", (Object)detailResponse.getHzcxje().add(detailResponse.getHzcxse()));
            redConfirm.set("hsbz", (Object)"0");
            PartRedService.setAddrBankInfo(redConfirm, allEQuickRedRequestDTO);
            if (StringUtils.equalsIgnoreCase((CharSequence)detailResponse.getYkjhzfpbz(), (CharSequence)"Y")) {
                redConfirm.set("issuestatus", (Object)"0");
            } else {
                redConfirm.set("issuestatus", (Object)"2");
            }
            if (StringUtils.isNotEmpty((CharSequence)detailResponse.getLzkprq())) {
                redConfirm.set("originalissuetime", (Object)DateUtils.handleDate((String)detailResponse.getLzkprq()));
            }
            redConfirm.set("org", (Object)org);
            redConfirm.set("useorg", (Object)org);
            redConfirm.set("createorg", (Object)org);
            redConfirm.set("ctrlstrategy", (Object)"7");
            redConfirm.set("billno", (Object)billNo);
            String specialType = InvoiceSpecialType.InvoiceSpecialTypeEnum.getCodeByLqCode((String)detailResponse.getLzfpTdyslxDm());
            redConfirm.set("specialtype", (Object)specialType);
            redConfirm.set("originalspecialtype", (Object)specialType);
            redConfirm.set("buyeremail", (Object)allEQuickRedRequestDTO.getBuyerRecipientMail());
            redConfirm.set("buyerphone", (Object)allEQuickRedRequestDTO.getBuyerRecipientPhone());
            DynamicObjectCollection redConfirmItems = redConfirm.getDynamicObjectCollection("items");
            for (int i = 0; i < redConfirmItems.size(); ++i) {
                DynamicObject redConfirmItem = (DynamicObject)redConfirmItems.get(i);
                redConfirmItem.set("seq", (Object)(i + 1));
                BigDecimal amount = redConfirmItem.getBigDecimal("amount");
                BigDecimal tax = redConfirmItem.getBigDecimal("tax");
                BigDecimal taxAmount = amount.add(tax);
                redConfirmItem.set("taxamount", (Object)taxAmount);
                BigDecimal num = redConfirmItem.getBigDecimal("num");
                if (!MathUtils.isNullOrZero((BigDecimal)num)) {
                    BigDecimal taxUnitPrice = taxAmount.divide(num, 8, 4);
                    redConfirmItem.set("taxunitprice", (Object)taxUnitPrice);
                }
                redConfirmItem.set("rowtype", (Object)"0");
                redConfirmItem.set("taxpremark", (Object)"0");
            }
        }
        String invoiceCode = allEQuickRedRequestDTO.getInvoiceCode();
        String invoiceNum = allEQuickRedRequestDTO.getInvoiceNum() == null ? allEQuickRedRequestDTO.getInvoiceNo() : allEQuickRedRequestDTO.getInvoiceNum();
        this.dealGetTravelerDataMethod(invoiceCode, invoiceNum, redConfirm);
        this.dealGetVesselShipDataMethod(invoiceCode, invoiceNum, redConfirm);
        List hzqrxxmxList = detailResponse.getHzqrxxmxList();
        boolean goodsNamsIsSame = false;
        for (RedConfirmDetailItemResponse detail : hzqrxxmxList) {
            if (!detail.getXmmc().equals(detail.getHwhyslwfwmc()) || !StringUtils.isBlank((CharSequence)detail.getSpfwjc())) continue;
            goodsNamsIsSame = true;
            break;
        }
        redConfirm.set("goodsnamesame", (Object)(goodsNamsIsSame ? "Y" : "N"));
        redConfirm.set("uploadstatus", (Object)"1");
        redConfirm.set("interfacecode", (Object)OpenApiInterfaceCodeEnum.ALLE_INVOICE_RED.getCode());
        redConfirm.set("systemsource", (Object)systemCode);
        redConfirm.set("confirmstatus", (Object)detailResponse.getHzqrxxztDm());
        InvoiceType invoiceTypeByLq = RedConfirmBillHelper.getInvoiceTypeByLq((String)detailResponse.getLzfphm(), (String)detailResponse.getLzfppzDm(), (String)detailResponse.getSfzzfpbz());
        redConfirm.set("originalinvoicetype", (Object)invoiceTypeByLq.getTypeCode());
        if (InvoiceUtils.isSpecialInvoice((String)invoiceTypeByLq.getTypeCode()) || InvoiceUtils.isAllESpecialInvoice((String)invoiceTypeByLq.getTypeCode())) {
            redConfirm.set("invoicetype", (Object)InvoiceType.ALL_E_SPECIAL.getTypeCode());
        } else {
            redConfirm.set("invoicetype", (Object)InvoiceType.ALL_E_NORMAL.getTypeCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)detailResponse.getLrrq())) {
            redConfirm.set("uploaddate", (Object)DateUtils.handleDate((String)detailResponse.getLrrq()));
        }
        if (StringUtils.isNotEmpty((CharSequence)detailResponse.getHzkprq())) {
            redConfirm.set("issuetime", (Object)DateUtils.handleDate((String)detailResponse.getHzkprq()));
        }
        if (StringUtils.isNotEmpty((CharSequence)detailResponse.getQrrq())) {
            redConfirm.set("confirmdate", (Object)DateUtils.handleDate((String)detailResponse.getQrrq()));
        }
        if (StringUtils.isNotBlank((CharSequence)allEQuickRedRequestDTO.getDrawer())) {
            redConfirm.set("drawer", (Object)allEQuickRedRequestDTO.getDrawer());
        }
        redConfirm.set("billno", (Object)allEQuickRedRequestDTO.getSerialNo());
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"sim_red_confirm_bill", (DynamicObject[])new DynamicObject[]{redConfirm}, null);
        if (!operationResult.isSuccess()) {
            throw new MsgException(ApiErrCodeEnum.NON_INV_CODE_NUM.getCode(), OperationConstant.getErrorMsg((OperationResult)operationResult));
        }
        String confirmStatus = detailResponse.getHzqrxxztDm();
        if (StringUtils.equals((CharSequence)confirmStatus, (CharSequence)RedConfirmStatusEnum.NO_CONFIRM.getBillCode()) || StringUtils.equals((CharSequence)confirmStatus, (CharSequence)RedConfirmStatusEnum.ALL_CONFIRM.getBillCode())) {
            if (StringUtils.isEmpty((CharSequence)detailResponse.getHzfphm())) {
                DynamicObject redDynamicObject = RedConfirmBillHelper.createWaitInvoice((DynamicObject)redConfirm);
                new PartRedService().warpRedInvoiceByRedConfirm(systemCode, redConfirm, allEQuickRedRequestDTO, redDynamicObject);
                ImcSaveServiceHelper.save((DynamicObject)redDynamicObject);
                IssueInvoiceMqHelper.submitInvoice2MQ((DynamicObject[])new DynamicObject[]{redDynamicObject});
                return ResponseVo.success((String)ResManager.loadKDString((String)"\u63d0\u4ea4\u7ea2\u51b2\u6210\u529f", (String)"AllEQuickRedInvoiceServiceImpl_10", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u8be5\u7ea2\u5b57\u786e\u8ba4\u5355\u5df2\u7ecf\u5f00\u5177\u53d1\u7968\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"AllEQuickRedInvoiceServiceImpl_9", (String)"imc-sim-webapi", (Object[])new Object[0]), (String)ApiErrCodeEnum.NON_INV_CODE_NUM.getCode());
        }
        return ApiRedService.createReturnFail(redConfirm);
    }

    private ApiResult existWaitInvoice(String billNo, SaleInfo saleInfo) {
        QFilter filter = new QFilter("billno", "=", (Object)billNo).and("issuetype", "=", (Object)IssueType.RED_INVOICE.getTypeCode()).and("orgid", "=", (Object)saleInfo.getOrgId());
        DynamicObject invoiceDO = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)false), (QFilter[])filter.toArray());
        if (invoiceDO != null) {
            String issueStatus = invoiceDO.getString("issuestatus");
            String issueType = invoiceDO.getString("issuetype");
            if (StringUtils.equals((CharSequence)issueStatus, (CharSequence)IssueStatusEnum.ok.getCode())) {
                if (StringUtils.equals((CharSequence)issueType, (CharSequence)IssueType.RED_INVOICE.getTypeCode())) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.ALLE_SERIALNO_EXIST.getCode(), (String)ApiErrCodeEnum.ALLE_SERIALNO_EXIST.getMsg());
                }
            } else {
                ApiResult riskControlResult = BillRiskControlService.riskControlSingleApi((DynamicObject)invoiceDO, (String)"sim_vatinvoice", (RiskControlRecordConstant.ExecuteActionEnum)RiskControlRecordConstant.ExecuteActionEnum.EXECUTE_ACTION_REVERSAL);
                if (riskControlResult != null) {
                    return riskControlResult;
                }
                ApiResult result = ApiAllEHelper.alleLoginCheck((String)invoiceDO.getString("salertaxno"), (String)"");
                if (result != null) {
                    return result;
                }
                IssueInvoiceMqHelper.submitInvoice2MQ((DynamicObject[])new DynamicObject[]{invoiceDO});
                return ResponseVo.success((String)ResManager.loadKDString((String)"\u63d0\u4ea4\u7ea2\u51b2\u6210\u529f", (String)"AllEQuickRedInvoiceServiceImpl_10", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
        }
        return null;
    }

    private void commitInvoice(String systemCode, DynamicObject redConfirm, AllEQuickRedRequestDTO allEQuickRedRequestDTO) {
        DynamicObject redDynamicObject = RedConfirmBillHelper.createWaitInvoice((DynamicObject)redConfirm);
        new PartRedService().warpRedInvoiceByRedConfirm(systemCode, redConfirm, allEQuickRedRequestDTO, redDynamicObject);
        ImcSaveServiceHelper.save((DynamicObject)redDynamicObject);
        IssueInvoiceMqHelper.submitInvoice2MQ((DynamicObject[])new DynamicObject[]{redDynamicObject});
    }

    private ApiResult allEQuickRedInvoiceByInvoiceNo(String systemCode, AllEQuickRedRequestDTO allEQuickRedRequestDTO, DynamicObject blueInvoiceDO, boolean isLogin, SaleInfo saleInfo) {
        String confirmStatus;
        DynamicObject redConfirm;
        log.info("\u6839\u636e\u539f\u84dd\u7968\u53f7\u7801\u5feb\u6377\u7ea2\u51b2\uff1a{}", (Object)JSON.toJSONString((Object)allEQuickRedRequestDTO));
        QFilter redConfirmFilter = new QFilter("billno", "=", (Object)allEQuickRedRequestDTO.getSerialNo()).and("org", "=", (Object)saleInfo.getOrgId());
        DynamicObject[] redConfirms = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)"", (QFilter[])redConfirmFilter.toArray());
        if (redConfirms != null && redConfirms.length > 1) {
            return ResponseVo.fail((String)ApiErrCodeEnum.REDCONFIRMBILL_BILLNO_MORE_FAIL.getCode(), (String)String.format(ApiErrCodeEnum.REDCONFIRMBILL_BILLNO_MORE_FAIL.getMsg(), allEQuickRedRequestDTO.getSerialNo()));
        }
        if (redConfirms != null && redConfirms.length == 1) {
            String redConfirmBillNo;
            redConfirm = redConfirms[0];
            redConfirm = BusinessDataServiceHelper.loadSingle((Object)redConfirm.getPkValue(), (String)"sim_red_confirm_bill");
            String totalRemark = allEQuickRedRequestDTO.getRemark();
            if (StringUtils.isNotBlank((CharSequence)totalRemark)) {
                redConfirm.set("remark", (Object)totalRemark);
            }
            PartRedService.setAddrBankInfo(redConfirm, allEQuickRedRequestDTO);
            if (StringUtils.isNotBlank((CharSequence)allEQuickRedRequestDTO.getDrawer())) {
                redConfirm.set("drawer", (Object)allEQuickRedRequestDTO.getDrawer());
            }
            if (StringUtils.isEmpty((CharSequence)(redConfirmBillNo = redConfirm.getString("billno")))) {
                redConfirm.set("billno", (Object)allEQuickRedRequestDTO.getSerialNo());
            } else if (!redConfirmBillNo.equals(allEQuickRedRequestDTO.getSerialNo())) {
                return ResponseVo.fail((String)ApiErrCodeEnum.REDCONFIRMBILL_BILLNO_FAIL.getCode(), (String)String.format(ApiErrCodeEnum.REDCONFIRMBILL_BILLNO_FAIL.getMsg(), redConfirmBillNo));
            }
        } else {
            OperationResult operationResult;
            blueInvoiceDO.set("billno", (Object)allEQuickRedRequestDTO.getSerialNo());
            String orderNo = UUID.randomUUID();
            blueInvoiceDO.set("orderno", (Object)orderNo);
            redConfirm = RedConfirmBillHelper.formatRedConfirm((String)allEQuickRedRequestDTO.getSerialNo(), (String)orderNo, (String)allEQuickRedRequestDTO.getRedReason(), (DynamicObject)blueInvoiceDO, (String)allEQuickRedRequestDTO.getAccount());
            redConfirm.set("billno", (Object)allEQuickRedRequestDTO.getSerialNo());
            redConfirm.set("systemsource", (Object)systemCode);
            if (StringUtils.isNotBlank((CharSequence)allEQuickRedRequestDTO.getRemark())) {
                redConfirm.set("remark", (Object)allEQuickRedRequestDTO.getRemark());
            }
            redConfirm.set("buyeremail", (Object)allEQuickRedRequestDTO.getBuyerRecipientMail());
            redConfirm.set("buyerphone", (Object)allEQuickRedRequestDTO.getBuyerRecipientPhone());
            PartRedService.setAddrBankInfo(redConfirm, allEQuickRedRequestDTO);
            redConfirm.set("interfacecode", (Object)OpenApiInterfaceCodeEnum.ALLE_INVOICE_RED.getCode());
            if (StringUtils.isNotBlank((CharSequence)allEQuickRedRequestDTO.getDrawer())) {
                redConfirm.set("drawer", (Object)allEQuickRedRequestDTO.getDrawer());
            }
            if (SpecialTypeEnum.PURCHASE_OF_AGRICULTURAL_PRODUCTS_02.getValue().equals(blueInvoiceDO.getString("specialtype"))) {
                redConfirm.set("applicant", (Object)RedInfoConstant.ApplicantEnum.BUYERNODEDUCTED.getCode());
            }
            if (!(operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"sim_red_confirm_bill", (DynamicObject[])new DynamicObject[]{redConfirm}, null)).isSuccess()) {
                throw new MsgException(ApiErrCodeEnum.NON_INV_CODE_NUM.getCode(), OperationConstant.getErrorMsg((OperationResult)operationResult));
            }
            if (!isLogin) {
                return ResponseVo.success((String)ResManager.loadKDString((String)"\u7535\u5b50\u7a0e\u5c40\u8d26\u53f7\u672a\u767b\u5f55\uff0c\u5df2\u4fdd\u5b58\u5f55\u5165\u72b6\u6001\u4e3a\u672a\u5f55\u5165\u7684\u7ea2\u5b57\u786e\u8ba4\u5355", (String)"AllEQuickRedInvoiceServiceImpl_20", (String)"imc-sim-webapi", (Object[])new Object[0]), (Object)"");
            }
        }
        if (!"1".equals(redConfirm.getString("uploadstatus")) || RedConfirmStatusEnum.validConfirmStatus.contains((Object)redConfirm.getString("confirmstatus"))) {
            if (StringUtils.isNotBlank((CharSequence)allEQuickRedRequestDTO.getAccount())) {
                redConfirm.set("account", (Object)allEQuickRedRequestDTO.getAccount());
            }
            ApiResult result = RedConfirmBillHelper.submit((DynamicObject)redConfirm);
            new MinusBillMatchHelper().writebackMatchBillAndSetBillComprehensive(Collections.singletonList(redConfirm));
            if (result != null) {
                log.info(String.format("\u7533\u8bf7\u7ea2\u5b57\u786e\u8ba4\u5355\u8fd4\u56de\uff1a%s", JSON.toJSONString((Object)result)));
                return result;
            }
        }
        if (StringUtils.equals((CharSequence)(confirmStatus = redConfirm.getString("confirmstatus")), (CharSequence)"01") || StringUtils.equals((CharSequence)confirmStatus, (CharSequence)RedConfirmStatusEnum.ALL_CONFIRM.getBillCode())) {
            log.info("\u751f\u6210\u7ea2\u5b57\u786e\u8ba4\u5355\uff0c\u5e76\u4e14\u7a0e\u5c40\u8fd4\u56de\u65e0\u9700\u786e\u8ba4\uff1a{}", (Object)redConfirm.getString("number"));
            this.commitInvoice(systemCode, redConfirm, allEQuickRedRequestDTO);
            return ResponseVo.success((String)ResManager.loadKDString((String)"\u63d0\u4ea4\u7ea2\u51b2\u6210\u529f", (String)"AllEQuickRedInvoiceServiceImpl_10", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        return ApiRedService.createReturnFail(redConfirm);
    }

    private SaleInfo getSaleInfo(String orgCode, String taxNo) {
        DynamicObject orgDynamicObject;
        if (StringUtils.isNotBlank((CharSequence)orgCode)) {
            orgDynamicObject = TaxUtils.getOrgDynamicObjectByOrgNumber((String)orgCode);
        } else {
            if (StringUtils.isEmpty((CharSequence)taxNo)) {
                throw new MsgException(ApiErrCodeEnum.NON_SELLER_INFO.getCode(), ResManager.loadKDString((String)"\u4f01\u4e1a\u7a0e\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"AllEQuickRedInvoiceServiceImpl_15", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            orgDynamicObject = TaxUtils.getOrgDynamicObjectByTaxNo((String)taxNo);
        }
        return TaxUtils.getSaleInfoByOrgDynamicObject((DynamicObject)orgDynamicObject);
    }
}

