/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.bill;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.EquipmentHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.helper.InvoiceCancelHelper;
import kd.imc.sim.common.vo.BillCancelVo;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.openapi.helper.BillHelper;
import kd.imc.sim.formplugin.openapi.service.OpenApiService;
import org.apache.commons.lang3.StringUtils;

public class BillCancelServiceImpl
implements OpenApiService {
    private static final Log LOG = LogFactory.getLog(BillCancelServiceImpl.class);

    @Override
    public ApiResult processer(RequestVo requestVo) {
        List<DynamicObject> invObjList;
        BillCancelVo cancelVo;
        try {
            cancelVo = (BillCancelVo)JSON.parseObject((String)requestVo.getData(), BillCancelVo.class);
        }
        catch (Exception e) {
            LOG.error("\u4f20\u5165\u53c2\u6570\u4e0d\u5408\u6cd5", (Throwable)e);
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u4f20\u5165\u4f5c\u5e9f\u4e1a\u52a1\u6570\u636e\u4e0d\u5408\u6cd5", (String)"BillCancelServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (null == cancelVo) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u4f20\u5165\u4f5c\u5e9f\u4e1a\u52a1\u6570\u636e\u4e0d\u5408\u6cd5", (String)"BillCancelServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)cancelVo.getBillNo())) {
            return ResponseVo.fail((String)"100301", (String)ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillCancelServiceImpl_1", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)cancelVo.getCanceler())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_CANCEL_NO_CANCELER.getCode(), (String)ResManager.loadKDString((String)"\u53d1\u7968\u4f5c\u5e9f\u4eba\u672a\u4f20\u5165\u503c", (String)"BillCancelServiceImpl_2", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (!GBKUtils.checkValidGbk((String)cancelVo.getCanceler())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_CANCEL_NO_CANCELER.getCode(), (String)String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4f5c\u5e9f\u4eba[%s]\u5305\u542b\u975eGBK\u7f16\u7801\u5b57\u7b26", (String)"BillCancelServiceImpl_3", (String)"imc-sim-webapi", (Object[])new Object[0]), cancelVo.getCanceler()));
        }
        if (GBKUtils.getGBKLength((String)cancelVo.getCanceler()) > 10) {
            return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_CANCEL_NO_CANCELER.getCode(), (String)String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4f5c\u5e9f\u4eba[%s]\u8d85\u8fc7\u6700\u5927\u5b57\u7b26\u957f\u5ea610\u5b57\u8282", (String)"BillCancelServiceImpl_4", (String)"imc-sim-webapi", (Object[])new Object[0]), cancelVo.getCanceler()));
        }
        if (!GBKUtils.checkValidGbk((String)cancelVo.getAbolishReason())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_CANCEL_NO_CANCELER.getCode(), (String)String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4f5c\u5e9f\u539f\u56e0[%s]\u5305\u542b\u975eGBK\u7f16\u7801\u5b57\u7b26", (String)"BillCancelServiceImpl_5", (String)"imc-sim-webapi", (Object[])new Object[0]), cancelVo.getAbolishReason()));
        }
        if (GBKUtils.getGBKLength((String)cancelVo.getAbolishReason()) > 40) {
            return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_CANCEL_NO_CANCELER.getCode(), (String)String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4f5c\u5e9f\u539f\u56e0[%s]\u8d85\u8fc7\u6700\u5927\u5b57\u7b26\u957f\u5ea620\u5b57\u7b26", (String)"BillCancelServiceImpl_6", (String)"imc-sim-webapi", (Object[])new Object[0]), cancelVo.getAbolishReason()));
        }
        try {
            invObjList = BillHelper.getInvoiceListByBillNo(cancelVo.getBillNo(), cancelVo.getOrgCode());
        }
        catch (MsgException msgException) {
            return ResponseVo.fail((String)"100401", (String)msgException.getErrorMsg());
        }
        ArrayList<DynamicObject> invoiceList = new ArrayList<DynamicObject>();
        HashSet<Long> hashSet = new HashSet<Long>();
        ImmutableSet elePaperCancelReason = ImmutableSet.of((Object)"01", (Object)"03", (Object)"04", (Object)"05");
        for (DynamicObject invoiceDynamicObject : invObjList) {
            if (!StringUtils.isBlank((CharSequence)cancelVo.getSellerTaxpayerId()) && !invoiceDynamicObject.getString("salertaxno").equals(cancelVo.getSellerTaxpayerId())) {
                return ResponseVo.fail((String)"100402", (String)ResManager.loadKDString((String)"\u9500\u65b9\u7a0e\u53f7\u548c\u5355\u636e\u4e0b\u7684\u53d1\u7968\u7a0e\u53f7\u4e0d\u4e00\u81f4", (String)"BillCancelServiceImpl_7", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            if (!InvoiceUtils.isPaperInvoice((String)invoiceDynamicObject.getString("invoicetype"))) {
                return ResponseVo.fail((String)"100404", (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\u4e0b\u7684\u53d1\u7968\u662f\u7535\u5b50\u53d1\u7968\uff0c\u65e0\u6cd5\u8fdb\u884c\u4f5c\u5e9f", (String)"BillCancelServiceImpl_8", (String)"imc-sim-webapi", (Object[])new Object[0]), cancelVo.getBillNo()));
            }
            if (!"6".equals(invoiceDynamicObject.getString("invoicestatus")) && IssueStatusEnum.ok.getCode().equals(invoiceDynamicObject.getString("issuestatus"))) {
                invoiceList.add(invoiceDynamicObject);
            }
            if (EquipmentHelper.isDisableJQBH((Object)invoiceDynamicObject.getString("salertaxno"), (Object)invoiceDynamicObject.getString("jqbh"))) {
                return ResponseVo.fail((String)"100405", (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\u4e0b\u7684\u53d1\u7968\u6240\u5173\u8054\u7684\u53d1\u7968\u7684\u8bbe\u5907\u5df2\u7ecf\u7981\u7528\uff0c\u65e0\u6cd5\u8fdb\u884c\u4f5c\u5e9f", (String)"BillCancelServiceImpl_9", (String)"imc-sim-webapi", (Object[])new Object[0]), cancelVo.getBillNo()));
            }
            if (AllEleAuthHelper.isElePaper((Object)invoiceDynamicObject.getString("iselepaper")) && !elePaperCancelReason.contains((Object)cancelVo.getAbolishReason())) {
                return ResponseVo.fail((String)"100407", (String)ResManager.loadKDString((String)"\u5355\u636e\u6240\u5f00\u53d1\u7968\u4e3a\u6570\u7535\u7eb8\u7968\uff0c\u6570\u7535\u7eb8\u7968\u4f5c\u5e9f\u65f6\uff0c\u4f5c\u5e9f\u539f\u56e0\u5fc5\u586b\uff0c\u5f00\u7968\u6709\u8bef\u3001\u670d\u52a1\u7ec8\u6b62\u3001\u9500\u8d27\u9000\u56de\u3001\u5176\u4ed6\u3002", (String)"BillCancelServiceImpl_10", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            hashSet.add(invoiceDynamicObject.getDynamicObject("orgid").getLong("id"));
        }
        if (hashSet.size() != 1 && StringUtils.isBlank((CharSequence)cancelVo.getOrgCode())) {
            return ResponseVo.fail((String)"100402", (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\u5b58\u5728\u4e0d\u540c\u7ec4\u7ec7\uff0c\u9700\u8981\u4f20\u5165orgCode", (String)"BillCancelServiceImpl_11", (String)"imc-sim-webapi", (Object[])new Object[0]), cancelVo.getBillNo()));
        }
        if (invoiceList.isEmpty()) {
            return ResponseVo.fail((String)"100303", (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\u65e0\u53ef\u4f5c\u5e9f\u7684\u53d1\u7968", (String)"BillCancelServiceImpl_12", (String)"imc-sim-webapi", (Object[])new Object[0]), cancelVo.getBillNo()));
        }
        ArrayList<DynamicObject> redInvoiceList = new ArrayList<DynamicObject>();
        for (DynamicObject invoiceDynamicObject : invoiceList) {
            if (!StringUtils.isEmpty((CharSequence)invoiceDynamicObject.getString("originalinvoicecode"))) {
                redInvoiceList.add(invoiceDynamicObject);
                continue;
            }
            if (!"3".equals(invoiceDynamicObject.getString("invoicestatus"))) continue;
            QFilter qFilter = new QFilter("originalinvoicecode", "=", (Object)invoiceDynamicObject.getString("invoicecode"));
            qFilter.and("originalinvoiceno", "=", (Object)invoiceDynamicObject.getString("invoiceno"));
            DynamicObject redObj = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])qFilter.toArray());
            redInvoiceList.add(redObj);
        }
        if (redInvoiceList.isEmpty()) {
            this.executeBatchCancelInvoice(invoiceList, cancelVo);
        } else {
            this.executeBatchCancelInvoice(redInvoiceList, cancelVo);
        }
        return ResponseVo.success((String)ResManager.loadKDString((String)"\u6279\u91cf\u4f5c\u5e9f\u63d0\u4ea4\u6210\u529f", (String)"BillCancelServiceImpl_13", (String)"imc-sim-webapi", (Object[])new Object[0]));
    }

    private void executeBatchCancelInvoice(List<DynamicObject> invoiceList, BillCancelVo cancelVo) {
        RequestContext context = RequestContext.get();
        if (!"1".equals(ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.VOLUME_INVOICE_CREATE_PDF))) {
            for (DynamicObject invoice : invoiceList) {
                invoice.set("issuestatus", (Object)IssueStatusEnum.submit.getCode());
            }
        }
        ImcSaveServiceHelper.update(invoiceList);
        ThreadPools.executeOnceIncludeRequestContext((String)"imc_executeBatchCancelInvoice", () -> {
            RequestContext.copyAndSet((RequestContext)context);
            for (DynamicObject invoice : invoiceList) {
                InvoiceCancelHelper.cancelInvoice((DynamicObject)invoice, (String)cancelVo.getCanceler(), (String)cancelVo.getAbolishReason());
            }
        });
    }
}

