/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.bill;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.openapi.FindOrderOpenVo;
import kd.imc.bdm.common.util.InvoiceQueryUtil;
import kd.imc.bdm.common.util.RegexUtil;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.openapi.check.BaseCheckService;
import kd.imc.sim.formplugin.openapi.check.VerifyResult;
import kd.imc.sim.formplugin.openapi.service.OpenApiService;
import org.apache.commons.lang3.StringUtils;

public class BillInvoiceQueryImpl
implements OpenApiService {
    private static Log logger = LogFactory.getLog(BillInvoiceQueryImpl.class);

    @Override
    public ApiResult processer(RequestVo requestVo) {
        if (null == requestVo || StringUtils.isBlank((CharSequence)requestVo.getData())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6570\u636e\u4f20\u5165\u4e3a\u7a7a", (String)"BillInvoiceQueryImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        FindOrderOpenVo vo = (FindOrderOpenVo)JSON.parseObject((String)requestVo.getData(), FindOrderOpenVo.class);
        if (vo == null) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6570\u636e\u4f20\u5165\u4e3a\u7a7a", (String)"BillInvoiceQueryImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        VerifyResult res = this.checkFindOrderOpen(vo);
        if (!res.isSucceed()) {
            return ResponseVo.fail((String)res.getCode(), (String)res.getDesc());
        }
        int nosLen = vo.getSerialNo().split(",").length;
        if (BaseCheckService.checkLength(nosLen)) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u6570\u636e\u4f20\u5165\u8d85\u8fc7\u6700\u5927\u5904\u7406\u6570\uff08%1$s\uff09\uff0c\u5f53\u524d\u4f20\u5165\u6570\uff1a%2$s", (String)"BillInvoiceQueryImpl_1", (String)"imc-sim-webapi", (Object[])new Object[0]), 50, nosLen));
        }
        Map result = InvoiceQueryUtil.queryInvoiceDataByBillNosForApi((FindOrderOpenVo)vo);
        if (CollectionUtils.isEmpty((Map)result)) {
            return ResponseVo.fail((String)ApiErrCodeEnum.FIND_ORDER_NOORG.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a", (String)"BillInvoiceQueryImpl_2", (String)"imc-sim-webapi", (Object[])new Object[0]), vo.getSerialNo()));
        }
        ArrayList invoice = new ArrayList(result.size());
        for (Map.Entry entry : result.entrySet()) {
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            map.put("billNo", entry.getKey());
            map.put("invoiceList", entry.getValue());
            invoice.add(map);
        }
        logger.info("BillInvoiceQueryImpl response {}", (Object)JSON.toJSONString(invoice));
        return ResponseVo.success((String)JSON.toJSONString(invoice));
    }

    private VerifyResult checkFindOrderOpen(FindOrderOpenVo vo) {
        if (StringUtils.isBlank((CharSequence)vo.getSellerTaxpayerId())) {
            return VerifyResult.error(ApiErrCodeEnum.BILL_PUSH_TAXPAYERID_ERROR.getCode(), ApiErrCodeEnum.BILL_PUSH_TAXPAYERID_ERROR.getMsg());
        }
        if (!RegexUtil.isNsrsbh((String)vo.getSellerTaxpayerId())) {
            return VerifyResult.error(ApiErrCodeEnum.FIND_ORDER_TAXNO.getCode(), ApiErrCodeEnum.FIND_ORDER_TAXNO.getMsg());
        }
        vo.setSellerTaxpayerId(vo.getSellerTaxpayerId().toUpperCase());
        if (StringUtils.isEmpty((CharSequence)vo.getSerialNo())) {
            return VerifyResult.error(ApiErrCodeEnum.FIND_ORDER_NO.getCode(), ApiErrCodeEnum.FIND_ORDER_NO.getMsg());
        }
        return VerifyResult.succeed();
    }
}

