/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.bill;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.serviceImpl.JobDispatcherImpl;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.dto.BillDetailVo;
import kd.imc.bdm.common.dto.BillMatch.BillMatchResultResponseVo;
import kd.imc.bdm.common.dto.BillMatch.BillMatchVo;
import kd.imc.bdm.common.dto.BillMatch.MatchBillDetailVo;
import kd.imc.bdm.common.dto.BillVo;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.InvItemConfigHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.NumberGenerateUtil;
import kd.imc.sim.common.dto.minusbill.MinusBillDTO;
import kd.imc.sim.common.dto.minusbill.MinusBillMatchConfig;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.issuing.task.MatchBillAsyncTask;
import kd.imc.sim.formplugin.match.BillMatchHelper;
import kd.imc.sim.formplugin.openapi.service.OpenApiService;
import kd.imc.sim.formplugin.openapi.service.impl.bill.BillPushServiceImpl;
import kd.imc.sim.schedule.bill.NegativeBillMatchTask;
import org.apache.commons.collections.CollectionUtils;

public class BillMatchServiceImpl
implements OpenApiService {
    @Override
    public ApiResult processer(RequestVo requestVo) {
        List billMatchVos = JSON.parseArray((String)requestVo.getData(), BillMatchVo.class);
        if (CollectionUtils.isEmpty((Collection)billMatchVos)) {
            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_EMPTY.getCode(), (String)ApiErrCodeEnum.BILL_MATCH_EMPTY.getMsg());
        }
        ArrayList minusBillDTOs = Lists.newArrayListWithCapacity((int)0);
        for (Object billMatchVo : billMatchVos) {
            QFilter buyerFilter;
            DynamicObject dynamicObject;
            DynamicObject dynamicObject2;
            long orgId;
            if (StringUtils.isEmpty((CharSequence)billMatchVo.getBillNo())) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_PULL_FORM_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillMatchServiceImpl_19", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            if (StringUtils.isEmpty((CharSequence)billMatchVo.getRedReason())) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_PULL_FORM_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u7ea2\u51b2\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillMatchServiceImpl_20", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            boolean isOrgEmpty = StringUtils.isBlank((CharSequence)billMatchVo.getOrgCode());
            boolean isSallerTaxEmpty = StringUtils.isBlank((CharSequence)billMatchVo.getSalerTaxNo());
            boolean isSallerNameEmpty = StringUtils.isBlank((CharSequence)billMatchVo.getSellerName());
            boolean isBuyerTaxEmpty = StringUtils.isBlank((CharSequence)billMatchVo.getBuyerTaxNo());
            boolean isBuyerNameEmpty = StringUtils.isBlank((CharSequence)billMatchVo.getBuyerName());
            if (isOrgEmpty && isSallerTaxEmpty && isSallerNameEmpty) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_PULL_FORM_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u53f7\u3001\u9500\u65b9\u540d\u79f0\u3001\u9500\u65b9\u7a0e\u53f7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a", (String)"BillMatchServiceImpl_1", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            DynamicObject blueInvoice = null;
            if (StringUtils.isNotEmpty((CharSequence)billMatchVo.getBlueInvoiceNo())) {
                QFilter numberFilter = new QFilter("invoiceno", "=", (Object)billMatchVo.getBlueInvoiceNo());
                if (StringUtils.isNotEmpty((CharSequence)billMatchVo.getBlueInvoiceCode())) {
                    numberFilter.and("invoicecode", "=", (Object)billMatchVo.getBlueInvoiceCode());
                }
                if ((blueInvoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "id", "invoicetype", "buyertaxno", "buyername"), (QFilter[])numberFilter.toArray())) != null) {
                    String buyerTaxNo = blueInvoice.getString("buyertaxno");
                    String invoiceType = blueInvoice.getString("invoicetype");
                    String buyerName = blueInvoice.getString("buyername");
                    if (StringUtils.isNotBlank((CharSequence)buyerTaxNo)) {
                        if (isBuyerTaxEmpty) {
                            billMatchVo.setBuyerTaxNo(buyerTaxNo);
                            isBuyerTaxEmpty = false;
                        } else if (!billMatchVo.getBuyerTaxNo().equals(buyerTaxNo)) {
                            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_PULL_FORM_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u8d2d\u65b9\u7a0e\u53f7\u4e0d\u4e00\u81f4\uff1a\u84dd\u7968\u53f7\u7801[%1$s]\u7684\u8d2d\u65b9\u7a0e\u53f7\u4e0e\u4f20\u8f93\u4e0d\u4e00\u81f4\uff0c\u8d2d\u65b9\u7a0e\u53f7\u4e3a[%2$s]\uff0c\u8bf7\u6838\u5b9e\u540e\u91cd\u65b0\u63a8\u9001\u3002", (String)"BillMatchServiceImpl_26", (String)"imc-sim-webapi", (Object[])new Object[0]), billMatchVo.getBlueInvoiceNo(), buyerTaxNo));
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)invoiceType)) {
                        if (StringUtils.isBlank((CharSequence)billMatchVo.getInvoiceType())) {
                            billMatchVo.setInvoiceType(invoiceType);
                        } else if (!billMatchVo.getInvoiceType().equals(invoiceType)) {
                            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_PULL_FORM_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u53d1\u7968\u79cd\u7c7b\u4e0d\u4e00\u81f4\uff1a\u84dd\u7968\u53f7\u7801[%1$s]\u7684\u53d1\u7968\u79cd\u7c7b\u4e0e\u4f20\u8f93\u4e0d\u4e00\u81f4\uff0c\u84dd\u7968\u79cd\u7c7b\u4e3a[%2$s]\uff0c\u8bf7\u6838\u5b9e\u540e\u91cd\u65b0\u63a8\u9001\u3002", (String)"BillMatchServiceImpl_27", (String)"imc-sim-webapi", (Object[])new Object[0]), billMatchVo.getBlueInvoiceNo(), invoiceType));
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)buyerName)) {
                        if (isBuyerNameEmpty) {
                            billMatchVo.setBuyerName(buyerName);
                            isBuyerNameEmpty = false;
                        } else if (!billMatchVo.getBuyerName().equals(buyerName)) {
                            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_PULL_FORM_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u8d2d\u65b9\u540d\u79f0\u4e0d\u4e00\u81f4\uff1a\u84dd\u7968\u53f7\u7801[%1$s]\u7684\u8d2d\u65b9\u540d\u79f0\u4e0e\u4f20\u8f93\u4e0d\u4e00\u81f4\uff0c\u8d2d\u65b9\u540d\u79f0\u4e3a[%2$s]\uff0c\u8bf7\u6838\u5b9e\u540e\u91cd\u65b0\u63a8\u9001\u3002", (String)"BillMatchServiceImpl_28", (String)"imc-sim-webapi", (Object[])new Object[0]), billMatchVo.getBlueInvoiceNo(), buyerName));
                        }
                    }
                } else {
                    return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_PULL_FORM_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u53d1\u7968\u4ee3\u7801:[%1$s],\u53f7\u7801:[%2$s],\u672a\u67e5\u8be2\u5230\u53d1\u7968", (String)"BillMatchServiceImpl_22", (String)"imc-sim-webapi", (Object[])new Object[0]), billMatchVo.getBlueInvoiceCode(), billMatchVo.getBlueInvoiceNo()));
                }
            }
            if (isBuyerNameEmpty && isBuyerTaxEmpty) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_PULL_FORM_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u8d2d\u65b9\u540d\u79f0\u3001\u8d2d\u65b9\u7a0e\u53f7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a", (String)"BillMatchServiceImpl_6", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            QFilter filter = new QFilter("number", "=", (Object)billMatchVo.getOrgCode());
            if (!isOrgEmpty) {
                DynamicObject orgObject = BusinessDataServiceHelper.loadSingle((String)"bdm_org", (String)String.join((CharSequence)",", "epinfo"), (QFilter[])filter.toArray());
                if (orgObject == null) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_PULL_FORM_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u53f7\u586b\u5199\u9519\u8bef\u6216\u672a\u5f55\u5165", (String)"BillMatchServiceImpl_2", (String)"imc-sim-webapi", (Object[])new Object[0]));
                }
                if (!isSallerTaxEmpty && !billMatchVo.getSalerTaxNo().equals(orgObject.getDynamicObject("epinfo").getString("number"))) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_PULL_FORM_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u53f7\u4e0e\u9500\u65b9\u7a0e\u53f7\u4e0d\u5339\u914d", (String)"BillMatchServiceImpl_3", (String)"imc-sim-webapi", (Object[])new Object[0]));
                }
                billMatchVo.setSalerTaxNo(orgObject.getDynamicObject("epinfo").getString("number"));
                orgId = (Long)orgObject.getPkValue();
            } else if (!isSallerTaxEmpty) {
                filter = new QFilter("number", "=", (Object)billMatchVo.getSalerTaxNo());
                dynamicObject2 = BusinessDataServiceHelper.loadSingle((String)"bdm_enterprise_baseinfo", (String)String.join((CharSequence)",", "org", "name"), (QFilter[])filter.toArray());
                if (dynamicObject2 == null) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_PULL_FORM_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u9500\u65b9\u7a0e\u53f7\u586b\u5199\u9519\u8bef", (String)"BillMatchServiceImpl_4", (String)"imc-sim-webapi", (Object[])new Object[0]));
                }
                DynamicObject[] orgObjects = BusinessDataServiceHelper.load((String)"bdm_org", (String)String.join((CharSequence)",", "epinfo"), (QFilter[])new QFilter("epinfo", "=", (Object)dynamicObject2.getLong("id")).toArray());
                if (orgObjects.length > 1) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_PULL_FORM_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6b64\u7a0e\u53f7\u5206\u914d\u7ed9\u591a\u4e2a\u7ec4\u7ec7\u4f7f\u7528\uff0c\u5fc5\u987b\u586b\u5199\u7ec4\u7ec7\u7f16\u7801", (String)"BillMatchServiceImpl_9", (String)"imc-sim-webapi", (Object[])new Object[0]));
                }
                orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)orgObjects[0]);
            } else {
                filter = new QFilter("name", "=", (Object)billMatchVo.getSellerName());
                dynamicObject2 = BusinessDataServiceHelper.loadSingle((String)"bdm_enterprise_baseinfo", (String)String.join((CharSequence)",", "org", "number"), (QFilter[])filter.toArray());
                if (dynamicObject2 == null) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_PULL_FORM_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u9500\u65b9\u540d\u79f0\u586b\u5199\u9519\u8bef", (String)"BillMatchServiceImpl_5", (String)"imc-sim-webapi", (Object[])new Object[0]));
                }
                billMatchVo.setSalerTaxNo(dynamicObject2.getString("number"));
                orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)dynamicObject2.get("org"));
            }
            if (isBuyerTaxEmpty && (dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bdm_invice_title_strate", (String)"taxno", (QFilter[])(buyerFilter = new QFilter("name", "=", (Object)billMatchVo.getBuyerName())).toArray())) != null) {
                billMatchVo.setBuyerTaxNo(dynamicObject.getString("taxno"));
            }
            if ((InvoiceUtils.isSpecialInvoice((String)billMatchVo.getInvoiceType()) || InvoiceUtils.isAllESpecialInvoice((String)billMatchVo.getInvoiceType())) && isBuyerTaxEmpty) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_PULL_FORM_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u4e13\u7968\u8d2d\u65b9\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillMatchServiceImpl_8", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            DynamicObject matchConfig = this.getMatchConfig((BillMatchVo)billMatchVo, orgId);
            if (matchConfig == null) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_PULL_FORM_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u8bf7\u5148\u521b\u5efa\u6216\u5b8c\u5584-\u8d1f\u6570\u5339\u914d\u539f\u84dd\u7968\u914d\u7f6e", (String)"BillMatchServiceImpl_7", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            String matchStandard = matchConfig.getString("matchstandard");
            if (StringUtils.isEmpty((CharSequence)matchStandard)) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_PULL_FORM_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u5339\u914d\u57fa\u51c6\u4e3a\u7a7a\uff0c\u8bf7\u5148\u5b8c\u5584-\u8d1f\u6570\u5339\u914d\u539f\u84dd\u7968\u914d\u7f6e", (String)"BillMatchServiceImpl_15", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            MinusBillMatchConfig minusBillMatchConfig = NegativeBillMatchTask.buildMatchConfigByDynamicObject((DynamicObject)matchConfig);
            HashSet detailId = Sets.newHashSetWithExpectedSize((int)0);
            for (MatchBillDetailVo item : billMatchVo.getItems()) {
                if (StringUtils.isEmpty((CharSequence)item.getDetailId())) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_PULL_FORM_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u660e\u7ec6ID\u5fc5\u4f20", (String)"BillMatchServiceImpl_16", (String)"imc-sim-webapi", (Object[])new Object[0]));
                }
                detailId.add(item.getDetailId());
                if (StringUtils.isEmpty((CharSequence)item.getGoodsCode()) && StringUtils.isEmpty((CharSequence)item.getGoodsName())) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_PULL_FORM_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u660e\u7ec6\u5546\u54c1\u540d\u79f0\u4e0e\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a", (String)"BillMatchServiceImpl_10", (String)"imc-sim-webapi", (Object[])new Object[0]));
                }
                if (StringUtils.equals((CharSequence)"2", (CharSequence)matchStandard) && StringUtils.isEmpty((CharSequence)item.getNum())) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_PULL_FORM_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6309\u6570\u91cf\u5339\u914d\u65f6\uff0c\u660e\u7ec6\u6570\u91cf\u5fc5\u586b", (String)"BillMatchServiceImpl_11", (String)"imc-sim-webapi", (Object[])new Object[0]));
                }
                if (StringUtils.equals((CharSequence)"1", (CharSequence)matchStandard) && StringUtils.isEmpty((CharSequence)item.getAmount())) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_PULL_FORM_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6309\u91d1\u989d\u5339\u914d\u65f6\uff0c\u660e\u7ec6\u91d1\u989d\u5fc5\u586b", (String)"BillMatchServiceImpl_12", (String)"imc-sim-webapi", (Object[])new Object[0]));
                }
                if ("1".equals(ImcConfigUtil.getValue((String)CacheKeyEnum.BILL_MATCH_GOODS_MAPPING_CLOSE.getConfigType(), (String)CacheKeyEnum.BILL_MATCH_GOODS_MAPPING_CLOSE.getConfigKey()))) {
                    DynamicObject[] goods;
                    if (StringUtils.isEmpty((CharSequence)item.getGoodsCode())) {
                        goods = BusinessDataServiceHelper.load((String)"bdm_goods_info", (String)String.join((CharSequence)",", "number", "name", "taxcode"), (QFilter[])new QFilter("name", "=", (Object)item.getGoodsName()).toArray());
                        if (goods.length == 0) {
                            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_PULL_FORM_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u660e\u7ec6\u5546\u54c1\u540d\u79f0\u4e0e\u5546\u54c1\u7f16\u7801\u672a\u5728\u7cfb\u7edf\u4e2d\u914d\u7f6e\uff0c\u8bf7\u8865\u5145\u5b8c\u6574", (String)"BillMatchServiceImpl_13", (String)"imc-sim-webapi", (Object[])new Object[0]));
                        }
                        if (goods.length > 1) {
                            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_PULL_FORM_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u660e\u7ec6\u4e2d\u5546\u54c1\u540d\u79f0\u5bf9\u5e94\u591a\u4e2a\u5546\u54c1\uff0c\u8bf7\u586b\u5199\u5546\u54c1\u7f16\u7801", (String)"BillMatchServiceImpl_14", (String)"imc-sim-webapi", (Object[])new Object[0]));
                        }
                        item.setGoodsCode(goods[0].getDynamicObject("taxcode").getString("mergecode"));
                        item.setSpbm(goods[0].getString("number"));
                        item.setGoodsName(this.formatGoodsName(goods[0].getString("name"), goods[0].getDynamicObject("taxcode").getString("simplename")));
                    } else {
                        goods = BusinessDataServiceHelper.load((String)"bdm_goods_info", (String)String.join((CharSequence)",", "number", "name", "taxcode"), (QFilter[])new QFilter("number", "=", (Object)item.getGoodsCode()).toArray());
                        if (goods.length == 0) {
                            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_PULL_FORM_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u660e\u7ec6\u5546\u54c1\u540d\u79f0\u4e0e\u5546\u54c1\u7f16\u7801\u672a\u5728\u7cfb\u7edf\u4e2d\u914d\u7f6e\uff0c\u8bf7\u8865\u5145\u5b8c\u6574", (String)"BillMatchServiceImpl_13", (String)"imc-sim-webapi", (Object[])new Object[0]));
                        }
                        item.setGoodsName(this.formatGoodsName(goods[0].getString("name"), goods[0].getDynamicObject("taxcode").getString("simplename")));
                        item.setSpbm(goods[0].getString("number"));
                        item.setGoodsCode(goods[0].getDynamicObject("taxcode").getString("mergecode"));
                    }
                } else {
                    this.billMatchGoodsMapping(item, orgId, billMatchVo.getFillValueRule(), billMatchVo.getPushMatchRules());
                }
                if (StringUtils.isEmpty((CharSequence)item.getGoodsCode())) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_PULL_FORM_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u660e\u7ec6ID[%s]\uff0c\u672a\u5339\u914d\u5230\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\uff0c\u8bf7\u586b\u5199", (String)"BillMatchServiceImpl_21", (String)"imc-sim-webapi", (Object[])new Object[0]), item.getDetailId()));
                }
                JSONObject itemExtJson = new JSONObject();
                this.setItemExtJsonByConfig(minusBillMatchConfig, item, itemExtJson);
                if (item.getExtJson() != null) {
                    itemExtJson.putAll((Map)item.getExtJson());
                }
                item.setItemExtJson(itemExtJson);
                if (!StringUtils.equals((CharSequence)"1", (CharSequence)matchStandard)) continue;
                if (StringUtils.isNotBlank((CharSequence)item.getAmount()) && StringUtils.isNotBlank((CharSequence)item.getTaxRate())) {
                    BigDecimal amount = BigDecimal.ZERO;
                    BigDecimal taxRate = BigDecimal.ZERO;
                    try {
                        amount = new BigDecimal(item.getAmount());
                        taxRate = new BigDecimal(item.getTaxRate());
                    }
                    catch (Exception e) {
                        return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_PULL_FORM_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u660e\u7ec6ID[%s]\uff0c\u91d1\u989d\u6216\u7a0e\u7387\u683c\u5f0f\u6709\u8bef", (String)"BillMatchServiceImpl_24", (String)"imc-sim-webapi", (Object[])new Object[0]), item.getDetailId()));
                    }
                    item.setTax(amount.multiply(taxRate).setScale(2, RoundingMode.HALF_UP).toPlainString());
                    continue;
                }
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_PULL_FORM_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u660e\u7ec6ID[%s]\uff0c\u7a0e\u7387\u5fc5\u586b", (String)"BillMatchServiceImpl_23", (String)"imc-sim-webapi", (Object[])new Object[0]), item.getDetailId()));
            }
            JSONObject headExtJson = new JSONObject();
            this.setHeadExtJsonByConfig(minusBillMatchConfig, (BillMatchVo)billMatchVo, headExtJson);
            if (billMatchVo.getExtJson() != null) {
                headExtJson.putAll((Map)billMatchVo.getExtJson());
            }
            billMatchVo.setHeadExtJson(headExtJson);
            if (detailId.size() != billMatchVo.getItems().size()) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_PULL_FORM_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u660e\u7ec6ID\u5fc5\u4f20\u4e14\u552f\u4e00", (String)"BillMatchServiceImpl_17", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            MinusBillDTO minusBillDTO = (MinusBillDTO)JSON.parseObject((String)SerializationUtils.toJsonString((Object)billMatchVo), MinusBillDTO.class);
            minusBillDTO.setOrgId(Long.valueOf(orgId));
            minusBillDTO.setConfig(minusBillMatchConfig);
            minusBillDTO.setCallbackUrl(billMatchVo.getCallbackUrl());
            if (blueInvoice != null) {
                HashSet invoiceIdSet = Sets.newHashSet();
                invoiceIdSet.add(DynamicObjectUtil.getDynamicObjectLongValue((Object)blueInvoice.getPkValue()));
                minusBillDTO.setLimitInvoiceIds((Set)invoiceIdSet);
            }
            minusBillDTOs.add(minusBillDTO);
        }
        String batchNo = NumberGenerateUtil.generateByPrefixWithRandom((String)"BM", (String)"_", (int)4);
        for (MinusBillDTO minusBillDTO : minusBillDTOs) {
            DynamicObject matchBillObject = BusinessDataServiceHelper.newDynamicObject((String)"sim_billmatch_data");
            matchBillObject.set("batchno", (Object)batchNo);
            matchBillObject.set("billno", (Object)minusBillDTO.getBillNo());
            matchBillObject.set("matchstatus", (Object)"0");
            matchBillObject.set("requestdata_tag", (Object)SerializationUtils.toJsonString((Object)minusBillDTO));
            BillMatchResultResponseVo billMatchResultResponseVo = new BillMatchResultResponseVo();
            billMatchResultResponseVo.setBillNo(minusBillDTO.getBillNo());
            billMatchResultResponseVo.setMatchStatus("0");
            matchBillObject.set("responsedata_tag", (Object)SerializationUtils.toJsonString((Object)billMatchResultResponseVo));
            matchBillObject.set("callbackretry", (Object)0);
            matchBillObject.set("callbackurl", (Object)minusBillDTO.getCallbackUrl());
            ImcSaveServiceHelper.save((DynamicObject)matchBillObject);
        }
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("sim");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName("BillMatchServiceImpl");
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname(MatchBillAsyncTask.class.getName());
        jobInfo.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        JobDispatcherImpl jobDispatcher = new JobDispatcherImpl();
        jobDispatcher.dispatch(jobInfo);
        return ResponseVo.success((String)batchNo);
    }

    private void setItemExtJsonByConfig(MinusBillMatchConfig minusBillMatchConfig, MatchBillDetailVo item, JSONObject itemExtJson) {
        for (String extraField : MatchBillDetailVo.EXTRAFIELD) {
            itemExtJson.put(extraField, MatchBillDetailVo.getPropertyValue((Object)item, (String)extraField));
        }
        for (String itemFiled : minusBillMatchConfig.getItemField().split(",")) {
            if (!StringUtils.isNotEmpty((CharSequence)itemFiled)) continue;
            itemExtJson.put(itemFiled, MatchBillDetailVo.getPropertyValue((Object)item, (String)itemFiled));
        }
    }

    private void setHeadExtJsonByConfig(MinusBillMatchConfig minusBillMatchConfig, BillMatchVo billMatchVo, JSONObject headExtJson) {
        for (String textField : BillMatchVo.TEXTFIELD) {
            headExtJson.put(textField, MatchBillDetailVo.getPropertyValue((Object)billMatchVo, (String)textField));
        }
        for (String itemFiled : minusBillMatchConfig.getHeadField().split(",")) {
            if (!StringUtils.isNotEmpty((CharSequence)itemFiled)) continue;
            headExtJson.put(itemFiled, MatchBillDetailVo.getPropertyValue((Object)billMatchVo, (String)itemFiled));
        }
    }

    private void billMatchGoodsMapping(MatchBillDetailVo item, long orgId, String fillValueRule, String pushMatchRules) {
        DynamicObject object;
        Map invItemConfig = InvItemConfigHelper.getInvItemConfig((Long)orgId);
        ArrayList bills = Lists.newArrayListWithCapacity((int)1);
        HashMap pushGoodsInfoData = Maps.newHashMapWithExpectedSize((int)1);
        HashSet<String> billNos = new HashSet<String>(1);
        this.dataSwitch(bills, item, fillValueRule, pushMatchRules);
        billNos.add("BillMatch");
        BillPushServiceImpl.goodsMapping(bills, billNos, pushGoodsInfoData, false, orgId, invItemConfig);
        BillDetailVo billDetailVo = (BillDetailVo)((BillVo)bills.get(0)).getBillDetail().get(0);
        String revenueCode = billDetailVo.getRevenueCode();
        String goodsName = billDetailVo.getGoodsName();
        if (StringUtils.isNotEmpty((CharSequence)revenueCode) && StringUtils.isNotEmpty((CharSequence)goodsName) && (object = BusinessDataServiceHelper.loadSingle((String)"er_taxclasscode", (String)"simplename", (QFilter[])new QFilter("mergecode", "=", (Object)revenueCode).toArray())) != null) {
            item.setGoodsName(this.formatGoodsName(goodsName, object.getString("simplename")));
        }
        item.setGoodsCode(billDetailVo.getRevenueCode());
        item.setSpbm(billDetailVo.getGoodsCode());
        item.setUnit(billDetailVo.getUnits());
        item.setSpecification(billDetailVo.getSpecification());
    }

    private void dataSwitch(List<BillVo> bills, MatchBillDetailVo item, String fillValueRule, String pushMatchRules) {
        BillVo billVo = new BillVo();
        BillDetailVo billDetailVo = (BillDetailVo)JSON.parseObject((String)SerializationUtils.toJsonString((Object)item), BillDetailVo.class);
        billDetailVo.setRevenueCode(item.getRevenueCode());
        billDetailVo.setUnits(item.getUnit());
        billDetailVo.setLineProperty(2);
        billVo.setFillValueRule(fillValueRule);
        billVo.setPushMatchRules(pushMatchRules);
        ArrayList billDetails = Lists.newArrayListWithCapacity((int)1);
        billDetails.add(billDetailVo);
        billVo.setBillDetail((List)billDetails);
        bills.add(billVo);
    }

    private String formatGoodsName(String name, String simpleName) {
        return "*" + simpleName + "*" + name;
    }

    private DynamicObject getMatchConfig(BillMatchVo billMatchVo, long orgId) {
        DynamicObject originalBill = DynamicObjectUtil.bean2DynamicObject((Object)billMatchVo, (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"sim_original_bill"));
        originalBill.set("orgid", (Object)orgId);
        this.setExtJsonData(billMatchVo.getExtJson(), originalBill);
        ArrayList<DynamicObject> bills = new ArrayList<DynamicObject>(1);
        bills.add(originalBill);
        Map matchMap = BillMatchHelper.getMatchOriInvSettingConfig(bills, (boolean)true);
        return (DynamicObject)matchMap.get(billMatchVo.getBillNo());
    }

    private void setExtJsonData(JSONObject extJson, DynamicObject dynamicObject) {
        DataEntityPropertyCollection properties = dynamicObject.getDataEntityType().getProperties();
        if (extJson != null && !extJson.isEmpty()) {
            for (String key : extJson.keySet()) {
                if (!DynamicObjectUtil.checkDynamicObjectHasField((DynamicObject)dynamicObject, (String)key)) continue;
                IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)key);
                if (property instanceof DecimalProp) {
                    dynamicObject.set(key, (Object)extJson.getBigDecimal(key));
                    continue;
                }
                if (property instanceof DateTimeProp) {
                    dynamicObject.set(key, extJson.getTimestamp(key));
                    continue;
                }
                dynamicObject.set(key, extJson.get((Object)key));
            }
        }
    }
}

