/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.bill;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.dto.BillPreviewVo;
import kd.imc.bdm.common.dto.allelespecial.BillEstateSaleItemVo;
import kd.imc.bdm.common.dto.merge.MergeRequestDTO;
import kd.imc.bdm.common.dto.merge.MergeResponseDTO;
import kd.imc.bdm.common.dto.split.SplitRequestDTO;
import kd.imc.bdm.common.dto.split.SplitResponseDTO;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.OrgHelper;
import kd.imc.bdm.common.util.ConvertUpMoneyUtils;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.file.fpy.model.pdf.fedi.FullDigitalEInvoice;
import kd.imc.sim.common.billpreview.BillPreviewData;
import kd.imc.sim.common.helper.allele.AllEleInvoiceFileHelper;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.bill.splitMerge.helper.BillMergeHelper;
import kd.imc.sim.formplugin.bill.splitMerge.helper.BillSplitHelper;
import kd.imc.sim.formplugin.openapi.service.OpenApiService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.RandomStringUtils;

public class BillPreviewServiceImpl
implements OpenApiService {
    @Override
    public ApiResult processer(RequestVo requestVo) {
        BillPreviewVo billPreviewVo = (BillPreviewVo)JSON.parseObject((String)requestVo.getData(), BillPreviewVo.class);
        ApiResult apiResult = this.checkBillPreview(billPreviewVo);
        if (apiResult != null) {
            return apiResult;
        }
        Long orgId = OrgHelper.getOrgIdByOrgCode((String)billPreviewVo.getOrgCode());
        if (orgId == null) {
            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_NO_DATA.getCode(), (String)ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\u586b\u5199\u9519\u8bef", (String)"BillPreviewServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        QFilter qFilter = new QFilter("orgid", "=", (Object)orgId);
        ArrayList bills = Lists.newArrayListWithCapacity((int)0);
        for (String billNo : billPreviewVo.getBillNo()) {
            QFilter filter = new QFilter("billno", "=", (Object)billNo);
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"sim_original_bill", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_original_bill", (boolean)true), (QFilter[])filter.and(qFilter).toArray());
            if (dynamicObject == null) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_NO_DATA.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7:[%s]\u586b\u5199\u6709\u8bef", (String)"BillPreviewServiceImpl_1", (String)"imc-sim-webapi", (Object[])new Object[0]), billNo));
            }
            if ("2".equals(dynamicObject.getString("confirmstate")) || !"0".equals(dynamicObject.getString("validstate")) || dynamicObject.getBigDecimal("surplusamount").compareTo(BigDecimal.ZERO) == 0) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_NO_DATA.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7:[%s]\u5df2\u7533\u8bf7\u6216\u5df2\u5f00\u7968", (String)"BillPreviewServiceImpl_2", (String)"imc-sim-webapi", (Object[])new Object[0]), billNo));
            }
            dynamicObject.set("orgId", (Object)dynamicObject.getDynamicObject("orgId").getLong("id"));
            bills.add(dynamicObject);
        }
        return this.billPreviewDataHandle(bills, billPreviewVo);
    }

    private ApiResult billPreviewDataHandle(List<DynamicObject> bills, BillPreviewVo billPreviewVo) {
        if (CollectionUtils.isNotEmpty(bills)) {
            ArrayList invoices = Lists.newArrayList();
            for (DynamicObject bill : bills) {
                DynamicObject mergeRule = bill.getDynamicObject("mergerule");
                String splitRule = bill.getString("splitrule");
                DynamicObject mergeRuleDynamic = null;
                if (mergeRule != null) {
                    mergeRuleDynamic = BusinessDataServiceHelper.loadSingle((String)"bdm_merge_rule_strategy", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_merge_rule_strategy", (boolean)true), (QFilter[])new QFilter("id", "=", mergeRule.getPkValue()).toArray());
                }
                DynamicObject splitRuleDynamic = BusinessDataServiceHelper.loadSingle((String)"bdm_inv_split_rule_strate", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_inv_split_rule_strate", (boolean)true), (QFilter[])new QFilter("number", "=", (Object)splitRule).toArray());
                bill.set("mergerule", (Object)mergeRuleDynamic);
                MergeRequestDTO request = new MergeRequestDTO.Builder().bills(new DynamicObject[]{bill}).mergeBill(false).mergeBillDetail(StringUtils.isNotEmpty((CharSequence)billPreviewVo.getIsAutoMergeDetail()) && billPreviewVo.getIsAutoMergeDetail().equalsIgnoreCase("Y")).setJqbh(bill.getString("jqbh")).build();
                try {
                    MergeResponseDTO mergeResponseDTO = new BillMergeHelper().mergeBill(request);
                    SplitRequestDTO splitRequest = new SplitRequestDTO();
                    for (DynamicObject mergeBill : mergeResponseDTO.getBills()) {
                        splitRequest.setBill(mergeBill);
                        splitRequest.setRuleObj(splitRuleDynamic);
                        splitRequest.setBillNoMap(mergeResponseDTO.getBillNoMap());
                        SplitResponseDTO splitResponseDTO = BillSplitHelper.splitBill((SplitRequestDTO)splitRequest, (String)mergeBill.getString("jqbh"));
                        invoices.addAll(splitResponseDTO.getInvoices());
                    }
                }
                catch (Exception e) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PREVIEW_CREATEURL_FAIL.getCode(), (String)e.getMessage());
                }
            }
            for (DynamicObject invoice : invoices) {
                if (!InvoiceUtils.isAllEInvoice((Object)invoice.getString("invoicetype"))) continue;
                FullDigitalEInvoice eInvoice = AllEleInvoiceFileHelper.createFullDigitalEInvoice((DynamicObject)invoice);
                invoice.set("remark", (Object)eInvoice.getRemark());
            }
            List datas = JSON.parseArray((String)SerializationUtils.toJsonString((Object)invoices), BillPreviewData.class);
            for (int i = 0; i < datas.size(); ++i) {
                if (!"E05".equalsIgnoreCase(((DynamicObject)invoices.get(i)).getString("specialtype")) && !"E06".equalsIgnoreCase(((DynamicObject)invoices.get(i)).getString("specialtype"))) continue;
                for (int j = 0; j < ((BillPreviewData)datas.get(i)).getEstatesales().size(); ++j) {
                    ((BillEstateSaleItemVo)((BillPreviewData)datas.get(i)).getEstatesales().get(j)).setAreaunit(((DynamicObject)((DynamicObject)invoices.get(i)).getDynamicObjectCollection("estatesales").get(j)).getString("saleunit"));
                    ((BillEstateSaleItemVo)((BillPreviewData)datas.get(i)).getEstatesales().get(j)).setEstateId(((DynamicObject)((DynamicObject)invoices.get(i)).getDynamicObjectCollection("estatesales").get(j)).getString("saleestateid"));
                }
            }
            TreeSet<String> billNos = new TreeSet<String>();
            for (BillPreviewData data : datas) {
                data.setCrosscitysign(BillPreviewData.crossCityFormat((String)data.getCrosscitysign()));
                data.setTotalamountbig(ConvertUpMoneyUtils.toChinese((String)String.valueOf(data.getTotalamount())));
                data.setBillproperties(data.getTotalamount().compareTo(BigDecimal.ZERO) < 0 ? -1 : 1);
                if ("E03".equalsIgnoreCase(data.getSpecialtype())) {
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bdm_admindivision", (String)"name", (QFilter[])new QFilter("id", "=", (Object)JSON.parseObject((String)data.getSimpleaddress()).getLong("id")).toArray());
                    if (dynamicObject != null) {
                        data.setSimpleaddress(dynamicObject.getString("name"));
                    }
                    data.setAddress(BillPreviewData.addressFormat((String)data.getSimpleaddress(), (String)data.getDetailaddress()));
                }
                for (BillPreviewData.items item : data.getItems()) {
                    item.setTaxrate(BillPreviewData.taxRateFormat((String)item.getTaxrate()));
                }
                billNos.add(data.getBatchbelong());
            }
            boolean needPassword = true;
            if (billPreviewVo.getNeedPassword() != null && "N".equalsIgnoreCase(billPreviewVo.getNeedPassword())) {
                needPassword = false;
            }
            String url = RequestContext.getOrCreate().getClientFullContextPath() + "?formId=sim_invoicing_preview&userId=Guest&key=";
            String originBillSeq = "";
            String urlCode = "";
            if (needPassword) {
                urlCode = RandomStringUtils.random((int)6, (boolean)true, (boolean)true);
            }
            for (String billNo : billNos) {
                int InvoiceIndex = 0;
                ArrayList<BillPreviewData> list = new ArrayList<BillPreviewData>();
                for (BillPreviewData billPreviewData : datas) {
                    if (!billNo.equals(billPreviewData.getBatchbelong())) continue;
                    billPreviewData.setBillSeq(InvoiceIndex);
                    list.add(billPreviewData);
                    ++InvoiceIndex;
                }
                BigDecimal amount = BigDecimal.ZERO;
                BigDecimal totalTax = BigDecimal.ZERO;
                BigDecimal totalAmount = BigDecimal.ZERO;
                for (BillPreviewData billPreviewData : list) {
                    amount = amount.add(billPreviewData.getInvoiceamount());
                    totalTax = totalTax.add(billPreviewData.getTotaltax());
                    totalAmount = totalAmount.add(billPreviewData.getTotalamount());
                }
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"sim_invoice_preview_data");
                dynamicObject.set("createtime", (Object)new Date());
                if (StringUtils.isBlank((CharSequence)billPreviewVo.getSaveDate())) {
                    dynamicObject.set("expiretime", (Object)DateUtils.addDay((Date)new Date(), (int)1));
                } else {
                    dynamicObject.set("expiretime", (Object)DateUtils.addDay((Date)new Date(), (int)Integer.parseInt(billPreviewVo.getSaveDate())));
                }
                dynamicObject.set("jsonstring_tag", (Object)SerializationUtils.toJsonString(list));
                dynamicObject.set("amount", (Object)amount);
                dynamicObject.set("totalamount", (Object)totalAmount);
                dynamicObject.set("totaltax", (Object)totalTax);
                dynamicObject.set("billno", (Object)billNo);
                dynamicObject.set("password", (Object)urlCode);
                ImcSaveServiceHelper.save((DynamicObject)dynamicObject);
                if (originBillSeq.isEmpty()) {
                    originBillSeq = dynamicObject.getString("id");
                }
                dynamicObject.set("originbillseq", (Object)originBillSeq);
                ImcSaveServiceHelper.save((DynamicObject)dynamicObject);
            }
            if (originBillSeq.isEmpty()) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PREVIEW_CREATEURL_FAIL.getCode(), (String)ApiErrCodeEnum.BILL_PREVIEW_CREATEURL_FAIL.getMsg());
            }
            url = url + originBillSeq;
            HashMap returnData = Maps.newHashMapWithExpectedSize((int)0);
            returnData.put("previewUrl", url);
            if (needPassword) {
                returnData.put("password", urlCode);
                return ResponseVo.success((String)ResManager.loadKDString((String)"\u94fe\u63a5\u751f\u6210\u6210\u529f", (String)"BillPreviewServiceImpl_5", (String)"imc-sim-webapi", (Object[])new Object[0]), (Object)SerializationUtils.toJsonString((Object)returnData));
            }
            return ResponseVo.success((String)ResManager.loadKDString((String)"\u94fe\u63a5\u751f\u6210\u6210\u529f", (String)"BillPreviewServiceImpl_5", (String)"imc-sim-webapi", (Object[])new Object[0]), (Object)SerializationUtils.toJsonString((Object)returnData));
        }
        return ResponseVo.fail((String)"-10001", (String)"PreviewMap is Empty");
    }

    private ApiResult checkBillPreview(BillPreviewVo billPreviewVo) {
        if (billPreviewVo.getBillNo().size() == 0) {
            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_NO_DATA.getCode(), (String)ResManager.loadKDString((String)"\u5355\u636e\u53f7\u4e3a\u7a7a", (String)"BillPreviewServiceImpl_3", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)billPreviewVo.getOrgCode())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_NO_DATA.getCode(), (String)ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillPreviewServiceImpl_4", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)billPreviewVo.getNeedPassword()) && (billPreviewVo.getNeedPassword().length() != 1 || !"YyNn".contains(billPreviewVo.getNeedPassword()))) {
            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PREVIEW_NEED_PASSWORD_ENTER_WRONG.getCode(), (String)ApiErrCodeEnum.BILL_PREVIEW_NEED_PASSWORD_ENTER_WRONG.getMsg());
        }
        try {
            if (StringUtils.isNotBlank((CharSequence)billPreviewVo.getSaveDate()) && (Integer.parseInt(billPreviewVo.getSaveDate()) > 90 || Integer.parseInt(billPreviewVo.getSaveDate()) < 1)) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PREVIEW_SAVETIME_LIMIT.getCode(), (String)ApiErrCodeEnum.BILL_PREVIEW_SAVETIME_LIMIT.getMsg());
            }
        }
        catch (Exception e) {
            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PREVIEW_SAVETIME_LIMIT.getCode(), (String)ApiErrCodeEnum.BILL_PREVIEW_SAVETIME_LIMIT.getMsg());
        }
        return null;
    }
}

