/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.bill;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.constant.BillCenterLogEnum;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.openapi.service.OpenApiService;
import org.apache.commons.lang3.StringUtils;

public class BillQueryRejectImpl
implements OpenApiService {
    private static final Log LOG = LogFactory.getLog(BillQueryRejectImpl.class);

    @Override
    public ApiResult processer(RequestVo requestVo) {
        String selectProperties;
        DynamicObject[] billLogArray;
        if (null == requestVo || StringUtils.isBlank((CharSequence)requestVo.getData())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6570\u636e\u4f20\u5165\u4e3a\u7a7a", (String)"BillCreateServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        JSONObject paramObject = JSONObject.parseObject((String)requestVo.getData());
        LOG.info("\u67e5\u8be2\u9a73\u56de\u8bb0\u5f55\u7684\u8bf7\u6c42\u53c2\u6570:{}", (Object)paramObject);
        String wxid = paramObject.getString("wxid");
        String pkId = paramObject.getString("id");
        if (StringUtils.isEmpty((CharSequence)wxid) && StringUtils.isEmpty((CharSequence)pkId)) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a", (String)"BillCreateServiceImpl_14", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        List<String> opTypeList = this.getOpTypeCondition();
        QFilter qFilter = new QFilter("operate_type", "in", opTypeList);
        if (StringUtils.isNotBlank((CharSequence)wxid)) {
            qFilter = qFilter.and("billno", "like", (Object)(wxid + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)pkId)) {
            qFilter = qFilter.and("id", "=", (Object)Long.valueOf(pkId));
        }
        if ((billLogArray = BusinessDataServiceHelper.load((String)"sim_bill_log", (String)(selectProperties = PropertieUtil.getAllPropertiesSplitByComma((String)"sim_bill_log", (boolean)true)), (QFilter[])qFilter.toArray())) == null || billLogArray.length == 0) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u9a73\u56de\u7684\u8bb0\u5f55\u6570\u636e\u4e0d\u5b58\u5728", (String)"BillCreateServiceImpl_15", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        ArrayList resultMap = new ArrayList(billLogArray.length);
        for (DynamicObject dynamicObject : billLogArray) {
            Long logId = dynamicObject.getLong("id");
            String opType = dynamicObject.getString("operate_type");
            String inner_param_tag = dynamicObject.getString("inner_param_tag");
            if (!StringUtils.isNotBlank((CharSequence)inner_param_tag)) continue;
            JSONObject jsonObject = JSONObject.parseObject((String)inner_param_tag);
            HashMap<String, Object> elementMap = new HashMap<String, Object>(8);
            elementMap.put("id", String.valueOf(logId));
            elementMap.put("opType", opType);
            for (String key : jsonObject.keySet()) {
                elementMap.put(key, jsonObject.get((Object)key));
            }
            resultMap.add(elementMap);
        }
        LOG.info("BillQueryRejectImpl, resultMap\u5927\u5c0f:{}", (Object)resultMap.size());
        return ResponseVo.success((String)"success", resultMap);
    }

    private List<String> getOpTypeCondition() {
        String rejectOpType = BillCenterLogEnum.APPROVAL_RESULT_OP_TYPE.getBillStatus();
        String processOpType = BillCenterLogEnum.PROCESS_RESULT_OP_TYPE.getBillStatus();
        ArrayList<String> opTypeList = new ArrayList<String>(2);
        opTypeList.add(rejectOpType);
        opTypeList.add(processOpType);
        return opTypeList;
    }
}

