/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.bill;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.InvoiceStatus;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.constant.table.RedReasonEnum;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.EquipmentHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.sim.common.helper.issueinvoice.IssueInvoiceMqHelper;
import kd.imc.sim.common.vo.BillQuickRedVo;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.issuing.util.RedInvoiceUtil;
import kd.imc.sim.formplugin.openapi.helper.BillHelper;
import kd.imc.sim.formplugin.openapi.service.OpenApiService;
import org.apache.commons.lang3.StringUtils;

public class BillQuickRedServiceImpl
implements OpenApiService {
    private static final Log LOG = LogFactory.getLog(BillQuickRedServiceImpl.class);

    @Override
    public ApiResult processer(RequestVo requestVo) {
        List<DynamicObject> invObjList;
        BillQuickRedVo billQuickRedVo;
        try {
            billQuickRedVo = (BillQuickRedVo)JSON.parseObject((String)requestVo.getData(), BillQuickRedVo.class);
        }
        catch (Exception e) {
            LOG.error("\u4f20\u5165\u53c2\u6570\u4e0d\u5408\u6cd5", (Throwable)e);
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u4f20\u5165\u4e1a\u52a1\u6570\u636e\u4e0d\u5408\u6cd5", (String)"BillQuickRedServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)billQuickRedVo.getBillNo())) {
            return ResponseVo.fail((String)"100301", (String)ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillQuickRedServiceImpl_1", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        try {
            invObjList = BillHelper.getInvoiceListByBillNo(billQuickRedVo.getBillNo(), billQuickRedVo.getOrgCode());
        }
        catch (MsgException msgException) {
            return ResponseVo.fail((String)"100401", (String)msgException.getErrorMsg());
        }
        ArrayList<DynamicObject> redList = new ArrayList<DynamicObject>();
        HashSet<Long> hashSet = new HashSet<Long>();
        for (DynamicObject invoiceDynamicObject : invObjList) {
            String invoiceType = invoiceDynamicObject.getString("invoicetype");
            if (InvoiceUtils.isSpecialInvoice((String)invoiceType) || InvoiceUtils.isAllEInvoice((Object)invoiceType)) {
                return ResponseVo.fail((String)"100401", (String)ResManager.loadKDString((String)"\u5355\u636e\u5feb\u901f\u7ea2\u51b2\u4ec5\u652f\u6301\u7a0e\u63a7\u666e\u901a\u53d1\u7968", (String)"BillQuickRedServiceImpl_2", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            if (AllEleAuthHelper.isElePaper((Object)invoiceDynamicObject.getString("iselepaper"))) {
                return ResponseVo.fail((String)"100406", (String)ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u5feb\u901f\u7ea2\u51b2\u6570\u7535\u7eb8\u7968", (String)"BillQuickRedServiceImpl_3", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            if (InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode().equals(invoiceDynamicObject.getString("invoicetype"))) {
                return ResponseVo.fail((String)"100401", (String)ResManager.loadKDString((String)"\u5feb\u901f\u7ea2\u51b2\u4e13\u7528\u53d1\u7968\uff0c\u9700\u8981\u6307\u5b9a\u539f\u84dd\u7968\u4ee3\u7801\u53f7\u7801\u5e76\u586b\u5199\u7ea2\u5b57\u4fe1\u606f\u8868\u7f16\u53f7\uff0c\u8bf7\u4f7f\u7528\u53d1\u7968\u5feb\u901f\u7ea2\u51b2\u63a5\u53e3", (String)"BillQuickRedServiceImpl_4", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            if (!StringUtils.isBlank((CharSequence)billQuickRedVo.getSellerTaxpayerId()) && !invoiceDynamicObject.getString("salertaxno").equals(billQuickRedVo.getSellerTaxpayerId())) {
                return ResponseVo.fail((String)"100402", (String)ResManager.loadKDString((String)"\u9500\u65b9\u7a0e\u53f7\u548c\u5355\u636e\u4e0b\u7684\u53d1\u7968\u7a0e\u53f7\u4e0d\u4e00\u81f4", (String)"BillQuickRedServiceImpl_5", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            if (IssueType.RED_INVOICE.getTypeCode().equals(invoiceDynamicObject.getString("issuetype"))) {
                return ResponseVo.fail((String)"100404", (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\u4e0b\u7684\u53d1\u7968\u662f\u7ea2\u7968\uff0c\u65e0\u6cd5\u8fdb\u884c\u7ea2\u51b2", (String)"BillQuickRedServiceImpl_6", (String)"imc-sim-webapi", (Object[])new Object[0]), billQuickRedVo.getBillNo()));
            }
            String jqbh = invoiceDynamicObject.getString("jqbh");
            String sellerTaxNo = invoiceDynamicObject.getString("salertaxno");
            if (EquipmentHelper.isDisableJQBH((Object)sellerTaxNo, (Object)jqbh)) {
                return ResponseVo.fail((String)"100405", (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\u4e0b\u7684\u53d1\u7968\u6240\u5173\u8054\u7684\u53d1\u7968\u7684\u8bbe\u5907\u5df2\u7ecf\u7981\u7528\uff0c\u65e0\u6cd5\u8fdb\u884c\u7ea2\u51b2", (String)"BillQuickRedServiceImpl_7", (String)"imc-sim-webapi", (Object[])new Object[0]), billQuickRedVo.getBillNo()));
            }
            this.putRedInvoiceData(billQuickRedVo, redList, hashSet, invoiceDynamicObject);
        }
        if (hashSet.size() > 1 && StringUtils.isBlank((CharSequence)billQuickRedVo.getOrgCode())) {
            return ResponseVo.fail((String)"100402", (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\u5b58\u5728\u4e0d\u540c\u7ec4\u7ec7\uff0c\u9700\u8981\u4f20\u5165orgCode", (String)"BillQuickRedServiceImpl_8", (String)"imc-sim-webapi", (Object[])new Object[0]), billQuickRedVo.getBillNo()));
        }
        if (redList.isEmpty()) {
            return ResponseVo.fail((String)"100303", (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\u65e0\u53ef\u7ea2\u51b2\u7684\u53d1\u7968", (String)"BillQuickRedServiceImpl_9", (String)"imc-sim-webapi", (Object[])new Object[0]), billQuickRedVo.getBillNo()));
        }
        try (TXHandle h1 = TX.required();){
            try {
                ImcSaveServiceHelper.save(redList);
            }
            catch (Exception e) {
                h1.markRollback();
                LOG.error("\u5355\u636e\u5feb\u901f\u7ea2\u51b2 \u4fdd\u5b58\u5f85\u5f00\u5f02\u5e38", (Throwable)e);
                ApiResult apiResult = ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)e.getMessage());
                if (h1 != null) {
                    if (var7_10 != null) {
                        try {
                            h1.close();
                        }
                        catch (Throwable throwable) {
                            var7_10.addSuppressed(throwable);
                        }
                    } else {
                        h1.close();
                    }
                }
                return apiResult;
            }
        }
        try {
            LOG.info("\u5355\u636e\u5feb\u901f\u7ea2\u51b2\uff0cwaitInvoiceList " + redList.size());
            IssueInvoiceMqHelper.submitInvoice2MQ((DynamicObject[])redList.toArray(new DynamicObject[0]));
        }
        catch (Exception e) {
            LOG.error("\u5355\u636e\u5feb\u901f\u7ea2\u51b2\uff0c\u63a8\u5165mq\u5f02\u5e38", (Throwable)e);
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)e.getMessage());
        }
        return ResponseVo.success((String)ResManager.loadKDString((String)"\u5355\u636e\u6279\u91cf\u7ea2\u51b2\u63d0\u4ea4\u6210\u529f", (String)"BillQuickRedServiceImpl_10", (String)"imc-sim-webapi", (Object[])new Object[0]));
    }

    private void putRedInvoiceData(BillQuickRedVo billQuickRedVo, List<DynamicObject> redList, HashSet<Long> hashSet, DynamicObject invoiceDynamicObject) {
        if (InvoiceStatus.isNormalInvIncludePartRed((String)invoiceDynamicObject.getString("invoicestatus")) && StringUtils.isEmpty((CharSequence)invoiceDynamicObject.getString("originalinvoicecode")) && IssueStatusEnum.ok.getCode().equals(invoiceDynamicObject.getString("invoicestatus"))) {
            DynamicObject redDynamicObject = RedInvoiceUtil.blueInvoiceConvertToRed((DynamicObject)invoiceDynamicObject);
            if (!IssueStatusEnum.none.getCode().equals(redDynamicObject.getString("issuestatus"))) {
                return;
            }
            if (StringUtils.isEmpty((CharSequence)billQuickRedVo.getRedReason()) || !RedReasonEnum.getAllTypeCode().contains(billQuickRedVo.getRedReason())) {
                redDynamicObject.set("redreason", (Object)"2");
            } else {
                redDynamicObject.set("redreason", (Object)billQuickRedVo.getRedReason());
            }
            if (!StringUtils.isBlank((CharSequence)billQuickRedVo.getDrawer())) {
                redDynamicObject.set("drawer", (Object)billQuickRedVo.getDrawer());
            }
            redDynamicObject.set("issuestatus", (Object)IssueStatusEnum.submit.getCode());
            redList.add(redDynamicObject);
        }
        hashSet.add(DynamicObjectUtil.getDynamicObjectLongValue((Object)invoiceDynamicObject.get("orgid")));
    }
}

