/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.common;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.helper.EquipmentHelper;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.RegexUtil;
import kd.imc.sim.common.vo.openapi.FindEquipmentVo;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.openapi.check.VerifyResult;
import kd.imc.sim.formplugin.openapi.service.OpenApiService;

public class FindEquipmentServiceImpl
implements OpenApiService {
    @Override
    public ApiResult processer(RequestVo requestVo) {
        if (null == requestVo) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6570\u636e\u4f20\u5165\u4e3a\u7a7a", (String)"FindEquipmentServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        FindEquipmentVo eqInfo = null;
        if (StringUtils.isNotEmpty((String)requestVo.getData())) {
            eqInfo = (FindEquipmentVo)JSON.parseObject((String)requestVo.getData(), FindEquipmentVo.class);
        }
        if (eqInfo == null) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6570\u636e\u4f20\u5165\u4e3a\u7a7a", (String)"FindEquipmentServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        VerifyResult res = this.checkFindEqInfo(eqInfo);
        if (!res.isSucceed()) {
            return ResponseVo.fail((String)res.getCode(), (String)res.getDesc());
        }
        List<Long> devList = null;
        if (StringUtils.isNotEmpty((String)eqInfo.getOrgCode()) && null == (devList = this.findByOrg(eqInfo.getSellerTaxpayerId(), eqInfo.getOrgCode()))) {
            return ResponseVo.fail((String)ApiErrCodeEnum.FIND_EQINFO_NOTFINDORG.getCode(), (String)ApiErrCodeEnum.FIND_EQINFO_NOTFINDORG.getMsg());
        }
        List<Map<String, Object>> eqList = this.findEqInfo(devList, eqInfo.getSellerTaxpayerId());
        if (eqList.size() <= 0) {
            return ResponseVo.fail((String)ApiErrCodeEnum.FIND_EQINFO_NOTFINDEQ.getCode(), (String)ApiErrCodeEnum.FIND_EQINFO_NOTFINDEQ.getMsg());
        }
        return ResponseVo.success((String)JSON.toJSONString(eqList));
    }

    private VerifyResult checkFindEqInfo(FindEquipmentVo vo) {
        if (!RegexUtil.isNsrsbh((String)vo.getSellerTaxpayerId())) {
            return VerifyResult.error(ApiErrCodeEnum.FIND_EQINFO_TAXNO.getCode(), ApiErrCodeEnum.FIND_EQINFO_TAXNO.getMsg());
        }
        vo.setSellerTaxpayerId(vo.getSellerTaxpayerId().toUpperCase());
        return VerifyResult.succeed();
    }

    private List<Long> findByOrg(String taxno, String orgNo) {
        QFilter filter = new QFilter("epinfo.number", "=", (Object)taxno);
        filter.and("number", "=", (Object)orgNo);
        DynamicObject org = QueryServiceHelper.queryOne((String)"bdm_org", (String)"devlist_tag", (QFilter[])filter.toArray());
        if (null == org) {
            return null;
        }
        String devs = org.get("devlist_tag") + "";
        if (StringUtils.isNotEmpty((String)devs)) {
            return Arrays.stream(devs.split(",")).map(Long::new).collect(Collectors.toList());
        }
        return null;
    }

    private List<Map<String, Object>> findEqInfo(List<Long> devList, String taxNo) {
        QFilter filter = null;
        filter = devList != null && devList.size() > 0 ? new QFilter("id", "in", (Object)devList.toArray()) : new QFilter("taxno", "=", (Object)taxNo);
        filter.and("authstatus", "=", (Object)"1").and(EquipmentHelper.getEnableFilter());
        DynamicObject[] eqInfos = BusinessDataServiceHelper.load((String)"bdm_tax_equipment", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_tax_equipment", (boolean)true), (QFilter[])filter.toArray());
        if (eqInfos.length <= 0) {
            return new ArrayList<Map<String, Object>>(1);
        }
        ArrayList<Map<String, Object>> res = new ArrayList<Map<String, Object>>(eqInfos.length);
        for (DynamicObject eqInfo : eqInfos) {
            HashMap<String, Object> map = new HashMap<String, Object>(4);
            map.put("deviceNo", eqInfo.get("equipmentno") + "");
            map.put("deviceType", eqInfo.get("equipmenttype") + "");
            ArrayList<HashMap<String, Object>> terminalList = new ArrayList<HashMap<String, Object>>(6);
            DynamicObjectCollection bdm_terminal = eqInfo.getDynamicObjectCollection("bdm_terminal");
            if ("3".equals(map.get("deviceType") + "")) {
                for (DynamicObject obj : bdm_terminal) {
                    HashMap<String, Object> invoice = new HashMap<String, Object>(4);
                    invoice.put("terminalNo", obj.get("terminalcode"));
                    invoice.put("invoiceType", obj.get("invoicetype"));
                    this.setQuota(invoice, eqInfo, invoice.get("invoiceType") + "");
                    terminalList.add(invoice);
                }
            } else {
                String[] invoices;
                String invoiceTypes = eqInfo.get("invoicetypes") + "";
                for (String s : invoices = invoiceTypes.split(",")) {
                    HashMap<String, Object> invoice = new HashMap<String, Object>(4);
                    invoice.put("terminalNo", "");
                    invoice.put("invoiceType", s);
                    this.setQuota(invoice, eqInfo, s);
                    terminalList.add(invoice);
                }
            }
            map.put("terminalList", terminalList);
            res.add(map);
        }
        return res;
    }

    private void setQuota(Map<String, Object> map, DynamicObject obj, String invoiceType) {
        switch (invoiceType) {
            case "004": {
                map.put("quota", obj.get("paperzticketquota") + "");
                break;
            }
            case "007": {
                map.put("quota", obj.get("paperpticketquota") + "");
                break;
            }
            case "028": {
                map.put("quota", obj.get("electzticketquota") + "");
                break;
            }
            case "026": {
                map.put("quota", obj.get("electpticketquota") + "");
                break;
            }
            case "025": {
                map.put("quota", obj.get("ticketquota") + "");
                break;
            }
            case "005": {
                map.put("quota", obj.get("motorticketquota") + "");
                break;
            }
        }
    }
}

