/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.util.RegexUtil;
import kd.imc.sim.common.vo.openapi.InvoiceStockQueryVo;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.formplugin.openapi.service.OpenApiService;
import org.apache.commons.lang3.StringUtils;

public class InvoiceStockQueryImpl
implements OpenApiService {
    private static Log logger = LogFactory.getLog(InvoiceStockQueryImpl.class);

    @Override
    public ApiResult processer(RequestVo requestVo) {
        String data = requestVo.getData();
        if (StringUtils.isBlank((CharSequence)data)) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceStockQueryImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]), (String)ApiErrCodeEnum.INV_STOCK_ILLEGAL_PARAM.getCode());
        }
        InvoiceStockQueryVo queryVo = (InvoiceStockQueryVo)JSON.parseObject((String)data, InvoiceStockQueryVo.class);
        Map<String, String> rMap = InvoiceStockQueryImpl.checkParam(queryVo);
        if (!"0".equals(rMap.get("code"))) {
            return ApiResult.fail((String)rMap.get("msg"), (String)rMap.get("code"));
        }
        logger.info("InvoiceStockQuery: " + data);
        QFilter qFilter = new QFilter("taxno", "=", (Object)queryVo.getTaxNo());
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bdm_stock_manage", (String)"einvoicestock,especialinvoicestock,invoicestock,specialinvoicestock,equipmenttype,taxno", (QFilter[])qFilter.toArray());
        if (dynamicObject == null) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u8bbe\u5907\u5e93\u5b58\u4fe1\u606f\u4e3a\u7a7a", (String)"InvoiceStockQueryImpl_1", (String)"imc-sim-webapi", (Object[])new Object[0]), (String)ApiErrCodeEnum.INV_STOCK_ILLEGAL_PARAM.getCode());
        }
        JSONObject returnData = new JSONObject();
        returnData.put("normalPaperInvoiceStock", dynamicObject.get("invoicestock"));
        returnData.put("specialPaperInvoiceStock", dynamicObject.get("specialinvoicestock"));
        returnData.put("normalEInvoiceStock", dynamicObject.get("einvoicestock"));
        returnData.put("specialEInvoiceStock", dynamicObject.get("especialinvoicestock"));
        returnData.put("equipmentType", dynamicObject.get("equipmenttype"));
        return ApiResult.success((Object)JSON.toJSONString((Object)returnData));
    }

    private static Map<String, String> checkParam(InvoiceStockQueryVo queryVo) {
        HashMap<String, String> rMap = new HashMap<String, String>(2);
        rMap.put("code", "0");
        rMap.put("msg", ResManager.loadKDString((String)"\u6210\u529f", (String)"InvoiceStockQueryImpl_2", (String)"imc-sim-webapi", (Object[])new Object[0]));
        if (!RegexUtil.isNsrsbh((String)queryVo.getTaxNo())) {
            rMap.put("code", ApiErrCodeEnum.INV_STOCK_ILLEGAL_TAX_NO.getCode());
            rMap.put("msg", ApiErrCodeEnum.INV_STOCK_ILLEGAL_TAX_NO.getMsg());
            return rMap;
        }
        if (StringUtils.isNotBlank((CharSequence)queryVo.getTerminalNo()) && queryVo.getTerminalNo().length() > 4) {
            rMap.put("code", ApiErrCodeEnum.INV_STOCK_ILLEGAL_TERMINALNO.getCode());
            rMap.put("msg", ApiErrCodeEnum.INV_STOCK_ILLEGAL_TERMINALNO.getMsg());
            return rMap;
        }
        if (StringUtils.isNotBlank((CharSequence)queryVo.getInvoiceType())) {
            ArrayList<String> invTypeList = new ArrayList<String>(4);
            invTypeList.add(InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode());
            invTypeList.add(InvoiceType.ELECTRICAL_NORMAL_INVOICE.getTypeCode());
            invTypeList.add(InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode());
            invTypeList.add(InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode());
            String[] invTypeArr = queryVo.getInvoiceType().split(",");
            boolean flag = true;
            for (String s : invTypeArr) {
                if (invTypeList.contains(s)) continue;
                flag = false;
                break;
            }
            if (!flag) {
                rMap.put("code", ApiErrCodeEnum.INV_STOCK_ILLEGAL_INVTYPE.getCode());
                rMap.put("msg", ApiErrCodeEnum.INV_STOCK_ILLEGAL_INVTYPE.getMsg());
            }
            return rMap;
        }
        QFilter qFilter = new QFilter("number", "=", (Object)queryVo.getTaxNo());
        DynamicObject epObj = BusinessDataServiceHelper.loadSingle((String)"bdm_enterprise_baseinfo", (String)"id", (QFilter[])qFilter.toArray());
        if (null == epObj) {
            rMap.put("code", ApiErrCodeEnum.INV_STOCK_NON_EPINFO.getCode());
            rMap.put("msg", ApiErrCodeEnum.INV_STOCK_NON_EPINFO.getMsg());
            return rMap;
        }
        QFilter deviceFilter = new QFilter("equipmentno", "=", (Object)queryVo.getDeviceNo()).and("epinfo", "=", epObj.getPkValue());
        boolean deviceExists = QueryServiceHelper.exists((String)"bdm_tax_equipment", (QFilter[])deviceFilter.toArray());
        if (!deviceExists) {
            rMap.put("code", ApiErrCodeEnum.INV_STOCK_NON_DEVICE.getCode());
            rMap.put("msg", ApiErrCodeEnum.INV_STOCK_NON_DEVICE.getMsg());
            return rMap;
        }
        return rMap;
    }
}

