/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.helper.QueryStockHelper;
import kd.imc.sim.common.vo.openapi.InvoiceStockVo;
import kd.imc.sim.common.vo.openapi.QueryStockVo;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.openapi.check.VerifyResult;
import kd.imc.sim.formplugin.openapi.service.OpenApiService;
import org.apache.commons.lang3.StringUtils;

public class QueryStockImpl
implements OpenApiService {
    private static Log LOGGER = LogFactory.getLog(QueryStockImpl.class);

    @Override
    public ApiResult processer(RequestVo requestVo) {
        if (null == requestVo || kd.bos.util.StringUtils.isBlank((String)requestVo.getData())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6570\u636e\u4f20\u5165\u4e3a\u7a7a", (String)"QueryStockImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        QueryStockVo vo = (QueryStockVo)JSON.parseObject((String)requestVo.getData(), QueryStockVo.class);
        if (vo == null) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6570\u636e\u4f20\u5165\u4e3a\u7a7a", (String)"QueryStockImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        LOGGER.info("QueryStockImpl:" + JSONObject.toJSONString((Object)vo));
        VerifyResult result = this.checkQueryStockVo(vo);
        if (!result.isSucceed()) {
            return ResponseVo.fail((String)result.getCode(), (String)result.getDesc());
        }
        InvoiceStockVo stock = QueryStockHelper.queryStock((String)vo.getEquipmentType(), (String)vo.getEquipmentNo(), (String)vo.getTaxNo(), (String)vo.getTerminalNo());
        if (stock.getSuccess().booleanValue()) {
            JSONObject json = new JSONObject();
            json.put("normalEInvoiceStock", (Object)stock.geteInvoiceStock());
            json.put("normalPaperInvoiceStock", (Object)stock.getInvoiceStock());
            json.put("specialPaperInvoiceStock", (Object)stock.getSpecialInvoiceStock());
            json.put("specialEInvoiceStock", (Object)stock.geteSpecialInvoiceStock());
            return ResponseVo.success((String)json.toJSONString());
        }
        return ResponseVo.fail((String)ErrorType.QUERY_STOCK_FAIL.getCode(), (String)stock.getErrorMsg());
    }

    private VerifyResult checkQueryStockVo(QueryStockVo vo) {
        String equipmentNo = vo.getEquipmentNo();
        String equipmentType = vo.getEquipmentType();
        String taxNo = vo.getTaxNo();
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return VerifyResult.error(ApiErrCodeEnum.BILL_PUSH_TAXPAYERID_ERROR.getCode(), ApiErrCodeEnum.BILL_PUSH_TAXPAYERID_ERROR.getMsg());
        }
        int taxNoLength = taxNo.length();
        if (15 != taxNoLength && 17 != taxNoLength && 18 != taxNoLength && 20 != taxNoLength) {
            return VerifyResult.error(ApiErrCodeEnum.FIND_EQINFO_TAXNO.getCode(), ApiErrCodeEnum.FIND_EQINFO_TAXNO.getMsg());
        }
        if (StringUtils.isBlank((CharSequence)equipmentNo) || equipmentNo.length() > 20) {
            return VerifyResult.error(ApiErrCodeEnum.INV_STOCK_ILLEGAL_DEVICENO.getCode(), ApiErrCodeEnum.INV_STOCK_ILLEGAL_DEVICENO.getMsg());
        }
        if (StringUtils.isBlank((CharSequence)equipmentType)) {
            return VerifyResult.error(ApiErrCodeEnum.INVOICE_DEV_IS_EMPTY.getCode(), ApiErrCodeEnum.INVOICE_DEV_IS_EMPTY.getMsg());
        }
        QFilter numberFilter = new QFilter("number", "=", (Object)taxNo);
        DynamicObject[] epInfos = BusinessDataServiceHelper.load((String)"bdm_enterprise_baseinfo", (String)"id", (QFilter[])numberFilter.toArray());
        if (epInfos.length == 0) {
            return VerifyResult.error(ApiErrCodeEnum.FIND_EQINFO_NOTFIND.getCode(), ApiErrCodeEnum.FIND_EQINFO_NOTFIND.getMsg());
        }
        QFilter filter = new QFilter("equipmentno", "=", (Object)equipmentNo).and("equipmenttype", "=", (Object)equipmentType).and("epinfo.number", "=", (Object)taxNo);
        DynamicObject[] array = BusinessDataServiceHelper.load((String)"bdm_tax_equipment", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_tax_equipment", (boolean)true), (QFilter[])filter.toArray());
        if (array.length == 0) {
            return VerifyResult.error(ApiErrCodeEnum.FIND_EQUIPMENT_NO.getCode(), ApiErrCodeEnum.FIND_EQUIPMENT_NO.getMsg());
        }
        if ("8".equals(equipmentType) && StringUtils.isBlank((CharSequence)vo.getTerminalNo())) {
            return VerifyResult.error(ApiErrCodeEnum.INVOICE_TERMINAL_NO_ERROR.getCode(), ApiErrCodeEnum.INVOICE_TERMINAL_NO_ERROR.getMsg());
        }
        if ("0".equalsIgnoreCase(array[0].getString("disen"))) {
            return VerifyResult.error(ApiErrCodeEnum.INVOICE_DEV_DISABLE.getCode(), ApiErrCodeEnum.INVOICE_DEV_DISABLE.getMsg());
        }
        return VerifyResult.succeed();
    }
}

