/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.invoice;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.lqpt.model.request.collect.InvoiceStatusQueryRequest;
import kd.imc.bdm.lqpt.model.response.collect.InvoiceStatusQueryResponse;
import kd.imc.bdm.lqpt.service.collect.InvoiceCollectionService;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.openapi.dto.request.InvoiceAccountingQueryRequestDTO;
import kd.imc.sim.formplugin.openapi.dto.response.InvoiceAccountingQueryResponseDTO;
import kd.imc.sim.formplugin.openapi.service.OpenApiService;

public class InvoiceAccountingQueryServiceImpl
implements OpenApiService {
    private static final Log LOGGER = LogFactory.getLog(InvoiceAccountingQueryServiceImpl.class);

    @Override
    public ApiResult processer(RequestVo requestVo) {
        InvoiceAccountingQueryRequestDTO queryVo;
        try {
            queryVo = this.checkAccountingRequest(requestVo.getData());
        }
        catch (MsgException e) {
            return ResponseVo.fail((String)e.getErrorCode(), (String)e.getErrorMsg());
        }
        String salerTaxNo = queryVo.getSellerTaxpayerId();
        if (!EnterpriseHelper.isLqptChannel((String)salerTaxNo)) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u975e\u4e50\u4f01\u901a\u9053\u67e5\u8be2\u5165\u8d26\u72b6\u6001\u3002", (String)"InvoiceQueryServiceImpl_12", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        JSONObject json = JSONObject.parseObject((String)JSONObject.toJSONString((Object)this.convertRequest(queryVo)));
        json.put("api_type", (Object)"FPZTXXCX");
        try {
            JSONObject responseJson = new InvoiceCollectionService().send(json);
            if (!ErrorType.SUCCESS.getCode().equals(responseJson.getString("errcode"))) {
                return ResponseVo.fail((String)responseJson.getString("errcode"), (String)responseJson.getString("description"));
            }
            InvoiceAccountingQueryResponseDTO response = this.convertResponse(responseJson.getJSONObject("data"));
            return ResponseVo.success((String)JSONObject.toJSONString((Object)response));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)e.getMessage());
        }
    }

    private InvoiceStatusQueryRequest convertRequest(InvoiceAccountingQueryRequestDTO queryVo) {
        InvoiceStatusQueryRequest request = new InvoiceStatusQueryRequest();
        request.setNsrsbh(queryVo.getSellerTaxpayerId());
        request.setFpdm(queryVo.getInvoiceCode());
        request.setFphm(queryVo.getInvoiceNo());
        request.setFplx(InvoiceType.getRimLqptCodeByTypeCode((String)queryVo.getInvoiceType()));
        request.setKprq(DateUtils.format((Date)queryVo.getInvoiceDate(), (String)"yyyyMMdd"));
        return request;
    }

    private InvoiceAccountingQueryRequestDTO checkAccountingRequest(String data) {
        InvoiceAccountingQueryRequestDTO queryVo;
        try {
            queryVo = (InvoiceAccountingQueryRequestDTO)JSONObject.parseObject((String)data, InvoiceAccountingQueryRequestDTO.class);
        }
        catch (Exception e) {
            throw new MsgException(ApiErrCodeEnum.VEHICLE_INVOICE_OPEN_PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u4f20\u5165\u53d1\u7968\u67e5\u8be2\u4e1a\u52a1\u6570\u636e\u4e0d\u5408\u6cd5", (String)"InvoiceQueryServiceImpl_7", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)queryVo.getSellerTaxpayerId())) {
            throw new MsgException(ApiErrCodeEnum.VEHICLE_INVOICE_OPEN_PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u672a\u4f20\u5165\u503c", (String)"InvoiceQueryServiceImpl_9", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)queryVo.getInvoiceType())) {
            throw new MsgException(ApiErrCodeEnum.VEHICLE_INVOICE_OPEN_PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u53d1\u7968\u79cd\u7c7b\u672a\u4f20\u5165\u503c", (String)"RedInfoBillDownloadServiceImpl_4", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        String rimLqptCode = InvoiceType.getRimLqptCodeByTypeCode((String)queryVo.getInvoiceType());
        if (StringUtils.isBlank((CharSequence)rimLqptCode)) {
            throw new MsgException(ApiErrCodeEnum.VEHICLE_INVOICE_OPEN_PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u53d1\u7968\u79cd\u7c7b\u4e0d\u6b63\u786e", (String)"AllEQuickRedInvoiceServiceImpl_2", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)queryVo.getInvoiceNo())) {
            throw new MsgException(ApiErrCodeEnum.VEHICLE_INVOICE_OPEN_PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801\u672a\u4f20\u5165\u503c", (String)"InvoiceCancelServiceImpl_2", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (queryVo.getInvoiceNo().length() != 20 && StringUtils.isBlank((CharSequence)queryVo.getInvoiceCode())) {
            throw new MsgException(ApiErrCodeEnum.VEHICLE_INVOICE_OPEN_PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u53d1\u7968\u4e3a\u7a0e\u63a7\u7968\u65f6\uff0c\u53d1\u7968\u4ee3\u7801\u5fc5\u586b", (String)"InvoiceAccountingQueryServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (queryVo.getInvoiceDate() == null) {
            throw new MsgException(ApiErrCodeEnum.VEHICLE_INVOICE_OPEN_PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u5f00\u7968\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"AllEQuickRedInvoiceServiceImpl_12", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        return queryVo;
    }

    private InvoiceAccountingQueryResponseDTO convertResponse(JSONObject responseJson) {
        InvoiceStatusQueryResponse statusQueryResponse = (InvoiceStatusQueryResponse)JSONObject.parseObject((String)responseJson.toJSONString(), InvoiceStatusQueryResponse.class);
        InvoiceAccountingQueryResponseDTO response = new InvoiceAccountingQueryResponseDTO();
        response.setInvoiceNo(statusQueryResponse.getFphm());
        response.setInvoiceDate(statusQueryResponse.getKprq());
        String vatStatus = statusQueryResponse.getFpyt();
        if ("0".equals(vatStatus)) {
            vatStatus = "00";
        }
        response.setVatStatus(vatStatus);
        response.setCtStatus(statusQueryResponse.getXfsyt());
        String accountingStatus = statusQueryResponse.getRzzt();
        if ("01".equals(accountingStatus)) {
            accountingStatus = "00";
        } else if ("02".equals(accountingStatus)) {
            accountingStatus = "01";
        }
        response.setAccountingStatus(accountingStatus);
        return response;
    }
}

