/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.invoice;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.helper.EquipmentHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.helper.InvoiceCancelHelper;
import kd.imc.sim.common.vo.openapi.InvoiceCancelVo;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.openapi.service.OpenApiService;
import org.apache.commons.lang3.StringUtils;

public class InvoiceCancelServiceImpl
implements OpenApiService {
    private static final Log LOG = LogFactory.getLog(InvoiceCancelServiceImpl.class);

    @Override
    public ApiResult processer(RequestVo requestVo) {
        InvoiceCancelVo cancelVo;
        try {
            cancelVo = (InvoiceCancelVo)JSON.parseObject((String)requestVo.getData(), InvoiceCancelVo.class);
        }
        catch (Exception e) {
            LOG.error("\u4f20\u5165\u53c2\u6570\u4e0d\u5408\u6cd5", (Throwable)e);
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u4f20\u5165\u4f5c\u5e9f\u4e1a\u52a1\u6570\u636e\u4e0d\u5408\u6cd5", (String)"InvoiceCancelServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (null == cancelVo) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u4f20\u5165\u4f5c\u5e9f\u4e1a\u52a1\u6570\u636e\u4e0d\u5408\u6cd5", (String)"InvoiceCancelServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)cancelVo.getInvoiceCode())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_CANCEL_NO_INVOICECODE.getCode(), (String)ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801\u672a\u4f20\u5165\u503c", (String)"InvoiceCancelServiceImpl_1", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)cancelVo.getInvoiceNumber())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_CANCEL_NO_INVOICENUMBER.getCode(), (String)ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801\u672a\u4f20\u5165\u503c", (String)"InvoiceCancelServiceImpl_2", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)cancelVo.getCanceler())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_CANCEL_NO_CANCELER.getCode(), (String)ResManager.loadKDString((String)"\u53d1\u7968\u4f5c\u5e9f\u4eba\u672a\u4f20\u5165\u503c", (String)"InvoiceCancelServiceImpl_3", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (!GBKUtils.checkValidGbk((String)cancelVo.getCanceler())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_CANCEL_NO_CANCELER.getCode(), (String)String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4f5c\u5e9f\u4eba[%s]\u5305\u542b\u975eGBK\u7f16\u7801\u5b57\u7b26", (String)"InvoiceCancelServiceImpl_4", (String)"imc-sim-webapi", (Object[])new Object[0]), cancelVo.getCanceler()));
        }
        if (GBKUtils.getGBKLength((String)cancelVo.getCanceler()) > 10) {
            return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_CANCEL_NO_CANCELER.getCode(), (String)String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4f5c\u5e9f\u4eba[%s]\u8d85\u8fc7\u6700\u5927\u5b57\u7b26\u957f\u5ea610\u5b57\u8282", (String)"InvoiceCancelServiceImpl_5", (String)"imc-sim-webapi", (Object[])new Object[0]), cancelVo.getCanceler()));
        }
        if (!GBKUtils.checkValidGbk((String)cancelVo.getAbolishReason())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_CANCEL_NO_CANCELER.getCode(), (String)String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4f5c\u5e9f\u539f\u56e0[%s]\u5305\u542b\u975eGBK\u7f16\u7801\u5b57\u7b26", (String)"InvoiceCancelServiceImpl_6", (String)"imc-sim-webapi", (Object[])new Object[0]), cancelVo.getAbolishReason()));
        }
        if (GBKUtils.getGBKLength((String)cancelVo.getAbolishReason()) > 40) {
            return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_CANCEL_NO_CANCELER.getCode(), (String)String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4f5c\u5e9f\u539f\u56e0[%s]\u8d85\u8fc7\u6700\u5927\u5b57\u7b26\u957f\u5ea620\u5b57\u7b26", (String)"InvoiceCancelServiceImpl_7", (String)"imc-sim-webapi", (Object[])new Object[0]), cancelVo.getAbolishReason()));
        }
        QFilter filter = new QFilter("invoicecode", "=", (Object)cancelVo.getInvoiceCode()).and("invoiceno", "=", (Object)cancelVo.getInvoiceNumber());
        DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice"), (QFilter[])new QFilter[]{filter});
        if (null == invoice) {
            return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_CANCEL_NO_INVOICE.getCode(), (String)String.format(ResManager.loadKDString((String)"\u65e0\u6b64\u53d1\u7968\u4fe1\u606f[\u4ee3\u7801:%1$s,\u53f7\u7801:%2$s]", (String)"InvoiceCancelServiceImpl_8", (String)"imc-sim-webapi", (Object[])new Object[0]), cancelVo.getInvoiceCode(), cancelVo.getInvoiceNumber()));
        }
        if (EquipmentHelper.isDisableJQBH((Object)invoice.getString("salertaxno"), (Object)invoice.getString("jqbh"))) {
            return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_DEV_DISABLE.getCode(), (String)String.format(ResManager.loadKDString((String)"\u53d1\u7968[\u4ee3\u7801:%1$s,\u53f7\u7801:%2$s]\u5bf9\u5e94\u7684\u8bbe\u5907\u5df2\u7ecf\u88ab\u7981\u7528", (String)"InvoiceCancelServiceImpl_9", (String)"imc-sim-webapi", (Object[])new Object[0]), cancelVo.getInvoiceCode(), cancelVo.getInvoiceNumber()));
        }
        try {
            InvoiceCancelHelper.cancelInvoice((DynamicObject)invoice, (String)cancelVo.getCanceler(), (String)cancelVo.getAbolishReason());
        }
        catch (MsgException e) {
            return ResponseVo.fail((String)e.getErrorCode(), (String)e.getErrorMsg());
        }
        invoice = BusinessDataServiceHelper.loadSingle((Object)invoice.getPkValue(), (String)"sim_vatinvoice");
        JSONObject returnData = new JSONObject();
        returnData.put("invoiceStatus", invoice.get("invoicestatus"));
        returnData.put("invalidDate", invoice.get("invaliddate"));
        returnData.put("invalidEr", invoice.get("invalider"));
        returnData.put("invoiceCode", invoice.get("invoicecode"));
        returnData.put("invoiceNo", invoice.get("invoiceno"));
        returnData.put("billNo", invoice.get("billno"));
        return ResponseVo.success((String)returnData.toJSONString());
    }
}

