/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.invoice;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.helper.ComponentServiceHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.RegexUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.sim.common.vo.openapi.InvoicePrintVo;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.openapi.check.VerifyResult;
import kd.imc.sim.formplugin.openapi.service.OpenApiService;
import org.apache.commons.lang3.StringUtils;

public class InvoicePrintServiceImpl
implements OpenApiService {
    public static final Log log = LogFactory.getLog(InvoicePrintServiceImpl.class);
    private static final int INVOICE_NO_LIMIT = 8;
    private static final String[] INVOICE_CODE_LIMIT = new String[]{"10", "12"};

    @Override
    public ApiResult processer(RequestVo requestVo) {
        if (null == requestVo) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6570\u636e\u4f20\u5165\u4e3a\u7a7a", (String)"InvoicePrintServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        InvoicePrintVo print = null;
        if (StringUtils.isNotEmpty((CharSequence)requestVo.getData())) {
            print = (InvoicePrintVo)JSON.parseObject((String)requestVo.getData(), InvoicePrintVo.class);
        }
        if (print == null) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6570\u636e\u4f20\u5165\u4e3a\u7a7a", (String)"InvoicePrintServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        VerifyResult res = this.checkInvoicePrint(print);
        if (!res.isSucceed()) {
            return ResponseVo.fail((String)res.getCode(), (String)res.getDesc());
        }
        try {
            String hxbzdh;
            DynamicObject invoice;
            if (InvoiceType.PAPER_VEHICLE_INVOICE.getTypeCode().equals(print.getInvoiceType())) {
                invoice = this.getVehicheVatInvoice(print);
                SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg((Long)DynamicObjectUtil.getDynamicObjectLongValue((Object)invoice.get("orgid")));
                hxbzdh = saleInfo.getDefaultTerminal();
            } else {
                invoice = this.getVatInvoice(print);
                hxbzdh = StringUtils.isEmpty((CharSequence)invoice.getString("terminalno")) ? "" : invoice.getString("terminalno");
            }
            print.setDeviceNo(invoice.getString("jqbh"));
            if (StringUtils.isEmpty((CharSequence)print.getDeviceNo())) {
                throw new MsgException(ApiErrCodeEnum.INVOICE_PRING.getCode(), ApiErrCodeEnum.INVOICE_PRING.getMsg());
            }
            String remoteUrl = ComponentServiceHelper.getComponentRequestUrl((String)print.getDeviceNo());
            String printMachine = this.getPrintMachine(remoteUrl, hxbzdh);
            JSONObject printInvoiceResult = this.sendPrintInvoiceRequest(print, remoteUrl, hxbzdh, printMachine);
            this.update(invoice, printInvoiceResult.getString("errcode"));
            return this.dealPrintInvoiceResult(printInvoiceResult);
        }
        catch (Exception e) {
            return this.handlerException(e);
        }
    }

    private VerifyResult checkInvoicePrint(InvoicePrintVo print) {
        if (!RegexUtil.isNsrsbh((String)print.getSellerTaxpayerId())) {
            return VerifyResult.error(ApiErrCodeEnum.INVOICE_PRING_TAXNO.getCode(), ApiErrCodeEnum.INVOICE_PRING_TAXNO.getMsg());
        }
        print.setSellerTaxpayerId(print.getSellerTaxpayerId().toUpperCase());
        if (!this.checkPaperByType(print.getInvoiceType()) && !this.checkVehiclePaperByType(print.getInvoiceType())) {
            return VerifyResult.error(ApiErrCodeEnum.INVOICE_PRING_TYPE.getCode(), ApiErrCodeEnum.INVOICE_PRING_TYPE.getMsg());
        }
        if (!this.checkInvoiceCodeLen(print.getInvoiceCode())) {
            return VerifyResult.error(ApiErrCodeEnum.INVOICE_PRING_CODE.getCode(), ApiErrCodeEnum.INVOICE_PRING_CODE.getMsg());
        }
        if (!this.checkInvoiceNoLen(print.getInvoiceNumber())) {
            return VerifyResult.error(ApiErrCodeEnum.INVOICE_PRING_NO.getCode(), ApiErrCodeEnum.INVOICE_PRING_NO.getMsg());
        }
        if (print.getInventoryFlag() != 0 && print.getInventoryFlag() != 1) {
            return VerifyResult.error(ApiErrCodeEnum.INVOICE_PRING_FLAG.getCode(), ApiErrCodeEnum.INVOICE_PRING_FLAG.getMsg());
        }
        return VerifyResult.succeed();
    }

    private boolean checkPaperByType(String type) {
        return StringUtils.isNotEmpty((CharSequence)type) && ("004".equals(type) || "007".equals(type));
    }

    private boolean checkVehiclePaperByType(String type) {
        return StringUtils.isNotEmpty((CharSequence)type) && "006".equals(type);
    }

    private boolean checkInvoiceNoLen(String no) {
        return StringUtils.isNotEmpty((CharSequence)no) && no.length() == 8;
    }

    private boolean checkInvoiceCodeLen(String code) {
        return StringUtils.isNotEmpty((CharSequence)code) && Arrays.asList(INVOICE_CODE_LIMIT).contains(code.length() + "");
    }

    private DynamicObject getVatInvoice(InvoicePrintVo invoicePrintVo) {
        QFilter filter = new QFilter("salertaxno", "=", (Object)invoicePrintVo.getSellerTaxpayerId());
        filter.and("invoicecode", "=", (Object)invoicePrintVo.getInvoiceCode());
        filter.and("invoiceno", "=", (Object)invoicePrintVo.getInvoiceNumber());
        DynamicObject object = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice"), (QFilter[])filter.toArray());
        if (object == null) {
            throw new MsgException(ApiErrCodeEnum.INVOICE_PRING.getCode(), ApiErrCodeEnum.INVOICE_PRING.getMsg());
        }
        return object;
    }

    private DynamicObject getVehicheVatInvoice(InvoicePrintVo print) {
        QFilter qFilter = new QFilter("invoicecode", "=", (Object)print.getInvoiceCode()).and("invoiceno", "=", (Object)print.getInvoiceNumber());
        DynamicObject vehicle = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice_vehicles", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice_vehicles"), (QFilter[])qFilter.toArray());
        if (vehicle == null) {
            throw new MsgException(ApiErrCodeEnum.INVOICE_PRING.getCode(), ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u53d1\u7968\u6570\u636e", (String)"InvoicePrintServiceImpl_1", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        return vehicle;
    }

    private ApiResult handlerException(Exception e) {
        if (e instanceof MsgException) {
            MsgException msgException = (MsgException)((Object)e);
            return ResponseVo.fail((String)msgException.getErrorCode(), (String)msgException.getErrorMsg());
        }
        log.info(String.format("\u7ec4\u4ef6\u5f02\u5e38\u8fd4\u56de\u6d4b\u8bd5\u6570\u636eTestData:%s", e.getMessage()));
        return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_NO_DATA.getCode(), (String)String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5f02\u5e38:%s", (String)"InvoicePrintServiceImpl_2", (String)"imc-sim-webapi", (Object[])new Object[0]), e.getMessage()));
    }

    private String getPrintMachine(String remoteUrl, String hxbzdh) {
        JSONObject reqData = JSONObject.parseObject((String)"{}");
        reqData.put("czlx", (Object)"901");
        reqData.put("hxbzdh", (Object)hxbzdh);
        JSONObject devResult = ComponentServiceHelper.doPost((String)remoteUrl, (String)reqData.toJSONString());
        if (!ErrorType.SUCCESS.getCode().equals(devResult.getString("errcode"))) {
            throw new MsgException(ApiErrCodeEnum.INVOICE_PRING_NOTDEV.getCode(), ApiErrCodeEnum.INVOICE_PRING_NOTDEV.getMsg());
        }
        return devResult.getJSONObject("sjd").getString("default_printer");
    }

    private JSONObject sendPrintInvoiceRequest(InvoicePrintVo printVo, String remoteUrl, String hxbzdh, String printMachine) {
        JSONObject reqData = JSONObject.parseObject((String)"{}");
        reqData.put("czlx", (Object)"4");
        if (this.checkPaperByType(printVo.getInvoiceType())) {
            reqData.put("hxbzdh", (Object)hxbzdh);
        }
        JSONObject sjd = JSONObject.parseObject((String)"{}");
        sjd.put("kpzl", (Object)InvoiceType.getTypeCodeHx((String)printVo.getInvoiceType()));
        sjd.put("fpdm", (Object)printVo.getInvoiceCode());
        sjd.put("fphm", (Object)printVo.getInvoiceNumber());
        sjd.put("ylbz", (Object)"0");
        sjd.put("print_type", (Object)String.valueOf(printVo.getInventoryFlag()));
        sjd.put("printer_name", (Object)printMachine);
        reqData.put("sjd", (Object)sjd);
        return ComponentServiceHelper.doPost((String)remoteUrl, (String)reqData.toJSONString());
    }

    private void update(DynamicObject object, String printResultCode) {
        if ("5011".equals(printResultCode)) {
            object.set("printflag", (Object)"1");
        } else {
            object.set("printflag", (Object)"2");
        }
        SaveServiceHelper.update((DynamicObject)object);
        if (log.isInfoEnabled()) {
            log.info("\u6253\u5370\u53d1\u7968(\u6e05\u5355)\u66f4\u65b0\u53d1\u7968\u6253\u5370\u72b6\u6001\uff1a\u53d1\u7968\u53f7\u7801" + object.getString("invoiceno") + "\uff1a\u72b6\u60011\u5df2\u6253\u5370-2\u6253\u5370\u5931\u8d25\uff1a" + object.getString("printflag"));
        }
    }

    private ApiResult dealPrintInvoiceResult(JSONObject printInvoiceResult) {
        if ("5011".equals(printInvoiceResult.getString("errcode"))) {
            return ResponseVo.success((String)ResManager.loadKDString((String)"\u6210\u529f", (String)"InvoicePrintServiceImpl_3", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u6253\u5370\u5931\u8d25\uff1a%s", (String)"InvoicePrintServiceImpl_4", (String)"imc-sim-webapi", (Object[])new Object[0]), printInvoiceResult.getString("description")));
    }
}

