/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.invoice;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.ApiConfig;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.InvoiceStatus;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.table.RedReasonEnum;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.EquipmentHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.invoice.RemarkTemplateHelper;
import kd.imc.bdm.common.openapi.InvoiceVo;
import kd.imc.bdm.common.util.UUID;
import kd.imc.sim.common.helper.issueinvoice.IssueInvoiceMqHelper;
import kd.imc.sim.common.utils.InvoiceQFilterUtil;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.issuing.util.RedInvoiceUtil;
import kd.imc.sim.formplugin.openapi.service.OpenApiService;
import org.apache.commons.collections.CollectionUtils;

public class QuickRedInvoiceServiceImpl
implements OpenApiService {
    private static final Log log = LogFactory.getLog(QuickRedInvoiceServiceImpl.class);

    @Override
    public ApiResult processer(RequestVo requestVo) {
        if (null == requestVo) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6570\u636e\u4f20\u5165\u4e3a\u7a7a", (String)"QuickRedInvoiceServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        List invoiceVoList = JSON.parseArray((String)requestVo.getData(), InvoiceVo.class);
        if (log.isInfoEnabled()) {
            log.info(String.format("api\u63a5\u53e3\u7ea2\u51b2 requestData\uff1a%s", JSON.toJSONString((Object)invoiceVoList)));
        }
        if (CollectionUtils.isEmpty((Collection)invoiceVoList)) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6570\u636e\u4f20\u5165\u4e3a\u7a7a", (String)"QuickRedInvoiceServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (!ApiConfig.checkDisposeLimit((int)invoiceVoList.size())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u6570\u636e\u4f20\u5165\u8d85\u8fc7\u6700\u5927\u5904\u7406\u6570\uff08%1$s\uff09\uff0c\u5f53\u524d\u4f20\u5165\u6570\uff1a%2$s", (String)"QuickRedInvoiceServiceImpl_1", (String)"imc-sim-webapi", (Object[])new Object[0]), ApiConfig.getDisposeLimit(), invoiceVoList.size()));
        }
        ArrayList<DynamicObject> redList = new ArrayList<DynamicObject>();
        for (InvoiceVo invoiceVo : invoiceVoList) {
            if (StringUtils.isEmpty((CharSequence)invoiceVo.getInvoiceCode())) {
                return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u539f\u84dd\u7968\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"QuickRedInvoiceServiceImpl_2", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            if (StringUtils.isEmpty((CharSequence)invoiceVo.getInvoiceNum())) {
                return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u539f\u84dd\u7968\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"QuickRedInvoiceServiceImpl_3", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            QFilter qFilter = InvoiceQFilterUtil.getInvoiceByCodeAndNo((String)invoiceVo.getInvoiceCode(), (String)invoiceVo.getInvoiceNum());
            DynamicObject invoiceObj = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"id,invoicestatus,invoicetype,invoiceamount,remainredamount,invoicecode,invoiceno", (QFilter[])qFilter.toArray());
            if (invoiceObj == null) {
                return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u539f\u84dd\u7968\u4e0d\u5b58\u5728", (String)"QuickRedInvoiceServiceImpl_4", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            if ("3".equals(invoiceObj.get("invoicestatus"))) {
                return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u84dd\u7968\u5df2\u7ea2\u51b2", (String)"QuickRedInvoiceServiceImpl_5", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            if (!InvoiceStatus.isNormalInvIncludePartRed((String)invoiceObj.getString("invoicestatus"))) {
                return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u53ea\u80fd\u7ea2\u51b2\u5df2\u5f00\u5177\u7684\u53d1\u7968", (String)"QuickRedInvoiceServiceImpl_6", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            if ((InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode().equals(invoiceObj.get("invoicetype")) || InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode().equals(invoiceObj.get("invoicetype"))) && StringUtils.isBlank((CharSequence)invoiceVo.getRedInfoBillNo())) {
                return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u5feb\u901f\u7ea2\u51b2\u4e13\u7528\u53d1\u7968\uff0c\u9700\u8981\u6307\u5b9a\u88ab\u7ea2\u51b2\u84dd\u7968\u7684\u7ea2\u5b57\u4fe1\u606f\u8868\u7f16\u53f7", (String)"QuickRedInvoiceServiceImpl_7", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            if (invoiceObj.getBigDecimal("invoiceamount").compareTo(BigDecimal.ZERO) < 0) {
                return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801%1$s\uff0c\u53f7\u7801%2$s\u4e0d\u662f\u666e\u901a\u84dd\u7968\uff0c\u4e0d\u80fd\u7ea2\u51b2", (String)"QuickRedInvoiceServiceImpl_8", (String)"imc-sim-webapi", (Object[])new Object[0]), invoiceObj.get("invoicecode"), invoiceObj.get("invoiceno")));
            }
            if (invoiceObj.getBigDecimal("invoiceamount").compareTo(invoiceObj.getBigDecimal("remainredamount")) != 0) {
                return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801%1$s\uff0c\u53f7\u7801%2$s\u5df2\u7ecf\u90e8\u5206\u7ea2\u51b2\u8fc7\uff0c\u63a5\u53e3\u5f00\u5177\u4e0d\u80fd\u8fdb\u884c\u7ea2\u51b2", (String)"QuickRedInvoiceServiceImpl_9", (String)"imc-sim-webapi", (Object[])new Object[0]), invoiceObj.get("invoicecode"), invoiceObj.get("invoiceno")));
            }
            if (EquipmentHelper.isDisableJQBH((Object)(invoiceObj = BusinessDataServiceHelper.loadSingle((Object)invoiceObj.getPkValue(), (String)"sim_vatinvoice")).getString("salertaxno"), (Object)invoiceObj.getString("jqbh"))) {
                return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801%1$s\uff0c\u53f7\u7801%2$s\u7684\u8bbe\u5907\u5df2\u7ecf\u88ab\u7981\u7528\uff0c\u63a5\u53e3\u5f00\u5177\u4e0d\u80fd\u8fdb\u884c\u7ea2\u51b2", (String)"QuickRedInvoiceServiceImpl_10", (String)"imc-sim-webapi", (Object[])new Object[0]), invoiceObj.get("invoicecode"), invoiceObj.get("invoiceno")));
            }
            DynamicObject redDynamicObject = RedInvoiceUtil.blueInvoiceConvertToRed((DynamicObject)invoiceObj);
            if (!IssueStatusEnum.none.getCode().equals(redDynamicObject.getString("issuestatus"))) continue;
            if (StringUtils.isEmpty((CharSequence)invoiceVo.getRedReason()) || !RedReasonEnum.getAllTypeCode().contains(invoiceVo.getRedReason())) {
                redDynamicObject.set("redreason", (Object)"2");
            } else {
                redDynamicObject.set("redreason", (Object)invoiceVo.getRedReason());
            }
            if (!StringUtils.isBlank((CharSequence)invoiceVo.getRedInfoBillNo())) {
                redDynamicObject.set("infocode", (Object)invoiceVo.getRedInfoBillNo());
                redDynamicObject.set("remark", (Object)RemarkTemplateHelper.generateRedInfoRemark((DynamicObject)redDynamicObject));
            }
            if (StringUtils.isEmpty((CharSequence)redDynamicObject.getString("orderno"))) {
                redDynamicObject.set("systemsource", (Object)requestVo.getBusinessSystemCode());
                redDynamicObject.set("billno", (Object)("API_RED_" + UUID.getBatchNumber() + "_0001"));
                redList.add(redDynamicObject);
                continue;
            }
            if (!StringUtils.isEmpty((CharSequence)redDynamicObject.getString("invoiceno"))) {
                return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801%1$s\uff0c\u53f7\u7801%2$s\u5df2\u7ea2\u51b2", (String)"QuickRedInvoiceServiceImpl_11", (String)"imc-sim-webapi", (Object[])new Object[0]), invoiceObj.get("invoicecode"), invoiceObj.get("invoiceno")));
            }
            redList.add(redDynamicObject);
        }
        try (TXHandle h1 = TX.required();){
            try {
                ImcSaveServiceHelper.save(redList);
            }
            catch (Exception e) {
                h1.markRollback();
                log.error("api\u63a5\u53e3\u7ea2\u51b2 \u4fdd\u5b58\u5f85\u5f00\u5f02\u5e38", (Throwable)e);
                ApiResult apiResult = ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)e.getMessage());
                if (h1 != null) {
                    if (var5_6 != null) {
                        try {
                            h1.close();
                        }
                        catch (Throwable throwable) {
                            var5_6.addSuppressed(throwable);
                        }
                    } else {
                        h1.close();
                    }
                }
                return apiResult;
            }
        }
        try {
            log.info("api\u63a5\u53e3\u7ea2\u51b2\uff0cwaitInvoiceList " + redList.size());
            IssueInvoiceMqHelper.submitInvoice2MQ((DynamicObject[])redList.toArray(new DynamicObject[0]));
        }
        catch (Exception e) {
            log.error("api\u63a5\u53e3\u7ea2\u51b2\u63a8\u5165mq\u5f02\u5e38", (Throwable)e);
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)e.getMessage());
        }
        return ResponseVo.success((String)ResManager.loadKDString((String)"\u63d0\u4ea4\u7ea2\u51b2\u6210\u529f", (String)"QuickRedInvoiceServiceImpl_12", (String)"imc-sim-webapi", (Object[])new Object[0]));
    }
}

