/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.ismc;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.ScanApiErrCodeEnum;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.sim.async.TgAsyncIssueHandlerImpl;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.openapi.service.OpenApiService;

public class ISMCCallbackInvoiceServiceImpl
implements OpenApiService {
    private static final Log LOGGER = LogFactory.getLog(ISMCCallbackInvoiceServiceImpl.class);

    @Override
    public ApiResult processer(RequestVo requestVo) {
        if (null == requestVo || StringUtils.isBlank((CharSequence)requestVo.getData())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6570\u636e\u4f20\u5165\u4e3a\u7a7a", (String)"ISMCCallbackInvoiceServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        LOGGER.info("ISMCCallbackInvoice \u5165\u53c2\uff1a" + requestVo.getData());
        try {
            JSONObject invoiceJson = JSON.parseObject((String)requestVo.getData());
            if (IssueStatusEnum.failed.getCode().equals(invoiceJson.getString("issuestatus"))) {
                new TgAsyncIssueHandlerImpl().handleTGInvoiceFailed(invoiceJson);
            } else {
                new TgAsyncIssueHandlerImpl().handleTGInvoiceSuccess(invoiceJson);
            }
        }
        catch (Exception e) {
            LOGGER.error("ISMCCallbackInvoice Exception ", (Throwable)e);
            return ResponseVo.fail((String)ScanApiErrCodeEnum.ERROR.getCode(), (String)e.getMessage());
        }
        return ResponseVo.success((String)ResManager.loadKDString((String)"\u6210\u529f", (String)"ISMCCallbackInvoiceServiceImpl_1", (String)"imc-sim-webapi", (Object[])new Object[0]), null);
    }
}

