/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.qr;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.ScanApiErrCodeEnum;
import kd.imc.bdm.common.dto.BillVo;
import kd.imc.sim.billcenter.sys.ExternalSystemDataHandler;
import kd.imc.sim.common.model.billcenter.BillErrorVo;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.openapi.service.OpenApiService;
import kd.imc.sim.formplugin.openapi.service.impl.qr.QRGetBillServiceImpl;

public class QRGetBillListServiceImpl
implements OpenApiService {
    private static final Log LOGGER = LogFactory.getLog(QRGetBillServiceImpl.class);

    @Override
    public ApiResult processer(RequestVo requestVo) {
        if (null == requestVo || StringUtils.isBlank((CharSequence)requestVo.getData())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6570\u636e\u4f20\u5165\u4e3a\u7a7a", (String)"QRGetBillListServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        JSONObject param = JSONObject.parseObject((String)requestVo.getData());
        if (param == null) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6570\u636e\u4f20\u5165\u4e3a\u7a7a", (String)"QRGetBillListServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        LOGGER.info("\u4ece\u8d26\u5355\u4e2d\u5fc3\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f\u5165\u53c2\uff1a" + requestVo.getData());
        try {
            String systemCode = param.getString("sysSource");
            LOGGER.info("\u5f53\u524d\u8bf7\u6c42\u7684\u7cfb\u7edf\u6765\u6e90\u7f16\u7801\uff1a" + systemCode);
            JSONObject requestParam = ExternalSystemDataHandler.createRequestParam((JSONObject)param);
            List list = ExternalSystemDataHandler.getExternalSystemData((JSONObject)requestParam);
            JSONArray jsonArray = new JSONArray();
            if (list == null || list.isEmpty()) {
                return ResponseVo.success((String)jsonArray.toJSONString());
            }
            for (BillVo billVo : list) {
                if (billVo instanceof BillErrorVo) {
                    BillErrorVo billErrorVo = (BillErrorVo)billVo;
                    if (!StringUtils.isNotEmpty((CharSequence)billErrorVo.getErrorMsg())) continue;
                    return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)billErrorVo.getErrorMsg());
                }
                jsonArray.add((Object)billVo);
            }
            LOGGER.info("\u8fd4\u56de\u7684\u8ba2\u5355\u6570\u636e\u5217\u8868\u5927\u5c0f\uff1a" + jsonArray.size());
            if (jsonArray.size() > 0) {
                return ResponseVo.success((String)jsonArray.toJSONString());
            }
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6570\u636e\u4f20\u5165\u4e3a\u7a7a", (String)"QRGetBillListServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        catch (KDBizException e) {
            return ResponseVo.fail((String)ScanApiErrCodeEnum.ERROR.getCode(), (String)e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("QRGetBill Exception ", (Throwable)e);
            return ResponseVo.fail((String)ScanApiErrCodeEnum.ERROR.getCode(), (String)ScanApiErrCodeEnum.ERROR.getMsg());
        }
    }
}

