/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.redconfirm;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.OperationConstant;
import kd.imc.bdm.common.constant.table.RedInfoConstant;
import kd.imc.bdm.common.dto.allelespecial.BillVehicheVesselShipVo;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.sim.common.constant.OpenApiInterfaceCodeEnum;
import kd.imc.sim.common.constant.RedConfirmBillRedReasonEnum;
import kd.imc.sim.common.constant.RedConfirmStatusEnum;
import kd.imc.sim.common.helper.BillHelper;
import kd.imc.sim.common.model.invoice.InvoiceSpecialType;
import kd.imc.sim.common.service.InvoiceAllESpecialCheckService;
import kd.imc.sim.common.utils.InvoiceQFilterUtil;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.common.vo.redconfirm.RedConfirmApplyRequestDTO;
import kd.imc.sim.formplugin.match.MinusBillMatchHelper;
import kd.imc.sim.formplugin.openapi.service.OpenApiService;
import kd.imc.sim.formplugin.openapi.service.impl.alle.constant.EInvoiceErrCodeEnum;
import kd.imc.sim.formplugin.openapi.service.impl.alle.service.ApiRedService;
import kd.imc.sim.formplugin.openapi.service.impl.alle.service.PartRedService;
import kd.imc.sim.formplugin.redconfirm.helper.RedConfirmBillHelper;
import kd.imc.sim.formplugin.redconfirm.helper.RedConfirmBillMailHelper;

public class RedConfirmBillApplyServiceImpl
implements OpenApiService {
    private static final Log log = LogFactory.getLog(RedConfirmBillApplyServiceImpl.class);

    @Override
    public ApiResult processer(RequestVo requestVo) {
        String invoiceCode;
        RedConfirmApplyRequestDTO requestDTO;
        if (log.isInfoEnabled()) {
            log.info(String.format("\u4e1a\u52a1\u7cfb\u7edf[%s]\u521b\u5efa\u7ea2\u5b57\u786e\u8ba4\u5355\u4f20\u5165\u53c2\u6570[%s]", requestVo.getBusinessSystemCode(), requestVo.getData()));
        }
        if ((requestDTO = (RedConfirmApplyRequestDTO)JSONObject.parseObject((String)requestVo.getData(), RedConfirmApplyRequestDTO.class)) == null || StringUtils.isBlank((CharSequence)requestDTO.getInvoiceNo())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.NON_INV_CODE_NUM.getCode(), (String)ResManager.loadKDString((String)"\u539f\u53d1\u7968\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"RedConfirmBillApplyServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (!StringUtils.isEmpty((CharSequence)requestDTO.getSerialNo())) {
            requestDTO.setOrderNo(requestDTO.getSerialNo());
        }
        if (StringUtils.isBlank((CharSequence)(invoiceCode = requestDTO.getInvoiceCode())) && requestDTO.getInvoiceNo().length() != 20) {
            return ResponseVo.fail((String)ApiErrCodeEnum.NON_INV_CODE_NUM.getCode(), (String)ResManager.loadKDString((String)"\u539f\u53d1\u7968\u53f7\u7801\u9519\u8bef\uff0c\u957f\u5ea6\u5e94\u4e3a20", (String)"RedConfirmBillApplyServiceImpl_1", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)requestDTO.getRedReason())) {
            requestDTO.setRedReason(RedConfirmBillRedReasonEnum.INVOICE_ERR.getBillCode());
        } else if (Arrays.stream(RedConfirmBillRedReasonEnum.values()).noneMatch(redReason -> redReason.getBillCode().equals(requestDTO.getRedReason()))) {
            return ResponseVo.fail((String)ApiErrCodeEnum.NON_INV_CODE_NUM.getCode(), (String)ResManager.loadKDString((String)"\u7ea2\u51b2\u539f\u56e0\u586b\u5199\u9519\u8bef", (String)"RedConfirmBillApplyServiceImpl_2", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)requestDTO.getOrderNo())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.NON_INV_CODE_NUM.getCode(), (String)ResManager.loadKDString((String)"\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"RedConfirmBillApplyServiceImpl_3", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (!Pattern.matches("^[0-9a-zA-Z]{20}$", requestDTO.getOrderNo())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.NON_INV_CODE_NUM.getCode(), (String)ResManager.loadKDString((String)"\u6d41\u6c34\u53f7\u53ea\u80fd\u5305\u542b\u6570\u5b57\u4e0e\u5b57\u6bcd\u4e14\u4e3a20\u4f4d", (String)"RedConfirmBillApplyServiceImpl_4", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (String.valueOf(requestDTO.getRemark()).length() > 200) {
            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_REMARK_OVER.getCode(), (String)ApiErrCodeEnum.BILL_PUSH_REMARK_OVER.getMsg());
        }
        if (StringUtils.isEmpty((CharSequence)requestDTO.getApplicant())) {
            requestDTO.setApplicant("2");
        }
        InvoiceAllESpecialCheckService invoiceAllESpecialCheckService = new InvoiceAllESpecialCheckService();
        invoiceAllESpecialCheckService.dealCheckTravelerItemMethod(requestDTO.getOrderNo(), requestDTO.getTravelerList());
        List<BillVehicheVesselShipVo> vehicheVesselShipList = requestDTO.getVehicheVesselShipList();
        if (vehicheVesselShipList != null && !vehicheVesselShipList.isEmpty()) {
            invoiceAllESpecialCheckService.dealCheckVesselVehicheItemMethod(requestDTO.getOrderNo(), requestDTO.getVehicheVesselShipList());
        }
        String account = requestDTO.getAccount();
        DynamicObject[] redConfirmBills = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)String.join((CharSequence)",", "number", "uploadstatus", "govuuid", "confirmstatus"), (QFilter[])new QFilter("orderno", "=", (Object)requestDTO.getOrderNo()).toArray());
        if (redConfirmBills != null && redConfirmBills.length > 1) {
            return ResponseVo.fail((String)ApiErrCodeEnum.REDCONFIRMBILL_BILLNO_MORE_FAIL.getCode(), (String)String.format(ApiErrCodeEnum.REDCONFIRMBILL_BILLNO_MORE_FAIL.getMsg(), requestDTO.getSerialNo()));
        }
        if (redConfirmBills != null && redConfirmBills.length == 1) {
            boolean isLeqiChannel;
            String taxNo;
            DynamicObject redConfirmBill = redConfirmBills[0];
            if ("1".equals(redConfirmBill.getString("uploadstatus")) && !RedConfirmStatusEnum.validConfirmStatus.contains((Object)redConfirmBill.getString("confirmstatus"))) {
                return ResponseVo.success((String)this.createReturnJson(redConfirmBill));
            }
            redConfirmBill = BusinessDataServiceHelper.loadSingle((Object)redConfirmBill.getPkValue(), (String)"sim_red_confirm_bill");
            String sellerTaxpayerId = redConfirmBill.getString("salertaxno");
            String buyerTaxpayerId = redConfirmBill.getString("buyertaxno");
            redConfirmBill.set("remark", (Object)requestDTO.getRemark());
            if ("0".equals(redConfirmBill.getString("enteridentity"))) {
                taxNo = sellerTaxpayerId;
                if ("02".equals(redConfirmBill.getString("specialtype"))) {
                    taxNo = buyerTaxpayerId;
                }
            } else {
                taxNo = buyerTaxpayerId;
            }
            if (!(isLeqiChannel = EnterpriseHelper.isLqptChannel((String)taxNo)) && StringUtils.isNotBlank((CharSequence)account)) {
                String msg = AllEleAuthHelper.checkIssueAccount((String)taxNo, (String)account);
                if (StringUtils.isNotBlank((CharSequence)msg)) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)msg);
                }
                redConfirmBill.set("account", (Object)account);
                redConfirmBill.set("drawer", (Object)AllEleAuthHelper.getDrawerByAccount((String)taxNo, (String)account));
            }
            ApiResult result = RedConfirmBillHelper.submit((DynamicObject)redConfirmBill);
            new MinusBillMatchHelper().writebackMatchBillAndSetBillComprehensive(Collections.singletonList(redConfirmBill));
            if (result != null) {
                return result;
            }
            return ResponseVo.success((String)this.createReturnJson(redConfirmBill));
        }
        String invoiceType = requestDTO.getInvoiceType();
        if (StringUtils.isNotEmpty((CharSequence)invoiceType) && (InvoiceUtils.isAllEVehicleInv((String)invoiceType) || InvoiceUtils.isUsedCarInvoice((Object)invoiceType))) {
            return this.alleVehicleInvoiceRed(requestDTO, account);
        }
        return this.alleInvoiceRed(requestDTO, account);
    }

    private ApiResult alleInvoiceRed(RedConfirmApplyRequestDTO requestDTO, String account) {
        boolean isLeqiChannel;
        if (QueryServiceHelper.exists((String)"sim_vatinvoice", (QFilter[])new QFilter("orderno", "=", (Object)requestDTO.getOrderNo()).toArray())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.NON_INV_CODE_NUM.getCode(), (String)ResManager.loadKDString((String)"\u6d41\u6c34\u53f7\u5df2\u5728\u53d1\u7968\u4e2d\u5b58\u5728", (String)"RedConfirmBillApplyServiceImpl_5", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        DynamicObject blueInvoiceDO = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "invoicestatus", "invoiceamount"), (QFilter[])InvoiceQFilterUtil.getInvoiceByCodeAndNo((String)requestDTO.getInvoiceCode(), (String)requestDTO.getInvoiceNo()).toArray());
        if (blueInvoiceDO == null) {
            return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_CANCEL_NO_INVOICE.getCode(), (String)ResManager.loadKDString((String)"\u539f\u84dd\u7968\u4e0d\u5b58\u5728\uff01", (String)"RedConfirmBillApplyServiceImpl_6", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        blueInvoiceDO = BusinessDataServiceHelper.loadSingle((Object)blueInvoiceDO.getPkValue(), (String)"sim_vatinvoice");
        DynamicObject redConfirm = null;
        String specialType = blueInvoiceDO.getString("specialtype");
        String sellerTaxpayerId = blueInvoiceDO.getString("salertaxno");
        String buyerTaxpayerId = blueInvoiceDO.getString("buyertaxno");
        String taxNo = sellerTaxpayerId;
        if ("E12".equals(specialType) || "02".equals(specialType)) {
            taxNo = buyerTaxpayerId;
        }
        DynamicObject buyerOrg = null;
        if ("02".equals(specialType)) {
            if ("2".equals(requestDTO.getApplicant())) {
                return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_CANCEL_NO_INVOICE.getCode(), (String)ResManager.loadKDString((String)"\u519c\u4ea7\u54c1\u6536\u8d2d\u7968\u8d2d\u9500\u8eab\u4efd\u4e0d\u80fd\u662f\u9500\u65b9", (String)"RedConfirmBillApplyServiceImpl_10", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
        } else {
            QFilter filter = new QFilter("number", "=", (Object)buyerTaxpayerId);
            DynamicObject epInfo = BusinessDataServiceHelper.loadSingle((String)"bdm_enterprise_baseinfo", (String)"name,number", (QFilter[])filter.toArray());
            if (epInfo == null) {
                if (!"2".equals(requestDTO.getApplicant())) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_CANCEL_NO_INVOICE.getCode(), (String)ResManager.loadKDString((String)"\u975e\u6536\u8d2d\u7968\uff0c\u5982\u679c\u8d2d\u65b9\u4e0d\u5728\u661f\u701a\uff0c\u53ea\u80fd\u662f\u9500\u65b9\u53d1\u8d77\u5f55\u5165", (String)"RedConfirmBillApplyServiceImpl_11", (String)"imc-sim-webapi", (Object[])new Object[0]));
                }
            } else {
                SaleInfo saleInfoByOrg = TaxUtils.getSaleInfoByOrg((Long)DynamicObjectUtil.getDynamicObjectLongValue((Object)blueInvoiceDO.get("orgid")));
                if (saleInfoByOrg.getSaleTaxNo().equals(sellerTaxpayerId) && "1".equals(requestDTO.getApplicant())) {
                    buyerOrg = TaxUtils.getOrgDynamicObjectByTaxNo((String)buyerTaxpayerId);
                }
            }
        }
        if (!(isLeqiChannel = EnterpriseHelper.isLqptChannel((String)taxNo)) && StringUtils.isBlank((CharSequence)ImcConfigUtil.getValue((String)"bdm_ek_service", (String)"AllEleService"))) {
            if (StringUtils.isNotBlank((CharSequence)account)) {
                String msg = AllEleAuthHelper.checkIssueAccount((String)taxNo, (String)account);
                if (StringUtils.isNotBlank((CharSequence)msg)) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)msg);
                }
            } else {
                account = AllEleAuthHelper.getEleAccount((String)taxNo, (boolean)true);
            }
        }
        requestDTO.setAccount(account);
        boolean isAllRed = false;
        if (requestDTO.getInvoiceDetail() == null || requestDTO.getInvoiceDetail().isEmpty()) {
            isAllRed = true;
        } else {
            BigDecimal limitRed = blueInvoiceDO.getBigDecimal("remainredamount");
            if (MathUtils.isZero((BigDecimal)limitRed)) {
                return ResponseVo.fail((String)EInvoiceErrCodeEnum.AllE_RED_20025.getCode(), (String)EInvoiceErrCodeEnum.AllE_RED_20025.getMsg());
            }
            String errorMsg = ApiRedService.dealCheckInvoiceDetailMethod(requestDTO.getOrderNo(), requestDTO.getInvoiceDetail(), blueInvoiceDO.getString("specialtype"));
            if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
                return ResponseVo.fail((String)EInvoiceErrCodeEnum.ERROR.getCode(), (String)errorMsg);
            }
            BigDecimal redTotalAmount = ApiRedService.checkRedItems(requestDTO.getInvoiceDetail());
            if (limitRed.compareTo(redTotalAmount.abs()) < 0) {
                return ResponseVo.fail((String)EInvoiceErrCodeEnum.AllE_RED_20019.getCode(), (String)String.format(ResManager.loadKDString((String)"\u8d85\u8fc7\u53ef\u7ea2\u51b2\u9650\u989d\uff0c\u5269\u4f59\u53ef\u7ea2\u51b2\u91d1\u989d\uff08\u4e0d\u542b\u7a0e\uff09\u4e3a:%s", (String)"RedConfirmBillApplyServiceImpl_7", (String)"imc-sim-webapi", (Object[])new Object[0]), limitRed.setScale(2, 4).toPlainString()));
            }
            if (redTotalAmount.abs().compareTo(blueInvoiceDO.getBigDecimal("invoiceamount")) == 0) {
                isAllRed = true;
            } else {
                OperationResult operationResult;
                if ("2".equals(requestDTO.getRedReason())) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_CANCEL_NO_INVOICE.getCode(), (String)ResManager.loadKDString((String)"\u5f00\u7968\u6709\u8bef\u4e0d\u80fd\u90e8\u5206\u7ea2\u51b2", (String)"RedConfirmBillApplyServiceImpl_8", (String)"imc-sim-webapi", (Object[])new Object[0]));
                }
                requestDTO.setRedReason(RedConfirmBillRedReasonEnum.getCodeByBillCode((String)requestDTO.getRedReason()));
                redConfirm = BusinessDataServiceHelper.newDynamicObject((String)"sim_red_confirm_bill");
                DynamicObjectUtil.copyDynamicObject((DynamicObject)blueInvoiceDO, (DynamicObject)redConfirm);
                redConfirm.set("issuetime", null);
                redConfirm.set("remark", null);
                this.buildPartRedMain(requestDTO, blueInvoiceDO, redConfirm);
                RedConfirmBillHelper.setBuyerAndSalerInfo((DynamicObject)redConfirm, (DynamicObject)blueInvoiceDO);
                PartRedService partRedService = new PartRedService();
                partRedService.buildRedConfirmItem(blueInvoiceDO, requestDTO.getInvoiceDetail(), requestDTO.getRedReason(), redConfirm);
                if (StringUtils.isNotEmpty((CharSequence)requestDTO.getApplicant())) {
                    redConfirm.set("applicant", (Object)requestDTO.getApplicant());
                }
                if (buyerOrg != null) {
                    redConfirm.set("createorg", (Object)buyerOrg);
                    redConfirm.set("useorg", (Object)buyerOrg);
                    redConfirm.set("enteridentity", (Object)"1");
                }
                if (!(operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"sim_red_confirm_bill", (DynamicObject[])new DynamicObject[]{redConfirm}, null)).isSuccess()) {
                    throw new MsgException(ApiErrCodeEnum.NON_INV_CODE_NUM.getCode(), OperationConstant.getErrorMsg((OperationResult)operationResult));
                }
            }
        }
        if (isAllRed) {
            OperationResult operationResult;
            redConfirm = RedConfirmBillHelper.formatRedConfirm((String)"", (String)requestDTO.getOrderNo(), (String)RedConfirmBillRedReasonEnum.getCodeByBillCode((String)requestDTO.getRedReason()), (DynamicObject)blueInvoiceDO, (String)account);
            if (StringUtils.isNotBlank((CharSequence)account) && !isLeqiChannel) {
                redConfirm.set("drawer", (Object)AllEleAuthHelper.getDrawerByAccount((String)taxNo, (String)account));
            }
            redConfirm.set("interfacecode", (Object)OpenApiInterfaceCodeEnum.REDCONFIRMBILL_APPLY.getCode());
            redConfirm.set("remark", (Object)requestDTO.getRemark());
            String errorMsg = ApiRedService.dealCheckInvoiceDetailMethod(requestDTO.getOrderNo(), requestDTO.getInvoiceDetail(), blueInvoiceDO.getString("specialtype"));
            if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
                return ResponseVo.fail((String)EInvoiceErrCodeEnum.ERROR.getCode(), (String)errorMsg);
            }
            if (StringUtils.isNotEmpty((CharSequence)requestDTO.getApplicant())) {
                redConfirm.set("applicant", (Object)requestDTO.getApplicant());
            }
            if (buyerOrg != null) {
                redConfirm.set("createorg", (Object)buyerOrg);
                redConfirm.set("useorg", (Object)buyerOrg);
                redConfirm.set("enteridentity", (Object)"1");
            }
            if (!(operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"sim_red_confirm_bill", (DynamicObject[])new DynamicObject[]{redConfirm}, null)).isSuccess()) {
                throw new MsgException(ApiErrCodeEnum.NON_INV_CODE_NUM.getCode(), OperationConstant.getErrorMsg((OperationResult)operationResult));
            }
        }
        ApiResult result = RedConfirmBillHelper.submit(redConfirm);
        new MinusBillMatchHelper().writebackMatchBillAndSetBillComprehensive(Collections.singletonList(redConfirm));
        if (result != null) {
            return result;
        }
        RedConfirmBillMailHelper.sendEmailImm((DynamicObject)redConfirm);
        return ResponseVo.success((String)this.createReturnJson(redConfirm));
    }

    private void buildPartRedMain(RedConfirmApplyRequestDTO requestDTO, DynamicObject blueInvoiceDO, DynamicObject redConfirm) {
        String drawer;
        redConfirm.set("orderno", (Object)requestDTO.getOrderNo());
        redConfirm.set("org", blueInvoiceDO.get("orgid"));
        redConfirm.set("useorg", blueInvoiceDO.get("orgid"));
        redConfirm.set("createorg", blueInvoiceDO.get("orgid"));
        redConfirm.set("remark", (Object)requestDTO.getRemark());
        redConfirm.set("ctrlstrategy", (Object)"7");
        redConfirm.set("issuestatus", (Object)IssueStatusEnum.none.getCode());
        redConfirm.set("originalinvoiceno", blueInvoiceDO.get("invoiceno"));
        redConfirm.set("originalinvoicecode", blueInvoiceDO.get("invoicecode"));
        redConfirm.set("invoiceno", (Object)"");
        redConfirm.set("originalissuetime", blueInvoiceDO.get("issuetime"));
        String originalInvoiceType = blueInvoiceDO.getString("invoicetype");
        redConfirm.set("originalinvoicetype", (Object)originalInvoiceType);
        redConfirm.set("invoicetype", (Object)InvoiceType.blueTypeToAllEType((String)originalInvoiceType));
        String specialType = InvoiceSpecialType.InvoiceSpecialTypeEnum.getCodeBySpecialType((String)blueInvoiceDO.getString("specialtype"));
        redConfirm.set("specialtype", (Object)specialType);
        redConfirm.set("systemsource", (Object)blueInvoiceDO.getString("systemsource"));
        redConfirm.set("uploadstatus", (Object)"0");
        if ("02".equals(specialType)) {
            redConfirm.set("applicant", (Object)RedInfoConstant.ApplicantEnum.BUYERNODEDUCTED.getCode());
            redConfirm.set("enteridentity", (Object)"1");
        } else {
            redConfirm.set("applicant", (Object)RedInfoConstant.ApplicantEnum.SALER.getCode());
            redConfirm.set("enteridentity", (Object)"0");
        }
        redConfirm.set("redreason", (Object)requestDTO.getRedReason());
        redConfirm.set("source", (Object)"4");
        redConfirm.set("status", (Object)BillHelper.getBillStatusByTableName((String)"sim_red_confirm_bill", (String)redConfirm.getString("source")));
        redConfirm.set("enable", (Object)"1");
        redConfirm.set("creator", (Object)RequestContext.get().getUserId());
        redConfirm.set("account", (Object)requestDTO.getAccount());
        boolean isLeqiChannel = EnterpriseHelper.isLqptChannel((String)blueInvoiceDO.getString("salertaxno"));
        if (StringUtils.isNotBlank((CharSequence)requestDTO.getAccount()) && !isLeqiChannel && StringUtils.isNotBlank((CharSequence)(drawer = AllEleAuthHelper.getDrawerByAccount((String)blueInvoiceDO.getString("salertaxno"), (String)requestDTO.getAccount())))) {
            redConfirm.set("drawer", (Object)drawer);
        }
        redConfirm.set("invoiceamount", (Object)redConfirm.getBigDecimal("invoiceamount").negate());
        redConfirm.set("totaltax", (Object)redConfirm.getBigDecimal("totaltax").negate());
        redConfirm.set("totalamount", (Object)redConfirm.getBigDecimal("totalamount").negate());
        redConfirm.set("interfacecode", (Object)OpenApiInterfaceCodeEnum.REDCONFIRMBILL_APPLY.getCode());
    }

    private String createReturnJson(DynamicObject redConfirmBill) {
        JSONObject json = new JSONObject();
        json.put("number", (Object)redConfirmBill.getString("number"));
        json.put("govRedConfirmBillUuid", (Object)redConfirmBill.getString("govuuid"));
        json.put("confirmStatus", (Object)redConfirmBill.getString("confirmstatus"));
        return json.toJSONString();
    }

    private ApiResult alleVehicleInvoiceRed(RedConfirmApplyRequestDTO requestDTO, String account) {
        DynamicObject redConfirm;
        OperationResult operationResult;
        if (!RedConfirmBillRedReasonEnum.INVOICE_ERR.getBillCode().equals(requestDTO.getRedReason()) && !RedConfirmBillRedReasonEnum.SALES_RETURN.getBillCode().equals(requestDTO.getRedReason())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.NON_INV_CODE_NUM.getCode(), (String)String.format(ResManager.loadKDString((String)"%s\u7ea2\u51b2\u539f\u56e0\u4ec5\u652f\u6301\u5f00\u7968\u6709\u8bef\u548c\u9500\u8d27\u9000\u56de", (String)"RedConfirmBillApplyServiceImpl_13", (String)"imc-sim-webapi", (Object[])new Object[0]), InvoiceType.getDescription((String)requestDTO.getInvoiceType())));
        }
        if (QueryServiceHelper.exists((String)"sim_vatinvoice_vehicles", (QFilter[])new QFilter("orderno", "=", (Object)requestDTO.getOrderNo()).toArray())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.NON_INV_CODE_NUM.getCode(), (String)ResManager.loadKDString((String)"\u6d41\u6c34\u53f7\u5df2\u5728\u53d1\u7968\u4e2d\u5b58\u5728", (String)"RedConfirmBillApplyServiceImpl_5", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        QFilter filter = new QFilter("invoicecode", "=", (Object)requestDTO.getInvoiceCode()).and("invoiceno", "=", (Object)requestDTO.getInvoiceNo());
        DynamicObject vehicleInvoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice_vehicles", (String)String.join((CharSequence)",", "invoicestatus", "invoiceamount"), (QFilter[])filter.toArray());
        if (vehicleInvoice == null) {
            return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_CANCEL_NO_INVOICE.getCode(), (String)ResManager.loadKDString((String)"\u539f\u84dd\u7968\u4e0d\u5b58\u5728\uff01", (String)"RedConfirmBillApplyServiceImpl_6", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (!(vehicleInvoice = BusinessDataServiceHelper.loadSingle((Object)vehicleInvoice.getPkValue(), (String)"sim_vatinvoice_vehicles")).getString("invoicetype").equals(requestDTO.getInvoiceType())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.NON_INV_CODE_NUM.getCode(), (String)ResManager.loadKDString((String)"\u8bf7\u6c42\u53d1\u7968\u7c7b\u578b\u4e0e\u53d1\u7968\u53f7\u7801\u5bf9\u5e94\u53d1\u7968\u7c7b\u578b\u4e0d\u4e00\u81f4", (String)"RedConfirmBillApplyServiceImpl_12", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        String taxNo = vehicleInvoice.getString("salertaxno");
        if (InvoiceUtils.isUsedCarInvoice((Object)vehicleInvoice.getString("invoicetype"))) {
            taxNo = vehicleInvoice.getString("issuetaxno");
        }
        if (StringUtils.isNotBlank((CharSequence)account)) {
            String msg = AllEleAuthHelper.checkIssueAccount((String)taxNo, (String)account);
            if (StringUtils.isNotBlank((CharSequence)msg)) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)msg);
            }
        } else {
            account = AllEleAuthHelper.getEleAccount((String)taxNo, (boolean)true);
        }
        if (!(operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"sim_red_confirm_bill", (DynamicObject[])new DynamicObject[]{redConfirm = RedConfirmBillHelper.formatRedConfirmFromVehicle((String)requestDTO.getOrderNo(), (String)requestDTO.getRedReason(), (DynamicObject)vehicleInvoice, (String)account)}, null)).isSuccess()) {
            throw new MsgException(ApiErrCodeEnum.NON_INV_CODE_NUM.getCode(), OperationConstant.getErrorMsg((OperationResult)operationResult));
        }
        redConfirm.set("id", operationResult.getSuccessPkIds().get(0));
        ApiResult result = RedConfirmBillHelper.submit((DynamicObject)redConfirm);
        if (result != null) {
            return result;
        }
        return ResponseVo.success((String)this.createReturnJson(redConfirm));
    }
}

