/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.redconfirm;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.allele.AllEleInterfaceTypeEnum;
import kd.imc.bdm.common.dto.allele.AllEleRequestDTO;
import kd.imc.bdm.common.dto.allele.AllEleResponseDTO;
import kd.imc.bdm.common.dto.allele.AllEleResponseListDTO;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.AllEleServiceHelper;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.helper.RedConfirmHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.lqpt.model.request.base.redconfirmdownload.RedConfirmDetailRequest;
import kd.imc.bdm.lqpt.model.request.base.redconfirmdownload.RedConfirmDownloadHeadRequest;
import kd.imc.bdm.lqpt.model.response.base.redconfirmdownload.RedConfirmDetailResponse;
import kd.imc.bdm.lqpt.model.response.base.redconfirmdownload.RedConfirmDownloadHeadItem;
import kd.imc.bdm.lqpt.model.response.base.redconfirmdownload.RedConfirmDownloadHeadResponse;
import kd.imc.sim.common.dto.allele.redconfirm.AllEleRedConfirmDownLoadRequestDTO;
import kd.imc.sim.common.dto.allele.redconfirm.AllEleRedConfirmDownLoadResponseDTO;
import kd.imc.sim.common.dto.allele.redconfirm.AllEleRedConfirmItemDownLoadRequestDTO;
import kd.imc.sim.common.helper.allele.ApiAllEHelper;
import kd.imc.sim.common.result.redconfirm.AllEleRedConfirmItemQueryResponseVo;
import kd.imc.sim.common.result.redconfirm.AllEleRedConfirmQueryResponseVo;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.common.vo.redconfirm.RedConfirmQueryRequestDTO;
import kd.imc.sim.formplugin.openapi.service.OpenApiService;
import kd.imc.sim.formplugin.redconfirm.helper.RedConfirmBillHelper;
import org.apache.commons.beanutils.BeanUtils;

public class RedConfirmBillQueryServiceImpl
implements OpenApiService {
    private static final Log log = LogFactory.getLog(RedConfirmBillQueryServiceImpl.class);

    @Override
    public ApiResult processer(RequestVo requestVo) {
        if (log.isInfoEnabled()) {
            log.info(String.format("\u4e1a\u52a1\u7cfb\u7edf[%s]\u67e5\u8be2\u7ea2\u5b57\u786e\u8ba4\u5355\u4f20\u5165\u53c2\u6570[%s]", requestVo.getBusinessSystemCode(), requestVo.getData()));
        }
        try {
            RedConfirmQueryRequestDTO requestDTO = (RedConfirmQueryRequestDTO)((Object)JSONObject.parseObject((String)requestVo.getData(), RedConfirmQueryRequestDTO.class));
            this.checkAndInitQueryParam(requestDTO);
            SaleInfo saleInfo = this.getSaleInfo(requestDTO);
            if (!EnterpriseHelper.isLqptChannel((String)saleInfo.getSaleTaxNo())) {
                if (StringUtils.isNotEmpty((CharSequence)requestDTO.getRedInfoBillNo())) {
                    this.setGovUuid(saleInfo.getOrgId(), requestDTO);
                }
                String account = requestDTO.getAccount();
                String taxNo = saleInfo.getSaleTaxNo();
                if (StringUtils.isNotBlank((CharSequence)account)) {
                    String msg = AllEleAuthHelper.checkIssueAccount((String)taxNo, (String)account);
                    if (StringUtils.isNotBlank((CharSequence)msg)) {
                        return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)msg);
                    }
                } else {
                    account = AllEleAuthHelper.getEleAccount((String)taxNo, (boolean)true);
                }
                requestDTO.setAccount(account);
                ApiResult result = ApiAllEHelper.alleLoginCheck((String)saleInfo.getSaleTaxNo(), (String)requestDTO.getAccount());
                if (result != null) {
                    throw new MsgException(result.getErrorCode(), result.getMessage());
                }
                return ResponseVo.success((String)SerializationUtils.toJsonString((Object)this.downloadRedConfirmBill(requestDTO, saleInfo)));
            }
            requestDTO.setRedConfirmBillNo(requestDTO.getRedInfoBillNo());
            long queryTimes = BigDecimalUtil.transDecimal((Object)ImcConfigUtil.getValue((String)"sim_lqpt_redfirm", (String)"query_times")).longValue();
            long maxTime = 0L;
            if (queryTimes > 1L) {
                maxTime = 60000L / queryTimes;
            }
            long statrt = System.currentTimeMillis();
            ApiResult result = ResponseVo.success((String)SerializationUtils.toJsonString((Object)this.downloadRedConfirmByLq(requestDTO, saleInfo)));
            long costTime = System.currentTimeMillis() - statrt;
            if (costTime < maxTime - 10L) {
                log.info("\u7ea2\u5b57\u786e\u8ba4\u5355\u67e5\u8be2\u7b49\u5f85{}", (Object)(maxTime - costTime));
                try {
                    Thread.sleep(maxTime - costTime);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return result;
        }
        catch (MsgException e) {
            log.error("\u7ea2\u5b57\u786e\u8ba4\u5355\u67e5\u8be2\u63a5\u53e3\u8fd4\u56de\u53c2\u6570\u4e3a\uff1a", (Throwable)e);
            return ResponseVo.fail((String)(StringUtils.isEmpty((CharSequence)e.getErrorCode()) ? ApiErrCodeEnum.ERROR.getCode() : e.getErrorCode()), (String)(StringUtils.isEmpty((CharSequence)e.getMessage()) ? ResManager.loadKDString((String)"\u67e5\u8be2\u7ea2\u5b57\u786e\u8ba4\u5355\u51fa\u9519", (String)"RedConfirmBillQueryServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]) : e.getMessage()));
        }
    }

    private void setGovUuid(Long orgPk, RedConfirmQueryRequestDTO param) {
        QFilter filter = RedConfirmHelper.getFilter((String)param.getRedInfoBillNo(), (Long)orgPk);
        DynamicObject recConfirm = BusinessDataServiceHelper.loadSingle((String)"sim_red_confirm_bill", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_red_confirm_bill", (boolean)false), (QFilter[])filter.toArray());
        if (null == recConfirm || StringUtils.isEmpty((CharSequence)recConfirm.getString("govuuid"))) {
            throw new MsgException(ApiErrCodeEnum.ILLEGAL_PARAM.getCode(), ResManager.loadKDString((String)"RPA\u4e0d\u652f\u6301\u6309\u7ea2\u5b57\u786e\u8ba4\u5355\u7f16\u53f7\u4e0b\u8f7d\uff0c\u5982\u9700\u83b7\u53d6\u786e\u8ba4\u5355\u6700\u65b0\u72b6\u6001\uff0c\u8bf7\u5148\u5c06\u786e\u8ba4\u5355\u4e0b\u8f7d\u81f3\u53d1\u7968\u4e91", (String)"RedConfirmBillQueryServiceImpl_1", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        param.setGovRedConfirmBillUuid(recConfirm.getString("govuuid"));
        param.setSellerTaxpayerId(recConfirm.getString("salertaxno"));
    }

    private DynamicObject queryGovUuuid(Long orgPk, RedConfirmQueryRequestDTO param) {
        if (StringUtils.isNotBlank((CharSequence)param.getRedInfoBillNo())) {
            QFilter filter = RedConfirmHelper.getFilter((String)param.getRedInfoBillNo(), (Long)orgPk);
            DynamicObject recConfirm = QueryServiceHelper.queryOne((String)"sim_red_confirm_bill", (String)"govuuid,salertaxno", (QFilter[])filter.toArray());
            return recConfirm;
        }
        return null;
    }

    private AllEleRedConfirmDownLoadRequestDTO formatDownloadParam(RedConfirmQueryRequestDTO requestDTO, SaleInfo saleInfo) {
        try {
            AllEleRedConfirmDownLoadRequestDTO param = new AllEleRedConfirmDownLoadRequestDTO();
            BeanUtils.copyProperties((Object)param, (Object)((Object)requestDTO));
            param.setOrgId(saleInfo.getOrgId().longValue());
            param.setPage(requestDTO.getPage());
            param.setPageSize(requestDTO.getPageSize());
            return param;
        }
        catch (Exception e) {
            log.error("\u8d4b\u503c\u5f02\u5e38(formatDownloadParam)\uff1a", (Throwable)e);
            throw new MsgException(ApiErrCodeEnum.ERROR.getCode(), ResManager.loadKDString((String)"\u683c\u5f0f\u5316\u53c2\u6570\u5f02\u5e38", (String)"RedConfirmBillQueryServiceImpl_2", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
    }

    private JSONObject downloadRedConfirmByLq(RedConfirmQueryRequestDTO requestDTO, SaleInfo saleInfo) {
        AllEleRedConfirmDownLoadRequestDTO downLoadRequestDTO = this.formatDownloadParam(requestDTO, saleInfo);
        downLoadRequestDTO.setSalerTaxNo(saleInfo.getSaleTaxNo());
        DynamicObject redConfirm = this.queryGovUuuid(saleInfo.getOrgId(), requestDTO);
        JSONObject resultJson = new JSONObject();
        if (redConfirm != null) {
            RedConfirmDetailRequest lqDetailRequest = new RedConfirmDetailRequest();
            lqDetailRequest.setXsfnsrsbh(redConfirm.getString("salertaxno"));
            lqDetailRequest.setUuid(redConfirm.getString("govuuid"));
            lqDetailRequest.setHzqrdbh(requestDTO.getRedInfoBillNo());
            lqDetailRequest.setNsrsbh(saleInfo.getSaleTaxNo());
            RedConfirmDetailResponse detailResponse = RedConfirmBillHelper.queryRedConfirmDetailByLq((RedConfirmDetailRequest)lqDetailRequest);
            if (detailResponse != null) {
                resultJson.put("totalElement", (Object)"1");
                resultJson.put("pageNo", (Object)"1");
                resultJson.put("pageSize", (Object)"10");
                ArrayList<AllEleRedConfirmDownLoadResponseDTO> list = new ArrayList<AllEleRedConfirmDownLoadResponseDTO>(1);
                list.add(RedConfirmBillHelper.parseDownloadResponse((RedConfirmDetailResponse)detailResponse));
                resultJson.put("dataList", this.formatResultArray(list));
                new RedConfirmBillHelper().download(downLoadRequestDTO, list);
                return resultJson;
            }
            resultJson.put("totalElement", (Object)"0");
            resultJson.put("pageNo", (Object)"1");
            resultJson.put("pageSize", (Object)"10");
            resultJson.put("dataList", (Object)Collections.EMPTY_LIST);
            return resultJson;
        }
        RedConfirmDownloadHeadRequest lqRequest = RedConfirmBillHelper.formatLqRequest((AllEleRedConfirmDownLoadRequestDTO)requestDTO, (SaleInfo)saleInfo);
        RedConfirmDownloadHeadResponse lqResponse = RedConfirmBillHelper.queryRedConfirmListByLq((RedConfirmDownloadHeadRequest)lqRequest);
        List lqList = lqResponse.getList();
        resultJson.put("totalElement", (Object)lqResponse.getTotal());
        resultJson.put("pageNo", (Object)lqResponse.getPageNumber());
        resultJson.put("pageSize", (Object)lqResponse.getPageSize());
        if (lqList == null || lqList.isEmpty()) {
            resultJson.put("dataList", (Object)Collections.EMPTY_LIST);
            return resultJson;
        }
        ArrayList<AllEleRedConfirmDownLoadResponseDTO> responseLists = new ArrayList<AllEleRedConfirmDownLoadResponseDTO>(lqList.size());
        for (RedConfirmDownloadHeadItem lqObj : lqList) {
            RedConfirmDetailRequest lqDetailRequest = new RedConfirmDetailRequest();
            lqDetailRequest.setXsfnsrsbh(lqObj.getXsfnsrsbh());
            lqDetailRequest.setUuid(lqObj.getUuid());
            lqDetailRequest.setHzqrdbh(lqObj.getHzfpxxqrdbh());
            lqDetailRequest.setNsrsbh(saleInfo.getSaleTaxNo());
            RedConfirmDetailResponse detailResponse = RedConfirmBillHelper.queryRedConfirmDetailByLq((RedConfirmDetailRequest)lqDetailRequest);
            responseLists.add(RedConfirmBillHelper.parseDownloadResponse((RedConfirmDetailResponse)detailResponse));
        }
        if (!CollectionUtils.isEmpty(responseLists)) {
            new RedConfirmBillHelper().download(downLoadRequestDTO, responseLists);
        }
        resultJson.put("dataList", this.formatResultArray(responseLists));
        return resultJson;
    }

    private JSONObject downloadRedConfirmBill(RedConfirmQueryRequestDTO requestDTO, SaleInfo saleInfo) {
        JSONObject resultJson = new JSONObject();
        AllEleRedConfirmDownLoadRequestDTO downLoadRequestDTO = this.formatDownloadParam(requestDTO, saleInfo);
        List responseList = null;
        if (StringUtils.isNotEmpty((CharSequence)requestDTO.getGovRedConfirmBillUuid())) {
            resultJson.put("totalElement", (Object)1);
            resultJson.put("pageNo", (Object)requestDTO.getPage());
            resultJson.put("pageSize", (Object)requestDTO.getPageSize());
            responseList = new ArrayList<AllEleRedConfirmDownLoadResponseDTO>(1);
            AllEleRedConfirmDownLoadResponseDTO responseEntity = new AllEleRedConfirmDownLoadResponseDTO();
            responseEntity.setGovRedConfirmBillUuid(requestDTO.getGovRedConfirmBillUuid());
            responseEntity.setSalerTaxNo(requestDTO.getSellerTaxpayerId());
            responseList.add(responseEntity);
        } else {
            downLoadRequestDTO.setRequest_path(AllEleInterfaceTypeEnum.RED_CONFIRM_BILL_QUERY.getRequestPath());
            AllEleResponseListDTO response = AllEleServiceHelper.doPostList((String)saleInfo.getSaleTaxNo(), (AllEleRequestDTO)downLoadRequestDTO, AllEleRedConfirmDownLoadResponseDTO.class);
            if (!response.getSuccess().booleanValue()) {
                throw new MsgException(ApiErrCodeEnum.ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u7a0e\u5c40\u4e0b\u8f7d\u53d1\u7968\u5931\u8d25\uff1a%s", (String)"RedConfirmBillQueryServiceImpl_3", (String)"imc-sim-webapi", (Object[])new Object[0]), response.getDescription()));
            }
            resultJson.put("totalElement", (Object)response.getTotalElement());
            resultJson.put("pageNo", (Object)response.getPageNo());
            resultJson.put("pageSize", (Object)response.getPageSize());
            responseList = response.getData();
            if (responseList == null) {
                resultJson.put("dataList", (Object)Collections.EMPTY_LIST);
                return resultJson;
            }
        }
        ArrayList<AllEleRedConfirmDownLoadResponseDTO> responseLists = new ArrayList<AllEleRedConfirmDownLoadResponseDTO>(responseList.size());
        AllEleRedConfirmItemDownLoadRequestDTO itemRequest = new AllEleRedConfirmItemDownLoadRequestDTO();
        itemRequest.setRequest_path(AllEleInterfaceTypeEnum.RED_CONFIRM_BILL_DETAIL_QUERY.getRequestPath());
        for (int i = 0; i < responseList.size(); ++i) {
            itemRequest.setGovRedConfirmBillUuid(((AllEleRedConfirmDownLoadResponseDTO)responseList.get(i)).getGovRedConfirmBillUuid());
            itemRequest.setSalerTaxNo(((AllEleRedConfirmDownLoadResponseDTO)responseList.get(i)).getSalerTaxNo());
            AllEleResponseDTO detail = AllEleServiceHelper.doPost((String)saleInfo.getSaleTaxNo(), (AllEleRequestDTO)itemRequest, AllEleRedConfirmDownLoadResponseDTO.class);
            AllEleRedConfirmDownLoadResponseDTO data = (AllEleRedConfirmDownLoadResponseDTO)detail.getData();
            if (!detail.getSuccess().booleanValue()) continue;
            responseLists.add(data);
        }
        if (!CollectionUtils.isEmpty(responseLists)) {
            downLoadRequestDTO.setSalerTaxNo(saleInfo.getSaleTaxNo());
            new RedConfirmBillHelper().download(downLoadRequestDTO, responseLists);
        }
        resultJson.put("dataList", this.formatResultArray(responseLists));
        return resultJson;
    }

    private List<AllEleRedConfirmQueryResponseVo> formatResultArray(List<AllEleRedConfirmDownLoadResponseDTO> responseLists) {
        ArrayList<AllEleRedConfirmQueryResponseVo> resultList = new ArrayList<AllEleRedConfirmQueryResponseVo>(responseLists.size());
        responseLists.stream().forEach(dataObj -> {
            AllEleRedConfirmQueryResponseVo resultObj = new AllEleRedConfirmQueryResponseVo();
            resultObj.setGovRedConfirmBillUuid(dataObj.getGovRedConfirmBillUuid());
            resultObj.setRedConfirmBillStatus(dataObj.getRedConfirmBillStatus());
            resultObj.setRedInfoBillNo(dataObj.getRedConfirmBillNo());
            resultObj.setRedConfirmEnterDate(dataObj.getRedConfirmEnterDate());
            resultObj.setRedReason(dataObj.getRedReason());
            resultObj.setBuyerName(dataObj.getBuyerName());
            resultObj.setBuyerTaxpayerId(dataObj.getBuyerTaxNo());
            resultObj.setSellerName(dataObj.getSalerName());
            resultObj.setSellerTaxpayerId(dataObj.getSalerTaxNo());
            resultObj.setInvoiceNo(dataObj.getRedInvoiceNo());
            resultObj.setInvoiceNum(dataObj.getRedInvoiceNo());
            resultObj.setTotalAmount(dataObj.getRedInvoiceAmount());
            resultObj.setTotalTaxAmount(dataObj.getRedTaxAmount());
            resultObj.setInvoiceDate(dataObj.getRedInvoiceDate());
            resultObj.setOriginalInvoiceType(dataObj.getBlueInvoiceType());
            resultObj.setOriginalInvoiceCode(dataObj.getBlueInvoiceCode());
            resultObj.setOriginalInvoiceNumber(dataObj.getBlueInvoiceNo());
            resultObj.setEnterIdentity(dataObj.getEnterIdentity());
            resultObj.setOriginalInvoiceAmount(dataObj.getBlueInvoiceAmount());
            resultObj.setOriginalTotalTaxAmount(dataObj.getBlueTaxAmount());
            resultObj.setOriginalIssueTime(dataObj.getBlueInvoiceDate());
            ArrayList<AllEleRedConfirmItemQueryResponseVo> resultDetailList = new ArrayList<AllEleRedConfirmItemQueryResponseVo>(dataObj.getItems().size());
            dataObj.getItems().forEach(dataItemObj -> {
                AllEleRedConfirmItemQueryResponseVo resultDetailObj = new AllEleRedConfirmItemQueryResponseVo();
                resultDetailObj.setBlueInvoiceItemIndex(dataItemObj.getBlueInvoiceItemIndex());
                resultDetailObj.setIndex(dataItemObj.getIndex());
                resultDetailObj.setRevenueCode(dataItemObj.getGoodsCode());
                resultDetailObj.setGoodsName(dataItemObj.getGoodsName());
                resultDetailObj.setSpecification(dataItemObj.getSpecModel());
                resultDetailObj.setQuantity(dataItemObj.getNum());
                resultDetailObj.setPrice(dataItemObj.getUnitPrice());
                resultDetailObj.setUnits(dataItemObj.getUnit());
                resultDetailObj.setAmount(dataItemObj.getDetailAmount());
                resultDetailObj.setTaxAmount(dataItemObj.getTaxAmount());
                resultDetailObj.setTaxRate(dataItemObj.getTaxRate());
                resultDetailList.add(resultDetailObj);
            });
            resultObj.setInvoiceDetail(resultDetailList);
            resultList.add(resultObj);
        });
        return resultList;
    }

    private void checkAndInitQueryParam(RedConfirmQueryRequestDTO requestDTO) {
        if (requestDTO == null) {
            throw new MsgException(ApiErrCodeEnum.ILLEGAL_PARAM.getCode(), ResManager.loadKDString((String)"\u67e5\u8be2\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"RedConfirmBillQueryServiceImpl_4", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)requestDTO.getRedInfoBillNo())) {
            if (StringUtils.isEmpty((CharSequence)requestDTO.getIdentity())) {
                throw new MsgException(ApiErrCodeEnum.ILLEGAL_PARAM.getCode(), ResManager.loadKDString((String)"\u8d2d\u9500\u8eab\u4efd\u53c2\u6570\u5fc5\u987b\u4f20\u8f93", (String)"RedConfirmBillQueryServiceImpl_5", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            if (!StringUtils.equals((CharSequence)requestDTO.getIdentity(), (CharSequence)"0") && !StringUtils.equals((CharSequence)requestDTO.getIdentity(), (CharSequence)"1")) {
                throw new MsgException(ApiErrCodeEnum.ILLEGAL_PARAM.getCode(), ResManager.loadKDString((String)"\u8d2d\u9500\u8eab\u4efd\u679a\u4e3e\u503c\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"RedConfirmBillQueryServiceImpl_6", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            if (StringUtils.isEmpty((CharSequence)requestDTO.getStartDate()) || StringUtils.isEmpty((CharSequence)requestDTO.getEndDate())) {
                throw new MsgException(ApiErrCodeEnum.ILLEGAL_PARAM.getCode(), ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u3001\u7ed3\u675f\u65f6\u95f4\u4e3a\u5fc5\u586b\u9879\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"RedConfirmBillQueryServiceImpl_7", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            if (requestDTO.getPage() == 0 || requestDTO.getPageSize() == 0) {
                throw new MsgException(ApiErrCodeEnum.ILLEGAL_PARAM.getCode(), ResManager.loadKDString((String)"\u5206\u9875\u53c2\u6570\u4e3a\u5fc5\u586b\u9879\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"RedConfirmBillQueryServiceImpl_8", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            if (requestDTO.getPageSize() > 50) {
                throw new MsgException(ApiErrCodeEnum.ILLEGAL_PARAM.getCode(), ResManager.loadKDString((String)"\u5206\u9875\u6700\u5927\u4e3a50\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"RedConfirmBillQueryServiceImpl_9", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
        } else {
            if (requestDTO.getPage() == 0) {
                requestDTO.setPage(1);
            }
            if (requestDTO.getPageSize() == 0) {
                requestDTO.setPageSize(5);
            }
        }
    }

    private SaleInfo getSaleInfo(RedConfirmQueryRequestDTO requestDTO) {
        DynamicObject orgDynamicObject;
        if (StringUtils.isNotBlank((CharSequence)requestDTO.getOrgCode())) {
            orgDynamicObject = TaxUtils.getOrgDynamicObjectByOrgNumber((String)requestDTO.getOrgCode());
        } else {
            if (StringUtils.isEmpty((CharSequence)requestDTO.getTaxpayerId())) {
                throw new MsgException(ApiErrCodeEnum.NON_SELLER_INFO.getCode(), ResManager.loadKDString((String)"\u4f01\u4e1a\u7a0e\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"RedConfirmBillQueryServiceImpl_10", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            orgDynamicObject = TaxUtils.getOrgDynamicObjectByTaxNo((String)requestDTO.getTaxpayerId());
        }
        return TaxUtils.getSaleInfoByOrgDynamicObject((DynamicObject)orgDynamicObject);
    }
}

