/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.vehicle;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.OperationConstant;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.AddressSplitHelper;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.UUID;
import kd.imc.bdm.file.util.Handle;
import kd.imc.sim.common.dto.vehicle.VehicleInvoiceIssueResponseDTO;
import kd.imc.sim.common.service.IssueInvoiceService;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.common.utils.TaxCalcUtil;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.openapi.dto.VehicleInvoiceOpenDTO;
import kd.imc.sim.formplugin.openapi.service.OpenApiService;
import kd.imc.sim.formplugin.openapi.service.impl.vehicle.VehicleInvoiceQueryServiceImpl;
import kd.imc.sim.formplugin.vehicle.validator.VehicleInvoiceValidator;
import kd.imc.sim.mq.consumer.service.IssueVehicleInvoiceServiceImpl;
import org.apache.commons.lang3.tuple.Pair;

public class VehicleInvoiceOpenServiceImpl
implements OpenApiService {
    protected static final Log log = LogFactory.getLog(VehicleInvoiceOpenServiceImpl.class);

    @Override
    public ApiResult processer(RequestVo requestVo) {
        String data = requestVo.getData();
        VehicleInvoiceOpenDTO vehicleInvoice = (VehicleInvoiceOpenDTO)((Object)JSONObject.parseObject((String)data, VehicleInvoiceOpenDTO.class));
        vehicleInvoice.setSystemSource(requestVo.getBusinessSystemCode());
        if (log.isInfoEnabled()) {
            log.info(String.format("\u4e1a\u52a1\u7cfb\u7edf[%s]\u8c03\u7528\u673a\u52a8\u8f66\u5f00\u7968\u4f20\u5165\u53c2\u6570[%s]", requestVo.getBusinessSystemCode(), data));
        }
        if (StringUtils.isBlank((CharSequence)vehicleInvoice.getSalerTaxNo())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_OPEN_SELLERTAXPAYERID.getCode(), (String)ApiErrCodeEnum.INVOICE_OPEN_SELLERTAXPAYERID.getMsg());
        }
        if (InvoiceUtils.isUsedCarInvoice((Object)vehicleInvoice.getInvoiceType()) && null == vehicleInvoice.getUsedCarInfo()) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ALLE_USEDCAR_NULL.getCode(), (String)ApiErrCodeEnum.ALLE_USEDCAR_NULL.getMsg());
        }
        SaleInfo saleInfo = TaxUtils.getSaleInfoByTaxNo((String)vehicleInvoice.getSalerTaxNo());
        DynamicObject invoice = this.queryInvoiceByBillNo(saleInfo.getOrgId(), vehicleInvoice.getSerialNo());
        if (invoice != null && StringUtils.isNotBlank((CharSequence)invoice.getString("invoicecode")) && StringUtils.isNotBlank((CharSequence)invoice.getString("invoiceno"))) {
            return ResponseVo.success((String)ResManager.loadKDString((String)"\u5f00\u7968\u6210\u529f", (String)"VehicleInvoiceOpenServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]), (Object)SerializationUtils.toJsonString((Object)VehicleInvoiceQueryServiceImpl.vehicleInvoiceObj2Bean(invoice)));
        }
        if (StringUtils.isBlank((CharSequence)vehicleInvoice.getInvoiceType())) {
            vehicleInvoice.setInvoiceType(InvoiceType.PAPER_VEHICLE_INVOICE.getTypeCode());
        }
        if (!InvoiceUtils.isVehicleInvoice((String)vehicleInvoice.getInvoiceType()) && !InvoiceUtils.isUsedCarInvoice((Object)vehicleInvoice.getInvoiceType())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ALLE_INVOICE_TYPE_FAIL.getCode(), (String)ApiErrCodeEnum.ALLE_INVOICE_TYPE_FAIL.getMsg());
        }
        if (InvoiceType.ALL_E_VEHICLE_NORMAL.getTypeCode().equals(vehicleInvoice.getInvoiceType()) || InvoiceType.ALL_E_VEHICLE_NORMAL_ELE.getTypeCode().equals(vehicleInvoice.getInvoiceType())) {
            if (StringUtils.isNotBlank((CharSequence)vehicleInvoice.getInvoiceCopyType()) && !"6".equals(vehicleInvoice.getInvoiceCopyType())) {
                return ResponseVo.fail((String)ApiErrCodeEnum.ALLE_LIANCI_ERROR.getCode(), (String)ApiErrCodeEnum.ALLE_LIANCI_ERROR.getMsg());
            }
        } else {
            vehicleInvoice.setInvoiceCopyType("");
        }
        if (String.valueOf(vehicleInvoice.getSystemSource()).length() > 20) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ALLE_SYSTEM_SOURCE_ERROR.getCode(), (String)ApiErrCodeEnum.ALLE_SYSTEM_SOURCE_ERROR.getMsg());
        }
        String account = vehicleInvoice.getAccount();
        if (StringUtils.isNotBlank((CharSequence)account)) {
            String taxNo = vehicleInvoice.getSalerTaxNo();
            String msg = AllEleAuthHelper.checkIssueAccount((String)taxNo, (String)account);
            if (StringUtils.isNotBlank((CharSequence)msg)) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)msg);
            }
        } else {
            account = AllEleAuthHelper.getEleAccount((String)vehicleInvoice.getSalerTaxNo(), (boolean)true);
            boolean isVirtual = StringUtils.isNotBlank((CharSequence)ImcConfigUtil.getValue((String)"all_ele_mock_invoice", (String)vehicleInvoice.getSalerTaxNo()));
            if (StringUtils.isEmpty((CharSequence)account) && !isVirtual) {
                return ResponseVo.fail((String)ApiErrCodeEnum.ALLE_NO_DEFAULT_ACCOUNT.getCode(), (String)ApiErrCodeEnum.ALLE_NO_DEFAULT_ACCOUNT.getMsg());
            }
        }
        vehicleInvoice.setAccount(account);
        if (invoice == null) {
            invoice = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice_vehicles");
            DynamicObjectUtil.bean2DynamicObject((Object)((Object)vehicleInvoice), (DynamicObject)invoice);
            if (InvoiceUtils.isUsedCarInvoice((Object)vehicleInvoice.getInvoiceType())) {
                DynamicObjectUtil.bean2DynamicObject((Object)vehicleInvoice.getUsedCarInfo(), (DynamicObject)invoice);
            }
            try {
                OperationResult operationResult;
                if (StringUtils.isNotEmpty((CharSequence)vehicleInvoice.getBuyerEmail())) {
                    VehicleInvoiceValidator.checkEmail((String)vehicleInvoice.getBuyerEmail());
                }
                if (StringUtils.isNotEmpty((CharSequence)vehicleInvoice.getRecipientPhone())) {
                    VehicleInvoiceValidator.checkPhone((String)vehicleInvoice.getRecipientPhone());
                }
                this.fillInInvoiceData(invoice, saleInfo);
                this.fillUsedCarIssueInfo(invoice, saleInfo, vehicleInvoice);
                if (!InvoiceUtils.isAllEVehicleInv((String)invoice.getString("invoicetype")) && !InvoiceUtils.isUsedCarInvoice((Object)invoice.getString("invoicetype"))) {
                    QFilter filter = new QFilter("equipmentno", "=", (Object)invoice.getString("jqbh"));
                    filter.and("authstatus", "=", (Object)"1");
                    filter.and("epinfo.number", "=", (Object)saleInfo.getSaleTaxNo());
                    DynamicObject taxEquipment = QueryServiceHelper.queryOne((String)"bdm_tax_equipment", (String)"id,disen", (QFilter[])filter.toArray());
                    if (taxEquipment == null) {
                        throw new MsgException(ApiErrCodeEnum.FIND_EQINFO_NOTFINDEQ.getCode(), String.format(ResManager.loadKDString((String)"\u9500\u65b9\u7a0e\u53f7[%1$s]\u4e0b\u4e0d\u5b58\u5728\u8bbe\u5907\u7f16\u53f7[%2$s]", (String)"VehicleInvoiceOpenServiceImpl_1", (String)"imc-sim-webapi", (Object[])new Object[0]), saleInfo.getSaleTaxNo(), invoice.getString("jqbh")));
                    }
                    if (!saleInfo.getDevNoList().contains(taxEquipment.getLong("id"))) {
                        throw new MsgException(ApiErrCodeEnum.FIND_EQINFO_NOTFINDEQ.getCode(), String.format(ResManager.loadKDString((String)"\u9500\u65b9\u7a0e\u53f7[%1$s]\u4e0b\u4e0d\u5b58\u5728\u8bbe\u5907\u7f16\u53f7[%2$s]", (String)"VehicleInvoiceOpenServiceImpl_1", (String)"imc-sim-webapi", (Object[])new Object[0]), saleInfo.getSaleTaxNo(), invoice.getString("jqbh")));
                    }
                    if ("0".equalsIgnoreCase(taxEquipment.getString("disen"))) {
                        throw new MsgException(ApiErrCodeEnum.INVOICE_DEV_DISABLE.getCode(), String.format(ResManager.loadKDString((String)"\u8bbe\u5907\u7f16\u53f7[%s]\u5df2\u88ab\u7981\u7528", (String)"VehicleInvoiceOpenServiceImpl_2", (String)"imc-sim-webapi", (Object[])new Object[0]), invoice.getString("jqbh")));
                    }
                }
                if (!(operationResult = OperationServiceHelper.executeOperate((String)"openinvoice", (String)"sim_vatinvoice_vehicles", (DynamicObject[])new DynamicObject[]{invoice}, null)).isSuccess()) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.VEHICLE_INVOICE_OPEN_PARAM_ERROR.getCode(), (String)OperationConstant.getErrorMsg((OperationResult)operationResult));
                }
            }
            catch (MsgException e) {
                return ResponseVo.fail((String)e.getErrorCode(), (String)e.getErrorMsg());
            }
        }
        VehicleInvoiceIssueResponseDTO response = IssueVehicleInvoiceServiceImpl.issueAllVehicleInvoice((DynamicObject)invoice);
        IssueInvoiceService.handleVehicleInvoiceIssueResponse((VehicleInvoiceIssueResponseDTO)response, (DynamicObject)invoice);
        if (ErrorType.SUCCESS.getCode().equals(response.getErrorCode())) {
            return ResponseVo.success((String)ResManager.loadKDString((String)"\u5f00\u7968\u6210\u529f", (String)"VehicleInvoiceOpenServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]), (Object)SerializationUtils.toJsonString((Object)VehicleInvoiceQueryServiceImpl.vehicleInvoiceObj2Bean(invoice)));
        }
        return ResponseVo.success((String)ApiErrCodeEnum.VEHICLE_INVOICE_SUBMIT_SUCCESS.getCode(), (Object)ApiErrCodeEnum.VEHICLE_INVOICE_SUBMIT_SUCCESS.getMsg());
    }

    private DynamicObject queryInvoiceByBillNo(long orgId, String billNo) {
        DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice_vehicles", (String)"", (QFilter[])new QFilter("orgid", "=", (Object)orgId).and("billno", "=", (Object)billNo).toArray());
        if (invoice != null) {
            invoice = BusinessDataServiceHelper.loadSingle((Object)invoice.getPkValue(), (String)"sim_vatinvoice_vehicles");
        }
        return invoice;
    }

    private void fillInInvoiceData(DynamicObject invoice, SaleInfo saleInfo) {
        DynamicObject buyerObj;
        String buyerName = invoice.getString("buyername");
        if (StringUtils.isNotBlank((CharSequence)buyerName) && (buyerObj = BusinessDataServiceHelper.loadSingle((String)"bdm_invice_title_strate", (String)String.join((CharSequence)",", "name", "buyertype", "idcode", "taxno"), (QFilter[])new QFilter("name", "=", (Object)buyerName).toArray())) != null) {
            String taxNo = "2".equals(buyerObj.getString("buyertype")) ? buyerObj.getString("idcode") : buyerObj.getString("taxno");
            this.fillInNullValue(invoice, "buyertaxno", taxNo);
        }
        Pair bankAndAccPair = AddressSplitHelper.splitBankAndName((String)saleInfo.getSaleBankAndBankAcc());
        this.fillInNullValue(invoice, "salerbankname", (String)bankAndAccPair.getKey());
        this.fillInNullValue(invoice, "saleraccount", (String)bankAndAccPair.getValue());
        Pair addrPhonePair = AddressSplitHelper.splitAddressAndTel((String)saleInfo.getSaleAddrAndPhone());
        this.fillInNullValue(invoice, "saleraddress", (String)addrPhonePair.getKey());
        this.fillInNullValue(invoice, "salerphone", (String)addrPhonePair.getValue());
        if (!InvoiceUtils.isAllEVehicleInv((String)invoice.getString("invoicetype")) && !InvoiceUtils.isUsedCarInvoice((Object)invoice.getString("invoicetype"))) {
            this.fillInNullValue(invoice, "jqbh", saleInfo.getDefaultDev());
            invoice.set("account", null);
        } else {
            invoice.set("jqbh", null);
        }
        BigDecimal totalAmount = invoice.getBigDecimal("totalamount");
        String taxRateStr = invoice.getString("taxrate");
        if (StringUtils.isNotBlank((CharSequence)taxRateStr) && BigDecimalUtil.isNumber((String)taxRateStr)) {
            BigDecimal tax = TaxCalcUtil.calTax((BigDecimal)totalAmount, (BigDecimal)BigDecimal.ZERO, (String)taxRateStr, (boolean)true);
            BigDecimal totalTax = invoice.getBigDecimal("totaltax");
            if (MathUtils.isNullOrZero((BigDecimal)totalTax)) {
                invoice.set("totaltax", (Object)tax);
            }
        }
        invoice.set("invoiceamount", (Object)invoice.getBigDecimal("totalamount").subtract(invoice.getBigDecimal("totaltax")));
        this.buildMainData(invoice, saleInfo);
    }

    private void buildMainData(DynamicObject invoice, SaleInfo saleInfo) {
        DynamicObject org = BusinessDataServiceHelper.newDynamicObject((String)"bos_org");
        org.set("id", (Object)saleInfo.getOrgId());
        invoice.set("orgid", (Object)org);
        invoice.set("issuetype", (Object)"0");
        invoice.set("billsource", (Object)"4");
        invoice.set("createtime", (Object)new Date());
        invoice.set("orderno", (Object)("vehicle_" + UUID.next()));
        if (StringUtils.isBlank((CharSequence)invoice.getString("invoicetype"))) {
            invoice.set("invoicetype", (Object)InvoiceType.PAPER_VEHICLE_INVOICE.getTypeCode());
        } else {
            String invoiceType = invoice.getString("invoicetype");
            if (!InvoiceUtils.isVehicleInvoice((String)invoiceType) && !InvoiceUtils.isUsedCarInvoice((Object)invoiceType)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u7968\u79cd\u7c7b\u4e0d\u5408\u6cd5", (String)"VehicleInvoiceOpenServiceImpl_3", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
        }
        if (InvoiceUtils.isVehicleInvoice((String)invoice.getString("invoicetype"))) {
            invoice.set("remark", (Object)"\u4e00\u8f66\u4e00\u7968");
        }
        invoice.set("issuestatus", (Object)IssueStatusEnum.none.getCode());
        invoice.set("checkcode", (Object)"");
        invoice.set("invaliddate", null);
        invoice.set("invoicestatus", (Object)"");
        invoice.set("issuetime", null);
        invoice.set("invoicecode", (Object)"");
        invoice.set("invoiceno", (Object)"");
        invoice.set("originalinvoicecode", (Object)"");
        invoice.set("originalinvoiceno", (Object)"");
        invoice.set("originalissuetime", null);
        if ("0".equals(invoice.get("version"))) {
            this.fillInNullValue(invoice, "buyercardno", invoice.getString("buyertaxno"));
        }
    }

    private void fillInNullValue(DynamicObject invoice, String key, String value) {
        String invoiceValue = invoice.getString(key);
        if (StringUtils.isBlank((CharSequence)invoiceValue)) {
            invoice.set(key, (Object)value);
        }
    }

    private void fillUsedCarIssueInfo(DynamicObject invoice, SaleInfo saleInfo, VehicleInvoiceOpenDTO vehicleInvoice) {
        DynamicObject[] nations;
        if (!InvoiceUtils.isUsedCarInvoice((Object)invoice.getString("invoicetype"))) {
            return;
        }
        String usedCarEnterpriseNature = this.getUsedCarEnterpriseNature(saleInfo.getOrgId());
        invoice.set("usedcarenterprisenature", (Object)usedCarEnterpriseNature);
        Pair bankAndAccPair = AddressSplitHelper.splitBankAndName((String)saleInfo.getSaleBankAndBankAcc());
        Pair addrPhonePair = AddressSplitHelper.splitAddressAndTel((String)saleInfo.getSaleAddrAndPhone());
        invoice.set("issuename", (Object)invoice.getString("salername"));
        invoice.set("issuetaxno", (Object)invoice.getString("salertaxno"));
        invoice.set("issueaddress", (Object)invoice.getString("saleraddress"));
        invoice.set("issuephone", (Object)invoice.getString("salerphone"));
        invoice.set("issuebankname", (Object)invoice.getString("salerbankname"));
        invoice.set("issuebankaccount", (Object)invoice.getString("saleraccount"));
        this.fillInNullValue(invoice, "issueaddress", (String)addrPhonePair.getKey());
        this.fillInNullValue(invoice, "issuephone", (String)addrPhonePair.getValue());
        this.fillInNullValue(invoice, "issuebankname", (String)bankAndAccPair.getKey());
        this.fillInNullValue(invoice, "issuebankaccount", (String)bankAndAccPair.getValue());
        invoice.set("salername", (Object)vehicleInvoice.getUsedCarInfo().getSellerName());
        invoice.set("salertaxno", (Object)vehicleInvoice.getUsedCarInfo().getSellerTaxNo());
        invoice.set("saleraddress", (Object)vehicleInvoice.getUsedCarInfo().getSellerrAddress());
        invoice.set("salerphone", (Object)vehicleInvoice.getUsedCarInfo().getSellerPhone());
        if (Handle.isEmpty((Object)invoice.getString("issueway"))) {
            invoice.set("issueway", (Object)"0");
        }
        String salerProperty = vehicleInvoice.getUsedCarInfo().getSellerProperty();
        String buyerProperty = vehicleInvoice.getUsedCarInfo().getBuyerProperty();
        if (StringUtils.isEmpty((CharSequence)salerProperty)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5356\u65b9\u6027\u8d28\u4e0d\u80fd\u4e3a\u7a7a", (String)"VehicleInvoiceOpenServiceImpl_5", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)salerProperty)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e70\u65b9\u6027\u8d28\u4e0d\u80fd\u4e3a\u7a7a", (String)"VehicleInvoiceOpenServiceImpl_6", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if ("08".equals(usedCarEnterpriseNature)) {
            if ("0".equals(invoice.getString("issueway")) && !"0".equals(salerProperty)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4f01\u4e1a\u8d44\u8d28\u662f\u4e8c\u624b\u8f66\u7ecf\u9500\u4f01\u4e1a\u65f6\u6b63\u5411\u5f00\u7968\u5356\u65b9\u6027\u8d28\u53ea\u80fd\u4e3a\u4f01\u4e1a", (String)"VehicleInvoiceOpenServiceImpl_7", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            if ("1".equals(invoice.getString("issueway")) && !"0".equals(buyerProperty)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4f01\u4e1a\u8d44\u8d28\u662f\u4e8c\u624b\u8f66\u7ecf\u9500\u4f01\u4e1a\u65f6\u53cd\u5411\u5f00\u7968\u4e70\u65b9\u6027\u8d28\u53ea\u80fd\u4e3a\u4f01\u4e1a", (String)"VehicleInvoiceOpenServiceImpl_8", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
        }
        DynamicObject[] defaultNations = InvoiceUtils.queryNations((String)"156");
        String salerNation = vehicleInvoice.getUsedCarInfo().getSellerNation();
        if ("1".equals(salerProperty)) {
            if (StringUtils.isNotEmpty((CharSequence)salerNation)) {
                nations = InvoiceUtils.queryNations((String)salerNation);
                invoice.set("nation", (Object)nations[0]);
            } else {
                invoice.set("nation", (Object)defaultNations[0]);
            }
        } else {
            invoice.set("nation", null);
        }
        if ("1".equals(buyerProperty)) {
            if (StringUtils.isNotEmpty((CharSequence)invoice.getString("buyernation"))) {
                nations = InvoiceUtils.queryNations((String)invoice.getString("buyernation"));
                invoice.set("buyernation", (Object)nations[0]);
            } else {
                invoice.set("buyernation", (Object)defaultNations[0]);
            }
        } else {
            invoice.set("buyernation", null);
        }
    }

    private String getUsedCarEnterpriseNature(long orgId) {
        DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)orgId, (String)"bdm_org");
        String usedCarEnterpriseNature = null;
        if (null != org) {
            QFilter filter = new QFilter("epinfo", "=", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)org.get("epinfo")));
            DynamicObject[] epInfos = BusinessDataServiceHelper.load((String)"bdm_enterprise_info", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_enterprise_info", (boolean)true), (QFilter[])filter.toArray());
            if (epInfos.length > 0) {
                String tobaccoMark = epInfos[0].getString("tobaccomark");
                if ("8".equals(tobaccoMark)) {
                    usedCarEnterpriseNature = "08";
                }
                if ("9".equals(tobaccoMark)) {
                    usedCarEnterpriseNature = "07";
                }
            }
        }
        if (null == usedCarEnterpriseNature || "07".equals(usedCarEnterpriseNature) && "08".equals(usedCarEnterpriseNature)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u4f01\u4e1a\u4e0d\u652f\u6301\u5f00\u4e8c\u624b\u8f66\u53d1\u7968", (String)"VehicleInvoiceOpenServiceImpl_4", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        return usedCarEnterpriseNature;
    }
}

