/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.scan;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.message.model.MsgRequest;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.message.send.SendMsg2Imac;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.MD5;
import kd.imc.sim.common.vo.openapi.RequestVo;

public class ImacScanService {
    private static final String IMAC_API_CREATE_WECHAT_URL = "createWeChatUrl";

    public static MsgResponse getWeChatScanUrl(DynamicObject[] dynamicBills, RequestVo requestVo) {
        MsgRequest request = new MsgRequest();
        request.setIdentifytype("imacSciiFromImc");
        request.setMsgType(IMAC_API_CREATE_WECHAT_URL);
        String businessSystemCode = requestVo.getBusinessSystemCode();
        ArrayList<JSONObject> requestJsonArray = new ArrayList<JSONObject>();
        for (DynamicObject billDO : dynamicBills) {
            DynamicObject qrKeyDO;
            QFilter qFilter;
            JSONObject requestJson = new JSONObject();
            requestJson.put("version", (Object)requestVo.getVersion());
            requestJson.put("billNo", billDO.get("billno"));
            requestJson.put("accountId", (Object)RequestContext.get().getAccountId());
            requestJson.put("tenantId", (Object)RequestContext.get().getTenantId());
            requestJson.put("systemCode", (Object)businessSystemCode);
            requestJson.put("billSource", billDO.get("billsource"));
            if (InvoiceUtils.isAllEInvoice((Object)billDO.getString("invoicetype"))) {
                qFilter = new QFilter("eqinfotaxno", "=", (Object)billDO.getString("salertaxno")).and("invoicetype", "like", (Object)('%' + billDO.getString("invoicetype") + '%'));
                qFilter.and("systemcode", "=", (Object)businessSystemCode);
                qrKeyDO = BusinessDataServiceHelper.loadSingle((String)"bdm_scaninvoice_setting", (String)"number", (QFilter[])qFilter.toArray());
                if (qrKeyDO == null) {
                    throw new MsgException(String.format(ResManager.loadKDString((String)"\u7a0e\u53f7[%s]\u8fd8\u672a\u914d\u7f6e\u52a8\u6001\u4e8c\u7ef4\u7801\u914d\u7f6e", (String)"ImacScanService_0", (String)"imc-sim-webapi", (Object[])new Object[0]), billDO.getString("salertaxno")));
                }
            } else {
                if (StringUtils.isEmpty((CharSequence)billDO.getString("jqbh"))) {
                    throw new MsgException(ResManager.loadKDString((String)"\u626b\u7801\u5f00\u7968\uff0c\u8bbe\u5907\u4e0d\u5b58\u5728\uff0c\u9700\u8981\u6307\u5b9a\u5f00\u7968\u8bbe\u5907", (String)"ImacScanService_1", (String)"imc-sim-webapi", (Object[])new Object[0]));
                }
                qFilter = new QFilter("eqinfono", "=", (Object)billDO.getString("jqbh"));
                qFilter.and("systemcode", "=", (Object)businessSystemCode);
                qrKeyDO = BusinessDataServiceHelper.loadSingle((String)"bdm_scaninvoice_setting", (String)"number", (QFilter[])qFilter.toArray());
                if (qrKeyDO == null) {
                    throw new MsgException(String.format(ResManager.loadKDString((String)"\u8bbe\u5907[%s]\u8fd8\u672a\u914d\u7f6e\u52a8\u6001\u4e8c\u7ef4\u7801\u914d\u7f6e", (String)"ImacScanService_2", (String)"imc-sim-webapi", (Object[])new Object[0]), billDO.getString("jqbh")));
                }
            }
            requestJson.put("qrKey", (Object)qrKeyDO.getString("number"));
            requestJson.put("md5", (Object)MD5.md5Hex((String)(qrKeyDO.getString("number") + billDO.get("billno"))));
            requestJson.put("billTotalAmount", billDO.get("totalamount"));
            requestJsonArray.add(requestJson);
        }
        request.setReqData(requestJsonArray);
        return SendMsg2Imac.send((MsgRequest)request, (String)"/kapi/app/imasm/imacWebService".concat("?access_token="));
    }
}

