/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.async;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.imc.bdm.common.constant.allele.AllEleInterfaceTypeEnum;
import kd.imc.bdm.common.dto.allele.AllEleRequestDTO;
import kd.imc.bdm.common.dto.allele.AllEleResponseDTO;
import kd.imc.bdm.common.helper.AllEleServiceHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.async.AbstractAsyncIssueHandler;
import kd.imc.sim.common.dto.allele.AllEleRedConfirmBillUploadResponseDTO;

public class LqCombineRedConfirmQueryImpl
extends AbstractAsyncIssueHandler {
    private static Log LOGGER = LogFactory.getLog(LqCombineRedConfirmQueryImpl.class);

    @Override
    public void handlerInvoice(List<DynamicObject> asyncInvoiceList) {
        Set redConfirmPks = asyncInvoiceList.stream().map(o -> Long.parseLong(o.getString("orderno"))).collect(Collectors.toSet());
        DynamicObject[] redConfirms = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_red_confirm_bill", (boolean)true), (QFilter[])new QFilter("id", "in", redConfirmPks).toArray());
        OperationServiceHelper.executeOperate((String)"btn_submit", (String)"sim_red_confirm_bill", (DynamicObject[])redConfirms, null);
    }

    public AllEleResponseDTO<AllEleRedConfirmBillUploadResponseDTO> queryRedConfirmUploadResult(DynamicObject asyncInvoice, DynamicObject redConfirmBill) {
        AllEleRequestDTO request = new AllEleRequestDTO();
        request.setBatchNo(asyncInvoice.getString("govorderno"));
        request.setOrderNo(redConfirmBill.getString("orderno"));
        request.setCombinePatch(AllEleInterfaceTypeEnum.RED_CONFIRM_RESULT_QUERY.getCombinePath());
        String taxNo = asyncInvoice.getString("salertaxno");
        asyncInvoice.set("querycount", (Object)(asyncInvoice.getInt("querycount") + 1));
        ImcSaveServiceHelper.save((DynamicObject)asyncInvoice);
        AllEleResponseDTO response = AllEleServiceHelper.doPost((String)taxNo, (AllEleRequestDTO)request, AllEleRedConfirmBillUploadResponseDTO.class);
        try (TXHandle tx = TX.required();){
            try {
                if (response.getSuccess().booleanValue()) {
                    AllEleRedConfirmBillUploadResponseDTO uploadResponse = (AllEleRedConfirmBillUploadResponseDTO)response.getData();
                    redConfirmBill.set("uploadstatus", (Object)"1");
                    redConfirmBill.set("uploaddate", (Object)DateUtils.stringToDate((String)uploadResponse.getRedConfirmEnterDate(), (String)"yyyy-MM-dd HH:mm:ss"));
                    redConfirmBill.set("govuuid", (Object)uploadResponse.getGovRedConfirmBillUuid());
                    redConfirmBill.set("number", (Object)uploadResponse.getRedConfirmBillNo());
                    redConfirmBill.set("confirmstatus", (Object)uploadResponse.getRedConfirmBillStatus());
                    redConfirmBill.set("failreason", (Object)"");
                    DeleteServiceHelper.delete((String)"sim_async_issue_invoice", (QFilter[])new QFilter("id", "=", (Object)asyncInvoice.getLong("id")).toArray());
                } else {
                    redConfirmBill.set("uploadstatus", (Object)"2");
                    redConfirmBill.set("failreason", (Object)response.getDescription());
                }
                ImcSaveServiceHelper.save((DynamicObject)redConfirmBill);
            }
            catch (Exception e) {
                tx.markRollback();
                LOGGER.error("queryRedConfirmUploadResultError" + e.getMessage(), (Throwable)e);
            }
        }
        return response;
    }
}

