/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.billcenter;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.dto.BillVo;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.sim.billcenter.BillCenterOrgMappingService;
import kd.imc.sim.common.model.billcenter.BillCenterVo;
import kd.imc.sim.common.model.billcenter.BillErrorVo;
import kd.sdk.annotation.SdkDeprecated;
import org.apache.commons.lang3.StringUtils;

public class BillCenterInvoiceCommonService {
    private static final Log logger = LogFactory.getLog(BillCenterInvoiceCommonService.class);
    private static final String ENTER_FLAG = "\n";
    private static final String SPECIAL_FLAG = "~";

    public DynamicObject dealLoadSingleObject(Long pkId) {
        return BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"sim_isomerism_bill_data");
    }

    public DynamicObject dealLoadIsomerismBillDataMethod(QFilter qFilter) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"sim_isomerism_bill_data", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (dynamicObject != null) {
            Long pkId = dynamicObject.getLong("id");
            return BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"sim_isomerism_bill_data");
        }
        return null;
    }

    @SdkDeprecated
    public DynamicObject getOrgMethod(String systemCode) {
        QFilter qFilter = new QFilter("system_code", "=", (Object)systemCode);
        DynamicObject orgObject = this.getOrgMethod(qFilter);
        if (orgObject == null) {
            String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u4e1a\u52a1\u7cfb\u7edf\u7684\u7ec4\u7ec7\u6620\u5c04\u5173\u7cfb\u672a\u5339\u914d\u5230\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\uff01", (String)"BillCenterInvoiceCommonService_5", (String)"imc-sim-service", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        return orgObject;
    }

    public DynamicObject getOrgMethod(QFilter qFilter) {
        BillCenterOrgMappingService billCenterOrgMappingService = new BillCenterOrgMappingService();
        DynamicObjectCollection dynamicObjectCollection = billCenterOrgMappingService.loadSourceTargetOrgMapping(qFilter);
        if (dynamicObjectCollection != null && dynamicObjectCollection.size() > 0) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(0);
            return dynamicObject.getDynamicObject("target_org_id");
        }
        return null;
    }

    public String getOrgNameMethod(String orgCode, String systemCode) {
        QFilter qFilter = new QFilter("number", "=", (Object)systemCode).and("sim_front_system_cfg.system_source_org.source_org_code", "=", (Object)orgCode);
        BillCenterOrgMappingService billCenterOrgMappingService = new BillCenterOrgMappingService();
        DynamicObject dynamicObject = billCenterOrgMappingService.loadSingle(qFilter);
        logger.info("\u6839\u636e\u7cfb\u7edf\u7f16\u7801\uff1a{}, \u7ec4\u7ec7\u7f16\u7801:{}, \u67e5\u8be2\u53d1\u7968\u4e91\u7ec4\u7ec7\u4fe1\u606f\u5bf9\u8c61\u662f\u5426\u5b58\u5728\uff1a{}", new Object[]{systemCode, orgCode, dynamicObject != null});
        if (dynamicObject != null) {
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("system_source_org");
            for (DynamicObject orgObject : dynamicObjectCollection) {
                String source_org_code = orgObject.getString("source_org_code");
                if (!orgCode.equals(source_org_code)) continue;
                return orgObject.getString("source_org_name");
            }
        }
        return null;
    }

    public String getSystemNameMethod(String systemCode) {
        BillCenterOrgMappingService billCenterOrgMappingService = new BillCenterOrgMappingService();
        QFilter qFilter = new QFilter("number", "=", (Object)systemCode);
        DynamicObject dynamicObject = billCenterOrgMappingService.loadSingle(qFilter);
        logger.info("\u6839\u636e\u7cfb\u7edf\u7f16\u7801\uff1a{}, \u67e5\u8be2\u53d1\u7968\u4e91\u7ec4\u7ec7\u4fe1\u606f\u5bf9\u8c61\u662f\u5426\u5b58\u5728\uff1a{}", (Object)systemCode, (Object)(dynamicObject != null ? 1 : 0));
        if (dynamicObject != null) {
            return dynamicObject.getString("name");
        }
        return null;
    }

    public DynamicObject getPaymentObjectMethod(String paymentMethod, Map<String, Set<String>> subErrorMsgMap, String systemCode) {
        QFilter qFilter = new QFilter("number", "=", (Object)paymentMethod).and("system_code", "=", (Object)systemCode);
        DynamicObject simPayObject = BusinessDataServiceHelper.loadSingle((String)"sim_pay_type", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (simPayObject != null) {
            Long pkId = simPayObject.getLong("id");
            if (!"C".equals((simPayObject = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"sim_pay_type")).getString("status"))) {
                if (subErrorMsgMap != null) {
                    this.dealAddErrorMsgMethod("approvalCode", paymentMethod, subErrorMsgMap);
                } else {
                    String errorMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u652f\u4ed8\u7f16\u7801:%1$s\uff0c\u672a\u5ba1\u6838\uff01", (String)"BillCenterInvoiceCommonService_4", (String)"imc-sim-service", (Object[])new Object[0]), paymentMethod);
                    throw new KDBizException(errorMsg);
                }
            }
            if ("0".equals(simPayObject.getString("enable"))) {
                if (subErrorMsgMap != null) {
                    this.dealAddErrorMsgMethod("disableCode", paymentMethod, subErrorMsgMap);
                } else {
                    String errorMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u652f\u4ed8\u7f16\u7801:%1$s\uff0c\u5df2\u7981\u7528\uff01", (String)"BillCenterInvoiceCommonService_3", (String)"imc-sim-service", (Object[])new Object[0]), paymentMethod);
                    throw new KDBizException(errorMsg);
                }
            }
        }
        return simPayObject;
    }

    @SdkDeprecated
    public DynamicObject dealCheckBillCenterDataMethod(String key, String value, String systemCode) {
        logger.info("dealCreateBillCenterDataMethod, systemCode:{}, key:{}, value:{}", new Object[]{systemCode, key, value});
        QFilter qFilter = new QFilter(key, "=", (Object)value).and("system_code", "=", (Object)systemCode);
        DynamicObject dynamicObject = this.dealLoadIsomerismBillDataMethod(qFilter);
        return dynamicObject;
    }

    public DynamicObjectCollection dealCheckBillCenterDataMethod(QFilter qFilter) {
        DynamicObject[] dynamicObjects;
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)"sim_isomerism_bill_data", (String)"id", (QFilter[])new QFilter[]{qFilter})) {
            Long pkId = dynamicObject.getLong("id");
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"sim_isomerism_bill_data");
            dynamicObjectCollection.add((Object)dynamicObject);
        }
        return dynamicObjectCollection;
    }

    public DynamicObject[] getBillCenterData(QFilter qFilter) {
        return BusinessDataServiceHelper.load((String)"sim_isomerism_bill_data", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_isomerism_bill_data", (boolean)true), (QFilter[])new QFilter[]{qFilter});
    }

    public boolean dealCheckAppOpKeyMethod(String paramContent) {
        JSONObject jsonObject = JSONObject.parseObject((String)paramContent);
        String opKey = jsonObject.getString("opKey");
        return "APP".equals(opKey);
    }

    public void dealCheckMoreThan30Method(List<BillVo> applyBillList) {
        ArrayList<BillErrorVo> billErrorVoList = new ArrayList<BillErrorVo>(applyBillList.size());
        Date nowDate = new Date();
        for (BillVo billVo : applyBillList) {
            String billNo = billVo.getBillNo();
            String billDate = billVo.getBillDate();
            Date bill_date = StringUtils.isEmpty((CharSequence)billDate) ? new Date() : DateUtils.stringToDate((String)billDate);
            int disDays = DateUtils.timeDifferenceDay((Date)bill_date, (Date)nowDate);
            logger.info("dealRecentlyOrderDataMethod, billNo:{}, disDays:{}", (Object)billNo, (Object)disDays);
            if (disDays <= 30) continue;
            BillErrorVo billErrorVo = new BillErrorVo();
            billErrorVo.setBillNo(billNo);
            billErrorVo.setFailNum(1);
            String errorMsg = ResManager.loadKDString((String)"\u8be5\u8ba2\u5355\u5df2\u7ecf\u8fc730\u5929\u6709\u6548\u671f\uff0c\u65e0\u6cd5\u81ea\u52a9\u5f00\u7968\uff0c\u5982\u9700\u5e2e\u52a9\u8bf7\u8054\u7cfb\u5ba2\u670d\u624b\u5de5\u5904\u7406!", (String)"BillCenterInvoiceCommonService_2", (String)"imc-sim-service", (Object[])new Object[0]);
            billErrorVo.setErrorMsg(errorMsg);
            billErrorVoList.add(billErrorVo);
        }
        logger.info("dealCheckMoreThan30Method, billErrorVoList\u5927\u5c0f:{}", (Object)billErrorVoList.size());
        if (billErrorVoList.size() > 0) {
            applyBillList.clear();
            applyBillList.addAll(billErrorVoList);
        }
    }

    @SdkDeprecated
    public void dealFormatBillDataMethod(DynamicObject dynamicObject, List<BillVo> applyBillList) {
        BillCenterVo billVo = new BillCenterVo();
        String billNo = dynamicObject.getString("billno");
        boolean flag = this.checkBillIsExistMethod(applyBillList, billNo);
        if (flag) {
            logger.error("\u5f53\u524d\u8ba2\u5355\u53f7:{}\uff0c\u5df2\u7ecf\u5728\u8d26\u5355\u8ba2\u5355\u5217\u8868\u4e2d\uff01", (Object)billNo);
            return;
        }
        billVo.setBillNo(billNo);
        Date bill_date = dynamicObject.getDate("bill_date");
        billVo.setBillDate(DateUtils.format((Date)bill_date));
        BigDecimal totalAmount = dynamicObject.getBigDecimal("total_amount");
        billVo.setIncludeTaxAmount(totalAmount);
        BigDecimal invoicable_amount = dynamicObject.getBigDecimal("invoicable_amount");
        logger.info("dealFormatBillDataMethod, billNo:{}, billDate:{}, totalAmount:{}, invoicable_amount:{}", new Object[]{billNo, bill_date, totalAmount, invoicable_amount});
        if (invoicable_amount == null || invoicable_amount.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        billVo.setConfirmAmount(invoicable_amount);
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("sim_isomerism_item_data");
        if (dynamicObjectCollection != null) {
            billVo.setGoodsName(((DynamicObject)dynamicObjectCollection.get(0)).getString("product_name"));
        }
        applyBillList.add((BillVo)billVo);
    }

    private boolean checkBillIsExistMethod(List<BillVo> applyBillList, String billNo) {
        if (!applyBillList.isEmpty()) {
            for (BillVo billVo : applyBillList) {
                if (!StringUtils.isNotEmpty((CharSequence)billNo) || !billNo.equals(billVo.getBillNo())) continue;
                return true;
            }
        }
        return false;
    }

    @SdkDeprecated
    public void dealAddErrorMsgMethod(String key, String value, Map<String, Set<String>> subErrorMsgMap) {
        if (subErrorMsgMap == null) {
            return;
        }
        if (subErrorMsgMap.containsKey(key)) {
            Set<String> errorMsgSet = subErrorMsgMap.get(key);
            errorMsgSet.add(value);
        } else {
            HashSet<String> errorMsgSet = new HashSet<String>();
            errorMsgSet.add(value);
            subErrorMsgMap.put(key, errorMsgSet);
        }
    }

    public void dealSplitDimensionMethod(String systemCode, String orgCode, String productCode, DynamicObject itemObject, Map<String, Set<String>> subErrorMsgMap) {
        logger.info("getSplitDimensionMethod, systemCode:{}, orgCode:{}, productCode:{}", new Object[]{systemCode, orgCode, productCode});
        QFilter qFilter = new QFilter("system_code", "=", (Object)systemCode).and("number", "=", (Object)orgCode);
        DynamicObject dynamicObject = this.getOrgMethod(qFilter);
        if (dynamicObject != null) {
            Long orgId = dynamicObject.getLong("id");
            QFilter orgFilter = ImcBaseDataHelper.getGoodsInfoFilter((Object)orgId);
            logger.info("getSplitDimensionMethod, orgid:{}, qFilter:{}", (Object)orgId, (Object)orgFilter);
            QFilter qFilter2 = new QFilter("number", "=", (Object)productCode).and("enable", "=", (Object)"1").and("lbsv_system_code", "=", (Object)systemCode);
            DynamicObject productObject = BusinessDataServiceHelper.loadSingle((String)"bdm_goods_info", (String)"id", (QFilter[])new QFilter[]{orgFilter, qFilter2});
            if (productObject != null) {
                Long pkId = productObject.getLong("id");
                productObject = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"bdm_goods_info");
                String saleFlag = productObject.getString("sale_flag");
                String saleTaxNo = productObject.getString("sale_tax_no");
                if (StringUtils.isEmpty((CharSequence)productObject.getString("taxrate"))) {
                    this.dealAddErrorMsgMethod("taxRate", productCode, subErrorMsgMap);
                } else {
                    itemObject.set("tax_rate", (Object)new BigDecimal(productObject.getString("taxrate")));
                }
                if ("1".equals(saleFlag)) {
                    DynamicObject saleOrgObject = productObject.getDynamicObject("sale_org");
                    if (saleOrgObject == null) {
                        this.dealAddErrorMsgMethod("saleOrg", productCode, subErrorMsgMap);
                    } else {
                        orgId = saleOrgObject.getLong("id");
                    }
                }
                if ("1".equals(productObject.getString("isopeninvoice"))) {
                    itemObject.set("invoicable_switch", (Object)"1");
                } else {
                    itemObject.set("invoicable_switch", (Object)"0");
                }
                String taxNo = StringUtils.isNotEmpty((CharSequence)saleTaxNo) ? saleTaxNo : this.getTaxNoByOrgCode(systemCode, orgCode, subErrorMsgMap);
                itemObject.set("orgid", (Object)orgId);
                itemObject.set("tax_no", (Object)taxNo);
                itemObject.set("splitkey", (Object)taxNo);
                itemObject.set("specification", (Object)productObject.getString("specifications"));
                itemObject.set("product_unit", (Object)productObject.getString("unit"));
                DynamicObject taxCodeObject = productObject.getDynamicObject("taxcode");
                if (taxCodeObject != null) {
                    itemObject.set("tax_code", (Object)taxCodeObject.getString("number"));
                } else {
                    itemObject.set("tax_code", null);
                }
                DynamicObject itemTypeObject = this.getBillCenterItemType(productObject);
                if (itemTypeObject == null) {
                    this.dealAddErrorMsgMethod("itemType", productCode, subErrorMsgMap);
                } else {
                    itemObject.set("itemtype", (Object)itemTypeObject);
                }
            } else {
                this.dealAddErrorMsgMethod("productCode", productCode, subErrorMsgMap);
            }
        } else {
            this.dealAddErrorMsgMethod("orgCode", orgCode, subErrorMsgMap);
        }
    }

    private String getTaxNoByOrgCode(String systemCode, String orgCode, Map<String, Set<String>> subErrorMsgMap) {
        QFilter qFilter = new QFilter("number", "=", (Object)systemCode).and("sim_front_system_cfg.system_source_org.source_org_code", "=", (Object)orgCode);
        BillCenterOrgMappingService billCenterOrgMappingService = new BillCenterOrgMappingService();
        DynamicObject dynamicObject = billCenterOrgMappingService.loadSingle(qFilter);
        logger.info("\u6839\u636e\u7cfb\u7edf\u7f16\u7801\uff1a{}, \u7ec4\u7ec7\u7f16\u7801:{}, \u67e5\u8be2\u53d1\u7968\u4e91\u7ec4\u7ec7\u4fe1\u606f\u5bf9\u8c61\u662f\u5426\u5b58\u5728\uff1a{}", new Object[]{systemCode, orgCode, dynamicObject != null});
        if (dynamicObject == null) {
            this.dealAddErrorMsgMethod("orgCode", orgCode, subErrorMsgMap);
        } else {
            QFilter qFilter2 = new QFilter("number", "=", (Object)orgCode).and("system_code", "=", (Object)systemCode);
            DynamicObject dynamicObject2 = billCenterOrgMappingService.loadSingleTargetOrgMapping(qFilter2);
            if (dynamicObject2 == null) {
                this.dealAddErrorMsgMethod("orgCode", orgCode, subErrorMsgMap);
            } else {
                DynamicObject epInfoObject = dynamicObject2.getDynamicObject("target_org_id");
                if (epInfoObject != null) {
                    return TaxUtils.getEnterpriseDynamicObjectByOrg((Long)epInfoObject.getLong("id")).getString("number");
                }
            }
        }
        return null;
    }

    public void dealUpdateBillInvoiceDataMethod(DynamicObject[] billDataCollection, JSONObject paramObject, String actual_invoiceType) {
        String wxOpenId = paramObject.getString("userId");
        String buyerName = paramObject.getString("buyerName");
        String buyerTaxpayerId = paramObject.getString("buyerTaxpayerId");
        if (StringUtils.isNotEmpty((CharSequence)buyerTaxpayerId)) {
            buyerTaxpayerId = buyerTaxpayerId.trim();
        }
        String buyerAddressAndTel = paramObject.getString("buyerAddressAndTel");
        String buyerBankAndAccount = paramObject.getString("buyerBankAndAccount");
        String buyerRecipientPhone = paramObject.getString("buyerRecipientPhone");
        if (StringUtils.isNotEmpty((CharSequence)buyerRecipientPhone) && (buyerRecipientPhone = buyerRecipientPhone.trim()).startsWith("+86-")) {
            buyerRecipientPhone = buyerRecipientPhone.replace("+86-", "");
        }
        String buyerRecipientMail = paramObject.getString("buyerRecipientMail");
        int buyerProperty = paramObject.getIntValue("buyerProperty");
        for (DynamicObject billDataObject : billDataCollection) {
            String[] bankAndAccountArray;
            String[] addressAndTelArray;
            billDataObject.set("wx_open_id", (Object)wxOpenId);
            billDataObject.set("buyername", (Object)buyerName);
            billDataObject.set("buyertaxno", (Object)buyerTaxpayerId);
            if (StringUtils.isNotEmpty((CharSequence)buyerAddressAndTel) && (addressAndTelArray = buyerAddressAndTel.split(",")) != null) {
                if (addressAndTelArray.length == 1) {
                    billDataObject.set("buyeraddr", (Object)addressAndTelArray[0]);
                } else if (addressAndTelArray.length == 2) {
                    billDataObject.set("buyeraddr", (Object)addressAndTelArray[0]);
                    billDataObject.set("buyertelno", (Object)addressAndTelArray[1]);
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)buyerBankAndAccount) && (bankAndAccountArray = buyerBankAndAccount.split(",")) != null) {
                if (bankAndAccountArray.length == 1) {
                    billDataObject.set("buyerbank", (Object)bankAndAccountArray[0]);
                } else if (bankAndAccountArray.length == 2) {
                    billDataObject.set("buyerbank", (Object)bankAndAccountArray[0]);
                    billDataObject.set("buyerbankacc", (Object)bankAndAccountArray[1]);
                }
            }
            billDataObject.set("user_email", (Object)buyerRecipientMail);
            billDataObject.set("invoicetype", (Object)actual_invoiceType);
            billDataObject.set("buyerproperty", (Object)buyerProperty);
            billDataObject.set("billstatus", (Object)"C");
            if (StringUtils.isNotEmpty((CharSequence)buyerRecipientPhone)) {
                billDataObject.set("user_phone", (Object)buyerRecipientPhone);
            }
            this.warpHotelNameRemark(paramObject, billDataObject);
        }
        SaveServiceHelper.update((DynamicObject[])billDataCollection);
    }

    private void warpHotelNameRemark(JSONObject paramObject, DynamicObject billDataObject) {
        StringBuilder stringBuilder = new StringBuilder();
        if ("1".equals(paramObject.getString("remarkHotelName"))) {
            BillCenterOrgMappingService billCenterOrgMappingService;
            DynamicObject frontSystemObject;
            String systemCode = billDataObject.getString("system_code");
            String hotelName = "";
            if (StringUtils.isNotEmpty((CharSequence)systemCode) && (frontSystemObject = (billCenterOrgMappingService = new BillCenterOrgMappingService()).loadSingleBySystemCode(systemCode)) != null) {
                hotelName = frontSystemObject.getString("lbsv_company_name");
            }
            String tipMsg = ResManager.loadKDString((String)"\u9152\u5e97\u540d\u79f0\uff1a", (String)"BillCenterInvoiceCommonService_0", (String)"imc-sim-service", (Object[])new Object[0]);
            stringBuilder.append(tipMsg).append(hotelName).append(ENTER_FLAG);
        }
        if ("1".equals(paramObject.getString("remarkHotelTime"))) {
            Date startDate = billDataObject.getDate("begin_date");
            Date endDate = billDataObject.getDate("end_date");
            if (startDate != null && endDate != null) {
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
                String tipMsg = ResManager.loadKDString((String)"\u5165\u79bb\u65f6\u95f4\uff1a", (String)"BillCenterInvoiceCommonService_1", (String)"imc-sim-service", (Object[])new Object[0]);
                stringBuilder.append(tipMsg).append(format.format(startDate)).append(SPECIAL_FLAG).append(format.format(endDate));
            }
        }
        billDataObject.set("remark", (Object)stringBuilder.toString());
    }

    public boolean dealCheckGoodsIsNotExistMethod(String filterStr, String conditionStr) {
        if (StringUtils.isEmpty((CharSequence)conditionStr)) {
            return false;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterStr, FilterCondition.class);
        List listFilterRow = filterCondition.getFilterRow();
        if (CollectionUtils.isEmpty((Collection)listFilterRow)) {
            return true;
        }
        for (int i = 0; i < listFilterRow.size(); ++i) {
            SimpleFilterRow simpleFilterRow = (SimpleFilterRow)listFilterRow.get(i);
            List filterValueList = simpleFilterRow.getValue();
            if (filterValueList == null || filterValueList.size() <= 0) continue;
            for (FilterValue filterValue : filterValueList) {
                Object value = filterValue.getValue();
                if (!conditionStr.equals(value)) continue;
                return false;
            }
        }
        return true;
    }

    public void dealSetDefaultOrgMethod(String systemCode, String orgCode, DynamicObject itemObject, Map<String, Set<String>> subErrorMsgMap) {
        logger.info("dealSetDefaultOrgMethod, systemCode:{}, orgCode:{}", (Object)systemCode, (Object)orgCode);
        QFilter qFilter = new QFilter("system_code", "=", (Object)systemCode).and("number", "=", (Object)orgCode);
        DynamicObject dynamicObject = this.getOrgMethod(qFilter);
        if (dynamicObject != null) {
            Long orgId = dynamicObject.getLong("id");
            itemObject.set("orgid", (Object)orgId);
            String taxNo = this.getTaxNoByOrgCode(systemCode, orgCode, subErrorMsgMap);
            itemObject.set("tax_no", (Object)taxNo);
            itemObject.set("splitkey", (Object)taxNo);
        } else {
            this.dealAddErrorMsgMethod("orgCode", orgCode, subErrorMsgMap);
        }
    }

    public DynamicObject getBillCenterItemType(DynamicObject bdmGoodsInfo) {
        DynamicObject taxCodeObject = bdmGoodsInfo.getDynamicObject("taxcode");
        if (taxCodeObject != null) {
            String taxCode = taxCodeObject.getString("number");
            taxCode = this.fillInTaxCode(taxCode);
            logger.info("getBillCenterItemType, taxCode:{}", (Object)taxCode);
            QFilter qFilter = new QFilter("sim_bill_center_category.entryentity.mergecode", "=", (Object)taxCode);
            logger.info("getBillCenterItemType, qFilter:{}", (Object)qFilter);
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"sim_bill_center_category", (QFilter[])qFilter.toArray());
            if (dynamicObject == null) {
                QFilter qFilter2 = new QFilter("number", "=", (Object)"other");
                dynamicObject = BusinessDataServiceHelper.loadSingle((String)"sim_bill_center_category", (QFilter[])qFilter2.toArray());
            }
            return dynamicObject;
        }
        return null;
    }

    private String fillInTaxCode(String taxCode) {
        int length = taxCode.length();
        if (length >= 19) {
            return taxCode;
        }
        StringBuilder mergeCodeSb = new StringBuilder(taxCode);
        for (int i = 0; i < 19 - length; ++i) {
            mergeCodeSb.append('0');
        }
        if (logger.isInfoEnabled()) {
            logger.info(String.format("\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e0d\u4e3a\u7a7a\uff0c\u5f00\u59cb\u8fdb\u884c\u88650\u64cd\u4f5c\uff0c\u539f\u7a0e\u6536\u5206\u7c7b\u7f16\u7801[%s],\u8865\u5168\u540e\u7684\u7a0e\u6536\u5206\u7c7b\u7f16\u7801[%s]", taxCode, mergeCodeSb.toString()));
        }
        return mergeCodeSb.toString();
    }

    public DynamicObject getBillCenterItemType(String taxCode) {
        taxCode = this.fillInTaxCode(taxCode);
        logger.info("getBillCenterItemType, taxCode:{}", (Object)taxCode);
        QFilter qFilter = new QFilter("sim_bill_center_category.entryentity.mergecode", "=", (Object)taxCode);
        logger.info("getBillCenterItemType, qFilter:{}", (Object)qFilter);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"sim_bill_center_category", (QFilter[])qFilter.toArray());
        if (dynamicObject == null) {
            QFilter qFilter2 = new QFilter("number", "=", (Object)"other");
            dynamicObject = BusinessDataServiceHelper.loadSingle((String)"sim_bill_center_category", (QFilter[])qFilter2.toArray());
        }
        return dynamicObject;
    }

    public void dealSetNoCanOpenInvoiceMethod(DynamicObject dynamicObject) {
        BigDecimal invoicable_amount = dynamicObject.getBigDecimal("invoicable_amount");
        if (invoicable_amount == null || invoicable_amount.compareTo(BigDecimal.ZERO) == 0) {
            dynamicObject.set("invoice_status", (Object)"-1");
            dynamicObject.set("pushstatus", (Object)"-2");
        }
    }

    public void dealStaticsCallbackMethod(String billNo, String systemCode, int callbackNum, String callbackStatus) {
        DynamicObject billCenterObject = this.dealCheckBillCenterDataMethod("billno", billNo, systemCode);
        if (billCenterObject != null) {
            billCenterObject.set("callback_num", (Object)(billCenterObject.getInt("callback_num") + callbackNum));
            billCenterObject.set("callback_status", (Object)callbackStatus);
            SaveServiceHelper.update((DynamicObject)billCenterObject);
        }
    }

    public void dealStaticsCallbackMethod(String billNo, String systemCode, String callbackStatus) {
        DynamicObject billCenterObject = this.dealCheckBillCenterDataMethod("billno", billNo, systemCode);
        if (billCenterObject != null) {
            billCenterObject.set("callback_num", (Object)0);
            billCenterObject.set("callback_status", (Object)callbackStatus);
            SaveServiceHelper.update((DynamicObject)billCenterObject);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DynamicObject dealGetSpecialInvoiceMethod(String systemCode, Long orgId, String productCode, String taxCode) {
        DynamicObject specialInvoiceObject = null;
        if (StringUtils.isNotBlank((CharSequence)productCode)) {
            QFilter qFilter2;
            QFilter orgFilter = ImcBaseDataHelper.getGoodsInfoFilter((Object)orgId);
            DynamicObject[] productObjectArray = BusinessDataServiceHelper.load((String)"bdm_goods_info", (String)"id", (QFilter[])new QFilter[]{orgFilter, qFilter2 = new QFilter("number", "=", (Object)productCode).and("enable", "=", (Object)"1")});
            if (productObjectArray != null) {
                logger.info("dealGetSpecialInvoiceMethod, \u5927\u5c0f:{}", (Object)productObjectArray.length);
                return this.getSpecialInvoceObject(systemCode, productObjectArray);
            }
            String errorMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5546\u54c1\u7f16\u7801:%1$s\uff0c\u672a\u5339\u914d\u5230\u5f00\u7968\u9879\u914d\u7f6e\uff01", (String)"BillCenterInvoiceCommonService_6", (String)"imc-sim-service", (Object[])new Object[0]), productCode);
            throw new KDBizException(errorMsg);
        }
        if (StringUtils.isNotBlank((CharSequence)taxCode)) {
            QFilter qFilter = taxCode.length() >= 19 ? new QFilter("mergecode", "=", (Object)taxCode) : new QFilter("number", "=", (Object)taxCode);
            DynamicObject taxClassCodeObject = BusinessDataServiceHelper.loadSingle((String)"er_taxclasscode", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"er_taxclasscode", (boolean)true), (QFilter[])qFilter.toArray());
            if (taxClassCodeObject == null) return specialInvoiceObject;
            String selectProperties = PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_special_invoice_cfg", (boolean)true);
            qFilter = new QFilter("taxcode", "=", (Object)taxClassCodeObject.getLong("id")).and("enable", "=", (Object)"1");
            return BusinessDataServiceHelper.loadSingle((String)"bdm_special_invoice_cfg", (String)selectProperties, (QFilter[])qFilter.toArray());
        }
        String errorMsg = ResManager.loadKDString((String)"\u83b7\u53d6\u7a0e\u6536\u5206\u7c7b\u5f00\u5177\u4e13\u7968\u914d\u7f6e\uff0c\u53c2\u6570\u4e0d\u6b63\u786e\uff01", (String)"BillCenterInvoiceCommonService_9", (String)"imc-sim-service", (Object[])new Object[0]);
        throw new KDBizException(errorMsg);
    }

    private DynamicObject getSpecialInvoceObject(String systemCode, DynamicObject[] productObjectArray) {
        for (DynamicObject productObject : productObjectArray) {
            DynamicObject taxCodeObject;
            Long pkId = productObject.getLong("id");
            DynamicObject goodsInfoObject = this.dealMatchGoodsInfoMethod(productObject = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"bdm_goods_info"), systemCode, productObject);
            if (goodsInfoObject == null || (taxCodeObject = goodsInfoObject.getDynamicObject("taxcode")) == null) continue;
            Long taxCodeId = taxCodeObject.getLong("id");
            QFilter qFilter = new QFilter("taxcode.id", "=", (Object)taxCodeId).and("enable", "=", (Object)"1");
            DynamicObject specialInvoiceObject = BusinessDataServiceHelper.loadSingle((String)"bdm_special_invoice_cfg", (String)"id", (QFilter[])qFilter.toArray());
            if (specialInvoiceObject != null) {
                specialInvoiceObject = BusinessDataServiceHelper.loadSingle((Object)specialInvoiceObject.getLong("id"), (String)"bdm_special_invoice_cfg");
            }
            return specialInvoiceObject;
        }
        return null;
    }

    private DynamicObject dealMatchGoodsInfoMethod(DynamicObject goodsInfoObject, String systemCode, DynamicObject productObject) {
        boolean hasField = DynamicObjectUtil.checkDynamicObjectHasField((DynamicObject)goodsInfoObject, (String)"lbsv_system_code");
        if (hasField) {
            String lbsv_system_code = goodsInfoObject.getString("lbsv_system_code");
            logger.info("dealMatchGoodsInfoMethod\uff0csystemCode:{}, lbsv_system_code:{}", (Object)systemCode, (Object)lbsv_system_code);
            if (StringUtils.isEmpty((CharSequence)lbsv_system_code)) {
                String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u5339\u914d\u5230\u5f00\u7968\u9879\u914d\u7f6e\u6570\u636e\uff0c\u7cfb\u7edf\u7f16\u7801\u5b57\u6bb5\u4e3a\u7a7a\uff01", (String)"IsomerismBill2OriginalPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]);
                throw new KDBizException(errorMsg);
            }
            if (lbsv_system_code.equals(systemCode)) {
                return goodsInfoObject;
            }
            return null;
        }
        return productObject;
    }

    public void dealGruopItemAmountMethod(DynamicObject[] dynamicObjects, Map<String, String> errorMsgMap, Map<String, BigDecimal> groupAmountMap) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (DynamicObject billCenterObject : dynamicObjects) {
            String systemCode = billCenterObject.getString("system_code");
            String billNo = billCenterObject.getString("billno");
            String invoice_status = billCenterObject.getString("invoice_status");
            String pushstatus = billCenterObject.getString("pushstatus");
            if ("-1".equals(invoice_status) || "-2".equals(pushstatus)) {
                logger.error("\u8ba2\u5355\u7f16\u53f7\uff1a{}\uff0c\u4e0d\u53ef\u4e0b\u63a8\u6216\u4e0d\u53ef\u5f00\u7968\uff01", (Object)billNo);
                continue;
            }
            DynamicObject orgObject = billCenterObject.getDynamicObject("org");
            if (orgObject == null) {
                String errorMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u5355\u7f16\u53f7:%1$s\uff0c\u5173\u8054\u7684\u7ec4\u7ec7\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01", (String)"BillCenterInvoiceCommonService_7", (String)"imc-sim-service", (Object[])new Object[0]), billNo);
                errorMsgMap.put("errorMsg", errorMsg);
                return;
            }
            Long orgId = orgObject.getLong("id");
            DynamicObjectCollection itemObjectCollection = billCenterObject.getDynamicObjectCollection("sim_isomerism_item_data");
            if (itemObjectCollection == null || itemObjectCollection.isEmpty()) {
                String errorMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u5355\u7f16\u53f7:%1$s\uff0c\u5546\u54c1\u660e\u7ec6\u533a\u6570\u636e\u4e0d\u5b58\u5728\uff01", (String)"BillCenterInvoiceCommonService_8", (String)"imc-sim-service", (Object[])new Object[0]), billNo);
                errorMsgMap.put("errorMsg", errorMsg);
                return;
            }
            for (DynamicObject itemObject : itemObjectCollection) {
                String invoicable_switch = itemObject.getString("invoicable_switch");
                if (StringUtils.isBlank((CharSequence)invoicable_switch) || "0".equals(invoicable_switch)) continue;
                String productCode = itemObject.getString("product_code");
                String taxCode = itemObject.getString("tax_code");
                BigDecimal avgAmount = itemObject.getBigDecimal("avg_amount");
                totalAmount = totalAmount.add(avgAmount);
                DynamicObject specialInvoiceObject = this.dealGetSpecialInvoiceMethod(systemCode, orgId, productCode, taxCode);
                if (specialInvoiceObject == null) {
                    this.dealGroupSpecialInvoiceAmountMethod(groupAmountMap, avgAmount, InvoiceType.ALL_E_NORMAL.getTypeCode());
                    continue;
                }
                String is_special_invoice = specialInvoiceObject.getString("is_special_invoice");
                if (StringUtils.isBlank((CharSequence)is_special_invoice) || "0".equals(is_special_invoice)) {
                    this.dealGroupSpecialInvoiceAmountMethod(groupAmountMap, avgAmount, InvoiceType.ALL_E_NORMAL.getTypeCode());
                    continue;
                }
                this.dealGroupSpecialInvoiceAmountMethod(groupAmountMap, avgAmount, InvoiceType.ALL_E_SPECIAL.getTypeCode());
            }
        }
        groupAmountMap.put("totalAmount", totalAmount);
    }

    private void dealGroupSpecialInvoiceAmountMethod(Map<String, BigDecimal> groupAmountMap, BigDecimal avgAmount, String invoiceType) {
        if (groupAmountMap.containsKey(invoiceType)) {
            BigDecimal totalAmount = groupAmountMap.get(invoiceType);
            totalAmount = totalAmount.add(avgAmount);
            groupAmountMap.put(invoiceType, totalAmount);
        } else {
            groupAmountMap.put(invoiceType, avgAmount);
        }
    }

    public Map<Integer, String> dealCheckBillIsMatchSpecialMethod(DynamicObject billObject) {
        if (billObject == null) {
            logger.error("\u4f20\u5165\u7684\u53c2\u6570\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01");
            return null;
        }
        int rowIdx = 1;
        DynamicObjectCollection dynamicObjectCollection = billObject.getDynamicObjectCollection("sim_original_bill_item");
        HashMap<Integer, String> originalBillMap = new HashMap<Integer, String>(dynamicObjectCollection.size());
        for (DynamicObject itemObject : dynamicObjectCollection) {
            DynamicObject taxCodeObject = itemObject.getDynamicObject("taxratecodeid");
            if (taxCodeObject == null) {
                originalBillMap.put(rowIdx, "02");
            } else {
                String taxCode = taxCodeObject.getString("number");
                DynamicObject specialInvoiceObject = this.dealGetSpecialInvoiceMethod(null, null, null, taxCode);
                if (specialInvoiceObject == null) {
                    originalBillMap.put(rowIdx, "02");
                } else {
                    String is_special_invoice = specialInvoiceObject.getString("is_special_invoice");
                    if (StringUtils.isBlank((CharSequence)is_special_invoice) || "0".equals(is_special_invoice)) {
                        originalBillMap.put(rowIdx, "02");
                    } else {
                        originalBillMap.put(rowIdx, "01");
                    }
                }
            }
            ++rowIdx;
        }
        logger.info("\u8fd4\u56de\u7684\u4e13\u666e\u7968\u7ed3\u679c\u503c\uff1a{}", originalBillMap);
        return originalBillMap;
    }

    public void dealUpdateBillItemOpenInvoiceMethod(DynamicObject[] billDataCollection) {
        for (DynamicObject billDataObject : billDataCollection) {
            DynamicObjectCollection itemObjectCollection = billDataObject.getDynamicObjectCollection("sim_isomerism_item_data");
            for (DynamicObject itemObject : itemObjectCollection) {
                itemObject.set("openinvoicetype", (Object)"02");
            }
        }
        SaveServiceHelper.update((DynamicObject[])billDataCollection);
    }

    public DynamicObject getBdmGoodsInfoObject(String systemCode, String orgCode, String productCode) {
        logger.info("getBdmGoodsInfoObject, systemCode:{}, orgCode:{}, productCode:{}", new Object[]{systemCode, orgCode, productCode});
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        QFilter qFilter = new QFilter("system_code", "=", (Object)systemCode).and("number", "=", (Object)orgCode);
        DynamicObject sourceTargetObject = billCenterInvoiceCommonService.getOrgMethod(qFilter);
        if (sourceTargetObject != null) {
            Long orgId = sourceTargetObject.getLong("id");
            QFilter orgFilter = ImcBaseDataHelper.getGoodsInfoFilter((Object)orgId);
            logger.info("getBdmGoodsInfoObject, orgid:{}, qFilter:{}", (Object)orgId, (Object)orgFilter);
            QFilter qFilter2 = new QFilter("number", "=", (Object)productCode).and("enable", "=", (Object)"1");
            DynamicObject productObject = BusinessDataServiceHelper.loadSingle((String)"bdm_goods_info", (QFilter[])new QFilter[]{orgFilter, qFilter2});
            if (productObject != null) {
                return productObject;
            }
        }
        return null;
    }

    public boolean dealCheckInvoicedFailMethod(DynamicObject dynamicObject) {
        String issuestatus = dynamicObject.getString("issuestatus");
        String issuesource = dynamicObject.getString("issuesource");
        String result = dynamicObject.getString("result");
        return IssueStatusEnum.failed.getCode().equals(issuestatus) && "13".equals(issuesource) && StringUtils.isNotBlank((CharSequence)result);
    }
}

