/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.billcenter;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.sim.billcenter.BillCenterInvoiceCommonService;

public class SimGiftReceiptService {
    private static Log LOGGER = LogFactory.getLog(SimGiftReceiptService.class);

    public void checkGroupGoodsItems(DynamicObject billCenterObject) {
        DynamicObjectCollection items = billCenterObject.getDynamicObjectCollection("sim_isomerism_item_data");
        HashMap<String, DynamicObject> groupItemMap = new HashMap<String, DynamicObject>(items.size());
        String systemCode = billCenterObject.getString("system_code");
        DynamicObject orgObject = billCenterObject.getDynamicObject("org");
        this.dealGroupGoodsItemMethod(systemCode, orgObject, groupItemMap, items);
        for (Map.Entry entryObject : groupItemMap.entrySet()) {
            DynamicObject itemObject = (DynamicObject)entryObject.getValue();
            BigDecimal unPushAmount = itemObject.getBigDecimal("unpushamount");
            if (unPushAmount != null && unPushAmount.compareTo(BigDecimal.ZERO) >= 0) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u5408\u5e76\u660e\u7ec6\u884c\u540e\uff0c\u5b58\u5728\u91d1\u989d\u4e3a\u8d1f\u6570\u7684\u660e\u7ec6\u884c\uff0c\u8bf7\u68c0\u67e5\u8d26\u5355\u3002", (String)"SimIsomerismBillGiftReceiptCreateOp_9", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        BigDecimal totalAmount = billCenterObject.getBigDecimal("remain_amount");
        if (totalAmount == null || totalAmount.compareTo(BigDecimal.ZERO) <= 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6574\u5355\u91d1\u989d\u4e3a\u8d1f\u6570\u62160\u7684\u8d26\u5355\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u5c0f\u7968\u7801\u3002", (String)"SimIsomerismBillGiftReceiptCreateOp_10", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
    }

    public void dealGroupGoodsItemMethod(String systemCode, DynamicObject orgObject, Map<String, DynamicObject> groupItemMap, DynamicObjectCollection items) {
        String orgCode = orgObject.getString("number");
        for (DynamicObject item : items) {
            String goodsCode = item.getString("product_code");
            DynamicObject goodsInfoObject = this.getBdmGoodsInfoObject(systemCode, orgCode, goodsCode);
            String goodsName = item.getString("product_name");
            String lineProperty = item.getString("line_property");
            BigDecimal taxRate = item.getBigDecimal("tax_rate");
            String taxCode = item.getString("tax_code");
            String key = goodsName + taxRate + lineProperty;
            if (goodsInfoObject != null) {
                String specifications = goodsInfoObject.getString("specifications");
                String unit = goodsInfoObject.getString("unit");
                String privilegeflag = goodsInfoObject.getString("privilegeflag");
                String privilegetype = goodsInfoObject.getString("privilegetype");
                key = key + specifications + unit + privilegeflag + privilegetype;
            }
            key = key + taxCode;
            LOGGER.info("dealGroupGoodsItemMethod, key:{}", (Object)key);
            if (groupItemMap.containsKey(key)) {
                DynamicObject dynamicObject = groupItemMap.get(key);
                BigDecimal unPushAmount = dynamicObject.getBigDecimal("unpushamount");
                BigDecimal totalUnPushAmount = unPushAmount.add(item.getBigDecimal("unpushamount"));
                dynamicObject.set("unpushamount", (Object)totalUnPushAmount);
                dynamicObject.set("product_price", (Object)totalUnPushAmount);
                int totalUnPushNum = 0;
                totalUnPushNum = totalUnPushAmount.compareTo(BigDecimal.ZERO) >= 0 ? 1 : -1;
                dynamicObject.set("unpushnum", (Object)totalUnPushNum);
                BigDecimal taxAmount = dynamicObject.getBigDecimal("unpushtax");
                dynamicObject.set("unpushtax", (Object)taxAmount.add(item.getBigDecimal("unpushtax")));
                continue;
            }
            groupItemMap.put(key, item);
        }
    }

    private DynamicObject getBdmGoodsInfoObject(String systemCode, String orgCode, String productCode) {
        LOGGER.info("getBdmGoodsInfoObject, systemCode:{}, orgCode:{}, productCode:{}", new Object[]{systemCode, orgCode, productCode});
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        QFilter qFilter = new QFilter("system_code", "=", (Object)systemCode).and("number", "=", (Object)orgCode);
        DynamicObject sourceTargetObject = billCenterInvoiceCommonService.getOrgMethod(qFilter);
        if (sourceTargetObject != null) {
            Long orgId = sourceTargetObject.getLong("id");
            QFilter orgFilter = ImcBaseDataHelper.getGoodsInfoFilter((Object)orgId);
            LOGGER.info("getBdmGoodsInfoObject, orgid:{}, qFilter:{}", (Object)orgId, (Object)orgFilter);
            QFilter qFilter2 = new QFilter("number", "=", (Object)productCode).and("enable", "=", (Object)"1");
            DynamicObject productObject = BusinessDataServiceHelper.loadSingle((String)"bdm_goods_info", (QFilter[])new QFilter[]{orgFilter, qFilter2});
            if (productObject != null) {
                return productObject;
            }
        }
        return null;
    }
}

