/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.billcenter.sys;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.sim.billcenter.BillCenterInvoiceCommonService;
import kd.imc.sim.billcenter.BillCenterInvoiceLogService;
import kd.imc.sim.billcenter.BillCenterOrgMappingService;
import kd.imc.sim.billcenter.util.JdbcUtil;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.common.utils.TaxCalcUtil;
import org.apache.commons.lang3.StringUtils;

public class OperaCommonLogicService {
    private static final Log logger = LogFactory.getLog(OperaCommonLogicService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dealCreateDBConnMethod(DynamicObject frontSystemObject, String[] paramArray, List<Object> successMsgList, List<Object> errorMsgList) {
        Map<String, JSONArray> billDataMap;
        JSONArray jsonArray = new JSONArray();
        String systemCode = frontSystemObject.getString("number");
        String dbUserName = frontSystemObject.getString("db_username");
        String billNo = paramArray[0];
        String phoneNumber = paramArray[1];
        String blockCode = paramArray[2];
        String startDate = paramArray[3];
        String endDate = paramArray[4];
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        logger.info("dealCreateDBConnMethod, systemCode:{}, billNo:{}, phoneNumber:{}, blockCode:{}, startDate:{}, endDate:{}", new Object[]{systemCode, billNo, phoneNumber, blockCode, startDate, endDate});
        try {
            connection = JdbcUtil.getConnection(frontSystemObject);
            String sql = this.dealExecSQLMethod(billNo, phoneNumber, blockCode, startDate, endDate, dbUserName, systemCode);
            statement = connection.prepareStatement(sql);
            Object[] params = this.dealSetFieldValueMethod(billNo, phoneNumber, blockCode, startDate, endDate);
            JdbcUtil.fillStatement(statement, params);
            logger.info("\u9884\u7f16\u8bd1SQL\u6210\u529f\uff0c\u51c6\u5907\u5f00\u59cb\u67e5\u8be2\u5bf9\u5e94\u7684\u7ed3\u679c\u96c6\u5185\u5bb9\uff01");
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                logger.info("\u67e5\u8be2phone_number\u7684\u7ed3\u679c\u503c\u662f:{}", (Object)resultSet.getString("Phone_number"));
                this.dealFormatBillDataMethod(resultSet, jsonArray, systemCode, blockCode);
            }
            billDataMap = this.dealBillDataTotalAmountMethod(jsonArray);
        }
        catch (Exception e) {
            Map<String, JSONArray> billDataMap2;
            try {
                logger.error("\u67e5\u8be2Opera\u6570\u636e\u51fa\u73b0\u5f02\u5e38:{}", (Object)e.getMessage());
                this.dealErrorExceptionLogMethod(errorMsgList, e, dbUserName);
                billDataMap2 = this.dealBillDataTotalAmountMethod(jsonArray);
            }
            catch (Throwable throwable) {
                Map<String, JSONArray> billDataMap3 = this.dealBillDataTotalAmountMethod(jsonArray);
                String currentTime = DateUtils.format((java.util.Date)new java.util.Date(), (String)"yyyy-MM-dd HH:mm:ss");
                logger.info("\u5f53\u524d\u65f6\u95f4\u70b9:{}\uff0c\u5f53\u524d\u7cfb\u7edf\u7f16\u7801:{}\uff0c\u7edf\u8ba1\u5230\u5171\u6709Opera\u6570\u636e:{}\u6761\uff0c\u7edf\u8ba1\u5f97\u5230\u8d26\u5355\u5206\u7ec4\u7684\u6570\u91cf\u662f\uff1a{}\uff01", new Object[]{currentTime, systemCode, jsonArray.size(), billDataMap3.size()});
                this.dealCreateBillCenterDataMethod(billDataMap3, systemCode, successMsgList, errorMsgList);
                JdbcUtil.close(resultSet, statement, connection);
                throw throwable;
            }
            String currentTime = DateUtils.format((java.util.Date)new java.util.Date(), (String)"yyyy-MM-dd HH:mm:ss");
            logger.info("\u5f53\u524d\u65f6\u95f4\u70b9:{}\uff0c\u5f53\u524d\u7cfb\u7edf\u7f16\u7801:{}\uff0c\u7edf\u8ba1\u5230\u5171\u6709Opera\u6570\u636e:{}\u6761\uff0c\u7edf\u8ba1\u5f97\u5230\u8d26\u5355\u5206\u7ec4\u7684\u6570\u91cf\u662f\uff1a{}\uff01", new Object[]{currentTime, systemCode, jsonArray.size(), billDataMap2.size()});
            this.dealCreateBillCenterDataMethod(billDataMap2, systemCode, successMsgList, errorMsgList);
            JdbcUtil.close(resultSet, statement, connection);
        }
        String currentTime = DateUtils.format((java.util.Date)new java.util.Date(), (String)"yyyy-MM-dd HH:mm:ss");
        logger.info("\u5f53\u524d\u65f6\u95f4\u70b9:{}\uff0c\u5f53\u524d\u7cfb\u7edf\u7f16\u7801:{}\uff0c\u7edf\u8ba1\u5230\u5171\u6709Opera\u6570\u636e:{}\u6761\uff0c\u7edf\u8ba1\u5f97\u5230\u8d26\u5355\u5206\u7ec4\u7684\u6570\u91cf\u662f\uff1a{}\uff01", new Object[]{currentTime, systemCode, jsonArray.size(), billDataMap.size()});
        this.dealCreateBillCenterDataMethod(billDataMap, systemCode, successMsgList, errorMsgList);
        JdbcUtil.close(resultSet, statement, connection);
    }

    private void dealErrorExceptionLogMethod(List<Object> errorMsgList, Exception e, String dbUserName) {
        String errorCode;
        boolean flag = e instanceof KDBizException;
        if (flag && "9999".equals(errorCode = ((KDBizException)e).getErrorCode().getCode())) {
            HashMap<String, Set<String>> subErrorMsgMap = new HashMap<String, Set<String>>(8);
            BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
            billCenterInvoiceCommonService.dealAddErrorMsgMethod("dbUser", dbUserName, subErrorMsgMap);
            errorMsgList.add(subErrorMsgMap);
        }
    }

    private Object[] dealSetFieldValueMethod(String billNo, String phoneNumber, String blockCode, String startDate, String endDate) throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)startDate) && StringUtils.isNotEmpty((CharSequence)endDate)) {
            return new Object[]{startDate, endDate};
        }
        if (StringUtils.isNotEmpty((CharSequence)billNo) && StringUtils.isNotEmpty((CharSequence)phoneNumber)) {
            return new Object[]{billNo, "%" + phoneNumber};
        }
        if (StringUtils.isNotEmpty((CharSequence)billNo) && StringUtils.isNotEmpty((CharSequence)blockCode)) {
            return new Object[]{billNo, blockCode};
        }
        if (StringUtils.isNotEmpty((CharSequence)blockCode) && StringUtils.isNotEmpty((CharSequence)startDate)) {
            return new Object[]{blockCode, startDate, startDate + " 23:59:59"};
        }
        if (StringUtils.isNotEmpty((CharSequence)blockCode)) {
            return new Object[]{blockCode};
        }
        if (StringUtils.isNotEmpty((CharSequence)billNo)) {
            return new Object[]{billNo};
        }
        if (StringUtils.isNotEmpty((CharSequence)phoneNumber)) {
            return new Object[]{"%" + phoneNumber};
        }
        return null;
    }

    private String dealExecSQLMethod(String billNo, String phoneNumber, String blockCode, String startDate, String endDate, String dbUserName, String systemCode) {
        String sql = StringUtils.isNotEmpty((CharSequence)blockCode) ? this.getMeetingSQLMethod(blockCode, billNo, startDate, dbUserName, systemCode) : this.getSQLMethod(billNo, phoneNumber, startDate, endDate, dbUserName, systemCode);
        return sql;
    }

    private String getMeetingSQLMethod(String blockCode, String billNo, String startDate, String dbUserName, String systemCode) {
        String tipMsg = ResManager.loadKDString((String)"\u4f1a\u8bae\u56e2\u89c6\u56fe", (String)"OperaCommonLogicService_6", (String)"imc-sim-service", (Object[])new Object[0]);
        String view_name = this.getTableNameMethod(tipMsg, systemCode);
        if (StringUtils.isEmpty((CharSequence)view_name) || StringUtils.isEmpty((CharSequence)dbUserName)) {
            String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u5e93\u7528\u6237\u6216\u8868\u540d\u4e0d\u5b58\u5728\uff01", (String)"OperaCommonLogicService_4", (String)"imc-sim-service", (Object[])new Object[0]);
            throw new KDBizException(new ErrorCode("9999", errorMsg), new Object[0]);
        }
        logger.info("getMeetingSQLMethod, view_name:{}, dbUserName:{}, systemCode:{}", new Object[]{view_name, dbUserName, systemCode});
        if (view_name.startsWith(dbUserName)) {
            String sql = "select t.RESORT, t.RESV_STATUS, t.TRX_NO, t.TRX_DATE, t.TRX_CODE, t.DESCRIPTION, t.TC_GROUP, t.TRX_AMOUNT, t.GROSS_AMOUNT, t.REFERENCE,t.FOLIO_NO,t.CONFIRMATION_NO,t.PHONE_NUMBER, t.BEGIN_DATE, t.END_DATE, t.BLOCK_CODE from " + view_name + " t where t.RESV_STATUS='CHECKED OUT' ";
            if (StringUtils.isNotEmpty((CharSequence)billNo) && StringUtils.isNotEmpty((CharSequence)blockCode)) {
                sql = sql + " AND t.CONFIRMATION_NO=? AND t.BLOCK_CODE=?";
            } else if (StringUtils.isNotEmpty((CharSequence)blockCode) && StringUtils.isNotEmpty((CharSequence)startDate)) {
                sql = sql + " AND t.BLOCK_CODE=? AND t.END_DATE >= TO_DATE(?, 'YYYY-MM-DD') AND t.END_DATE <= TO_DATE(?, 'yyyy-mm-dd hh24:mi:ss')";
            } else if (StringUtils.isNotEmpty((CharSequence)blockCode)) {
                sql = sql + " AND t.BLOCK_CODE=?";
            }
            logger.info("\u8bfb\u53d6Opera\u7684\u9152\u5e97\u4f1a\u8bae\u56e2\u8ba2\u5355\u6570\u636e\uff0c\u5f53\u524d\u6267\u884c\u7684SQL\u662f:{}", (Object)sql);
            return sql;
        }
        String errorMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u5e93\u7528\u6237:%1$s\uff0c\u6ca1\u6709\u6743\u9650\u8bbf\u95ee\u6b64\u89c6\u56fe\uff01", (String)"OperaCommonLogicService_5", (String)"imc-sim-service", (Object[])new Object[0]), dbUserName);
        throw new KDBizException(new ErrorCode("9999", errorMsg), new Object[0]);
    }

    private void dealCreateBillCenterDataMethod(Map<String, JSONArray> billDataMap, String systemCode, List<Object> successMsgList, List<Object> errorMsgList) {
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        for (Map.Entry<String, JSONArray> entryObject : billDataMap.entrySet()) {
            HashMap<String, Set<String>> subErrorMsgMap = new HashMap<String, Set<String>>(billDataMap.size());
            String key = entryObject.getKey();
            JSONArray subArray = entryObject.getValue();
            if (StringUtils.isEmpty((CharSequence)key)) {
                logger.error("dealCreateBillCenterDataMethod, key\u503c\u4e3a\u7a7a\uff01");
                continue;
            }
            if (subArray == null || subArray.isEmpty()) {
                logger.error("dealCreateBillCenterDataMethod, subArray\u6570\u7ec4\u4e3a\u7a7a\uff01");
                continue;
            }
            logger.info("dealCreateBillCenterDataMethod, key:{}, systemCode:{}, subArray\u5927\u5c0f:{}", new Object[]{key, systemCode, subArray.size()});
            String[] array = key.split("-");
            String userPhone = array[0];
            if ("NULL".equals(userPhone)) {
                userPhone = "";
            }
            String billNo = array[1];
            logger.info("dealCreateBillCenterDataMethod, userPhone:{}, billNo:{}, systemCode:{}", new Object[]{userPhone, billNo, systemCode});
            QFilter qFilter = new QFilter("billno", "=", (Object)billNo).and("system_code", "=", (Object)systemCode);
            DynamicObject dynamicObject = billCenterInvoiceCommonService.dealLoadIsomerismBillDataMethod(qFilter);
            if (dynamicObject == null) {
                dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"sim_isomerism_bill_data");
            } else {
                String invoice_status = dynamicObject.getString("invoice_status");
                String pushStatus = dynamicObject.getString("pushstatus");
                if ("1".equals(invoice_status) || "5".equals(invoice_status) || "1".equals(pushStatus) || "0".equals(pushStatus)) {
                    logger.error("\u5f53\u524d\u6267\u884c\u7684\u8ba2\u5355\u53f7\uff1a{}\uff0c\u5df2\u7ecf\u5b8c\u6210\u5f00\u7968\u64cd\u4f5c\uff01", (Object)billNo);
                    billCenterInvoiceCommonService.dealAddErrorMsgMethod("billPush", billNo, subErrorMsgMap);
                    errorMsgList.add(subErrorMsgMap);
                    continue;
                }
                logger.info("dealCreateBillCenterDataMethod, billNo:{}\uff0c \u5bf9\u5e94\u7684\u8ba2\u5355\u6570\u636e\u5df2\u7ecf\u5b58\u5728\uff01", (Object)billNo);
            }
            this.dealCreateBillHeaderDataMethod(dynamicObject, subArray, userPhone, billNo, subErrorMsgMap);
            this.dealCreateBillItemDataMethod(dynamicObject, subArray, subErrorMsgMap);
            this.dealCreateBillPayDataMethod(dynamicObject, subArray, subErrorMsgMap, systemCode);
            this.dealOperaAmountShareLogicMethod(dynamicObject, subErrorMsgMap);
            logger.info("\u5f53\u524d\u6267\u884c\u7684\u8ba2\u5355\u53f7\uff1a{}\uff0c \u9519\u8bef\u63d0\u793a\u4fe1\u606f\u5185\u5bb9\u7684\u6570\u91cf\u662f:{}", (Object)billNo, subErrorMsgMap);
            if (subErrorMsgMap.size() == 0) {
                billCenterInvoiceCommonService.dealSetNoCanOpenInvoiceMethod(dynamicObject);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                successMsgList.add(dynamicObject);
                logger.info("\u5f53\u524d\u6267\u884c\u7684\u8ba2\u5355\u53f7\uff1a{}\uff0c \u4fdd\u5b58\u6210\u529f\uff01", (Object)billNo);
                continue;
            }
            errorMsgList.add(subErrorMsgMap);
        }
    }

    private void dealOperaAmountShareLogicMethod(DynamicObject dynamicObject, Map<String, Set<String>> subErrorMsgMap) {
        BigDecimal canOpenInvoiceAmount;
        String billNo = dynamicObject.getString("billno");
        boolean flag = this.dealCheckItemPaymentAmountMethod(dynamicObject);
        logger.info("dealOperaAmountShareLogicMethod, billNo:{}, flag:{}", (Object)billNo, (Object)flag);
        if (flag) {
            boolean isEqualFlag = this.dealComparedAmountIsEqualMethod(dynamicObject);
            logger.info("dealOperaAmountShareLogicMethod, isEqualFlag:{}", (Object)isEqualFlag);
            if (isEqualFlag) {
                canOpenInvoiceAmount = this.dealCountCommonOpenAmountMethod(dynamicObject);
                dynamicObject.set("invoicable_amount", (Object)canOpenInvoiceAmount);
                dynamicObject.set("remain_amount", (Object)canOpenInvoiceAmount);
                this.dealGroupItemPayShareAmountMethod(dynamicObject);
                this.dealSetItemPushStatusMethod(dynamicObject);
            } else {
                canOpenInvoiceAmount = BigDecimal.ZERO;
            }
        } else {
            canOpenInvoiceAmount = BigDecimal.ZERO;
        }
        logger.info("dealOperaAmountShareLogicMethod, canOpenInvoiceAmount:{}", (Object)canOpenInvoiceAmount);
        if (canOpenInvoiceAmount.compareTo(BigDecimal.ZERO) == 0) {
            logger.error("\u4e0d\u6ee1\u8db3\u91d1\u989d\u5206\u644a\u7684\u5904\u7406\uff0c\u53ef\u5f00\u7968\u91d1\u989d\u4e3a0\uff01");
            dynamicObject.set("invoicable_amount", (Object)canOpenInvoiceAmount);
            dynamicObject.set("remain_amount", (Object)canOpenInvoiceAmount);
            return;
        }
    }

    private void dealSetItemPushStatusMethod(DynamicObject dynamicObject) {
        DynamicObjectCollection itemObjectCollection = dynamicObject.getDynamicObjectCollection("sim_isomerism_item_data");
        if (itemObjectCollection == null) {
            return;
        }
        logger.info("dealSetItemPushStatusMethod, billNo:{}, \u6d88\u8d39\u660e\u7ec6\u9879\u96c6\u5408\u5927\u5c0f:{}", (Object)dynamicObject.getString("billno"), (Object)itemObjectCollection.size());
        for (DynamicObject itemObject : itemObjectCollection) {
            BigDecimal productAmount = itemObject.getBigDecimal("product_amount");
            String invoicable_switch = itemObject.getString("invoicable_switch");
            BigDecimal avgAmount = itemObject.getBigDecimal("avg_amount");
            if (productAmount == null || productAmount.compareTo(BigDecimal.ZERO) == 0 || "0".equals(invoicable_switch)) {
                itemObject.set("rowpushstatus", (Object)"1");
                continue;
            }
            if (avgAmount != null && avgAmount.compareTo(BigDecimal.ZERO) != 0) continue;
            itemObject.set("rowpushstatus", (Object)"1");
        }
    }

    private Map<String, List<DynamicObject>> getGroupItemListMethod(DynamicObject dynamicObject) {
        DynamicObjectCollection itemObjectCollection = dynamicObject.getDynamicObjectCollection("sim_isomerism_item_data");
        HashMap<String, List<DynamicObject>> itemObjectMap = new HashMap<String, List<DynamicObject>>(itemObjectCollection.size());
        for (DynamicObject itemObject : itemObjectCollection) {
            ArrayList<DynamicObject> subList;
            String folioNo = itemObject.getString("folio_no");
            if (StringUtils.isEmpty((CharSequence)folioNo)) continue;
            if (itemObjectMap.containsKey(folioNo)) {
                subList = (ArrayList<DynamicObject>)itemObjectMap.get(folioNo);
                subList.add(itemObject);
                continue;
            }
            subList = new ArrayList<DynamicObject>(itemObjectCollection.size());
            subList.add(itemObject);
            itemObjectMap.put(folioNo, subList);
        }
        return itemObjectMap;
    }

    private Map<String, BigDecimal> getGroupItemAmountMethod(DynamicObject dynamicObject) {
        Map<String, List<DynamicObject>> itemDynamicMap = this.getGroupItemListMethod(dynamicObject);
        HashMap<String, BigDecimal> itemObjectMap = new HashMap<String, BigDecimal>(itemDynamicMap.size());
        for (Map.Entry<String, List<DynamicObject>> entryObject : itemDynamicMap.entrySet()) {
            String folioNo = entryObject.getKey();
            List<DynamicObject> subList = entryObject.getValue();
            BigDecimal itemTotalAmount = BigDecimal.ZERO;
            for (DynamicObject itemObject : subList) {
                BigDecimal productAmount = itemObject.getBigDecimal("product_amount");
                itemTotalAmount = itemTotalAmount.add(productAmount);
            }
            itemObjectMap.put(folioNo, itemTotalAmount);
        }
        return itemObjectMap;
    }

    private Map<String, BigDecimal> getGroupPayAmountMethod(DynamicObject dynamicObject) {
        Map<String, List<DynamicObject>> payDynamicMap = this.getGroupPayListMethod(dynamicObject);
        HashMap<String, BigDecimal> payObjectMap = new HashMap<String, BigDecimal>(payDynamicMap.size());
        for (Map.Entry<String, List<DynamicObject>> entryObject : payDynamicMap.entrySet()) {
            String folioNo = entryObject.getKey();
            List<DynamicObject> subList = entryObject.getValue();
            BigDecimal payTotalAmount = BigDecimal.ZERO;
            for (DynamicObject payObject : subList) {
                BigDecimal payAmount = payObject.getBigDecimal("pay_amount");
                payTotalAmount = payTotalAmount.add(payAmount);
            }
            payObjectMap.put(folioNo, payTotalAmount);
        }
        return payObjectMap;
    }

    private Map<String, List<DynamicObject>> getGroupPayListMethod(DynamicObject dynamicObject) {
        DynamicObjectCollection payObjectCollection = dynamicObject.getDynamicObjectCollection("sim_isomerism_pay_data");
        HashMap<String, List<DynamicObject>> payDynamicMap = new HashMap<String, List<DynamicObject>>(payObjectCollection.size());
        for (DynamicObject payObject : payObjectCollection) {
            List<DynamicObject> subList;
            String folioNo = payObject.getString("folio_pay_no");
            if (StringUtils.isEmpty((CharSequence)folioNo)) continue;
            if (payDynamicMap.containsKey(folioNo)) {
                subList = (List)payDynamicMap.get(folioNo);
                subList.add(payObject);
                continue;
            }
            subList = new ArrayList();
            subList.add(payObject);
            payDynamicMap.put(folioNo, subList);
        }
        return payDynamicMap;
    }

    public boolean dealComparedAmountIsEqualMethod(DynamicObject dynamicObject) {
        Map<String, BigDecimal> itemObjectMap = this.getGroupItemAmountMethod(dynamicObject);
        Map<String, BigDecimal> payObjectMap = this.getGroupPayAmountMethod(dynamicObject);
        logger.info("dealComparedAmountIsEqualMethod, itemObjectMap\u5927\u5c0f\uff1a{}, payObjectMap\u5927\u5c0f:{}", (Object)itemObjectMap.size(), (Object)payObjectMap.size());
        HashSet<String> folioNoSet = new HashSet<String>(itemObjectMap.size());
        int num = 0;
        for (Map.Entry<String, BigDecimal> entryObject : itemObjectMap.entrySet()) {
            String folioNo = entryObject.getKey();
            BigDecimal itemAmount = entryObject.getValue();
            if (payObjectMap.containsKey(folioNo)) {
                BigDecimal payAmount = payObjectMap.get(folioNo);
                if (itemAmount == null || itemAmount.compareTo(payAmount) == 0) continue;
                ++num;
                continue;
            }
            folioNoSet.add(folioNo);
        }
        if (num > 0) {
            logger.info("dealComparedAmountIsEqualMethod, folioNoSet\u5927\u5c0f:{}", (Object)folioNoSet.size());
            if (folioNoSet.size() > 0) {
                ++num;
            }
        }
        logger.info("dealComparedAmountIsEqualMethod, num:{}", (Object)num);
        return num < 2;
    }

    private void dealGroupItemPayShareAmountMethod(DynamicObject dynamicObject) {
        String billNo = dynamicObject.getString("billno");
        logger.info("dealGroupItemPayShareAmountMethod, billNo:{}", (Object)billNo);
        Map<String, BigDecimal> itemObjectMap = this.getGroupItemAmountMethod(dynamicObject);
        Map<String, BigDecimal> payObjectMap = this.getGroupPayAmountMethod(dynamicObject);
        for (Map.Entry<String, BigDecimal> entryObject : itemObjectMap.entrySet()) {
            List<DynamicObject> itemObjectList;
            Map<String, List<DynamicObject>> itemDynamicMap;
            String folioNo = entryObject.getKey();
            BigDecimal itemTotalAmount = entryObject.getValue();
            logger.info("dealGroupItemPayShareAmountMethod, folioNo:{}, itemTotalAmount:{}", (Object)folioNo, (Object)itemTotalAmount);
            if (payObjectMap.containsKey(folioNo) && itemTotalAmount != null) {
                BigDecimal canOpenPayAmount;
                BigDecimal notCanOpenAmount;
                BigDecimal disAmount2;
                List<DynamicObject> itemObjectList2;
                Map<String, List<DynamicObject>> itemDynamicMap2;
                BigDecimal disAmount;
                BigDecimal payTotalAmount = payObjectMap.get(folioNo);
                if (itemTotalAmount.compareTo(payTotalAmount) == 0) {
                    itemDynamicMap = this.getGroupItemListMethod(dynamicObject);
                    itemObjectList = itemDynamicMap.get(folioNo);
                    logger.info("\u573a\u666f\u4e00\uff0c\u5f00\u59cb\u505a\u91d1\u989d\u5206\u644a\u903b\u8f91\uff0citemObjectList\u7684\u5927\u5c0f:{}", (Object)(itemObjectList == null ? 0 : itemObjectList.size()));
                    if (itemObjectList == null) continue;
                    BigDecimal canShareAmount = this.dealGetCanShareAmountMethod(folioNo, dynamicObject);
                    BigDecimal totalAmount = this.dealGetCanOpenItemAmountMethod(folioNo, dynamicObject);
                    logger.info("\u573a\u666f\u4e00\uff0ccanShareAmount:{}, totalAmount:{}", (Object)canShareAmount, (Object)totalAmount);
                    this.dealShareItemAmountMethod(canShareAmount, totalAmount, itemObjectList);
                    continue;
                }
                if (itemTotalAmount.compareTo(payTotalAmount) < 0) {
                    disAmount = payTotalAmount.subtract(itemTotalAmount);
                    logger.error("dealGroupItemPayShareAmountMethod, folioNo:{}, payTotalAmount:{}, itemTotalAmount:{}, disAmount:{}", new Object[]{folioNo, payTotalAmount, itemTotalAmount, disAmount});
                    itemDynamicMap2 = this.getGroupItemListMethod(dynamicObject);
                    itemObjectList2 = itemDynamicMap2.get(folioNo);
                    List<DynamicObject> disItemList = this.getDisItemListMethod(dynamicObject, itemObjectMap, disAmount);
                    if (disItemList.isEmpty()) {
                        disAmount2 = itemTotalAmount.subtract(payTotalAmount);
                        logger.info("dealGroupItemPayShareAmountMethod, folioNo:{}, disAmount2:{}", (Object)folioNo, (Object)disAmount2);
                        List<DynamicObject> disPayList = this.getDisPayListMethod(dynamicObject, itemObjectMap, disAmount2);
                        if (disPayList.isEmpty()) {
                            logger.error("dealGroupItemPayShareAmountMethod, \u4e0d\u5b58\u5728\u5176\u5b83\u8d1f\u6570\u884c\u7684\u652f\u4ed8\u660e\u7ec6\u9879\uff01");
                            continue;
                        }
                        payTotalAmount = payTotalAmount.add(disAmount2);
                    } else {
                        itemTotalAmount = itemTotalAmount.add(disAmount);
                        itemObjectList2.addAll(disItemList);
                    }
                    if (itemObjectList2 == null) continue;
                    logger.info("\u573a\u666f\u4e8c\uff0c\u5f00\u59cb\u505a\u91d1\u989d\u5206\u644a\u903b\u8f91\uff0citemObjectList\u7684\u5927\u5c0f:{}", (Object)(itemObjectList2 == null ? 0 : itemObjectList2.size()));
                    notCanOpenAmount = this.dealGetNoCanOpenPayAmountMethod(folioNo, dynamicObject);
                    canOpenPayAmount = payTotalAmount.subtract(notCanOpenAmount);
                    logger.info("\u573a\u666f\u4e8c\uff0cpayTotalAmount:{}, notCanOpenAmount:{}, canOpenPayAmount:{}", new Object[]{payTotalAmount, notCanOpenAmount, canOpenPayAmount});
                    this.dealShareItemAmountMethod(canOpenPayAmount, itemTotalAmount, itemObjectList2);
                    continue;
                }
                if (itemTotalAmount.compareTo(payTotalAmount) <= 0) continue;
                disAmount = itemTotalAmount.subtract(payTotalAmount);
                logger.error("dealGroupItemPayShareAmountMethod, folioNo:{}, itemTotalAmount:{}, payTotalAmount:{}, disAmount:{}", new Object[]{folioNo, itemTotalAmount, payTotalAmount, disAmount});
                itemDynamicMap2 = this.getGroupItemListMethod(dynamicObject);
                itemObjectList2 = itemDynamicMap2.get(folioNo);
                List<DynamicObject> disPayList = this.getDisPayListMethod(dynamicObject, payObjectMap, disAmount);
                if (disPayList.isEmpty()) {
                    disAmount2 = payTotalAmount.subtract(itemTotalAmount);
                    logger.info("dealGroupItemPayShareAmountMethod, folioNo:{}, disAmount2:{}", (Object)folioNo, (Object)disAmount2);
                    List<DynamicObject> disItemList = this.getDisItemListMethod(dynamicObject, itemObjectMap, disAmount2);
                    if (disItemList.isEmpty()) {
                        logger.error("dealGroupItemPayShareAmountMethod, \u4e0d\u5b58\u5728\u5176\u5b83\u8d1f\u6570\u884c\u7684\u6d88\u8d39\u660e\u7ec6\u9879\uff01");
                        continue;
                    }
                    itemTotalAmount = itemTotalAmount.add(disAmount2);
                    itemObjectList2.addAll(disItemList);
                } else {
                    payTotalAmount = payTotalAmount.add(disAmount);
                }
                logger.info("\u573a\u666f\u4e09\uff0c\u5f00\u59cb\u505a\u91d1\u989d\u5206\u644a\u903b\u8f91\uff0citemObjectList\u7684\u5927\u5c0f:{}", (Object)(itemObjectList2 == null ? 0 : itemObjectList2.size()));
                if (itemObjectList2 == null) continue;
                notCanOpenAmount = this.dealGetNoCanOpenPayAmountMethod(folioNo, dynamicObject);
                canOpenPayAmount = payTotalAmount.subtract(notCanOpenAmount);
                logger.info("\u573a\u666f\u4e09\uff0cpayTotalAmount:{}, notCanOpenAmount:{}, canOpenPayAmount:{}", new Object[]{payTotalAmount, notCanOpenAmount, canOpenPayAmount});
                this.dealShareItemAmountMethod(canOpenPayAmount, itemTotalAmount, itemObjectList2);
                continue;
            }
            boolean canOpenFlag = this.dealSpecialCompareAmountMethod(dynamicObject, itemTotalAmount, folioNo);
            if (!canOpenFlag) continue;
            itemDynamicMap = this.getGroupItemListMethod(dynamicObject);
            itemObjectList = itemDynamicMap.get(folioNo);
            logger.info("\u573a\u666f\u56db\uff0c\u5f00\u59cb\u505a\u91d1\u989d\u5206\u644a\u903b\u8f91\uff0citemObjectList\u7684\u5927\u5c0f:{}", (Object)(itemObjectList == null ? 0 : itemObjectList.size()));
            if (itemObjectList == null) continue;
            this.dealShareItemAmountMethod(itemTotalAmount, itemTotalAmount, itemObjectList);
        }
    }

    private BigDecimal dealGetNoCanOpenPayAmountMethod(String folioNo, DynamicObject dynamicObject) {
        BigDecimal notCanOpenAmount = BigDecimal.ZERO;
        DynamicObjectCollection payObjectCollection = dynamicObject.getDynamicObjectCollection("sim_isomerism_pay_data");
        for (DynamicObject payObject : payObjectCollection) {
            String folio_pay_no = payObject.getString("folio_pay_no");
            BigDecimal payAmount = payObject.getBigDecimal("pay_amount");
            String is_invoiced = payObject.getString("is_invoiced");
            if (payAmount == null || payAmount.compareTo(BigDecimal.ZERO) == 0 || !StringUtils.isNotEmpty((CharSequence)is_invoiced) || !"0".equals(is_invoiced) || !folioNo.equals(folio_pay_no)) continue;
            notCanOpenAmount = notCanOpenAmount.add(payAmount);
        }
        logger.info("dealGetNoCanOpenPayAmountMethod, folioNo:{}, notCanOpenAmount:{}", (Object)folioNo, (Object)notCanOpenAmount);
        return notCanOpenAmount;
    }

    private BigDecimal dealGetCanShareAmountMethod(String folioNo, DynamicObject dynamicObject) {
        BigDecimal canOpenItemAmount = this.dealGetCanOpenItemAmountMethod(folioNo, dynamicObject);
        BigDecimal canOpenPayAmount = this.dealGetCanOpenPayAmountMethod(folioNo, dynamicObject);
        if (canOpenPayAmount == null || canOpenPayAmount.compareTo(BigDecimal.ZERO) == 0) {
            BigDecimal noFolioNoPayAmount = this.dealGetSpecialPayAmountMethod(dynamicObject);
            logger.info("dealGetCanShareAmountMethod, noFolioNoPayAmount:{}", (Object)noFolioNoPayAmount);
            if (noFolioNoPayAmount != null && noFolioNoPayAmount.compareTo(BigDecimal.ZERO) > 0) {
                canOpenPayAmount = noFolioNoPayAmount;
            }
        }
        logger.info("dealGetCanShareAmountMethod, canOpenPayAmount:{}, canOpenItemAmount:{}", (Object)canOpenPayAmount, (Object)canOpenItemAmount);
        if (canOpenPayAmount != null && canOpenPayAmount.compareTo(canOpenItemAmount) > 0) {
            return canOpenItemAmount;
        }
        return canOpenPayAmount;
    }

    private BigDecimal dealGetSpecialPayAmountMethod(DynamicObject dynamicObject) {
        BigDecimal noFolioNoPayAmount = BigDecimal.ZERO;
        DynamicObjectCollection payObjectCollection = dynamicObject.getDynamicObjectCollection("sim_isomerism_pay_data");
        for (DynamicObject payObject : payObjectCollection) {
            String folio_pay_no = payObject.getString("folio_pay_no");
            BigDecimal payAmount = payObject.getBigDecimal("pay_amount");
            String is_invoiced = payObject.getString("is_invoiced");
            logger.info("dealGetSpecialPayAmountMethod, folio_pay_no:{}, payAmount:{}, is_invoiced:{}", new Object[]{folio_pay_no, payAmount, is_invoiced});
            if (!StringUtils.isEmpty((CharSequence)folio_pay_no) || payAmount.compareTo(BigDecimal.ZERO) <= 0 || !"1".equals(is_invoiced)) continue;
            noFolioNoPayAmount = noFolioNoPayAmount.add(payAmount);
        }
        return noFolioNoPayAmount;
    }

    private BigDecimal dealGetCanOpenItemAmountMethod(String folioNo, DynamicObject dynamicObject) {
        BigDecimal canOpenItemAmount = BigDecimal.ZERO;
        DynamicObjectCollection itemObjectCollection = dynamicObject.getDynamicObjectCollection("sim_isomerism_item_data");
        for (DynamicObject itemObject : itemObjectCollection) {
            BigDecimal product_amount = itemObject.getBigDecimal("product_amount");
            String folio_no = itemObject.getString("folio_no");
            String invoicable_switch = itemObject.getString("invoicable_switch");
            if (StringUtils.isEmpty((CharSequence)folio_no) || product_amount == null || product_amount.compareTo(BigDecimal.ZERO) == 0 || StringUtils.isEmpty((CharSequence)invoicable_switch) || "0".equals(invoicable_switch) || !folioNo.equals(folio_no)) continue;
            canOpenItemAmount = canOpenItemAmount.add(product_amount);
        }
        logger.info("dealGetCanOpenItemAmountMethod, folioNo:{}, canShareItemAmount:{}", (Object)folioNo, (Object)canOpenItemAmount);
        return canOpenItemAmount;
    }

    private BigDecimal dealGetCanOpenPayAmountMethod(String folioNo, DynamicObject dynamicObject) {
        BigDecimal canOpenPayAmount = BigDecimal.ZERO;
        DynamicObjectCollection payObjectCollection = dynamicObject.getDynamicObjectCollection("sim_isomerism_pay_data");
        for (DynamicObject payObject : payObjectCollection) {
            String folio_pay_no = payObject.getString("folio_pay_no");
            BigDecimal payAmount = payObject.getBigDecimal("pay_amount");
            String is_invoiced = payObject.getString("is_invoiced");
            if (StringUtils.isEmpty((CharSequence)folio_pay_no) || payAmount == null || payAmount.compareTo(BigDecimal.ZERO) == 0 || StringUtils.isEmpty((CharSequence)is_invoiced) || "0".equals(is_invoiced) || !folioNo.equals(folio_pay_no)) continue;
            canOpenPayAmount = canOpenPayAmount.add(payAmount);
        }
        logger.info("dealGetCanOpenPayAmountMethod, folioNo:{}, canOpenPayAmount:{}", (Object)folioNo, (Object)canOpenPayAmount);
        return canOpenPayAmount;
    }

    private boolean dealSpecialCompareAmountMethod(DynamicObject dynamicObject, BigDecimal itemTotalAmount, String folioNo) {
        BigDecimal subAmount = BigDecimal.ZERO;
        DynamicObjectCollection payObjectCollection = dynamicObject.getDynamicObjectCollection("sim_isomerism_pay_data");
        for (DynamicObject payObject : payObjectCollection) {
            String folio_pay_no = payObject.getString("folio_pay_no");
            BigDecimal payAmount = payObject.getBigDecimal("pay_amount");
            if (payAmount.compareTo(BigDecimal.ZERO) == 0 || folioNo.equals(folio_pay_no) || (subAmount = subAmount.add(payAmount)).compareTo(BigDecimal.ZERO) <= 0 || subAmount.compareTo(itemTotalAmount) != 0) continue;
            return true;
        }
        return false;
    }

    private List<DynamicObject> getDisPayListMethod(DynamicObject dynamicObject, Map<String, BigDecimal> payObjectMap, BigDecimal disAmount) {
        BigDecimal subAmount = BigDecimal.ZERO;
        DynamicObjectCollection payObjectCollection = dynamicObject.getDynamicObjectCollection("sim_isomerism_pay_data");
        ArrayList<DynamicObject> subList = new ArrayList<DynamicObject>(payObjectCollection.size());
        for (DynamicObject payObject : payObjectCollection) {
            String folioNo = payObject.getString("folio_pay_no");
            BigDecimal payAmount = payObject.getBigDecimal("pay_amount");
            if (payObjectMap.containsKey(folioNo) || payAmount.compareTo(BigDecimal.ZERO) == 0) continue;
            if (payAmount.compareTo(disAmount) == 0) {
                subList.add(payObject);
                break;
            }
            if (subAmount.compareTo(BigDecimal.ZERO) > 0 && subAmount.compareTo(disAmount) == 0) break;
            subAmount = subAmount.add(payAmount);
            subList.add(payObject);
        }
        logger.info("getDisPayListMethod, subList\u5927\u5c0f:{}, subAmount\uff1a{}, disAmount:{}", new Object[]{subList.size(), subAmount, disAmount});
        return subList;
    }

    private List<DynamicObject> getDisItemListMethod(DynamicObject dynamicObject, Map<String, BigDecimal> itemObjectMap, BigDecimal disAmount) {
        logger.info("getDisItemListMethod, itemObjectMap:{}", itemObjectMap);
        BigDecimal subAmount = BigDecimal.ZERO;
        DynamicObjectCollection itemObjectCollection = dynamicObject.getDynamicObjectCollection("sim_isomerism_item_data");
        ArrayList<DynamicObject> subList = new ArrayList<DynamicObject>(itemObjectCollection.size());
        for (DynamicObject itemObject : itemObjectCollection) {
            String folioNo = itemObject.getString("folio_no");
            BigDecimal productAmount = itemObject.getBigDecimal("product_amount");
            logger.info("getDisItemListMethod, folioNo:{}, productAmount:{}", (Object)folioNo, (Object)productAmount);
            if (itemObjectMap.containsKey(folioNo) || productAmount.compareTo(BigDecimal.ZERO) == 0) continue;
            if (productAmount.compareTo(disAmount) == 0) {
                subList.add(itemObject);
                break;
            }
            if (subAmount.compareTo(BigDecimal.ZERO) > 0 && subAmount.compareTo(disAmount) == 0) break;
            subAmount = subAmount.add(productAmount);
            subList.add(itemObject);
        }
        logger.info("getDisItemListMethod, subList\u5927\u5c0f:{}, subAmount\uff1a{}, disAmount:{}", new Object[]{subList.size(), subAmount, disAmount});
        return subList;
    }

    private void dealShareItemAmountMethod(BigDecimal canShareAmount, BigDecimal totalAmount, List<DynamicObject> itemObjectList) {
        logger.info("dealShareItemAmountMethod, canShareAmount:{}, totalAmount:{}, itemObjectList\u5927\u5c0f:{}", new Object[]{canShareAmount, totalAmount, itemObjectList.size()});
        if (canShareAmount == null || totalAmount == null) {
            logger.error("dealShareItemAmountMethod, \u53ef\u5206\u6ee9\u91d1\u989d\u6216\u603b\u91d1\u989d\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u591f\u7ee7\u7eed\u6267\u884c\u5904\u7406\uff01");
            return;
        }
        if (canShareAmount.compareTo(BigDecimal.ZERO) == 0 || totalAmount.compareTo(BigDecimal.ZERO) == 0) {
            logger.error("dealShareItemAmountMethod, \u53ef\u5206\u6ee9\u91d1\u989d\u6216\u603b\u91d1\u989d\u4e3a0\uff0c\u4e0d\u80fd\u591f\u7ee7\u7eed\u6267\u884c\u5904\u7406\uff01");
            return;
        }
        ArrayList<DynamicObject> subList = new ArrayList<DynamicObject>(itemObjectList.size());
        for (DynamicObject billItemObject : itemObjectList) {
            BigDecimal productAmount = billItemObject.getBigDecimal("product_amount");
            String invoicable_switch = billItemObject.getString("invoicable_switch");
            if ("0".equals(invoicable_switch) || productAmount == null || productAmount.compareTo(BigDecimal.ZERO) == 0) continue;
            String productCode = billItemObject.getString("product_code");
            BigDecimal avgAmount = this.countShareAmountMethod(totalAmount, canShareAmount, productAmount);
            logger.info("dealCountBillAmountMethod, productCode:{}, productAmount:{}, avgAmount:{}", new Object[]{productCode, productAmount, avgAmount});
            billItemObject.set("avg_amount", (Object)avgAmount);
            billItemObject.set("unpushamount", (Object)avgAmount);
            BigDecimal taxRate = billItemObject.getBigDecimal("tax_rate");
            BigDecimal taxAmount = TaxCalcUtil.calTax((BigDecimal)new BigDecimal(avgAmount.toString()), (BigDecimal)BigDecimal.ZERO, (String)taxRate.toString(), (boolean)true);
            billItemObject.set("tax_amount", (Object)taxAmount);
            billItemObject.set("unpushtax", (Object)taxAmount);
            subList.add(billItemObject);
        }
        logger.info("dealShareItemAmountMethod, subList\u5927\u5c0f:{}", (Object)subList.size());
        if (subList.size() > 0) {
            this.dealTailDifferenceAmountMethod(subList, canShareAmount);
        }
    }

    private void dealTailDifferenceAmountMethod(List<DynamicObject> itemObjectList, BigDecimal disTotalAmount) {
        BigDecimal sumAmount = new BigDecimal("0.00");
        for (int i = 0; i < itemObjectList.size() - 1; ++i) {
            DynamicObject dynamicObject = itemObjectList.get(i);
            BigDecimal openInvoiceAmount = dynamicObject.getBigDecimal("avg_amount");
            sumAmount = sumAmount.add(openInvoiceAmount);
        }
        logger.info("dealTailDifferenceAmountMethod, sumAmount:{}", (Object)sumAmount);
        BigDecimal lastBillAmount = itemObjectList.get(itemObjectList.size() - 1).getBigDecimal("avg_amount");
        BigDecimal disAmount = disTotalAmount.subtract(sumAmount);
        logger.info("dealTailDifferenceAmountMethod, lastBillAmount:{}, disAmount:{}", (Object)lastBillAmount, (Object)disAmount);
        if (lastBillAmount.compareTo(disAmount) != 0) {
            DynamicObject lastBillObject = itemObjectList.get(itemObjectList.size() - 1);
            lastBillObject.set("avg_amount", (Object)disAmount);
            lastBillObject.set("unpushamount", (Object)disAmount);
            BigDecimal taxRate = lastBillObject.getBigDecimal("tax_rate");
            BigDecimal taxAmount = TaxCalcUtil.calTax((BigDecimal)new BigDecimal(disAmount.toString()), (BigDecimal)BigDecimal.ZERO, (String)taxRate.toString(), (boolean)true);
            lastBillObject.set("tax_amount", (Object)taxAmount);
            lastBillObject.set("unpushtax", (Object)taxAmount);
        }
    }

    private BigDecimal countShareAmountMethod(BigDecimal totalAmount, BigDecimal canShareAmount, BigDecimal productAmount) {
        logger.info("countShareAmountMethod, productAmount:{}, totalAmount:{}, canShareAmount:{}", new Object[]{productAmount, totalAmount, canShareAmount});
        double product_amount = productAmount.doubleValue();
        double bill_total_amount = totalAmount.doubleValue();
        double can_share_amount = canShareAmount.doubleValue();
        double avg_amount = product_amount / bill_total_amount * can_share_amount;
        BigDecimal avgAmount = BigDecimal.valueOf(avg_amount).setScale(2, 4);
        return avgAmount;
    }

    private BigDecimal dealCountCommonOpenAmountMethod(DynamicObject dynamicObject) {
        BigDecimal canItemAmount;
        BigDecimal canPayAmount = this.dealCountCanPayAmountMethod(dynamicObject);
        BigDecimal canOpenInvoiceAmount = canPayAmount.compareTo(canItemAmount = this.dealCountCanItemAmountMethod(dynamicObject)) >= 0 ? canItemAmount : canPayAmount;
        return canOpenInvoiceAmount;
    }

    private BigDecimal dealCountCanPayAmountMethod(DynamicObject dynamicObject) {
        BigDecimal canPayAmount = new BigDecimal("0.00");
        DynamicObjectCollection payDataCollection = dynamicObject.getDynamicObjectCollection("sim_isomerism_pay_data");
        for (DynamicObject payDataObject : payDataCollection) {
            String is_invoiced = payDataObject.getString("is_invoiced");
            BigDecimal pay_amount = payDataObject.getBigDecimal("pay_amount");
            if (!"1".equals(is_invoiced)) continue;
            canPayAmount = canPayAmount.add(pay_amount);
        }
        return canPayAmount;
    }

    private BigDecimal dealCountItemTotalAmountMethod(DynamicObject dynamicObject) {
        BigDecimal totalItemAmount = new BigDecimal("0.00");
        DynamicObjectCollection itemObjectCollection = dynamicObject.getDynamicObjectCollection("sim_isomerism_item_data");
        for (DynamicObject itemObject : itemObjectCollection) {
            BigDecimal product_amount = itemObject.getBigDecimal("product_amount");
            totalItemAmount = totalItemAmount.add(product_amount);
        }
        return totalItemAmount;
    }

    private BigDecimal dealCountCanItemAmountMethod(DynamicObject dynamicObject) {
        BigDecimal canItemAmount = new BigDecimal("0.00");
        DynamicObjectCollection itemDataCollection = dynamicObject.getDynamicObjectCollection("sim_isomerism_item_data");
        for (DynamicObject itemDataObject : itemDataCollection) {
            String invoicable_switch = itemDataObject.getString("invoicable_switch");
            BigDecimal product_amount = itemDataObject.getBigDecimal("product_amount");
            if (!"1".equals(invoicable_switch)) continue;
            canItemAmount = canItemAmount.add(product_amount);
        }
        return canItemAmount;
    }

    private BigDecimal dealCountCanOpenPayAmountMethod(DynamicObject dynamicObject) {
        BigDecimal totalPayAmount = new BigDecimal("0.00");
        DynamicObjectCollection paymentObjectCollection = dynamicObject.getDynamicObjectCollection("sim_isomerism_pay_data");
        for (DynamicObject paymentObject : paymentObjectCollection) {
            String entry_no = paymentObject.getString("entry_no");
            if (!"PAY".equals(entry_no)) continue;
            BigDecimal payAmount = paymentObject.getBigDecimal("pay_amount");
            totalPayAmount = totalPayAmount.add(payAmount);
        }
        return totalPayAmount;
    }

    private void calculateDetailAmount(DynamicObject dynamicObject) {
        DynamicObjectCollection items = dynamicObject.getDynamicObjectCollection("sim_isomerism_item_data");
        try {
            HashMap<String, List<Object>> itemGroupMap = new HashMap<String, List<Object>>();
            HashMap<String, List<Object>> itemDOGroupMap = new HashMap<String, List<Object>>();
            for (Object item : items) {
                List<Object> list;
                String string = item.getString("folio_no");
                item.set("rowpushstatus", (Object)"1");
                if ("0".equals(item.getString("invoicable_switch"))) continue;
                if (itemGroupMap.containsKey(string)) {
                    list = (List)itemGroupMap.get(string);
                    list.add(item.getBigDecimal("product_amount"));
                } else {
                    list = new ArrayList();
                    list.add(item.getBigDecimal("product_amount"));
                    itemGroupMap.put(string, list);
                }
                if (itemDOGroupMap.containsKey(string)) {
                    list = (List)itemDOGroupMap.get(string);
                    list.add(item);
                    continue;
                }
                list = new ArrayList();
                list.add(item);
                itemDOGroupMap.put(string, list);
            }
            HashMap itemGroupAmountMap = new HashMap(itemGroupMap.size());
            for (Map.Entry entry : itemGroupMap.entrySet()) {
                BigDecimal totalPayAmount = BigDecimal.ZERO;
                for (Iterator bigDecimal : (List)entry.getValue()) {
                    totalPayAmount = totalPayAmount.add((BigDecimal)((Object)bigDecimal));
                }
                itemGroupAmountMap.put(entry.getKey(), totalPayAmount);
            }
            logger.info("calculateDetailAmount item totalAmount group\uff1a" + ((Object)itemGroupAmountMap).toString());
            DynamicObjectCollection payItems = dynamicObject.getDynamicObjectCollection("sim_isomerism_pay_data");
            Map<String, BigDecimal> map = this.getPayAmountGroup(payItems, true);
            logger.info("calculateDetailAmount pay totalAmount group\uff1a" + map.toString());
            Map<String, BigDecimal> payGroupEnableIssueAmount = this.getPayAmountGroup(payItems, false);
            logger.info("calculateDetailAmount pay issueAmount group\uff1a" + payGroupEnableIssueAmount.toString());
            HashMap needCalculateGroupMap = new HashMap();
            for (Map.Entry entry : itemGroupAmountMap.entrySet()) {
                BigDecimal itemTotalAmount = (BigDecimal)entry.getValue();
                BigDecimal payIssueTotalAmount = payGroupEnableIssueAmount.get(entry.getKey());
                if (payIssueTotalAmount != null && itemTotalAmount.compareTo(payIssueTotalAmount) > 0) {
                    needCalculateGroupMap.put(entry.getKey(), true);
                    continue;
                }
                needCalculateGroupMap.put(entry.getKey(), false);
            }
            for (Map.Entry entry : itemDOGroupMap.entrySet()) {
                String mapKey = (String)entry.getKey();
                List itemGroupList = (List)entry.getValue();
                for (DynamicObject item : itemGroupList) {
                    BigDecimal productAmount = item.getBigDecimal("product_amount");
                    String folioNo = item.getString("folio_no");
                    if (((Boolean)needCalculateGroupMap.get(mapKey)).booleanValue()) {
                        BigDecimal payIssueAmount = payGroupEnableIssueAmount.get(mapKey);
                        BigDecimal totalAmount = (BigDecimal)itemGroupAmountMap.get(folioNo);
                        BigDecimal actualItemAmount = productAmount.divide(map.get(mapKey), 20, RoundingMode.HALF_UP).multiply(payIssueAmount).setScale(2, RoundingMode.HALF_UP);
                        item.set("avg_amount", (Object)actualItemAmount);
                    } else {
                        BigDecimal payIssueTotalAmount = payGroupEnableIssueAmount.get(mapKey);
                        if (MathUtils.isZero((BigDecimal)payIssueTotalAmount)) {
                            item.set("avg_amount", (Object)BigDecimal.ZERO);
                        } else {
                            item.set("avg_amount", (Object)productAmount);
                        }
                    }
                    BigDecimal avg_amount = item.getBigDecimal("avg_amount");
                    BigDecimal tax = BigDecimal.ZERO;
                    if (!MathUtils.isZero((BigDecimal)avg_amount)) {
                        BigDecimal tax_rate = item.getBigDecimal("tax_rate");
                        BigDecimal amount = avg_amount.divide(BigDecimal.ONE.add(tax_rate), 2, RoundingMode.HALF_UP);
                        item.set("product_price", (Object)avg_amount.divide(item.getBigDecimal("product_quantity"), 10, RoundingMode.HALF_UP));
                        tax = avg_amount.subtract(amount);
                        item.set("tax_amount", (Object)tax);
                        item.set("rowpushstatus", (Object)"-1");
                    }
                    item.set("unpushamount", (Object)avg_amount);
                    item.set("unpushnum", item.get("product_quantity"));
                    item.set("unpushtax", (Object)tax);
                }
            }
            BigDecimal totalIssueAmount = BigDecimal.ZERO;
            for (Map.Entry entry : itemDOGroupMap.entrySet()) {
                String mapKey = (String)entry.getKey();
                List itemGroupList = (List)entry.getValue();
                if (itemGroupList.size() > 1 && ((Boolean)needCalculateGroupMap.get(mapKey)).booleanValue()) {
                    BigDecimal totalAmount = BigDecimal.ZERO;
                    for (int i = 0; i < itemGroupList.size() - 1; ++i) {
                        totalAmount = totalAmount.add(((DynamicObject)itemGroupList.get(i)).getBigDecimal("avg_amount"));
                    }
                    BigDecimal payIssueAmount = payGroupEnableIssueAmount.get(mapKey);
                    DynamicObject lastItem = (DynamicObject)itemGroupList.get(itemGroupList.size() - 1);
                    BigDecimal avgAmount = payIssueAmount.subtract(totalAmount);
                    if (avgAmount.compareTo(BigDecimal.ZERO) == 0) {
                        totalIssueAmount = totalIssueAmount.add(payIssueAmount);
                        continue;
                    }
                    lastItem.set("avg_amount", (Object)avgAmount);
                    BigDecimal tax_rate = lastItem.getBigDecimal("tax_rate");
                    BigDecimal amount = avgAmount.divide(BigDecimal.ONE.add(tax_rate), 2, RoundingMode.HALF_UP);
                    lastItem.set("product_price", (Object)avgAmount.divide(lastItem.getBigDecimal("product_quantity"), 10, RoundingMode.HALF_UP));
                    lastItem.set("tax_amount", (Object)avgAmount.subtract(amount));
                    totalIssueAmount = totalIssueAmount.add(payIssueAmount);
                    continue;
                }
                for (DynamicObject item : itemGroupList) {
                    totalIssueAmount = totalIssueAmount.add(item.getBigDecimal("avg_amount"));
                }
            }
            dynamicObject.set("invoicable_amount", (Object)totalIssueAmount);
            dynamicObject.set("remain_amount", (Object)totalIssueAmount);
            dynamicObject.set("pushstatus", (Object)"-1");
        }
        catch (Exception e) {
            logger.error("calculateDetailAmount error", (Throwable)e);
        }
    }

    private Map<String, BigDecimal> getPayAmountGroup(DynamicObjectCollection payItems, boolean isAll) {
        HashMap payGroupMap = new HashMap();
        for (DynamicObject payItem : payItems) {
            List<BigDecimal> list;
            String entry_no = payItem.getString("folio_pay_no");
            if (!isAll && "0".equals(payItem.getString("is_invoiced"))) continue;
            if (payGroupMap.containsKey(entry_no)) {
                list = (List)payGroupMap.get(entry_no);
                list.add(payItem.getBigDecimal("pay_amount"));
                continue;
            }
            list = new ArrayList();
            list.add(payItem.getBigDecimal("pay_amount"));
            payGroupMap.put(entry_no, list);
        }
        HashMap<String, BigDecimal> payGroupAmount = new HashMap<String, BigDecimal>(payGroupMap.size());
        for (Map.Entry entry : payGroupMap.entrySet()) {
            BigDecimal totalPayAmount = BigDecimal.ZERO;
            for (BigDecimal bigDecimal : (List)entry.getValue()) {
                totalPayAmount = totalPayAmount.add(bigDecimal);
            }
            payGroupAmount.put((String)entry.getKey(), totalPayAmount);
        }
        return payGroupAmount;
    }

    private void dealCreateBillPayDataMethod(DynamicObject dynamicObject, JSONArray subArray, Map<String, Set<String>> subErrorMsgMap, String systemCode) {
        logger.info("OperaCommonLogicService, dealCreateBillPayDataMethod, billNo:{}, \u6267\u884c\u5f00\u59cb\uff01", (Object)dynamicObject.getString("billno"));
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("sim_isomerism_pay_data");
        if (dynamicObjectCollection == null) {
            String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u5355\u4e2d\u5fc3\u652f\u4ed8\u660e\u7ec6\u533a\u5143\u6570\u636e\u4e0d\u5b58\u5728\uff01", (String)"OperaCommonLogicService_1", (String)"imc-sim-service", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        if (dynamicObjectCollection.size() > 0) {
            dynamicObjectCollection.clear();
        }
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        for (int i = 0; i < subArray.size(); ++i) {
            JSONObject subObject = subArray.getJSONObject(i);
            String tcGroup = subObject.getString("tcGroup");
            if (!"PAY".equals(tcGroup) && !"IPA".equals(tcGroup)) continue;
            DynamicObject payObject = dynamicObjectCollection.addNew();
            String paymentMethod = subObject.getString("paymentMethod");
            payObject.set("pay_code", (Object)paymentMethod);
            payObject.set("pay_amount", (Object)subObject.getBigDecimal("actualAmount"));
            String folioNo = subObject.getString("folioNo");
            payObject.set("folio_pay_no", (Object)folioNo);
            payObject.set("entry_no", (Object)tcGroup);
            DynamicObject paymentObject = billCenterInvoiceCommonService.getPaymentObjectMethod(paymentMethod, subErrorMsgMap, systemCode);
            if (paymentObject != null) {
                payObject.set("pay_name", (Object)paymentObject.getString("name"));
                payObject.set("pay_desc", (Object)paymentObject.getString("name"));
                payObject.set("is_invoiced", (Object)paymentObject.getString("invoicable"));
                continue;
            }
            billCenterInvoiceCommonService.dealAddErrorMsgMethod("payCode", paymentMethod, subErrorMsgMap);
        }
        logger.info("OperaCommonLogicService, dealCreateBillPayDataMethod, billNo:{}, \u652f\u4ed8\u660e\u7ec6\u9879\u96c6\u5408\u5927\u5c0f:{},  \u6267\u884c\u7ed3\u675f\uff01", (Object)dynamicObject.getString("billno"), (Object)dynamicObjectCollection.size());
    }

    private void dealCreateBillItemDataMethod(DynamicObject dynamicObject, JSONArray subArray, Map<String, Set<String>> subErrorMsgMap) {
        logger.info("OperaCommonLogicService, dealCreateBillItemDataMethod, billNo:{}, \u6267\u884c\u5f00\u59cb\uff01", (Object)dynamicObject.getString("billno"));
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("sim_isomerism_item_data");
        if (dynamicObjectCollection == null) {
            String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u5355\u4e2d\u5fc3\u5546\u54c1\u660e\u7ec6\u533a\u5143\u6570\u636e\u4e0d\u5b58\u5728\uff01", (String)"OperaCommonLogicService_2", (String)"imc-sim-service", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        if (dynamicObjectCollection.size() > 0) {
            dynamicObjectCollection.clear();
        }
        for (int i = 0; i < subArray.size(); ++i) {
            JSONObject subObject = subArray.getJSONObject(i);
            String tcGroup = subObject.getString("tcGroup");
            if ("PAY".equals(tcGroup) || "IPA".equals(tcGroup)) continue;
            DynamicObject itemObject = dynamicObjectCollection.addNew();
            itemObject.set("product_id", (Object)subObject.getString("productId"));
            itemObject.set("product_name", (Object)subObject.getString("productName"));
            String productCode = subObject.getString("productCode");
            itemObject.set("product_code", (Object)productCode);
            itemObject.set("product_type", (Object)subObject.getString("productType"));
            itemObject.set("product_quantity", (Object)subObject.getIntValue("num"));
            itemObject.set("product_price", (Object)subObject.getBigDecimal("invoicableAmount"));
            BigDecimal productAmount = subObject.getBigDecimal("invoicableAmount");
            itemObject.set("product_amount", (Object)productAmount);
            itemObject.set("avg_amount", (Object)BigDecimal.ZERO);
            itemObject.set("tax_code", null);
            itemObject.set("tax_rate", null);
            itemObject.set("tax_amount", null);
            itemObject.set("consume_time", (Object)subObject.getDate("billDate"));
            itemObject.set("folio_no", (Object)subObject.getString("folioNo"));
            itemObject.set("tc_group", (Object)subObject.getString("tcGroup"));
            String systemCode = subObject.getString("systemCode");
            String orgCode = subObject.getString("orgCode");
            BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
            if (productAmount != null && productAmount.compareTo(BigDecimal.ZERO) != 0) {
                billCenterInvoiceCommonService.dealSplitDimensionMethod(systemCode, orgCode, productCode, itemObject, subErrorMsgMap);
            } else {
                billCenterInvoiceCommonService.dealSetDefaultOrgMethod(systemCode, orgCode, itemObject, subErrorMsgMap);
            }
            itemObject.set("unpushamount", (Object)BigDecimal.ZERO);
            itemObject.set("unpushtax", null);
            itemObject.set("unpushnum", (Object)subObject.getIntValue("num"));
            itemObject.set("rowpushstatus", (Object)"-1");
            this.dealSetItemOpenInvoiceTypeMethod(itemObject, systemCode, orgCode, productCode, subErrorMsgMap);
            itemObject.set("apply_no", (Object)systemCode);
        }
        logger.info("OperaCommonLogicService, dealCreateBillItemDataMethod, billNo:{}, \u6d88\u8d39\u660e\u7ec6\u9879\u96c6\u5408\u5927\u5c0f:{},  \u6267\u884c\u7ed3\u675f\uff01", (Object)dynamicObject.getString("billno"), (Object)dynamicObjectCollection.size());
    }

    private void dealSetItemOpenInvoiceTypeMethod(DynamicObject itemObject, String systemCode, String orgCode, String productCode, Map<String, Set<String>> subErrorMsgMap) {
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        QFilter qFilter = new QFilter("system_code", "=", (Object)systemCode).and("number", "=", (Object)orgCode);
        DynamicObject orgObject = billCenterInvoiceCommonService.getOrgMethod(qFilter);
        if (orgObject != null) {
            Long orgId = orgObject.getLong("id");
            DynamicObject specialInvoiceObject = billCenterInvoiceCommonService.dealGetSpecialInvoiceMethod(systemCode, orgId, productCode, null);
            if (specialInvoiceObject == null) {
                itemObject.set("openinvoicetype", (Object)"02");
            } else {
                String is_special_invoice = specialInvoiceObject.getString("is_special_invoice");
                if (StringUtils.isBlank((CharSequence)is_special_invoice) || "0".equals(is_special_invoice)) {
                    itemObject.set("openinvoicetype", (Object)"02");
                } else {
                    itemObject.set("openinvoicetype", (Object)"01");
                }
            }
        } else {
            billCenterInvoiceCommonService.dealAddErrorMsgMethod("orgCode", orgCode, subErrorMsgMap);
        }
    }

    private void dealCreateBillHeaderDataMethod(DynamicObject dynamicObject, JSONArray subArray, String userPhone, String billNo, Map<String, Set<String>> subErrorMsgMap) {
        logger.info("OperaCommonLogicService, dealCreateBillHeaderDataMethod, userPhone:{}, billNo:{}, \u6267\u884c\u5f00\u59cb\uff01", (Object)userPhone, (Object)billNo);
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        dynamicObject.set("billno", (Object)billNo);
        dynamicObject.set("billstatus", (Object)"C");
        dynamicObject.set("pushstatus", (Object)"-1");
        String systemCode = subArray.getJSONObject(0).getString("systemCode");
        dynamicObject.set("system_code", (Object)systemCode);
        BillCenterOrgMappingService billCenterOrgMappingService = new BillCenterOrgMappingService();
        DynamicObject frontSystemObject = billCenterOrgMappingService.loadSingleBySystemCode(systemCode);
        dynamicObject.set("system", (Object)frontSystemObject);
        dynamicObject.set("system_name", (Object)subArray.getJSONObject(0).getString("systemName"));
        dynamicObject.set("org_code", (Object)subArray.getJSONObject(0).getString("orgCode"));
        dynamicObject.set("org_name", (Object)subArray.getJSONObject(0).getString("orgName"));
        QFilter qFilter = new QFilter("system_code", "=", (Object)systemCode);
        DynamicObject orgObject = billCenterInvoiceCommonService.getOrgMethod(qFilter);
        if (orgObject == null) {
            billCenterInvoiceCommonService.dealAddErrorMsgMethod("orgCode", systemCode, subErrorMsgMap);
        } else {
            dynamicObject.set("org", (Object)orgObject);
        }
        dynamicObject.set("bill_create_time", (Object)new java.util.Date());
        dynamicObject.set("createtime", (Object)new java.util.Date());
        dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("bill_date", (Object)subArray.getJSONObject(0).getDate("billDate"));
        if ("null".equals(userPhone) || "NULL".equals(userPhone)) {
            userPhone = "";
        } else if (StringUtils.isNotEmpty((CharSequence)userPhone) && userPhone.startsWith("+86-")) {
            userPhone = userPhone.replace("+86-", "");
        }
        dynamicObject.set("user_phone", (Object)userPhone);
        dynamicObject.set("remark", null);
        BigDecimal totalAmount = subArray.getJSONObject(0).getBigDecimal("totalAmount");
        dynamicObject.set("total_amount", (Object)totalAmount);
        dynamicObject.set("invoicable_amount", (Object)totalAmount);
        dynamicObject.set("invoice_amount", (Object)BigDecimal.ZERO);
        dynamicObject.set("remain_amount", (Object)totalAmount);
        dynamicObject.set("invoice_status", (Object)"0");
        dynamicObject.set("begin_date", subArray.getJSONObject(0).getTimestamp("beginDate"));
        dynamicObject.set("end_date", subArray.getJSONObject(0).getTimestamp("endDate"));
        dynamicObject.set("block_code", (Object)subArray.getJSONObject(0).getString("blockCode"));
        dynamicObject.set("hsbz", (Object)"1");
        logger.info("OperaCommonLogicService, dealCreateBillHeaderDataMethod, \u6267\u884c\u5b8c\u6210\uff01");
    }

    private Map<String, JSONArray> dealBillDataTotalAmountMethod(JSONArray jsonArray) {
        HashMap<String, JSONArray> billDataMap = new HashMap<String, JSONArray>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONArray subArray;
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String userPhone = jsonObject.getString("userPhone");
            String billNo = jsonObject.getString("billNo");
            String systemCode = jsonObject.getString("systemCode");
            String key = userPhone + "-" + billNo + "-" + systemCode;
            if (StringUtils.isEmpty((CharSequence)userPhone)) {
                key = "NULL-" + billNo + "-" + systemCode;
            }
            if (billDataMap.containsKey(key)) {
                subArray = (JSONArray)billDataMap.get(key);
                subArray.add((Object)jsonObject);
                continue;
            }
            subArray = new JSONArray();
            subArray.add((Object)jsonObject);
            billDataMap.put(key, subArray);
        }
        for (Map.Entry entryObject : billDataMap.entrySet()) {
            JSONObject subObject;
            int i;
            JSONArray subArray = (JSONArray)entryObject.getValue();
            BigDecimal totalAmount = new BigDecimal("0.00");
            for (i = 0; i < subArray.size(); ++i) {
                subObject = subArray.getJSONObject(i);
                String tcGroup = subObject.getString("tcGroup");
                if (!"PAY".equals(tcGroup)) continue;
                totalAmount = totalAmount.add(subObject.getBigDecimal("actualAmount"));
            }
            for (i = 0; i < subArray.size(); ++i) {
                subObject = subArray.getJSONObject(i);
                subObject.put("totalAmount", (Object)totalAmount);
            }
        }
        return billDataMap;
    }

    private String getSQLMethod(String billNo, String phoneNumber, String startDate, String endDate, String dbUserName, String systemCode) {
        String tipMsg = ResManager.loadKDString((String)"\u6563\u5ba2\u56e2\u89c6\u56fe", (String)"OperaCommonLogicService_3", (String)"imc-sim-service", (Object[])new Object[0]);
        String table_name = this.getTableNameMethod(tipMsg, systemCode);
        if (StringUtils.isEmpty((CharSequence)table_name) || StringUtils.isEmpty((CharSequence)dbUserName)) {
            String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u5e93\u7528\u6237\u6216\u8868\u540d\u4e0d\u5b58\u5728\uff01", (String)"OperaCommonLogicService_4", (String)"imc-sim-service", (Object[])new Object[0]);
            throw new KDBizException(new ErrorCode("9999", errorMsg), new Object[0]);
        }
        if (table_name.startsWith(dbUserName)) {
            String sql = "select t.RESORT, t.RESV_STATUS, t.TRX_NO, t.TRX_DATE, t.TRX_CODE, t.DESCRIPTION, t.TC_GROUP, t.TRX_AMOUNT, t.GROSS_AMOUNT, t.REFERENCE,t.FOLIO_NO,t.CONFIRMATION_NO,t.PHONE_NUMBER, t.BEGIN_DATE, t.END_DATE from " + table_name + " t where t.RESV_STATUS='CHECKED OUT' ";
            if (StringUtils.isNotEmpty((CharSequence)startDate) && StringUtils.isNotEmpty((CharSequence)endDate)) {
                sql = sql + " AND t.END_DATE >= TO_DATE(?, 'YYYY-MM-DD') AND t.END_DATE < TO_DATE(?, 'YYYY-MM-DD')";
            } else if (StringUtils.isNotEmpty((CharSequence)billNo) && StringUtils.isNotEmpty((CharSequence)phoneNumber)) {
                sql = sql + " AND t.CONFIRMATION_NO=? AND t.PHONE_NUMBER like ?";
            } else if (StringUtils.isNotEmpty((CharSequence)billNo)) {
                sql = sql + " AND t.CONFIRMATION_NO=?";
            } else if (StringUtils.isNotEmpty((CharSequence)phoneNumber)) {
                sql = sql + " AND t.PHONE_NUMBER like ? ";
            }
            logger.info("\u8bfb\u53d6Opera\u7684\u9152\u5e97\u6563\u5ba2\u56e2\u8ba2\u5355\u6570\u636e\uff0c\u5f53\u524d\u6267\u884c\u7684SQL\u662f:{}", (Object)sql);
            return sql;
        }
        String errorMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u5e93\u7528\u6237:%1$s\uff0c\u6ca1\u6709\u6743\u9650\u8bbf\u95ee\u6b64\u89c6\u56fe\uff01", (String)"OperaCommonLogicService_5", (String)"imc-sim-service", (Object[])new Object[0]), dbUserName);
        throw new KDBizException(new ErrorCode("9999", errorMsg), new Object[0]);
    }

    private String getTableNameMethod(String name, String systemCode) {
        QFilter qFilter = new QFilter("name", "=", (Object)name).and("system_code", "=", (Object)systemCode);
        DynamicObject simPayObject = BusinessDataServiceHelper.loadSingle((String)"sim_pay_type", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (simPayObject != null) {
            return simPayObject.getString("number");
        }
        return "fp_query";
    }

    private void dealFormatBillDataMethod(ResultSet resultSet, JSONArray jsonArray, String systemCode, String blockCode) throws Exception {
        logger.info("dealFormatBillDataMethod\uff0c\u5f00\u59cb\u505a\u76f8\u5173\u7684\u7ed3\u679c\u96c6\u5185\u5bb9\u8f6c\u6362\u5904\u7406\uff01");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("systemCode", (Object)systemCode);
        BillCenterOrgMappingService orgMappingService = new BillCenterOrgMappingService();
        QFilter qFilter = new QFilter("number", "=", (Object)systemCode);
        DynamicObject frontSystemObject = orgMappingService.loadSingle(qFilter);
        if (frontSystemObject == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\uff1a%1$s\uff0c\u65e0\u6cd5\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u7cfb\u7edf\u53c2\u6570\u914d\u7f6e\uff01", (String)"OperaCommonLogicService_0", (String)"imc-sim-service", (Object[])new Object[0]), systemCode));
        }
        jsonObject.put("systemName", (Object)frontSystemObject.getString("name"));
        String resort = resultSet.getString("RESORT");
        jsonObject.put("orgCode", (Object)resort);
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        String orgName = billCenterInvoiceCommonService.getOrgNameMethod(resort, systemCode);
        jsonObject.put("orgName", (Object)orgName);
        String resv_status = resultSet.getString("RESV_STATUS");
        jsonObject.put("billStatus", (Object)resv_status);
        String trx_no = resultSet.getString("TRX_NO");
        jsonObject.put("productId", (Object)trx_no);
        Date trx_date = resultSet.getDate("TRX_DATE");
        jsonObject.put("billDate", (Object)trx_date);
        String trx_code = resultSet.getString("TRX_CODE");
        jsonObject.put("productCode", (Object)trx_code);
        String description = resultSet.getString("DESCRIPTION");
        jsonObject.put("productName", (Object)description);
        BigDecimal trx_amount = resultSet.getBigDecimal("TRX_AMOUNT");
        if (trx_amount == null) {
            trx_amount = BigDecimal.ZERO;
        }
        jsonObject.put("actualAmount", (Object)trx_amount);
        BigDecimal gross_amount = resultSet.getBigDecimal("GROSS_AMOUNT");
        if (gross_amount == null) {
            gross_amount = BigDecimal.ZERO;
        }
        jsonObject.put("invoicableAmount", (Object)gross_amount);
        String tc_group = resultSet.getString("TC_GROUP");
        jsonObject.put("tcGroup", (Object)tc_group);
        if ("PAY".equals(tc_group) || "IPA".equals(tc_group)) {
            jsonObject.put("paymentStatus", (Object)"2");
            jsonObject.put("paymentMethod", (Object)trx_code);
            jsonObject.put("productCode", null);
            jsonObject.put("invoicableAmount", (Object)BigDecimal.ZERO);
        }
        String reference = resultSet.getString("REFERENCE");
        jsonObject.put("remark", (Object)reference);
        String folio_no = resultSet.getString("FOLIO_NO");
        if (folio_no == null) {
            folio_no = "";
        }
        jsonObject.put("folioNo", (Object)folio_no);
        String confirmation_no = resultSet.getString("confirmation_no");
        jsonObject.put("billNo", (Object)confirmation_no);
        String phone_number = resultSet.getString("PHONE_NUMBER");
        if (StringUtils.isNotEmpty((CharSequence)phone_number) && phone_number.startsWith("86")) {
            phone_number = phone_number.replace("86", "").trim();
        }
        jsonObject.put("userPhone", (Object)phone_number);
        if (StringUtils.isNotEmpty((CharSequence)blockCode)) {
            String block_code = resultSet.getString("block_code");
            jsonObject.put("blockCode", (Object)block_code);
        }
        jsonObject.put("billCreateTime", (Object)new java.util.Date());
        jsonObject.put("billType", null);
        jsonObject.put("billEndTime", null);
        jsonObject.put("productType", null);
        jsonObject.put("num", (Object)1);
        jsonObject.put("projectStartTime", null);
        jsonObject.put("projectEndTime", null);
        jsonObject.put("opUser", null);
        jsonObject.put("billJsonData", null);
        jsonObject.put("invoiceStatus", (Object)0);
        jsonObject.put("invoiceAmount", (Object)BigDecimal.ZERO);
        jsonObject.put("remainAmount", (Object)BigDecimal.ZERO);
        jsonObject.put("userEmail", null);
        jsonObject.put("wxOpenId", null);
        jsonObject.put("beginDate", (Object)resultSet.getTimestamp("BEGIN_DATE"));
        jsonObject.put("endDate", (Object)resultSet.getTimestamp("END_DATE"));
        jsonArray.add((Object)jsonObject);
    }

    public void dealSaveInterfaceLogMethod(String systemCode, String[] paramArray, String billNoParam, int successNum, int errorNum) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("billNo", (Object)paramArray[0]);
            jsonObject.put("phoneNumber", (Object)paramArray[1]);
            jsonObject.put("blockCode", (Object)paramArray[2]);
            jsonObject.put("startDate", (Object)paramArray[3]);
            jsonObject.put("endDate", (Object)paramArray[4]);
            if (StringUtils.isNotEmpty((CharSequence)systemCode)) {
                jsonObject.put("systemCode", (Object)systemCode);
            }
            String paramContent = jsonObject.toJSONString();
            JSONObject returnObject = new JSONObject();
            returnObject.put("successNum", (Object)successNum);
            returnObject.put("errorNum", (Object)errorNum);
            String result = returnObject.toJSONString();
            BillCenterInvoiceLogService billCenterInvoiceLogService = new BillCenterInvoiceLogService();
            billCenterInvoiceLogService.dealSaveInterfaceLogDataByType("Opera", "1", billNoParam, paramContent, result);
        }
        catch (Exception e) {
            logger.error("dealSaveInterfaceLogMethod, \u4fdd\u5b58\u5931\u8d25\uff0c\u539f\u56e0\u662f:{}", (Object)e.getMessage());
        }
    }

    public boolean dealCheckItemPaymentAmountMethod(DynamicObject dynamicObject) {
        BigDecimal totalItemAmount = this.dealCountItemTotalAmountMethod(dynamicObject);
        BigDecimal totalPayAmount = this.dealCountCanOpenPayAmountMethod(dynamicObject);
        logger.info("dealCheckItemPaymentAmountMethod, totalItemAmount:{}, totalPayAmount:{}", (Object)totalItemAmount, (Object)totalPayAmount);
        return totalItemAmount.compareTo(BigDecimal.ZERO) > 0 && totalPayAmount.compareTo(BigDecimal.ZERO) > 0 && totalItemAmount.compareTo(totalPayAmount) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dealGetOperaBillNoMethod(DynamicObject frontSystemObject, String[] paramArray, Set<String> billNoSet) {
        block6: {
            String systemCode = frontSystemObject.getString("number");
            String dbUserName = frontSystemObject.getString("db_username");
            String startDate = paramArray[3];
            String endDate = paramArray[4];
            Connection connection = null;
            PreparedStatement statement = null;
            ResultSet resultSet = null;
            logger.info("dealGetOperaBillNoMethod, systemCode:{}, startDate:{}, endDate:{}", new Object[]{systemCode, startDate, endDate});
            int successNum = 0;
            int failNum = 0;
            try {
                connection = JdbcUtil.getConnection(frontSystemObject);
                String sql = this.dealExecSQLMethod(startDate, endDate, dbUserName, systemCode);
                statement = connection.prepareStatement(sql);
                Object[] params = this.dealSetFieldValueMethod(null, null, null, startDate, endDate);
                logger.info("dealGetOperaBillNoMethod, \u9884\u7f16\u8bd1SQL\u6210\u529f\uff0c\u51c6\u5907\u5f00\u59cb\u67e5\u8be2\u5bf9\u5e94\u7684\u7ed3\u679c\u96c6\u5185\u5bb9\uff01");
                JdbcUtil.fillStatement(statement, params);
                resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    String confirmation_no = resultSet.getString("confirmation_no");
                    logger.info("dealGetOperaBillNoMethod, confirmation_no:{}", (Object)confirmation_no);
                    billNoSet.add(confirmation_no);
                }
                successNum = billNoSet.size();
                String billNoParam = "\u5b9a\u65f6\u4efb\u52a1\u62c9\u53d6\u8ba2\u5355\u53f7\u5217\u8868\u6570\u636e";
                this.dealSaveInterfaceLogMethod(systemCode, paramArray, billNoParam, successNum, failNum);
            }
            catch (Exception e) {
                billNoSet.add(e.getMessage());
                failNum = billNoSet.size();
                logger.error("\u67e5\u8be2Opera\u8ba2\u5355\u53f7\u6570\u636e\u51fa\u73b0\u5f02\u5e38:{}", (Object)e.getMessage());
                break block6;
            }
            finally {
                String billNoParam = "\u5b9a\u65f6\u4efb\u52a1\u62c9\u53d6\u8ba2\u5355\u53f7\u5217\u8868\u6570\u636e";
                this.dealSaveInterfaceLogMethod(systemCode, paramArray, billNoParam, successNum, failNum);
                JdbcUtil.close(resultSet, statement, connection);
            }
            JdbcUtil.close(resultSet, statement, connection);
        }
    }

    private String dealExecSQLMethod(String startDate, String endDate, String dbUserName, String systemCode) {
        logger.info("dealExecSQLMethod, startDate:{}, endDate:{}, dbUserName:{}, systemCode:{}", new Object[]{startDate, endDate, dbUserName, systemCode});
        String tipMsg = ResManager.loadKDString((String)"\u6563\u5ba2\u56e2\u89c6\u56fe", (String)"OperaCommonLogicService_3", (String)"imc-sim-service", (Object[])new Object[0]);
        String table_name = this.getTableNameMethod(tipMsg, systemCode);
        if (StringUtils.isEmpty((CharSequence)table_name) || StringUtils.isEmpty((CharSequence)dbUserName)) {
            String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u5e93\u7528\u6237\u6216\u8868\u540d\u4e0d\u5b58\u5728\uff01", (String)"OperaCommonLogicService_4", (String)"imc-sim-service", (Object[])new Object[0]);
            throw new KDBizException(new ErrorCode("9999", errorMsg), new Object[0]);
        }
        if (table_name.startsWith(dbUserName)) {
            String sql = "select t.CONFIRMATION_NO from " + table_name + " t where t.RESV_STATUS='CHECKED OUT'  AND t.END_DATE >= TO_DATE(?, 'YYYY-MM-DD') AND t.END_DATE < TO_DATE(?, 'YYYY-MM-DD')";
            logger.info("\u8bfb\u53d6Opera\u8ba2\u5355\u53f7\u6570\u636e\uff0c\u5f53\u524d\u6267\u884c\u7684SQL\u662f:{}", (Object)sql);
            return sql;
        }
        String errorMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u5e93\u7528\u6237:%1$s\uff0c\u6ca1\u6709\u6743\u9650\u8bbf\u95ee\u6b64\u89c6\u56fe\uff01", (String)"OperaCommonLogicService_5", (String)"imc-sim-service", (Object[])new Object[0]), dbUserName);
        throw new KDBizException(new ErrorCode("9999", errorMsg), new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dealLoadDepartEmployeesMethod(List<String> userIdList, String startDate, String endDate) {
        block9: {
            String[] array;
            String driverName = ImcConfigUtil.getValue((String)CacheKeyEnum.EMPLOYEE_DEPART_DRIVER.getConfigType(), (String)CacheKeyEnum.EMPLOYEE_DEPART_DRIVER.getConfigKey());
            String dbAddress = ImcConfigUtil.getValue((String)CacheKeyEnum.EMPLOYEE_DEPART_LINK.getConfigType(), (String)CacheKeyEnum.EMPLOYEE_DEPART_LINK.getConfigKey());
            String userName = ImcConfigUtil.getValue((String)CacheKeyEnum.EMPLOYEE_DEPART_USER.getConfigType(), (String)CacheKeyEnum.EMPLOYEE_DEPART_USER.getConfigKey());
            String userPwd = ImcConfigUtil.getValue((String)CacheKeyEnum.EMPLOYEE_DEPART_PWD.getConfigType(), (String)CacheKeyEnum.EMPLOYEE_DEPART_PWD.getConfigKey());
            String dbViewName = ImcConfigUtil.getValue((String)CacheKeyEnum.EMPLOYEE_DEPART_VIEW.getConfigType(), (String)CacheKeyEnum.EMPLOYEE_DEPART_VIEW.getConfigKey());
            logger.info("dealLoadDepartEmployeesMethod, dbAddress:{}, userName:{}, userPwd:{}, dbViewName:{}", new Object[]{dbAddress, userName, userPwd, dbViewName});
            for (String element : array = new String[]{driverName, dbAddress, userName, userPwd, dbViewName}) {
                if (!StringUtils.isBlank((CharSequence)element)) continue;
                logger.error("dealLoadDepartEmployeesMethod\uff0c\u79bb\u804c\u5458\u5de5\u7684\u6570\u636e\u5e93\u76f8\u5173\u914d\u7f6e\u4e3a\u7a7a\uff01");
                return;
            }
            Connection connection = null;
            PreparedStatement statement = null;
            ResultSet resultSet = null;
            try {
                connection = JdbcUtil.getConnection(driverName, dbAddress, userName, userPwd);
                String sql = this.dealExecSQLMethod(dbViewName);
                statement = connection.prepareStatement(sql);
                if (StringUtils.isBlank((CharSequence)startDate)) {
                    startDate = DateUtils.format((java.util.Date)DateUtils.addDay((java.util.Date)new java.util.Date(), (int)-1));
                }
                if (StringUtils.isBlank((CharSequence)endDate)) {
                    endDate = DateUtils.format((java.util.Date)DateUtils.addDay((java.util.Date)new java.util.Date(), (int)1));
                }
                Object[] params = new Object[]{0, 2, startDate, endDate};
                JdbcUtil.fillStatement(statement, params);
                logger.info("dealLoadDepartEmployeesMethod, \u9884\u7f16\u8bd1SQL\u6210\u529f\uff0c\u51c6\u5907\u5f00\u59cb\u67e5\u8be2\u5bf9\u5e94\u7684\u7ed3\u679c\u96c6\u5185\u5bb9\uff01");
                resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    String userId = resultSet.getString("ZHR_SAP_SALARYNO");
                    userIdList.add(userId);
                }
                JdbcUtil.close(resultSet, statement, connection);
            }
            catch (Exception e) {
                logger.error("\u67e5\u8be2\u957f\u9686\u79bb\u804c\u5458\u5de5\u4e2d\u95f4\u8868\u51fa\u73b0\u5f02\u5e38:{}", (Object)e.getMessage());
                break block9;
            }
            finally {
                JdbcUtil.close(resultSet, statement, connection);
                logger.info("\u67e5\u8be2\u6267\u884c\u5b8c\u6210\uff0c\u79bb\u804c\u5458\u5de5\u5217\u8868\u5927\u5c0f:{}", (Object)userIdList.size());
            }
            logger.info("\u67e5\u8be2\u6267\u884c\u5b8c\u6210\uff0c\u79bb\u804c\u5458\u5de5\u5217\u8868\u5927\u5c0f:{}", (Object)userIdList.size());
        }
    }

    private String dealExecSQLMethod(String dbViewName) {
        String sql = "select ZHR_SAP_SALARYNO, ZHR_NAME, ZHR_STATUSID, ZHR_STATUS, ZHR_ENTERDATE, ZHR_LEAVEDATE, ZHR_BNAME, ZHR_PERUPDATEDATS from " + dbViewName + " where (ZHR_STATUSID=? or ZHR_STATUSID=?)  AND ZHR_PERUPDATEDATS >= TO_DATE(?, 'YYYY-MM-DD') AND ZHR_PERUPDATEDATS < TO_DATE(?, 'YYYY-MM-DD')";
        logger.info("\u67e5\u8be2\u79bb\u804c\u5458\u5de5\u4e2d\u95f4\u8868\u7684SQL\u8bed\u53e5:{}", (Object)sql);
        return sql;
    }
}

