/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.billcenter.sys.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.HttpClientUtils;
import kd.imc.bdm.common.dto.BillVo;
import kd.imc.bdm.common.openapi.InvoiceDetailVo;
import kd.imc.bdm.common.openapi.InvoiceVo;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.sim.billcenter.BillCenterInvoiceCommonService;
import kd.imc.sim.billcenter.BillCenterInvoiceLogService;
import kd.imc.sim.billcenter.BillCenterOrgMappingService;
import kd.imc.sim.billcenter.domain.ApprovalProcessFlowVO;
import kd.imc.sim.billcenter.domain.CenterElectronicsAmountVO;
import kd.imc.sim.billcenter.domain.CenterElectronicsDataVO;
import kd.imc.sim.billcenter.domain.CenterElectronicsDetailVO;
import kd.imc.sim.billcenter.domain.CenterElectronicsErrorVO;
import kd.imc.sim.billcenter.domain.CenterElectronicsInvoiceDetailVO;
import kd.imc.sim.billcenter.domain.CenterElectronicsOrderVO;
import kd.imc.sim.billcenter.domain.CenterElectronicsPriceVO;
import kd.imc.sim.billcenter.domain.CenterElectronicsStatusVO;
import kd.imc.sim.billcenter.sys.ExternalSystemsDataService;
import kd.imc.sim.common.constant.BillCenterLogEnum;
import kd.imc.sim.common.constant.ErrorType;
import kd.imc.sim.common.model.billcenter.BillErrorVo;
import kd.imc.sim.common.utils.TaxCalcUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class CenterElectronicsDataImpl
implements ExternalSystemsDataService {
    private static final Log logger = LogFactory.getLog(CenterElectronicsDataImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<BillVo> getData(JSONObject paramObject) {
        ArrayList<BillVo> applyBillList;
        block42: {
            int n;
            String[] stringArray;
            BillCenterInvoiceCommonService billCenterInvoiceCommonService;
            String billNoParam;
            DynamicObject frontSystemObject;
            String systemCode;
            String paramContent;
            block43: {
                applyBillList = new ArrayList<BillVo>();
                paramContent = paramObject.getString("paramContent");
                systemCode = paramObject.getString("systemCode");
                logger.info("CenterElectronicsDataImpl, paramContent:{}, systemCode:{}", (Object)paramContent, (Object)systemCode);
                if (StringUtils.isEmpty((CharSequence)paramContent) || StringUtils.isEmpty((CharSequence)systemCode)) {
                    throw new KDBizException(new ErrorCode(ErrorType.PARAM_IS_NULL.getErrcode(), ErrorType.PARAM_IS_NULL.getDescription()), new Object[]{systemCode});
                }
                try (DLock lock = DLock.create((String)"getCenterElectronicsOrderThread", (String)"getCenterElectronicsOrderLogic");){
                    if (lock.tryLock()) {
                        try {
                            String[] billNoArray;
                            BillCenterOrgMappingService orgMappingService = new BillCenterOrgMappingService();
                            frontSystemObject = orgMappingService.loadSingleBySystemCode(systemCode);
                            if (frontSystemObject == null) throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u672a\u5339\u914d\u5230\u4e2d\u53f0\u7535\u5b50\u7cfb\u7edf:%1$s\uff0c\u53c2\u6570\u914d\u7f6e\uff01", (String)"CenterElectronicsDataImpl_0", (String)"imc-sim-service", (Object[])new Object[0]), systemCode));
                            billNoParam = this.getBillNoParamMethod(paramContent);
                            logger.info("CenterElectronicsDataImpl, billNoParam:{}", (Object)billNoParam);
                            boolean flag = false;
                            String flagStr = frontSystemObject.getString("client_enc_key");
                            if (StringUtils.isNotEmpty((CharSequence)flagStr)) {
                                flag = Boolean.parseBoolean(flagStr);
                            }
                            if (flag) {
                                String result = this.getTestDemo();
                                this.dealBillDataCommonLogic(systemCode, billNoParam, paramContent, result, applyBillList);
                                break block42;
                            }
                            billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
                            if (billNoParam.contains(";")) {
                                String[] billNoArray2 = billNoParam.split(";");
                                String orderId = billNoArray2[0];
                                QFilter qFilter = new QFilter("bill_json_data", "=", (Object)orderId);
                                DynamicObjectCollection dynamicObjectCollection = billCenterInvoiceCommonService.dealCheckBillCenterDataMethod(qFilter);
                                if (dynamicObjectCollection == null || dynamicObjectCollection.isEmpty()) {
                                    String result = this.doGetDataService(frontSystemObject, paramContent);
                                    this.dealBillDataCommonLogic(systemCode, billNoParam, paramContent, result, applyBillList);
                                    break block42;
                                } else {
                                    String result = this.doGetDataService(frontSystemObject, paramContent);
                                    this.dealFilterExistDataMethod(dynamicObjectCollection, systemCode, billNoParam, paramContent, result, applyBillList);
                                }
                                break block42;
                            }
                            stringArray = billNoArray = billNoParam.split(",");
                            n = stringArray.length;
                            break block43;
                        }
                        catch (Exception e) {
                            logger.error("\u83b7\u53d6\u4e2d\u53f0\u7535\u5b50\u4e1a\u52a1\u7cfb\u7edf\u7684\u5f85\u7533\u8bf7\u5f00\u7968\u6570\u636e\u51fa\u73b0\u5f02\u5e38:{}", (Object)e.getMessage());
                            BillErrorVo billErrorVo = new BillErrorVo();
                            billErrorVo.setFailNum(1);
                            billErrorVo.setErrorMsg(e.getMessage());
                            applyBillList.add((BillVo)billErrorVo);
                            return applyBillList;
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                    String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u6b63\u5728\u62c9\u53d6\u8ba2\u5355\u6570\u636e\uff0c\u8bf7\u7a0d\u5019\u91cd\u8bd5!", (String)"CenterElectronicsDataImpl_14", (String)"imc-sim-service", (Object[])new Object[0]);
                    throw new KDBizException(errorMsg);
                }
            }
            for (int i = 0; i < n; ++i) {
                String result;
                String subOrderId = stringArray[i];
                DynamicObject dynamicObject = billCenterInvoiceCommonService.dealCheckBillCenterDataMethod("billno", subOrderId, systemCode);
                if (dynamicObject == null) {
                    result = this.doGetDataService(frontSystemObject, paramContent);
                    this.dealBillDataCommonLogic(systemCode, billNoParam, paramContent, result, applyBillList);
                    continue;
                }
                this.dealClearApprovalDataMethod(dynamicObject, systemCode);
                String billno = dynamicObject.getString("billno");
                String invoice_status = dynamicObject.getString("invoice_status");
                String push_status = dynamicObject.getString("pushstatus");
                logger.info("CenterElectronicsDataImpl, \u539f\u59cb\u8ba2\u5355\u7f16\u53f7:{}, \u53d1\u7968\u72b6\u6001:{}, \u4e0b\u63a8\u72b6\u6001:{}", new Object[]{billno, invoice_status, push_status});
                if ("1".equals(invoice_status) || "5".equals(invoice_status)) {
                    BillErrorVo billErrorVo = new BillErrorVo();
                    String errorMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8ba2\u5355\u7f16\u53f7:%1$s\uff0c\u5df2\u7ecf\u5b8c\u6210\u5f00\u7968\u64cd\u4f5c\uff01", (String)"CenterElectronicsDataImpl_2", (String)"imc-sim-service", (Object[])new Object[0]), billNoParam);
                    billErrorVo.setErrorMsg(errorMsg);
                    billErrorVo.setFailNum(1);
                    billErrorVo.setSuccessNum(0);
                    applyBillList.add((BillVo)billErrorVo);
                    return applyBillList;
                }
                if ("2".equals(invoice_status)) {
                    BillErrorVo billErrorVo = new BillErrorVo();
                    String errorMsg = ResManager.loadKDString((String)"\u6b64\u8ba2\u5355\u5df2\u90e8\u5206\u5f00\u7968\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d\u5f00\u5177\u5269\u4f59\u53d1\u7968\u91d1\u989d!", (String)"CenterElectronicsDataImpl_3", (String)"imc-sim-service", (Object[])new Object[0]);
                    billErrorVo.setErrorMsg(errorMsg);
                    billErrorVo.setFailNum(1);
                    applyBillList.add((BillVo)billErrorVo);
                    return applyBillList;
                }
                if ("0".equals(push_status) || "1".equals(push_status)) {
                    BillErrorVo billErrorVo = new BillErrorVo();
                    String errorMsg = ResManager.loadKDString((String)"\u6b64\u8ba2\u5355\u5df2\u4e0b\u63a8\u6216\u90e8\u5206\u4e0b\u63a8\u5904\u7406\uff0c\u4e0d\u80fd\u91cd\u590d\u62c9\u53d6\u8d26\u5355\u6570\u636e!", (String)"GalaSysDataImpl_13", (String)"imc-sim-service", (Object[])new Object[0]);
                    billErrorVo.setErrorMsg(errorMsg);
                    billErrorVo.setFailNum(1);
                    applyBillList.add((BillVo)billErrorVo);
                    return applyBillList;
                }
                result = this.doGetDataService(frontSystemObject, paramContent);
                this.dealBillDataCommonLogic(systemCode, billNoParam, paramContent, result, applyBillList);
            }
        }
        logger.info("\u76f4\u9500\u4e2d\u53f0\u67e5\u8be2\u5f97\u5230\u7684\u8d26\u5355\u4e2d\u5fc3\u5bf9\u8c61\u5217\u8868\u5927\u5c0f\u662f\uff1a{}", (Object)applyBillList.size());
        return applyBillList;
    }

    private void dealClearApprovalDataMethod(DynamicObject dynamicObject, String systemCode) {
        String wxOpenId = dynamicObject.getString("wx_open_id");
        if (StringUtils.isNotBlank((CharSequence)wxOpenId)) {
            ArrayList<String> wxOpenIdList = new ArrayList<String>(10);
            wxOpenIdList.add(wxOpenId);
            BillCenterInvoiceLogService billCenterInvoiceLogService = new BillCenterInvoiceLogService();
            billCenterInvoiceLogService.dealClearApprovalDataMethod(wxOpenIdList, systemCode);
        }
    }

    private void dealFilterExistDataMethod(DynamicObjectCollection dynamicObjectCollection, String systemCode, String billNoParam, String paramContent, String result, List<BillVo> applyBillList) {
        List subList;
        String billNo;
        this.dealSaveInterfaceLogDataByType(systemCode, BillCenterLogEnum.GET_ORDER_OP_TYPE.getBillStatus(), billNoParam, paramContent, result);
        HashMap<String, List<CenterElectronicsDetailVO>> billDetailMap = new HashMap<String, List<CenterElectronicsDetailVO>>(8);
        this.dealFormatCenterElectronicsMethod(result, billDetailMap);
        logger.info("dealFilterExistDataMethod, \u8f6c\u6362\u4e4b\u540e\uff0c\u76f4\u9500\u4e2d\u53f0\u7684\u6570\u636e\u7ed3\u6784\u5927\u5c0f\u662f:{}", (Object)billDetailMap.size());
        HashMap<String, List> hasExistBillDetailMap = new HashMap<String, List>(billDetailMap.size());
        HashMap<String, List<CenterElectronicsDetailVO>> centerElectronicsBillDetailMap = new HashMap<String, List<CenterElectronicsDetailVO>>(billDetailMap.size());
        ArrayList<String> wxOpenIdList = new ArrayList<String>(dynamicObjectCollection.size());
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            billNo = dynamicObject.getString("billno");
            subList = (List)billDetailMap.get(billNo);
            logger.info("dealFilterDataMethod, billNo:{}, subList\u5927\u5c0f:{}", (Object)billNo, (Object)subList.size());
            if (!billDetailMap.containsKey(billNo)) continue;
            String wxOpenId = dynamicObject.getString("wx_open_id");
            if (StringUtils.isNotBlank((CharSequence)wxOpenId)) {
                wxOpenIdList.add(wxOpenId);
            }
            String push_status = dynamicObject.getString("pushstatus");
            String invoice_status = dynamicObject.getString("invoice_status");
            logger.info("dealFilterDataMethod, billNo:{}, push_status:{}, invoice_status:{}", (Object)push_status, (Object)invoice_status);
            if ("1".equals(invoice_status) || "5".equals(invoice_status) || "2".equals(invoice_status)) {
                hasExistBillDetailMap.put(billNo, subList);
                continue;
            }
            if (!"0".equals(push_status) && !"1".equals(push_status)) continue;
            hasExistBillDetailMap.put(billNo, subList);
        }
        if (!wxOpenIdList.isEmpty()) {
            BillCenterInvoiceLogService billCenterInvoiceLogService = new BillCenterInvoiceLogService();
            billCenterInvoiceLogService.dealClearApprovalDataMethod(wxOpenIdList, systemCode);
        }
        for (Map.Entry entry : billDetailMap.entrySet()) {
            billNo = (String)entry.getKey();
            subList = (List)entry.getValue();
            if (hasExistBillDetailMap.containsKey(billNo)) continue;
            centerElectronicsBillDetailMap.put(billNo, subList);
        }
        if (hasExistBillDetailMap.size() > 0) {
            BillErrorVo billErrorVo = new BillErrorVo();
            billErrorVo.setFailNum(hasExistBillDetailMap.size());
            String string = ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u5355\u6570\u636e\u5df2\u4e0b\u63a8\u6216\u5df2\u5f00\u7968\u5904\u7406\uff01", (String)"CenterElectronicsDataImpl_17", (String)"imc-sim-service", (Object[])new Object[0]);
            billErrorVo.setErrorMsg(string);
            applyBillList.add((BillVo)billErrorVo);
        }
        if (hasExistBillDetailMap.size() == centerElectronicsBillDetailMap.size()) {
            return;
        }
        logger.info("dealFilterDataMethod, centerElectronicsBillDetailMap\u5927\u5c0f:{}", (Object)centerElectronicsBillDetailMap.size());
        this.dealCreateBillCenterDataMethod(centerElectronicsBillDetailMap, systemCode, applyBillList);
    }

    private String getBillNoParamMethod(String paramContent) {
        String opKey = this.getOpKeyMethod(paramContent);
        String billNoParam = "PC".equals(opKey) ? this.dealGetDataByPcMethod(paramContent) : this.dealGetDataByAppMethod(paramContent);
        if (StringUtils.isEmpty((CharSequence)billNoParam)) {
            String errorMsg = ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"CenterElectronicsDataImpl_16", (String)"imc-sim-service", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        return billNoParam;
    }

    private String dealGetDataByAppMethod(String paramContent) {
        StringBuilder stringBuilder = new StringBuilder();
        JSONObject paramObject = JSONObject.parseObject((String)paramContent);
        JSONArray billNoList = paramObject.getJSONArray("billNoList");
        for (Object obj : billNoList) {
            JSONObject jsonObject = (JSONObject)obj;
            String billNo = jsonObject.getString("billNo");
            stringBuilder.append(billNo).append(",");
        }
        return stringBuilder.toString();
    }

    private String dealGetDataByPcMethod(String paramContent) {
        JSONArray subBillNoList;
        JSONObject paramObject = JSONObject.parseObject((String)paramContent);
        StringBuilder builder = new StringBuilder();
        JSONArray billNoList = paramObject.getJSONArray("billNoList");
        if (billNoList != null && !billNoList.isEmpty()) {
            for (int i = 0; i < billNoList.size(); ++i) {
                JSONObject jsonObject = billNoList.getJSONObject(i);
                String billNo = jsonObject.getString("billNo");
                builder.append(billNo).append(";");
            }
        }
        if ((subBillNoList = paramObject.getJSONArray("subBillNoList")) != null && !subBillNoList.isEmpty()) {
            builder = new StringBuilder();
            for (int i = 0; i < subBillNoList.size(); ++i) {
                JSONObject jsonObject = subBillNoList.getJSONObject(i);
                String subBillNo = jsonObject.getString("subBillNo");
                builder.append(subBillNo).append(",");
            }
        }
        return builder.toString();
    }

    private void dealBillDataCommonLogic(String systemCode, String billNoParam, String paramContent, String result, List<BillVo> applyBillList) {
        this.dealSaveInterfaceLogDataByType(systemCode, BillCenterLogEnum.GET_ORDER_OP_TYPE.getBillStatus(), billNoParam, paramContent, result);
        HashMap<String, List<CenterElectronicsDetailVO>> billDetailMap = new HashMap<String, List<CenterElectronicsDetailVO>>(8);
        this.dealFormatCenterElectronicsMethod(result, billDetailMap);
        logger.info("\u8f6c\u6362\u4e4b\u540e\uff0c\u76f4\u9500\u4e2d\u53f0\u7684\u6570\u636e\u7ed3\u6784\u5927\u5c0f\u662f:{}", (Object)billDetailMap.size());
        HashMap<String, List<CenterElectronicsDetailVO>> centerElectronicsBillDetailMap = new HashMap(billDetailMap.size());
        String opKey = this.getOpKeyMethod(paramContent);
        if (StringUtils.isNotEmpty((CharSequence)opKey) && "PC".equals(opKey)) {
            JSONObject paramObject = JSONObject.parseObject((String)paramContent);
            JSONArray billNoList = paramObject.getJSONArray("billNoList");
            JSONArray subBillNoList = paramObject.getJSONArray("subBillNoList");
            if (ObjectUtils.isNotEmpty((Object)billNoList) && (subBillNoList == null || subBillNoList.isEmpty())) {
                centerElectronicsBillDetailMap = billDetailMap;
            } else {
                if (subBillNoList != null) {
                    for (int i = 0; i < subBillNoList.size(); ++i) {
                        JSONObject jsonObject = subBillNoList.getJSONObject(i);
                        String subBillNo = jsonObject.getString("subBillNo");
                        if (!billDetailMap.containsKey(subBillNo)) continue;
                        centerElectronicsBillDetailMap.put(subBillNo, (List<CenterElectronicsDetailVO>)billDetailMap.get(subBillNo));
                    }
                }
                if (centerElectronicsBillDetailMap.isEmpty()) {
                    BillErrorVo billErrorVo = new BillErrorVo();
                    String errorMsg = ResManager.loadKDString((String)"\u672a\u67e5\u5230\u76f8\u5173\u7684\u8d26\u5355\u6570\u636e\u5217\u8868\uff01", (String)"CenterElectronicsDataImpl_15", (String)"imc-sim-service", (Object[])new Object[0]);
                    billErrorVo.setErrorMsg(errorMsg);
                    billErrorVo.setFailNum(1);
                    applyBillList.add((BillVo)billErrorVo);
                    return;
                }
            }
        } else {
            centerElectronicsBillDetailMap = billDetailMap;
        }
        this.dealCreateBillCenterDataMethod(centerElectronicsBillDetailMap, systemCode, applyBillList);
    }

    private String getOpKeyMethod(String paramContent) {
        JSONObject jsonObject = JSONObject.parseObject((String)paramContent);
        return jsonObject.getString("opKey");
    }

    private void dealFormatCenterElectronicsMethod(String result, Map<String, List<CenterElectronicsDetailVO>> billDetailMap) {
        List<CenterElectronicsDataVO> einvoiceDataList = this.getCenterElectronicsDataMethod(result);
        for (CenterElectronicsDataVO centerElectronicsDataVO : einvoiceDataList) {
            List<CenterElectronicsDetailVO> einvoiceDetailDataList = centerElectronicsDataVO.getEinvoiceDetailDataList();
            String sellerTaxId = centerElectronicsDataVO.getSellerTaxId();
            if (einvoiceDetailDataList == null || einvoiceDetailDataList.isEmpty()) {
                String errorMsg = ResManager.loadKDString((String)"\u76f4\u9500\u4e2d\u53f0\u8fd4\u56de\u7684\u8ba2\u5355\u660e\u7ec6\u6570\u636e\u4e3a\u7a7a\uff01", (String)"CenterElectronicsDataImpl_4", (String)"imc-sim-service", (Object[])new Object[0]);
                throw new KDBizException(errorMsg);
            }
            for (CenterElectronicsDetailVO centerElectronicsDetailVO : einvoiceDetailDataList) {
                List<Object> subList;
                centerElectronicsDetailVO.setSellerTaxId(sellerTaxId);
                String subOrderId = centerElectronicsDetailVO.getSubOrderId();
                if (billDetailMap.containsKey(subOrderId)) {
                    subList = billDetailMap.get(subOrderId);
                    subList.add(centerElectronicsDetailVO);
                    continue;
                }
                subList = new ArrayList();
                subList.add(centerElectronicsDetailVO);
                billDetailMap.put(subOrderId, subList);
            }
        }
    }

    private void dealCreateBillCenterDataMethod(Map<String, List<CenterElectronicsDetailVO>> billDetailMap, String systemCode, List<BillVo> applyBillList) {
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        for (Map.Entry<String, List<CenterElectronicsDetailVO>> entryObject : billDetailMap.entrySet()) {
            List<CenterElectronicsDetailVO> centerElectronicsDetailVOList = entryObject.getValue();
            CenterElectronicsDetailVO centerElectronicsDetail = centerElectronicsDetailVOList.get(0);
            String orderId = centerElectronicsDetail.getOrderId();
            String subOrderId = centerElectronicsDetail.getSubOrderId();
            String taxNo = centerElectronicsDetail.getSellerTaxId();
            logger.info("dealCreateBillCenterDataMethod, orderId:{}, subOrderId:{}, systemSource:{}, taxNo:{}", new Object[]{orderId, subOrderId, systemCode, taxNo});
            boolean flag = false;
            QFilter qFilter = new QFilter("billno", "=", (Object)subOrderId).and("system_code", "=", (Object)systemCode);
            DynamicObject dynamicObject = billCenterInvoiceCommonService.dealLoadIsomerismBillDataMethod(qFilter);
            if (dynamicObject == null) {
                dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"sim_isomerism_bill_data");
            } else {
                flag = true;
            }
            logger.info("dealCreateBillCenterDataMethod, CenterElectronicsDataImpl, flag:{}", (Object)flag);
            String billNo = subOrderId;
            String extendField = orderId;
            BigDecimal totalAmount = this.dealCountCenterBillAmountMethod(centerElectronicsDetailVOList);
            this.dealCreateBillHeaderDataMethod(dynamicObject, billNo, extendField, systemCode, taxNo, totalAmount);
            this.dealCreateBillItemDataMethod(dynamicObject, centerElectronicsDetailVOList);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            billCenterInvoiceCommonService.dealFormatBillDataMethod(dynamicObject, applyBillList);
        }
    }

    private BigDecimal dealCountCenterBillAmountMethod(List<CenterElectronicsDetailVO> centerElectronicsDetailVOList) {
        BigDecimal totalAmount = new BigDecimal("0.00");
        for (CenterElectronicsDetailVO centerElectronicsDetailVO : centerElectronicsDetailVOList) {
            BigDecimal detailAmount = centerElectronicsDetailVO.getAmount().getValue();
            totalAmount = totalAmount.add(detailAmount);
        }
        return totalAmount;
    }

    private void dealCreateBillHeaderDataMethod(DynamicObject dynamicObject, String billNo, String extendField, String systemCode, String taxNo, BigDecimal totalAmount) {
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        dynamicObject.set("billno", (Object)billNo);
        dynamicObject.set("bill_json_data", (Object)extendField);
        dynamicObject.set("billstatus", (Object)"C");
        dynamicObject.set("pushstatus", (Object)"-1");
        dynamicObject.set("system_code", (Object)systemCode);
        String systemName = billCenterInvoiceCommonService.getSystemNameMethod(systemCode);
        dynamicObject.set("system_name", (Object)systemName);
        BillCenterOrgMappingService billCenterOrgMappingService = new BillCenterOrgMappingService();
        DynamicObject frontSystemObject = billCenterOrgMappingService.loadSingleBySystemCode(systemCode);
        dynamicObject.set("system", (Object)frontSystemObject);
        dynamicObject.set("org_code", null);
        dynamicObject.set("org_name", null);
        DynamicObject orgObject = TaxUtils.getOrgDynamicObjectByTaxNo((String)taxNo);
        dynamicObject.set("org", (Object)orgObject);
        dynamicObject.set("custom_name", null);
        dynamicObject.set("bill_create_time", (Object)new Date());
        dynamicObject.set("createtime", (Object)new Date());
        dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        Date billDate = new Date();
        dynamicObject.set("bill_date", (Object)billDate);
        dynamicObject.set("user_phone", null);
        dynamicObject.set("remark", null);
        dynamicObject.set("total_amount", (Object)totalAmount);
        dynamicObject.set("invoicable_amount", (Object)totalAmount);
        dynamicObject.set("invoice_amount", (Object)BigDecimal.ZERO);
        dynamicObject.set("remain_amount", (Object)totalAmount);
        dynamicObject.set("invoice_status", (Object)"0");
        dynamicObject.set("hsbz", (Object)"1");
    }

    private void dealCreateBillItemDataMethod(DynamicObject dynamicObject, List<CenterElectronicsDetailVO> centerElectronicsDetailVOList) {
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("sim_isomerism_item_data");
        if (dynamicObjectCollection == null) {
            String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u5355\u4e2d\u5fc3\u5546\u54c1\u660e\u7ec6\u533a\u5143\u6570\u636e\u4e0d\u5b58\u5728\uff01", (String)"CenterElectronicsDataImpl_5", (String)"imc-sim-service", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        if (dynamicObjectCollection.size() > 0) {
            dynamicObjectCollection.clear();
        }
        String systemCode = dynamicObject.getString("system_code");
        for (CenterElectronicsDetailVO centerElectronicsDetailVO : centerElectronicsDetailVOList) {
            DynamicObject itemObject = dynamicObjectCollection.addNew();
            itemObject.set("product_id", (Object)centerElectronicsDetailVO.getSubOrderId());
            itemObject.set("product_name", (Object)centerElectronicsDetailVO.getProductName());
            itemObject.set("product_code", null);
            itemObject.set("product_type", (Object)centerElectronicsDetailVO.getUnit());
            int quantity = centerElectronicsDetailVO.getQuantity();
            if (quantity == 0) {
                quantity = 1;
            }
            itemObject.set("product_quantity", (Object)new BigDecimal(quantity));
            CenterElectronicsAmountVO amountObject = centerElectronicsDetailVO.getAmount();
            if (amountObject == null) {
                String errorMsg = ResManager.loadKDString((String)"\u4ea7\u54c1\u91d1\u989d\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01", (String)"CenterElectronicsDataImpl_6", (String)"imc-sim-service", (Object[])new Object[0]);
                throw new KDBizException(errorMsg);
            }
            BigDecimal productAmount = amountObject.getValue();
            itemObject.set("product_amount", (Object)productAmount);
            CenterElectronicsPriceVO priceObject = centerElectronicsDetailVO.getPrice();
            if (priceObject == null) {
                String errorMsg = ResManager.loadKDString((String)"\u4ea7\u54c1\u4ef7\u683c\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01", (String)"CenterElectronicsDataImpl_7", (String)"imc-sim-service", (Object[])new Object[0]);
                throw new KDBizException(errorMsg);
            }
            BigDecimal price = priceObject.getValue();
            if (price == null) {
                price = new BigDecimal(productAmount.toString()).divide(new BigDecimal(quantity)).setScale(2, 4);
            }
            itemObject.set("product_price", (Object)price);
            itemObject.set("avg_amount", (Object)productAmount);
            String taxCode = centerElectronicsDetailVO.getTaxNo();
            itemObject.set("tax_code", (Object)taxCode);
            BigDecimal taxRate = centerElectronicsDetailVO.getTaxRate();
            if (taxRate == null) {
                taxRate = BigDecimal.ZERO;
            }
            itemObject.set("tax_rate", (Object)taxRate);
            boolean hasTaxFlag = centerElectronicsDetailVO.getWithTax() == 1;
            BigDecimal taxAmount = TaxCalcUtil.calTax((BigDecimal)new BigDecimal(productAmount.toString()), (BigDecimal)BigDecimal.ZERO, (String)((Object)taxRate).toString(), (boolean)hasTaxFlag);
            itemObject.set("tax_amount", (Object)taxAmount);
            itemObject.set("invoicable_switch", (Object)"1");
            Date billDate = new Date();
            itemObject.set("consume_time", (Object)billDate);
            itemObject.set("folio_no", null);
            itemObject.set("tc_group", null);
            String taxNo = centerElectronicsDetailVO.getSellerTaxId();
            itemObject.set("tax_no", (Object)taxNo);
            itemObject.set("splitkey", (Object)taxNo);
            DynamicObject orgObject = TaxUtils.getOrgDynamicObjectByTaxNo((String)taxNo);
            itemObject.set("orgid", (Object)orgObject);
            BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
            DynamicObject itemTypeObject = billCenterInvoiceCommonService.getBillCenterItemType(taxCode);
            itemObject.set("itemtype", (Object)itemTypeObject);
            itemObject.set("unpushamount", (Object)productAmount);
            itemObject.set("unpushtax", (Object)taxAmount);
            itemObject.set("unpushnum", (Object)quantity);
            itemObject.set("rowpushstatus", (Object)"-1");
            this.dealSetItemOpenInvoiceTypeMethod(itemObject, taxCode);
            itemObject.set("apply_no", (Object)systemCode);
        }
    }

    private void dealSetItemOpenInvoiceTypeMethod(DynamicObject itemObject, String taxCode) {
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        DynamicObject specialInvoiceObject = billCenterInvoiceCommonService.dealGetSpecialInvoiceMethod(null, null, null, taxCode);
        if (specialInvoiceObject == null) {
            itemObject.set("openinvoicetype", (Object)"02");
        } else {
            String is_special_invoice = specialInvoiceObject.getString("is_special_invoice");
            if (StringUtils.isBlank((CharSequence)is_special_invoice) || "0".equals(is_special_invoice)) {
                itemObject.set("openinvoicetype", (Object)"02");
            } else {
                itemObject.set("openinvoicetype", (Object)"01");
            }
        }
    }

    private String getTestDemo() {
        String result = "";
        return result;
    }

    private void dealSaveInterfaceLogDataByType(String systemCode, String opType, String billNoParam, String paramContent, String result) {
        try {
            BillCenterInvoiceLogService billCenterInvoiceLogService = new BillCenterInvoiceLogService();
            billCenterInvoiceLogService.dealSaveInterfaceLogDataByType(systemCode, opType, billNoParam, paramContent, result);
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u63a5\u53e3\u4ea4\u4e92\u65e5\u5fd7\u51fa\u73b0\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
        }
    }

    private List<CenterElectronicsDataVO> getCenterElectronicsDataMethod(String result) {
        if (StringUtils.isNotEmpty((CharSequence)result)) {
            CenterElectronicsOrderVO centerElectronicsOrderVO = (CenterElectronicsOrderVO)JSONObject.parseObject((String)result, CenterElectronicsOrderVO.class);
            if (centerElectronicsOrderVO == null) {
                String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u4e2d\u53f0\u7535\u5b50\u8fd4\u56de\u7684\u5f00\u7968\u6570\u636e\u5bf9\u8c61\u4e3a\u7a7a\uff01", (String)"CenterElectronicsDataImpl_8", (String)"imc-sim-service", (Object[])new Object[0]);
                throw new KDBizException(errorMsg);
            }
            CenterElectronicsStatusVO centerElectronicsStatusVO = centerElectronicsOrderVO.getStatusInfo();
            if (centerElectronicsStatusVO == null) {
                String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u4e2d\u53f0\u7535\u5b50\u8fd4\u56de\u7684\u72b6\u6001\u4fe1\u606f\u4e3a\u7a7a\uff01", (String)"CenterElectronicsDataImpl_9", (String)"imc-sim-service", (Object[])new Object[0]);
                throw new KDBizException(errorMsg);
            }
            String status = centerElectronicsStatusVO.getStatus();
            if ("success".equals(status)) {
                List<CenterElectronicsDataVO> einvoiceDataList = centerElectronicsOrderVO.getEinvoiceDataList();
                if (einvoiceDataList == null || einvoiceDataList.isEmpty()) {
                    String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u4e2d\u53f0\u7535\u5b50\u8fd4\u56de\u7684\u53d1\u7968\u6570\u636e\u96c6\u5408\u4e3a\u7a7a\uff01", (String)"CenterElectronicsDataImpl_10", (String)"imc-sim-service", (Object[])new Object[0]);
                    throw new KDBizException(errorMsg);
                }
                return einvoiceDataList;
            }
            CenterElectronicsErrorVO error = centerElectronicsStatusVO.getError();
            String errorMsg = error == null ? ResManager.loadKDString((String)"\u76f4\u9500\u4e2d\u53f0\u7cfb\u7edf\uff0c\u5f53\u524d\u8fd4\u56de\u7684\u72b6\u6001\u4e0d\u6210\u529f\uff01", (String)"CenterElectronicsDataImpl_11", (String)"imc-sim-service", (Object[])new Object[0]) : error.getErrorMsg();
            throw new KDBizException(errorMsg);
        }
        String errorMsg = ResManager.loadKDString((String)"\u76f4\u9500\u4e2d\u53f0\u7cfb\u7edf\uff0c\u83b7\u53d6\u4e0d\u5230\u76f8\u5173\u7684\u8d26\u5355\u6570\u636e\uff01", (String)"CenterElectronicsDataImpl_12", (String)"imc-sim-service", (Object[])new Object[0]);
        throw new KDBizException(errorMsg);
    }

    private String doGetDataService(DynamicObject frontSystemObject, String paramContent) throws Exception {
        JSONObject paramObject = JSONObject.parseObject((String)paramContent);
        JSONArray billNoList = paramObject.getJSONArray("billNoList");
        JSONArray subBillNoList = paramObject.getJSONArray("subBillNoList");
        String accessToken = this.getAccessTokenMethod(frontSystemObject);
        logger.info("CenterElectronicsDataImpl, doGetDataService, accessToken\u5185\u5bb9\u662f:{}", (Object)accessToken);
        if (StringUtils.isNotEmpty((CharSequence)accessToken)) {
            String systemUrl = frontSystemObject.getString("system_url");
            String requestUrl = systemUrl + "/clinboundwebservice/v2/clb2c/eInvoice/eInvoiceDataList";
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("Authorization", "bearer " + accessToken);
            HashMap<String, List<Map<String, String>>> body = new HashMap<String, List<Map<String, String>>>();
            String opKey = this.getOpKeyMethod(paramContent);
            logger.info("CenterElectronicsDataImpl, doGetDataService, opKey:{}", (Object)opKey);
            if ("PC".equals(opKey)) {
                body.put("orderList", this.getOrderListMethod(billNoList, subBillNoList));
            } else {
                body.put("orderList", this.getOrderListMethod(billNoList));
            }
            logger.info("CenterElectronicsDataImpl, doGetDataService, \u53d1\u8d77\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", body);
            String result = HttpClientUtils.postAppJson((String)requestUrl, header, body);
            logger.info("CenterElectronicsDataImpl, doGetDataService, \u83b7\u53d6\u5f00\u7968\u6570\u636e\uff0cresult\u8fd4\u56de\u5185\u5bb9\u662f\uff1a{}", (Object)result);
            return result;
        }
        return null;
    }

    private List<Map<String, String>> getOrderListMethod(JSONArray billNoList) {
        if (ObjectUtils.isEmpty((Object)billNoList)) {
            return null;
        }
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        for (Object obj : billNoList) {
            JSONObject jsonObject = (JSONObject)obj;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("subOrderId", jsonObject.getString("billNo"));
            list.add(map);
        }
        return list;
    }

    private List<Map<String, String>> getOrderListMethod(JSONArray billNoList, JSONArray subBillNoList) {
        HashMap<String, String> map;
        JSONObject jsonObject;
        if (ObjectUtils.isEmpty((Object)billNoList) && ObjectUtils.isEmpty((Object)subBillNoList)) {
            return null;
        }
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        if (ObjectUtils.isNotEmpty((Object)billNoList)) {
            for (Object object : billNoList) {
                jsonObject = (JSONObject)object;
                map = new HashMap<String, String>();
                map.put("orderId", jsonObject.getString("billNo"));
                list.add(map);
            }
        }
        if (ObjectUtils.isNotEmpty((Object)subBillNoList)) {
            for (Object object : subBillNoList) {
                jsonObject = (JSONObject)object;
                map = new HashMap();
                map.put("subOrderId", jsonObject.getString("subBillNo"));
                list.add(map);
            }
        }
        return list;
    }

    private String getAccessTokenMethod(DynamicObject frontSystemObject) throws Exception {
        String systemUrl = frontSystemObject.getString("system_url");
        String clientId = frontSystemObject.getString("client_id");
        String clientSecret = frontSystemObject.getString("client_secret");
        String grantType = "password";
        String username = frontSystemObject.getString("db_username");
        String password = frontSystemObject.getString("db_password");
        logger.info("CenterElectronicsDataImpl, doGetDataService, systemUrl:{}, clientId:{}, clientSecret:{}, username:{}, password:{}", new Object[]{systemUrl, clientId, clientSecret, username, password});
        String access_token_url = systemUrl + "/authorizationserver/oauth/token";
        access_token_url = access_token_url + "?client_id=" + clientId + "&client_secret=" + clientSecret + "&grant_type=" + grantType + "&username=" + username + "&password=" + password;
        logger.info("CenterElectronicsDataImpl, getAccessTokenMethod, access_token_url\u662f:{}", (Object)access_token_url);
        String result = HttpClientUtils.postAppJson((String)access_token_url, null, null);
        logger.info("CenterElectronicsDataImpl, getAccessTokenMethod, \u83b7\u53d6AccessToken\uff0c\u7ed3\u679c\u8fd4\u56de\u5185\u5bb9\u662f:{}", (Object)result);
        if (StringUtils.isNotEmpty((CharSequence)result)) {
            JSONObject jsonObject = JSONObject.parseObject((String)result);
            return jsonObject.getString("access_token");
        }
        return null;
    }

    private Map<String, Object> createUpdateResultStatusMethod(InvoiceVo invoiceVo) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        ArrayList orderList = new ArrayList();
        HashMap<String, Object> orderMap = new HashMap<String, Object>();
        String billNo = invoiceVo.getBillNo();
        String systemCode = invoiceVo.getSystemSource();
        logger.info("CenterElectronicsDataImpl, createUpdateResultStatusMethod, batch:{}, billNo:{}, systemCode:{}", new Object[]{invoiceVo.getBatch(), billNo, systemCode});
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        DynamicObject billCenterObject = billCenterInvoiceCommonService.dealCheckBillCenterDataMethod("billno", billNo, systemCode);
        if (billCenterObject == null) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8ba2\u5355\u7f16\u53f7:%1$s\uff0c\u65e0\u6cd5\u5339\u914d\u5230\u8d26\u5355\u4e2d\u5fc3\u7684\u8ba2\u5355\u6570\u636e\uff01", (String)"CenterElectronicsDataImpl_13", (String)"imc-sim-service", (Object[])new Object[0]), billNo);
            throw new KDBizException(errorMsg);
        }
        String orderId = billCenterObject.getString("bill_json_data");
        if (StringUtils.isBlank((CharSequence)billNo)) {
            billNo = invoiceVo.getBatch();
        }
        if (StringUtils.isNotEmpty((CharSequence)billNo) && billNo.contains("_")) {
            int idx = billNo.indexOf("_");
            billNo = billNo.substring(0, idx);
        }
        orderMap.put("orderId", orderId);
        String invoiceStatus = invoiceVo.getInvoiceStatus();
        if (StringUtils.equals((CharSequence)invoiceStatus, (CharSequence)"0")) {
            invoiceStatus = "INVOICED";
        }
        orderMap.put("invoiceStatus", invoiceStatus);
        Date invoiceDate = invoiceVo.getInvoiceDate();
        if (invoiceDate == null) {
            invoiceDate = new Date();
        }
        orderMap.put("invoiceDate", DateUtils.format((Date)invoiceDate, (String)"yyyy-MM-dd HH:mm:ss"));
        orderMap.put("updateDate", DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        HashMap<String, CenterElectronicsInvoiceDetailVO> invoiceDetailMap = new HashMap<String, CenterElectronicsInvoiceDetailVO>(8);
        ArrayList<InvoiceDetailVo> invoiceDetailVoList = invoiceVo.getInvoiceDetail();
        if (invoiceDetailVoList == null) {
            invoiceDetailVoList = new ArrayList<InvoiceDetailVo>();
        } else {
            this.dealGroupInvoiceDetailMethod(invoiceDetailMap, invoiceDetailVoList, invoiceVo.getInvoiceNum(), invoiceVo.getInvoiceCode());
        }
        ArrayList detailList = new ArrayList(invoiceDetailVoList.size());
        for (Map.Entry entryObject : invoiceDetailMap.entrySet()) {
            CenterElectronicsInvoiceDetailVO invoiceDetailVo = (CenterElectronicsInvoiceDetailVO)((Object)entryObject.getValue());
            HashMap<String, Object> detailMap = new HashMap<String, Object>();
            String subOrderId = billNo;
            logger.info("createUpdateResultStatusMethod, subOrderId:{}", (Object)subOrderId);
            detailMap.put("subOrderId", subOrderId);
            detailMap.put("subOrderEntryNumber", 1);
            BigDecimal taxAmount = invoiceDetailVo.getTaxAmount();
            if (taxAmount != null) {
                taxAmount = taxAmount.setScale(2, 4);
            }
            detailMap.put("tax", taxAmount);
            detailMap.put("noTaxAmount", invoiceDetailVo.getAmount());
            String invoiceCode = invoiceVo.getInvoiceCode();
            if (StringUtils.isBlank((CharSequence)invoiceCode)) {
                invoiceCode = "";
            }
            detailMap.put("invoiceCode", invoiceCode);
            detailMap.put("invoiceNumber", invoiceVo.getInvoiceNum());
            detailMap.put("sellerTaxId", invoiceVo.getSellerTaxpayerId());
            detailMap.put("xmlFileUrl", invoiceVo.getInvoiceXmlFileUrl());
            detailMap.put("ofdFileUrl", invoiceVo.getInvoiceFileUrl());
            detailMap.put("pdfFileUrl", invoiceVo.getInvoicePdfFileUrl());
            detailMap.put("imageFileUrl", invoiceVo.getInvoiceImageUrl());
            detailList.add(detailMap);
        }
        orderMap.put("einvoiceDetailDatas", detailList);
        orderList.add(orderMap);
        body.put("orderList", orderList);
        return body;
    }

    private void dealGroupInvoiceDetailMethod(Map<String, CenterElectronicsInvoiceDetailVO> invoiceDetailMap, List<InvoiceDetailVo> invoiceDetailVoList, String invoiceNum, String invoiceCode) {
        String key = invoiceNum + "-" + invoiceCode;
        for (InvoiceDetailVo invoiceDetailVo : invoiceDetailVoList) {
            CenterElectronicsInvoiceDetailVO subInvoiceDetailVo;
            if (invoiceDetailMap.containsKey(key)) {
                subInvoiceDetailVo = invoiceDetailMap.get(key);
                subInvoiceDetailVo.setTaxAmount(subInvoiceDetailVo.getTaxAmount().add(invoiceDetailVo.getTaxAmount()));
                subInvoiceDetailVo.setAmount(subInvoiceDetailVo.getAmount().add(invoiceDetailVo.getAmount()));
                continue;
            }
            subInvoiceDetailVo = new CenterElectronicsInvoiceDetailVO();
            subInvoiceDetailVo.setTaxAmount(invoiceDetailVo.getTaxAmount());
            subInvoiceDetailVo.setAmount(invoiceDetailVo.getAmount());
            invoiceDetailMap.put(key, subInvoiceDetailVo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dealNoticeApprovalStatusMethod(ApprovalProcessFlowVO approvalProcessFlowVO, String auditStatus) {
        String[] array;
        String systemCode = approvalProcessFlowVO.getSystemCode();
        String billCenterNo = approvalProcessFlowVO.getBillCenterNo();
        if (StringUtils.isEmpty((CharSequence)billCenterNo)) {
            logger.error("dealNoticeApprovalStatusMethod, \u539f\u59cb\u8d26\u5355\u7f16\u53f7\u4e3a\u7a7a\uff01");
            return;
        }
        for (String subOrderId : array = billCenterNo.split(",")) {
            logger.info("CenterElectronicsSysDataImpl, dealNoticeApprovalStatusMethod, systemCode:{}, subOrderId:{}", (Object)systemCode, (Object)subOrderId);
            BillCenterOrgMappingService orgMappingService = new BillCenterOrgMappingService();
            DynamicObject frontSystemObject = orgMappingService.loadSingleBySystemCode(systemCode);
            Map<Object, Object> body = new HashMap();
            String result = "";
            try {
                if (frontSystemObject == null) continue;
                approvalProcessFlowVO.setSubOrderId(subOrderId);
                body = this.createApprovalResultMethod(approvalProcessFlowVO, auditStatus);
                String accessToken = this.getAccessTokenMethod(frontSystemObject);
                logger.info("CenterElectronicsDataImpl, dealNoticeApprovalStatusMethod, accessToken\u5185\u5bb9\u662f:{}", (Object)accessToken);
                if (!StringUtils.isNotEmpty((CharSequence)accessToken)) continue;
                String systemUrl = frontSystemObject.getString("system_url");
                String requestUrl = systemUrl + "/clinboundwebservice/v2/clb2c/eInvoice/updateAuditStatus";
                HashMap<String, String> header = new HashMap<String, String>();
                header.put("Authorization", "bearer " + accessToken);
                logger.info("CenterElectronicsDataImpl, dealNoticeApprovalStatusMethod, \u8bf7\u6c42\u53c2\u6570\u5185\u5bb9\u662f:{}", body);
                result = HttpClientUtils.postAppJson((String)requestUrl, header, body);
                logger.info("CenterElectronicsDataImpl, dealNoticeApprovalStatusMethod, \u54cd\u5e94\u7ed3\u679c\u5185\u5bb9\u662f\uff1a{}", (Object)result);
            }
            catch (Exception e) {
                logger.error("\u63a8\u9001\u76f4\u9500\u4e2d\u53f0\uff0c\u5ba1\u6838\u7ed3\u679c-\u901a\u77e5\u5904\u7406\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u662f\uff1a{}", (Object)e.getMessage());
            }
            finally {
                JSONObject innerParamObject = new JSONObject(body);
                String opType = "REJECTED".equals(auditStatus) ? BillCenterLogEnum.APPROVAL_RESULT_OP_TYPE.getBillStatus() : BillCenterLogEnum.SUCCESS_RESULT_OP_TYPE.getBillStatus();
                this.dealSaveInterfaceLogDataByType(systemCode, opType, subOrderId, innerParamObject.toJSONString(), result);
            }
        }
    }

    private Map<String, Object> createApprovalResultMethod(ApprovalProcessFlowVO approvalProcessFlowVO, String auditStatus) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        String orderId = approvalProcessFlowVO.getOrderId();
        if (StringUtils.isEmpty((CharSequence)orderId)) {
            BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
            DynamicObject billCenterObject = billCenterInvoiceCommonService.dealCheckBillCenterDataMethod("billno", approvalProcessFlowVO.getSubOrderId(), approvalProcessFlowVO.getSystemCode());
            orderId = billCenterObject.getString("bill_json_data");
        }
        body.put("orderId", orderId);
        body.put("subOrderid", approvalProcessFlowVO.getSubOrderId());
        body.put("auditStatus", auditStatus);
        body.put("rejectedReason", approvalProcessFlowVO.getRejectReason());
        return body;
    }

    @Override
    public void dealUpdateOpenInvoiceStatus(DynamicObject dynamicObject, InvoiceVo invoiceVo) {
        logger.info("CenterElectronicsSysDataImpl, dealUpdateOpenInvoiceStatus, \u56de\u4f20\u5f00\u7968\u7684\u72b6\u6001\u7ed9\u5230\u76f4\u9500\u4e2d\u53f0\u7cfb\u7edf\uff01");
        if (this.invociceFailCallBack(dynamicObject)) {
            return;
        }
        if (dynamicObject != null && invoiceVo == null) {
            this.dealNoticeProcessInvoiceMethod(dynamicObject);
            return;
        }
        int invoiceProperty = invoiceVo.getInvoiceProperty();
        logger.info("CenterElectronicsSysDataImpl, dealUpdateOpenInvoiceStatus, invoiceProperty:{}", (Object)invoiceProperty);
        if (0 == invoiceProperty) {
            this.dealNoticeBlueInvoiceMethod(invoiceVo);
        } else if (1 == invoiceProperty) {
            this.dealNoticeRedInvoiceMethod(invoiceVo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dealNoticeProcessInvoiceMethod(DynamicObject dynamicObject) {
        BillCenterOrgMappingService orgMappingService = new BillCenterOrgMappingService();
        String systemCode = dynamicObject.getString("systemsource");
        String billNo = dynamicObject.getString("lbsv_oribillno");
        logger.info("CenterElectronicsDataImpl, dealNoticeProcessInvoiceMethod, systemCode:{}, billNo:{}", (Object)systemCode, (Object)billNo);
        DynamicObject frontSystemObject = orgMappingService.loadSingleBySystemCode(systemCode);
        Map<Object, Object> body = new HashMap();
        String result = "";
        try {
            if (frontSystemObject != null) {
                body = this.createProcessInvoiceMethod(dynamicObject);
                String accessToken = this.getAccessTokenMethod(frontSystemObject);
                logger.info("CenterElectronicsDataImpl, dealNoticeProcessInvoiceMethod, accessToken\u5185\u5bb9\u662f:{}", (Object)accessToken);
                if (StringUtils.isNotEmpty((CharSequence)accessToken)) {
                    String systemUrl = frontSystemObject.getString("system_url");
                    String requestUrl = systemUrl + "/clinboundwebservice/v2/clb2c/eInvoice/updateInvoiceStatusList";
                    HashMap<String, String> header = new HashMap<String, String>();
                    header.put("Authorization", "bearer " + accessToken);
                    logger.info("CenterElectronicsDataImpl, dealNoticeProcessInvoiceMethod, \u8bf7\u6c42\u53c2\u6570\u5185\u5bb9\u662f:{}", body);
                    result = HttpClientUtils.postAppJson((String)requestUrl, header, body);
                    logger.info("CenterElectronicsDataImpl, dealNoticeProcessInvoiceMethod, \u54cd\u5e94\u7ed3\u679c\u5185\u5bb9\u662f\uff1a{}", (Object)result);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u63a8\u9001\u76f4\u9500\u4e2d\u53f0\u5f00\u7968\u4e2d\u7684\u72b6\u6001\uff0c\u5904\u7406\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u662f\uff1a{}", (Object)e.getMessage());
        }
        finally {
            JSONObject innerParamObject = new JSONObject(body);
            this.dealSaveInterfaceLogDataByType(systemCode, BillCenterLogEnum.BLUE_INV_RESULT_OP_TYPE.getBillStatus(), billNo, innerParamObject.toJSONString(), result);
        }
    }

    private Map<String, Object> createProcessInvoiceMethod(DynamicObject dynamicObject) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        ArrayList orderList = new ArrayList();
        HashMap<String, Object> orderMap = new HashMap<String, Object>();
        String billNo = dynamicObject.getString("lbsv_oribillno");
        String systemCode = dynamicObject.getString("systemsource");
        logger.info("CenterElectronicsDataImpl, createProcessInvoiceMethod, billNo:{}, systemCode:{}", (Object)billNo, (Object)systemCode);
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        DynamicObject billCenterObject = billCenterInvoiceCommonService.dealCheckBillCenterDataMethod("billno", billNo, systemCode);
        if (billCenterObject == null) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8ba2\u5355\u7f16\u53f7:%1$s\uff0c\u65e0\u6cd5\u5339\u914d\u5230\u8d26\u5355\u4e2d\u5fc3\u7684\u8ba2\u5355\u6570\u636e\uff01", (String)"CenterElectronicsDataImpl_13", (String)"imc-sim-service", (Object[])new Object[0]), billNo);
            throw new KDBizException(errorMsg);
        }
        String orderId = billCenterObject.getString("bill_json_data");
        orderMap.put("orderId", orderId);
        String invoiceStatus = "IN_INVOICED";
        orderMap.put("invoiceStatus", invoiceStatus);
        Date invoiceDate = new Date();
        orderMap.put("invoiceDate", DateUtils.format((Date)invoiceDate, (String)"yyyy-MM-dd HH:mm:ss"));
        orderMap.put("updateDate", DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        DynamicObjectCollection invoiceDetailCollection = billCenterObject.getDynamicObjectCollection("invoice");
        int size = invoiceDetailCollection != null && invoiceDetailCollection.size() > 0 ? invoiceDetailCollection.size() : 8;
        ArrayList detailList = new ArrayList(size);
        HashMap<String, Object> detailMap = new HashMap<String, Object>();
        String subOrderId = billNo;
        logger.info("CenterElectronicsDataImpl, createProcessInvoiceMethod, subOrderId:{}", (Object)subOrderId);
        detailMap.put("subOrderId", subOrderId);
        int index = 1;
        detailMap.put("subOrderEntryNumber", index);
        detailList.add(detailMap);
        orderMap.put("einvoiceDetailDatas", detailList);
        orderList.add(orderMap);
        body.put("orderList", orderList);
        return body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dealNoticeRedInvoiceMethod(InvoiceVo invoiceVo) {
        BillCenterOrgMappingService orgMappingService = new BillCenterOrgMappingService();
        String systemCode = invoiceVo.getSystemSource();
        String billNo = invoiceVo.getBillNo();
        logger.info("CenterElectronicsDataImpl, dealNoticeRedInvoiceMethod, systemCode:{}, billNo:{}", (Object)systemCode, (Object)billNo);
        DynamicObject frontSystemObject = orgMappingService.loadSingleBySystemCode(systemCode);
        Map<Object, Object> body = new HashMap();
        String result = "";
        try {
            if (frontSystemObject != null) {
                body = this.createRedNoticeResultMethod(invoiceVo);
                String accessToken = this.getAccessTokenMethod(frontSystemObject);
                logger.info("CenterElectronicsDataImpl, dealNoticeRedInvoiceMethod, accessToken\u5185\u5bb9\u662f:{}", (Object)accessToken);
                if (StringUtils.isNotEmpty((CharSequence)accessToken)) {
                    String systemUrl = frontSystemObject.getString("system_url");
                    String requestUrl = systemUrl + "/clinboundwebservice/v2/clb2c/eInvoice/updateRedDetail";
                    HashMap<String, String> header = new HashMap<String, String>();
                    header.put("Authorization", "bearer " + accessToken);
                    logger.info("CenterElectronicsDataImpl, dealNoticeRedInvoiceMethod, \u8bf7\u6c42\u53c2\u6570\u5185\u5bb9\u662f:{}", body);
                    result = HttpClientUtils.postAppJson((String)requestUrl, header, body);
                    logger.info("CenterElectronicsDataImpl, dealNoticeRedInvoiceMethod, \u54cd\u5e94\u7ed3\u679c\u5185\u5bb9\u662f\uff1a{}", (Object)result);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u63a8\u9001\u76f4\u9500\u4e2d\u53f0\uff0c\u7ea2\u51b2\u7ed3\u679c\u901a\u77e5\u5904\u7406\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u662f\uff1a{}", (Object)e.getMessage());
        }
        finally {
            JSONObject innerParamObject = new JSONObject(body);
            this.dealSaveInterfaceLogDataByType(systemCode, BillCenterLogEnum.RED_INV_RESULT_OP_TYPE.getBillStatus(), billNo, innerParamObject.toJSONString(), result);
        }
    }

    private void dealStaticsCallbackMethod(String billNo, String systemCode, String result) {
        CenterElectronicsStatusVO statusInfo;
        CenterElectronicsOrderVO centerElectronicsOrderVO;
        String callbackStatus = StringUtils.isNotBlank((CharSequence)result) ? ((centerElectronicsOrderVO = (CenterElectronicsOrderVO)JSONObject.parseObject((String)result, CenterElectronicsOrderVO.class)) != null ? ((statusInfo = centerElectronicsOrderVO.getStatusInfo()) != null && "success".equals(statusInfo.getStatus()) ? "1" : "2") : "2") : "2";
        logger.info("dealStaticsCallbackMethod, billNo:{}, systemCode:{}, callbackStatus:{}", new Object[]{billNo, systemCode, callbackStatus});
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        if ("2".equals(callbackStatus)) {
            billCenterInvoiceCommonService.dealStaticsCallbackMethod(billNo, systemCode, 1, callbackStatus);
        } else {
            billCenterInvoiceCommonService.dealStaticsCallbackMethod(billNo, systemCode, callbackStatus);
        }
    }

    private Map<String, Object> createRedNoticeResultMethod(InvoiceVo invoiceVo) {
        HashMap<String, Object> redInvoiceMap = new HashMap<String, Object>();
        String invoiceCode = invoiceVo.getOriginalInvoiceCode();
        redInvoiceMap.put("invoiceCode", invoiceCode);
        String invoiceNumber = invoiceVo.getOriginalInvoiceNumber();
        redInvoiceMap.put("invoiceNumber", invoiceNumber);
        String reason = invoiceVo.getRedReason();
        redInvoiceMap.put("reason", reason);
        BigDecimal totalAmount = invoiceVo.getTotalAmount();
        if (totalAmount == null) {
            totalAmount = BigDecimal.ZERO;
        }
        String amount = totalAmount.toString();
        redInvoiceMap.put("amount", amount);
        BigDecimal totalTaxAmount = invoiceVo.getTotalTaxAmount();
        if (totalTaxAmount == null) {
            totalTaxAmount = BigDecimal.ZERO;
        }
        String tax = totalTaxAmount.toString();
        redInvoiceMap.put("tax", tax);
        String redInvoiceCode = invoiceVo.getInvoiceCode();
        redInvoiceMap.put("redInvoiceCode", redInvoiceCode);
        String redInvoiceNumber = invoiceVo.getInvoiceNum();
        redInvoiceMap.put("redInvoiceNumber", redInvoiceNumber);
        return redInvoiceMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dealNoticeBlueInvoiceMethod(InvoiceVo invoiceVo) {
        BillCenterOrgMappingService orgMappingService = new BillCenterOrgMappingService();
        String systemCode = invoiceVo.getSystemSource();
        String billNo = invoiceVo.getBillNo();
        logger.info("CenterElectronicsDataImpl, dealUpdateOpenInvoiceStatus, systemCode:{}, billNo:{}", (Object)systemCode, (Object)billNo);
        DynamicObject frontSystemObject = orgMappingService.loadSingleBySystemCode(systemCode);
        Map<Object, Object> body = new HashMap();
        String result = "";
        try {
            if (frontSystemObject != null) {
                body = this.createUpdateResultStatusMethod(invoiceVo);
                String accessToken = this.getAccessTokenMethod(frontSystemObject);
                logger.info("CenterElectronicsDataImpl, dealUpdateResultStatus, accessToken\u5185\u5bb9\u662f:{}", (Object)accessToken);
                if (StringUtils.isNotEmpty((CharSequence)accessToken)) {
                    String systemUrl = frontSystemObject.getString("system_url");
                    String requestUrl = systemUrl + "/clinboundwebservice/v2/clb2c/eInvoice/updateInvoiceStatusList";
                    HashMap<String, String> header = new HashMap<String, String>();
                    header.put("Authorization", "bearer " + accessToken);
                    logger.info("CenterElectronicsDataImpl, dealUpdateResultStatus, \u8bf7\u6c42\u53c2\u6570\u5185\u5bb9\u662f:{}", body);
                    result = HttpClientUtils.postAppJson((String)requestUrl, header, body);
                    logger.info("CenterElectronicsDataImpl, dealUpdateResultStatus, \u54cd\u5e94\u7ed3\u679c\u5185\u5bb9\u662f\uff1a{}", (Object)result);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u63a8\u9001\u76f4\u9500\u4e2d\u53f0\uff0c\u66f4\u65b0\u72b6\u6001\u4e0e\u7ed3\u679c\u5904\u7406\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u662f\uff1a{}", (Object)e.getMessage());
        }
        finally {
            JSONObject innerParamObject = new JSONObject(body);
            this.dealSaveInterfaceLogDataByType(systemCode, BillCenterLogEnum.BLUE_INV_RESULT_OP_TYPE.getBillStatus(), billNo, innerParamObject.toJSONString(), result);
            this.dealStaticsCallbackMethod(billNo, systemCode, result);
        }
    }

    @Override
    public void dealPushCallBackStatusToFrontSystem(JSONObject paramObject) {
        BillCenterInvoiceLogService billCenterInvoiceLogService = new BillCenterInvoiceLogService();
        if (paramObject.containsKey((Object)"approvalResult")) {
            this.dealNoticeApprovalRejectMethod(paramObject);
        } else if (paramObject.containsKey((Object)"approvalProcess")) {
            billCenterInvoiceLogService.dealNoticeApprovalProcessMethod(paramObject);
        } else if (paramObject.containsKey((Object)"approvalSuccess")) {
            this.dealNoticeApprovalSuccessMethod(paramObject);
        } else {
            this.dealNoticeCallBackStatusToFrontSystem(paramObject);
        }
    }

    private void dealNoticeApprovalSuccessMethod(JSONObject paramObject) {
        String systemCode = paramObject.getString("systemCode");
        String paramContent = paramObject.getString("paramContent");
        if (StringUtils.isBlank((CharSequence)paramContent)) {
            String errorMsg = ResManager.loadKDString((String)"\u5ba1\u6838\u901a\u8fc7\u8fd4\u56de\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"CenterElectronicsDataImpl_19", (String)"imc-sim-service", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        logger.info("dealNoticeApprovalSuccessMethod, paramContent:{}", (Object)paramContent);
        ApprovalProcessFlowVO approvalProcessFlowVo = (ApprovalProcessFlowVO)JSONObject.parseObject((String)paramContent, ApprovalProcessFlowVO.class);
        if (approvalProcessFlowVo != null) {
            approvalProcessFlowVo.setSystemCode(systemCode);
            this.dealNoticeApprovalStatusMethod(approvalProcessFlowVo, "APPROVED");
            BillCenterInvoiceLogService billCenterInvoiceLogService = new BillCenterInvoiceLogService();
            billCenterInvoiceLogService.dealNoticeApprovalSuccessMethod(paramObject);
            logger.info("\u5ba1\u6279\u901a\u8fc7\u7684\u64cd\u4f5c\u7ed3\u679c\u5df2\u7ecf\u5b8c\u6210\uff01");
        }
    }

    private void dealNoticeApprovalRejectMethod(JSONObject paramObject) {
        String systemCode = paramObject.getString("systemCode");
        String paramContent = paramObject.getString("paramContent");
        if (StringUtils.isBlank((CharSequence)paramContent)) {
            String errorMsg = ResManager.loadKDString((String)"\u9a73\u56de\u8fd4\u56de\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"CenterElectronicsDataImpl_18", (String)"imc-sim-service", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        logger.info("dealNoticeApprovalRejectMethod, paramContent:{}", (Object)paramContent);
        ApprovalProcessFlowVO approvalProcessFlowVo = (ApprovalProcessFlowVO)JSONObject.parseObject((String)paramContent, ApprovalProcessFlowVO.class);
        if (approvalProcessFlowVo != null) {
            approvalProcessFlowVo.setSystemCode(systemCode);
            this.dealNoticeApprovalStatusMethod(approvalProcessFlowVo, "REJECTED");
            BillCenterInvoiceLogService billCenterInvoiceLogService = new BillCenterInvoiceLogService();
            billCenterInvoiceLogService.dealClearApprovalDataMethod(approvalProcessFlowVo);
            this.dealSaveApprovalRejectMethod(approvalProcessFlowVo, paramContent);
            logger.info("\u9a73\u56de\u901a\u77e5\u7684\u64cd\u4f5c\u7ed3\u679c\u5df2\u7ecf\u5b8c\u6210\uff01");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dealNoticeCallBackStatusToFrontSystem(JSONObject paramObject) {
        block8: {
            BillCenterOrgMappingService orgMappingService = new BillCenterOrgMappingService();
            String systemCode = paramObject.getString("systemCode");
            String innerParam = paramObject.getString("innerParam");
            String billNo = paramObject.getString("billNo");
            String opType = paramObject.getString("opType");
            logger.info("CenterElectronicsDataImpl, dealPushCallBackStatusToFrontSystem, systemCode:{}, billNo:{}", (Object)systemCode, (Object)billNo);
            DynamicObject frontSystemObject = orgMappingService.loadSingleBySystemCode(systemCode);
            String result = "";
            try {
                if (frontSystemObject != null) {
                    Map<String, Object> bodyContentMap = this.dealFormatBodyContentMethod(innerParam);
                    String accessToken = this.getAccessTokenMethod(frontSystemObject);
                    logger.info("CenterElectronicsDataImpl, dealPushCallBackStatusToFrontSystem, accessToken\u5185\u5bb9\u662f:{}", (Object)accessToken);
                    if (StringUtils.isNotEmpty((CharSequence)accessToken)) {
                        String systemUrl = frontSystemObject.getString("system_url");
                        String requestUrl = systemUrl + "/clinboundwebservice/v2/clb2c/eInvoice/updateInvoiceStatusList";
                        HashMap<String, String> header = new HashMap<String, String>();
                        header.put("Authorization", "bearer " + accessToken);
                        logger.info("CenterElectronicsDataImpl, dealPushCallBackStatusToFrontSystem, \u8bf7\u6c42\u53c2\u6570\u5185\u5bb9\u662f:{}", bodyContentMap);
                        result = HttpClientUtils.postAppJson((String)requestUrl, header, bodyContentMap);
                        logger.info("CenterElectronicsDataImpl, dealPushCallBackStatusToFrontSystem, \u54cd\u5e94\u7ed3\u679c\u5185\u5bb9\u662f\uff1a{}", (Object)result);
                    }
                    break block8;
                }
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u672a\u5339\u914d\u5230\u76f4\u9500\u4e2d\u53f0\u7cfb\u7edf:%1$s\uff0c\u53c2\u6570\u914d\u7f6e\uff01", (String)"CenterElectronicsDataImpl_1", (String)"imc-sim-service", (Object[])new Object[0]), systemCode));
            }
            catch (Exception e) {
                result = e.getMessage();
                logger.error("\u624b\u52a8\u63a8\u9001\u4e2d\u53f0\u56de\u8c03\u7ed3\u679c\uff0c\u5f02\u5e38\u4fe1\u606f\u662f\uff1a{}", (Object)e.getMessage());
            }
            finally {
                this.dealSaveInterfaceLogDataByType(systemCode, opType, billNo, innerParam, result);
                if (BillCenterLogEnum.BLUE_INV_RESULT_OP_TYPE.getBillStatus().equals(opType)) {
                    this.dealStaticsCallbackMethod(billNo, systemCode, result);
                }
            }
        }
    }

    private void dealSaveApprovalRejectMethod(ApprovalProcessFlowVO approvalProcessFlowVO, String paramContent) {
        String wxOpenId = approvalProcessFlowVO.getWxOpenId();
        if (StringUtils.isNotBlank((CharSequence)wxOpenId)) {
            String systemCode = approvalProcessFlowVO.getSystemCode();
            this.dealSaveInterfaceLogDataByType(systemCode, BillCenterLogEnum.APPROVAL_RESULT_OP_TYPE.getBillStatus(), wxOpenId, paramContent, null);
        }
    }

    @Override
    public String dealGetQrCodeMethod(JSONObject paramObject) {
        return null;
    }

    private Map<String, Object> dealFormatBodyContentMethod(String innerParam) {
        if (StringUtils.isNotEmpty((CharSequence)innerParam)) {
            JSONObject jsonObject;
            JSONObject bodyMap = jsonObject = JSON.parseObject((String)innerParam);
            return bodyMap;
        }
        return null;
    }
}

