/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.billcenter.sys.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.dto.BillVo;
import kd.imc.bdm.common.openapi.InvoiceVo;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.sim.billcenter.BillCenterInvoiceCommonService;
import kd.imc.sim.billcenter.BillCenterInvoiceLogService;
import kd.imc.sim.billcenter.BillCenterOrgMappingService;
import kd.imc.sim.billcenter.domain.DaoKongOrderInfo;
import kd.imc.sim.billcenter.domain.DaoKongResultVO;
import kd.imc.sim.billcenter.sys.ExternalSystemDataHandler;
import kd.imc.sim.billcenter.sys.ExternalSystemsDataService;
import kd.imc.sim.billcenter.util.HttpRequestUtil;
import kd.imc.sim.common.constant.BillCenterLogEnum;
import kd.imc.sim.common.constant.BillCenterSystemEnum;
import kd.imc.sim.common.constant.ErrorType;
import kd.imc.sim.common.model.billcenter.BillErrorVo;
import kd.imc.sim.common.service.SimGetBillDataService;
import kd.imc.sim.common.utils.MD5Util;
import org.apache.commons.lang3.StringUtils;

public class DaoKongDataImpl
implements ExternalSystemsDataService {
    private static final Log logger = LogFactory.getLog(DaoKongDataImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BillVo> getData(JSONObject paramObject) {
        List<BillVo> applyBillList = new ArrayList<BillVo>();
        String paramContent = paramObject.getString("paramContent");
        String systemCode = paramObject.getString("systemCode");
        logger.info("DaoKongDataImpl, paramContent:{}, systemCode:{}", (Object)paramContent, (Object)systemCode);
        if (StringUtils.isEmpty((CharSequence)paramContent) || StringUtils.isEmpty((CharSequence)systemCode)) {
            throw new KDBizException(new ErrorCode(ErrorType.PARAM_IS_NULL.getErrcode(), ErrorType.PARAM_IS_NULL.getDescription()), new Object[]{systemCode});
        }
        Throwable throwable = null;
        try (DLock lock = DLock.create((String)"getDaoKongOrderThread", (String)"getDaoKongOrderLogic");){
            block25: {
                block24: {
                    if (!lock.tryLock()) break block25;
                    String result = null;
                    try {
                        BillCenterOrgMappingService orgMappingService = new BillCenterOrgMappingService();
                        DynamicObject frontSystemObject = orgMappingService.loadSingleBySystemCode(systemCode);
                        if (frontSystemObject != null) {
                            String client_enc_key = frontSystemObject.getString("client_enc_key");
                            String billNoParam = this.getBillNoParamMethod(paramContent);
                            boolean flag = false;
                            if (StringUtils.isNotEmpty((CharSequence)client_enc_key)) {
                                flag = Boolean.parseBoolean(client_enc_key);
                            }
                            if (flag) {
                                result = this.getTestDemo();
                                applyBillList = this.dealCommonLogicMethod(systemCode, billNoParam, paramContent, result);
                            } else {
                                result = this.doGetDataService(frontSystemObject, paramContent);
                                applyBillList = this.dealCommonLogicMethod(systemCode, billNoParam, paramContent, result);
                            }
                        } else {
                            String tipMsg = String.format(ResManager.loadKDString((String)"\u6839\u636e\u7cfb\u7edf\u7f16\u7801\uff1a%1$s\uff0c\u65e0\u6cd5\u5339\u914d\u5230\u7cfb\u7edf\u914d\u7f6e\u6570\u636e\uff01", (String)"HeroGourmetSysDataImpl_4", (String)"imc-sim-service", (Object[])new Object[0]), systemCode);
                            throw new KDBizException(tipMsg);
                        }
                        this.dealSaveDaoKongFieldDataMethod(result);
                    }
                    catch (Exception e) {
                        String errorMsg = e.getMessage();
                        logger.error("\u83b7\u53d6\u9053\u63a7\u7cfb\u7edf\u7684\u5f85\u7533\u8bf7\u5f00\u7968\u6570\u636e\uff0c\u51fa\u73b0\u5f02\u5e38:{}", (Object)errorMsg);
                        BillErrorVo billErrorVo = new BillErrorVo();
                        billErrorVo.setErrorMsg(errorMsg);
                        billErrorVo.setFailNum(1);
                        applyBillList.add((BillVo)billErrorVo);
                        break block24;
                    }
                    finally {
                        this.dealSaveDaoKongFieldDataMethod(result);
                        lock.unlock();
                    }
                    lock.unlock();
                }
                ArrayList<BillVo> arrayList = applyBillList;
                return arrayList;
            }
            try {
                String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u6b63\u5728\u626b\u7801\u62c9\u5355\u5904\u7406\uff0c\u8bf7\u7a0d\u5019\u91cd\u8bd5!", (String)"GalaSysDataImpl_5", (String)"imc-sim-service", (Object[])new Object[0]);
                throw new KDBizException(errorMsg);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private void dealSaveDaoKongFieldDataMethod(String result) {
        logger.info("dealSaveDaoKongFieldDataMethod, result:{}", (Object)result);
        if (StringUtils.isBlank((CharSequence)result)) {
            return;
        }
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        DaoKongResultVO daoKongResultVO = (DaoKongResultVO)JSONObject.parseObject((String)result, DaoKongResultVO.class);
        if (daoKongResultVO == null) {
            return;
        }
        boolean flag = daoKongResultVO.isTrue();
        if (flag) {
            List<DaoKongOrderInfo> daoKongOrderInfoList = daoKongResultVO.getDatas();
            if (daoKongOrderInfoList == null || daoKongOrderInfoList.isEmpty()) {
                return;
            }
            for (DaoKongOrderInfo orderInfo : daoKongOrderInfoList) {
                String sysSource = orderInfo.getSysSource();
                String daoKongOrderNo = orderInfo.getOrderNo();
                String daoKongAreaNo = orderInfo.getDistrictCode();
                String daoKongOrderSource = orderInfo.getOrderSource();
                logger.info("dealSaveDaoKongFieldDataMethod, daoKongOrderNo:{}, daoKongAreaNo:{}, sysSource:{}", new Object[]{daoKongOrderNo, daoKongAreaNo, sysSource});
                DynamicObject billCenterObject = null;
                if (this.isHeroGourmet(sysSource)) {
                    String checkNumber = orderInfo.getCheckNumber();
                    String location = orderInfo.getLocation();
                    String businessDate = orderInfo.getBusinessDate();
                    String billNo = checkNumber + "_" + location + "_" + businessDate;
                    billCenterObject = billCenterInvoiceCommonService.dealCheckBillCenterDataMethod("billno", billNo, sysSource);
                } else if (StringUtils.equalsAnyIgnoreCase((CharSequence)sysSource, (CharSequence[])new CharSequence[]{BillCenterSystemEnum.SYSTEM_GALA_GZCY.getCode(), BillCenterSystemEnum.SYSTEM_GALA_ZHCY.getCode(), BillCenterSystemEnum.SYSTEM_GALA_QYCY.getCode()})) {
                    String[] array = this.dealDecodeParamContentMethod(orderInfo);
                    if (array == null || array.length < 2) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u9053\u63a7\u8fd4\u56de\u7684\u63d0\u53d6\u7801\u53c2\u6570\uff0c\u89e3\u5bc6\u5931\u8d25\uff01", (String)"DaoKongDataImpl_3", (String)"imc-sim-service", (Object[])new Object[0]));
                    }
                    if (array[0] == null || array[1] == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u9053\u63a7\u8fd4\u56de\u7684\u63d0\u53d6\u7801\u53c2\u6570\uff0c\u89e3\u5bc6\u5931\u8d25\uff01", (String)"DaoKongDataImpl_3", (String)"imc-sim-service", (Object[])new Object[0]));
                    }
                    String extractedCode = array[0];
                    billCenterObject = billCenterInvoiceCommonService.dealCheckBillCenterDataMethod("extracted_code", extractedCode, sysSource);
                }
                if (billCenterObject == null) continue;
                billCenterObject.set("daokong_order_no", (Object)daoKongOrderNo);
                billCenterObject.set("daokong_area_no", (Object)daoKongAreaNo);
                billCenterObject.set("daokong_order_source", (Object)daoKongOrderSource);
                SaveServiceHelper.update((DynamicObject)billCenterObject);
                logger.info("dealSaveDaoKongFieldDataMethod, \u66f4\u65b0\u9053\u63a7\u8ba2\u5355\u6570\u636e\u6210\u529f\u3002");
            }
        }
    }

    private JSONArray dealFormatDaoKongResultMethod(String result) {
        DaoKongResultVO daoKongResultVO = (DaoKongResultVO)JSONObject.parseObject((String)result, DaoKongResultVO.class);
        if (daoKongResultVO == null) {
            String errorMsg = ResManager.loadKDString((String)"\u9053\u63a7\u7cfb\u7edf\u8fd4\u56de\u7684\u6570\u636e\u5185\u5bb9\u4e3a\u7a7a\uff01", (String)"DaoKongDataImpl_2", (String)"imc-sim-service", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        boolean flag = daoKongResultVO.isTrue();
        if (flag) {
            List<DaoKongOrderInfo> daoKongOrderInfoList = daoKongResultVO.getDatas();
            if (daoKongOrderInfoList == null || daoKongOrderInfoList.isEmpty()) {
                String errorMsg = ResManager.loadKDString((String)"\u9053\u63a7\u7cfb\u7edf\u8fd4\u56de\u7684\u6570\u636e\u5185\u5bb9\u4e3a\u7a7a\uff01", (String)"DaoKongDataImpl_2", (String)"imc-sim-service", (Object[])new Object[0]);
                throw new KDBizException(errorMsg);
            }
            JSONArray jsonArray = new JSONArray();
            for (DaoKongOrderInfo orderInfo : daoKongOrderInfoList) {
                String sysSource = orderInfo.getSysSource();
                JSONObject subObject = new JSONObject();
                if (this.isHeroGourmet(sysSource)) {
                    subObject = this.getParamContentByHeroGourmet(orderInfo);
                } else if (StringUtils.equalsAnyIgnoreCase((CharSequence)sysSource, (CharSequence[])new CharSequence[]{BillCenterSystemEnum.SYSTEM_GALA_GZCY.getCode(), BillCenterSystemEnum.SYSTEM_GALA_ZHCY.getCode(), BillCenterSystemEnum.SYSTEM_GALA_QYCY.getCode()})) {
                    subObject = this.getParamContentByGala(orderInfo);
                }
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("systemCode", (Object)sysSource);
                jsonObject.put("paramContent", (Object)subObject);
                jsonArray.add((Object)jsonObject);
            }
            return jsonArray;
        }
        String resultMsg = daoKongResultVO.getResultMsg();
        logger.error("\u9053\u63a7\u7cfb\u7edf\u8fd4\u56de\u7684\u7ed3\u6784\u4f53\u5185\u5bb9\u5931\u8d25:{}", (Object)resultMsg);
        throw new KDBizException(resultMsg);
    }

    private boolean isHeroGourmet(String sysSource) {
        return StringUtils.equalsAnyIgnoreCase((CharSequence)sysSource, (CharSequence[])new CharSequence[]{BillCenterSystemEnum.SYSTEM_HERO_GZCLXJH1.getCode(), BillCenterSystemEnum.SYSTEM_HERO_PANDAH1.getCode(), BillCenterSystemEnum.SYSTEM_HERO_MSH1.getCode(), BillCenterSystemEnum.SYSTEM_GOURMET_CHIMEL1.getCode(), BillCenterSystemEnum.SYSTEM_GOURMET_HQBH1.getCode(), BillCenterSystemEnum.SYSTEM_GOURMET_PH1.getCode(), BillCenterSystemEnum.SYSTEM_GOURMET_CH1.getCode(), BillCenterSystemEnum.SYSTEM_HERO_QYCLGC1.getCode()});
    }

    private JSONObject getParamContentByGala(DaoKongOrderInfo orderInfo) {
        JSONObject subObject = new JSONObject();
        String[] array = this.dealDecodeParamContentMethod(orderInfo);
        if (array == null || array.length < 2) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9053\u63a7\u8fd4\u56de\u7684\u63d0\u53d6\u7801\u53c2\u6570\uff0c\u89e3\u5bc6\u5931\u8d25\uff01", (String)"DaoKongDataImpl_3", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        if (array[0] == null || array[1] == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9053\u63a7\u8fd4\u56de\u7684\u63d0\u53d6\u7801\u53c2\u6570\uff0c\u89e3\u5bc6\u5931\u8d25\uff01", (String)"DaoKongDataImpl_3", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        subObject.put("codeNo", (Object)array[0]);
        subObject.put("date", (Object)array[1]);
        subObject.put("opKey", (Object)"PC");
        return subObject;
    }

    private String[] dealDecodeParamContentMethod(DaoKongOrderInfo orderInfo) {
        boolean flag;
        String[] array = new String[2];
        String ddh = orderInfo.getExtractedCode();
        String date = orderInfo.getExtractedDate();
        logger.info("dealDecodeParamContentMethod, ddh:{}, date:{}", (Object)ddh, (Object)date);
        String baseUrl = (String)ImcConfigUtil.getValue((String)"bdm_ismc_config_move").get("bdm_ismc_config_move_cloud_url");
        if (StringUtils.isBlank((CharSequence)baseUrl)) {
            baseUrl = "https://sdfp.chimelong.com/";
        }
        baseUrl = baseUrl.substring(0, baseUrl.lastIndexOf("/"));
        String decodeContent = baseUrl + "?businessScene=5&billSource=billCenter&sysSource=" + orderInfo.getSysSource() + "&ddh=" + ddh;
        logger.info("dealDecodeParamContentMethod, decodeContent:{}", (Object)decodeContent);
        boolean bl = flag = decodeContent.startsWith("https") || decodeContent.startsWith("http");
        if (StringUtils.isNotEmpty((CharSequence)decodeContent) && flag) {
            logger.info("\u53d1\u8d77\u89e3\u5bc6\u8bf7\u6c42\u7684\u5185\u5bb9\u662f:{}", (Object)decodeContent);
            SimGetBillDataService simGetBillDataService = new SimGetBillDataService();
            String responseMsg = simGetBillDataService.dealSplitScanInfoMethod(decodeContent);
            logger.info("\u5f97\u5230\u54cd\u5e94\u89e3\u5bc6\u7684\u5185\u5bb9\u662f:{}", (Object)responseMsg);
            if (StringUtils.isNotEmpty((CharSequence)responseMsg)) {
                String extractedCode;
                JSONObject jsonObject = JSONObject.parseObject((String)responseMsg);
                array[0] = extractedCode = jsonObject.getString("ddh");
                array[1] = date;
            }
        }
        return array;
    }

    private JSONObject getParamContentByHeroGourmet(DaoKongOrderInfo orderInfo) {
        JSONObject subObject = new JSONObject();
        subObject.put("location", (Object)orderInfo.getLocation());
        subObject.put("businessDate", (Object)orderInfo.getBusinessDate());
        subObject.put("checkNumber", (Object)orderInfo.getCheckNumber());
        subObject.put("opKey", (Object)"PC");
        return subObject;
    }

    private List<BillVo> dealCommonLogicMethod(String systemCode, String billNoParam, String paramContent, String result) {
        this.dealSaveInterfaceLogDataByType(systemCode, "1", billNoParam, paramContent, result);
        JSONArray jsonArray = this.dealFormatDaoKongResultMethod(result);
        if (jsonArray == null || jsonArray.isEmpty()) {
            String errorMsg = ResManager.loadKDString((String)"\u89e3\u6790\u9053\u63a7\u7cfb\u7edf\u8fd4\u56de\u7684\u5185\u5bb9\u4e3a\u7a7a\uff01", (String)"DaoKongDataImpl_1", (String)"imc-sim-service", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        logger.info("dealCommonLogicMethod, jsonArray\u5927\u5c0f:{}", (Object)jsonArray.size());
        ArrayList<BillVo> allList = new ArrayList<BillVo>(16);
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            logger.info("\u9053\u63a7\u7cfb\u7edf\u53d1\u8d77\u8bf7\u6c42\uff0c\u53c2\u6570\u5185\u5bb9\u662f:{}", (Object)SerializationUtils.toJsonString((Object)jsonObject));
            List<BillVo> applyBillList = ExternalSystemDataHandler.getExternalSystemData(jsonObject);
            logger.info("\u83b7\u53d6\u8d26\u5355\u6570\u636e\u64cd\u4f5c\uff0c\u8fd4\u56de\u7ed3\u679c\u662f\uff1a{}", applyBillList);
            if (applyBillList == null || applyBillList.size() <= 0) continue;
            allList.addAll(applyBillList);
        }
        return allList;
    }

    private void dealSaveInterfaceLogDataByType(String systemCode, String opType, String billNoParam, String paramContent, String result) {
        BillCenterInvoiceLogService billCenterInvoiceLogService = new BillCenterInvoiceLogService();
        billCenterInvoiceLogService.dealSaveInterfaceLogDataByType(systemCode, opType, billNoParam, paramContent, result);
    }

    private String doGetDataService(DynamicObject frontSystemObject, String paramContent) throws Exception {
        Map<String, String> headerMap = this.getRequestHeaderMethod(frontSystemObject, paramContent, "GetData");
        String systemUrl = frontSystemObject.getString("system_url");
        String requestUrl = systemUrl + "/api/dccy/GetOrderPosDealID";
        logger.info("doGetDataService, requestUrl\u503c:{}", (Object)requestUrl);
        JSONArray jsonArray = this.getRequestParamMethod(paramContent);
        logger.info("DaoKongDataImpl, doGetDataService, \u53d1\u8d77\u8bf7\u6c42\u53c2\u6570\u662f:{}", (Object)jsonArray);
        String result = HttpRequestUtil.post(SerializationUtils.toJsonString((Object)jsonArray), requestUrl, headerMap);
        logger.info("DaoKongDataImpl, doGetDataService, \u8fd4\u56de\u7ed3\u679c\u5185\u5bb9\u662f:{}", (Object)result);
        if (StringUtils.isNotEmpty((CharSequence)result)) {
            return result;
        }
        String errorMsg = ResManager.loadKDString((String)"\u9053\u63a7\u7cfb\u7edf\u8fd4\u56de\u7684\u6570\u636e\u4e3a\u7a7a\uff01", (String)"DaoKongDataImpl_0", (String)"imc-sim-service", (Object[])new Object[0]);
        throw new KDBizException(errorMsg);
    }

    private Map<String, String> getRequestHeaderMethod(DynamicObject frontSystemObject, String paramContent, String opType) throws Exception {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        long curTime = System.currentTimeMillis();
        headerMap.put("Timestamp", String.valueOf(curTime));
        String client_secret = frontSystemObject.getString("client_secret");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(curTime).append(client_secret);
        if ("GetData".equals(opType)) {
            stringBuilder.append("GetOrderPosDealID").append(this.getRequestParamMethod(paramContent));
        } else {
            stringBuilder.append("SetOrderInvoiceInfo").append(paramContent);
        }
        String value = stringBuilder.toString();
        String sign = MD5Util.md5Hex((String)value);
        headerMap.put("Sign", sign);
        logger.info("getRequestHeaderMethod, curTime:{}, token:{}, value:{}, sign:{}", new Object[]{curTime, client_secret, value, sign});
        return headerMap;
    }

    private JSONArray getRequestParamMethod(String paramContent) {
        JSONObject jsonObject = JSONObject.parseObject((String)paramContent);
        String billNo = jsonObject.getString("billNo");
        if (StringUtils.isNotEmpty((CharSequence)billNo)) {
            JSONArray jsonArray = JSONArray.parseArray((String)billNo);
            return jsonArray;
        }
        return null;
    }

    private String getTestDemo() {
        String testInfo = "{\"IsTrue\":true,\"ResultMsg\":\"Success\",\"ResultDate\":\"1715398670294\",\"Datas\":[{\"location\":null,\"extractedCode\":\"4nKmpfXVWFY2Dl94jhgGGtqg4tH9sOAiw7HVPWiDfH2RnsPtNUSqxcWBK8nCsv-9\",\"checkNumber\":null,\"businessDate\":null,\"extractedDate\":\"2024-05-10\",\"sysSource\":\"QYCY\",\"orderType\":\"1\",\"orderTime\":\"2024/5/10 15:47:02\"},{\"location\":null,\"extractedCode\":\"q16_HWALv29TP_SoHQ7kVFlfvlCHTsNeXlFY5S_K6gE1z3f0M7Ns5ED3t9sOl41C\",\"checkNumber\":null,\"businessDate\":null,\"extractedDate\":\"2024-05-10\",\"sysSource\":\"QYCY\",\"orderType\":\"1\",\"orderTime\":\"2024/5/10 15:46:15\"}]}";
        return testInfo;
    }

    private String getBillNoParamMethod(String paramContent) {
        StringBuilder stringBuilder = new StringBuilder();
        JSONObject jsonObject = JSONObject.parseObject((String)paramContent);
        String billNo = jsonObject.getString("billNo");
        if (StringUtils.isNotEmpty((CharSequence)billNo)) {
            JSONArray jsonArray = JSONArray.parseArray((String)billNo);
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject subObject = jsonArray.getJSONObject(i);
                String orderNo = subObject.getString("OrderNO");
                stringBuilder.append(orderNo).append(",");
            }
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dealUpdateOpenInvoiceStatus(DynamicObject dynamicObject, InvoiceVo invoiceVo) {
        String systemCode;
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        if (this.invociceFailCallBack(dynamicObject)) {
            return;
        }
        String call_back_switch = ImcConfigUtil.getValue((String)"Call_Back_Switch", (String)"Call_Back_Switch_DaoKong");
        logger.info("dealUpdateOpenInvoiceStatus, call_back_switch:{}", (Object)call_back_switch);
        if (StringUtils.isBlank((CharSequence)call_back_switch)) {
            return;
        }
        String billNo = invoiceVo.getBillNo();
        DynamicObject billDataObject = billCenterInvoiceCommonService.dealCheckBillCenterDataMethod("billno", billNo, systemCode = invoiceVo.getSystemSource());
        if (billDataObject == null) {
            logger.error("dealCheckDataSourceByDaoKong, \u8d26\u5355\u7f16\u53f7:{}\uff0c\u7cfb\u7edf\u7f16\u7801:{}, \u672a\u5339\u914d\u5230\u8d26\u5355\u6570\u636e\u3002", (Object)billNo, (Object)systemCode);
            return;
        }
        String daoKongOrderNo = billDataObject.getString("daokong_order_no");
        String daoKongAreaNo = billDataObject.getString("daokong_area_no");
        String daoKongOrderSource = billDataObject.getString("daokong_order_source");
        logger.info("dealUpdateOpenInvoiceStatus, daoKongOrderNo:{}, daoKongAreaNo:{}, daoKongOrderSource:{}", new Object[]{daoKongOrderNo, daoKongAreaNo, daoKongOrderSource});
        if (StringUtils.isEmpty((CharSequence)daoKongOrderNo) || StringUtils.isEmpty((CharSequence)daoKongAreaNo) || StringUtils.isEmpty((CharSequence)daoKongOrderSource)) {
            logger.error("dealCheckDataSourceByDaoKong, \u5f53\u524d\u8d26\u5355\u4e0d\u542b\u6709\u9053\u63a7\u8ba2\u5355\u7684\u53c2\u6570\u3002");
            return;
        }
        String result = null;
        String innerParam = null;
        try {
            BillCenterOrgMappingService orgMappingService = new BillCenterOrgMappingService();
            DynamicObject frontSystemObject = orgMappingService.loadSingleBySystemCode("DaoKong");
            if (frontSystemObject == null) {
                String tipMsg;
                result = tipMsg = String.format(ResManager.loadKDString((String)"\u6839\u636e\u7cfb\u7edf\u7f16\u7801\uff1a%1$s\uff0c\u65e0\u6cd5\u5339\u914d\u5230\u7cfb\u7edf\u914d\u7f6e\u6570\u636e\uff01", (String)"HeroGourmetSysDataImpl_4", (String)"imc-sim-service", (Object[])new Object[0]), systemCode);
                throw new KDBizException(tipMsg);
            }
            JSONObject jsonObject = this.createCallBackParamMethod(daoKongOrderNo, daoKongAreaNo, daoKongOrderSource, invoiceVo);
            innerParam = jsonObject.toJSONString();
            result = this.dealPushCallBackToFrontSystem(frontSystemObject, jsonObject);
        }
        catch (Exception e) {
            try {
                result = e.getMessage();
                logger.error("\u53d1\u7968\u72b6\u6001\u56de\u4f20\u9053\u63a7\u7cfb\u7edf\uff0c\u51fa\u73b0\u4e86\u5f02\u5e38:{}", (Object)result);
            }
            catch (Throwable throwable) {
                int invoiceProperty = invoiceVo.getInvoiceProperty();
                if (0 == invoiceProperty) {
                    this.dealSaveInterfaceLogDataByType("DaoKong", BillCenterLogEnum.BLUE_INV_RESULT_OP_TYPE.getBillStatus(), billNo, innerParam, result);
                    this.dealStaticsCallbackMethod(billNo, "DaoKong", result);
                } else if (1 == invoiceProperty) {
                    this.dealSaveInterfaceLogDataByType("DaoKong", BillCenterLogEnum.RED_INV_RESULT_OP_TYPE.getBillStatus(), billNo, innerParam, result);
                }
                throw throwable;
            }
            int invoiceProperty = invoiceVo.getInvoiceProperty();
            if (0 == invoiceProperty) {
                this.dealSaveInterfaceLogDataByType("DaoKong", BillCenterLogEnum.BLUE_INV_RESULT_OP_TYPE.getBillStatus(), billNo, innerParam, result);
                this.dealStaticsCallbackMethod(billNo, "DaoKong", result);
            } else if (1 == invoiceProperty) {
                this.dealSaveInterfaceLogDataByType("DaoKong", BillCenterLogEnum.RED_INV_RESULT_OP_TYPE.getBillStatus(), billNo, innerParam, result);
            }
        }
        int invoiceProperty = invoiceVo.getInvoiceProperty();
        if (0 == invoiceProperty) {
            this.dealSaveInterfaceLogDataByType("DaoKong", BillCenterLogEnum.BLUE_INV_RESULT_OP_TYPE.getBillStatus(), billNo, innerParam, result);
            this.dealStaticsCallbackMethod(billNo, "DaoKong", result);
        } else if (1 == invoiceProperty) {
            this.dealSaveInterfaceLogDataByType("DaoKong", BillCenterLogEnum.RED_INV_RESULT_OP_TYPE.getBillStatus(), billNo, innerParam, result);
        }
    }

    private void dealStaticsCallbackMethod(String billNo, String systemCode, String result) {
        String callbackStatus;
        if (StringUtils.isNotBlank((CharSequence)result)) {
            boolean isTrue;
            JSONObject jsonObject = JSONObject.parseObject((String)result);
            boolean bl = isTrue = jsonObject.containsKey((Object)"isTrue") ? jsonObject.getBoolean("isTrue") : false;
            callbackStatus = isTrue ? "1" : "2";
        } else {
            callbackStatus = "2";
        }
        logger.info("dealStaticsCallbackMethod, billNo:{}, systemCode:{}, callbackStatus:{}", new Object[]{billNo, systemCode, callbackStatus});
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        if ("2".equals(callbackStatus)) {
            billCenterInvoiceCommonService.dealStaticsCallbackMethod(billNo, systemCode, 1, callbackStatus);
        } else {
            billCenterInvoiceCommonService.dealStaticsCallbackMethod(billNo, systemCode, callbackStatus);
        }
    }

    private JSONObject createCallBackParamMethod(String daoKongOrderNo, String daoKongAreaNo, String daoKongOrderSource, InvoiceVo invoiceVo) {
        JSONObject jsonObject = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        JSONObject subObject = new JSONObject();
        subObject.put("orderNo", (Object)daoKongOrderNo);
        subObject.put("districtCode", (Object)daoKongAreaNo);
        subObject.put("orderSource", (Object)daoKongOrderSource);
        subObject.put("invoiceDatas", (Object)this.createInvoiceDatasMethod(invoiceVo));
        jsonArray.add((Object)subObject);
        jsonObject.put("orderDatas", (Object)jsonArray);
        return jsonObject;
    }

    private JSONArray createInvoiceDatasMethod(InvoiceVo invoiceVo) {
        JSONObject jsonObject = new JSONObject();
        String invoiceNo = invoiceVo.getInvoiceNum();
        jsonObject.put("invoiceNo", (Object)invoiceNo);
        String invoiceCode = invoiceVo.getInvoiceCode();
        jsonObject.put("invoiceCode", (Object)invoiceCode);
        String issueDate = DateUtils.format((Date)invoiceVo.getInvoiceDate());
        jsonObject.put("issueDate", (Object)issueDate);
        String invoiceImageUrl = invoiceVo.getInvoiceImageUrl();
        jsonObject.put("invoiceUrl", (Object)invoiceImageUrl);
        String invoiceAmount = invoiceVo.getTotalAmount() == null ? BigDecimal.ZERO.toString() : invoiceVo.getTotalAmount().toString();
        jsonObject.put("invoiceAmount", (Object)invoiceAmount);
        String taxAmount = invoiceVo.getTotalTaxAmount() == null ? BigDecimal.ZERO.toString() : invoiceVo.getTotalTaxAmount().toString();
        jsonObject.put("taxAmount", (Object)taxAmount);
        String totalAmount = invoiceVo.getIncludeTaxAmount() == null ? BigDecimal.ZERO.toString() : invoiceVo.getIncludeTaxAmount().toString();
        jsonObject.put("totalAmount", (Object)totalAmount);
        String invoiceProperty = String.valueOf(invoiceVo.getInvoiceProperty());
        jsonObject.put("invoiceProperty", (Object)invoiceProperty);
        JSONArray jsonArray = new JSONArray();
        jsonArray.add((Object)jsonObject);
        return jsonArray;
    }

    private String dealPushCallBackToFrontSystem(DynamicObject frontSystemObject, JSONObject jsonObject) throws Exception {
        String paramContent = jsonObject.toJSONString();
        Map<String, String> headerMap = this.getRequestHeaderMethod(frontSystemObject, paramContent, "CallBack");
        String systemUrl = frontSystemObject.getString("system_url");
        String requestUrl = systemUrl + "/api/dccy/SetOrderInvoiceInfo";
        logger.info("DaoKongDataImpl, dealPushCallBackToFrontSystem, requestUrl\u503c:{}, \u53d1\u8d77\u8bf7\u6c42\u53c2\u6570\u662f:{}", (Object)requestUrl, (Object)jsonObject);
        String result = HttpRequestUtil.post(SerializationUtils.toJsonString((Object)jsonObject), requestUrl, headerMap);
        logger.info("DaoKongDataImpl, dealPushCallBackToFrontSystem, \u8fd4\u56de\u7ed3\u679c\u5185\u5bb9\u662f:{}", (Object)result);
        if (StringUtils.isNotEmpty((CharSequence)result)) {
            return result;
        }
        String errorMsg = ResManager.loadKDString((String)"\u9053\u63a7\u7cfb\u7edf\u8fd4\u56de\u7684\u6570\u636e\u4e3a\u7a7a\uff01", (String)"DaoKongDataImpl_0", (String)"imc-sim-service", (Object[])new Object[0]);
        throw new KDBizException(errorMsg);
    }

    @Override
    public void dealPushCallBackStatusToFrontSystem(JSONObject paramObject) {
    }

    @Override
    public String dealGetQrCodeMethod(JSONObject paramObject) {
        return null;
    }
}

