/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.billcenter.sys.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.dto.BillVo;
import kd.imc.bdm.common.openapi.InvoiceVo;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.MD5;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.sim.billcenter.BillCenterInvoiceCommonService;
import kd.imc.sim.billcenter.BillCenterInvoiceLogService;
import kd.imc.sim.billcenter.BillCenterOrgMappingService;
import kd.imc.sim.billcenter.domain.FuJiOrderDataVO;
import kd.imc.sim.billcenter.domain.FuJiOrderDetailVO;
import kd.imc.sim.billcenter.domain.FuJiOrderVO;
import kd.imc.sim.billcenter.sys.ExternalSystemsDataService;
import kd.imc.sim.common.constant.BillCenterLogEnum;
import kd.imc.sim.common.constant.ErrorType;
import kd.imc.sim.common.model.billcenter.BillErrorVo;
import kd.imc.sim.common.service.SimClassMappingService;
import kd.imc.sim.common.utils.TaxCalcUtil;
import org.apache.commons.lang3.StringUtils;

public class FuJiSysDataImpl
implements ExternalSystemsDataService {
    private static final Log logger = LogFactory.getLog(FuJiSysDataImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<BillVo> getData(JSONObject paramObject) {
        ArrayList<BillVo> applyBillList = new ArrayList<BillVo>();
        String paramContent = paramObject.getString("paramContent");
        String systemCode = paramObject.getString("systemCode");
        logger.info("FuJiSysDataImpl, paramContent:{}, systemCode:{}", (Object)paramContent, (Object)systemCode);
        if (StringUtils.isEmpty((CharSequence)paramContent) || StringUtils.isEmpty((CharSequence)systemCode)) {
            throw new KDBizException(new ErrorCode(ErrorType.PARAM_IS_NULL.getErrcode(), ErrorType.PARAM_IS_NULL.getDescription()), new Object[]{systemCode});
        }
        try (DLock lock = DLock.create((String)"getFuJiOrderThread", (String)"getFuJiOrderLogic");){
            if (lock.tryLock()) {
                block43: {
                    try {
                        BillCenterOrgMappingService orgMappingService = new BillCenterOrgMappingService();
                        DynamicObject frontSystemObject = orgMappingService.loadSingleBySystemCode(systemCode);
                        if (frontSystemObject != null) {
                            String result;
                            BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
                            String client_enc_key = frontSystemObject.getString("client_enc_key");
                            String billNoParam = this.getBillNoParamMethod(paramContent);
                            boolean flag = false;
                            if (StringUtils.isNotEmpty((CharSequence)client_enc_key)) {
                                flag = Boolean.parseBoolean(client_enc_key);
                            }
                            if (flag) {
                                result = "{\"compression\":\"0\",\"info\":\"\u6267\u884c\u6210\u529f\",\"sign\":\"AFBEF1839B6397A29412510D2EA0C5AE\",\"status\":\"1\",\"value\":\"{\\\"GETINVOICE\\\":{\\\"exec0\\\":[[\\\"-1\\\",\\\"\u8be5\u5c0f\u7968\u4e0d\u5b58\u5728\\\"]],\\\"fieldName\\\":[\\\"CODE\\\",\\\"MSG\\\"],\\\"fieldType\\\":[\\\"S\\\",\\\"S\\\"]}}\"}";
                            } else {
                                DynamicObject dynamicObject = billCenterInvoiceCommonService.dealCheckBillCenterDataMethod("billno", billNoParam, systemCode);
                                if (dynamicObject == null) {
                                    result = FuJiSysDataImpl.doGetDataService(frontSystemObject, paramContent);
                                } else {
                                    String billno = dynamicObject.getString("billno");
                                    String invoice_status = dynamicObject.getString("invoice_status");
                                    String push_status = dynamicObject.getString("pushstatus");
                                    logger.info("FuJiSysDataImpl, \u539f\u59cb\u8ba2\u5355\u7f16\u53f7\uff1a{}\uff0c\u53d1\u7968\u72b6\u6001:{}, \u4e0b\u63a8\u72b6\u6001:{}", new Object[]{billno, invoice_status, push_status});
                                    if ("1".equals(invoice_status) || "5".equals(invoice_status)) {
                                        BillErrorVo billErrorVo = new BillErrorVo();
                                        billErrorVo.setFailNum(1);
                                        String errorMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8ba2\u5355\u7f16\u53f7:%1$s\uff0c\u5df2\u7ecf\u5b8c\u6210\u5f00\u7968\u64cd\u4f5c\uff01", (String)"FuJiSysDataImpl_4", (String)"imc-sim-service", (Object[])new Object[0]), billNoParam);
                                        billErrorVo.setErrorMsg(errorMsg);
                                        applyBillList.add((BillVo)billErrorVo);
                                        ArrayList<BillVo> arrayList = applyBillList;
                                        return arrayList;
                                    }
                                    if ("2".equals(invoice_status)) {
                                        BillErrorVo billErrorVo = new BillErrorVo();
                                        String errorMsg = ResManager.loadKDString((String)"\u6b64\u8ba2\u5355\u5df2\u90e8\u5206\u5f00\u7968\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d\u5f00\u5177\u5269\u4f59\u53d1\u7968\u91d1\u989d!", (String)"FuJiSysDataImpl_5", (String)"imc-sim-service", (Object[])new Object[0]);
                                        billErrorVo.setErrorMsg(errorMsg);
                                        billErrorVo.setFailNum(1);
                                        applyBillList.add((BillVo)billErrorVo);
                                        ArrayList<BillVo> arrayList = applyBillList;
                                        return arrayList;
                                    }
                                    if ("0".equals(push_status) || "1".equals(push_status)) {
                                        BillErrorVo billErrorVo = new BillErrorVo();
                                        String errorMsg = ResManager.loadKDString((String)"\u6b64\u8ba2\u5355\u5df2\u4e0b\u63a8\u6216\u90e8\u5206\u4e0b\u63a8\u5904\u7406\uff0c\u4e0d\u80fd\u91cd\u590d\u62c9\u53d6\u8d26\u5355\u6570\u636e!", (String)"GalaSysDataImpl_13", (String)"imc-sim-service", (Object[])new Object[0]);
                                        billErrorVo.setErrorMsg(errorMsg);
                                        billErrorVo.setFailNum(1);
                                        applyBillList.add((BillVo)billErrorVo);
                                        ArrayList<BillVo> arrayList = applyBillList;
                                        return arrayList;
                                    }
                                    result = FuJiSysDataImpl.doGetDataService(frontSystemObject, paramContent);
                                }
                            }
                            this.dealSaveInterfaceLogDataByType(systemCode, "1", billNoParam, paramContent, result);
                            String errorMsg = this.dealCheckNoPullBillDataMethod(systemCode, result);
                            if (StringUtils.isNotEmpty((CharSequence)errorMsg)) {
                                throw new KDBizException(errorMsg);
                            }
                            this.dealCreateBillCenterDataMethod(result, paramContent, systemCode, applyBillList);
                            flag = billCenterInvoiceCommonService.dealCheckAppOpKeyMethod(paramContent);
                            if (flag) {
                                billCenterInvoiceCommonService.dealCheckMoreThan30Method(applyBillList);
                            }
                            break block43;
                        }
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u672a\u5339\u914d\u5230\u7cfb\u7edf%1$s\u53c2\u6570\u914d\u7f6e\uff01", (String)"FuJiSysDataImpl_0", (String)"imc-sim-service", (Object[])new Object[0]), systemCode));
                    }
                    catch (Exception e) {
                        String errorMsg = e.getMessage();
                        logger.error("\u83b7\u53d6\u5bcc\u57fa\u96f6\u552e\u4e1a\u52a1\u7cfb\u7edf\u7684\u5f85\u7533\u8bf7\u5f00\u7968\u6570\u636e\u51fa\u73b0\u5f02\u5e38:{}", (Object)errorMsg);
                        BillErrorVo billErrorVo = new BillErrorVo();
                        billErrorVo.setErrorMsg(errorMsg);
                        billErrorVo.setFailNum(1);
                        applyBillList.add((BillVo)billErrorVo);
                    }
                    finally {
                        lock.unlock();
                    }
                }
                ArrayList<BillVo> e = applyBillList;
                return e;
            }
            String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u6b63\u5728\u62c9\u53d6\u8ba2\u5355\u6570\u636e\uff0c\u8bf7\u7a0d\u5019\u91cd\u8bd5!", (String)"CenterElectronicsDataImpl_14", (String)"imc-sim-service", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
    }

    private String dealCheckNoPullBillDataMethod(String systemCode, String result) {
        QFilter qFilter = new QFilter("number", "=", (Object)systemCode);
        DynamicObject simClassMappingCfg = SimClassMappingService.getInterfaceByCondition((QFilter)qFilter);
        if (simClassMappingCfg != null) {
            Date limitDate = null;
            try {
                limitDate = simClassMappingCfg.getDate("limit_date");
                if (limitDate == null) {
                    return null;
                }
            }
            catch (Exception e) {
                return null;
            }
            Map<Integer, JSONArray> resultMap = this.getFuJiOrderDataMethod(result);
            Date billDate = this.getBillDateMethod(resultMap);
            logger.info("FuJiSysDataImpl, limitDate:{}, billDate:{}", (Object)limitDate, (Object)billDate);
            if (billDate.compareTo(limitDate) <= 0) {
                String errorMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u65e5\u671f:%1$s\u524d\u7684\uff0c\u4e3a\u907f\u514d\u91cd\u590d\u5f00\u7968\uff0c\u4e0d\u5141\u8bb8\u62c9\u53d6\u6570\u636e\uff01", (String)"FuJiSysDataImpl_CHECK_DATE_0", (String)"imc-sim-service", (Object[])new Object[0]), DateUtils.format((Date)limitDate));
                return errorMsg;
            }
        }
        return null;
    }

    private Map<Integer, JSONArray> getFuJiOrderDataMethod(String result) {
        if (StringUtils.isNotEmpty((CharSequence)result)) {
            JSONObject resultObject = JSONObject.parseObject((String)result);
            String value = resultObject.getString("value");
            if (StringUtils.isEmpty((CharSequence)value)) {
                String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u5bcc\u57fa\u96f6\u552e\u8fd4\u56de\u7684\u5f00\u7968\u5bf9\u8c61\u4e3a\u7a7a\uff01", (String)"FuJiSysDataImpl_6", (String)"imc-sim-service", (Object[])new Object[0]);
                throw new KDBizException(errorMsg);
            }
            FuJiOrderDataVO fuJiOrderDataVO = (FuJiOrderDataVO)JSONObject.parseObject((String)value, FuJiOrderDataVO.class);
            if (fuJiOrderDataVO == null) {
                String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u5bcc\u57fa\u96f6\u552e\u8fd4\u56de\u7684\u5f00\u7968\u6570\u636e\u4e3a\u7a7a\uff01", (String)"FuJiSysDataImpl_7", (String)"imc-sim-service", (Object[])new Object[0]);
                throw new KDBizException(errorMsg);
            }
            resultObject.remove((Object)"value");
            FuJiOrderVO fuJiOrderVO = (FuJiOrderVO)JSONObject.parseObject((String)resultObject.toString(), FuJiOrderVO.class);
            if (fuJiOrderVO == null) {
                String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u5bcc\u57fa\u96f6\u552e\u8fd4\u56de\u7684\u5f00\u7968\u8be6\u60c5\u6570\u636e\u4e3a\u7a7a\uff01", (String)"FuJiSysDataImpl_8", (String)"imc-sim-service", (Object[])new Object[0]);
                throw new KDBizException(errorMsg);
            }
            fuJiOrderVO.setValue(fuJiOrderDataVO);
            String status = fuJiOrderVO.getStatus();
            String info = fuJiOrderVO.getInfo();
            logger.info("dealFormatBillDataMethod, status:{}, info:{}", (Object)status, (Object)info);
            if (!StringUtils.equals((CharSequence)"1", (CharSequence)status)) {
                String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u5bcc\u57fa\u96f6\u552e\u8fd4\u56de\u7684\u5f00\u7968\u6570\u636e\uff0c\u72b6\u6001\u7801\u4e0d\u6b63\u786e\uff01", (String)"FuJiSysDataImpl_9", (String)"imc-sim-service", (Object[])new Object[0]);
                throw new KDBizException(errorMsg);
            }
            FuJiOrderDetailVO fuJiOrderDetailVO = fuJiOrderDataVO.getGETINVOICE();
            if (fuJiOrderDetailVO == null) {
                String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u5bcc\u57fa\u96f6\u552e\u8fd4\u56de\u7684\u5f00\u7968\u8be6\u60c5\u6570\u636e\u4e3a\u7a7a\uff01", (String)"FuJiSysDataImpl_10", (String)"imc-sim-service", (Object[])new Object[0]);
                throw new KDBizException(errorMsg);
            }
            HashMap<Integer, JSONArray> resultMap = new HashMap<Integer, JSONArray>();
            this.dealFormatOrderDetailMethod(resultMap, fuJiOrderDetailVO);
            Object code = this.getElementDataByMap("CODE", resultMap);
            Object message = this.getElementDataByMap("MSG", resultMap);
            if ("-1".equals(code)) {
                String errorMsg = ResManager.loadKDString((String)"\u8ba2\u5355\u6570\u636e\u4e0d\u5b58\u5728\uff01", (String)"FuJiSysDataImpl_11", (String)"imc-sim-service", (Object[])new Object[0]);
                throw new KDBizException(message == null ? errorMsg : message.toString());
            }
            return resultMap;
        }
        String errorMsg = ResManager.loadKDString((String)"\u5bcc\u57fa\u96f6\u552e\u7cfb\u7edf\u83b7\u53d6\u4e0d\u5230\u76f8\u5173\u7684\u8d26\u5355\u6570\u636e\uff01", (String)"FuJiSysDataImpl_12", (String)"imc-sim-service", (Object[])new Object[0]);
        throw new KDBizException(errorMsg);
    }

    private String getBillNoParamMethod(String paramContent) {
        JSONObject paramObject = JSONObject.parseObject((String)paramContent);
        String cashRegisterNo = paramObject.getString("SYJH");
        String invoiceNo = paramObject.getString("FPHM");
        if (StringUtils.isNotEmpty((CharSequence)invoiceNo) && invoiceNo.startsWith("0")) {
            invoiceNo = String.valueOf(Integer.parseInt(invoiceNo));
        }
        return cashRegisterNo + "_" + invoiceNo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dealUpdateOpenInvoiceStatus(DynamicObject dynamicObject, InvoiceVo invoiceVo) {
        if (this.invociceFailCallBack(dynamicObject)) {
            return;
        }
        if (invoiceVo == null) {
            logger.error("FuJiSysDataImpl, dealUpdateOpenInvoiceStatus, \u56de\u4f20\u5f00\u7968\u5bf9\u8c61\u4e3a\u7a7a\uff01");
            return;
        }
        BillCenterOrgMappingService orgMappingService = new BillCenterOrgMappingService();
        String systemCode = invoiceVo.getSystemSource();
        String billNo = invoiceVo.getBillNo();
        String batch = invoiceVo.getBatch();
        logger.info("FuJiSysDataImpl, dealUpdateOpenInvoiceStatus, systemCode:{}, billNo:{}, batch:{}", new Object[]{systemCode, billNo, batch});
        DynamicObject frontSystemObject = orgMappingService.loadSingleBySystemCode(systemCode);
        if (frontSystemObject != null) {
            String INVOICETYPE;
            if (StringUtils.isBlank((CharSequence)billNo)) {
                billNo = invoiceVo.getBatch();
            }
            String SYJH = null;
            String FPHM = null;
            if (StringUtils.isNotEmpty((CharSequence)billNo) && billNo.contains("_")) {
                SYJH = billNo.split("_")[0];
                FPHM = billNo.split("_")[1];
            }
            if (StringUtils.equalsAny((CharSequence)(INVOICETYPE = invoiceVo.getInvoiceType()), (CharSequence[])new CharSequence[]{"028", "026"})) {
                INVOICETYPE = "d";
            } else if (StringUtils.equalsAny((CharSequence)INVOICETYPE, (CharSequence[])new CharSequence[]{"004", "007"})) {
                INVOICETYPE = "z";
            }
            String BILLID = invoiceVo.getBillNo();
            String INVOICECODE = invoiceVo.getInvoiceCode();
            if (StringUtils.isEmpty((CharSequence)INVOICECODE)) {
                INVOICECODE = "null";
            }
            String INVOICENO = invoiceVo.getInvoiceNum();
            String SELLERTAXID = invoiceVo.getSellerTaxpayerId();
            logger.info("FuJiSysDataImpl, dealUpdateOpenInvoiceStatus, invoiceCode:{}, invoiceNo:{}, sellerTaxpayerId:{}", new Object[]{INVOICECODE, INVOICENO, SELLERTAXID});
            String systemUrl = frontSystemObject.getString("system_url");
            String appkey = frontSystemObject.getString("client_enc_key");
            String apiid = frontSystemObject.getString("apiid");
            String client = frontSystemObject.getString("client_secret");
            String compression = frontSystemObject.getString("compression");
            String exeinfo = frontSystemObject.getString("client_id");
            String para = "{'SENDINVOICEDATA':{'COLUMNTYPE':['S','S','S','S','S','S','S','S'],'PARAMETER':[['" + SYJH + "','" + FPHM + "','" + billNo + "','" + INVOICETYPE + "','" + BILLID + "','" + INVOICECODE + "','" + INVOICENO + "','" + SELLERTAXID + "']]}}";
            String timestamp = DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
            logger.info("FuJiSysDataImpl, dealUpdateOpenInvoiceStatus, systemUrl:{}, appkey:{}, apiid:{}, client:{}, compression:{}, exeinfo:{}, para:{}, timestamp:{}", new Object[]{systemUrl, appkey, apiid, client, compression, exeinfo, para, timestamp});
            StringBuilder bs = new StringBuilder();
            bs.append(appkey).append("apiid").append(apiid).append("client").append(client).append("compression").append(compression).append("exeinfo").append(exeinfo).append("para").append(para).append("timestamp").append(timestamp).append(appkey);
            String requestContent = "";
            String result = "";
            try {
                String sign = MD5.md5Hex((String)bs.toString());
                logger.info("FuJiSysDataImpl, dealUpdateOpenInvoiceStatus, \u52a0\u5bc6\u7b7e\u540dsign:{}", (Object)sign);
                String paraEnCoder = URLEncoder.encode(para, "utf-8");
                requestContent = "apiid=" + apiid + "&client=" + client + "&compression=" + compression + "&exeinfo=" + exeinfo + "&para=" + paraEnCoder + "&sign=" + sign + "&timestamp=" + timestamp;
                logger.info("FuJiSysDataImpl, dealUpdateOpenInvoiceStatus, \u8bf7\u6c42\u5185\u5bb9requestContent:{}", (Object)requestContent);
                result = FuJiSysDataImpl.getHttpResult(systemUrl, requestContent, "utf-8");
                logger.info("FuJiSysDataImpl, dealUpdateOpenInvoiceStatus, \u7ed3\u679c\u72b6\u6001\u56de\u4f20\u8fd4\u56de\u5185\u5bb9\u662f\uff1a{}", (Object)result);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                int invoiceProperty = invoiceVo.getInvoiceProperty();
                if (0 == invoiceProperty) {
                    this.dealSaveInterfaceLogDataByType(systemCode, BillCenterLogEnum.BLUE_INV_RESULT_OP_TYPE.getBillStatus(), billNo, requestContent, result);
                    this.dealStaticsCallbackMethod(billNo, systemCode, result);
                } else if (1 == invoiceProperty) {
                    this.dealSaveInterfaceLogDataByType(systemCode, BillCenterLogEnum.RED_INV_RESULT_OP_TYPE.getBillStatus(), billNo, requestContent, result);
                }
            }
        }
    }

    private void dealStaticsCallbackMethod(String billNo, String systemCode, String result) {
        String callbackStatus;
        if (StringUtils.isNotBlank((CharSequence)result)) {
            FuJiOrderVO fuJiOrderVO = (FuJiOrderVO)JSONObject.parseObject((String)result, FuJiOrderVO.class);
            if (fuJiOrderVO != null) {
                String status = fuJiOrderVO.getStatus();
                String info = fuJiOrderVO.getInfo();
                FuJiOrderDataVO fuJiOrderDataVO = fuJiOrderVO.getValue();
                FuJiOrderDetailVO fuJiOrderDetailVO = fuJiOrderDataVO.getSENDINVOICEDATA();
                List<String> fieldNameList = fuJiOrderDetailVO.getFieldName();
                List<List<Object>> exec0List = fuJiOrderDetailVO.getExec0();
                boolean isSuccess = false;
                block0: for (int i = 0; i < exec0List.size(); ++i) {
                    List<Object> fieldValueList = exec0List.get(i);
                    for (int j = 0; j < fieldValueList.size(); ++j) {
                        String fieldName = fieldNameList.get(j);
                        Object fieldValue = fieldValueList.get(j);
                        if (!"CODE".equals(fieldName) || !"0".equals(fieldValue)) continue;
                        isSuccess = true;
                        continue block0;
                    }
                }
                callbackStatus = "1".equals(status) && "\u6267\u884c\u6210\u529f".equals(info) && isSuccess ? "1" : "2";
            } else {
                callbackStatus = "2";
            }
        } else {
            callbackStatus = "2";
        }
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        if ("2".equals(callbackStatus)) {
            billCenterInvoiceCommonService.dealStaticsCallbackMethod(billNo, systemCode, 1, callbackStatus);
        } else {
            billCenterInvoiceCommonService.dealStaticsCallbackMethod(billNo, systemCode, callbackStatus);
        }
    }

    @Override
    public void dealPushCallBackStatusToFrontSystem(JSONObject paramObject) {
        BillCenterInvoiceLogService billCenterInvoiceLogService = new BillCenterInvoiceLogService();
        if (paramObject.containsKey((Object)"approvalResult")) {
            billCenterInvoiceLogService.dealNoticeApprovalRejectMethod(paramObject);
        } else if (paramObject.containsKey((Object)"approvalProcess")) {
            billCenterInvoiceLogService.dealNoticeApprovalProcessMethod(paramObject);
        } else if (paramObject.containsKey((Object)"approvalSuccess")) {
            billCenterInvoiceLogService.dealNoticeApprovalSuccessMethod(paramObject);
        } else {
            this.dealNoticeCallBackStatusToFrontSystem(paramObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dealNoticeCallBackStatusToFrontSystem(JSONObject paramObject) {
        BillCenterOrgMappingService orgMappingService = new BillCenterOrgMappingService();
        String systemCode = paramObject.getString("systemCode");
        String innerParam = paramObject.getString("innerParam");
        String billNo = paramObject.getString("billNo");
        String opType = paramObject.getString("opType");
        logger.info("FuJiSysDataImpl, dealPushCallBackStatusToFrontSystem, systemCode:{}, billNo:{}", (Object)systemCode, (Object)billNo);
        String result = "";
        DynamicObject frontSystemObject = orgMappingService.loadSingleBySystemCode(systemCode);
        if (frontSystemObject != null) {
            String systemUrl = frontSystemObject.getString("system_url");
            try {
                String requestContent = innerParam;
                logger.info("FuJiSysDataImpl, dealPushCallBackStatusToFrontSystem, \u8bf7\u6c42\u5185\u5bb9\u662f:{}", (Object)requestContent);
                result = FuJiSysDataImpl.getHttpResult(systemUrl, requestContent, "utf-8");
                logger.info("FuJiSysDataImpl, dealPushCallBackStatusToFrontSystem, \u8fd4\u56de\u5185\u5bb9\u662f\uff1a{}", (Object)result);
            }
            catch (Exception e) {
                result = e.getMessage();
                logger.error("\u624b\u5de5\u63a8\u9001\u56de\u8c03\u7ed3\u679c\u7ed9\u5230\u5bcc\u57fa\u96f6\u552e\u7cfb\u7edf\u51fa\u73b0\u5f02\u5e38:{}", (Object)result);
            }
            finally {
                this.dealSaveInterfaceLogDataByType(systemCode, opType, billNo, innerParam, result);
                if (BillCenterLogEnum.BLUE_INV_RESULT_OP_TYPE.getBillStatus().equals(opType)) {
                    this.dealStaticsCallbackMethod(billNo, systemCode, result);
                }
            }
        } else {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5bcc\u57fa\u96f6\u552e:%1$s\u7684\u7cfb\u7edf\u6765\u6e90\u914d\u7f6e\u4e0d\u5b58\u5728\uff01", (String)"FuJiSysDataImpl_2", (String)"imc-sim-service", (Object[])new Object[0]), systemCode));
        }
    }

    @Override
    public String dealGetQrCodeMethod(JSONObject paramObject) {
        return null;
    }

    private void dealSaveInterfaceLogDataByType(String systemCode, String opType, String billNoParam, String paramContent, String result) {
        BillCenterInvoiceLogService billCenterInvoiceLogService = new BillCenterInvoiceLogService();
        billCenterInvoiceLogService.dealSaveInterfaceLogDataByType(systemCode, opType, billNoParam, paramContent, result);
    }

    private void dealCreateBillCenterDataMethod(String result, String paramContent, String systemCode, List<BillVo> applyBillList) {
        String billNo = this.getBillNoParamMethod(paramContent);
        Map<Integer, JSONArray> resultMap = this.getFuJiOrderDataMethod(result);
        boolean flag = false;
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        logger.info("dealCreateBillCenterDataMethod, billNo:{}, systemCode:{}", (Object)billNo, (Object)systemCode);
        QFilter qFilter = new QFilter("billno", "=", (Object)billNo).and("system_code", "=", (Object)systemCode);
        DynamicObject dynamicObject = billCenterInvoiceCommonService.dealLoadIsomerismBillDataMethod(qFilter);
        if (dynamicObject == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"sim_isomerism_bill_data");
        } else {
            flag = true;
        }
        logger.info("dealCreateBillCenterDataMethod, FuJiSysDataImpl, flag:{}", (Object)flag);
        this.dealCreateBillHeaderDataMethod(dynamicObject, billNo, systemCode, resultMap);
        this.dealCreateBillItemDataMethod(dynamicObject, resultMap);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        billCenterInvoiceCommonService.dealFormatBillDataMethod(dynamicObject, applyBillList);
    }

    private void dealCreateBillItemDataMethod(DynamicObject dynamicObject, Map<Integer, JSONArray> resultMap) {
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("sim_isomerism_item_data");
        if (dynamicObjectCollection == null) {
            String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u5355\u4e2d\u5fc3\u5546\u54c1\u660e\u7ec6\u533a\u5143\u6570\u636e\u4e0d\u5b58\u5728\uff01", (String)"FuJiSysDataImpl_13", (String)"imc-sim-service", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        if (dynamicObjectCollection.size() > 0) {
            dynamicObjectCollection.clear();
        }
        String systemCode = dynamicObject.getString("system_code");
        for (Map.Entry<Integer, JSONArray> entryObject : resultMap.entrySet()) {
            JSONArray jsonArray = entryObject.getValue();
            DynamicObject itemObject = dynamicObjectCollection.addNew();
            itemObject.set("product_id", null);
            itemObject.set("product_name", (Object)this.getFieldValueByCondition(jsonArray, "GOODSNAME"));
            itemObject.set("product_code", null);
            itemObject.set("product_type", (Object)this.getFieldValueByCondition(jsonArray, "UNITNAME"));
            String qty = this.getFieldValueByCondition(jsonArray, "QTY");
            itemObject.set("product_quantity", (Object)new BigDecimal(qty));
            itemObject.set("product_price", (Object)this.getFieldValueByCondition(jsonArray, "PRICE"));
            Object productAmount = this.getFieldValueByCondition(jsonArray, "SALEVALUE");
            if (productAmount == null) {
                productAmount = BigDecimal.ZERO;
            }
            itemObject.set("product_amount", productAmount);
            itemObject.set("avg_amount", (Object)this.getFieldValueByCondition(jsonArray, "SALEVALUE"));
            String taxCode = this.getFieldValueByCondition(jsonArray, "TAXID");
            itemObject.set("tax_code", (Object)taxCode);
            Object taxRate = this.getFieldValueByCondition(jsonArray, "TAXRATE");
            if (taxRate == null) {
                taxRate = BigDecimal.ZERO;
            }
            itemObject.set("tax_rate", taxRate);
            BigDecimal taxAmount = TaxCalcUtil.calTax((BigDecimal)new BigDecimal(productAmount.toString()), (BigDecimal)BigDecimal.ZERO, (String)taxRate.toString(), (boolean)true);
            itemObject.set("tax_amount", (Object)taxAmount);
            itemObject.set("invoicable_switch", (Object)"1");
            itemObject.set("consume_time", (Object)this.getBillDateMethod(resultMap));
            itemObject.set("folio_no", null);
            itemObject.set("tc_group", null);
            String taxNo = this.getFieldValueByCondition(jsonArray, "GSBM");
            itemObject.set("tax_no", (Object)taxNo);
            itemObject.set("splitkey", (Object)taxNo);
            DynamicObject orgObject = TaxUtils.getOrgDynamicObjectByTaxNo((String)taxNo);
            itemObject.set("orgid", (Object)orgObject);
            BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
            DynamicObject itemTypeObject = billCenterInvoiceCommonService.getBillCenterItemType(taxCode);
            itemObject.set("itemtype", (Object)itemTypeObject);
            itemObject.set("unpushamount", productAmount);
            itemObject.set("unpushtax", (Object)taxAmount);
            itemObject.set("unpushnum", (Object)this.getFieldValueByCondition(jsonArray, "QTY"));
            itemObject.set("rowpushstatus", (Object)"-1");
            this.dealSetItemOpenInvoiceTypeMethod(itemObject, taxCode);
            itemObject.set("apply_no", (Object)systemCode);
        }
    }

    private void dealSetItemOpenInvoiceTypeMethod(DynamicObject itemObject, String taxCode) {
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        DynamicObject specialInvoiceObject = billCenterInvoiceCommonService.dealGetSpecialInvoiceMethod(null, null, null, taxCode);
        if (specialInvoiceObject == null) {
            itemObject.set("openinvoicetype", (Object)"02");
        } else {
            String is_special_invoice = specialInvoiceObject.getString("is_special_invoice");
            if (StringUtils.isBlank((CharSequence)is_special_invoice) || "0".equals(is_special_invoice)) {
                itemObject.set("openinvoicetype", (Object)"02");
            } else {
                itemObject.set("openinvoicetype", (Object)"01");
            }
        }
    }

    private String getFieldValueByCondition(JSONArray jsonArray, String key) {
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            if (!jsonObject.containsKey((Object)key)) continue;
            return jsonObject.getString(key);
        }
        return null;
    }

    private void dealCreateBillHeaderDataMethod(DynamicObject dynamicObject, String billNo, String systemCode, Map<Integer, JSONArray> resultMap) {
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        dynamicObject.set("billno", (Object)billNo);
        dynamicObject.set("billstatus", (Object)"C");
        dynamicObject.set("pushstatus", (Object)"-1");
        dynamicObject.set("system_code", (Object)systemCode);
        String systemName = billCenterInvoiceCommonService.getSystemNameMethod(systemCode);
        dynamicObject.set("system_name", (Object)systemName);
        BillCenterOrgMappingService billCenterOrgMappingService = new BillCenterOrgMappingService();
        DynamicObject frontSystemObject = billCenterOrgMappingService.loadSingleBySystemCode(systemCode);
        dynamicObject.set("system", (Object)frontSystemObject);
        dynamicObject.set("org_code", null);
        dynamicObject.set("org_name", null);
        for (Map.Entry<Integer, JSONArray> entryObject : resultMap.entrySet()) {
            JSONArray jsonArray = entryObject.getValue();
            String taxNo = this.getFieldValueByCondition(jsonArray, "GSBM");
            DynamicObject orgObject = TaxUtils.getOrgDynamicObjectByTaxNo((String)taxNo);
            if (orgObject == null) continue;
            dynamicObject.set("org", (Object)orgObject);
            break;
        }
        dynamicObject.set("custom_name", null);
        dynamicObject.set("bill_create_time", (Object)new Date());
        dynamicObject.set("createtime", (Object)new Date());
        dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        Date billDate = this.getBillDateMethod(resultMap);
        dynamicObject.set("bill_date", (Object)billDate);
        dynamicObject.set("user_phone", null);
        dynamicObject.set("remark", null);
        BigDecimal totalAmount = this.getBillTotalAmountMethod(resultMap);
        dynamicObject.set("total_amount", (Object)totalAmount);
        dynamicObject.set("invoicable_amount", (Object)totalAmount);
        dynamicObject.set("invoice_amount", (Object)BigDecimal.ZERO);
        dynamicObject.set("remain_amount", (Object)totalAmount);
        dynamicObject.set("invoice_status", (Object)"0");
        dynamicObject.set("hsbz", (Object)"1");
    }

    private BigDecimal getBillTotalAmountMethod(Map<Integer, JSONArray> resultMap) {
        BigDecimal totalAmount = new BigDecimal("0.00");
        for (Map.Entry<Integer, JSONArray> entryObject : resultMap.entrySet()) {
            JSONArray jsonArray = entryObject.getValue();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                if (!jsonObject.containsKey((Object)"SALEVALUE")) continue;
                BigDecimal amount = jsonObject.getBigDecimal("SALEVALUE");
                totalAmount = totalAmount.add(amount);
            }
        }
        return totalAmount;
    }

    private Date getBillDateMethod(Map<Integer, JSONArray> resultMap) {
        Object saleTime = this.getElementDataByMap("SALETIME", resultMap);
        if (saleTime == null) {
            return new Date();
        }
        String tradeTime = saleTime.toString();
        Date date = StringUtils.isEmpty((CharSequence)tradeTime) ? new Date() : DateUtils.stringToDate((String)tradeTime);
        return date;
    }

    private void dealFormatOrderDetailMethod(Map<Integer, JSONArray> resultMap, FuJiOrderDetailVO fuJiOrderDetailVO) {
        List<String> fieldNameList = fuJiOrderDetailVO.getFieldName();
        List<List<Object>> exec0List = fuJiOrderDetailVO.getExec0();
        for (int i = 0; i < exec0List.size(); ++i) {
            List<Object> fieldValueList = exec0List.get(i);
            JSONArray jsonArray = new JSONArray();
            for (int j = 0; j < fieldValueList.size(); ++j) {
                String fieldName = fieldNameList.get(j);
                Object fieldValue = fieldValueList.get(j);
                JSONObject jsonObject = new JSONObject();
                jsonObject.put(fieldName, fieldValue);
                jsonArray.add((Object)jsonObject);
            }
            resultMap.put(i, jsonArray);
        }
    }

    private Object getElementDataByMap(String key, Map<Integer, JSONArray> resultMap) {
        for (Map.Entry<Integer, JSONArray> entryObject : resultMap.entrySet()) {
            JSONArray jsonArray = entryObject.getValue();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                if (!jsonObject.containsKey((Object)key)) continue;
                return jsonObject.getString(key);
            }
        }
        return null;
    }

    public static String doGetDataService(DynamicObject frontSystemObject, String paramContent) throws Exception {
        JSONObject paramObject = JSONObject.parseObject((String)paramContent);
        String cashRegisterNo = paramObject.getString("SYJH");
        String invoiceNo = paramObject.getString("FPHM");
        String systemUrl = frontSystemObject.getString("system_url");
        String appkey = frontSystemObject.getString("client_enc_key");
        String apiid = frontSystemObject.getString("apiid");
        String client = frontSystemObject.getString("client_secret");
        String compression = frontSystemObject.getString("compression");
        String exeinfo = frontSystemObject.getString("client_id");
        String para = "{'GETINVOICE':{'COLUMNTYPE':['S','S'],'PARAMETER':[['" + cashRegisterNo + "','" + invoiceNo + "']]}}";
        String timestamp = DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
        logger.info("FuJiSysDataImpl, doGetDataService, systemUrl:{}, appkey:{}, apiid:{}, client:{}, compression:{}, exeinfo:{}, para:{}, timestamp:{}", new Object[]{systemUrl, appkey, apiid, client, compression, exeinfo, para, timestamp});
        StringBuilder bs = new StringBuilder();
        bs.append(appkey).append("apiid").append(apiid).append("client").append(client).append("compression").append(compression).append("exeinfo").append(exeinfo).append("para").append(para).append("timestamp").append(timestamp).append(appkey);
        try {
            String sign = MD5.md5Hex((String)bs.toString());
            logger.info("FuJiSysDataImpl, doGetDataService, \u52a0\u5bc6\u7b7e\u540dsign:{}", (Object)sign);
            String paraEnCoder = URLEncoder.encode(para, "utf-8");
            String requestContent = "apiid=" + apiid + "&client=" + client + "&compression=" + compression + "&exeinfo=" + exeinfo + "&para=" + paraEnCoder + "&sign=" + sign + "&timestamp=" + timestamp;
            logger.info("FuJiSysDataImpl, doGetDataService, \u8bf7\u6c42\u5185\u5bb9requestContent:{}", (Object)requestContent);
            String result = FuJiSysDataImpl.getHttpResult(systemUrl, requestContent, "utf-8");
            logger.info("FuJiSysDataImpl, doGetDataService, \u83b7\u53d6\u5f00\u7968\u6570\u636e\uff0cresult\u8fd4\u56de\u5185\u5bb9\u662f\uff1a{}", (Object)result);
            return result;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public static String getHttpResult(String urlStr, String content, String encoding) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

