/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.billcenter.sys.impl;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.dto.BillVo;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.openapi.InvoiceVo;
import kd.imc.bdm.common.util.Base64Util;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.sim.billcenter.BillCenterInvoiceCommonService;
import kd.imc.sim.billcenter.BillCenterInvoiceLogService;
import kd.imc.sim.billcenter.BillCenterOrgMappingService;
import kd.imc.sim.billcenter.domain.HeroGourmetDepartmentVO;
import kd.imc.sim.billcenter.domain.HeroGourmetErrorVO;
import kd.imc.sim.billcenter.domain.HeroGourmetItemsVO;
import kd.imc.sim.billcenter.domain.HeroGourmetOrderVO;
import kd.imc.sim.billcenter.domain.HeroGourmetPaymentVO;
import kd.imc.sim.billcenter.domain.HeroGourmetServiceChargeVO;
import kd.imc.sim.billcenter.sys.ExternalSystemsDataService;
import kd.imc.sim.billcenter.sys.impl.DaoKongDataImpl;
import kd.imc.sim.billcenter.util.HttpRequestUtil;
import kd.imc.sim.common.constant.ErrorType;
import kd.imc.sim.common.model.billcenter.BillErrorVo;
import kd.imc.sim.common.model.billcenter.BillWarnVo;
import kd.imc.sim.common.service.SimClassMappingService;
import kd.imc.sim.common.utils.TaxCalcUtil;
import org.apache.commons.lang3.StringUtils;

public class HeroGourmetSysDataImpl
implements ExternalSystemsDataService {
    private static final Log logger = LogFactory.getLog(HeroGourmetSysDataImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<BillVo> getData(JSONObject paramObject) {
        ArrayList<BillVo> applyBillList = new ArrayList<BillVo>();
        String paramContent = paramObject.getString("paramContent");
        String systemCode = paramObject.getString("systemCode");
        logger.info("HeroGourmetSysDataImpl, paramContent:{}, systemCode:{}", (Object)paramContent, (Object)systemCode);
        if (StringUtils.isEmpty((CharSequence)paramContent) || StringUtils.isEmpty((CharSequence)systemCode)) {
            throw new KDBizException(new ErrorCode(ErrorType.PARAM_IS_NULL.getErrcode(), ErrorType.PARAM_IS_NULL.getDescription()), new Object[]{systemCode});
        }
        try (DLock lock = DLock.create((String)"getHeroGourmetOrderThread", (String)"getHeroGourmetOrderLogic");){
            if (lock.tryLock()) {
                block42: {
                    try {
                        String errorMsg = this.dealCheckNoPullBillDataMethod(systemCode, paramContent);
                        if (StringUtils.isNotEmpty((CharSequence)errorMsg)) {
                            throw new KDBizException(errorMsg);
                        }
                        BillCenterOrgMappingService orgMappingService = new BillCenterOrgMappingService();
                        DynamicObject frontSystemObject = orgMappingService.loadSingleBySystemCode(systemCode);
                        if (frontSystemObject != null) {
                            BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
                            String client_enc_key = frontSystemObject.getString("client_enc_key");
                            String billNoParam = this.getBillNoParamMethod(paramContent);
                            boolean flag = false;
                            if (StringUtils.isNotEmpty((CharSequence)client_enc_key)) {
                                flag = Boolean.parseBoolean(client_enc_key);
                            }
                            if (flag) {
                                String result = this.getTestDemo();
                                this.dealCommonLogicMethod(systemCode, billNoParam, paramContent, result, applyBillList);
                                break block42;
                            }
                            String accessToken = this.getAccessTokenMethod(frontSystemObject);
                            logger.info("\u8fd4\u56de\u7684access_token\u6388\u6743\u7801\u662f:{}", (Object)accessToken);
                            if (StringUtils.isEmpty((CharSequence)accessToken)) {
                                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6Hero\u3001Gourmet\u7cfb\u7edf\u7684access_token\u6388\u6743\u7801\u4e3a\u7a7a\uff01", (String)"HeroGourmetSysDataImpl_0", (String)"imc-sim-service", (Object[])new Object[0]));
                            }
                            DynamicObject dynamicObject = billCenterInvoiceCommonService.dealCheckBillCenterDataMethod("billno", billNoParam, systemCode);
                            if (dynamicObject == null) {
                                String result = this.doGetDataService(frontSystemObject, paramContent, accessToken);
                                this.dealCommonLogicMethod(systemCode, billNoParam, paramContent, result, applyBillList);
                                break block42;
                            }
                            String billno = dynamicObject.getString("billno");
                            String invoice_status = dynamicObject.getString("invoice_status");
                            String push_status = dynamicObject.getString("pushstatus");
                            logger.info("HeroGourmetSysDataImpl, \u539f\u59cb\u8ba2\u5355\u7f16\u53f7:{}, \u53d1\u7968\u72b6\u6001:{}, \u4e0b\u63a8\u72b6\u6001:{}", new Object[]{billno, invoice_status, push_status});
                            if ("1".equals(invoice_status) || "5".equals(invoice_status)) {
                                BillErrorVo billErrorVo = new BillErrorVo();
                                String tipMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8ba2\u5355\u7f16\u53f7:%1$s\uff0c\u5df2\u7ecf\u5b8c\u6210\u5f00\u7968\u64cd\u4f5c\uff01", (String)"HeroGourmetSysDataImpl_2", (String)"imc-sim-service", (Object[])new Object[0]), billNoParam);
                                billErrorVo.setErrorMsg(tipMsg);
                                billErrorVo.setFailNum(1);
                                applyBillList.add((BillVo)billErrorVo);
                                ArrayList<BillVo> arrayList = applyBillList;
                                return arrayList;
                            }
                            if ("2".equals(invoice_status)) {
                                BillErrorVo billErrorVo = new BillErrorVo();
                                String tipMsg = ResManager.loadKDString((String)"\u6b64\u8ba2\u5355\u5df2\u90e8\u5206\u5f00\u7968\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d\u5f00\u5177\u5269\u4f59\u53d1\u7968\u91d1\u989d!", (String)"HeroGourmetSysDataImpl_3", (String)"imc-sim-service", (Object[])new Object[0]);
                                billErrorVo.setErrorMsg(tipMsg);
                                billErrorVo.setFailNum(1);
                                applyBillList.add((BillVo)billErrorVo);
                                ArrayList<BillVo> arrayList = applyBillList;
                                return arrayList;
                            }
                            if ("1".equals(push_status) || "2".equals(push_status)) {
                                billCenterInvoiceCommonService.dealFormatBillDataMethod(dynamicObject, applyBillList);
                                billCenterInvoiceCommonService.dealCheckMoreThan30Method(applyBillList);
                                this.dealAmountIsNullMethod(dynamicObject, paramContent, billno, applyBillList);
                                ArrayList<BillVo> arrayList = applyBillList;
                                return arrayList;
                            }
                            if ("-1".equals(push_status)) {
                                String result = this.doGetDataService(frontSystemObject, paramContent, accessToken);
                                this.dealCommonLogicMethod(systemCode, billNoParam, paramContent, result, applyBillList);
                            }
                            break block42;
                        }
                        String tipMsg = String.format(ResManager.loadKDString((String)"\u6839\u636e\u7cfb\u7edf\u7f16\u7801\uff1a%1$s\uff0c\u65e0\u6cd5\u5339\u914d\u5230\u7cfb\u7edf\u914d\u7f6e\u6570\u636e\uff01", (String)"HeroGourmetSysDataImpl_4", (String)"imc-sim-service", (Object[])new Object[0]), systemCode);
                        throw new KDBizException(tipMsg);
                    }
                    catch (Exception e) {
                        String errorMsg = e.getMessage();
                        logger.error("\u83b7\u53d6Hero\u3001Gourmet\u7cfb\u7edf\u7684\u5f85\u7533\u8bf7\u5f00\u7968\u6570\u636e\uff0c\u51fa\u73b0\u5f02\u5e38:{}", (Object)errorMsg);
                        BillErrorVo billErrorVo = new BillErrorVo();
                        billErrorVo.setErrorMsg(errorMsg);
                        billErrorVo.setFailNum(1);
                        applyBillList.add((BillVo)billErrorVo);
                    }
                    finally {
                        lock.unlock();
                    }
                }
                ArrayList<BillVo> e = applyBillList;
                return e;
            }
            String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u6b63\u5728\u626b\u7801\u62c9\u5355\u5904\u7406\uff0c\u8bf7\u7a0d\u5019\u91cd\u8bd5!", (String)"GalaSysDataImpl_5", (String)"imc-sim-service", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
    }

    private void dealCommonLogicMethod(String systemCode, String billNoParam, String paramContent, String result, List<BillVo> applyBillList) {
        this.dealSaveInterfaceLogDataByType(systemCode, "1", billNoParam, paramContent, result);
        this.dealCreateBillCenterDataMethod(result, systemCode, paramContent, applyBillList);
        this.dealUpdateIncludeTaxMethod(systemCode, paramContent);
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        boolean flag = billCenterInvoiceCommonService.dealCheckAppOpKeyMethod(paramContent);
        if (flag) {
            billCenterInvoiceCommonService.dealCheckMoreThan30Method(applyBillList);
        }
    }

    private void dealUpdateIncludeTaxMethod(String systemCode, String paramContent) {
        String billNo = this.getBillNoParamMethod(paramContent);
        logger.info("dealUpdateIncludeTaxMethod, billNo:{}, systemSource:{}", (Object)billNo, (Object)systemCode);
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        QFilter qFilter = new QFilter("billno", "=", (Object)billNo).and("system_code", "=", (Object)systemCode);
        DynamicObject dynamicObject = billCenterInvoiceCommonService.dealLoadIsomerismBillDataMethod(qFilter);
        if (dynamicObject != null) {
            dynamicObject.set("hsbz", (Object)"1");
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }

    private String dealCheckNoPullBillDataMethod(String systemCode, String paramContent) {
        QFilter qFilter = new QFilter("number", "=", (Object)systemCode);
        DynamicObject simClassMappingCfg = SimClassMappingService.getInterfaceByCondition((QFilter)qFilter);
        if (simClassMappingCfg != null) {
            Date limitDate = simClassMappingCfg.getDate("limit_date");
            if (limitDate == null) {
                return null;
            }
            String businessDate = this.getBusinessDateMethod(paramContent);
            Date business_date = DateUtils.stringToDate((String)businessDate);
            logger.info("HeroGourmetSysDataImpl, limitDate:{}, business_date:{}", (Object)limitDate, (Object)business_date);
            if (business_date.compareTo(limitDate) <= 0) {
                String errorMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u65e5\u671f:%1$s\u524d\u7684\uff0c\u4e3a\u907f\u514d\u91cd\u590d\u5f00\u7968\uff0c\u4e0d\u5141\u8bb8\u62c9\u53d6\u6570\u636e\uff01", (String)"HeroGourmetSysDataImpl_1", (String)"imc-sim-service", (Object[])new Object[0]), DateUtils.format((Date)limitDate));
                return errorMsg;
            }
        }
        return null;
    }

    private String getBillNoParamMethod(String paramContent) {
        JSONObject paramObject = JSONObject.parseObject((String)paramContent);
        String checkNumber = paramObject.getString("checkNumber");
        String location = paramObject.getString("location");
        String businessDate = paramObject.getString("businessDate");
        String errorMsg = ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5\uff01", (String)"HeroGourmetSysDataImpl_5", (String)"imc-sim-service", (Object[])new Object[0]);
        if (StringUtils.isEmpty((CharSequence)checkNumber) || StringUtils.isEmpty((CharSequence)location) || StringUtils.isEmpty((CharSequence)businessDate)) {
            throw new KDBizException(errorMsg);
        }
        if ("null".equals(checkNumber) || "null".equals(location) || "null".equals(businessDate)) {
            throw new KDBizException(errorMsg);
        }
        if ("NULL".equals(checkNumber) || "NULL".equals(location) || "NULL".equals(businessDate)) {
            throw new KDBizException(errorMsg);
        }
        String billNo = checkNumber + "_" + location + "_" + businessDate;
        logger.info("getBillNoParamMethod, billNo:{}", (Object)billNo);
        return billNo;
    }

    private String getLocationParamMethod(String paramContent) {
        JSONObject paramObject = JSONObject.parseObject((String)paramContent);
        String location = paramObject.getString("location");
        return location;
    }

    private String getBusinessDateMethod(String paramContent) {
        JSONObject paramObject = JSONObject.parseObject((String)paramContent);
        String businessDate = paramObject.getString("businessDate");
        return businessDate;
    }

    private void dealCreateBillCenterDataMethod(String result, String systemCode, String paramContent, List<BillVo> applyBillList) {
        HeroGourmetOrderVO heroGourmetOrderVO = this.getHeroGourmetOrderVoMethod(result);
        boolean flag = false;
        String billNo = this.getBillNoParamMethod(paramContent);
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        logger.info("dealCreateBillCenterDataMethod, billNo:{}, systemSource:{}", (Object)billNo, (Object)systemCode);
        QFilter qFilter = new QFilter("billno", "=", (Object)billNo).and("system_code", "=", (Object)systemCode);
        DynamicObject dynamicObject = billCenterInvoiceCommonService.dealLoadIsomerismBillDataMethod(qFilter);
        if (dynamicObject == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"sim_isomerism_bill_data");
        } else {
            flag = true;
        }
        logger.info("dealCreateBillCenterDataMethod, HeroGourmetSysDataImpl, flag:{}", (Object)flag);
        this.dealCreateBillHeaderDataMethod(dynamicObject, billNo, systemCode, paramContent, heroGourmetOrderVO);
        this.dealCreateBillItemDataMethod(dynamicObject, paramContent, systemCode, heroGourmetOrderVO);
        this.dealCreateBillPayDataMethod(dynamicObject, heroGourmetOrderVO, systemCode);
        this.dealCountBillAmountMethod(dynamicObject);
        billCenterInvoiceCommonService.dealSetNoCanOpenInvoiceMethod(dynamicObject);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        if (applyBillList != null) {
            billCenterInvoiceCommonService.dealFormatBillDataMethod(dynamicObject, applyBillList);
            this.dealAmountIsNullMethod(dynamicObject, paramContent, billNo, applyBillList);
        }
    }

    private void dealAmountIsNullMethod(DynamicObject dynamicObject, String paramContent, String billNo, List<BillVo> applyBillList) {
        boolean opKey;
        BigDecimal invoicable_amount = dynamicObject.getBigDecimal("invoicable_amount");
        logger.info("dealAmountIsNullMethod, billNo:{},invoicable_amount:{}", (Object)billNo, (Object)invoicable_amount);
        boolean amountIsNull = false;
        if (invoicable_amount == null || invoicable_amount.compareTo(BigDecimal.ZERO) == 0) {
            amountIsNull = true;
        }
        if (opKey = this.dealCheckOpKeyMethod(paramContent)) {
            if (amountIsNull) {
                BillWarnVo billErrorVo = new BillWarnVo();
                String warnMsg = ResManager.loadKDString((String)"\u5f53\u524d\u8ba2\u5355\u53ef\u5f00\u7968\u7684\u91d1\u989d\u4e3a0\uff01", (String)"HeroGourmetSysDataImpl_6", (String)"imc-sim-service", (Object[])new Object[0]);
                billErrorVo.setWarnMsg(warnMsg);
                billErrorVo.setWarnNum(1);
                applyBillList.add((BillVo)billErrorVo);
            }
        } else if (amountIsNull) {
            BillErrorVo billErrorVo = new BillErrorVo();
            String tipMsg = ResManager.loadKDString((String)"\u5f53\u524d\u8ba2\u5355\u53ef\u5f00\u7968\u7684\u91d1\u989d\u4e3a0\uff01", (String)"HeroGourmetSysDataImpl_6", (String)"imc-sim-service", (Object[])new Object[0]);
            billErrorVo.setErrorMsg(tipMsg);
            billErrorVo.setFailNum(1);
            applyBillList.add((BillVo)billErrorVo);
        }
    }

    private boolean dealCheckOpKeyMethod(String paramContent) {
        JSONObject jsonObject = JSONObject.parseObject((String)paramContent);
        String opKey = jsonObject.getString("opKey");
        return "PC".equals(opKey);
    }

    private void dealCountBillAmountMethod(DynamicObject dynamicObject) {
        BigDecimal totalAmount = this.dealCountCanItemAmountMethod(dynamicObject);
        BigDecimal canPayAmount = this.dealCountCanPayAmountMethod(dynamicObject);
        BigDecimal canItemAmount = this.dealCountCanItemAmountMethod(dynamicObject);
        BigDecimal canShareAmount = this.dealComparedAmountMethod(canPayAmount, canItemAmount);
        logger.info("dealCountBillAmountMethod, totalAmount:{}, canPayAmount:{}, canItemAmount:{}, canShareAmount:{}", new Object[]{totalAmount, canPayAmount, canItemAmount, canShareAmount});
        this.dealUpdateOpenInvoiceAmount(dynamicObject, canShareAmount);
        if (canShareAmount.compareTo(BigDecimal.ZERO) == 0) {
            logger.error("\u4e0d\u6ee1\u8db3\u91d1\u989d\u5206\u644a\u7684\u5904\u7406\uff0c\u53ef\u5f00\u7968\u91d1\u989d\u4e3a0\uff01");
            return;
        }
        if (canShareAmount.compareTo(canItemAmount) == 0) {
            logger.error("\u53ef\u5f00\u7968\u91d1\u989d\u4e0e\u53ef\u660e\u7ec6\u9879\u91d1\u989d\u76f8\u7b49\uff0c\u4e0d\u7528\u5206\u644a\u5904\u7406\uff01");
            this.dealSetAvgAmountMethod(dynamicObject);
            return;
        }
        ArrayList<DynamicObject> itemObjectList = new ArrayList<DynamicObject>();
        DynamicObjectCollection billItemCollection = dynamicObject.getDynamicObjectCollection("sim_isomerism_item_data");
        for (DynamicObject billItemObject : billItemCollection) {
            BigDecimal productAmount = billItemObject.getBigDecimal("product_amount");
            String invoicable_switch = billItemObject.getString("invoicable_switch");
            if ("0".equals(invoicable_switch) || productAmount == null || productAmount.compareTo(BigDecimal.ZERO) == 0) continue;
            String productCode = billItemObject.getString("product_code");
            BigDecimal avgAmount = this.countShareAmountMethod(totalAmount, canShareAmount, productAmount);
            logger.info("dealCountBillAmountMethod, productCode:{}, productAmount:{}, avgAmount:{}", new Object[]{productCode, productAmount, avgAmount});
            billItemObject.set("avg_amount", (Object)avgAmount);
            billItemObject.set("unpushamount", (Object)avgAmount);
            BigDecimal taxRate = billItemObject.getBigDecimal("tax_rate");
            BigDecimal taxAmount = TaxCalcUtil.calTax((BigDecimal)new BigDecimal(avgAmount.toString()), (BigDecimal)BigDecimal.ZERO, (String)taxRate.toString(), (boolean)true);
            billItemObject.set("tax_amount", (Object)taxAmount);
            billItemObject.set("unpushtax", (Object)taxAmount);
            itemObjectList.add(billItemObject);
        }
        this.dealTailDifferenceAmountMethod(itemObjectList, canShareAmount);
    }

    private BigDecimal dealComparedAmountMethod(BigDecimal canPayAmount, BigDecimal canItemAmount) {
        BigDecimal canShareAmount = canPayAmount.compareTo(canItemAmount) >= 0 ? canItemAmount : canPayAmount;
        return canShareAmount;
    }

    private BigDecimal dealCountCanItemAmountMethod(DynamicObject dynamicObject) {
        BigDecimal canItemAmount = new BigDecimal("0.00");
        DynamicObjectCollection itemDataCollection = dynamicObject.getDynamicObjectCollection("sim_isomerism_item_data");
        for (DynamicObject itemDataObject : itemDataCollection) {
            String invoicable_switch = itemDataObject.getString("invoicable_switch");
            BigDecimal product_amount = itemDataObject.getBigDecimal("product_amount");
            if (!"1".equals(invoicable_switch)) continue;
            canItemAmount = canItemAmount.add(product_amount);
        }
        return canItemAmount;
    }

    private BigDecimal dealCountCanPayAmountMethod(DynamicObject dynamicObject) {
        BigDecimal canPayAmount = new BigDecimal("0.00");
        DynamicObjectCollection payDataCollection = dynamicObject.getDynamicObjectCollection("sim_isomerism_pay_data");
        for (DynamicObject payDataObject : payDataCollection) {
            String is_invoiced = payDataObject.getString("is_invoiced");
            BigDecimal pay_amount = payDataObject.getBigDecimal("pay_amount");
            if (!"1".equals(is_invoiced)) continue;
            canPayAmount = canPayAmount.add(pay_amount);
        }
        return canPayAmount;
    }

    private void dealUpdateOpenInvoiceAmount(DynamicObject dynamicObject, BigDecimal canShareAmount) {
        dynamicObject.set("invoicable_amount", (Object)canShareAmount);
        dynamicObject.set("remain_amount", (Object)canShareAmount);
    }

    private void dealSetAvgAmountMethod(DynamicObject dynamicObject) {
        DynamicObjectCollection billItemCollection = dynamicObject.getDynamicObjectCollection("sim_isomerism_item_data");
        for (DynamicObject billItemObject : billItemCollection) {
            BigDecimal productAmount = billItemObject.getBigDecimal("product_amount");
            billItemObject.set("avg_amount", (Object)productAmount);
        }
    }

    private void dealTailDifferenceAmountMethod(List<DynamicObject> itemObjectList, BigDecimal disTotalAmount) {
        BigDecimal sumAmount = new BigDecimal("0.00");
        for (int i = 0; i < itemObjectList.size() - 1; ++i) {
            DynamicObject dynamicObject = itemObjectList.get(i);
            BigDecimal openInvoiceAmount = dynamicObject.getBigDecimal("avg_amount");
            sumAmount = sumAmount.add(openInvoiceAmount);
        }
        BigDecimal lastBillAmount = itemObjectList.get(itemObjectList.size() - 1).getBigDecimal("avg_amount");
        BigDecimal disAmount = disTotalAmount.subtract(sumAmount);
        logger.info("dealShareItemOpenAmountMethod, lastBillAmount:{}, disAmount:{}", (Object)lastBillAmount, (Object)disAmount);
        if (lastBillAmount.compareTo(disAmount) != 0) {
            DynamicObject lastBillObject = itemObjectList.get(itemObjectList.size() - 1);
            lastBillObject.set("avg_amount", (Object)disAmount);
            lastBillObject.set("unpushamount", (Object)disAmount);
            BigDecimal taxRate = lastBillObject.getBigDecimal("tax_rate");
            BigDecimal taxAmount = TaxCalcUtil.calTax((BigDecimal)new BigDecimal(disAmount.toString()), (BigDecimal)BigDecimal.ZERO, (String)taxRate.toString(), (boolean)true);
            lastBillObject.set("tax_amount", (Object)taxAmount);
            lastBillObject.set("unpushtax", (Object)taxAmount);
        }
    }

    private BigDecimal countShareAmountMethod(BigDecimal billTotalAmount, BigDecimal canShareAmount, BigDecimal productAmount) {
        logger.info("countShareAmountMethod, productAmount:{}, billTotalAmount:{}, canShareAmount:{}", new Object[]{productAmount, billTotalAmount, canShareAmount});
        double product_amount = productAmount.doubleValue();
        double bill_total_amount = billTotalAmount.doubleValue();
        double can_share_amount = canShareAmount.doubleValue();
        double avg_amount = product_amount / bill_total_amount * can_share_amount;
        BigDecimal avgAmount = BigDecimal.valueOf(avg_amount).setScale(2, 4);
        return avgAmount;
    }

    private void dealCreateBillPayDataMethod(DynamicObject dynamicObject, HeroGourmetOrderVO heroGourmetOrderVO, String systemCode) {
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("sim_isomerism_pay_data");
        if (dynamicObjectCollection == null) {
            String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u5355\u4e2d\u5fc3\u652f\u4ed8\u660e\u7ec6\u533a\u5143\u6570\u636e\u4e0d\u5b58\u5728\uff01", (String)"HeroGourmetSysDataImpl_9", (String)"imc-sim-service", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        if (dynamicObjectCollection.size() > 0) {
            dynamicObjectCollection.clear();
        }
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        List<HeroGourmetPaymentVO> payments = heroGourmetOrderVO.getPayments();
        for (HeroGourmetPaymentVO heroGourmetPaymentVO : payments) {
            DynamicObject payObject = dynamicObjectCollection.addNew();
            String paymentMethod = heroGourmetPaymentVO.getCode();
            payObject.set("pay_code", (Object)paymentMethod);
            payObject.set("pay_amount", (Object)heroGourmetPaymentVO.getAmount());
            payObject.set("pay_name", (Object)heroGourmetPaymentVO.getName());
            DynamicObject paymentObject = billCenterInvoiceCommonService.getPaymentObjectMethod(paymentMethod, null, systemCode);
            if (paymentObject != null) {
                payObject.set("pay_desc", (Object)paymentObject.getString("name"));
                String is_invoiced = paymentObject.getString("invoicable");
                if (StringUtils.isEmpty((CharSequence)is_invoiced)) {
                    String errorMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u652f\u4ed8\u7f16\u7801\uff1a%1$s\uff0c\u5bf9\u5e94\u7684\u652f\u4ed8\u65b9\u5f0f\u662f\u5426\u5f00\u7968\u5b57\u6bb5\u5c5e\u6027\u4e3a\u7a7a\uff01", (String)"HeroGourmetSysDataImpl_10", (String)"imc-sim-service", (Object[])new Object[0]), paymentMethod);
                    throw new KDBizException(errorMsg);
                }
                payObject.set("is_invoiced", (Object)is_invoiced);
                continue;
            }
            String errorMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u652f\u4ed8\u7f16\u7801\uff1a%1$s\uff0c\u672a\u5339\u914d\u5230\u652f\u4ed8\u65b9\u5f0f\u914d\u7f6e\u6570\u636e\uff01", (String)"HeroGourmetSysDataImpl_11", (String)"imc-sim-service", (Object[])new Object[0]), paymentMethod);
            throw new KDBizException(errorMsg);
        }
    }

    private void dealCreateBillItemDataMethod(DynamicObject dynamicObject, String paramContent, String systemCode, HeroGourmetOrderVO heroGourmetOrderVO) {
        String sourceOrgCode;
        logger.info("dealCreateBillItemDataMethod, paramContent:{}", (Object)paramContent);
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("sim_isomerism_item_data");
        if (dynamicObjectCollection == null) {
            String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u5355\u4e2d\u5fc3\u5546\u54c1\u660e\u7ec6\u533a\u5143\u6570\u636e\u4e0d\u5b58\u5728\uff01", (String)"HeroGourmetSysDataImpl_12", (String)"imc-sim-service", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        if (dynamicObjectCollection.size() > 0) {
            dynamicObjectCollection.clear();
        }
        List<HeroGourmetItemsVO> items = heroGourmetOrderVO.getItems();
        int row = 1;
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        for (HeroGourmetItemsVO heroGourmetItemsVO : items) {
            DynamicObject itemObject = dynamicObjectCollection.addNew();
            itemObject.set("product_id", (Object)row);
            itemObject.set("product_name", (Object)heroGourmetItemsVO.getName());
            HeroGourmetDepartmentVO departmentObject = heroGourmetItemsVO.getDepartment();
            if (departmentObject == null) {
                String errorMsg = ResManager.loadKDString((String)"\u4ea7\u54c1\u5927\u7c7b\u5bf9\u8c61\u4e3a\u7a7a\uff01", (String)"HeroGourmetSysDataImpl_13", (String)"imc-sim-service", (Object[])new Object[0]);
                throw new KDBizException(errorMsg);
            }
            sourceOrgCode = this.getLocationParamMethod(paramContent);
            String productType = departmentObject.getCode();
            String productCode = productType + "-" + sourceOrgCode;
            itemObject.set("product_code", (Object)productCode);
            itemObject.set("product_type", (Object)productCode);
            String quantity = heroGourmetItemsVO.getQty();
            BigDecimal productNum = StringUtils.isEmpty((CharSequence)quantity) ? BigDecimal.ZERO : new BigDecimal(quantity);
            itemObject.set("product_quantity", (Object)productNum);
            String total = heroGourmetItemsVO.getTotal();
            BigDecimal productAmount = StringUtils.isEmpty((CharSequence)total) ? BigDecimal.ZERO : new BigDecimal(total);
            itemObject.set("product_amount", (Object)productAmount);
            String unitPrice = heroGourmetItemsVO.getUnitPrice();
            BigDecimal price = StringUtils.isEmpty((CharSequence)unitPrice) ? new BigDecimal(productAmount.toString()).divide(new BigDecimal(quantity)).setScale(2, 4) : new BigDecimal(unitPrice);
            itemObject.set("product_price", (Object)price);
            itemObject.set("avg_amount", (Object)BigDecimal.ZERO);
            logger.info("dealCreateBillItemDataMethod, systemCode:{}, sourceOrgCode:{}", (Object)systemCode, (Object)sourceOrgCode);
            QFilter qFilter = new QFilter("system_code", "=", (Object)systemCode).and("number", "=", (Object)sourceOrgCode);
            DynamicObject orgObject = billCenterInvoiceCommonService.getOrgMethod(qFilter);
            if (orgObject == null) {
                String errorMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u9152\u9910\u4ee3\u7801\uff1a%1$s\uff0c\u672a\u5339\u914d\u5230\u76f8\u5173\u7684\u53d1\u7968\u4e91\u7ec4\u7ec7\u6570\u636e\uff01", (String)"HeroGourmetSysDataImpl_8", (String)"imc-sim-service", (Object[])new Object[0]), sourceOrgCode);
                throw new KDBizException(errorMsg);
            }
            logger.info("dealCreateBillItemDataMethod, \u5339\u914d\u5230\u7684\u7ec4\u7ec7\u5bf9\u8c61\u662f:{}", (Object)orgObject);
            itemObject.set("orgid", (Object)orgObject);
            this.dealHeroGourmetDimensionMethod(productCode, orgObject, itemObject);
            BigDecimal taxRate = itemObject.getBigDecimal("tax_rate");
            BigDecimal taxAmount = TaxCalcUtil.calTax((BigDecimal)new BigDecimal(productAmount.toString()), (BigDecimal)BigDecimal.ZERO, (String)taxRate.toString(), (boolean)true);
            itemObject.set("tax_amount", (Object)taxAmount);
            String consumeTime = this.getBusinessDateMethod(paramContent) + "\\u0020" + heroGourmetOrderVO.getCloseTime();
            itemObject.set("consume_time", (Object)DateUtils.stringToDate((String)consumeTime));
            itemObject.set("folio_no", null);
            itemObject.set("tc_group", null);
            itemObject.set("sub_order_no", (Object)sourceOrgCode);
            itemObject.set("unpushamount", (Object)productAmount);
            itemObject.set("unpushtax", (Object)taxAmount);
            itemObject.set("unpushnum", (Object)quantity);
            itemObject.set("rowpushstatus", (Object)"-1");
            if (productAmount.compareTo(BigDecimal.ZERO) == 0) {
                itemObject.set("invoicable_switch", (Object)"0");
                itemObject.set("rowpushstatus", (Object)"1");
            }
            this.dealSetItemOpenInvoiceTypeMethod(itemObject, systemCode, productCode, orgObject.getLong("id"));
            itemObject.set("apply_no", (Object)systemCode);
            ++row;
        }
        logger.info("\u6267\u884c\u4e2dHero\u3001Gourmet\u6d88\u8d39\u660e\u7ec6\u96c6\u5408\u5927\u5c0f\u662f:{}", (Object)dynamicObjectCollection.size());
        row = dynamicObjectCollection.size() + 1;
        List<HeroGourmetServiceChargeVO> serviceChargeList = heroGourmetOrderVO.getServiceCharge();
        for (HeroGourmetServiceChargeVO serviceChargeVO : serviceChargeList) {
            DynamicObject itemObject = dynamicObjectCollection.addNew();
            itemObject.set("product_id", (Object)row);
            itemObject.set("product_name", (Object)serviceChargeVO.getCode());
            sourceOrgCode = this.getLocationParamMethod(paramContent);
            String productCode = serviceChargeVO.getCode() + "-" + sourceOrgCode;
            itemObject.set("product_code", (Object)productCode);
            itemObject.set("product_type", (Object)productCode);
            BigDecimal productNum = BigDecimal.ONE;
            itemObject.set("product_quantity", (Object)productNum);
            String total = serviceChargeVO.getAmount();
            BigDecimal productAmount = StringUtils.isEmpty((CharSequence)total) ? BigDecimal.ZERO : new BigDecimal(total);
            itemObject.set("product_amount", (Object)productAmount);
            String unitPrice = serviceChargeVO.getAmount();
            BigDecimal price = StringUtils.isEmpty((CharSequence)unitPrice) ? new BigDecimal(productAmount.toString()).divide(productNum).setScale(2, 4) : new BigDecimal(unitPrice);
            itemObject.set("product_price", (Object)price);
            itemObject.set("avg_amount", (Object)BigDecimal.ZERO);
            logger.info("dealCreateBillChargeDataMethod, systemCode:{}, sourceOrgCode:{}", (Object)systemCode, (Object)sourceOrgCode);
            QFilter qFilter = new QFilter("system_code", "=", (Object)systemCode).and("number", "=", (Object)sourceOrgCode);
            DynamicObject orgObject = billCenterInvoiceCommonService.getOrgMethod(qFilter);
            if (orgObject == null) {
                String errorMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u9152\u9910\u4ee3\u7801\uff1a%1$s\uff0c\u672a\u5339\u914d\u5230\u76f8\u5173\u7684\u53d1\u7968\u4e91\u7ec4\u7ec7\u6570\u636e\uff01", (String)"HeroGourmetSysDataImpl_8", (String)"imc-sim-service", (Object[])new Object[0]), sourceOrgCode);
                throw new KDBizException(errorMsg);
            }
            logger.info("dealCreateBillChargeDataMethod, \u5339\u914d\u5230\u7684\u7ec4\u7ec7\u5bf9\u8c61\u662f:{}", (Object)orgObject);
            itemObject.set("orgid", (Object)orgObject);
            this.dealHeroGourmetDimensionMethod(productCode, orgObject, itemObject);
            BigDecimal taxRate = itemObject.getBigDecimal("tax_rate");
            BigDecimal taxAmount = TaxCalcUtil.calTax((BigDecimal)new BigDecimal(productAmount.toString()), (BigDecimal)BigDecimal.ZERO, (String)taxRate.toString(), (boolean)true);
            itemObject.set("tax_amount", (Object)taxAmount);
            if (productAmount.compareTo(BigDecimal.ZERO) == 0) {
                itemObject.set("invoicable_switch", (Object)"0");
            }
            String consumeTime = this.getBusinessDateMethod(paramContent) + "\\u0020" + heroGourmetOrderVO.getCloseTime();
            itemObject.set("consume_time", (Object)DateUtils.stringToDate((String)consumeTime));
            itemObject.set("folio_no", null);
            itemObject.set("tc_group", null);
            itemObject.set("sub_order_no", (Object)sourceOrgCode);
            itemObject.set("unpushamount", (Object)productAmount);
            itemObject.set("unpushtax", (Object)taxAmount);
            itemObject.set("unpushnum", (Object)productNum);
            itemObject.set("rowpushstatus", (Object)"-1");
            if (productAmount.compareTo(BigDecimal.ZERO) == 0) {
                itemObject.set("invoicable_switch", (Object)"0");
                itemObject.set("rowpushstatus", (Object)"1");
            }
            this.dealSetItemOpenInvoiceTypeMethod(itemObject, systemCode, productCode, orgObject.getLong("id"));
            itemObject.set("apply_no", (Object)systemCode);
            ++row;
        }
        logger.info("\u6267\u884c\u5b8c\u6210Hero\u3001Gourmet\u6d88\u8d39\u660e\u7ec6\u96c6\u5408\u5927\u5c0f\u662f:{}", (Object)dynamicObjectCollection.size());
    }

    private void dealSetItemOpenInvoiceTypeMethod(DynamicObject itemObject, String systemCode, String productCode, long orgId) {
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        DynamicObject specialInvoiceObject = billCenterInvoiceCommonService.dealGetSpecialInvoiceMethod(systemCode, orgId, productCode, null);
        if (specialInvoiceObject == null) {
            itemObject.set("openinvoicetype", (Object)"02");
        } else {
            String is_special_invoice = specialInvoiceObject.getString("is_special_invoice");
            if (StringUtils.isBlank((CharSequence)is_special_invoice) || "0".equals(is_special_invoice)) {
                itemObject.set("openinvoicetype", (Object)"02");
            } else {
                itemObject.set("openinvoicetype", (Object)"01");
            }
        }
    }

    private void dealHeroGourmetDimensionMethod(String productCode, DynamicObject orgObject, DynamicObject itemObject) {
        Long orgId = orgObject.getLong("id");
        logger.info("dealHeroGourmetDimensionMethod, orgid:{}, productCode:{}", (Object)orgId, (Object)productCode);
        QFilter orgFilter = ImcBaseDataHelper.getGoodsInfoFilter((Object)orgId);
        QFilter qFilter2 = new QFilter("number", "=", (Object)productCode).and("enable", "=", (Object)"1");
        DynamicObject productObject = BusinessDataServiceHelper.loadSingle((String)"bdm_goods_info", (String)"id", (QFilter[])new QFilter[]{orgFilter, qFilter2});
        if (productObject != null) {
            String taxNo;
            Long pkId = productObject.getLong("id");
            productObject = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"bdm_goods_info");
            String saleFlag = productObject.getString("sale_flag");
            String saleTaxNo = productObject.getString("sale_tax_no");
            if (StringUtils.isEmpty((CharSequence)productObject.getString("taxrate"))) {
                String errorMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4ea7\u54c1\u7f16\u7801\uff1a%1$s\uff0c\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"HeroGourmetSysDataImpl_15", (String)"imc-sim-service", (Object[])new Object[0]), productCode);
                throw new KDBizException(errorMsg);
            }
            itemObject.set("tax_rate", (Object)new BigDecimal(productObject.getString("taxrate")));
            if ("1".equals(saleFlag)) {
                DynamicObject dynamicObject = productObject.getDynamicObject("sale_org");
                if (dynamicObject == null) {
                    String errorMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4ea7\u54c1\u7f16\u7801\uff1a%1$s\uff0c\u672a\u914d\u7f6e\u4ee3\u552e\u7ec4\u7ec7\uff01", (String)"HeroGourmetSysDataImpl_16", (String)"imc-sim-service", (Object[])new Object[0]), productCode);
                    throw new KDBizException(errorMsg);
                }
                orgId = dynamicObject.getLong("id");
            }
            if ("1".equals(productObject.getString("isopeninvoice"))) {
                itemObject.set("invoicable_switch", (Object)"1");
            } else {
                itemObject.set("invoicable_switch", (Object)"0");
            }
            if (StringUtils.isNotEmpty((CharSequence)saleTaxNo)) {
                taxNo = saleTaxNo;
            } else {
                Long orgId2 = orgObject.getLong("id");
                taxNo = TaxUtils.getEnterpriseDynamicObjectByOrg((Long)orgId2).getString("number");
            }
            itemObject.set("orgid", (Object)orgId);
            itemObject.set("tax_no", (Object)taxNo);
            itemObject.set("splitkey", (Object)taxNo);
            itemObject.set("specification", (Object)productObject.getString("specifications"));
            itemObject.set("product_unit", (Object)productObject.getString("unit"));
            DynamicObject taxCodeObject = productObject.getDynamicObject("taxcode");
            if (taxCodeObject != null) {
                itemObject.set("tax_code", (Object)taxCodeObject.getString("number"));
            } else {
                itemObject.set("tax_code", null);
            }
        } else {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4ea7\u54c1\u7f16\u7801\uff1a%1$s\uff0c\u672a\u5339\u914d\u5230\u5bf9\u5e94\u5f00\u7968\u9879\u6570\u636e\uff01", (String)"HeroGourmetSysDataImpl_17", (String)"imc-sim-service", (Object[])new Object[0]), productCode);
            throw new KDBizException(errorMsg);
        }
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        DynamicObject itemTypeObject = billCenterInvoiceCommonService.getBillCenterItemType(productObject);
        itemObject.set("itemtype", (Object)itemTypeObject);
    }

    private void dealCreateBillHeaderDataMethod(DynamicObject dynamicObject, String billNo, String systemCode, String paramContent, HeroGourmetOrderVO heroGourmetOrderVO) {
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        dynamicObject.set("billno", (Object)billNo);
        dynamicObject.set("bill_json_data", (Object)paramContent);
        dynamicObject.set("billstatus", (Object)"C");
        dynamicObject.set("pushstatus", (Object)"-1");
        dynamicObject.set("system_code", (Object)systemCode);
        String systemName = billCenterInvoiceCommonService.getSystemNameMethod(systemCode);
        logger.info("dealCreateBillHeaderDataMethod, systemName:{}, systemCode:{}", (Object)systemName, (Object)systemCode);
        dynamicObject.set("system_name", (Object)systemName);
        BillCenterOrgMappingService billCenterOrgMappingService = new BillCenterOrgMappingService();
        DynamicObject frontSystemObject = billCenterOrgMappingService.loadSingleBySystemCode(systemCode);
        dynamicObject.set("system", (Object)frontSystemObject);
        String orgCode = this.getLocationParamMethod(paramContent);
        logger.info("dealCreateBillHeaderDataMethod, orgCode:{}", (Object)orgCode);
        dynamicObject.set("org_code", (Object)orgCode);
        String orgName = billCenterInvoiceCommonService.getOrgNameMethod(orgCode, systemCode);
        logger.info("dealCreateBillHeaderDataMethod, orgName:{}", (Object)orgName);
        dynamicObject.set("org_name", (Object)orgName);
        QFilter qFilter = new QFilter("system_code", "=", (Object)systemCode).and("number", "=", (Object)orgCode);
        DynamicObject orgObject = billCenterInvoiceCommonService.getOrgMethod(qFilter);
        if (orgObject != null) {
            logger.info("dealCreateBillHeaderDataMethod, orgId:{}", (Object)orgObject.getLong("id"));
        }
        dynamicObject.set("org", (Object)orgObject);
        dynamicObject.set("custom_name", null);
        dynamicObject.set("bill_create_time", (Object)new Date());
        dynamicObject.set("createtime", (Object)new Date());
        dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        String billDate = this.getBusinessDateMethod(paramContent);
        dynamicObject.set("bill_date", (Object)DateUtils.stringToDate((String)billDate));
        dynamicObject.set("user_phone", null);
        dynamicObject.set("remark", null);
        BigDecimal totalAmount = this.getTotalAmountMethod(heroGourmetOrderVO);
        dynamicObject.set("total_amount", (Object)totalAmount);
        dynamicObject.set("invoicable_amount", (Object)totalAmount);
        dynamicObject.set("invoice_amount", (Object)BigDecimal.ZERO);
        dynamicObject.set("remain_amount", (Object)totalAmount);
        dynamicObject.set("invoice_status", (Object)"0");
        dynamicObject.set("table_no", (Object)heroGourmetOrderVO.getTableNumber());
        dynamicObject.set("open_emp_no", (Object)heroGourmetOrderVO.getOpenEmployeeCode());
        dynamicObject.set("open_emp_name", (Object)heroGourmetOrderVO.getOpenEmployeeName());
        String beginDate = this.getBusinessDateMethod(paramContent) + " " + heroGourmetOrderVO.getOpenTime();
        dynamicObject.set("begin_date", (Object)DateUtils.stringToDate((String)beginDate, (String)"yyyy-MM-dd HH:mm:ss"));
        String endDate = this.getBusinessDateMethod(paramContent) + " " + heroGourmetOrderVO.getCloseTime();
        dynamicObject.set("end_date", (Object)DateUtils.stringToDate((String)endDate, (String)"yyyy-MM-dd HH:mm:ss"));
        dynamicObject.set("hsbz", (Object)"1");
    }

    private BigDecimal getTotalAmountMethod(HeroGourmetOrderVO heroGourmetOrderVO) {
        List<HeroGourmetPaymentVO> paymentList = heroGourmetOrderVO.getPayments();
        BigDecimal paymentAmount = new BigDecimal("0.00");
        for (HeroGourmetPaymentVO heroGourmetPaymentVO : paymentList) {
            String amount = heroGourmetPaymentVO.getAmount();
            if (StringUtils.isEmpty((CharSequence)amount)) continue;
            paymentAmount = paymentAmount.add(new BigDecimal(amount));
        }
        return paymentAmount;
    }

    private String getTestDemo() {
        String result = "{\"tableNumber\":\"0002\",\"tableName\":\"0002\",\"checkNumber\":\"993179\",\"openEmployeeCode\":\"00001\",\"openEmployeeName\":\"00001\",\"openTime\":\"14:45:58\",\"closeTime\":\"14:46:06\",\"voidTime\":\"\",\"serviceChargeTotal\":\"0.00\",\"serviceCharge\":[{\"code\":\"FSERV_TOT1\",\"amount\":\"0.00\"},{\"code\":\"FSERV_TOT2\",\"amount\":\"0.00\"}],\"taxes\":[{\"code\":\"FTAX_TOT1\",\"name\":\"FTAX_TOT1\",\"amount\":\"0.00\"},{\"code\":\"FTAX_TOT2\",\"name\":\"FTAX_TOT2\",\"amount\":\"0.00\"},{\"code\":\"FTAX_TOT3\",\"name\":\"FTAX_TOT3\",\"amount\":\"0.00\"}],\"checkTotal\":\"446.00\",\"items\":[{\"code\":\"5630\",\"name\":\"\u56e2\u8d2d\u5348\u9910/\u5e73\u65e5\",\"qty\":\"1.0\",\"unitPrice\":\"223.00\",\"total\":\"223.00\",\"department\":{\"code\":\"01\",\"name\":\"\u56e2\u8d2d\u5348\u9910/\u5e73\u65e5\"}},{\"code\":\"5630\",\"name\":\"\u56e2\u8d2d\u5348\u9910/\u5e73\u65e5\",\"qty\":\"1.0\",\"unitPrice\":\"223.00\",\"total\":\"223.00\",\"department\":{\"code\":\"01\",\"name\":\"\u56e2\u8d2d\u5348\u9910/\u5e73\u65e5\"}}],\"payments\":[{\"code\":\"105\",\"name\":\"\u73b0\u91d1\u652f\u4ed8\",\"amount\":\"446.00\"}]}";
        return result;
    }

    @Override
    public void dealUpdateOpenInvoiceStatus(DynamicObject dynamicObject, InvoiceVo invoiceVo) {
        if (this.invociceFailCallBack(dynamicObject)) {
            return;
        }
        String billNo = invoiceVo.getBillNo();
        String systemCode = invoiceVo.getSystemSource();
        this.dealCheckDataSourceByDaoKong(billNo, systemCode, invoiceVo);
    }

    private void dealCheckDataSourceByDaoKong(String billNo, String systemCode, InvoiceVo invoiceVo) {
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        DynamicObject billDataObject = billCenterInvoiceCommonService.dealCheckBillCenterDataMethod("billno", billNo, systemCode);
        if (billDataObject == null) {
            logger.error("dealCheckDataSourceByDaoKong, \u8d26\u5355\u7f16\u53f7:{}\uff0c\u7cfb\u7edf\u7f16\u7801:{}, \u672a\u5339\u914d\u5230\u8d26\u5355\u6570\u636e\u3002", (Object)billNo, (Object)systemCode);
            return;
        }
        String daoKongOrderNo = billDataObject.getString("daokong_order_no");
        String daoKongAreaNo = billDataObject.getString("daokong_area_no");
        String daoKongOrderSource = billDataObject.getString("daokong_order_source");
        logger.info("dealCheckDataSourceByDaoKong, daoKongOrderNo:{}, daoKongAreaNo:{}, daoKongOrderSource:{}", new Object[]{daoKongOrderNo, daoKongAreaNo, daoKongOrderSource});
        if (StringUtils.isEmpty((CharSequence)daoKongOrderNo) || StringUtils.isEmpty((CharSequence)daoKongAreaNo) || StringUtils.isEmpty((CharSequence)daoKongOrderSource)) {
            logger.error("dealCheckDataSourceByDaoKong, \u5f53\u524d\u8d26\u5355\u4e0d\u542b\u6709\u9053\u63a7\u8ba2\u5355\u7684\u53c2\u6570\u3002");
            return;
        }
        DaoKongDataImpl externalSystemsDataService = new DaoKongDataImpl();
        QFilter qFilter = new QFilter("invoiceno", "=", (Object)invoiceVo.getInvoiceNum());
        String selectProperties = PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)false);
        DynamicObject invoiceObject = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)selectProperties, (QFilter[])qFilter.toArray());
        externalSystemsDataService.dealUpdateOpenInvoiceStatus(invoiceObject, invoiceVo);
    }

    @Override
    public void dealPushCallBackStatusToFrontSystem(JSONObject paramObject) {
        BillCenterInvoiceLogService billCenterInvoiceLogService = new BillCenterInvoiceLogService();
        if (paramObject.containsKey((Object)"approvalResult")) {
            billCenterInvoiceLogService.dealNoticeApprovalRejectMethod(paramObject);
        } else if (paramObject.containsKey((Object)"approvalProcess")) {
            billCenterInvoiceLogService.dealNoticeApprovalProcessMethod(paramObject);
        } else if (paramObject.containsKey((Object)"approvalSuccess")) {
            billCenterInvoiceLogService.dealNoticeApprovalSuccessMethod(paramObject);
        }
    }

    @Override
    public String dealGetQrCodeMethod(JSONObject paramObject) {
        String baseUrl;
        String billNo = paramObject.getString("billNo");
        String systemCode = paramObject.getString("systemCode");
        logger.info("HeroGourmetSysDataImpl, dealGetQrCodeMethod, billNo:{}, systemCode:{}", (Object)billNo, (Object)systemCode);
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        DynamicObject billCenterDO = billCenterInvoiceCommonService.dealCheckBillCenterDataMethod("billno", billNo, systemCode);
        if (billCenterDO == null) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8ba2\u5355\u53f7\uff1a%1$s\uff0c\u8d26\u5355\u4e2d\u5fc3\u7684\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01", (String)"HeroGourmetSysDataImpl_18", (String)"imc-sim-service", (Object[])new Object[0]), billNo);
            throw new KDBizException(errorMsg);
        }
        BigDecimal remainAmount = billCenterDO.getBigDecimal("remain_amount");
        if (remainAmount == null || remainAmount.compareTo(BigDecimal.ZERO) == 0) {
            String errorMsg = ResManager.loadKDString((String)"\u8ba2\u5355\u5269\u4f59\u53ef\u5f00\u7968\u91d1\u989d\u5c0f\u4e8e\u7b49\u4e8e0\u7684\u60c5\u51b5\uff0c\u4e0d\u80fd\u591f\u751f\u6210\u5c0f\u7968\u7801!", (String)"HeroGourmetSysDataImpl_19", (String)"imc-sim-service", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        String ddh = billCenterDO.getString("bill_json_data");
        logger.info("\u8d26\u5355\u4e2d\u5fc3\u6253\u5370\u7684\u539f\u59cb\u8ba2\u5355\u5185\u5bb9:{}", (Object)ddh);
        String pushStatus = billCenterDO.getString("pushstatus");
        BigDecimal invoiceAmount = billCenterDO.getBigDecimal("invoice_amount");
        if ("1".equals(pushStatus) && remainAmount.compareTo(BigDecimal.ZERO) > 0 && invoiceAmount.compareTo(BigDecimal.ZERO) > 0) {
            String errorMsg = ResManager.loadKDString((String)"\u6b64\u8ba2\u5355\u5df2\u90e8\u5206\u5f00\u7968\uff0c\u4e0d\u80fd\u591f\u751f\u6210\u5c0f\u7968\u7801!", (String)"HeroGourmetSysDataImpl_20", (String)"imc-sim-service", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        ddh = Base64Util.encode((byte[])ddh.getBytes(StandardCharsets.UTF_8));
        logger.info("\u8d26\u5355\u4e2d\u5fc3\u6253\u5370\u7684\u52a0\u5bc6\u8ba2\u5355\u5185\u5bb9:{}", (Object)ddh);
        try {
            baseUrl = (String)ImcConfigUtil.getValue((String)"bdm_ismc_config_move").get("bdm_ismc_config_move_cloud_url");
        }
        catch (Throwable ignore) {
            baseUrl = RequestContext.get().getClientFullContextPath();
        }
        if (StringUtils.isEmpty((CharSequence)baseUrl)) {
            String errorMsg = ResManager.loadKDString((String)"\u6253\u5370\u5c0f\u7968\u7801\u7684\u524d\u7f00\u5730\u5740\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u6253\u5370\uff01", (String)"BillCenterPrint_0", (String)"imc-sim-service", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        baseUrl = baseUrl.substring(0, baseUrl.lastIndexOf("/"));
        return String.format("%s?businessScene=5&billSource=billCenter&sysSource=%s&ddh=%s", baseUrl, systemCode, ddh);
    }

    private void dealSaveInterfaceLogDataByType(String systemCode, String opType, String billNoParam, String paramContent, String result) {
        BillCenterInvoiceLogService billCenterInvoiceLogService = new BillCenterInvoiceLogService();
        billCenterInvoiceLogService.dealSaveInterfaceLogDataByType(systemCode, opType, billNoParam, paramContent, result);
    }

    private HeroGourmetOrderVO getHeroGourmetOrderVoMethod(String result) {
        if (StringUtils.isNotEmpty((CharSequence)result)) {
            List<HeroGourmetPaymentVO> payments;
            HeroGourmetOrderVO heroGourmetOrderVO = (HeroGourmetOrderVO)JSONObject.parseObject((String)result, HeroGourmetOrderVO.class);
            if (heroGourmetOrderVO == null) {
                String errorMsg = ResManager.loadKDString((String)"Hero\u3001Gourmet\u8fd4\u56de\u7684\u5f85\u7533\u8bf7\u5f00\u7968\u8d26\u5355\u6570\u636e\u4e3a\u7a7a\uff01", (String)"HeroGourmetSysDataImpl_21", (String)"imc-sim-service", (Object[])new Object[0]);
                throw new KDBizException(errorMsg);
            }
            HeroGourmetErrorVO heroGourmetErrorVO = heroGourmetOrderVO.getError();
            if (heroGourmetErrorVO != null) {
                String code = heroGourmetErrorVO.getCode();
                String message = heroGourmetErrorVO.getMessage();
                if ("RESERVATION_NOT_FOUND".equals(code)) {
                    throw new KDBizException(message);
                }
            }
            if ((payments = heroGourmetOrderVO.getPayments()) == null || payments.isEmpty()) {
                String errorMsg = ResManager.loadKDString((String)"Hero\u3001Gourmet\u8fd4\u56de\u7684\u5f85\u7533\u8bf7\u5f00\u7968\u4ed8\u6b3e\u6570\u636e\u4e3a\u7a7a\uff01", (String)"HeroGourmetSysDataImpl_22", (String)"imc-sim-service", (Object[])new Object[0]);
                throw new KDBizException(errorMsg);
            }
            return heroGourmetOrderVO;
        }
        String errorMsg = ResManager.loadKDString((String)"Hero\u3001Gourmet\u7cfb\u7edf\u83b7\u53d6\u4e0d\u5230\u76f8\u5173\u7684\u8d26\u5355\u6570\u636e\uff01", (String)"HeroGourmetSysDataImpl_23", (String)"imc-sim-service", (Object[])new Object[0]);
        throw new KDBizException(errorMsg);
    }

    private String doGetDataService(DynamicObject frontSystemObject, String paramContent, String accessToken) throws Exception {
        String systemUrl = frontSystemObject.getString("system_url");
        String systemCode = frontSystemObject.getString("number");
        String realm = "chimelong";
        String requestUrl = systemUrl + "/" + realm + "/api/v1/invoice-external/query-pos-original-bill";
        logger.info("doGetDataService, requestUrl\u503c:{}, accessToken\u503c:{}", (Object)requestUrl, (Object)accessToken);
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Authorization", "Bearer " + accessToken);
        JSONObject paramObject = JSONObject.parseObject((String)paramContent);
        String location = paramObject.getString("location");
        String businessDate = paramObject.getString("businessDate");
        String checkNumber = paramObject.getString("checkNumber");
        String businessSystemName = systemCode + "-CHIMELONG";
        JSONObject bodyParamJson = new JSONObject();
        bodyParamJson.put("location", (Object)location);
        bodyParamJson.put("businessDate", (Object)businessDate);
        bodyParamJson.put("checkNumber", (Object)checkNumber);
        bodyParamJson.put("businessSystemName", (Object)businessSystemName);
        logger.info("HeroGourmetSysDataImpl, doGetDataService, \u53d1\u8d77\u8bf7\u6c42\u53c2\u6570\u662f:{}", (Object)bodyParamJson);
        String result = HttpRequestUtil.post(bodyParamJson, requestUrl, headerMap);
        logger.info("HeroGourmetSysDataImpl, doGetDataService, \u8fd4\u56de\u7ed3\u679c\u5185\u5bb9\u662f:{}", (Object)result);
        return result;
    }

    private String getAccessTokenMethod(DynamicObject frontSystemObject) throws Exception {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        String systemUrl = frontSystemObject.getString("system_url");
        String clientId = frontSystemObject.getString("client_id");
        String clientSecret = frontSystemObject.getString("client_secret");
        String grantType = "client_credentials";
        String realm = "chimelong";
        String requestUrl = systemUrl + "/" + realm + "/api/oauth/token";
        HashMap<String, String> bodyParamsMap = new HashMap<String, String>();
        bodyParamsMap.put("grant_type", grantType);
        bodyParamsMap.put("client_id", clientId);
        bodyParamsMap.put("client_secret", clientSecret);
        logger.info("HeroGourmetSysDataImpl, getAccessTokenMethod, requestUrl:{}, clientId:{}, clientSecret:{}", new Object[]{requestUrl, clientId, clientSecret});
        String accessTokenResult = HttpRequestUtil.post(bodyParamsMap, requestUrl, headerMap, "application/x-www-form-urlencoded");
        logger.info("HeroGourmetSysDataImpl, getAccessTokenMethod, \u54cd\u5e94\u7ed3\u679caccessTokenResult:{}", (Object)accessTokenResult);
        if (StringUtils.isEmpty((CharSequence)accessTokenResult)) {
            String errorMsg = ResManager.loadKDString((String)"\u83b7\u53d6Hero\u3001Gourmet\u7cfb\u7edf\u7684accessToken\u5185\u5bb9\u8fd4\u56de\u4e3a\u7a7a\uff01", (String)"HeroGourmetSysDataImpl_24", (String)"imc-sim-service", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        JSONObject jsonObject = JSONObject.parseObject((String)accessTokenResult);
        return jsonObject.getString("access_token");
    }
}

