/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.billcenter.util;

import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;

public class HttpRequestUtil {
    private String defaultContentEncoding = Charset.defaultCharset().name();

    public String getDefaultContentEncoding() {
        return this.defaultContentEncoding;
    }

    public void setDefaultContentEncoding(String defaultContentEncoding) {
        this.defaultContentEncoding = defaultContentEncoding;
    }

    public static String post(JSONObject json, String url) throws Exception {
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        HttpPost post = new HttpPost(url);
        CloseableHttpResponse response = null;
        InputStream in = null;
        BufferedReader br = null;
        String result = "";
        try {
            String line;
            StringEntity s = new StringEntity(json.toString(), "utf-8");
            s.setContentEncoding("UTF-8");
            s.setContentType("application/json");
            post.setEntity((HttpEntity)s);
            post.setHeader("Content-Type", "application/json;charset=utf-8");
            response = httpclient.execute((HttpUriRequest)post);
            in = response.getEntity().getContent();
            br = new BufferedReader(new InputStreamReader(in, "utf-8"));
            StringBuilder strber = new StringBuilder();
            while ((line = br.readLine()) != null) {
                strber.append(line);
                strber.append('\n');
            }
            result = strber.toString();
            if (response.getStatusLine().getStatusCode() != 200) {
                if (StringUtils.isBlank((CharSequence)result)) {
                    result = "\u670d\u52a1\u5668\u5f02\u5e38";
                }
                throw new Exception(result);
            }
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        finally {
            if (null != br) {
                br.close();
            }
            if (null != br) {
                in.close();
            }
            if (null != response) {
                response.close();
            }
            if (null != httpclient) {
                httpclient.close();
            }
        }
        return result;
    }

    public static String post(JSONObject json, String url, Map<String, String> headerMap) throws Exception {
        SSLConnectionSocketFactory scsf = new SSLConnectionSocketFactory(SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)scsf).build();
        HttpPost post = new HttpPost(url);
        CloseableHttpResponse response = null;
        InputStream in = null;
        BufferedReader br = null;
        String result = "";
        try {
            String line;
            StringEntity s = new StringEntity(json.toString(), "utf-8");
            s.setContentEncoding("UTF-8");
            s.setContentType("application/json");
            post.setEntity((HttpEntity)s);
            post.setHeader("Content-Type", "application/json;charset=utf-8");
            Set<Map.Entry<String, String>> headerEntries = headerMap.entrySet();
            for (Map.Entry<String, String> headerEntry : headerEntries) {
                post.setHeader(headerEntry.getKey(), headerEntry.getValue());
            }
            response = httpclient.execute((HttpUriRequest)post);
            in = response.getEntity().getContent();
            br = new BufferedReader(new InputStreamReader(in, "utf-8"));
            StringBuilder strber = new StringBuilder();
            while ((line = br.readLine()) != null) {
                strber.append(line);
                strber.append('\n');
            }
            result = strber.toString();
            if (response.getStatusLine().getStatusCode() != 200) {
                if (StringUtils.isBlank((CharSequence)result)) {
                    result = "\u670d\u52a1\u5668\u5f02\u5e38";
                }
                throw new Exception(result);
            }
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (in != null) {
                in.close();
            }
            if (response != null) {
                response.close();
            }
            if (httpclient != null) {
                httpclient.close();
            }
        }
        return result;
    }

    public static String post(Map<String, String> map, String url, Map<String, String> headerMap, String contentType) throws Exception {
        SSLConnectionSocketFactory scsf = new SSLConnectionSocketFactory(SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)scsf).build();
        HttpPost post = new HttpPost(url);
        CloseableHttpResponse response = null;
        InputStream in = null;
        BufferedReader br = null;
        String result = "";
        try {
            String line;
            List<NameValuePair> nameValuePairs = HttpRequestUtil.getNameValuePairList(map);
            UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(nameValuePairs, "UTF-8");
            urlEncodedFormEntity.setContentType(contentType);
            post.setEntity((HttpEntity)urlEncodedFormEntity);
            post.setHeader("Content-Type", contentType);
            Set<Map.Entry<String, String>> headerEntries = headerMap.entrySet();
            for (Map.Entry<String, String> headerEntry : headerEntries) {
                post.setHeader(headerEntry.getKey(), headerEntry.getValue());
            }
            response = httpclient.execute((HttpUriRequest)post);
            in = response.getEntity().getContent();
            br = new BufferedReader(new InputStreamReader(in, "utf-8"));
            StringBuilder strber = new StringBuilder();
            while ((line = br.readLine()) != null) {
                strber.append(line);
                strber.append('\n');
            }
            result = strber.toString();
            if (response.getStatusLine().getStatusCode() != 200) {
                if (StringUtils.isBlank((CharSequence)result)) {
                    result = "\u670d\u52a1\u5668\u5f02\u5e38";
                }
                throw new Exception(result);
            }
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (in != null) {
                in.close();
            }
            if (response != null) {
                response.close();
            }
            if (httpclient != null) {
                httpclient.close();
            }
        }
        return result;
    }

    private static List<NameValuePair> getNameValuePairList(Map<String, String> map) {
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>(map.size());
        for (Map.Entry<String, String> entryObject : map.entrySet()) {
            String key = entryObject.getKey();
            String value = entryObject.getValue();
            list.add((NameValuePair)new BasicNameValuePair(key, value));
        }
        return list;
    }

    public static String post(String params, String url, Map<String, String> headerMap) throws Exception {
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        HttpPost post = new HttpPost(url);
        CloseableHttpResponse response = null;
        InputStream in = null;
        BufferedReader br = null;
        String result = "";
        try {
            String line;
            StringEntity s = new StringEntity(params, "utf-8");
            s.setContentEncoding("UTF-8");
            s.setContentType("application/json");
            post.setEntity((HttpEntity)s);
            post.setHeader("Content-Type", "application/json;charset=utf-8");
            Set<Map.Entry<String, String>> headerEntries = headerMap.entrySet();
            for (Map.Entry<String, String> headerEntry : headerEntries) {
                post.setHeader(headerEntry.getKey(), headerEntry.getValue());
            }
            response = httpclient.execute((HttpUriRequest)post);
            in = response.getEntity().getContent();
            br = new BufferedReader(new InputStreamReader(in, "utf-8"));
            StringBuilder strber = new StringBuilder();
            while ((line = br.readLine()) != null) {
                strber.append(line);
                strber.append('\n');
            }
            result = strber.toString();
            if (response.getStatusLine().getStatusCode() != 200) {
                if (StringUtils.isBlank((CharSequence)result)) {
                    result = "\u670d\u52a1\u5668\u5f02\u5e38";
                }
                throw new Exception(result);
            }
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (in != null) {
                in.close();
            }
            if (response != null) {
                response.close();
            }
            if (httpclient != null) {
                httpclient.close();
            }
        }
        return result;
    }

    public static String put(JSONObject json, String url, Map<String, String> headerMap) throws Exception {
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        HttpPut post = new HttpPut(url);
        CloseableHttpResponse response = null;
        InputStream in = null;
        BufferedReader br = null;
        String result = "";
        try {
            String line;
            StringEntity s = new StringEntity(json.toString(), "utf-8");
            s.setContentEncoding("UTF-8");
            s.setContentType("application/json");
            post.setEntity((HttpEntity)s);
            post.setHeader("Content-Type", "application/json;charset=utf-8");
            Set<Map.Entry<String, String>> headerEntries = headerMap.entrySet();
            for (Map.Entry<String, String> headerEntry : headerEntries) {
                post.setHeader(headerEntry.getKey(), headerEntry.getValue());
            }
            response = httpclient.execute((HttpUriRequest)post);
            in = response.getEntity().getContent();
            br = new BufferedReader(new InputStreamReader(in, "utf-8"));
            StringBuilder strber = new StringBuilder();
            while ((line = br.readLine()) != null) {
                strber.append(line);
                strber.append('\n');
            }
            result = strber.toString();
            if (response.getStatusLine().getStatusCode() != 200) {
                if (StringUtils.isBlank((CharSequence)result)) {
                    result = "\u670d\u52a1\u5668\u5f02\u5e38";
                }
                throw new Exception(result);
            }
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (in != null) {
                in.close();
            }
            if (response != null) {
                response.close();
            }
            if (httpclient != null) {
                httpclient.close();
            }
        }
        return result;
    }

    public static String delete(String url, Map<String, String> headerMap) throws Exception {
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        HttpDelete post = new HttpDelete(url);
        CloseableHttpResponse response = null;
        InputStream in = null;
        BufferedReader br = null;
        String result = "";
        try {
            String line;
            post.setHeader("Content-Type", "application/json;charset=utf-8");
            Set<Map.Entry<String, String>> headerEntries = headerMap.entrySet();
            for (Map.Entry<String, String> headerEntry : headerEntries) {
                post.setHeader(headerEntry.getKey(), headerEntry.getValue());
            }
            response = httpclient.execute((HttpUriRequest)post);
            in = response.getEntity().getContent();
            br = new BufferedReader(new InputStreamReader(in, "utf-8"));
            StringBuilder strber = new StringBuilder();
            while ((line = br.readLine()) != null) {
                strber.append(line);
                strber.append('\n');
            }
            result = strber.toString();
            if (response.getStatusLine().getStatusCode() != 200) {
                if (StringUtils.isBlank((CharSequence)result)) {
                    result = "\u670d\u52a1\u5668\u5f02\u5e38";
                }
                throw new Exception(result);
            }
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (in != null) {
                in.close();
            }
            if (response != null) {
                response.close();
            }
            if (httpclient != null) {
                httpclient.close();
            }
        }
        return result;
    }

    public static String get(JSONObject paramsObj, String url, Map<String, String> headerMap) throws Exception {
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        CloseableHttpResponse response = null;
        InputStream in = null;
        BufferedReader br = null;
        String result = "";
        try {
            String line;
            StringBuilder param = new StringBuilder();
            int i = 0;
            Set entries = paramsObj.entrySet();
            for (Map.Entry entry : entries) {
                if (i == 0) {
                    param.append("?");
                } else {
                    param.append("&");
                }
                param.append((String)entry.getKey()).append("=").append(entry.getValue());
                ++i;
            }
            url = url + param;
            HttpGet post = new HttpGet(url);
            Set<Map.Entry<String, String>> headerEntries = headerMap.entrySet();
            for (Map.Entry<String, String> headerEntry : headerEntries) {
                post.setHeader(headerEntry.getKey(), headerEntry.getValue());
            }
            response = httpclient.execute((HttpUriRequest)post);
            in = response.getEntity().getContent();
            br = new BufferedReader(new InputStreamReader(in, "utf-8"));
            StringBuilder strber = new StringBuilder();
            while ((line = br.readLine()) != null) {
                strber.append(line);
                strber.append('\n');
            }
            result = strber.toString();
            if (response.getStatusLine().getStatusCode() != 200) {
                if (StringUtils.isBlank((CharSequence)result)) {
                    result = "\u670d\u52a1\u5668\u5f02\u5e38";
                }
                throw new Exception(result);
            }
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (in != null) {
                in.close();
            }
            if (response != null) {
                response.close();
            }
            if (httpclient != null) {
                httpclient.close();
            }
        }
        return result;
    }
}

