/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.billcenter.workhotel.event;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.BillStatusEnum;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.EquipmentUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.sim.billcenter.workhotel.dto.BillCenterHotelApplyAmountDTO;
import kd.imc.sim.formplugin.bill.originalbill.workbench.event.AbstractBillWorkbenchCustomEvent;
import kd.imc.sim.formplugin.bill.originalbill.workbench.event.BillCommonCustomEvent;

public class BillCenterCommonCustomEvent
extends AbstractBillWorkbenchCustomEvent {
    private static final Log LOGGER = LogFactory.getLog(BillCenterCommonCustomEvent.class);
    private static final String QUERY_FIELDS = String.join((CharSequence)",", "id", "org", "billno", "invoicable_amount", "pushamount", "invoicetype", "total_amount", "sim_isomerism_item_data.seq", "sim_isomerism_item_data.itemtype", "sim_isomerism_item_data.product_name", "sim_isomerism_item_data.product_amount", "sim_isomerism_item_data.avg_amount", "sim_isomerism_item_data.tax_amount", "sim_isomerism_item_data.sub_order_no", "sim_isomerism_item_data.unpushamount", "sim_isomerism_item_data.unpushtax", "sim_isomerism_item_data.unpushnum", "sim_isomerism_item_data.product_price", "sim_isomerism_item_data.tax_rate", "sim_isomerism_item_data.product_unit", "sim_isomerism_item_data.specification", "sim_isomerism_item_data.tax_code", "sim_isomerism_item_data.invoicable_switch", "sim_isomerism_item_data.rowpushstatus");

    @Override
    public void customEvent(AbstractFormPlugin that, CustomEventArgs e) {
        String event = e.getEventName();
        String param = e.getEventArgs();
        switch (event) {
            case "common/tip": {
                that.getView().showTipNotification(param);
                break;
            }
            case "init": {
                this.initData(that);
            }
        }
    }

    private void initData(AbstractFormPlugin that) {
        try {
            BillCenterCommonCustomEvent.putPageCache(that, "workbenchtype", "invoiceworkhotel");
            HashMap<String, Object> map = new HashMap<String, Object>(5);
            Map customParams = that.getView().getFormShowParameter().getCustomParams();
            JSONArray pkValues = (JSONArray)customParams.get("pks");
            BillCenterCommonCustomEvent.putPageCache(that, "pks", pkValues.toJSONString());
            QFilter qFilter = new QFilter("id", "in", (Object)pkValues).and("sim_isomerism_item_data.rowpushstatus", "!=", (Object)"1").and("sim_isomerism_item_data.invoicable_switch", "=", (Object)"1");
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)"sim_isomerism_bill_data", (String)QUERY_FIELDS, (QFilter[])qFilter.toArray());
            HashMap<String, BigDecimal> negativeMap = new HashMap<String, BigDecimal>(bills.length);
            for (DynamicObject bill : bills) {
                DynamicObjectCollection items = bill.getDynamicObjectCollection("sim_isomerism_item_data");
                for (DynamicObject item2 : items) {
                    DynamicObject itemType = item2.getDynamicObject("itemtype");
                    String itemTypeNo = itemType != null ? itemType.getString("number") : "other";
                    BigDecimal unPushAmount = item2.getBigDecimal("unpushamount");
                    String rowPushStatus = item2.getString("rowpushstatus");
                    boolean pushFlag = "-1".equals(rowPushStatus) || "0".equals(rowPushStatus);
                    if (!pushFlag || unPushAmount.compareTo(BigDecimal.ZERO) >= 0) continue;
                    if (negativeMap.containsKey(itemTypeNo)) {
                        BigDecimal totalUnPushAmount = ((BigDecimal)negativeMap.get(itemTypeNo)).add(unPushAmount);
                        negativeMap.put(itemTypeNo, totalUnPushAmount);
                        continue;
                    }
                    negativeMap.put(itemTypeNo, unPushAmount);
                }
                items.removeIf(item -> !"1".equals(item.getString("invoicable_switch")) || "1".equals(item.getString("rowpushstatus")) || item.getBigDecimal("unpushamount").compareTo(BigDecimal.ZERO) <= 0);
            }
            this.convertBill(map, bills, negativeMap);
            long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)bills[0].get("org"));
            BillCenterCommonCustomEvent.putPageCache(that, "currentOrg", String.valueOf(orgId));
            DynamicObject org = BusinessDataServiceHelper.loadSingle((String)"bdm_org", (String)"epinfo", (QFilter[])new QFilter("id", "=", (Object)orgId).toArray());
            BillCommonCustomEvent commonCustomEvent = new BillCommonCustomEvent();
            DynamicObject orgDynamicObject = TaxUtils.getOrgDynamicObject((Long)orgId);
            commonCustomEvent.initJqbh(orgDynamicObject, "", "", map);
            commonCustomEvent.initAccount(org.getDynamicObject("epinfo").getString("number"), map);
            this.initTerminalNo(orgDynamicObject, map);
            boolean lqptChannel = EnterpriseHelper.isLqptChannel((String)org.getDynamicObject("epinfo").getString("number"));
            Map accountMap = (Map)map.get("accountMap");
            map.put("isAllE", lqptChannel || accountMap != null && !accountMap.isEmpty());
            BillCenterCommonCustomEvent.updateCustomControl(that, map, "init");
        }
        catch (Exception e) {
            LOGGER.error("\u8fdb\u5165\u9152\u5e97\u5de5\u4f5c\u53f0\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
            BillCenterCommonCustomEvent.handleExcepiton(that, e);
            BillCenterCommonCustomEvent.updateCustomControlError(that, null, "init");
        }
    }

    private void initTerminalNo(DynamicObject orgDynamicObject, Map<String, Object> map) {
        String taxNo = orgDynamicObject.getDynamicObject("epinfo").getString("number");
        Map jqbhMap = (Map)map.get("jqbhs");
        String currentJqbh = (String)map.get("currentJqbh");
        HashMap terminalNos = new HashMap(4);
        Collection jqbhs = jqbhMap.values();
        for (String jqbh : jqbhs) {
            DynamicObject equipment = EquipmentUtil.getEquipmentDynamicObjectByDevNo((String)jqbh, (String)taxNo);
            List bindTerminalList = new ArrayList(1);
            if (equipment != null && "8".equals(equipment.getString("equipmenttype"))) {
                bindTerminalList = EquipmentUtil.getTerminanMapListByDevNo((String)jqbh, (String)taxNo);
            }
            if (bindTerminalList == null || bindTerminalList.size() <= 0) continue;
            terminalNos.put(jqbh, bindTerminalList);
            if (!jqbh.equals(currentJqbh)) continue;
            map.put("terminalNo", bindTerminalList.get(0));
        }
        map.put("terminalNos", terminalNos);
    }

    private void convertBill(Map<String, Object> map, DynamicObject[] bills, Map<String, BigDecimal> negativeMap) {
        HashMap<String, BillCenterHotelApplyAmountDTO> applyAmountMap = new HashMap<String, BillCenterHotelApplyAmountDTO>(8);
        DynamicObject[] categorys = BusinessDataServiceHelper.load((String)"sim_bill_center_category", (String)String.join((CharSequence)",", "name", "number"), (QFilter[])new QFilter("status", "=", (Object)BillStatusEnum.AUDIT_SUCCESS.getCode()).and("enable", "=", (Object)"1").toArray(), (String)"id asc");
        DynamicObject otherItemType = Arrays.stream(categorys).filter(category -> category.getPkValue().equals(4L)).findFirst().orElse(null);
        if (otherItemType == null) {
            otherItemType = BusinessDataServiceHelper.newDynamicObject((String)"sim_bill_center_category");
            otherItemType.set("name", (Object)ResManager.loadKDString((String)"\u5176\u4ed6\u670d\u52a1", (String)"BillCenterCommonCustomEvent_0", (String)"imc-sim-service", (Object[])new Object[0]));
            otherItemType.set("number", (Object)"other");
        }
        ArrayList<Map> billList = new ArrayList<Map>(bills.length);
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (DynamicObject bill : bills) {
            Map billMap = DynamicObjectUtil.dynamicObjectToMap((DynamicObject)bill, (boolean)true);
            billMap.remove("org_id");
            billMap.remove("tableName");
            DynamicObjectCollection items = bill.getDynamicObjectCollection("sim_isomerism_item_data");
            List itemList = (List)billMap.get("sim_isomerism_item_data");
            for (int i = 0; i < itemList.size(); ++i) {
                Map itemMap = (Map)itemList.get(i);
                itemMap.remove("itemtype");
                itemMap.remove("itemtype_id");
                itemMap.remove("tableName");
                DynamicObject item = (DynamicObject)items.get(i);
                DynamicObject itemType = item.getDynamicObject("itemtype");
                if (itemType == null) {
                    itemType = otherItemType;
                }
                itemMap.put("itemtypenumber", itemType.getString("number"));
                itemMap.put("itemtypename", itemType.getString("name"));
                BillCenterHotelApplyAmountDTO applyAmountDto = applyAmountMap.computeIfAbsent(itemType.getString("number"), k -> new BillCenterHotelApplyAmountDTO());
                applyAmountDto.setCanApplyAmount(applyAmountDto.getCanApplyAmount().add(item.getBigDecimal("unpushamount")));
            }
            BigDecimal unPushAmount = bill.getBigDecimal("invoicable_amount").subtract(bill.getBigDecimal("pushamount")).setScale(2, 4);
            totalAmount = totalAmount.add(unPushAmount);
            billMap.put("invoicable_amount", unPushAmount);
            billList.add(billMap);
        }
        map.put("bills", billList);
        ArrayList<BillCenterHotelApplyAmountDTO> applyAmounts = new ArrayList<BillCenterHotelApplyAmountDTO>(categorys.length);
        for (DynamicObject category2 : categorys) {
            BillCenterHotelApplyAmountDTO applyAmount = new BillCenterHotelApplyAmountDTO();
            applyAmount.setName(category2.getString("name"));
            String number = category2.getString("number");
            applyAmount.setNumber(number);
            BillCenterHotelApplyAmountDTO applyAmountDTO = (BillCenterHotelApplyAmountDTO)applyAmountMap.get(number);
            if (applyAmountDTO != null) {
                applyAmount.setCanApplyAmount(applyAmountDTO.getCanApplyAmount().setScale(2, 4));
            }
            applyAmounts.add(applyAmount);
        }
        for (BillCenterHotelApplyAmountDTO applyAmountObject : applyAmounts) {
            String number = applyAmountObject.getNumber();
            if (!negativeMap.containsKey(number)) continue;
            applyAmountObject.setCanApplyAmount(applyAmountObject.getCanApplyAmount().add(negativeMap.get(number)));
        }
        map.put("applyAmounts", applyAmounts);
        map.put("totalAmount", totalAmount.setScale(2, 4));
    }
}

