/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.billcenter.workhotel.event;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.container.Tab;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.imc.bdm.common.constant.OperationConstant;
import kd.imc.bdm.common.dto.BillRelationDTO;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.sim.common.helper.issueinvoice.IssueInvoiceMqHelper;
import kd.imc.sim.formplugin.bill.originalbill.workbench.event.AbstractBillWorkbenchCustomEvent;
import kd.imc.sim.formplugin.bill.originalbill.workbench.event.BillPreviewTabCustomEvent;
import kd.imc.sim.formplugin.bill.originalbill.workbenchreverse.helper.WorkbenchReverseHelper;
import kd.imc.sim.formplugin.issuing.helper.IssueInvoiceControlHelper;

public class BillCenterPreviewCustomEvent
extends AbstractBillWorkbenchCustomEvent {
    private static final Log LOGGER = LogFactory.getLog(BillCenterPreviewCustomEvent.class);
    private static final ImmutableSet<String> invoiceContainKey = new ImmutableSet.Builder().add((Object[])new String[]{"buyerphone", "buyeremail", "saleraddr", "salerbank"}).add((Object[])new String[]{"remark", "drawer", "payee", "reviewer", "id"}).build();
    private static final ImmutableSet<String> itemContainKey = new ImmutableSet.Builder().add((Object[])new String[]{"specification", "unit", "id", "num", "unitprice", "taxunitprice"}).build();

    @Override
    public void customEvent(AbstractFormPlugin that, CustomEventArgs e) {
        switch (e.getEventName()) {
            case "preview/issue": {
                this.confirmIssue(that, e.getEventArgs());
                break;
            }
            case "preview/change_saler_address": {
                JSONObject jsonArs = JSONObject.parseObject((String)e.getEventArgs());
                BillPreviewTabCustomEvent.openSalerAddress(that, jsonArs);
            }
        }
    }

    public void confirmIssue(AbstractFormPlugin that, String param) {
        OperateOption create = OperateOption.create();
        create.setVariableValue("workhotel_save", "true");
        DynamicObject[] invoiceList = null;
        try (TXHandle tx = TX.requiresNew();){
            try {
                DynamicObject[] originalBillList = this.getDynamicObjectFromCache(that, "sim_original_bill", "sim_original_bill_item");
                OperationResult saveResult = OperationServiceHelper.executeOperate((String)"writebacksave", (String)"sim_original_bill", (DynamicObject[])originalBillList, (OperateOption)OperateOption.create());
                if (!saveResult.isSuccess()) {
                    throw new KDBizException("save fail\uff1a" + OperationConstant.getErrorMsg((OperationResult)saveResult));
                }
                invoiceList = this.getDynamicObjectFromCache(that, "sim_vatinvoice", "items");
                JSONArray invoiceArr = JSONArray.parseArray((String)param);
                JSONArray newArr = new JSONArray();
                for (int i = 0; i < invoiceArr.size(); ++i) {
                    JSONObject invoice2 = invoiceArr.getJSONObject(i);
                    JSONObject newInvoice = new JSONObject();
                    for (String key : invoiceContainKey) {
                        newInvoice.put(key, invoice2.get((Object)key));
                    }
                    JSONArray jsonArray = invoice2.getJSONArray("items");
                    JSONArray newItems = new JSONArray();
                    for (int j = 0; j < jsonArray.size(); ++j) {
                        JSONObject item = jsonArray.getJSONObject(j);
                        JSONObject newItem = new JSONObject();
                        for (String key : itemContainKey) {
                            newItem.put(key, item.get((Object)key));
                        }
                        newItems.add((Object)newItem);
                    }
                    newInvoice.put("items", (Object)newItems);
                    newArr.add((Object)newInvoice);
                }
                WorkbenchReverseHelper.overrideJsonArray2Dynamic(newArr, invoiceList, true);
                ImcSaveServiceHelper.save((DynamicObject[])invoiceList);
                List billInvRelationList = JSONArray.parseArray((String)BillCenterPreviewCustomEvent.getPageCacheVal(that, "sim_bill_inv_relation"), BillRelationDTO.class);
                ArrayList relationsList = new ArrayList(billInvRelationList.size());
                billInvRelationList.forEach(relation -> relationsList.add(DynamicObjectUtil.bean2DynamicObject((Object)relation, (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"sim_bill_inv_relation"))));
                ImcSaveServiceHelper.save(relationsList);
                IssueInvoiceControlHelper.setOriginalBillByInvRelation(Arrays.stream(originalBillList).collect(Collectors.toList()), billInvRelationList);
                HashMap<String, Object> params = new HashMap<String, Object>(8);
                params.put("curIndex", 2);
                BillCenterPreviewCustomEvent.updateCustomControl(that, params, "setCurrentDisplay");
                Tab tab = (Tab)that.getView().getControl("tabap");
                tab.activeTab("result");
            }
            catch (Exception e) {
                LOGGER.error("\u9152\u5e97\u5de5\u4f5c\u53f0\u786e\u8ba4\u5f00\u7968\u5931\u8d25" + e.getMessage(), (Throwable)e);
                that.getView().showErrorNotification("issue fail" + e.getMessage());
                tx.markRollback();
            }
        }
        if (invoiceList != null) {
            BillCenterPreviewCustomEvent.putPageCache(that, "invoiceIds", Arrays.stream(invoiceList).map(invoice -> invoice.getPkValue().toString()).collect(Collectors.joining(",")));
            IssueInvoiceMqHelper.submitInvoice2MQ((DynamicObject[])invoiceList);
        }
    }

    private DynamicObject[] getDynamicObjectFromCache(AbstractFormPlugin that, String formId, String entryId) {
        MainEntityType dtType = EntityMetadataCache.getDataEntityType((String)formId);
        Object[] deserializeArr = DynamicObjectSerializeUtil.deserialize((String)BillCenterPreviewCustomEvent.getPageCacheVal(that, formId), (DynamicObjectType)dtType);
        DynamicObject[] newBills = new DynamicObject[deserializeArr.length];
        for (int i = 0; i < deserializeArr.length; ++i) {
            DynamicObject oldBill = (DynamicObject)deserializeArr[i];
            DynamicObject newBill = (DynamicObject)new CloneUtils(false, true).clone((IDataEntityBase)oldBill);
            newBill.set("id", oldBill.get("id"));
            DynamicObjectCollection oldItems = oldBill.getDynamicObjectCollection(entryId);
            DynamicObjectCollection newItems = newBill.getDynamicObjectCollection(entryId);
            for (int j = 0; j < newItems.size(); ++j) {
                ((DynamicObject)newItems.get(j)).set("id", ((DynamicObject)oldItems.get(j)).get("id"));
            }
            newBills[i] = newBill;
        }
        return newBills;
    }
}

