/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.dto.BillDetailVo;
import kd.imc.bdm.common.dto.BillVo;
import kd.imc.bdm.common.helper.DrawerStrategyHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.model.DrawerInfo;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.helper.BillValidaterHelper;
import kd.imc.sim.common.helper.MaterialToGoodsInfoHelp;
import kd.imc.sim.common.service.WideInvoiceSevice;
import kd.imc.sim.common.utils.InvoiceQFilterUtil;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.formplugin.match.BillMatchHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class OriginalBillHelper {
    private static Log LOGGER = LogFactory.getLog(OriginalBillHelper.class);

    public void setDrawer(List<DynamicObject> list) {
        for (DynamicObject originalBill : list) {
            DrawerInfo drawerInfo = DrawerStrategyHelper.getOriginalBillDrawerStrategy((Object)originalBill.get("jqbh"), (DynamicObject)originalBill);
            originalBill.set("drawer", (Object)drawerInfo.getDrawer());
            originalBill.set("payee", (Object)drawerInfo.getPayee());
            originalBill.set("reviewer", (Object)drawerInfo.getReviewer());
        }
    }

    public void setSaleInfo(List<DynamicObject> bills) {
        LOGGER.info(String.format("OriginalBillMappingServiceImpl sellerMapping bills:%s", SerializationUtils.toJsonString(bills)));
        HashSet<String> taxNoSet = new HashSet<String>(bills.size());
        for (DynamicObject bill : bills) {
            taxNoSet.add(bill.getString("salertaxno"));
        }
        Map<Object, List<DynamicObject>> settingByTaxNo = BillValidaterHelper.getSettingByTaxNo(taxNoSet);
        BillMatchHelper billMatchHelper = new BillMatchHelper();
        for (DynamicObject bill : bills) {
            String salerAddr;
            List<DynamicObject> settings = settingByTaxNo.get(bill.getString("salertaxno"));
            if (CollectionUtils.isEmpty(settings)) continue;
            billMatchHelper.matchSalerAddrAndBank(bill, settings.toArray(new DynamicObject[0]));
            String salerBank = bill.getString("salerbank");
            if (StringUtils.isNotBlank((CharSequence)salerBank)) {
                bill.set("salerbank", (Object)salerBank);
            }
            if (!StringUtils.isNotBlank((CharSequence)(salerAddr = bill.getString("saleraddr")))) continue;
            bill.set("saleraddr", (Object)salerAddr);
        }
    }

    public static Map<String, Object> setGoodsInfoMapping(List<DynamicObject> billDOs) {
        return OriginalBillHelper.setGoodsInfoMapping(billDOs, "0");
    }

    public static Map<String, Object> setGoodsInfoMapping(List<DynamicObject> billDOs, String pushMatchRules) {
        LOGGER.info(String.format("OriginalBillHelper goodsInfoMapping bills:%s", SerializationUtils.toJsonString(billDOs)));
        ArrayList bills = Lists.newArrayListWithExpectedSize((int)billDOs.size());
        for (DynamicObject billDO : billDOs) {
            BillVo vo = (BillVo)DynamicObjectUtil.dynamicObject2Bean(BillVo.class, (DynamicObject)billDO);
            vo.setPushMatchRules(pushMatchRules);
            bills.add(vo);
        }
        HashMap resultMap = Maps.newHashMap();
        ArrayList failBillList = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)bills)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7533\u8bf7\u5355\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillHelper_0", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        for (BillVo bill : bills) {
            if (null != bill.getBillDetail()) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u5355:%s\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillHelper_1", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo()));
        }
        Long orgId = ((BillVo)bills.get(0)).getOrgId();
        Map<String, DynamicObject> pushGoodsInfoData = MaterialToGoodsInfoHelp.loadPushGoodsInfoData(orgId, bills);
        for (BillVo bill : bills) {
            List billDetail = bill.getBillDetail();
            for (BillDetailVo detailVo : billDetail) {
                DynamicObject goodsInfo = MaterialToGoodsInfoHelp.getMappingGoodsInfo(detailVo, bill.getPushMatchRules(), pushGoodsInfoData);
                if (null != goodsInfo) {
                    MaterialToGoodsInfoHelp.setDetail(detailVo, goodsInfo, bill.getFillValueRule());
                    continue;
                }
                failBillList.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s\u660e\u7ec6\u884c\uff1a%2$s \u5339\u914d\u5931\u8d25", (String)"OriginalBillHelper_7", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), detailVo.getGoodsName()));
            }
        }
        if (CollectionUtils.isEmpty(pushGoodsInfoData)) {
            LOGGER.info("goodsInfoMapping \u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5f00\u7968\u9879");
            resultMap.put("msg", ResManager.loadKDString((String)"\u6620\u5c04\u5931\u8d25\uff0c\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5f00\u7968\u9879", (String)"OriginalBillHelper_5", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        if (!CollectionUtils.isEmpty((Collection)failBillList)) {
            resultMap.put("failInfo", failBillList);
        }
        resultMap.put("data", bills);
        return resultMap;
    }

    public boolean isBillAllIssue(String billno) {
        if (StringUtils.isBlank((CharSequence)billno)) {
            throw new MsgException(ErrorType.EMPTY_PARAM);
        }
        DynamicObject originalBill = BusinessDataServiceHelper.loadSingle((String)"sim_original_bill", (String)String.join((CharSequence)",", "confirmstate", "surplusamount", "surplustax"), (QFilter[])new QFilter("billno", "=", (Object)billno).toArray());
        if (originalBill == null) {
            throw new MsgException(ResManager.loadKDString((String)"\u67e5\u65e0\u6b64\u5355\u636e", (String)"OriginalBillHelper_6", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        String confirmState = originalBill.getString("confirmstate");
        if ("0".equals(confirmState) || "1".equals(confirmState)) {
            return false;
        }
        BigDecimal surplusAmount = originalBill.getBigDecimal("surplusamount");
        BigDecimal surplusTax = originalBill.getBigDecimal("surplustax");
        return surplusAmount.compareTo(BigDecimal.ZERO) == 0 || surplusAmount.add(surplusTax).compareTo(BigDecimal.ZERO) == 0;
    }

    public static void invalidBillDelete(List<Pair<String, String>> invalidInvoiceCodeNo) {
        if (CollectionUtils.isEmpty(invalidInvoiceCodeNo)) {
            return;
        }
        DynamicObject[] invoices = OriginalBillHelper.queryInvoice(invalidInvoiceCodeNo);
        if (invoices.length != 0) {
            for (DynamicObject invoice : invoices) {
                invoice.set("occupystatus", (Object)"0");
            }
            ImcSaveServiceHelper.update((DynamicObject[])invoices);
        }
        WideInvoiceSevice.dealWideInvoiceOccupyStatus(Arrays.stream(invoices).collect(Collectors.toList()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void redBillDelete(List<DynamicObject> redBills, List<Pair<String, String>> invalidInvoiceCodeNo) {
        if (CollectionUtils.isEmpty(redBills)) {
            return;
        }
        invalidInvoiceCodeNo.clear();
        HashMap<String, DynamicObjectCollection> redBillItems = new HashMap<String, DynamicObjectCollection>(redBills.size());
        for (DynamicObject redBill : redBills) {
            invalidInvoiceCodeNo.add((Pair<String, String>)Pair.of((Object)redBill.getString("blueinvoicecode"), (Object)redBill.getString("blueinvoiceno")));
            DynamicObjectCollection collection = redBillItems.computeIfAbsent(redBill.getString("blueinvoicecode") + "blueinvoicecode" + redBill.getString("blueinvoiceno"), k -> new DynamicObjectCollection());
            collection.addAll((Collection)redBill.getDynamicObjectCollection("sim_original_bill_item"));
        }
        DLock lock = DLock.create((String)"deleteRed");
        lock.lock();
        try {
            DynamicObject[] invoices = OriginalBillHelper.queryInvoice(invalidInvoiceCodeNo);
            if (invoices.length == 0) {
                return;
            }
            for (DynamicObject invoice : invoices) {
                invoice.set("occupystatus", (Object)"0");
                DynamicObjectCollection items = (DynamicObjectCollection)redBillItems.get(invoice.getString("invoicecode") + "blueinvoicecode" + invoice.getString("invoiceno"));
                if (CollectionUtils.isEmpty((Collection)items)) continue;
                Map<Long, List<DynamicObject>> billItems = items.stream().filter(item -> item.getLong("blueinvoiceitemid") != 0L).collect(Collectors.groupingBy(k -> k.getLong("blueinvoiceitemid")));
                DynamicObjectCollection invoiceItems = invoice.getDynamicObjectCollection("items");
                for (DynamicObject invoiceItem : invoiceItems) {
                    List<DynamicObject> billItemList = billItems.get(invoiceItem.getLong("id"));
                    if (CollectionUtils.isEmpty(billItemList)) continue;
                    BigDecimal amount = BigDecimal.ZERO;
                    BigDecimal tax = BigDecimal.ZERO;
                    for (DynamicObject billItem : billItemList) {
                        amount = amount.add(billItem.getBigDecimal("amount"));
                        tax = tax.add(billItem.getBigDecimal("tax"));
                    }
                    if (MathUtils.isNullOrZero((BigDecimal)amount)) continue;
                    invoiceItem.set("itemremainredamount", (Object)invoiceItem.getBigDecimal("itemremainredamount").subtract(amount));
                    invoiceItem.set("itemremainredtax", (Object)invoiceItem.getBigDecimal("itemremainredtax").subtract(tax));
                }
            }
            ImcSaveServiceHelper.update((DynamicObject[])invoices);
            WideInvoiceSevice.dealWideInvoiceOccupyStatus(Arrays.stream(invoices).collect(Collectors.toList()));
        }
        finally {
            lock.unlock();
        }
    }

    public static DynamicObject[] queryInvoice(List<Pair<String, String>> invoiceCodeNoList) {
        QFilter qFilter = new QFilter("invoicecode", "=", (Object)"-1").and("invoiceno", "=", (Object)"-1");
        for (Pair<String, String> invoiceCodeNo : invoiceCodeNoList) {
            qFilter.or(InvoiceQFilterUtil.getInvoiceByCodeAndNo((String)((String)invoiceCodeNo.getKey()), (String)((String)invoiceCodeNo.getValue())));
        }
        return BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "occupystatus", "billstatus", "invoicecode", "invoiceno", "itemremainredamount", "itemremainredtax"), (QFilter[])qFilter.toArray());
    }

    public static DynamicObject[] queryOriginalbillsByIds(Object[] billIds) {
        return OriginalBillHelper.queryOriginalbillsByIds(billIds, "", "");
    }

    public static DynamicObject[] queryOriginalbillsByIds(Object[] billIds, String orderBy) {
        return OriginalBillHelper.queryOriginalbillsByIds(billIds, "", orderBy);
    }

    public static DynamicObject[] queryOriginalbillsByIds(Object[] billIds, String fields, String orderBy) {
        int size;
        if (StringUtils.isBlank((CharSequence)fields)) {
            fields = PropertieUtil.getAllPropertiesSplitByComma((String)"sim_original_bill", (boolean)true);
        }
        if ((size = BigDecimalUtil.transDecimal((Object)ImcConfigUtil.getValue((String)"sim_orginal_bill_query", (String)"sim_orginal_bill_query_size")).intValue()) <= 0 || billIds.length <= size) {
            if (StringUtils.isBlank((CharSequence)orderBy)) {
                return BusinessDataServiceHelper.load((String)"sim_original_bill", (String)fields, (QFilter[])new QFilter("id", "in", (Object)billIds).toArray());
            }
            return BusinessDataServiceHelper.load((String)"sim_original_bill", (String)fields, (QFilter[])new QFilter("id", "in", (Object)billIds).toArray(), (String)orderBy);
        }
        long start = System.currentTimeMillis();
        int group = (billIds.length + size - 1) / size;
        List idSetList = Stream.iterate(0, i -> i + 1).limit(group).map(i -> Arrays.stream(billIds).skip((long)i.intValue() * (long)size).limit(size).collect(Collectors.toSet())).collect(Collectors.toList());
        ArrayList billList = new ArrayList(16);
        for (Set billIdSet : idSetList) {
            DynamicObject[] dataArray = StringUtils.isBlank((CharSequence)orderBy) ? BusinessDataServiceHelper.load((String)"sim_original_bill", (String)fields, (QFilter[])new QFilter("id", "in", (Object)billIdSet).toArray()) : BusinessDataServiceHelper.load((String)"sim_original_bill", (String)fields, (QFilter[])new QFilter("id", "in", (Object)billIdSet).toArray(), (String)orderBy);
            if (dataArray == null) continue;
            Collections.addAll(billList, dataArray);
        }
        LOGGER.info("\u67e5\u8be2\u5f00\u7968\u7533\u8bf7\u5355\u6570\u91cf:" + billIds.length + ",\u5206\u9875:" + group + ",\u8017\u65f6:" + (System.currentTimeMillis() - start));
        return billList.toArray(new DynamicObject[0]);
    }

    public static DynamicObject[] queryMatchBillByIds(Object[] matchBillIds) {
        int size = BigDecimalUtil.transDecimal((Object)ImcConfigUtil.getValue((String)"sim_orginal_bill_query", (String)"sim_orginal_bill_query_size")).intValue();
        if (size <= 0 || matchBillIds.length <= size) {
            return BusinessDataServiceHelper.load((Object[])matchBillIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_match_bill"));
        }
        int group = (matchBillIds.length + size - 1) / size;
        List idSetList = Stream.iterate(0, i -> i + 1).limit(group).map(i -> Arrays.stream(matchBillIds).skip((long)i.intValue() * (long)size).limit(size).collect(Collectors.toSet())).collect(Collectors.toList());
        ArrayList billList = new ArrayList(16);
        for (Set billIdSet : idSetList) {
            DynamicObject[] dataArray = BusinessDataServiceHelper.load((Object[])billIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_match_bill"));
            if (dataArray == null) continue;
            Collections.addAll(billList, dataArray);
        }
        return billList.toArray(new DynamicObject[0]);
    }
}

