/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.helper;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableSet;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.lqpt.model.request.check.CheckRequest;
import kd.imc.bdm.lqpt.model.response.LqptResponse;
import kd.imc.bdm.lqpt.model.response.check.CheckInvoiceResponse;
import kd.imc.bdm.lqpt.model.response.check.CheckResponse;
import kd.imc.bdm.lqpt.model.response.collect.InvoiceStatusQueryResponse;
import kd.imc.bdm.lqpt.service.check.CheckApiService;
import kd.imc.bdm.lqpt.service.collect.InvoiceCollectionService;
import kd.imc.sim.common.utils.ZipUtil;

public class RimLqptQueryHelper {
    private static final Log LOGGER = LogFactory.getLog(RimLqptQueryHelper.class);
    public static final ImmutableSet<String> NO_CHECK_ABILITY_CODE = new ImmutableSet.Builder().add((Object)"694049").add((Object)"694033").add((Object)"694032").build();

    public InvoiceStatusQueryResponse invoiceAccountingQuery(String taxNo, String invoiceType, String invoiceCode, String invoiceNo, Date issueTime) {
        try {
            JSONObject json = new JSONObject();
            json.put("nsrsbh", (Object)taxNo);
            json.put("fpdm", (Object)invoiceCode);
            json.put("fphm", (Object)invoiceNo);
            json.put("fplx", (Object)InvoiceType.getRimLqptCodeByTypeCode((String)invoiceType));
            json.put("kprq", (Object)DateUtils.format((Date)issueTime, (String)"yyyyMMdd"));
            json.put("api_type", (Object)"FPZTXXCX");
            JSONObject responseJson = new InvoiceCollectionService().send(json);
            if (ErrorType.SUCCESS.getCode().equals(responseJson.getString("errcode"))) {
                return (InvoiceStatusQueryResponse)JSONObject.parseObject((String)responseJson.getString("data"), InvoiceStatusQueryResponse.class);
            }
        }
        catch (Exception e) {
            LOGGER.info("\u5f52\u96c6\u80fd\u529b\u53d1\u7968\u7528\u9014\u72b6\u6001\u67e5\u8be2\u5931\u8d25" + e.getMessage());
        }
        return new InvoiceStatusQueryResponse();
    }

    public LqptResponse allEInvoiceInspection(DynamicObject invoice) {
        CheckRequest checkRequest = new CheckRequest();
        checkRequest.setNsrsbh(invoice.getString("salertaxno"));
        checkRequest.setFplx(InvoiceType.getRimLqptCodeByTypeCode((String)invoice.getString("invoicetype")));
        checkRequest.setFphm(invoice.getString("invoiceno"));
        checkRequest.setKprq(DateUtils.format((Date)invoice.getDate("issuetime"), (String)"yyyyMMdd"));
        checkRequest.setKpje(invoice.getBigDecimal("totalamount").setScale(2, 4));
        return this.allEInvoiceInspection(checkRequest);
    }

    public LqptResponse allEInvoiceInspection(CheckRequest request) {
        LqptResponse response = new LqptResponse();
        response.setErrcode(ErrorType.FAIL.getCode());
        try {
            JSONObject responseJson = new CheckApiService().send((JSONObject)JSONObject.toJSON((Object)request));
            response.setErrcode(responseJson.getString("errcode"));
            response.setDescription(responseJson.getString("description"));
            response.setData(JSONObject.parseObject((String)responseJson.getString("data"), CheckResponse.class));
            if (ErrorType.SUCCESS.getCode().equals(response.getErrcode())) {
                CheckResponse checkResponse = (CheckResponse)response.getData();
                String invoiceStr = ZipUtil.gunzipStr(Base64.getDecoder().decode(checkResponse.getCyjgxx()), StandardCharsets.UTF_8.name());
                LOGGER.info(String.format("\u67e5\u9a8c\u6210\u529f\uff0c\u53d1\u7968\u6570\u636e : [%s]", invoiceStr));
                checkResponse.setInvoice((CheckInvoiceResponse)JSONObject.parseObject((String)invoiceStr, CheckInvoiceResponse.class));
            }
        }
        catch (Exception e) {
            LOGGER.info("\u67e5\u9a8c\u80fd\u529b\u67e5\u8be2\u5931\u8d25" + e.getMessage(), (Object)e);
        }
        return response;
    }
}

