/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.declarationbill.service.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.imc.bdm.common.constant.table.BgdBillConstant;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.dto.bgd.config.BgdConfig;
import kd.imc.sim.common.dto.bgd.request.BgdDetailRequestDTO;
import kd.imc.sim.common.dto.bgd.request.BgdExchangeRateRequestDTO;
import kd.imc.sim.common.dto.bgd.request.BgdListRequestDTO;
import kd.imc.sim.common.dto.bgd.response.BgdCollectResponse;
import kd.imc.sim.common.dto.bgd.response.BgdDetailResponseDTO;
import kd.imc.sim.common.dto.bgd.response.BgdExchangeRateResponseDTO;
import kd.imc.sim.common.dto.bgd.response.BgdListResponseDTO;
import kd.imc.sim.common.dto.bgd.service.BgdCollectDTO;
import kd.imc.sim.common.helper.customsbill.DeclarationRecordHelper;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.helper.issueinvoice.UnitPriceHelper;
import kd.imc.sim.declarationbill.helper.BgdHelper;
import kd.imc.sim.declarationbill.service.BgdBusinessService;
import kd.imc.sim.declarationbill.service.BgdCalculateService;
import kd.imc.sim.declarationbill.service.BgdCollectService;
import kd.imc.sim.declarationbill.service.LogBgdCollectRecordService;
import kd.imc.sim.declarationbill.service.XuNuoDeclarationCollectService;

public class XuNoiBgdCollectServiceImpl
implements BgdCollectService,
XuNuoDeclarationCollectService,
BgdCalculateService,
LogBgdCollectRecordService,
BgdBusinessService {
    private static final Log LOGGER = LogFactory.getLog(XuNoiBgdCollectServiceImpl.class);
    private static final String COMPLETE = "1";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BgdCollectResponse collect(BgdCollectDTO dto) {
        LOGGER.info("collectBgdStart");
        dto.setDdateks(DateUtils.format((Date)dto.getStart(), (String)"yyyy-MM-dd"));
        dto.setDdatejs(DateUtils.format((Date)dto.getEnd(), (String)"yyyy-MM-dd"));
        List bgdListRequestDTOS = dto.generateListDtos();
        BgdConfig config = BgdHelper.getBgdConfig(dto);
        String lockKey = this.getClass().getSimpleName() + config.getAppKey();
        ArrayList<DynamicObject> updateAndNewList = new ArrayList<DynamicObject>(8);
        ArrayList<BgdListResponseDTO> failList = new ArrayList<BgdListResponseDTO>(8);
        BgdCollectResponse response = new BgdCollectResponse();
        response.setErrorCode(ErrorType.FAIL.getCode());
        try (DLock dLock = DLock.create((String)lockKey);){
            if (!dLock.tryLock(50L)) {
                response.setErrorMsg(ResManager.loadKDString((String)"\u6709\u5176\u4ed6\u62a5\u5173\u5355\u91c7\u96c6\u4efb\u52a1\u5728\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"XuNoiBgdCollectServiceImpl_1", (String)"imc-sim-service", (Object[])new Object[0]));
                BgdCollectResponse bgdCollectResponse = response;
                return bgdCollectResponse;
            }
            List<BgdListResponseDTO> bgdList = this.batchQueryBgdList(bgdListRequestDTOS, config);
            this.filter(bgdList, config, dto);
            this.removeAlreadyPushed(bgdList, config);
            for (BgdListResponseDTO listDto : bgdList) {
                BgdDetailResponseDTO detailResponse = this.queryBgdDetail(BgdDetailRequestDTO.born((BgdListResponseDTO)listDto), config);
                if (ErrorType.SUCCESS.getCode().equals(detailResponse.getErrorCode())) {
                    try {
                        DynamicObject dynamicBill = DynamicObjectUtil.bean2DynamicObject((Object)detailResponse, (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"sim_declaration_bill"));
                        BgdHelper.fillData(dynamicBill, detailResponse, listDto, config);
                        updateAndNewList.add(dynamicBill);
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                        failList.add(listDto);
                    }
                    continue;
                }
                failList.add(listDto);
            }
            for (DynamicObject bgdBill : updateAndNewList) {
                this.calculate(bgdBill, config);
            }
            this.saveData(config, updateAndNewList, failList);
            response.setErrorCode(ErrorType.SUCCESS.getCode());
        }
        catch (Exception e) {
            response.setErrorMsg(String.format(ResManager.loadKDString((String)"\u62a5\u5173\u5355\u91c7\u96c6\u5f02\u5e38:%s", (String)"XuNoiBgdCollectServiceImpl_0", (String)"imc-sim-service", (Object[])new Object[0]), e.getMessage()));
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.logBgdRecord(updateAndNewList, config);
        }
        response.setFailedBgdNums(failList.size());
        response.setNewBgdNums(config.getNewNum());
        response.setUpdateNums(config.getUpdateNum());
        return response;
    }

    private List<BgdListResponseDTO> batchQueryBgdList(List<BgdListRequestDTO> bgdListRequestDTOS, BgdConfig config) {
        ArrayList<BgdListResponseDTO> bgdList = new ArrayList<BgdListResponseDTO>();
        for (BgdListRequestDTO listRequestDTO : bgdListRequestDTOS) {
            List<BgdListResponseDTO> oneQuery = this.queryBgdList(listRequestDTO, config);
            if (oneQuery.size() <= 0) continue;
            bgdList.addAll(oneQuery);
        }
        return bgdList;
    }

    private void saveData(BgdConfig config, ArrayList<DynamicObject> updateAndNewList, List<BgdListResponseDTO> failList) {
        Map newExchangeRateMap = config.getNewExchangeRateMap();
        if (null != newExchangeRateMap && newExchangeRateMap.size() > 0) {
            ArrayList list = new ArrayList(newExchangeRateMap.values());
            ImcSaveServiceHelper.save(list);
        }
        try (TXHandle tx = TX.required();){
            try {
                Set billNoSet = updateAndNewList.stream().map(o -> o.getString("billno")).collect(Collectors.toSet());
                Set failNoList = failList.stream().map(BgdListResponseDTO::getCusCiqNo).collect(Collectors.toSet());
                failNoList.removeIf(billNoSet::contains);
                int deletedNum = DeleteServiceHelper.delete((String)"sim_declaration_bill", (QFilter[])new QFilter("billno", "in", (Object)billNoSet.toArray()).toArray());
                ImcSaveServiceHelper.save(updateAndNewList);
                config.setUpdateNum(deletedNum);
                config.setNewNum(updateAndNewList.size() - deletedNum);
                DynamicObject[] dbFailed = BusinessDataServiceHelper.load((String)"sim_declaration_bill", (String)"billno", (QFilter[])new QFilter("billno", "in", (Object)failNoList.toArray()).toArray());
                Set dbBillNos = Arrays.stream(dbFailed).map(o -> o.getString("billno")).collect(Collectors.toSet());
                failNoList.removeIf(dbBillNos::contains);
                ArrayList<DynamicObject> failRecord = new ArrayList<DynamicObject>();
                for (BgdListResponseDTO bgdListResponseDTO : failList) {
                    if (!failNoList.contains(bgdListResponseDTO.getCusCiqNo())) continue;
                    DynamicObject failBgd = BusinessDataServiceHelper.newDynamicObject((String)"sim_declaration_bill");
                    BgdHelper.fillData(failBgd, null, bgdListResponseDTO, config);
                    failRecord.add(failBgd);
                }
                if (failRecord.size() > 0) {
                    ImcSaveServiceHelper.save(failRecord);
                }
            }
            catch (Exception t) {
                LOGGER.error("saveAndRecordFail:" + t.getMessage(), (Throwable)t);
                tx.markRollback();
                throw t;
            }
        }
    }

    private void removeAlreadyPushed(List<BgdListResponseDTO> bgdList, BgdConfig config) {
        QFilter filter = new QFilter("billno", "in", (Object)bgdList.stream().map(BgdListResponseDTO::getCusCiqNo).toArray()).and("pushstatus", "=", (Object)BgdBillConstant.PushStatus.PUSHED);
        DynamicObject[] arrays = BusinessDataServiceHelper.load((String)"sim_declaration_bill", (String)"billno", (QFilter[])filter.toArray());
        if (arrays.length == 0) {
            return;
        }
        Set billNoSet = Arrays.stream(arrays).map(o -> o.getString("billno")).collect(Collectors.toSet());
        config.setAlreadyPushed(billNoSet.size());
        bgdList.removeIf(next -> billNoSet.contains(next.getCusCiqNo()));
    }

    @Override
    public List<BgdListResponseDTO> queryBgdList(BgdListRequestDTO requestDTO, BgdConfig config) {
        return BgdHelper.queryBgdList(requestDTO, config);
    }

    @Override
    public BgdDetailResponseDTO queryBgdDetail(BgdDetailRequestDTO requestDTO, BgdConfig config) {
        return BgdHelper.queryBgdDetail(requestDTO, config);
    }

    @Override
    public BgdExchangeRateResponseDTO queryExchangeRate(BgdExchangeRateRequestDTO requestDTO, BgdConfig config) {
        QFilter filter = new QFilter("bzdm", "=", (Object)requestDTO.getBzdm()).and("nf", "=", (Object)requestDTO.getNf()).and("yf", "=", (Object)requestDTO.getYf());
        DynamicObject[] array = BusinessDataServiceHelper.load((String)"bdm_cur_exchange_rate", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_cur_exchange_rate"), (QFilter[])filter.toArray());
        if (array.length > 0) {
            return (BgdExchangeRateResponseDTO)DynamicObjectUtil.dynamicObject2Bean(BgdExchangeRateResponseDTO.class, (DynamicObject)array[0]);
        }
        return BgdHelper.queryExchangeRate(requestDTO, config);
    }

    @Override
    public void calculate(DynamicObject bgdBill, BgdConfig config) {
        if ("3".equals(bgdBill.getString("feeMark"))) {
            BigDecimal feeAmount = bgdBill.getBigDecimal("feerate").multiply(bgdBill.getBigDecimal("feeexchangerate")).setScale(2, RoundingMode.HALF_UP);
            bgdBill.set("feeamount", (Object)feeAmount);
        }
        if ("3".equals(bgdBill.getString("insurMark"))) {
            BigDecimal insurAmount = bgdBill.getBigDecimal("insurrate").multiply(bgdBill.getBigDecimal("insurexchangerate")).setScale(2, RoundingMode.HALF_UP);
            bgdBill.set("insurlocalamount", (Object)insurAmount);
        }
        if ("3".equals(bgdBill.getString("otherMark"))) {
            BigDecimal otherAmount = bgdBill.getBigDecimal("otherrate").multiply(bgdBill.getBigDecimal("otherexchangerate")).setScale(2, RoundingMode.HALF_UP);
            bgdBill.set("otherlocalamount", (Object)otherAmount);
        }
        BigDecimal dealExchangeRate = bgdBill.getBigDecimal("dealexchangerate");
        bgdBill.set("dealtotalamount", (Object)bgdBill.getBigDecimal("dealtotalfromamount").multiply(dealExchangeRate).setScale(2, RoundingMode.HALF_UP));
        BigDecimal feeAmount = bgdBill.getBigDecimal("feeamount");
        BigDecimal otherAmount = bgdBill.getBigDecimal("otherlocalamount");
        BigDecimal insurAmount = bgdBill.getBigDecimal("insurlocalamount");
        String issueWay = bgdBill.getString("issueway");
        String transModeName = bgdBill.getString("transmodename");
        boolean rmbFobWay = BgdHelper.isRmbFobWay(issueWay, transModeName);
        DynamicObjectCollection items = bgdBill.getDynamicObjectCollection("items");
        int lastIndex = items.size() - 1;
        BigDecimal feeAndOther = feeAmount.add(otherAmount);
        BigDecimal threeAmount = feeAmount.add(otherAmount).add(insurAmount);
        BigDecimal lastTotalDeducAmount = BigDecimal.ZERO;
        BigDecimal totalFromAmount = BigDecimal.ZERO;
        BigDecimal totalIssueLocalAmount = BigDecimal.ZERO;
        BigDecimal totalDealAmount = BigDecimal.ZERO;
        for (DynamicObject item : items) {
            BigDecimal itemDealFromAmount = item.getBigDecimal("decltotal");
            BigDecimal itemDealAmount = itemDealFromAmount.multiply(dealExchangeRate).setScale(UnitPriceHelper.MONEY_ACCURACY, RoundingMode.HALF_UP).setScale(2, RoundingMode.HALF_UP);
            totalFromAmount = totalFromAmount.add(itemDealFromAmount);
            totalDealAmount = totalDealAmount.add(itemDealAmount);
        }
        bgdBill.set("dealtotalfromamount", (Object)totalFromAmount);
        bgdBill.set("dealtotalamount", (Object)totalDealAmount);
        DynamicObject tradeCurr = bgdBill.getDynamicObject("tradecurr");
        DynamicObject dollarCurr = bgdBill.getDynamicObject("dollar");
        BigDecimal totalOriginalIssueAmount = BigDecimal.ZERO;
        for (int i = 0; i < items.size(); ++i) {
            DynamicObject item = (DynamicObject)items.get(i);
            item.set("deallocalamount", (Object)item.getBigDecimal("decltotal").multiply(dealExchangeRate).setScale(2, RoundingMode.HALF_UP));
            item.set("deallocalprice", (Object)PriceHelper.getValue((BigDecimal)item.getBigDecimal("declprice").multiply(dealExchangeRate), (boolean)true));
            BigDecimal dealNum = item.getBigDecimal("gqty");
            BigDecimal issueNum = BgdHelper.getIssueNum(item, config);
            if (!BigDecimalUtil.compareZero((BigDecimal)dealNum)) {
                item.set("deallocalprice", (Object)PriceHelper.calcPriceOrNum((BigDecimal)item.getBigDecimal("deallocalamount"), (BigDecimal)dealNum, (boolean)true));
            }
            BigDecimal deducAmount = BigDecimal.ZERO;
            BigDecimal dealTotalFromAmount = item.getBigDecimal("decltotal");
            if (rmbFobWay) {
                item.set("issueamount", item.get("deallocalamount"));
            } else if ("C&F".equals(transModeName)) {
                if (i != lastIndex) {
                    deducAmount = dealTotalFromAmount.divide(totalFromAmount, 20, RoundingMode.HALF_UP).multiply(feeAndOther).setScale(2, RoundingMode.HALF_UP);
                    lastTotalDeducAmount = lastTotalDeducAmount.add(deducAmount);
                } else {
                    deducAmount = feeAndOther.subtract(lastTotalDeducAmount).setScale(2, RoundingMode.HALF_UP);
                }
            } else if ("CIF".equals(transModeName)) {
                if (i != lastIndex) {
                    deducAmount = dealTotalFromAmount.divide(totalFromAmount, 20, RoundingMode.HALF_UP).multiply(threeAmount).setScale(2, RoundingMode.HALF_UP);
                    lastTotalDeducAmount = lastTotalDeducAmount.add(deducAmount);
                } else {
                    deducAmount = threeAmount.subtract(lastTotalDeducAmount).setScale(2, RoundingMode.HALF_UP);
                }
            }
            item.set("deductamount", (Object)deducAmount);
            item.set("issueamount", (Object)item.getBigDecimal("deallocalamount").subtract(deducAmount));
            item.set("unpushamount", (Object)item.getBigDecimal("issueamount"));
            item.set("issuenum", (Object)issueNum);
            if (!BigDecimalUtil.compareZero((BigDecimal)issueNum)) {
                item.set("issueprice", (Object)PriceHelper.calcPriceOrNum((BigDecimal)item.getBigDecimal("issueamount"), (BigDecimal)issueNum, (boolean)true));
            } else {
                item.set("issueprice", (Object)BigDecimal.ZERO);
            }
            totalIssueLocalAmount = totalIssueLocalAmount.add(item.getBigDecimal("issueamount"));
            BigDecimal dollarIssueAmount = item.getBigDecimal("issuedolaramount");
            BigDecimal issueRmbAmount = item.getBigDecimal("issueamount");
            if (BgdHelper.isEqualsCurr(dollarCurr, tradeCurr)) {
                if (!BigDecimalUtil.compareZero((BigDecimal)dollarIssueAmount)) {
                    item.set("issueoriginamount", (Object)dollarIssueAmount);
                } else if (!BigDecimalUtil.compareZero((BigDecimal)dealExchangeRate)) {
                    item.set("issueoriginamount", (Object)issueRmbAmount.divide(dealExchangeRate, 2, RoundingMode.HALF_UP));
                }
            } else if (!BigDecimalUtil.compareZero((BigDecimal)dealExchangeRate)) {
                item.set("issueoriginamount", (Object)issueRmbAmount.divide(dealExchangeRate, 2, RoundingMode.HALF_UP));
            }
            totalOriginalIssueAmount = totalOriginalIssueAmount.add(item.getBigDecimal("issueoriginamount"));
        }
        bgdBill.set("issuetotalamount", (Object)totalIssueLocalAmount);
        bgdBill.set("issuefromamount", (Object)totalOriginalIssueAmount);
        bgdBill.set("totalunpushamount", (Object)totalIssueLocalAmount);
    }

    @Override
    public void logBgdRecord(List<DynamicObject> updateAndNewList, BgdConfig config) {
        try {
            DeclarationRecordHelper.saveDeclarationRecord((String)config.getBatchNo(), (Long)config.getOrg().getLong("id"), (int)(config.getNewNum() + config.getUpdateNum()), (int)config.getFailNum(), (String)RequestContext.get().getTraceId());
            Map detailMap = config.getDetailMap();
            if (detailMap.size() > 0) {
                this.saleDetailLog(detailMap);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private void saleDetailLog(Map<String, String> detailMap) {
        DeleteServiceHelper.delete((String)"invsm_botp_callback_log", (QFilter[])new QFilter("invoiceno", "in", (Object)detailMap.keySet().toArray()).toArray());
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        Date date = new Date();
        Set<Map.Entry<String, String>> entries = detailMap.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"invsm_botp_callback_log");
            log.set("createtime", (Object)date);
            log.set("invoiceno", (Object)entry.getKey());
            log.set("param_tag", (Object)entry.getValue());
            list.add(log);
        }
        if (list.size() > 0) {
            ImcSaveServiceHelper.save(list);
        }
    }

    @Override
    public void filter(List<BgdListResponseDTO> bgdList, BgdConfig config, BgdCollectDTO dto) {
        if (COMPLETE.equals(dto.getCompleteStatusCode())) {
            bgdList.removeIf(nextBill -> !"10".equals(nextBill.getCusDecStatus()));
        }
    }
}

