/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.delclarationbill;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.sim.common.dto.bgd.config.BgdConfig;
import kd.imc.sim.common.dto.bgd.service.BgdCollectDTO;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.helper.issueinvoice.UnitPriceHelper;
import kd.imc.sim.declarationbill.helper.BgdHelper;

public class DeclarationFormControl {
    public static void editIssueRule(AbstractFormPlugin plugin, String name, Object newValue, Object oldValue) {
        IFormView view = plugin.getView();
        if (null == newValue) {
            view.getModel().setValue(name, oldValue);
            view.showTipNotification(ResManager.loadKDString((String)"\u62a5\u5173\u5355\u5f00\u7968\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a", (String)"DeclarationFormControl_0", (String)"imc-sim-service", (Object[])new Object[0]));
            return;
        }
        Date ieDate = (Date)view.getModel().getValue("iedate");
        if (null == ieDate) {
            view.getModel().setValue(name, oldValue);
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u51fa\u53e3\u65e5\u671f", (String)"DeclarationFormControl_1", (String)"imc-sim-service", (Object[])new Object[0]));
            return;
        }
        DeclarationFormControl.editIssueRule(plugin, oldValue, newValue);
    }

    public static void editIssuePrice(AbstractFormPlugin plugin, Object oldValue, Object newValue, int editIndex) {
        IFormView view = plugin.getView();
        if (BigDecimalUtil.lessZero((BigDecimal)((BigDecimal)newValue))) {
            plugin.getPageCache().put("not_property_change" + view.getPageId(), "id");
            view.getModel().setValue("issueprice", oldValue, editIndex);
            view.showTipNotification(ResManager.loadKDString((String)"\u5355\u4ef7\u4e0d\u80fd\u5c0f\u4e8e0", (String)"DeclarationFormControl_2", (String)"imc-sim-service", (Object[])new Object[0]));
            plugin.getPageCache().remove("not_property_change" + view.getPageId());
            return;
        }
        BigDecimal dollarAmount = (BigDecimal)view.getModel().getValue("issuedolaramount", editIndex);
        if (!BigDecimalUtil.compareZero((BigDecimal)dollarAmount)) {
            plugin.getPageCache().put("not_property_change" + view.getPageId(), "id");
            view.getModel().setValue("issueprice", oldValue, editIndex);
            plugin.getPageCache().remove("not_property_change" + view.getPageId());
            return;
        }
        BigDecimal issuePrice = (BigDecimal)newValue;
        DynamicObjectCollection itemList = view.getModel().getEntryEntity("items");
        DynamicObject item = (DynamicObject)itemList.get(editIndex);
        BgdConfig baseConfig = BgdHelper.getBaseConfig((DynamicObject)view.getModel().getValue("issuerule"));
        BigDecimal issueNum = BgdHelper.getIssueNum(item, baseConfig);
        view.getModel().beginInit();
        BigDecimal issueAmount = issuePrice.multiply(issueNum).setScale(UnitPriceHelper.MONEY_ACCURACY, RoundingMode.HALF_UP);
        view.getModel().setValue("issueamount", (Object)issueAmount, editIndex);
        BigDecimal dealExchangeRate = (BigDecimal)view.getModel().getValue("dealexchangerate");
        if (!BigDecimalUtil.compareZero((BigDecimal)dealExchangeRate)) {
            BigDecimal issueOriginalAmount = issueAmount.divide(dealExchangeRate, 2, RoundingMode.HALF_UP);
            view.getModel().setValue("issueoriginamount", (Object)issueOriginalAmount, editIndex);
        }
        view.getModel().setValue("unpushamount", (Object)issuePrice.multiply(issueNum).setScale(UnitPriceHelper.MONEY_ACCURACY, RoundingMode.HALF_UP), editIndex);
        view.getModel().endInit();
        view.updateView("issueamount", editIndex);
        view.updateView("issueoriginamount", editIndex);
        view.updateView("unpushamount", editIndex);
        DeclarationFormControl.countHeadAmount(plugin);
    }

    private static void countHeadAmount(AbstractFormPlugin plugin) {
        IFormView view = plugin.getView();
        DynamicObjectCollection itemList = view.getModel().getEntryEntity("items");
        BigDecimal totalIssueAmount = BigDecimal.ZERO;
        BigDecimal totalDealFromAmount = BigDecimal.ZERO;
        BigDecimal totalDealAmount = BigDecimal.ZERO;
        BigDecimal totalIssueDollarAmount = BigDecimal.ZERO;
        BigDecimal totalFromAmount = BigDecimal.ZERO;
        for (int i = 0; i < itemList.size(); ++i) {
            DynamicObject item = (DynamicObject)itemList.get(i);
            BigDecimal itemIssueAmount = item.getBigDecimal("issueamount");
            BigDecimal itemDealFromAmount = item.getBigDecimal("decltotal");
            BigDecimal itemDealAmount = item.getBigDecimal("deallocalamount");
            BigDecimal itemDollarAmount = item.getBigDecimal("issuedolaramount");
            BigDecimal itemFromAmount = item.getBigDecimal("issueoriginamount");
            totalIssueAmount = totalIssueAmount.add(itemIssueAmount);
            totalDealFromAmount = totalDealFromAmount.add(itemDealFromAmount);
            totalDealAmount = totalDealAmount.add(itemDealAmount);
            totalIssueDollarAmount = totalIssueDollarAmount.add(itemDollarAmount);
            totalFromAmount = totalFromAmount.add(itemFromAmount);
        }
        view.getModel().setValue("issuetotalamount", (Object)totalIssueAmount);
        view.getModel().setValue("totalunpushamount", (Object)totalIssueAmount);
        view.getModel().setValue("dealtotalamount", (Object)totalDealAmount);
        view.getModel().setValue("dealtotalfromamount", (Object)totalDealFromAmount);
        view.getModel().setValue("issuedollartotalamount", (Object)totalIssueDollarAmount);
        view.getModel().setValue("issuefromamount", (Object)totalFromAmount);
        DeclarationFormControl.updateFields(plugin, "issuetotalamount", "totalunpushamount", "dealtotalamount", "dealtotalfromamount", "issuedollartotalamount", "issuefromamount");
    }

    public static void editIssueAmount(AbstractFormPlugin plugin, Object oldValue, Object newValue, int editIndex) {
        IFormView view = plugin.getView();
        if (BigDecimalUtil.lessZero((BigDecimal)((BigDecimal)newValue))) {
            plugin.getPageCache().put("not_property_change" + view.getPageId(), "id");
            view.getModel().setValue("issueamount", oldValue, editIndex);
            view.showTipNotification(ResManager.loadKDString((String)"\u5f00\u7968\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0", (String)"DeclarationFormControl_3", (String)"imc-sim-service", (Object[])new Object[0]));
            plugin.getPageCache().remove("not_property_change" + view.getPageId());
            return;
        }
        BigDecimal dollarAmount = (BigDecimal)view.getModel().getValue("issuedolaramount", editIndex);
        if (!BigDecimalUtil.compareZero((BigDecimal)dollarAmount)) {
            plugin.getPageCache().put("not_property_change" + view.getPageId(), "id");
            view.getModel().setValue("issueamount", oldValue, editIndex);
            plugin.getPageCache().remove("not_property_change" + view.getPageId());
            return;
        }
        BigDecimal issueAmount = (BigDecimal)newValue;
        DynamicObjectCollection itemList = view.getModel().getEntryEntity("items");
        DynamicObject item = (DynamicObject)itemList.get(editIndex);
        BgdConfig baseConfig = BgdHelper.getBaseConfig((DynamicObject)view.getModel().getValue("issuerule"));
        BigDecimal issueNum = BgdHelper.getIssueNum(item, baseConfig);
        DynamicObject tradeCurr = (DynamicObject)view.getModel().getValue("tradecurr");
        DynamicObject dollarCurr = (DynamicObject)view.getModel().getValue("dollar");
        BigDecimal dealExchangeRate = (BigDecimal)view.getModel().getValue("dealexchangerate");
        view.getModel().beginInit();
        if (tradeCurr == dollarCurr && dollarAmount.compareTo(BigDecimal.ZERO) != 0) {
            view.getModel().setValue("issueoriginamount", (Object)dollarAmount, editIndex);
        } else {
            BigDecimal originAmount = DeclarationFormControl.rateConverter(issueAmount, dealExchangeRate, false);
            view.getModel().setValue("issueoriginamount", (Object)originAmount, editIndex);
        }
        view.getModel().setValue("issueprice", (Object)PriceHelper.calcPriceOrNum((BigDecimal)issueAmount, (BigDecimal)issueNum, (boolean)true), editIndex);
        view.getModel().setValue("unpushamount", newValue, editIndex);
        view.getModel().endInit();
        view.updateView("issueprice", editIndex);
        view.updateView("unpushamount", editIndex);
        view.updateView("issueoriginamount", editIndex);
        DeclarationFormControl.countHeadAmount(plugin);
    }

    public static void updateItemFields(AbstractFormPlugin plugin, DynamicObjectCollection items, String ... fields) {
        for (int i = 0; i < items.size(); ++i) {
            for (String field : fields) {
                plugin.getView().updateView(field, i);
            }
        }
    }

    public static void calculateAllIssueAmount(AbstractFormPlugin plugin) {
        int i;
        IFormView view = plugin.getView();
        BgdConfig baseConfig = BgdHelper.getBaseConfig((DynamicObject)view.getModel().getValue("issuerule"));
        String value = (String)view.getModel().getValue("issueway");
        if (StringUtils.isNotBlank((CharSequence)value)) {
            baseConfig.setIssueConfig(value);
        }
        DynamicObjectCollection items = view.getModel().getEntryEntity("items");
        String transModeName = (String)view.getModel().getValue("transmodename");
        BigDecimal totalFromAmount = (BigDecimal)view.getModel().getValue("dealtotalfromamount");
        BigDecimal feeAmount = (BigDecimal)view.getModel().getValue("feeamount");
        BigDecimal otherAmount = (BigDecimal)view.getModel().getValue("otherlocalamount");
        BigDecimal insurAmount = (BigDecimal)view.getModel().getValue("insurlocalamount");
        BigDecimal dollarExchangeRate = (BigDecimal)view.getModel().getValue("dollarexchangerate");
        BigDecimal dealExchangeRate = (BigDecimal)view.getModel().getValue("dealexchangerate");
        DynamicObject dollarCurr = (DynamicObject)view.getModel().getValue("dollar");
        DynamicObject tradeCurr = (DynamicObject)view.getModel().getValue("tradecurr");
        BigDecimal feeAndOther = feeAmount.add(otherAmount);
        BigDecimal threeAmount = feeAmount.add(otherAmount).add(insurAmount);
        int lastIndex = items.size() - 1;
        BigDecimal lastTotalDeducAmount = BigDecimal.ZERO;
        BigDecimal totalIssueLocalAmount = BigDecimal.ZERO;
        BigDecimal totalOriginalIssueAmount = BigDecimal.ZERO;
        BigDecimal dealTotalRmbAmount = BigDecimal.ZERO;
        view.getModel().beginInit();
        boolean containsDollarAmount = false;
        for (i = 0; i < items.size(); ++i) {
            DynamicObject item = (DynamicObject)items.get(i);
            BigDecimal dollarIssuedAmount = item.getBigDecimal("issuedolaramount");
            if (BigDecimalUtil.compareZero((BigDecimal)dollarIssuedAmount)) continue;
            containsDollarAmount = true;
        }
        for (i = 0; i < items.size(); ++i) {
            BigDecimal deducAmount = BigDecimal.ZERO;
            DynamicObject item = (DynamicObject)items.get(i);
            BigDecimal dollarIssuedAmount = item.getBigDecimal("issuedolaramount");
            if (BigDecimalUtil.compareZero((BigDecimal)dollarIssuedAmount) || BigDecimalUtil.compareZero((BigDecimal)dollarExchangeRate)) {
                BigDecimal issueNum = BgdHelper.getIssueNum(item, baseConfig);
                BigDecimal dealTotalFromAmount = item.getBigDecimal("decltotal");
                if (!BgdHelper.isRmbFobWay(baseConfig.getIssueConfig(), transModeName)) {
                    if ("C&F".equals(transModeName)) {
                        if (i != lastIndex) {
                            deducAmount = dealTotalFromAmount.divide(totalFromAmount, 2, RoundingMode.HALF_UP).multiply(feeAndOther);
                            lastTotalDeducAmount = lastTotalDeducAmount.add(deducAmount);
                        } else {
                            deducAmount = containsDollarAmount ? dealTotalFromAmount.divide(totalFromAmount, 2, RoundingMode.HALF_UP).multiply(feeAndOther) : feeAndOther.subtract(lastTotalDeducAmount);
                        }
                    } else if ("CIF".equals(transModeName)) {
                        if (i != lastIndex) {
                            deducAmount = dealTotalFromAmount.divide(totalFromAmount, 2, RoundingMode.HALF_UP).multiply(feeAndOther);
                            lastTotalDeducAmount = lastTotalDeducAmount.add(deducAmount);
                        } else {
                            deducAmount = containsDollarAmount ? dealTotalFromAmount.divide(totalFromAmount, 2, RoundingMode.HALF_UP).multiply(feeAndOther) : threeAmount.subtract(lastTotalDeducAmount);
                        }
                    }
                }
                view.getModel().setValue("deductamount", (Object)deducAmount, i);
                BigDecimal declTotal = item.getBigDecimal("decltotal");
                BigDecimal dealLocalAmount = declTotal.multiply(dealExchangeRate).setScale(2, RoundingMode.HALF_UP);
                item.set("deallocalamount", (Object)dealLocalAmount);
                BigDecimal dealNum = item.getBigDecimal("gqty");
                if (!BigDecimalUtil.compareZero((BigDecimal)dealNum)) {
                    item.set("deallocalprice", (Object)PriceHelper.calcPriceOrNum((BigDecimal)dealLocalAmount, (BigDecimal)dealNum, (boolean)true));
                }
                BigDecimal subtract = item.getBigDecimal("deallocalamount").subtract(deducAmount).setScale(2, RoundingMode.HALF_UP);
                view.getModel().setValue("issueamount", (Object)subtract, i);
                view.getModel().setValue("unpushamount", (Object)subtract, i);
                view.getModel().setValue("issuenum", (Object)issueNum, i);
                if (!BigDecimalUtil.compareZero((BigDecimal)issueNum)) {
                    view.getModel().setValue("issueprice", (Object)PriceHelper.calcPriceOrNum((BigDecimal)item.getBigDecimal("issueamount"), (BigDecimal)issueNum, (boolean)true), i);
                } else {
                    view.getModel().setValue("issueprice", (Object)BigDecimal.ZERO, i);
                }
            } else {
                BigDecimal issueAmount = DeclarationFormControl.rateConverter(dollarIssuedAmount, dollarExchangeRate, true);
                BigDecimal issueNum = (BigDecimal)view.getModel().getValue("issuenum", i);
                view.getModel().setValue("issueamount", (Object)issueAmount, i);
                view.getModel().setValue("issueprice", (Object)PriceHelper.calcPriceOrNum((BigDecimal)issueAmount, (BigDecimal)issueNum, (boolean)true), i);
                view.getModel().setValue("unpushamount", (Object)issueAmount, i);
            }
            totalIssueLocalAmount = totalIssueLocalAmount.add(item.getBigDecimal("issueamount"));
            BigDecimal dollarIssueAmount = (BigDecimal)item.get("issuedolaramount");
            BigDecimal issueRmbAmount = (BigDecimal)item.get("issueamount");
            if (BgdHelper.isEqualsCurr(dollarCurr, tradeCurr)) {
                if (!BigDecimalUtil.compareZero((BigDecimal)dollarIssueAmount)) {
                    view.getModel().setValue("issueoriginamount", (Object)dollarIssueAmount, i);
                } else if (!BigDecimalUtil.compareZero((BigDecimal)dealExchangeRate)) {
                    view.getModel().setValue("issueoriginamount", (Object)issueRmbAmount.divide(dealExchangeRate, 2, RoundingMode.HALF_UP), i);
                }
            } else if (!BigDecimalUtil.compareZero((BigDecimal)dealExchangeRate)) {
                view.getModel().setValue("issueoriginamount", (Object)issueRmbAmount.divide(dealExchangeRate, 2, RoundingMode.HALF_UP), i);
            }
            totalOriginalIssueAmount = totalOriginalIssueAmount.add(item.getBigDecimal("issueoriginamount"));
            dealTotalRmbAmount = dealTotalRmbAmount.add(item.getBigDecimal("deallocalamount"));
        }
        view.getModel().setValue("dealtotalamount", (Object)dealTotalRmbAmount);
        view.getModel().setValue("issuetotalamount", (Object)totalIssueLocalAmount);
        view.getModel().setValue("issuefromamount", (Object)totalOriginalIssueAmount);
        view.getModel().setValue("totalunpushamount", (Object)totalIssueLocalAmount);
        view.getModel().endInit();
        DeclarationFormControl.updateItemFields(plugin, items, "deductamount", "issueamount", "issueprice", "issuenum", "unpushamount", "deallocalprice", "issueoriginamount", "deallocalamount");
        DeclarationFormControl.updateFields(plugin, "issuetotalamount", "totalunpushamount", "issuefromamount", "dealtotalfromamount", "dealtotalamount");
    }

    public static void editOtherExchangeRate(AbstractFormPlugin plugin, Object oldValue, Object newValue) {
        IFormView view = plugin.getView();
        if (!BigDecimalUtil.greaterZero((BigDecimal)((BigDecimal)newValue))) {
            plugin.getPageCache().put("not_property_change" + view.getPageId(), "id");
            view.getModel().setValue("otherexchangerate", oldValue);
            view.showTipNotification(ResManager.loadKDString((String)"\u6c47\u7387\u5fc5\u987b\u5927\u4e8e0", (String)"DeclarationFormControl_4", (String)"imc-sim-service", (Object[])new Object[0]));
            plugin.getPageCache().remove("not_property_change" + view.getPageId());
            return;
        }
        Object otherMark = view.getModel().getValue("otherMark");
        BigDecimal newExchangeRate = ((BigDecimal)newValue).setScale(4, RoundingMode.HALF_UP);
        DynamicObject otherCurr = (DynamicObject)view.getModel().getValue("othercurr");
        DeclarationFormControl.updateAllExchangeRate(plugin, newExchangeRate, otherCurr);
        if ("3".equals(otherMark)) {
            BigDecimal otherRate = (BigDecimal)view.getModel().getValue("otherrate");
            view.getModel().setValue("otherlocalamount", (Object)otherRate.multiply(newExchangeRate).setScale(UnitPriceHelper.MONEY_ACCURACY, RoundingMode.HALF_UP));
        }
    }

    public static void editInsurExchangeRate(AbstractFormPlugin plugin, Object oldValue, Object newValue) {
        IFormView view = plugin.getView();
        if (!BigDecimalUtil.greaterZero((BigDecimal)((BigDecimal)newValue))) {
            plugin.getPageCache().put("not_property_change" + view.getPageId(), "id");
            view.getModel().setValue("otherexchangerate", oldValue);
            view.showTipNotification(ResManager.loadKDString((String)"\u6c47\u7387\u5fc5\u987b\u5927\u4e8e0", (String)"DeclarationFormControl_4", (String)"imc-sim-service", (Object[])new Object[0]));
            plugin.getPageCache().remove("not_property_change" + view.getPageId());
            return;
        }
        Object insurMark = view.getModel().getValue("insurMark");
        BigDecimal newExchangeRate = ((BigDecimal)newValue).setScale(4, RoundingMode.HALF_UP);
        DynamicObject insurCurr = (DynamicObject)view.getModel().getValue("insurcurr");
        DeclarationFormControl.updateAllExchangeRate(plugin, newExchangeRate, insurCurr);
        view.updateView("insurexchangerate");
        if ("3".equals(insurMark)) {
            BigDecimal insurRate = (BigDecimal)view.getModel().getValue("insurrate");
            view.getModel().setValue("insurlocalamount", (Object)insurRate.multiply(newExchangeRate).setScale(UnitPriceHelper.MONEY_ACCURACY, RoundingMode.HALF_UP));
        }
    }

    public static void editFeeExchangeRate(AbstractFormPlugin plugin, Object oldValue, Object newValue) {
        IFormView view = plugin.getView();
        if (!BigDecimalUtil.greaterZero((BigDecimal)((BigDecimal)newValue))) {
            plugin.getPageCache().put("not_property_change" + view.getPageId(), "id");
            view.getModel().setValue("feeexchangerate", oldValue);
            view.showTipNotification(ResManager.loadKDString((String)"\u6c47\u7387\u5fc5\u987b\u5927\u4e8e0", (String)"DeclarationFormControl_4", (String)"imc-sim-service", (Object[])new Object[0]));
            plugin.getPageCache().remove("not_property_change" + view.getPageId());
            return;
        }
        Object feeMark = view.getModel().getValue("feeMark");
        BigDecimal newExchangeRate = ((BigDecimal)newValue).setScale(4, RoundingMode.HALF_UP);
        DynamicObject feeCurr = (DynamicObject)view.getModel().getValue("feecurr");
        DeclarationFormControl.updateAllExchangeRate(plugin, newExchangeRate, feeCurr);
        view.updateView("feeexchangerate");
        if ("3".equals(feeMark)) {
            BigDecimal feeRate = (BigDecimal)view.getModel().getValue("feerate");
            view.getModel().setValue("feeamount", (Object)feeRate.multiply(newExchangeRate).setScale(UnitPriceHelper.MONEY_ACCURACY, RoundingMode.HALF_UP));
        }
    }

    public static void updateFields(AbstractFormPlugin plugin, String ... fields) {
        for (String field : fields) {
            plugin.getView().updateView(field);
        }
    }

    public static void editDealExchangeRate(AbstractFormPlugin plugin, String name, BigDecimal newValue, Object oldValue) {
        IFormView view = plugin.getView();
        if (!BigDecimalUtil.greaterZero((BigDecimal)newValue)) {
            plugin.getPageCache().put("not_property_change" + view.getPageId(), "id");
            view.showTipNotification(ResManager.loadKDString((String)"\u6c47\u7387\u5fc5\u987b\u5927\u4e8e0", (String)"DeclarationFormControl_4", (String)"imc-sim-service", (Object[])new Object[0]));
            view.getModel().setValue(name, oldValue);
            plugin.getPageCache().remove("not_property_change" + view.getPageId());
            return;
        }
        DynamicObjectCollection items = view.getModel().getEntryEntity("items");
        BigDecimal totalDealAmount = BigDecimal.ZERO;
        BigDecimal newExchangeRate = newValue.setScale(4, RoundingMode.HALF_UP);
        DynamicObject tradeCurr = (DynamicObject)view.getModel().getValue("tradecurr");
        DeclarationFormControl.updateAllExchangeRate(plugin, newExchangeRate, tradeCurr);
        view.getModel().beginInit();
        for (int i = 0; i < items.size(); ++i) {
            BigDecimal dealFromAmount = ((DynamicObject)items.get(i)).getBigDecimal("decltotal");
            BigDecimal dealNum = ((DynamicObject)items.get(i)).getBigDecimal("gqty");
            BigDecimal dealAmount = dealFromAmount.multiply(newExchangeRate).setScale(UnitPriceHelper.MONEY_ACCURACY, RoundingMode.HALF_UP);
            view.getModel().setValue("deallocalamount", (Object)dealAmount, i);
            if (BigDecimalUtil.greaterZero((BigDecimal)dealNum)) {
                BigDecimal dealPrice = PriceHelper.calTaxUnitPrice((BigDecimal)dealAmount, (BigDecimal)dealNum, (boolean)true);
                view.getModel().setValue("deallocalprice", (Object)dealPrice, i);
            }
            totalDealAmount = totalDealAmount.add(dealAmount);
        }
        view.getModel().setValue("dealtotalamount", (Object)totalDealAmount);
        view.getModel().endInit();
        DeclarationFormControl.updateItemFields(plugin, items, "deallocalamount", "deallocalprice");
        DeclarationFormControl.updateFields(plugin, "dealtotalamount");
    }

    public static void editOtherAmount(AbstractFormPlugin plugin, Object oldValue, Object newValue) {
        IFormView view = plugin.getView();
        if (BigDecimalUtil.lessZero((BigDecimal)((BigDecimal)newValue))) {
            plugin.getPageCache().put("not_property_change" + view.getPageId(), "id");
            view.showTipNotification(ResManager.loadKDString((String)"\u6742\u8d39\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0", (String)"DeclarationFormControl_5", (String)"imc-sim-service", (Object[])new Object[0]));
            view.getModel().setValue("otherlocalamount", oldValue);
            plugin.getPageCache().remove("not_property_change" + view.getPageId());
            return;
        }
        BigDecimal amount = (BigDecimal)newValue;
        view.getModel().beginInit();
        Object otherMark = view.getModel().getValue("otherMark");
        BigDecimal otherExchangeRate = (BigDecimal)view.getModel().getValue("otherexchangerate");
        if ("3".equals(otherMark) && !BigDecimalUtil.compareZero((BigDecimal)otherExchangeRate)) {
            BigDecimal insurRate = amount.divide(otherExchangeRate, 2, RoundingMode.HALF_UP);
            view.getModel().setValue("otherrate", (Object)insurRate);
        }
        view.getModel().endInit();
        view.updateView("otherrate");
        DeclarationFormControl.calculateAllIssueAmount(plugin);
    }

    public static void editFeeAmount(AbstractFormPlugin plugin, Object oldValue, Object newValue) {
        IFormView view = plugin.getView();
        if (BigDecimalUtil.lessZero((BigDecimal)((BigDecimal)newValue))) {
            plugin.getPageCache().put("not_property_change" + view.getPageId(), "id");
            view.showTipNotification(ResManager.loadKDString((String)"\u8fd0\u8d39\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0", (String)"DeclarationFormControl_6", (String)"imc-sim-service", (Object[])new Object[0]));
            view.getModel().setValue("feeamount", oldValue);
            plugin.getPageCache().remove("not_property_change" + view.getPageId());
            return;
        }
        BigDecimal amount = (BigDecimal)newValue;
        view.getModel().beginInit();
        Object feeMark = view.getModel().getValue("feeMark");
        BigDecimal feeExchangeRate = (BigDecimal)view.getModel().getValue("feeexchangerate");
        if ("3".equals(feeMark) && !BigDecimalUtil.compareZero((BigDecimal)feeExchangeRate)) {
            BigDecimal feeRate = amount.divide(feeExchangeRate, 2, RoundingMode.HALF_UP);
            view.getModel().setValue("feerate", (Object)feeRate);
        }
        view.getModel().endInit();
        view.updateView("feerate");
        DeclarationFormControl.calculateAllIssueAmount(plugin);
    }

    public static void editInsurAmount(AbstractFormPlugin plugin, Object oldValue, Object newValue) {
        IFormView view = plugin.getView();
        if (BigDecimalUtil.lessZero((BigDecimal)((BigDecimal)newValue))) {
            plugin.getPageCache().put("not_property_change" + view.getPageId(), "id");
            view.showTipNotification(ResManager.loadKDString((String)"\u4fdd\u8d39\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0", (String)"DeclarationFormControl_7", (String)"imc-sim-service", (Object[])new Object[0]));
            view.getModel().setValue("insurlocalamount", oldValue);
            plugin.getPageCache().remove("not_property_change" + view.getPageId());
            return;
        }
        BigDecimal amount = (BigDecimal)newValue;
        view.getModel().beginInit();
        Object insurMark = view.getModel().getValue("insurMark");
        BigDecimal insurExchangeRate = (BigDecimal)view.getModel().getValue("insurexchangerate");
        if ("3".equals(insurMark) && !BigDecimalUtil.compareZero((BigDecimal)insurExchangeRate)) {
            BigDecimal insurRate = amount.divide(insurExchangeRate, 2, RoundingMode.HALF_UP);
            view.getModel().setValue("insurrate", (Object)insurRate);
        }
        view.getModel().endInit();
        view.updateView("insurrate");
        DeclarationFormControl.calculateAllIssueAmount(plugin);
    }

    public static void editIssueRule(AbstractFormPlugin plugin, Object oldValue, Object newRule) {
        IFormView view = plugin.getView();
        BgdCollectDTO dto = new BgdCollectDTO();
        dto.setOrg((DynamicObject)view.getModel().getValue("org"));
        Date ieDate = (Date)view.getModel().getValue("iedate");
        dto.setStart(ieDate);
        dto.setEnd(ieDate);
        BgdConfig config = BgdHelper.getBgdConfig(dto, (DynamicObject)newRule);
        DynamicObject tradeCurrency = (DynamicObject)view.getModel().getValue("tradecurr");
        BigDecimal tradeExchangeRate = BgdHelper.getExchangeRate(ieDate, tradeCurrency, config);
        DynamicObject otherCurrency = (DynamicObject)view.getModel().getValue("othercurr");
        BigDecimal otherExchangeRate = BgdHelper.getExchangeRate(ieDate, otherCurrency, config);
        DynamicObject insurCurrency = (DynamicObject)view.getModel().getValue("insurcurr");
        BigDecimal insurExchangeRate = BgdHelper.getExchangeRate(ieDate, insurCurrency, config);
        DynamicObject feeCurrency = (DynamicObject)view.getModel().getValue("feecurr");
        BigDecimal feeExchangeRate = BgdHelper.getExchangeRate(ieDate, feeCurrency, config);
        view.getModel().beginInit();
        view.getModel().setValue("dealexchangerate", (Object)tradeExchangeRate);
        view.getModel().setValue("feeexchangerate", (Object)feeExchangeRate);
        view.getModel().setValue("insurexchangerate", (Object)insurExchangeRate);
        view.getModel().setValue("otherexchangerate", (Object)otherExchangeRate);
        view.getModel().endInit();
        DeclarationFormControl.updateFields(plugin, "dealexchangerate", "feeexchangerate", "insurexchangerate", "otherexchangerate");
        DeclarationFormControl.calculateAllIssueAmount(plugin);
    }

    public static boolean isFieldNotBlank(Object value) {
        if (value instanceof BigDecimal && BigDecimalUtil.compareZero((BigDecimal)((BigDecimal)value))) {
            return false;
        }
        String str = String.valueOf(value);
        if (BigDecimalUtil.isNumber((String)str) && BigDecimalUtil.compareZero((BigDecimal)new BigDecimal(str))) {
            return false;
        }
        return StringUtils.isNotBlank((Object)value);
    }

    public static void editIssueAmountByDollar(AbstractFormPlugin plugin, Object oldValue, Object newValue, int editIndex) {
        IFormView view = plugin.getView();
        DynamicObject dollarCurr = (DynamicObject)view.getModel().getValue("dollar");
        BigDecimal rate = (BigDecimal)view.getModel().getValue("dollarexchangerate");
        BigDecimal dollarAmount = (BigDecimal)newValue;
        BigDecimal issueAmount = DeclarationFormControl.rateConverter(dollarAmount, rate, true);
        DynamicObjectCollection itemList = view.getModel().getEntryEntity("items");
        DynamicObject item = (DynamicObject)itemList.get(editIndex);
        BgdConfig baseConfig = BgdHelper.getBaseConfig((DynamicObject)view.getModel().getValue("issuerule"));
        BigDecimal issueNum = BgdHelper.getIssueNum(item, baseConfig);
        BigDecimal issuePrice = PriceHelper.calcPriceOrNum((BigDecimal)issueAmount, (BigDecimal)issueNum, (boolean)true);
        DynamicObject curr = (DynamicObject)view.getModel().getValue("tradecurr");
        BigDecimal dealExchangeRate = (BigDecimal)view.getModel().getValue("dealexchangerate");
        view.getModel().beginInit();
        view.getModel().setValue("issueamount", (Object)issueAmount, editIndex);
        view.getModel().setValue("unpushamount", (Object)issueAmount, editIndex);
        if (BgdHelper.isEqualsCurr(curr, dollarCurr)) {
            view.getModel().setValue("issueoriginamount", (Object)dollarAmount, editIndex);
        } else if (!BigDecimalUtil.compareZero((BigDecimal)dealExchangeRate)) {
            BigDecimal issueOriginalAmount = issueAmount.divide(dealExchangeRate, 2, 4);
            view.getModel().setValue("issueoriginamount", (Object)issueOriginalAmount, editIndex);
        }
        view.getModel().setValue("issueprice", (Object)issuePrice, editIndex);
        view.getModel().endInit();
        view.updateView("issueamount", editIndex);
        view.updateView("unpushamount", editIndex);
        view.updateView("issueprice", editIndex);
        view.updateView("issueoriginamount", editIndex);
        DeclarationFormControl.countHeadAmount(plugin);
    }

    public static BigDecimal rateConverter(BigDecimal money, BigDecimal rate, boolean isConvertRMB) {
        if (isConvertRMB) {
            return money.multiply(rate).setScale(2, RoundingMode.HALF_UP);
        }
        if (rate.compareTo(BigDecimal.ZERO) <= 0) {
            return BigDecimal.ZERO;
        }
        return money.divide(rate, 2, RoundingMode.HALF_UP);
    }

    public static void editDollarExchangeRate(AbstractFormPlugin plugin, Object oldValue, Object newValue) {
        IFormView view = plugin.getView();
        IDataModel model = view.getModel();
        if (!BigDecimalUtil.greaterZero((BigDecimal)((BigDecimal)newValue))) {
            plugin.getPageCache().put("not_property_change" + view.getPageId(), "id");
            view.showTipNotification(ResManager.loadKDString((String)"\u6c47\u7387\u5fc5\u987b\u5927\u4e8e0", (String)"DeclarationFormControl_4", (String)"imc-sim-service", (Object[])new Object[0]));
            view.getModel().setValue("dollarexchangerate", oldValue);
            plugin.getPageCache().remove("not_property_change" + view.getPageId());
            return;
        }
        DynamicObject sourceCurr = (DynamicObject)model.getValue("dollar");
        DeclarationFormControl.updateAllExchangeRate(plugin, (BigDecimal)newValue, sourceCurr);
        DeclarationFormControl.calculateAllIssueAmount(plugin);
    }

    private static void updateAllExchangeRate(AbstractFormPlugin plugin, BigDecimal newValue, DynamicObject sourceCurr) {
        BigDecimal insurRate;
        IFormView view = plugin.getView();
        IDataModel model = view.getModel();
        BigDecimal newExchangeRate = newValue.setScale(4, RoundingMode.HALF_UP);
        DynamicObject dollarCurr = (DynamicObject)model.getValue("dollar");
        DynamicObject insurCurr = (DynamicObject)model.getValue("insurcurr");
        DynamicObject feeCurr = (DynamicObject)model.getValue("feecurr");
        DynamicObject tradeCurr = (DynamicObject)model.getValue("tradecurr");
        DynamicObject otherCurr = (DynamicObject)model.getValue("othercurr");
        view.getModel().beginInit();
        if (BgdHelper.isEqualsCurr(sourceCurr, insurCurr)) {
            model.setValue("insurexchangerate", (Object)newExchangeRate);
            if ("3".equals(model.getValue("insurMark"))) {
                insurRate = (BigDecimal)view.getModel().getValue("insurrate");
                view.getModel().setValue("insurlocalamount", (Object)insurRate.multiply(newExchangeRate).setScale(UnitPriceHelper.MONEY_ACCURACY, RoundingMode.HALF_UP));
            }
        }
        if (BgdHelper.isEqualsCurr(sourceCurr, feeCurr)) {
            model.setValue("feeexchangerate", (Object)newExchangeRate);
            if ("3".equals(model.getValue("feeMark"))) {
                insurRate = (BigDecimal)view.getModel().getValue("feerate");
                view.getModel().setValue("feeamount", (Object)insurRate.multiply(newExchangeRate).setScale(UnitPriceHelper.MONEY_ACCURACY, RoundingMode.HALF_UP));
            }
        }
        if (BgdHelper.isEqualsCurr(sourceCurr, tradeCurr)) {
            model.setValue("dealexchangerate", (Object)newExchangeRate);
        }
        if (BgdHelper.isEqualsCurr(sourceCurr, otherCurr)) {
            model.setValue("otherexchangerate", (Object)newExchangeRate);
            if ("3".equals(model.getValue("otherMark"))) {
                insurRate = (BigDecimal)view.getModel().getValue("otherrate");
                view.getModel().setValue("otherlocalamount", (Object)insurRate.multiply(newExchangeRate).setScale(UnitPriceHelper.MONEY_ACCURACY, RoundingMode.HALF_UP));
            }
        }
        if (BgdHelper.isEqualsCurr(sourceCurr, dollarCurr)) {
            model.setValue("dollarexchangerate", (Object)newExchangeRate);
        }
        view.getModel().endInit();
        DeclarationFormControl.updateFields(plugin, "feeamount", "otherlocalamount", "insurlocalamount", "dollarexchangerate", "insurexchangerate", "feeexchangerate", "dealexchangerate", "otherexchangerate", "othercurr");
    }

    public static void editFeeRate(AbstractFormPlugin plugin, BigDecimal newValue, Object oldValue) {
        IFormView view = plugin.getView();
        if (BigDecimalUtil.lessZero((BigDecimal)newValue)) {
            view.getPageCache().put("not_property_change" + view.getPageId(), "id");
            view.getModel().setValue("feerate", oldValue);
            view.showTipNotification(ResManager.loadKDString((String)"\u8fd0\u8d39\u503c\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0", (String)"DeclarationFormControl_8", (String)"imc-sim-service", (Object[])new Object[0]));
            view.getPageCache().remove("not_property_change" + view.getPageId());
            return;
        }
        Object feeMark = view.getModel().getValue("feeMark");
        if ("3".equals(feeMark)) {
            BigDecimal rate = newValue;
            BigDecimal feeExchangeRate = (BigDecimal)view.getModel().getValue("feeexchangerate");
            view.getModel().setValue("feeamount", (Object)rate.multiply(feeExchangeRate).setScale(UnitPriceHelper.MONEY_ACCURACY, RoundingMode.HALF_UP));
        }
    }

    public static void editOtherRate(AbstractFormPlugin plugin, BigDecimal newValue, Object oldValue) {
        IFormView view = plugin.getView();
        if (BigDecimalUtil.lessZero((BigDecimal)newValue)) {
            view.getPageCache().put("not_property_change" + view.getPageId(), "id");
            view.getModel().setValue("otherrate", oldValue);
            view.showTipNotification(ResManager.loadKDString((String)"\u6742\u8d39\u503c\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0", (String)"DeclarationFormControl_9", (String)"imc-sim-service", (Object[])new Object[0]));
            view.getPageCache().remove("not_property_change" + view.getPageId());
            return;
        }
        Object otherMark = view.getModel().getValue("otherMark");
        if ("3".equals(otherMark)) {
            BigDecimal rate = newValue;
            BigDecimal otherExchangeRate = (BigDecimal)view.getModel().getValue("otherexchangerate");
            view.getModel().setValue("otherlocalamount", (Object)rate.multiply(otherExchangeRate).setScale(UnitPriceHelper.MONEY_ACCURACY, RoundingMode.HALF_UP));
        }
    }

    public static void editInsurRate(AbstractFormPlugin plugin, BigDecimal newValue, Object oldValue) {
        IFormView view = plugin.getView();
        if (BigDecimalUtil.lessZero((BigDecimal)newValue)) {
            view.getPageCache().put("not_property_change" + view.getPageId(), "id");
            view.getModel().setValue("insurrate", oldValue);
            view.showTipNotification(ResManager.loadKDString((String)"\u4fdd\u8d39\u503c\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0", (String)"DeclarationFormControl_10", (String)"imc-sim-service", (Object[])new Object[0]));
            view.getPageCache().remove("not_property_change" + view.getPageId());
            return;
        }
        Object insurMark = view.getModel().getValue("insurMark");
        if ("3".equals(insurMark)) {
            BigDecimal rate = newValue;
            BigDecimal insurExchangeRate = (BigDecimal)view.getModel().getValue("insurexchangerate");
            view.getModel().setValue("insurlocalamount", (Object)rate.multiply(insurExchangeRate).setScale(UnitPriceHelper.MONEY_ACCURACY, RoundingMode.HALF_UP));
        }
    }
}

