/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill.control;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.TaxRate;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.BotpHelper;
import kd.imc.bdm.common.helper.CurrencyHelper;
import kd.imc.bdm.common.helper.OriginalBillHelper;
import kd.imc.bdm.common.helper.ReducedHelper;
import kd.imc.bdm.common.helper.invoice.ReduceOnePoint5Helper;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.MaterialInfoUtil;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.constant.InvoiceConstant;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.helper.issueinvoice.UnitPriceHelper;
import kd.imc.sim.common.model.invoice.ZzstsglEnum;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.common.utils.TaxCalcUtil;
import kd.imc.sim.formplugin.bill.originalbill.control.AllESpecialTypeControl;
import kd.imc.sim.formplugin.bill.originalbill.control.OriginalBillPluginAddControl;
import kd.imc.sim.formplugin.bill.originalbill.control.OriginalBillPluginBaseControl;
import kd.imc.sim.formplugin.bill.originalbill.control.OriginalBillPluginChangeNumControl;
import kd.imc.sim.formplugin.bill.originalbill.control.OriginalBillPluginTaxCodeControl;
import kd.imc.sim.formplugin.bill.originalbill.control.OriginalBillPluginZKItemControl;
import kd.imc.sim.formplugin.bill.originalbill.control.OriginalBillPluginZSFSControl;
import kd.imc.sim.formplugin.bill.splitMerge.helper.BillMergeHelper;
import org.apache.commons.lang3.StringUtils;

public class OriginalBillPluginControl
extends OriginalBillPluginBaseControl {
    private static Log LOGGER = LogFactory.getLog(OriginalBillPluginControl.class);
    public static final String UPDATE_BILL_TOTAL_AMOUNT = "updateBillTotalAmount";
    public static final String CLEAR_BILL_ITEM = "CLEAR_BILL_ITEM";
    public static final String DOES_NOT_CHANGE = "DOES_NOT_CHANGE";

    public static void changeNum(AbstractFormPlugin formPlugin, IFormView view, Object newValue, Object oldValue, int index) {
        String rowTypeStr;
        BigDecimal num = (BigDecimal)newValue;
        Object gift = view.getModel().getValue("gift", index);
        String string = rowTypeStr = (Boolean)gift != false ? ResManager.loadKDString((String)"\u8d60\u54c1\u884c", (String)"OriginalBillPluginControl_0", (String)"imc-sim-service", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5546\u54c1\u884c", (String)"OriginalBillPluginControl_1", (String)"imc-sim-service", (Object[])new Object[0]);
        if (num.compareTo(BigDecimal.ZERO) < 0 && "1".equals(view.getModel().getValue("billproperties"))) {
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u6b63\u6570\u53d1\u7968\u7b2c%d\u884c%s\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e0", (String)"OriginalBillPluginControl_2", (String)"imc-sim-service", (Object[])new Object[0]), index + 1, rowTypeStr), Integer.valueOf(3000));
            OriginalBillPluginControl.setRowValueWithCache(formPlugin, view, oldValue, index, "do_not_change_num", "num");
            return;
        }
        if (num.compareTo(BigDecimal.ZERO) == 0 && ((Boolean)gift).booleanValue()) {
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u8d60\u54c1\u884c\u6570\u91cf\u4e0d\u80fd\u4e3a0", (String)"OriginalBillPluginControl_3", (String)"imc-sim-service", (Object[])new Object[0]), index + 1), Integer.valueOf(3000));
            OriginalBillPluginControl.setRowValueWithCache(formPlugin, view, oldValue, index, "do_not_change_num", "num");
            return;
        }
        if (num.compareTo(BigDecimal.ZERO) > 0 && "-1".equals(view.getModel().getValue("billproperties"))) {
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u8d1f\u6570\u53d1\u7968\u7b2c%d\u884c\u5546\u54c1\u884c\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e0", (String)"OriginalBillPluginControl_4", (String)"imc-sim-service", (Object[])new Object[0]), index + 1), Integer.valueOf(3000));
            OriginalBillPluginControl.setRowValueWithCache(formPlugin, view, oldValue, index, "do_not_change_num", "num");
            return;
        }
        if (!StringUtils.isEmpty((CharSequence)formPlugin.getPageCache().get("do_not_change_num" + index))) {
            return;
        }
        if (null == view.getModel().getValue("taxrate", index)) {
            return;
        }
        BigDecimal taxRate = new BigDecimal((String)view.getModel().getValue("taxrate", index));
        view.getModel().setValue("remainvalidnum", newValue, index);
        BigDecimal taxUnitPrice = (BigDecimal)view.getModel().getValue("taxunitprice", index);
        BigDecimal unitPrice = (BigDecimal)view.getModel().getValue("unitprice", index);
        BigDecimal taxAmount = (BigDecimal)view.getModel().getValue("taxamount", index);
        BigDecimal amount = (BigDecimal)view.getModel().getValue("amount", index);
        Object taxFlag = view.getModel().getValue("hsbz");
        if (CurrencyHelper.isFrom((Object)view.getModel().getValue("fromcurr"))) {
            OriginalBillPluginControl.alterInfoByNum(view, num, taxRate, taxFlag, index);
            return;
        }
        if ("1".equals(taxFlag)) {
            OriginalBillPluginChangeNumControl.changeNumByHS(formPlugin, view, oldValue, index, num, taxRate, taxUnitPrice, taxAmount, amount);
        } else {
            OriginalBillPluginChangeNumControl.changeNumByBHS(formPlugin, view, oldValue, index, num, taxRate, unitPrice, taxAmount, amount);
        }
    }

    public static void alterInfoAllDiscountRowByNum(IFormView view, BigDecimal num, BigDecimal taxRate, Object taxFlag, int editIndex) {
        String cacheKey = "not_property_change" + view.getPageId();
        view.getPageCache().put(cacheKey, cacheKey);
        IDataModel model = view.getModel();
        Object fromCurr = model.getValue("fromcurr");
        boolean isFrom = CurrencyHelper.isFrom((Object)fromCurr);
        if (isFrom) {
            OriginalBillPluginControl.countItemFromAmount(num, taxRate, taxFlag, editIndex, model, true);
        } else {
            OriginalBillPluginControl.countItemAmount(num, taxRate, taxFlag, editIndex, model, true);
        }
        OriginalBillPluginControl.copy2DiscountRow(model, editIndex);
        OriginalBillPluginControl.countHeadAmount(model);
        view.getPageCache().remove(cacheKey);
    }

    private static void countItemAmount(BigDecimal num, BigDecimal taxRate, Object taxFlag, int editIndex, IDataModel model, boolean isCombineAmtZero) {
        BigDecimal newTax;
        BigDecimal newAmount;
        BigDecimal newTaxAmount;
        boolean isIncludeTax = false;
        if ("1".equals(taxFlag)) {
            isIncludeTax = true;
            BigDecimal taxUnitPrice = (BigDecimal)model.getValue("taxunitprice", editIndex);
            newTaxAmount = taxUnitPrice.multiply(num).setScale(2, RoundingMode.HALF_UP);
            newAmount = newTaxAmount.multiply(BigDecimal.ONE.divide(BigDecimal.ONE.add(taxRate), 30, RoundingMode.HALF_UP)).setScale(2, RoundingMode.HALF_UP);
            newTax = newTaxAmount.subtract(newAmount);
        } else {
            BigDecimal price = (BigDecimal)model.getValue("unitprice", editIndex);
            newAmount = price.multiply(num).setScale(2, RoundingMode.HALF_UP);
            newTax = newAmount.multiply(taxRate).setScale(2, RoundingMode.HALF_UP);
            newTaxAmount = newAmount.add(newTax);
        }
        model.setValue("tax", (Object)newTax, editIndex);
        model.setValue("amount", (Object)newAmount, editIndex);
        model.setValue("taxamount", (Object)newTaxAmount, editIndex);
        BigDecimal remainVliadAmount = isIncludeTax ? newTaxAmount : newAmount;
        model.setValue("remainvalidtax", (Object)newTax, editIndex);
        model.setValue("remainvalidamount", (Object)remainVliadAmount, editIndex);
        model.setValue("remainvalidnum", (Object)num, editIndex);
        model.setValue("combineamount", (Object)newTaxAmount, editIndex);
        model.setValue("combinelocalamount", (Object)newTaxAmount, editIndex);
        if (isCombineAmtZero) {
            model.setValue("combineamount", (Object)BigDecimal.ZERO, editIndex);
            model.setValue("combinelocalamount", (Object)BigDecimal.ZERO, editIndex);
        }
        model.setValue("combinenum", (Object)num, editIndex);
    }

    private static void copy2DiscountRow(IDataModel model, int editIndex) {
        int discountIndex = editIndex + 1;
        model.setValue("amount", (Object)OriginalBillPluginControl.negateValue(model.getValue("amount", editIndex)), discountIndex);
        model.setValue("taxamount", (Object)OriginalBillPluginControl.negateValue(model.getValue("taxamount", editIndex)), discountIndex);
        model.setValue("fromamount", (Object)OriginalBillPluginControl.negateValue(model.getValue("fromamount", editIndex)), discountIndex);
        model.setValue("fromtaxamount", (Object)OriginalBillPluginControl.negateValue(model.getValue("fromtaxamount", editIndex)), discountIndex);
        model.setValue("fromtax", (Object)OriginalBillPluginControl.negateValue(model.getValue("fromtax", editIndex)), discountIndex);
        model.setValue("remainvalidtax", (Object)OriginalBillPluginControl.negateValue(model.getValue("remainvalidtax", editIndex)), discountIndex);
        model.setValue("remainvalidamount", (Object)OriginalBillPluginControl.negateValue(model.getValue("remainvalidamount", editIndex)), discountIndex);
        model.setValue("oritaxamount", (Object)OriginalBillPluginControl.negateValue(model.getValue("oritaxamount", editIndex)), discountIndex);
        model.setValue("tax", (Object)OriginalBillPluginControl.negateValue(model.getValue("tax", editIndex)), discountIndex);
    }

    private static BigDecimal negateValue(Object value) {
        if (null == value) {
            return BigDecimal.ZERO;
        }
        BigDecimal decimal = (BigDecimal)value;
        return decimal.negate();
    }

    private static void alterInfoByNum(IFormView view, BigDecimal num, BigDecimal taxRate, Object taxFlag, int editIndex) {
        String cacheKey = "not_property_change" + view.getPageId();
        view.getPageCache().put(cacheKey, cacheKey);
        IDataModel model = view.getModel();
        OriginalBillPluginControl.countItemFromAmount(num, taxRate, taxFlag, editIndex, model, false);
        OriginalBillPluginControl.countHeadAmount(model);
        view.getPageCache().remove(cacheKey);
    }

    private static void countItemFromAmount(BigDecimal num, BigDecimal taxRate, Object taxFlag, int editIndex, IDataModel model, boolean isCombineAmountZero) {
        BigDecimal newTaxUnitPrice;
        BigDecimal newPrice;
        BigDecimal fromTax;
        BigDecimal fromAmount;
        BigDecimal newTax;
        BigDecimal newAmount;
        BigDecimal fromTaxAmount;
        BigDecimal newTaxAmount;
        boolean isAllEle;
        DynamicObject fromCurr = (DynamicObject)model.getValue("fromcurr");
        String invoiceType = (String)model.getValue("invoicetype");
        String isElePaper = (String)model.getValue("iselepaper");
        boolean bl = isAllEle = InvoiceUtils.isAllEInvoice((Object)invoiceType) || "1".equals(isElePaper);
        if (null == fromCurr) {
            throw new KDBizException(ResManager.loadKDString((String)"\u539f\u5e01\u6c47\u7387\u5fc5\u586b", (String)"OriginalBillPluginControl_5", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        boolean isIncludeTax = "1".equals(taxFlag);
        int amtPrecision = fromCurr.getInt("amtprecision");
        Object oriNum = model.getValue("orinum");
        if (OriginalBillPluginControl.isOriginalNum(num, oriNum)) {
            newTaxAmount = (BigDecimal)model.getValue("oritaxamount");
            fromTaxAmount = (BigDecimal)model.getValue("orifromtaxamount");
            newAmount = newTaxAmount.divide(BigDecimal.ONE.add(taxRate), 2, RoundingMode.HALF_UP);
            newTax = newTaxAmount.subtract(newAmount);
            fromAmount = fromTaxAmount.divide(BigDecimal.ONE.add(taxRate), amtPrecision, RoundingMode.HALF_UP);
            fromTax = fromTaxAmount.subtract(fromAmount);
            newPrice = PriceHelper.calcPriceOrNum((BigDecimal)newAmount, (BigDecimal)num, (boolean)isAllEle);
            newTaxUnitPrice = PriceHelper.calcPriceOrNum((BigDecimal)newTaxAmount, (BigDecimal)num, (boolean)isAllEle);
        } else {
            BigDecimal exRate = (BigDecimal)model.getValue("exrate");
            String quotation = (String)model.getValue("quotation");
            if ("1".equals(taxFlag)) {
                BigDecimal fromTaxUnitPrice = (BigDecimal)model.getValue("fromtaxprice", editIndex);
                fromTaxAmount = fromTaxUnitPrice.multiply(num).setScale(amtPrecision, RoundingMode.HALF_UP);
                fromAmount = fromTaxAmount.multiply(BigDecimal.ONE.divide(BigDecimal.ONE.add(taxRate), 20, RoundingMode.HALF_UP)).setScale(amtPrecision, RoundingMode.HALF_UP);
                fromTax = fromTaxAmount.subtract(fromAmount);
                newTaxAmount = CurrencyHelper.calToAmount((String)quotation, (BigDecimal)exRate, (BigDecimal)fromTaxAmount);
                newAmount = newTaxAmount.multiply(BigDecimal.ONE.divide(BigDecimal.ONE.add(taxRate), 20, RoundingMode.HALF_UP)).setScale(2, RoundingMode.HALF_UP);
                newTax = newTaxAmount.subtract(newAmount);
                newTaxUnitPrice = PriceHelper.calcPriceOrNum((BigDecimal)newTaxAmount, (BigDecimal)num, (boolean)isAllEle);
                newPrice = PriceHelper.calcPriceOrNum((BigDecimal)newAmount, (BigDecimal)num, (boolean)isAllEle);
            } else {
                BigDecimal fromPrice = (BigDecimal)model.getValue("fromprice", editIndex);
                fromAmount = fromPrice.multiply(num).setScale(amtPrecision, RoundingMode.HALF_UP);
                fromTax = fromAmount.multiply(taxRate).setScale(amtPrecision, RoundingMode.HALF_UP);
                fromTaxAmount = fromAmount.add(fromTax);
                newAmount = CurrencyHelper.calToAmount((String)quotation, (BigDecimal)exRate, (BigDecimal)fromAmount);
                newTax = newAmount.multiply(taxRate).setScale(2, RoundingMode.HALF_UP);
                newTaxAmount = newAmount.add(newTax);
                newTaxUnitPrice = PriceHelper.calcPriceOrNum((BigDecimal)newTaxAmount, (BigDecimal)num, (boolean)isAllEle);
                newPrice = PriceHelper.calcPriceOrNum((BigDecimal)newAmount, (BigDecimal)num, (boolean)isAllEle);
            }
        }
        model.setValue("amount", (Object)newAmount, editIndex);
        model.setValue("tax", (Object)newTax, editIndex);
        model.setValue("taxamount", (Object)newTaxAmount, editIndex);
        model.setValue("unitprice", (Object)newPrice, editIndex);
        model.setValue("taxunitprice", (Object)newTaxUnitPrice, editIndex);
        model.setValue("fromamount", (Object)fromAmount, editIndex);
        model.setValue("fromtaxamount", (Object)fromTaxAmount, editIndex);
        model.setValue("fromtax", (Object)fromTax, editIndex);
        BigDecimal remainVliadAmount = isIncludeTax ? newTaxAmount : newAmount;
        model.setValue("remainvalidamount", (Object)remainVliadAmount, editIndex);
        model.setValue("remainvalidtax", (Object)newTax, editIndex);
        model.setValue("remainvalidnum", (Object)num, editIndex);
        if (isCombineAmountZero) {
            model.setValue("combinelocalamount", (Object)BigDecimal.ZERO, editIndex);
            model.setValue("combineamount", (Object)BigDecimal.ZERO, editIndex);
        } else {
            model.setValue("combinelocalamount", (Object)newTaxAmount, editIndex);
            model.setValue("combineamount", (Object)fromTaxAmount, editIndex);
        }
        model.setValue("combinenum", (Object)num, editIndex);
    }

    private static boolean isOriginalNum(BigDecimal num, Object oriNum) {
        return null != oriNum && num.compareTo((BigDecimal)oriNum) == 0;
    }

    public static void changeUnitPrice(AbstractFormPlugin formPlugin, IFormView view, Object newValue, Object oldValue, int index) {
        Object nextRowType;
        BigDecimal unitPrice = (BigDecimal)newValue;
        if (!OriginalBillPluginControl.checkUnitPriceGreaterZero(formPlugin, view, oldValue, index, unitPrice, "do_not_change_unit_price", "unitprice")) {
            return;
        }
        if (!StringUtils.isEmpty((CharSequence)formPlugin.getPageCache().get("do_not_change_unit_price" + index))) {
            return;
        }
        BigDecimal num = (BigDecimal)view.getModel().getValue("num", index);
        BigDecimal amount = (BigDecimal)view.getModel().getValue("amount", index);
        BigDecimal taxRate = new BigDecimal((String)view.getModel().getValue("taxrate", index));
        if (MathUtils.isZero((BigDecimal)num) && !MathUtils.isZero((BigDecimal)amount) && !MathUtils.isZero((BigDecimal)unitPrice)) {
            num = UnitPriceHelper.calcNum((BigDecimal)amount, (BigDecimal)unitPrice);
            OriginalBillPluginControl.setRowValueWithCache(formPlugin, view, num, index, "do_not_change_num", "num");
        } else {
            amount = num.multiply(unitPrice).setScale(2, RoundingMode.HALF_UP);
        }
        DynamicObjectCollection items = view.getModel().getEntryEntity("sim_original_bill_item");
        if (index + 1 < items.getRowCount() && "1".equals(nextRowType = view.getModel().getValue("rowtype", index + 1))) {
            BigDecimal nextItemAmount = (BigDecimal)view.getModel().getValue("amount", index + 1);
            int showIndex = index + 1;
            if (amount.add(nextItemAmount).compareTo(BigDecimal.ZERO) <= 0) {
                view.showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5546\u54c1\u884c\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u6298\u6263\u91d1\u989d", (String)"OriginalBillPluginControl_6", (String)"imc-sim-service", (Object[])new Object[0]), showIndex), Integer.valueOf(3000));
                view.getModel().setValue("unitprice", oldValue, index);
                return;
            }
        }
        OriginalBillPluginControl.updateRowValueByBHS(formPlugin, view, index, num, taxRate, amount, oldValue, "unitprice");
    }

    public static void changeTaxUnitPrice(AbstractFormPlugin formPlugin, IFormView view, Object newValue, Object oldValue, int index) {
        Object nextRowType;
        BigDecimal taxUnitPrice = (BigDecimal)newValue;
        if (!OriginalBillPluginControl.checkUnitPriceGreaterZero(formPlugin, view, oldValue, index, taxUnitPrice, "do_not_change_tax_unit_price", "taxunitprice")) {
            return;
        }
        if (!StringUtils.isEmpty((CharSequence)formPlugin.getPageCache().get("do_not_change_tax_unit_price" + index))) {
            return;
        }
        BigDecimal num = (BigDecimal)view.getModel().getValue("num", index);
        BigDecimal taxAmount = (BigDecimal)view.getModel().getValue("taxamount", index);
        BigDecimal taxRate = new BigDecimal((String)view.getModel().getValue("taxrate", index));
        if (MathUtils.isZero((BigDecimal)num) && !MathUtils.isZero((BigDecimal)taxAmount) && !MathUtils.isZero((BigDecimal)taxUnitPrice)) {
            num = UnitPriceHelper.calcNum((BigDecimal)taxAmount, (BigDecimal)taxUnitPrice);
            OriginalBillPluginControl.setRowValueWithCache(formPlugin, view, num, index, "do_not_change_num", "num");
        } else {
            taxAmount = num.multiply(taxUnitPrice).setScale(2, RoundingMode.HALF_UP);
        }
        DynamicObjectCollection items = view.getModel().getEntryEntity("sim_original_bill_item");
        if (index + 1 < items.getRowCount() && "1".equals(nextRowType = view.getModel().getValue("rowtype", index + 1))) {
            BigDecimal nextItemTaxAmount = (BigDecimal)view.getModel().getValue("taxamount", index + 1);
            int showIndex = index + 1;
            if (taxAmount.add(nextItemTaxAmount).compareTo(BigDecimal.ZERO) <= 0) {
                view.showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5546\u54c1\u884c\u542b\u7a0e\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u6298\u6263\u542b\u7a0e\u91d1\u989d", (String)"OriginalBillPluginControl_7", (String)"imc-sim-service", (Object[])new Object[0]), showIndex), Integer.valueOf(3000));
                view.getModel().setValue("taxunitprice", oldValue, index);
                return;
            }
        }
        if (!OriginalBillPluginZSFSControl.checkDeduction(view, taxAmount)) {
            view.getModel().setValue("taxunitprice", oldValue, index);
            return;
        }
        OriginalBillPluginControl.updateRowValueByHS(formPlugin, view, index, taxRate, num, taxAmount);
    }

    public static void changeTaxRate(AbstractFormPlugin formPlugin, IFormView view, Object newValue, Object oldValue, int index) {
        if (!StringUtils.isEmpty((CharSequence)formPlugin.getPageCache().get("do_not_change_tax_rate" + index))) {
            return;
        }
        if (newValue == null || StringUtils.isEmpty((CharSequence)newValue.toString())) {
            OriginalBillPluginControl.setRowValueWithCache(formPlugin, view, oldValue, index, "do_not_change_tax_rate", "taxrate");
            return;
        }
        String policyContants = (String)view.getModel().getValue("policycontants");
        if (("\u514d\u7a0e".equals(policyContants) || "\u4e0d\u5f81\u7a0e".equals(policyContants)) && !"0".equals(newValue)) {
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u4f18\u60e0\u653f\u7b56\u662f\u514d\u7a0e\uff0c\u7a0e\u7387\u53ea\u80fd\u4e3a0", (String)"OriginalBillPluginControl_8", (String)"imc-sim-service", (Object[])new Object[0]), index + 1), Integer.valueOf(3000));
            view.getModel().setValue("taxrate", (Object)"0", index);
            return;
        }
        if ("0".equals(newValue) && StringUtils.isEmpty((CharSequence)policyContants) && "0".equals(view.getModel().getValue("policylogo"))) {
            view.getModel().setValue("policycontants", (Object)"\u666e\u901a\u96f6\u7a0e\u7387", index);
        }
        if (!"0".equals(newValue) && StringUtils.isBlank((CharSequence)policyContants)) {
            view.getModel().setValue("policylogo", (Object)"0", index);
        }
        String policylogo = (String)view.getModel().getValue("policylogo", index);
        if (!"0".equals(newValue) && "0".equals(policylogo)) {
            view.getModel().setValue("policycontants", (Object)"", index);
        }
        if (StringUtils.isEmpty((CharSequence)newValue.toString())) {
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillPluginControl_9", (String)"imc-sim-service", (Object[])new Object[0]), index + 1), Integer.valueOf(3000));
            view.getModel().setValue("tax", (Object)BigDecimal.ZERO, index);
            return;
        }
        BigDecimal taxRate = new BigDecimal((String)newValue);
        BigDecimal taxAmount = (BigDecimal)view.getModel().getValue("taxamount", index);
        BigDecimal amount = (BigDecimal)view.getModel().getValue("amount", index);
        BigDecimal num = (BigDecimal)view.getModel().getValue("num", index);
        if ("1".equals(view.getModel().getValue("hsbz"))) {
            OriginalBillPluginControl.changeTaxRateHS(formPlugin, view, index, taxRate, taxAmount, num);
        } else {
            OriginalBillPluginControl.changeTaxRateBHS(formPlugin, view, index, taxRate, amount, num);
        }
        OriginalBillPluginControl.dealChangeDiscountTaxMethod(view, index, newValue);
    }

    private static void dealChangeDiscountTaxMethod(IFormView view, int index, Object newValue) {
        Object nextRowType;
        String hsbz = (String)view.getModel().getValue("hsbz");
        DynamicObjectCollection items = view.getModel().getEntryEntity("sim_original_bill_item");
        if (index + 1 < items.getRowCount() && "1".equals(nextRowType = view.getModel().getValue("rowtype", index + 1))) {
            int nextIndex = index + 1;
            view.getModel().setValue("taxrate", newValue, nextIndex);
            if ("0".equals(hsbz)) {
                OriginalBillPluginControl.dealChangeAmountByNoHsbz(view, nextIndex, newValue, index);
            } else if ("1".equals(hsbz)) {
                OriginalBillPluginControl.dealChangeAmountByHsbz(view, nextIndex, newValue, index);
            }
            String policyContants = (String)view.getModel().getValue("policycontants", nextIndex);
            String policyLogo = (String)view.getModel().getValue("policylogo", nextIndex);
            if ("0".equals(newValue) && StringUtils.isEmpty((CharSequence)policyContants) && "0".equals(policyLogo)) {
                view.getModel().setValue("policycontants", (Object)"\u666e\u901a\u96f6\u7a0e\u7387", nextIndex);
            } else if (!"0".equals(newValue) && StringUtils.isNotBlank((CharSequence)policyContants) && "0".equals(policyLogo)) {
                view.getModel().setValue("policycontants", (Object)"", nextIndex);
            }
        }
    }

    private static void dealChangeAmountByHsbz(IFormView view, int nextIndex, Object newValue, int index) {
        if (newValue == null) {
            newValue = "0";
        }
        BigDecimal taxRate = new BigDecimal(newValue.toString());
        if ("0".equals(newValue)) {
            taxRate = BigDecimal.ZERO;
        }
        BigDecimal taxAmount_hsbz = (BigDecimal)view.getModel().getValue("taxamount", index);
        BigDecimal tax_hshz = taxAmount_hsbz.multiply(taxRate).divide(BigDecimal.ONE.add(taxRate), 2, 4);
        view.getModel().setValue("tax", (Object)tax_hshz, index);
        BigDecimal amount_hsbz = taxAmount_hsbz.subtract(tax_hshz);
        view.getModel().setValue("amount", (Object)amount_hsbz, index);
        BigDecimal taxamount = (BigDecimal)view.getModel().getValue("taxamount", nextIndex);
        BigDecimal tax = taxamount.multiply(taxRate).divide(BigDecimal.ONE.add(taxRate), 2, 4);
        view.getModel().setValue("tax", (Object)tax, nextIndex);
        view.getModel().setValue("remainvalidtax", (Object)tax, nextIndex);
        BigDecimal amount = taxamount.subtract(tax);
        view.getModel().setValue("amount", (Object)amount, nextIndex);
    }

    private static void dealChangeAmountByNoHsbz(IFormView view, int nextIndex, Object newValue, int index) {
        BigDecimal remainvalidamount = (BigDecimal)view.getModel().getValue("remainvalidamount", nextIndex);
        BigDecimal tax = remainvalidamount.multiply(new BigDecimal(newValue.toString()));
        view.getModel().setValue("tax", (Object)tax, nextIndex);
        view.getModel().setValue("remainvalidtax", (Object)tax, nextIndex);
        BigDecimal amount = (BigDecimal)view.getModel().getValue("amount", nextIndex);
        BigDecimal taxAmount = (BigDecimal)view.getModel().getValue("tax", nextIndex);
        view.getModel().setValue("taxamount", (Object)amount.add(taxAmount), nextIndex);
        BigDecimal commonLineAmount = (BigDecimal)view.getModel().getValue("amount", index);
        BigDecimal commonLineTaxAmount = (BigDecimal)view.getModel().getValue("tax", index);
        view.getModel().setValue("taxamount", (Object)commonLineAmount.add(commonLineTaxAmount), index);
    }

    private static void changeTaxRateBHS(AbstractFormPlugin formPlugin, IFormView view, int index, BigDecimal taxRate, BigDecimal amount, BigDecimal num) {
        BigDecimal tax;
        boolean isAllEle;
        String invoiceType = (String)view.getModel().getValue("invoicetype");
        String isElePaper = (String)view.getModel().getValue("iselepaper");
        boolean bl = isAllEle = InvoiceUtils.isAllEInvoice((Object)invoiceType) || "1".equals(isElePaper);
        if (OriginalBillPluginControl.isCETaxStyle(view) && BigDecimal.ZERO.compareTo(amount) != 0) {
            if (!"1".equals(view.getModel().getValue("rowtype", index))) {
                BigDecimal subtract = amount.subtract((BigDecimal)view.getModel().getValue("deduction"));
                tax = subtract.multiply(taxRate);
                OriginalBillPluginZSFSControl.changeZKTaxBHS(formPlugin, view, index, taxRate, tax);
            } else {
                BigDecimal bzkTax = (BigDecimal)view.getModel().getValue("tax", index - 1);
                if (bzkTax.add(tax = amount.multiply(taxRate)).compareTo(BigDecimal.ZERO) < 0) {
                    tax = bzkTax.negate();
                }
            }
        } else {
            tax = amount.multiply(taxRate);
        }
        IDataModel model = view.getModel();
        Object policyConstant = model.getValue("policycontants", index);
        if (InvoiceUtils.isAllEInvoice((Object)view.getModel().getValue("invoicetype")) && new BigDecimal("0.015").compareTo(taxRate) == 0 && ZzstsglEnum.TEN.getDescription().equals(policyConstant)) {
            tax = ReduceOnePoint5Helper.getTaxAmountBHS((BigDecimal)amount, (BigDecimal)taxRate, (String)((String)model.getValue("goodscode", index)));
        }
        BigDecimal taxAmount = amount.add(tax);
        OriginalBillPluginControl.updateRowSurplusAndCanCommitAmountNumTax(view, num, amount, tax, index);
        OriginalBillPluginControl.setRowValueWithCache(formPlugin, view, tax, index, "do_not_change_tax", "tax");
        OriginalBillPluginControl.setRowValueWithCache(formPlugin, view, taxAmount, index, "do_not_change_tax_amount", "taxamount");
        BigDecimal unitPrice = (BigDecimal)view.getModel().getValue("unitprice", index);
        BigDecimal taxUnitPrice = PriceHelper.getTaxUnitPriceByBHS((BigDecimal)taxRate, (BigDecimal)num, (BigDecimal)taxAmount, (BigDecimal)unitPrice, (boolean)isAllEle);
        OriginalBillPluginControl.setRowValueWithCache(formPlugin, view, taxUnitPrice, index, "do_not_change_tax_unit_price", "taxunitprice");
    }

    private static void changeTaxRateHS(AbstractFormPlugin formPlugin, IFormView view, int index, BigDecimal taxRate, BigDecimal taxAmount, BigDecimal num) {
        BigDecimal amount;
        BigDecimal tax;
        if (OriginalBillPluginControl.isCETaxStyle(view) && BigDecimal.ZERO.compareTo(taxAmount) != 0) {
            tax = OriginalBillPluginControl.updateDeductionTaxHS(view, index, taxAmount, taxRate);
            amount = taxAmount.subtract(tax);
            OriginalBillPluginZSFSControl.changeZKTaxHS(formPlugin, view, index, taxRate, tax);
        } else {
            amount = taxAmount.divide(BigDecimal.ONE.add(taxRate), 2, RoundingMode.HALF_UP);
            tax = taxAmount.subtract(amount);
        }
        if (InvoiceUtils.isAllEInvoice((Object)view.getModel().getValue("invoicetype")) && new BigDecimal("0.015").compareTo(taxRate) == 0 && ZzstsglEnum.TEN.getDescription().equals(view.getModel().getValue("policycontants", index))) {
            tax = ReduceOnePoint5Helper.getTaxAmountHS((BigDecimal)taxAmount, (BigDecimal)taxRate, (String)((String)view.getModel().getValue("goodscode", index)));
            amount = taxAmount.subtract(tax);
        }
        OriginalBillPluginControl.setRowValueWithCache(formPlugin, view, amount, index, "do_not_change_amount", "amount");
        OriginalBillPluginControl.setRowValueWithCache(formPlugin, view, tax, index, "do_not_change_tax", "tax");
        OriginalBillPluginControl.updateRowSurplusAndCanCommitAmountNumTax(view, num, amount, tax, index);
        String invoiceType = (String)view.getModel().getValue("invoicetype");
        String isElePaper = (String)view.getModel().getValue("iselepaper");
        boolean isAllEle = InvoiceUtils.isAllEInvoice((Object)invoiceType) || "1".equals(isElePaper);
        BigDecimal taxUnitPrice = (BigDecimal)view.getModel().getValue("taxunitprice", index);
        BigDecimal unitPrice = PriceHelper.getUnitPriceByHS((BigDecimal)taxRate, (BigDecimal)num, (BigDecimal)amount, (BigDecimal)taxUnitPrice, (boolean)isAllEle);
        OriginalBillPluginControl.setRowValueWithCache(formPlugin, view, unitPrice, index, "do_not_change_unit_price", "unitprice");
    }

    public static void changeAmount(AbstractFormPlugin formPlugin, IFormView view, Object newValue, Object oldValue, int index) {
        BigDecimal taxUnitPrice;
        String billProperties;
        if (!StringUtils.isEmpty((CharSequence)formPlugin.getPageCache().get("do_not_change_amount" + index))) {
            return;
        }
        BigDecimal amount = (BigDecimal)newValue;
        if (!OriginalBillPluginZKItemControl.handleZKItemByChangeAmount(formPlugin, view, oldValue, index, amount)) {
            return;
        }
        IDataModel model = view.getModel();
        Object invoiceType = model.getValue("invoicetype");
        Object isElePaper = model.getValue("iselepaper");
        boolean isAllEle = InvoiceUtils.isAllEInvoice((Object)((String)invoiceType)) || "1".equals(isElePaper);
        BigDecimal taxRate = new BigDecimal((String)model.getValue("taxrate", index));
        BigDecimal tax = amount.multiply(taxRate);
        if (OriginalBillPluginControl.isCETaxStyle(view) && !"1".equals(model.getValue("rowtype", index)) && ("1".equals(billProperties = (String)model.getValue("billproperties")) && amount.compareTo((BigDecimal)model.getValue("deduction")) < 0 || "-1".equals(billProperties) && amount.compareTo((BigDecimal)model.getValue("deduction")) > 0)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5dee\u989d\u5f81\u7a0e\uff0c\u4e0d\u542b\u7a0e\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u6263\u9664\u989d", (String)"OriginalBillPluginControl_10", (String)"imc-sim-service", (Object[])new Object[0]), Integer.valueOf(3000));
            OriginalBillPluginControl.setRowValueWithCache(formPlugin, view, oldValue, index, "do_not_change_amount", "amount");
            return;
        }
        if (OriginalBillPluginControl.isCETaxStyle(view)) {
            tax = OriginalBillPluginControl.updateDeductionTaxBHS(view, index, taxRate, amount);
            OriginalBillPluginZSFSControl.changeZKTaxBHS(formPlugin, view, index, taxRate, tax);
        }
        Object policyConstant = model.getValue("policycontants", index);
        if (ReducedHelper.isReduced((Object)model.getValue("taxationstyle")) && ReducedHelper.isSpecialCalc((Object)policyConstant)) {
            tax = ReducedHelper.calcTaxWithoutTax((Object)policyConstant, (BigDecimal)amount);
        } else if (InvoiceUtils.isAllEInvoice((Object)view.getModel().getValue("invoicetype")) && new BigDecimal("0.015").compareTo(taxRate) == 0 && ZzstsglEnum.TEN.getDescription().equals(policyConstant)) {
            tax = ReduceOnePoint5Helper.getTaxAmountBHS((BigDecimal)amount, (BigDecimal)taxRate, (String)((String)model.getValue("goodscode", index)));
        }
        BigDecimal taxAmount = amount.add(tax);
        OriginalBillPluginControl.setRowValueWithCache(formPlugin, view, tax, index, "do_not_change_tax", "tax");
        OriginalBillPluginControl.setRowValueWithCache(formPlugin, view, taxAmount, index, "do_not_change_tax_amount", "taxamount");
        BigDecimal unitPrice = (BigDecimal)view.getModel().getValue("unitprice", index);
        BigDecimal num = (BigDecimal)view.getModel().getValue("num", index);
        if (MathUtils.isZero((BigDecimal)num) && MathUtils.isZero((BigDecimal)unitPrice)) {
            OriginalBillPluginControl.updateRowSurplusAndCanCommitAmountNumTax(view, num, amount, tax, index);
            return;
        }
        Object benchMark = view.getModel().getValue("benchmark");
        boolean isAmountMark = "1".equals(benchMark);
        if (!MathUtils.isZero((BigDecimal)unitPrice) && !MathUtils.isZero((BigDecimal)num) && !BotpHelper.isFromAr((Object)model.getValue("systemsource")) || isAmountMark) {
            OriginalBillPluginControl.numAndUnitPriceNotNull(formPlugin, view, index, taxAmount, amount, tax, num);
            return;
        }
        if (!MathUtils.isZero((BigDecimal)unitPrice) && !MathUtils.isZero((BigDecimal)num) && BotpHelper.isFromAr((Object)model.getValue("systemsource"))) {
            OriginalBillPluginControl.numAndUnitPriceNotNull2(formPlugin, view, index, taxAmount, amount, tax, false);
            return;
        }
        if (MathUtils.isZero((BigDecimal)unitPrice) && !MathUtils.isZero((BigDecimal)num)) {
            formPlugin.getPageCache().put("do_not_change_unit_price" + index, "1");
            formPlugin.getPageCache().put("do_not_change_tax_unit_price" + index, "1");
            unitPrice = PriceHelper.calcPriceOrNum((BigDecimal)amount, (BigDecimal)num, (boolean)isAllEle);
            view.getModel().setValue("unitprice", (Object)unitPrice, index);
            taxUnitPrice = PriceHelper.calcPriceOrNum((BigDecimal)taxAmount, (BigDecimal)num, (boolean)isAllEle);
            view.getModel().setValue("taxunitprice", (Object)taxUnitPrice, index);
            formPlugin.getPageCache().remove("do_not_change_unit_price" + index);
            formPlugin.getPageCache().remove("do_not_change_tax_unit_price" + index);
        }
        if (!MathUtils.isZero((BigDecimal)unitPrice) && MathUtils.isZero((BigDecimal)num)) {
            formPlugin.getPageCache().put("do_not_change_num" + index, "1");
            formPlugin.getPageCache().put("do_not_change_tax_unit_price" + index, "1");
            num = UnitPriceHelper.calcNum((BigDecimal)amount, (BigDecimal)unitPrice);
            view.getModel().setValue("num", (Object)num, index);
            taxUnitPrice = PriceHelper.calcPriceOrNum((BigDecimal)taxAmount, (BigDecimal)num, (boolean)isAllEle);
            view.getModel().setValue("taxunitprice", (Object)taxUnitPrice, index);
            formPlugin.getPageCache().remove("do_not_change_num" + index);
            formPlugin.getPageCache().remove("do_not_change_tax_unit_price" + index);
        }
        OriginalBillPluginControl.updateRowSurplusAndCanCommitAmountNumTax(view, num, amount, tax, index);
    }

    public static void changeTaxAmount(AbstractFormPlugin formPlugin, IFormView view, Object newValue, Object oldValue, int index) {
        BigDecimal unitPrice;
        boolean isAllEle;
        BigDecimal amount;
        BigDecimal tax;
        if (!StringUtils.isEmpty((CharSequence)formPlugin.getPageCache().get("do_not_change_tax_amount" + index))) {
            return;
        }
        BigDecimal taxAmount = (BigDecimal)newValue;
        if (!OriginalBillPluginZKItemControl.handleZKItemByChangeTaxAmount(formPlugin, view, oldValue, index, taxAmount)) {
            return;
        }
        if (OriginalBillPluginControl.isCETaxStyle(view) && !"1".equals(view.getModel().getValue("rowtype", index)) && taxAmount.compareTo((BigDecimal)view.getModel().getValue("deduction")) < 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5dee\u989d\u5f81\u7a0e\uff0c\u542b\u7a0e\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u6263\u9664\u989d", (String)"OriginalBillPluginControl_11", (String)"imc-sim-service", (Object[])new Object[0]), Integer.valueOf(3000));
            OriginalBillPluginControl.setRowValueWithCache(formPlugin, view, oldValue, index, "do_not_change_tax_amount", "taxamount");
            return;
        }
        BigDecimal taxRate = new BigDecimal((String)view.getModel().getValue("taxrate", index));
        Object policyConstants = view.getModel().getValue("policycontants", index);
        if (OriginalBillPluginControl.isCETaxStyle(view)) {
            tax = OriginalBillPluginControl.updateDeductionTaxHS(view, index, taxAmount, taxRate);
            amount = taxAmount.subtract(tax);
            OriginalBillPluginZSFSControl.changeZKTaxHS(formPlugin, view, index, taxRate, tax);
        } else if (ReducedHelper.isReduced((Object)view.getModel().getValue("taxationstyle")) && ReducedHelper.isSpecialCalc((Object)policyConstants)) {
            tax = ReducedHelper.calcTaxWithTax((Object)policyConstants, (BigDecimal)taxAmount);
            amount = taxAmount.subtract(tax);
        } else if (InvoiceUtils.isAllEInvoice((Object)view.getModel().getValue("invoicetype")) && new BigDecimal("0.015").compareTo(taxRate) == 0 && ZzstsglEnum.TEN.getDescription().equals(policyConstants)) {
            tax = ReduceOnePoint5Helper.getTaxAmountHS((BigDecimal)taxAmount, (BigDecimal)taxRate, (String)((String)view.getModel().getValue("goodscode", index)));
            amount = taxAmount.subtract(tax);
        } else {
            amount = taxAmount.divide(BigDecimal.ONE.add(taxRate), 2, RoundingMode.HALF_UP);
            tax = taxAmount.subtract(amount);
        }
        OriginalBillPluginControl.setRowValueWithCache(formPlugin, view, amount, index, "do_not_change_amount", "amount");
        OriginalBillPluginControl.setRowValueWithCache(formPlugin, view, tax, index, "do_not_change_tax", "tax");
        BigDecimal taxUnitPrice = (BigDecimal)view.getModel().getValue("taxunitprice", index);
        BigDecimal num = (BigDecimal)view.getModel().getValue("num", index);
        Object invoiceType = view.getModel().getValue("invoicetype");
        Object isElePaper = view.getModel().getValue("iselepaper");
        boolean bl = isAllEle = InvoiceUtils.isAllEInvoice((Object)((String)invoiceType)) || "1".equals(isElePaper);
        if (MathUtils.isZero((BigDecimal)num) && MathUtils.isZero((BigDecimal)taxUnitPrice)) {
            OriginalBillPluginControl.updateRowSurplusAndCanCommitAmountNumTax(view, num, amount, tax, index);
            return;
        }
        Object benchMark = view.getModel().getValue("benchmark");
        boolean isAmountMark = "1".equals(benchMark);
        if (!MathUtils.isZero((BigDecimal)taxUnitPrice) && !MathUtils.isZero((BigDecimal)num) && !BotpHelper.isFromAr((Object)view.getModel().getValue("systemsource")) || isAmountMark) {
            OriginalBillPluginControl.numAndUnitPriceNotNull(formPlugin, view, index, taxAmount, amount, tax, num);
            return;
        }
        if (!MathUtils.isZero((BigDecimal)taxUnitPrice) && !MathUtils.isZero((BigDecimal)num) && BotpHelper.isFromAr((Object)view.getModel().getValue("systemsource"))) {
            OriginalBillPluginControl.numAndUnitPriceNotNull2(formPlugin, view, index, taxAmount, amount, tax, true);
            return;
        }
        if (MathUtils.isZero((BigDecimal)taxUnitPrice) && !MathUtils.isZero((BigDecimal)num)) {
            formPlugin.getPageCache().put("do_not_change_unit_price" + index, "1");
            formPlugin.getPageCache().put("do_not_change_tax_unit_price" + index, "1");
            taxUnitPrice = PriceHelper.calcPriceOrNum((BigDecimal)taxAmount, (BigDecimal)num, (boolean)isAllEle);
            view.getModel().setValue("taxunitprice", (Object)taxUnitPrice, index);
            unitPrice = PriceHelper.getUnitPriceByHS((BigDecimal)taxRate, (BigDecimal)num, (BigDecimal)amount, (BigDecimal)taxUnitPrice, (boolean)isAllEle);
            view.getModel().setValue("unitprice", (Object)unitPrice, index);
            formPlugin.getPageCache().remove("do_not_change_unit_price" + index);
            formPlugin.getPageCache().remove("do_not_change_tax_unit_price" + index);
        }
        if (!MathUtils.isZero((BigDecimal)taxUnitPrice) && MathUtils.isZero((BigDecimal)num)) {
            formPlugin.getPageCache().put("do_not_change_num" + index, "1");
            formPlugin.getPageCache().put("do_not_change_unit_price" + index, "1");
            num = UnitPriceHelper.calcNum((BigDecimal)taxAmount, (BigDecimal)taxUnitPrice);
            view.getModel().setValue("num", (Object)num, index);
            unitPrice = PriceHelper.calcPriceOrNum((BigDecimal)amount, (BigDecimal)num, (boolean)isAllEle);
            view.getModel().setValue("unitprice", (Object)unitPrice, index);
            formPlugin.getPageCache().remove("do_not_change_num" + index);
            formPlugin.getPageCache().remove("do_not_change_unit_price" + index);
        }
        OriginalBillPluginControl.updateRowSurplusAndCanCommitAmountNumTax(view, num, amount, tax, index);
    }

    private static void numAndUnitPriceNotNull2(AbstractFormPlugin formPlugin, IFormView view, int index, BigDecimal taxAmount, BigDecimal amount, BigDecimal tax, boolean isContainTax) {
        IDataModel model = formPlugin.getView().getModel();
        BigDecimal unitPrice = (BigDecimal)model.getValue("unitprice");
        BigDecimal taxUnitPrice = (BigDecimal)model.getValue("taxunitprice");
        BigDecimal num = UnitPriceHelper.calcNum((BigDecimal)amount, (BigDecimal)unitPrice);
        if (isContainTax) {
            num = UnitPriceHelper.calcNum((BigDecimal)taxAmount, (BigDecimal)taxUnitPrice);
            OriginalBillPluginControl.setRowValueWithCache(formPlugin, view, taxAmount, index, "do_not_change_tax_amount", "taxamount");
        } else {
            OriginalBillPluginControl.setRowValueWithCache(formPlugin, view, amount, index, "do_not_change_amount", "amount");
        }
        view.getModel().setValue("combineamount", (Object)taxAmount, index);
        OriginalBillPluginControl.setRowValueWithCache(formPlugin, view, num, index, "do_not_change_num", "num");
        OriginalBillPluginControl.updateRowSurplusAndCanCommitAmountNumTax(view, num, amount, tax, index);
    }

    private static void numAndUnitPriceNotNull(AbstractFormPlugin formPlugin, IFormView view, int index, BigDecimal taxAmount, BigDecimal amount, BigDecimal tax, BigDecimal num) {
        Object invoiceType = view.getModel().getValue("invoicetype");
        Object isElePaper = view.getModel().getValue("iselepaper");
        boolean isAllEle = InvoiceUtils.isAllEInvoice((Object)((String)invoiceType)) || "1".equals(isElePaper);
        BigDecimal unitPrice = PriceHelper.calcPriceOrNum((BigDecimal)amount, (BigDecimal)num, (boolean)isAllEle);
        BigDecimal taxUnitPriceNew = PriceHelper.calcPriceOrNum((BigDecimal)taxAmount, (BigDecimal)num, (boolean)isAllEle);
        OriginalBillPluginControl.setRowValueWithCache(formPlugin, view, unitPrice, index, "do_not_change_unit_price", "unitprice");
        OriginalBillPluginControl.setRowValueWithCache(formPlugin, view, taxUnitPriceNew, index, "do_not_change_tax_unit_price", "taxunitprice");
        OriginalBillPluginControl.updateRowSurplusAndCanCommitAmountNumTax(view, num, amount, tax, index);
    }

    public static void changeYHZC(AbstractFormPlugin formPlugin, IFormView view, Object newValue, Object oldValue, int index) {
        if (!StringUtils.isEmpty((CharSequence)formPlugin.getPageCache().get("do_not_change_yhzc" + index))) {
            return;
        }
        if (newValue == null || StringUtils.isEmpty((CharSequence)newValue.toString())) {
            view.getModel().setValue("policylogo", oldValue, index);
            return;
        }
        if ("1".equals(newValue)) {
            view.getModel().setValue("policycontants", (Object)"", index);
        } else {
            if ("0".equals(view.getModel().getValue("taxrate"))) {
                view.getModel().setValue("policycontants", (Object)"\u666e\u901a\u96f6\u7a0e\u7387", index);
            } else {
                view.getModel().setValue("policycontants", (Object)"", index);
            }
            if ("0.015".equals(view.getModel().getValue("taxrate", index)) && InvoiceUtils.isAllEInvoice((Object)view.getModel().getValue("invoicetype"))) {
                view.getModel().setValue("policylogo", oldValue, index);
                view.showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u660e\u7ec6,\u7a0e\u7387\u4e3a\u51cf\u63091.5,\u4f18\u60e0\u653f\u7b56\u5fc5\u987b\u4e3a\u4eab\u53d7,\u4f18\u60e0\u653f\u7b56\u5185\u5bb9\u5fc5\u987b\u4e3a\u63095%%\u7b80\u6613\u5f81\u6536\u51cf\u63091.5%%\u8ba1\u5f81", (String)"OriginalBillPluginControl_35", (String)"imc-sim-service", (Object[])new Object[0]), index + 1), Integer.valueOf(6000));
                view.getModel().setValue("policycontants", (Object)ZzstsglEnum.TEN.getDescription(), index);
            }
        }
        OriginalBillPluginControl.setNextRowPolicylogo(view, newValue, index);
    }

    public static void setNextRowPolicylogo(IFormView view, Object newValue, int index) {
        DynamicObjectCollection items = view.getModel().getEntryEntity("sim_original_bill_item");
        if (index + 1 == items.getRowCount()) {
            return;
        }
        Object nextRowType = view.getModel().getValue("rowtype", index + 1);
        if ("1".equals(nextRowType)) {
            view.getModel().setValue("policylogo", newValue, index + 1);
            ViewUtil.setEntryRowEnable((IFormView)view, (String)"policycontants", (boolean)false, (int)(index + 1));
            ViewUtil.setEntryRowEnable((IFormView)view, (String)"policylogo", (boolean)false, (int)(index + 1));
            if (!"1".equals(newValue)) {
                if ("0".equals(view.getModel().getValue("taxrate"))) {
                    view.getModel().setValue("policycontants", (Object)"\u666e\u901a\u96f6\u7a0e\u7387", index + 1);
                } else {
                    view.getModel().setValue("policycontants", (Object)"", index + 1);
                }
            } else {
                view.getModel().setValue("policycontants", (Object)"", index + 1);
            }
        }
    }

    private static List<Object> getOtherPolicyContents() {
        ArrayList<Object> list = new ArrayList<Object>(10);
        list.add("\u7b80\u6613\u5f81\u6536");
        list.add("\u63093%\u7b80\u6613\u5f81\u6536");
        list.add("\u63095%\u7b80\u6613\u5f81\u6536");
        list.add("\u63095%\u7b80\u6613\u5f81\u6536\u51cf\u63091.5%\u8ba1\u5f81");
        list.add("\u7a00\u571f\u4ea7\u54c1");
        list.add("\u5148\u5f81\u540e\u9000");
        list.add("50%\u5148\u5f81\u540e\u9000");
        list.add("100%\u5148\u5f81\u540e\u9000");
        list.add("\u5373\u5f81\u5373\u900030%");
        list.add("\u5373\u5f81\u5373\u900050%");
        list.add("\u5373\u5f81\u5373\u900070%");
        list.add("\u5373\u5f81\u5373\u9000100%");
        list.add("\u8d85\u7a0e\u8d1f3%\u5373\u5f81\u5373\u9000");
        list.add("\u8d85\u7a0e\u8d1f6%\u5373\u5f81\u5373\u9000");
        list.add("\u8d85\u7a0e\u8d1f8%\u5373\u5f81\u5373\u9000");
        list.add("\u8d85\u7a0e\u8d1f12%\u5373\u5f81\u5373\u9000");
        return list;
    }

    public static void changeYHZCNR(AbstractFormPlugin formPlugin, IFormView view, Object newValue, Object oldValue, int index) {
        if (!StringUtils.isEmpty((CharSequence)formPlugin.getPageCache().get("do_not_change_yhzcnr" + index))) {
            return;
        }
        boolean notAllowChangeTaxRate = OriginalBillPluginControl.isBotpOrBusinessSystem(view);
        if ("1".equals(view.getModel().getValue("policylogo")) && "\u666e\u901a\u96f6\u7a0e\u7387".equals(newValue)) {
            view.getModel().setValue("policycontants", oldValue, index);
            return;
        }
        int nextIndex = index + 1;
        DynamicObjectCollection items = view.getModel().getEntryEntity("sim_original_bill_item");
        boolean hasDiscount = nextIndex < items.size() && "1".equals(((DynamicObject)items.get(index + 1)).getString("rowtype"));
        String taxRate = (String)view.getModel().getValue("taxrate", index);
        if ("\u514d\u7a0e".equals(newValue) || "\u4e0d\u5f81\u7a0e".equals(newValue)) {
            if (notAllowChangeTaxRate && !TaxRate.ZERO_PERCENT.getRateValue().equals(taxRate)) {
                formPlugin.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u660e\u7ec6\uff0c\u4eab\u53d7\u514d\u7a0e\u4f18\u60e0\u653f\u7b56\u65f6\uff0c\u7a0e\u7387\u5e94\u4e3a0%\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u4f18\u60e0\u653f\u7b56\u5185\u5bb9\u3002", (String)"OriginalBillPluginControl_36", (String)"imc-sim-service", (Object[])new Object[0]), nextIndex));
                view.getModel().setValue("policycontants", oldValue, index);
                return;
            }
            view.getModel().setValue("taxrate", (Object)"0", index);
            if (hasDiscount) {
                view.getModel().setValue("policycontants", newValue, nextIndex);
                view.getModel().setValue("taxrate", (Object)"0", nextIndex);
                view.getModel().setValue("tax", (Object)"0", nextIndex);
                view.getModel().setValue("remainvalidtax", (Object)"0", nextIndex);
                formPlugin.getPageCache().put("do_not_change_tax_amount" + index, "1");
                view.getModel().setValue("taxamount", view.getModel().getValue("amount", nextIndex), nextIndex);
                formPlugin.getPageCache().remove("do_not_change_tax_amount" + index);
            }
            return;
        }
        if (!OriginalBillPluginControl.getOtherPolicyContents().contains(newValue)) {
            return;
        }
        if ("\u63093%\u7b80\u6613\u5f81\u6536".equals(newValue)) {
            if (notAllowChangeTaxRate) {
                if (!TaxRate.THREE_PERCENT.getRateValue().equals(taxRate)) {
                    formPlugin.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u660e\u7ec6\uff0c\u4eab\u53d7\u63093%\u7b80\u6613\u5f81\u6536\u4f18\u60e0\u653f\u7b56\u65f6\uff0c\u7a0e\u7387\u5e94\u4e3a3%\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u4f18\u60e0\u653f\u7b56\u5185\u5bb9\u3002", (String)"OriginalBillPluginControl_37", (String)"imc-sim-service", (Object[])new Object[0]), nextIndex));
                    view.getModel().setValue("policycontants", oldValue, index);
                    return;
                }
            } else {
                view.getModel().setValue("taxrate", (Object)TaxRate.THREE_PERCENT.getRateValue(), index);
                if (hasDiscount) {
                    view.getModel().setValue("taxrate", (Object)TaxRate.THREE_PERCENT.getRateValue(), nextIndex);
                }
            }
        } else if ("\u63095%\u7b80\u6613\u5f81\u6536".equals(newValue)) {
            if (notAllowChangeTaxRate) {
                if (!TaxRate.FIVE_PERCENT.getRateValue().equals(taxRate)) {
                    formPlugin.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u660e\u7ec6\uff0c\u4eab\u53d7\u63095%\u7b80\u6613\u5f81\u6536\u4f18\u60e0\u653f\u7b56\u65f6\uff0c\u7a0e\u7387\u5e94\u4e3a5%\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u4f18\u60e0\u653f\u7b56\u5185\u5bb9\u3002", (String)"OriginalBillPluginControl_38", (String)"imc-sim-service", (Object[])new Object[0]), nextIndex));
                    view.getModel().setValue("policycontants", oldValue, index);
                    return;
                }
            } else {
                view.getModel().setValue("taxrate", (Object)TaxRate.FIVE_PERCENT.getRateValue(), index);
                if (hasDiscount) {
                    view.getModel().setValue("taxrate", (Object)TaxRate.FIVE_PERCENT.getRateValue(), nextIndex);
                }
            }
        } else if ("\u63095%\u7b80\u6613\u5f81\u6536\u51cf\u63091.5%\u8ba1\u5f81".equals(newValue)) {
            if (notAllowChangeTaxRate) {
                if (!TaxRate.ONE_POINT_FIVE_PERCENT.getRateValue().equals(taxRate)) {
                    formPlugin.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u660e\u7ec6\uff0c\u4eab\u53d7\u63095%\u7b80\u6613\u5f81\u6536\u51cf\u63091.5%\u8ba1\u5f81\u4f18\u60e0\u653f\u7b56\u65f6\uff0c\u7a0e\u7387\u5e94\u4e3a1.5%\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u4f18\u60e0\u653f\u7b56\u5185\u5bb9\u3002", (String)"OriginalBillPluginControl_39", (String)"imc-sim-service", (Object[])new Object[0]), nextIndex));
                    view.getModel().setValue("policycontants", oldValue, index);
                    return;
                }
            } else {
                view.getModel().setValue("taxrate", (Object)TaxRate.ONE_POINT_FIVE_PERCENT.getRateValue(), index);
                BigDecimal amount = (BigDecimal)view.getModel().getValue("amount", index);
                view.getModel().setValue("amount", (Object)BigDecimal.ZERO, index);
                view.getModel().setValue("amount", (Object)amount, index);
            }
        }
        if (hasDiscount) {
            view.getModel().setValue("policycontants", newValue, nextIndex);
        }
    }

    public static void changeSpecialType(AbstractFormPlugin formPlugin) {
        ImmutableSet immutableSet;
        IFormView view = formPlugin.getView();
        formPlugin.getView().setVisible(Boolean.TRUE, new String[]{"splitrule", "mergerule"});
        formPlugin.getView().setVisible(Boolean.TRUE, new String[]{"unit", "specification", "unitprice", "taxunitprice", "num"});
        Object specialType = view.getModel().getValue("specialtype");
        if ("02".equals(specialType)) {
            view.setEnable(Boolean.FALSE, new String[]{"taxationstyle"});
            view.getModel().setValue("taxationstyle", (Object)"0");
            OriginalBillPluginAddControl.setPurchaseInvoiceCaption(formPlugin, formPlugin.getView());
            AllESpecialTypeControl.dealShowOrHideSpecailAreaMethod(formPlugin);
        } else {
            view.setEnable(Boolean.TRUE, new String[]{"taxationstyle"});
            view.setVisible(Boolean.FALSE, new String[]{"cardtype"});
            OriginalBillPluginAddControl.setNormalInvoiceCaption(formPlugin, formPlugin.getView());
            AllESpecialTypeControl.showOrHideFields(formPlugin, false);
            AllESpecialTypeControl.dealShowOrHideSpecailAreaMethod(formPlugin);
        }
        if ("3".equals(view.getModel().getValue("taxationstyle")) && !(immutableSet = ImmutableSet.of((Object)"00", (Object)"E06")).contains(view.getModel().getValue("specialtype"))) {
            view.setVisible(Boolean.FALSE, new String[]{"reductiontaxtype"});
            view.getModel().setValue("taxationstyle", (Object)"00");
            view.showTipNotification(ResManager.loadKDString((String)"\u7279\u6b8a\u7968\u79cd\u53ea\u670906\u4e0d\u52a8\u4ea7\u7ecf\u8425\u79df\u8d41\u670d\u52a1\u652f\u6301\u51cf\u6309\u5f81\u7a0e", (String)"OriginalBillPluginControl_34", (String)"imc-sim-service", (Object[])new Object[0]));
        }
    }

    public static void changeTaxAdjust(AbstractFormPlugin formPlugin, IFormView view, Object newValue, Object oldValue, int index) {
        if (!StringUtils.isEmpty((CharSequence)formPlugin.getPageCache().get("do_not_change_tax" + index)) || !((Boolean)view.getModel().getValue("taxadjust")).booleanValue()) {
            if (RequestContext.get().getRequestId() != null && !RequestContext.get().getRequestId().equals(formPlugin.getPageCache().get("taxRequestId"))) {
                formPlugin.getPageCache().remove("oldAmountCache");
                formPlugin.getPageCache().remove("oldTaxCache");
            }
            return;
        }
        String requestId = RequestContext.get().getRequestId();
        formPlugin.getPageCache().put("taxRequestId", requestId);
        BigDecimal taxNewValue = (BigDecimal)newValue;
        BigDecimal taxOldValue = (BigDecimal)oldValue;
        BigDecimal taxaTount = (BigDecimal)view.getModel().getValue("taxamount", index);
        String taxRate = view.getModel().getValue("taxrate", index).toString();
        BigDecimal standardTax = TaxCalcUtil.calTax((BigDecimal)taxaTount, (BigDecimal)BigDecimal.ZERO, (String)taxRate, (boolean)true, (int)2);
        BigDecimal oldAmount = (BigDecimal)formPlugin.getView().getModel().getValue("amount");
        BigDecimal diff = OriginalBillPluginControl.getItemMaxTaxDiff(formPlugin);
        BigDecimal subtractABS = taxNewValue.subtract(standardTax).abs().setScale(2, 4);
        if (subtractABS.compareTo(diff) > 0) {
            OriginalBillPluginControl.setRowValueWithCache(formPlugin, view, oldValue, index, "do_not_change_tax", "tax");
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f00\u542f\u7a0e\u989d\u5fae\u8c03\u65f6\uff0c\u7a0e\u989d\u8c03\u6574\u540e\u5c3e\u5dee\u4e0d\u80fd\u8d85\u8fc7\u00b1%1$s\uff0c\u539f\u7a0e\u989d\u4e3a%2$s\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539!", (String)"OriginalBillPluginControl_12", (String)"imc-sim-service", (Object[])new Object[0]), diff.abs(), taxOldValue.setScale(2, 4)));
            return;
        }
        BigDecimal taxSub = standardTax.subtract(taxNewValue);
        BigDecimal num = (BigDecimal)formPlugin.getView().getModel().getValue("num");
        BigDecimal unitprice = (BigDecimal)formPlugin.getView().getModel().getValue("unitprice");
        if (num.compareTo(BigDecimal.ZERO) != 0 && unitprice.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal unitAmount = num.multiply(unitprice).setScale(2, 4);
            if (taxaTount.subtract(taxNewValue).subtract(unitAmount).abs().compareTo(new BigDecimal("0.01")) > 0) {
                BigDecimal oriTax = unitAmount.multiply(new BigDecimal(view.getModel().getValue("taxrate", index).toString())).setScale(2, 4);
                OriginalBillPluginControl.setRowValueWithCache(formPlugin, view, oldValue, index, "do_not_change_tax", "tax");
                view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f00\u542f\u7a0e\u989d\u5fae\u8c03\u65f6\uff0c\u660e\u7ec6\u4e0d\u542b\u7a0e\u91d1\u989d\u8bef\u5dee\u8d85\u8fc7\u00b10.01\uff0c\u6570\u91cf\u548c\u4e0d\u542b\u7a0e\u5355\u4ef7\u6240\u5f97\u7684\u4e0d\u542b\u7a0e\u91d1\u989d\u4e3a%1$s\uff0c\u7a0e\u989d\u4e3a%2$s\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539!", (String)"OriginalBillPluginControl_13", (String)"imc-sim-service", (Object[])new Object[0]), unitAmount, oriTax));
                return;
            }
        }
        view.getModel().setValue("remainvalidtax", newValue, index);
        BigDecimal newAmount = oldAmount.add(taxSub).add(taxOldValue.subtract(standardTax));
        OriginalBillPluginControl.setRowValueWithCache(formPlugin, view, newAmount, index, "do_not_change_amount", "amount");
        if (view.getModel().getValue("hsbz").equals("0")) {
            view.getModel().setValue("remainvalidamount", (Object)newAmount, index);
        }
        formPlugin.getPageCache().put("DIFF" + view.getModel().getValue("billno"), "0");
        formPlugin.getView().addClientCallBack(UPDATE_BILL_TOTAL_AMOUNT, Integer.valueOf(100));
    }

    private static BigDecimal getItemMaxTaxDiff(AbstractFormPlugin formPlugin) {
        String itemsMaxTaxDiff = formPlugin.getPageCache().get("itemsMaxTaxDiff");
        if (StringUtils.isNotBlank((CharSequence)itemsMaxTaxDiff)) {
            return new BigDecimal(itemsMaxTaxDiff);
        }
        String invoiceType = (String)formPlugin.getView().getModel().getValue("invoicetype");
        if (InvoiceUtils.isAllEInvoice((Object)invoiceType)) {
            return InvoiceConstant.DIFFF_06;
        }
        String jqbh = (String)formPlugin.getView().getModel().getValue("jqbh");
        if (StringUtils.isBlank((CharSequence)jqbh)) {
            return InvoiceConstant.DIFFF_06;
        }
        return new BillMergeHelper().getItemsMaxTaxDiff(jqbh);
    }

    public static void afterF7TaxCode(int selectRow, IFormView view) {
        DynamicObject taxRateCode = (DynamicObject)view.getModel().getValue("taxratecodeid", selectRow);
        if (taxRateCode != null) {
            Object zsfs = view.getModel().getValue("taxationstyle");
            if (ReducedHelper.isReduced((Object)zsfs) && !ReducedHelper.isTaxRateCodeisReduced((DynamicObject)taxRateCode)) {
                view.getModel().setValue("taxratecodeid", null, selectRow);
                view.showErrorNotification(ResManager.loadKDString((String)"\u51cf\u6309\u8ba1\u5f81\u53ea\u80fd\u9009\u62e9\u4f18\u60e0\u653f\u7b56\u5185\u5bb9\u4e3a\u7b80\u6613\u5f81\u6536\u7684\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\uff01", (String)"OriginalBillPluginControl_28", (String)"imc-sim-service", (Object[])new Object[0]));
                return;
            }
            OriginalBillPluginTaxCodeControl.updateRowTaxCode(view, selectRow, taxRateCode, false);
            try {
                Object nextRowType;
                if (view.getModel().getValue("amount", selectRow + 1) != null && "1".equals(nextRowType = view.getModel().getValue("rowtype", selectRow + 1))) {
                    view.getModel().setValue("taxratecodeid", taxRateCode.get("id"), selectRow + 1);
                    OriginalBillPluginTaxCodeControl.updateRowTaxCode(view, selectRow + 1, taxRateCode, false);
                }
            }
            catch (Exception e) {
                LOGGER.error("\u66f4\u65b0\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public static void afterF7Materiel(int selectRow, IFormView view) {
        DynamicObject material = (DynamicObject)view.getModel().getValue("materielfield", selectRow);
        if (material != null) {
            view.getModel().setValue("goodsname", (Object)material.getString("name"));
        }
    }

    public static void afterF7ExpenseItem(int selectRow, IFormView view) {
        DynamicObject expenseItem = (DynamicObject)view.getModel().getValue("expenseitem", selectRow);
        if (expenseItem != null) {
            view.getModel().setValue("goodsname", (Object)expenseItem.getString("name"));
        }
    }

    public static void changeFromAmount(IFormView view, Object newValue, Object oldValue, int editIndex) {
        Object invoiceType = view.getModel().getValue("invoicetype");
        Object isElePaper = view.getModel().getValue("iselepaper");
        boolean isAllEle = InvoiceUtils.isAllEInvoice((Object)((String)invoiceType)) || "1".equals(isElePaper);
        BigDecimal taxRate = new BigDecimal((String)view.getModel().getValue("taxrate", editIndex));
        BigDecimal fromAmount = (BigDecimal)newValue;
        IDataModel model = view.getModel();
        DynamicObject fromCurr = (DynamicObject)model.getValue("fromcurr");
        if (null == fromCurr) {
            throw new KDBizException(ResManager.loadKDString((String)"\u539f\u5e01\u6c47\u7387\u5fc5\u586b", (String)"OriginalBillPluginControl_5", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        int amtPrecision = fromCurr.getInt("amtprecision");
        BigDecimal fromTax = fromAmount.multiply(taxRate).setScale(amtPrecision, RoundingMode.HALF_UP);
        BigDecimal fromTaxAmount = fromAmount.add(fromTax);
        BigDecimal exRate = (BigDecimal)model.getValue("exrate");
        String quotation = (String)model.getValue("quotation");
        BigDecimal newAmount = CurrencyHelper.calToAmount((String)quotation, (BigDecimal)exRate, (BigDecimal)fromAmount);
        BigDecimal newTax = newAmount.multiply(taxRate).setScale(2, RoundingMode.HALF_UP);
        BigDecimal newTaxAmount = newAmount.add(newTax);
        BigDecimal num = (BigDecimal)model.getValue("num");
        BigDecimal newTaxUnitPrice = BigDecimal.ZERO;
        BigDecimal newPrice = BigDecimal.ZERO;
        BigDecimal fromPrice = (BigDecimal)model.getValue("fromprice", editIndex);
        if (!OriginalBillPluginControl.checkBillProperty(fromAmount, view, oldValue, "fromamount", editIndex)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u4fee\u6539\u503c\u4e0e\u5355\u636e\u6027\u8d28\u4e0d\u7b26", (String)"OriginalBillPluginControl_14", (String)"imc-sim-service", (Object[])new Object[0]));
            return;
        }
        Object benchMark = model.getValue("benchmark");
        String cacheKey = "not_property_change" + view.getPageId();
        view.getPageCache().put(cacheKey, cacheKey);
        if (MathUtils.isNotZero((BigDecimal)fromPrice) && !"1".equals(benchMark)) {
            num = UnitPriceHelper.calcNum((BigDecimal)fromAmount, (BigDecimal)fromPrice);
            model.setValue("num", (Object)num, editIndex);
            model.setValue("combinenum", (Object)num, editIndex);
            model.setValue("remainvalidnum", (Object)num, editIndex);
        }
        if (MathUtils.isNotZero((BigDecimal)num)) {
            newTaxUnitPrice = PriceHelper.calcPriceOrNum((BigDecimal)newTaxAmount, (BigDecimal)num, (boolean)isAllEle);
            newPrice = PriceHelper.calcPriceOrNum((BigDecimal)newAmount, (BigDecimal)num, (boolean)isAllEle);
        }
        model.setValue("amount", (Object)newAmount, editIndex);
        model.setValue("taxamount", (Object)newTaxAmount, editIndex);
        model.setValue("unitprice", (Object)newPrice, editIndex);
        model.setValue("taxunitprice", (Object)newTaxUnitPrice, editIndex);
        model.setValue("fromtaxamount", (Object)fromTaxAmount, editIndex);
        model.setValue("fromtax", (Object)fromTax, editIndex);
        model.setValue("tax", (Object)newTax, editIndex);
        model.setValue("remainvalidtax", (Object)newTax, editIndex);
        model.setValue("remainvalidamount", (Object)newAmount, editIndex);
        model.setValue("combinelocalamount", (Object)newTaxAmount, editIndex);
        model.setValue("combineamount", (Object)fromTaxAmount, editIndex);
        if ("1".equals(benchMark)) {
            model.setValue("fromprice", (Object)fromAmount);
            model.setValue("fromtaxprice", (Object)fromTaxAmount);
        }
        OriginalBillPluginControl.countHeadAmount(model);
        view.getPageCache().remove(cacheKey);
    }

    private static boolean checkBillProperty(BigDecimal fromAmount, IFormView view, Object oldValue, String key, int editIndex) {
        Object billPropertie = view.getModel().getValue("billproperties");
        try {
            if (MathUtils.isZero((BigDecimal)fromAmount)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4fee\u6539\u503c\u4e0e\u5355\u636e\u6027\u8d28\u4e0d\u7b26", (String)"OriginalBillPluginControl_14", (String)"imc-sim-service", (Object[])new Object[0]));
            }
            if (BigDecimalUtil.lessZero((BigDecimal)fromAmount) && "1".equals(billPropertie)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4fee\u6539\u503c\u4e0e\u5355\u636e\u6027\u8d28\u4e0d\u7b26", (String)"OriginalBillPluginControl_14", (String)"imc-sim-service", (Object[])new Object[0]));
            }
            if (BigDecimalUtil.greaterZero((BigDecimal)fromAmount) && "-1".equals(billPropertie)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4fee\u6539\u503c\u4e0e\u5355\u636e\u6027\u8d28\u4e0d\u7b26", (String)"OriginalBillPluginControl_14", (String)"imc-sim-service", (Object[])new Object[0]));
            }
        }
        catch (KDBizException e) {
            OriginalBillHelper.noReact((IFormView)view);
            view.getModel().setValue(key, oldValue, editIndex);
            OriginalBillHelper.react((IFormView)view);
            return false;
        }
        return true;
    }

    public static void changeFromTaxAmount(IFormView view, Object newValue, Object oldValue, int editIndex) {
        BigDecimal taxRate = new BigDecimal((String)view.getModel().getValue("taxrate", editIndex));
        BigDecimal fromTaxAmount = (BigDecimal)newValue;
        IDataModel model = view.getModel();
        Object invoiceType = model.getValue("invoicetype");
        Object isElePaper = model.getValue("iselepaper");
        boolean isAllEle = InvoiceUtils.isAllEInvoice((Object)((String)invoiceType)) || "1".equals(isElePaper);
        DynamicObject fromCurr = (DynamicObject)model.getValue("fromcurr");
        if (null == fromCurr) {
            throw new KDBizException(ResManager.loadKDString((String)"\u539f\u5e01\u6c47\u7387\u5fc5\u586b", (String)"OriginalBillPluginControl_5", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        int amtPrecision = fromCurr.getInt("amtprecision");
        BigDecimal fromAmount = fromTaxAmount.multiply(BigDecimal.ONE.divide(BigDecimal.ONE.add(taxRate), 20, RoundingMode.HALF_UP)).setScale(amtPrecision, RoundingMode.HALF_UP);
        BigDecimal fromTax = fromTaxAmount.subtract(fromAmount);
        BigDecimal exRate = (BigDecimal)model.getValue("exrate");
        String quotation = (String)model.getValue("quotation");
        BigDecimal newTaxAmount = CurrencyHelper.calToAmount((String)quotation, (BigDecimal)exRate, (BigDecimal)fromTaxAmount);
        BigDecimal newAmount = newTaxAmount.multiply(BigDecimal.ONE.divide(BigDecimal.ONE.add(taxRate), 20, RoundingMode.HALF_UP)).setScale(2, RoundingMode.HALF_UP);
        BigDecimal newTax = newTaxAmount.subtract(newAmount);
        BigDecimal num = (BigDecimal)model.getValue("num", editIndex);
        BigDecimal fromTaxPrice = (BigDecimal)model.getValue("fromtaxprice", editIndex);
        BigDecimal newTaxUnitPrice = BigDecimal.ZERO;
        if (!OriginalBillPluginControl.checkBillProperty(fromAmount, view, oldValue, "fromtaxamount", editIndex)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u4fee\u6539\u503c\u4e0e\u5355\u636e\u6027\u8d28\u4e0d\u7b26", (String)"OriginalBillPluginControl_14", (String)"imc-sim-service", (Object[])new Object[0]));
            return;
        }
        Object benchMark = model.getValue("benchmark");
        String cacheKey = "not_property_change" + view.getPageId();
        view.getPageCache().put(cacheKey, cacheKey);
        if (MathUtils.isNotZero((BigDecimal)fromTaxPrice) && !"1".equals(benchMark)) {
            num = UnitPriceHelper.calcNum((BigDecimal)fromTaxAmount, (BigDecimal)fromTaxPrice);
            model.setValue("num", (Object)num, editIndex);
            model.setValue("combinenum", (Object)num, editIndex);
            model.setValue("remainvalidnum", (Object)num, editIndex);
        }
        BigDecimal newPrice = BigDecimal.ZERO;
        if (MathUtils.isNotZero((BigDecimal)num)) {
            newTaxUnitPrice = PriceHelper.calcPriceOrNum((BigDecimal)newTaxAmount, (BigDecimal)num, (boolean)isAllEle);
            newPrice = PriceHelper.calcPriceOrNum((BigDecimal)newAmount, (BigDecimal)num, (boolean)isAllEle);
        }
        view.getPageCache().put(cacheKey, cacheKey);
        model.setValue("amount", (Object)newAmount, editIndex);
        model.setValue("taxamount", (Object)newTaxAmount, editIndex);
        model.setValue("unitprice", (Object)newPrice, editIndex);
        model.setValue("taxunitprice", (Object)newTaxUnitPrice, editIndex);
        model.setValue("fromamount", (Object)fromAmount, editIndex);
        model.setValue("fromtax", (Object)fromTax, editIndex);
        model.setValue("remainvalidtax", (Object)newTax, editIndex);
        model.setValue("tax", (Object)newTax, editIndex);
        model.setValue("remainvalidamount", (Object)newTaxAmount, editIndex);
        model.setValue("combinelocalamount", (Object)newTaxAmount, editIndex);
        model.setValue("combineamount", (Object)fromTaxAmount, editIndex);
        if ("1".equals(benchMark)) {
            model.setValue("fromprice", (Object)fromAmount);
            model.setValue("fromtaxprice", (Object)fromTaxAmount);
        }
        OriginalBillPluginControl.countHeadAmount(model);
        view.getPageCache().remove(cacheKey);
    }

    public static void countHeadAmount(IDataModel model) {
        DynamicObjectCollection itemList = model.getEntryEntity("sim_original_bill_item");
        BigDecimal totalFromAmount = BigDecimal.ZERO;
        BigDecimal totalFromTax = BigDecimal.ZERO;
        BigDecimal invoiceAmount = BigDecimal.ZERO;
        BigDecimal totalTax = BigDecimal.ZERO;
        for (DynamicObject item : itemList) {
            BigDecimal amount = item.getBigDecimal("amount");
            BigDecimal tax = item.getBigDecimal("tax");
            BigDecimal fromAmount = item.getBigDecimal("fromamount");
            BigDecimal fromTax = item.getBigDecimal("fromtax");
            totalTax = totalTax.add(tax);
            invoiceAmount = invoiceAmount.add(amount);
            totalFromAmount = totalFromAmount.add(fromAmount);
            totalFromTax = totalFromTax.add(fromTax);
        }
        BigDecimal totalAmount = totalTax.add(invoiceAmount);
        BigDecimal totalFromTaxAmount = totalFromAmount.add(totalFromTax);
        model.setValue("foreigninvoiceamount", (Object)totalFromAmount);
        model.setValue("foreigntax", (Object)totalFromTax);
        model.setValue("foreigntotalamount", (Object)totalFromTaxAmount);
        model.setValue("totalamount", (Object)totalAmount);
        model.setValue("oldtotalamount", (Object)totalAmount);
        model.setValue("totaltax", (Object)totalTax);
        model.setValue("invoiceamount", (Object)invoiceAmount);
        model.setValue("surplustax", (Object)totalTax);
        model.setValue("surplusamount", (Object)invoiceAmount);
    }

    public static boolean changeFromGift(IFormView view, Object newValue, Object oldValue, int editIndex) {
        try {
            DynamicObjectCollection items = view.getModel().getEntryEntity("sim_original_bill_item");
            DynamicObject editItem = (DynamicObject)items.get(editIndex);
            if (!((Boolean)newValue).booleanValue()) {
                return true;
            }
            if ("1".equals(editItem.getString("rowtype"))) {
                OriginalBillPluginControl.rockBackGift(view, oldValue);
                throw new KDBizException(ResManager.loadKDString((String)"\u6298\u6263\u884c\u4e0d\u80fd\u662f\u8d60\u54c1\u884c", (String)"OriginalBillPluginControl_15", (String)"imc-sim-service", (Object[])new Object[0]));
            }
            int nextIndex = editIndex + 1;
            if (items.getRowCount() == nextIndex) {
                return true;
            }
            DynamicObject nextItem = (DynamicObject)items.get(nextIndex);
            if ("1".equals(nextItem.getString("rowtype"))) {
                OriginalBillPluginControl.rockBackGift(view, oldValue);
                throw new KDBizException(ResManager.loadKDString((String)"\u6298\u6263\u884c\u4e0a\u9762\u4e00\u884c\u4e0d\u80fd\u662f\u8d60\u54c1\u884c", (String)"OriginalBillPluginControl_16", (String)"imc-sim-service", (Object[])new Object[0]));
            }
        }
        catch (KDBizException e) {
            view.showTipNotification(e.getMessage(), Integer.valueOf(2000));
            return false;
        }
        return true;
    }

    private static void rockBackGift(IFormView view, Object oldValue) {
        view.getPageCache().put(DOES_NOT_CHANGE, DOES_NOT_CHANGE);
        view.getModel().setValue("gift", oldValue);
        view.getPageCache().remove(DOES_NOT_CHANGE);
    }

    public static void changeModelNumRate(IFormView view, Object newValue, Object oldValue, int editIndex) {
        IDataModel model = view.getModel();
        BigDecimal newNumRate = (BigDecimal)newValue;
        if (BigDecimalUtil.compareZero((BigDecimal)newNumRate) || BigDecimalUtil.lessZero((BigDecimal)newNumRate)) {
            model.setValue("modelnumrate", oldValue, editIndex);
            return;
        }
        Object invoiceType = model.getValue("invoicetype");
        Object isElePaper = model.getValue("iselepaper");
        boolean isAllEle = InvoiceUtils.isAllEInvoice((Object)((String)invoiceType)) || "1".equals(isElePaper);
        BigDecimal oriNum = (BigDecimal)view.getModel().getValue("orinum", editIndex);
        BigDecimal newNum = UnitPriceHelper.getNumValue((BigDecimal)oriNum.multiply(newNumRate));
        model.beginInit();
        view.getModel().setValue("num", (Object)newNum, editIndex);
        view.getModel().setValue("remainvalidnum", (Object)newNum, editIndex);
        BigDecimal amount = (BigDecimal)model.getValue("amount", editIndex);
        BigDecimal taxAmount = (BigDecimal)model.getValue("taxamount", editIndex);
        BigDecimal fromAmount = (BigDecimal)model.getValue("fromamount", editIndex);
        BigDecimal fromTaxAmount = (BigDecimal)model.getValue("fromtaxamount", editIndex);
        model.setValue("unitprice", (Object)PriceHelper.getValue((BigDecimal)amount.divide(newNum, 20, RoundingMode.HALF_UP), (boolean)isAllEle), editIndex);
        model.setValue("taxunitprice", (Object)PriceHelper.getValue((BigDecimal)taxAmount.divide(newNum, 20, RoundingMode.HALF_UP), (boolean)isAllEle), editIndex);
        DynamicObject fromCurr = (DynamicObject)model.getValue("fromcurr");
        if (CurrencyHelper.isFrom((Object)fromCurr)) {
            int precision = fromCurr.getInt("amtprecision");
            model.setValue("fromprice", (Object)fromAmount.divide(newNum, precision, RoundingMode.HALF_UP), editIndex);
            model.setValue("fromtaxprice", (Object)fromTaxAmount.divide(newNum, precision, RoundingMode.HALF_UP), editIndex);
        } else {
            model.setValue("fromprice", model.getValue("unitprice"), editIndex);
            model.setValue("fromtaxprice", model.getValue("taxunitprice"), editIndex);
        }
        BigDecimal oriModelExchangeRate = (BigDecimal)model.getValue("orimodelnumrate", editIndex);
        BigDecimal currentExchangeRate = oriModelExchangeRate.divide(newNumRate, 4, RoundingMode.HALF_UP);
        model.setValue("CURRENTMODELNUMRATE", (Object)currentExchangeRate, editIndex);
        model.endInit();
        view.updateView("unitprice", editIndex);
        view.updateView("taxunitprice", editIndex);
        view.updateView("fromprice", editIndex);
        view.updateView("fromtaxprice", editIndex);
        view.updateView("num", editIndex);
        view.updateView("remainvalidnum", editIndex);
        view.updateView("CURRENTMODELNUMRATE", editIndex);
    }

    public static void initInvoiceSpecialType(AbstractFormPlugin plugin, String invoiceType) {
        HashMap<String, String> specialTypeMap = new HashMap<String, String>(16);
        specialTypeMap.put(ResManager.loadKDString((String)"\u975e\u7279\u6b8a\u7968\u79cd", (String)"OriginalBillPluginControl_17", (String)"imc-sim-service", (Object[])new Object[0]), "00");
        Object isElePaper = plugin.getView().getModel().getValue("iselepaper");
        if (InvoiceUtils.isAllEInvoice((Object)invoiceType) || AllEleAuthHelper.isElePaper((Object)isElePaper)) {
            specialTypeMap.put(ResManager.loadKDString((String)"\u4e0d\u52a8\u4ea7\u7ecf\u8425\u79df\u8d41", (String)"OriginalBillPluginControl_18", (String)"imc-sim-service", (Object[])new Object[0]), "E06");
            specialTypeMap.put(ResManager.loadKDString((String)"\u4e0d\u52a8\u4ea7\u9500\u552e", (String)"OriginalBillPluginControl_19", (String)"imc-sim-service", (Object[])new Object[0]), "E05");
            specialTypeMap.put(ResManager.loadKDString((String)"\u5efa\u7b51\u670d\u52a1", (String)"OriginalBillPluginControl_20", (String)"imc-sim-service", (Object[])new Object[0]), "E03");
            specialTypeMap.put(ResManager.loadKDString((String)"\u8d27\u7269\u8fd0\u8f93", (String)"OriginalBillPluginControl_21", (String)"imc-sim-service", (Object[])new Object[0]), "E04");
            specialTypeMap.put(ResManager.loadKDString((String)"\u6210\u54c1\u6cb9", (String)"OriginalBillPluginControl_22", (String)"imc-sim-service", (Object[])new Object[0]), "E01");
            specialTypeMap.put(ResManager.loadKDString((String)"\u5377\u70df", (String)"OriginalBillPluginControl_23", (String)"imc-sim-service", (Object[])new Object[0]), "E18");
            specialTypeMap.put(ResManager.loadKDString((String)"\u81ea\u4ea7\u519c\u4ea7\u54c1\u9500\u552e", (String)"CreateInvoiceEInvoiceControl_9", (String)"imc-sim-service", (Object[])new Object[0]), "E12");
            specialTypeMap.put(ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93", (String)"OriginalBillPluginControl_29", (String)"imc-sim-service", (Object[])new Object[0]), "E09");
            if (InvoiceUtils.isAllESpecialInvoice((String)invoiceType)) {
                specialTypeMap.put(ResManager.loadKDString((String)"\u673a\u52a8\u8f66", (String)"CreateInvoiceEInvoiceControl_8", (String)"imc-sim-service", (Object[])new Object[0]), "E14");
            }
            if (InvoiceType.ALL_E_NORMAL.getTypeCode().equals(invoiceType)) {
                specialTypeMap.put(ResManager.loadKDString((String)"\u4ee3\u6536\u8f66\u8239\u7a0e", (String)"OriginalBillPluginControl_33", (String)"imc-sim-service", (Object[])new Object[0]), "E07");
                specialTypeMap.put(ResManager.loadKDString((String)"\u6536\u8d2d", (String)"OriginalBillPluginControl_24", (String)"imc-sim-service", (Object[])new Object[0]), "02");
            }
        } else {
            specialTypeMap.put(ResManager.loadKDString((String)"\u6536\u8d2d", (String)"OriginalBillPluginControl_24", (String)"imc-sim-service", (Object[])new Object[0]), "02");
            specialTypeMap.put(ResManager.loadKDString((String)"\u62b5\u6263\u901a\u884c\u8d39", (String)"OriginalBillPluginControl_25", (String)"imc-sim-service", (Object[])new Object[0]), "06");
            specialTypeMap.put(ResManager.loadKDString((String)"\u4e0d\u62b5\u6263\u901a\u884c\u8d39", (String)"OriginalBillPluginControl_26", (String)"imc-sim-service", (Object[])new Object[0]), "07");
            specialTypeMap.put(ResManager.loadKDString((String)"\u6210\u54c1\u6cb9", (String)"OriginalBillPluginControl_22", (String)"imc-sim-service", (Object[])new Object[0]), "08");
            specialTypeMap.put(ResManager.loadKDString((String)"\u5377\u70df", (String)"OriginalBillPluginControl_23", (String)"imc-sim-service", (Object[])new Object[0]), "11");
        }
        if (InvoiceUtils.isSpecialInvoice((String)invoiceType) && !AllEleAuthHelper.isElePaper((Object)isElePaper)) {
            specialTypeMap.put(ResManager.loadKDString((String)"\u673a\u52a8\u8f66", (String)"OriginalBillPluginControl_27", (String)"imc-sim-service", (Object[])new Object[0]), "18");
        }
        String specialType = String.valueOf(plugin.getView().getModel().getValue("specialtype"));
        if (!specialTypeMap.values().contains(specialType)) {
            plugin.getView().getModel().setValue("specialtype", (Object)"00");
        }
        ViewUtil.setDropDownViewData((AbstractFormPlugin)plugin, (String)"specialtype", specialTypeMap);
        if (AllEleAuthHelper.isElePaper((Object)isElePaper)) {
            invoiceType = InvoiceType.ALL_E_NORMAL.getTypeCode();
        }
        OriginalBillPluginControl.initInvoiceTaxationStyle(plugin, invoiceType);
    }

    private static void initInvoiceTaxationStyle(AbstractFormPlugin plugin, String invoiceType) {
        ComboEdit taxationStyleComboEdit = (ComboEdit)plugin.getControl("taxationstyle");
        ComboProp pros = (ComboProp)taxationStyleComboEdit.getProperty();
        List comboItems = pros.getComboItems();
        HashMap<String, String> taxationStyleMap = new HashMap<String, String>();
        boolean allEInvoice = InvoiceUtils.isAllEInvoice((Object)invoiceType);
        for (ValueMapItem comboItem : comboItems) {
            String value = comboItem.getValue();
            if ("0".equals(value)) {
                taxationStyleMap.put(comboItem.getName().getLocaleValue(), value);
            }
            if (allEInvoice) {
                if ("1".equals(value) || "2".equals(value)) continue;
                taxationStyleMap.put(comboItem.getName().getLocaleValue(), value);
                continue;
            }
            if (!"1".equals(value) && !"2".equals(value)) continue;
            taxationStyleMap.put(comboItem.getName().getLocaleValue(), value);
        }
        if (allEInvoice && "02".equals(plugin.getView().getModel().getValue("specialtype"))) {
            plugin.getView().setVisible(Boolean.TRUE, new String[]{"cardtype"});
        } else {
            plugin.getView().setVisible(Boolean.FALSE, new String[]{"cardtype"});
        }
        String taxationStyle = String.valueOf(plugin.getView().getModel().getValue("taxationstyle"));
        if (!taxationStyleMap.values().contains(taxationStyle)) {
            plugin.getView().getModel().setValue("taxationstyle", (Object)"0");
        }
        ViewUtil.setDropDownViewData((AbstractFormPlugin)plugin, (String)"taxationstyle", taxationStyleMap);
    }

    public static void afterF7UnitSelect(int editIndex, IFormView view) {
        IDataModel model = view.getModel();
        DynamicObject material = (DynamicObject)model.getValue("materielfield");
        DynamicObject unitObj = (DynamicObject)model.getValue("unitfield", editIndex);
        Object unitPk = unitObj.getPkValue();
        QFilter qFilter = new QFilter("measureunitid", "=", unitPk);
        DynamicObject[] units = MaterialInfoUtil.querySourceUnitByMater((Object)material.getPkValue(), (List)Lists.newArrayList((Object[])new QFilter[]{qFilter}));
        if (units.length == 0) {
            model.setValue("modelnumrate", (Object)BigDecimal.ONE, editIndex);
            return;
        }
        DynamicObject unit = units[0];
        String unitName = ((OrmLocaleValue)unit.getDynamicObject("measureunitid").get("name")).getLocaleValue();
        model.setValue("unit", (Object)unitName);
        BigDecimal newModelNumRate = unit.getBigDecimal("numerator").divide(unit.getBigDecimal("denominator"), 8, 4).stripTrailingZeros();
        BigDecimal oriModelRate = (BigDecimal)model.getValue("orimodelnumrate", editIndex);
        model.setValue("CURRENTMODELNUMRATE", (Object)newModelNumRate, editIndex);
        model.setValue("modelnumrate", (Object)oriModelRate.divide(newModelNumRate, 6, RoundingMode.HALF_UP), editIndex);
    }

    public static void updateNation(AbstractFormPlugin plugin) {
        String buyerTaxNo;
        String cardType;
        DynamicObject queryNation;
        boolean isAllEle;
        IFormView view = plugin.getView();
        IDataModel model = plugin.getView().getModel();
        Object specialType = model.getValue("specialtype");
        boolean bl = isAllEle = InvoiceUtils.isAllEInvoice((Object)model.getValue("invoicetype")) || AllEleAuthHelper.isElePaper((Object)model.getValue("iselepaper"));
        if (isAllEle && "02".equals(specialType) && null != (queryNation = InvoiceUtils.getNation((String)(cardType = (String)model.getValue("cardtype")), (String)(buyerTaxNo = (String)model.getValue("buyertaxno"))))) {
            model.setValue("nation", (Object)queryNation);
            view.updateView("nation");
        }
    }

    static boolean isBotpOrBusinessSystem(IFormView view) {
        return "2".equals(view.getModel().getValue("billsource")) || BotpHelper.isArBotpCompleteBill((Object)view.getModel().getValue("systemsource"), (Object)view.getModel().getValue("billcomplete")) || "3".equals(view.getModel().getValue("billsource"));
    }
}

