/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill.control;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.helper.cache.TaxClassCodeCheckHelper;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.constant.BillConstant;
import kd.imc.sim.common.helper.RedInfoHelper;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.sdk.annotation.SdkDeprecated;

public class OriginalBillPluginCopyRedInfoControl {
    public static final String FILL_COPY_INFO = "fillCopyInfo";
    private static final Log LOGGER = LogFactory.getLog(OriginalBillPluginCopyRedInfoControl.class);
    public static final String ITEM_TYPE = "itemType";
    public static final String FROM_RED_INFO = "fromRedInfo";
    public static final String FROM_INVOICE = "fromInvoice";

    public static void copyVatInvoiceDetail(AbstractFormPlugin that, DynamicObject[] vatInvoices) {
        if (OriginalBillPluginCopyRedInfoControl.isFromRedInfo(that)) {
            return;
        }
        if (OriginalBillPluginCopyRedInfoControl.checkItemFrom(that)) {
            return;
        }
        that.getPageCache().put(FILL_COPY_INFO, "1");
        that.getView().getModel().deleteEntryData("sim_original_bill_item");
        IFormView view = that.getView();
        Integer lastRow = null;
        boolean lastRedRemainAmountExist = true;
        boolean isContinue = false;
        for (DynamicObject vatInvoice : vatInvoices) {
            DynamicObjectCollection items = vatInvoice.getDynamicObjectCollection("items");
            QFilter qFilter = new QFilter("id", "=", (Object)vatInvoice.getLong("id"));
            qFilter.and("items.seq", "=", (Object)0);
            boolean startZero = QueryServiceHelper.exists((String)"sim_vatinvoice", (QFilter[])qFilter.toArray());
            int itemsSize = items.size();
            boolean isRedAmountNotAllZero = false;
            for (DynamicObject item : items) {
                if (item.getBigDecimal("itemremainredamount").compareTo(BigDecimal.ZERO) == 0) continue;
                isRedAmountNotAllZero = true;
                break;
            }
            for (int i = 0; i < itemsSize; ++i) {
                DynamicObject nextRow;
                String nextRowType;
                DynamicObject infoItem = (DynamicObject)items.get(i);
                if (infoItem.getBigDecimal("itemremainredamount").compareTo(BigDecimal.ZERO) == 0 && (isRedAmountNotAllZero || infoItem.getBigDecimal("itemremainredamount").compareTo(infoItem.getBigDecimal("amount")) == 0)) continue;
                if ("1".equals(infoItem.getString("rowtype"))) {
                    if (isContinue) {
                        isContinue = false;
                        continue;
                    }
                    if (InvoiceUtils.isAllEInvoice((Object)vatInvoice.getString("invoicetype")) || lastRedRemainAmountExist) continue;
                    OriginalBillPluginCopyRedInfoControl.setDiscountItem(view, lastRow, infoItem);
                    continue;
                }
                boolean bl = lastRedRemainAmountExist = infoItem.getBigDecimal("itemremainredamount").compareTo(BigDecimal.ZERO) != 0;
                if (i + 1 < itemsSize && "1".equals(nextRowType = (nextRow = (DynamicObject)items.get(i + 1)).getString("rowtype"))) {
                    BigDecimal nextAmount = nextRow.getBigDecimal("amount");
                    BigDecimal amount = infoItem.getBigDecimal("amount");
                    if (nextAmount.abs().compareTo(amount.abs()) == 0) {
                        isContinue = true;
                        continue;
                    }
                }
                int newEntryRow = OriginalBillPluginCopyRedInfoControl.getNewEntryRow(that, view, infoItem, true, startZero, items);
                view.getModel().setValue("sourceinfocode", (Object)vatInvoice.getString("invoiceno"), newEntryRow);
                lastRow = newEntryRow;
            }
        }
        that.getPageCache().remove(FILL_COPY_INFO);
        that.getView().addClientCallBack("updateBillTotalAmount", Integer.valueOf(100));
    }

    private static void setDiscountItem(IFormView view, Integer lastRow, DynamicObject discountItem) {
        if (null == lastRow) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7b2c\u4e00\u884c\u4e0d\u80fd\u662f\u6298\u6263\u884c", (String)"OriginalBillPluginCopyRedInfoControl_0", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        BigDecimal discountAmount = discountItem.getBigDecimal("amount");
        BigDecimal discountTaxAmount = discountItem.getBigDecimal("taxamount");
        BigDecimal discountTax = discountItem.getBigDecimal("tax");
        BigDecimal lastRowAmount = (BigDecimal)view.getModel().getValue("amount", lastRow.intValue());
        BigDecimal lastRowTaxAmount = (BigDecimal)view.getModel().getValue("taxamount", lastRow.intValue());
        BigDecimal lastRowTax = (BigDecimal)view.getModel().getValue("tax", lastRow.intValue());
        BigDecimal num = (BigDecimal)view.getModel().getValue("num", lastRow.intValue());
        view.getModel().setValue("amount", (Object)lastRowAmount.subtract(discountAmount), lastRow.intValue());
        view.getModel().setValue("taxamount", (Object)lastRowTaxAmount.subtract(discountTaxAmount), lastRow.intValue());
        view.getModel().setValue("tax", (Object)lastRowTax.subtract(discountTax), lastRow.intValue());
        Object hsbz = view.getModel().getValue("hsbz");
        BigDecimal remainvalidamount = "1".equals(hsbz) ? lastRowTaxAmount.subtract(discountTaxAmount) : lastRowAmount.subtract(discountAmount);
        view.getModel().setValue("remainvalidamount", (Object)remainvalidamount, lastRow.intValue());
        view.getModel().setValue("remainvalidtax", (Object)lastRowTax.subtract(discountTax), lastRow.intValue());
        if (!BigDecimalUtil.compareZero((BigDecimal)num)) {
            Object invoiceType = view.getModel().getValue("invoicetype");
            Object isElePaper = view.getModel().getValue("iselepaper");
            boolean isAllEle = InvoiceUtils.isAllEInvoice((Object)((String)invoiceType)) || "1".equals(isElePaper);
            BigDecimal unitprice = PriceHelper.calcPriceOrNum((BigDecimal)lastRowAmount.subtract(discountAmount), (BigDecimal)num, (boolean)isAllEle);
            BigDecimal taxunitprice = PriceHelper.calcPriceOrNum((BigDecimal)lastRowTaxAmount.subtract(discountTaxAmount), (BigDecimal)num, (boolean)isAllEle);
            view.getModel().setValue("unitprice", (Object)unitprice, lastRow.intValue());
            view.getModel().setValue("taxunitprice", (Object)taxunitprice, lastRow.intValue());
        }
    }

    public static void copyRedInfoDetail(AbstractFormPlugin that, DynamicObject[] redInfoArray, String infoCode) {
        that.getPageCache().put(FILL_COPY_INFO, "1");
        DynamicObjectCollection entryEntity = that.getView().getModel().getEntryEntity("sim_original_bill_item");
        ArrayList<String> itemIds = new ArrayList<String>(entryEntity.size());
        ArrayList<Integer> indexs = new ArrayList<Integer>(entryEntity.size());
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject item = (DynamicObject)entryEntity.get(i);
            itemIds.add(item.getString("sourceinfodetailid"));
            if (!StringUtils.isNotBlank((CharSequence)item.getString("sourceinfocode")) || infoCode.contains(item.getString("sourceinfocode"))) continue;
            indexs.add(i);
        }
        that.getView().getModel().deleteEntryRows("sim_original_bill_item", indexs.stream().mapToInt(Integer::valueOf).toArray());
        IFormView view = that.getView();
        for (DynamicObject redInfo : redInfoArray) {
            DynamicObjectCollection items = redInfo.getDynamicObjectCollection("items");
            for (DynamicObject infoItem : items) {
                if (itemIds.contains(infoItem.getString("id"))) continue;
                int newEntryRow = OriginalBillPluginCopyRedInfoControl.getNewEntryRow(that, view, infoItem, false, false, items);
                view.getModel().setValue("sourceinfocode", (Object)redInfo.getString("infocode"), newEntryRow);
            }
        }
        that.getPageCache().remove(FILL_COPY_INFO);
        that.getView().addClientCallBack("updateBillTotalAmount", Integer.valueOf(100));
    }

    private static int getNewEntryRow(AbstractFormPlugin that, IFormView view, DynamicObject item, boolean isBlueInvoice, boolean startZero, DynamicObjectCollection items) {
        BigDecimal tax;
        BigDecimal amount;
        BigDecimal unitPrice;
        BigDecimal num;
        String simpleName;
        int newEntryRow = that.getView().getModel().createNewEntryRow("sim_original_bill_item");
        String goodsName = item.getString("goodsname");
        if (BillConstant.TIP_ITEM_DETAIL.equals(goodsName)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6e05\u5355\u7ea2\u5b57\u4fe1\u606f\u8868\u65e0\u6cd5\u5e26\u51fa\u660e\u7ec6", (String)"OriginalBillPluginCopyRedInfoControl_1", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        BigDecimal negativeOne = new BigDecimal("-1");
        try {
            int index = goodsName.indexOf(42);
            int ent = goodsName.indexOf(42, index + 1);
            simpleName = goodsName.substring(index + 1, ent);
            goodsName = goodsName.substring(ent + 1);
            view.getModel().setValue("goodsname", (Object)goodsName, newEntryRow);
        }
        catch (Exception IndexOutOfBoundsException) {
            LOGGER.info(IndexOutOfBoundsException.getMessage());
            throw new KDBizException(ResManager.loadKDString((String)"\u6e05\u5355\u7ea2\u5b57\u4fe1\u606f\u8868\u65e0\u6cd5\u5e26\u51fa\u660e\u7ec6", (String)"OriginalBillPluginCopyRedInfoControl_1", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        long itemId = item.getLong("id");
        String goodsCode = item.getString("goodscode");
        view.getModel().setValue("goodscode", (Object)goodsCode, newEntryRow);
        DynamicObject taxClass = TaxClassCodeCheckHelper.geTaxCode((String)goodsCode);
        view.getModel().setValue("taxratecodeid", (Object)taxClass, newEntryRow);
        view.getModel().setValue("goodssimplename", (Object)simpleName, newEntryRow);
        view.getModel().setValue("specification", (Object)item.getString("specification"), newEntryRow);
        view.getModel().setValue("unit", (Object)item.getString("unit"), newEntryRow);
        view.getModel().setValue("rowtype", (Object)OriginalBillPluginCopyRedInfoControl.castRowType(item.getString("rowtype")), newEntryRow);
        view.getModel().setValue("policycontants", (Object)item.getString("zzstsgl"), newEntryRow);
        view.getModel().setValue("policylogo", (Object)item.getString("taxpremark"), newEntryRow);
        if ("0".equals(item.getString("taxpremark")) && item.getBigDecimal("taxrate").compareTo(BigDecimal.ZERO) == 0) {
            view.getModel().setValue("policycontants", (Object)ResManager.loadKDString((String)"\u666e\u901a\u96f6\u7a0e\u7387", (String)"OriginalBillPluginCopyRedInfoControl_3", (String)"imc-sim-service", (Object[])new Object[0]), newEntryRow);
        }
        if (isBlueInvoice) {
            num = item.getBigDecimal("itemremainrednum");
            unitPrice = item.getBigDecimal("redprice");
            amount = item.getBigDecimal("itemremainredamount");
            tax = item.getBigDecimal("itemremainredtax");
        } else {
            num = item.getBigDecimal("num");
            unitPrice = item.getBigDecimal("unitprice");
            amount = item.getBigDecimal("amount");
            tax = item.getBigDecimal("tax");
        }
        if (null != that.getView().getModel().getValue("blueinvoicetype") && !InvoiceUtils.isAllEInvoice((Object)that.getView().getModel().getValue("blueinvoicetype").toString()) && amount.compareTo(BigDecimal.ZERO) == 0) {
            amount = item.getBigDecimal("amount");
            tax = amount.multiply(item.getBigDecimal("taxrate")).setScale(2, 4);
            if (num.compareTo(BigDecimal.ZERO) == 0) {
                BigDecimal oriNum = item.getBigDecimal("num");
                if (oriNum.compareTo(BigDecimal.ZERO) != 0) {
                    num = oriNum;
                    unitPrice = amount.divide(num, 16, RoundingMode.HALF_UP);
                } else {
                    num = BigDecimal.ZERO;
                    unitPrice = BigDecimalUtil.ZERO;
                }
            }
        }
        if (null != that.getView().getModel().getValue("blueinvoicetype") && InvoiceUtils.isAllEInvoice((Object)that.getView().getModel().getValue("blueinvoicetype").toString()) && amount.compareTo(BigDecimal.ZERO) != 0 && num.compareTo(BigDecimal.ZERO) == 0 && item.getBigDecimal("num").compareTo(BigDecimal.ZERO) != 0) {
            num = BigDecimal.valueOf(Double.parseDouble(InvoiceUtils.calculateRedNum((DynamicObject)item, (DynamicObjectCollection)items)));
        }
        if (BigDecimalUtil.compareZero((BigDecimal)num)) {
            num = BigDecimal.valueOf(Double.parseDouble(InvoiceUtils.calculateRedNum((DynamicObject)item, (DynamicObjectCollection)items)));
        }
        if (BigDecimalUtil.compareZero((BigDecimal)unitPrice)) {
            unitPrice = BigDecimal.valueOf(Double.parseDouble(InvoiceUtils.calculateRedPrice((DynamicObject)item, (DynamicObjectCollection)items)));
        }
        BigDecimal taxAmount = amount.add(tax);
        BigDecimal taxUnitPrice = unitPrice.multiply(item.getBigDecimal("taxrate")).add(unitPrice);
        if (isBlueInvoice) {
            num = num.multiply(negativeOne);
            amount = amount.multiply(negativeOne);
            taxAmount = taxAmount.multiply(negativeOne);
            tax = tax.multiply(negativeOne);
            if (startZero) {
                view.getModel().setValue("originalseq", (Object)(item.getInt("seq") + 1), newEntryRow);
            } else {
                view.getModel().setValue("originalseq", (Object)item.getInt("seq"), newEntryRow);
            }
        }
        BigDecimal taxRate = item.getBigDecimal("taxrate");
        view.getModel().setValue("num", (Object)num, newEntryRow);
        view.getModel().setValue("unitprice", (Object)unitPrice, newEntryRow);
        view.getModel().setValue("taxunitprice", (Object)taxUnitPrice, newEntryRow);
        view.getModel().setValue("amount", (Object)amount, newEntryRow);
        view.getModel().setValue("taxamount", (Object)taxAmount, newEntryRow);
        view.getModel().setValue("taxrate", (Object)taxRate, newEntryRow);
        view.getModel().setValue("tax", (Object)tax, newEntryRow);
        Object hsbz = that.getView().getModel().getValue("hsbz");
        BigDecimal remainvalidamount = "1".equals(hsbz) ? taxAmount : amount;
        view.getModel().setValue("remainvalidnum", (Object)num, newEntryRow);
        view.getModel().setValue("remainvalidamount", (Object)remainvalidamount, newEntryRow);
        view.getModel().setValue("remainvalidtax", (Object)tax, newEntryRow);
        view.getModel().setValue("sourceinfodetailid", (Object)itemId, newEntryRow);
        return newEntryRow;
    }

    public static void deleteRow(AbstractFormPlugin that) {
        DynamicObjectCollection entryEntity = that.getView().getModel().getEntryEntity("sim_original_bill_item");
        ArrayList indexs = Lists.newArrayList();
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject item = (DynamicObject)entryEntity.get(i);
            if (!StringUtils.isNotBlank((CharSequence)item.getString("sourceinfocode"))) continue;
            indexs.add(i);
        }
        int[] ints = indexs.stream().mapToInt(Integer::valueOf).toArray();
        that.getView().getModel().deleteEntryRows("sim_original_bill_item", ints);
    }

    public static String castRowType(String redInfoRowType) {
        if ("2".equals(redInfoRowType) || "0".equals(redInfoRowType) || "".equals(redInfoRowType)) {
            return "2";
        }
        return redInfoRowType;
    }

    public static void copyRedInfo(AbstractFormPlugin plugin, String infoCode) {
        if (StringUtils.isBlank((CharSequence)infoCode)) {
            if (!StringUtils.isEmpty((CharSequence)plugin.getPageCache().get("fromCopy"))) {
                return;
            }
            if (OriginalBillPluginCopyRedInfoControl.isFromRedInfo(plugin)) {
                OriginalBillPluginCopyRedInfoControl.deleteRow(plugin);
                OriginalBillPluginCopyRedInfoControl.recover(plugin);
                plugin.getPageCache().remove(ITEM_TYPE);
            }
            return;
        }
        if (OriginalBillPluginCopyRedInfoControl.isFromInvoice(plugin)) {
            return;
        }
        if (OriginalBillPluginCopyRedInfoControl.checkItemFrom(plugin)) {
            return;
        }
        QFilter redInfoFromFilter = OriginalBillPluginCopyRedInfoControl.createQueryFilter(plugin, infoCode);
        DynamicObject[] redInfoArray = BusinessDataServiceHelper.load((String)"sim_red_info", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_red_info", (boolean)true), (QFilter[])redInfoFromFilter.toArray());
        if (redInfoArray.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7f16\u53f7\u5728\u53d1\u7968\u4e91\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6b63", (String)"OriginalBillPluginCopyRedInfoControl_2", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        OriginalBillPluginCopyRedInfoControl.disableControl(plugin, redInfoArray[0]);
        OriginalBillPluginCopyRedInfoControl.copyRedInfoDetail(plugin, redInfoArray, infoCode);
        plugin.getPageCache().put(ITEM_TYPE, FROM_RED_INFO);
    }

    public static boolean checkItemFrom(AbstractFormPlugin plugin) {
        DynamicObjectCollection billItems = plugin.getView().getModel().getEntryEntity("sim_original_bill_item");
        List dynamicObjects = billItems.stream().filter(e -> StringUtils.isBlank((CharSequence)e.getString("sourceinfocode"))).collect(Collectors.toList());
        if (dynamicObjects.size() > 0) {
            LOGGER.info("copyRedInfo \u5b58\u5728\u624b\u52a8\u660e\u7ec6\u884c\uff0c\u4e0d\u6267\u884c\u5e26\u51fa\u660e\u7ec6");
            return true;
        }
        return false;
    }

    private static QFilter createQueryFilter(AbstractFormPlugin plugin, String infoCode) {
        IFormView view = plugin.getView();
        Object applicant = view.getModel().getValue("applicant");
        Object buyerTaxNo = view.getModel().getValue("buyertaxno");
        long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)view.getModel().getValue("orgid"));
        Object salesTaxNo = view.getModel().getValue("salertaxno");
        QFilter redInfoFromFilter = RedInfoHelper.getRedInfoFromFilter((Object)applicant, (Object)buyerTaxNo, (Object)orgId, (Object)salesTaxNo);
        redInfoFromFilter.and("infocode", "in", (Object)infoCode.split(","));
        return redInfoFromFilter;
    }

    private static void recover(AbstractFormPlugin plugin) {
        plugin.getView().setVisible(Boolean.TRUE, new String[]{"advcontoolbarap"});
        plugin.getView().setEnable(Boolean.TRUE, new String[]{"goodsid", "producttype"});
    }

    @SdkDeprecated
    public static void disableControl(AbstractFormPlugin that, DynamicObject redInfo) {
        that.getView().getModel().setValue("hsbz", (Object)redInfo.getString("hsbz"));
        that.getView().setEnable(Boolean.FALSE, new String[]{"goodsid", "producttype"});
        DynamicObjectCollection entryEntity = that.getView().getModel().getEntryEntity("sim_original_bill_item");
        for (int i = 0; i < entryEntity.size(); ++i) {
            that.getView().setEnable(Boolean.FALSE, i, new String[]{"goodsid"});
        }
    }

    public static boolean isFromRedInfo(AbstractFormPlugin that) {
        String itemType = that.getPageCache().get(ITEM_TYPE);
        if (StringUtils.isNotBlank((CharSequence)itemType)) {
            return FROM_RED_INFO.equals(itemType);
        }
        return false;
    }

    public static boolean isFromInvoice(AbstractFormPlugin that) {
        String itemType = that.getPageCache().get(ITEM_TYPE);
        if (StringUtils.isNotBlank((CharSequence)itemType)) {
            return FROM_INVOICE.equals(itemType);
        }
        return false;
    }
}

