/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceQueryUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;

public class BillIssueResultTabCustomEventUtil {
    private static Log LOGGER = LogFactory.getLog(BillIssueResultTabCustomEventUtil.class);
    private static String DOTASKFLAG = "doTaskFlag";
    private static String ISSUEINVOICE = "issueInvoice";
    private static String INVOICEPRINT = "invoicePrint";

    public static DynamicObject[] getInvObjsByInvId(String params) {
        List array = JSONArray.parseArray((String)JSON.parseArray((String)params).toJSONString(), Long.class);
        return BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])new QFilter("id", "in", (Object)array).toArray());
    }

    public static Map<String, Object> buildWorkBenchReverseIssuesResult(String billIds) {
        ArrayList returnMapList = Lists.newArrayList();
        JSONArray jsonArray = JSONArray.parseArray((String)billIds);
        ArrayList<Long> billIdList = new ArrayList<Long>();
        ArrayList<DynamicObject> invoiceDynamicObjectList = new ArrayList<DynamicObject>(jsonArray.size());
        for (Object billId : jsonArray) {
            DynamicObject originalBill = BusinessDataServiceHelper.loadSingle(billId, (String)"sim_original_bill");
            if ("C".equals(originalBill.getString("billsourcetype"))) {
                DynamicObject invalidInvoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])InvoiceUtils.getInvoiceFilter((Object)originalBill.getString("invoicecode"), (Object)originalBill.getString("invoiceno")).toArray());
                invoiceDynamicObjectList.add(invalidInvoice);
                continue;
            }
            billIdList.add((Long)billId);
        }
        List invObjListFromRelation = InvoiceQueryUtil.getInvoiceByRelationTableSBillId(billIdList);
        for (DynamicObject invoiceOrRedInfo : invObjListFromRelation) {
            if ("sim_red_info".equals(invoiceOrRedInfo.getDataEntityType().getName())) {
                DynamicObject redInvoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])new QFilter("infocode", "=", (Object)invoiceOrRedInfo.getString("infocode")).toArray());
                redInvoice.set("billno", (Object)invoiceOrRedInfo.getString("billno"));
                invoiceDynamicObjectList.add(redInvoice);
                continue;
            }
            invoiceDynamicObjectList.add(invoiceOrRedInfo);
        }
        List invoiceListMap = DynamicObjectUtil.dynamicObjects2ListMap(invoiceDynamicObjectList, (boolean)true);
        returnMapList.addAll(invoiceListMap);
        int issueCount = 0;
        int printCount = 0;
        if (!returnMapList.isEmpty()) {
            for (Map invoiceMap : returnMapList) {
                String issueStatus = (String)invoiceMap.get("issuestatus");
                if ("0".equals(invoiceMap.get("abolishtype"))) {
                    if ("6".equals(invoiceMap.get("invoicestatus"))) {
                        invoiceMap.put("issuestatus", "6");
                    } else {
                        invoiceMap.put("issuestatus", "5");
                    }
                }
                if (IssueStatusEnum.ok.getCode().equals(issueStatus) || IssueStatusEnum.failed.getCode().equals(issueStatus) || "-9999".equals(issueStatus)) {
                    ++issueCount;
                }
                if (!"1".equals(invoiceMap.get("printflag"))) continue;
                ++printCount;
            }
            Collections.reverse(returnMapList);
        }
        HashMap rMap = Maps.newHashMap();
        rMap.put("isComplete", issueCount == returnMapList.size());
        rMap.put(DOTASKFLAG, "issueInvoice");
        rMap.put("result", returnMapList);
        return rMap;
    }

    public static Map<String, Object> buildWorkBenchIssuesResult(String currentSalerTaxNo, String params) {
        String[] redids;
        Object[] redList;
        DynamicObject[] redInfoObjs;
        ArrayList allList = Lists.newArrayList();
        JSONObject paramsJSON = JSONObject.parseObject((String)params);
        String blueinvoiceid = paramsJSON.getString("blueinvoiceid");
        String redinvoiceid = paramsJSON.getString("redinvoiceid");
        LOGGER.info("billIssueResultTabCustomEventUtil:blueinvoiceid----" + blueinvoiceid);
        LOGGER.info("billIssueResultTabCustomEventUtil:redinvoiceid----" + redinvoiceid);
        if (StringUtils.isNotBlank((CharSequence)blueinvoiceid)) {
            String[] blueids = blueinvoiceid.split(",");
            Object[] blueList = Arrays.stream(blueids).map(s -> Long.parseLong(s.trim())).toArray();
            DynamicObject[] blueInfoObjs = BusinessDataServiceHelper.load((Object[])blueList, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice"));
            ArrayList blueDy = Lists.newArrayListWithCapacity((int)blueInfoObjs.length);
            ArrayList redDy = Lists.newArrayListWithCapacity((int)blueInfoObjs.length);
            ArrayList redEleDy = Lists.newArrayListWithCapacity((int)blueInfoObjs.length);
            for (DynamicObject blueInfoObj : blueInfoObjs) {
                if (blueInfoObj.getBigDecimal("totalamount").compareTo(BigDecimal.ZERO) < 0 && InvoiceUtils.isSpecialInvoice((String)blueInfoObj.getString("invoicetype"))) {
                    redDy.add(blueInfoObj);
                    continue;
                }
                if (blueInfoObj.getBigDecimal("totalamount").compareTo(BigDecimal.ZERO) < 0 && InvoiceUtils.isAllEInvoice((Object)blueInfoObj.getString("invoicetype"))) {
                    redEleDy.add(blueInfoObj);
                    continue;
                }
                blueDy.add(blueInfoObj);
            }
            List blueListMap = DynamicObjectUtil.dynamicObjects2ListMap((List)blueDy, (boolean)true);
            blueListMap.forEach(inv -> inv.put("billno", BillIssueResultTabCustomEventUtil.getBillNo(Long.parseLong(String.valueOf(inv.get("id"))), "sim_vatinvoice")));
            allList.addAll(blueListMap);
            List collect = redDy.stream().map(o -> o.getString("infocode")).collect(Collectors.toList());
            QFilter redFilter = new QFilter("infocode", "in", (Object)collect.toArray()).and("org", "=", (Object)RequestContext.get().getOrgId());
            DynamicObject[] redInfoObjs2 = BusinessDataServiceHelper.load((String)"sim_red_info", (String)"infocode,id", (QFilter[])redFilter.toArray());
            HashMap infoMap = Maps.newHashMapWithExpectedSize((int)redInfoObjs2.length);
            for (DynamicObject redInfoObj : redInfoObjs2) {
                infoMap.put(redInfoObj.getString("infocode"), redInfoObj.getLong("id"));
            }
            List redlistMap = DynamicObjectUtil.dynamicObjects2ListMap((DynamicObject[])redDy.toArray(new DynamicObject[0]), (boolean)true);
            redlistMap.forEach(inv -> inv.put("billno", BillIssueResultTabCustomEventUtil.getBillNo((Long)infoMap.get(inv.get("infocode")), "sim_red_info")));
            allList.addAll(redlistMap);
            List redConfirmBillNos = redEleDy.stream().map(o -> o.getString("infocode")).collect(Collectors.toList());
            QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"sim_red_confirm_bill", (Long)RequestContext.get().getOrgId());
            QFilter redConfirmFilter = new QFilter("number", "in", (Object)redConfirmBillNos.toArray()).and(baseDataFilter);
            DynamicObject[] redConfirms = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)"number,id", (QFilter[])redConfirmFilter.toArray());
            HashMap redConfirmMap = Maps.newHashMapWithExpectedSize((int)redConfirms.length);
            List redConfirmlistMap = DynamicObjectUtil.dynamicObjects2ListMap((DynamicObject[])redEleDy.toArray(new DynamicObject[0]), (boolean)true);
            for (DynamicObject redConfirm : redConfirms) {
                redConfirmMap.put(redConfirm.getString("number"), redConfirm.getLong("id"));
            }
            redConfirmlistMap.forEach(inv -> inv.put("billno", BillIssueResultTabCustomEventUtil.getBillNo((Long)redConfirmMap.get(inv.get("infocode")), "sim_red_confirm_bill")));
            allList.addAll(redConfirmlistMap);
        }
        if (StringUtils.isNotBlank((CharSequence)redinvoiceid) && null != (redInfoObjs = BusinessDataServiceHelper.load((Object[])(redList = Arrays.stream(redids = redinvoiceid.split(",")).map(s -> Long.parseLong(s.trim())).toArray()), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_red_info"))) && redInfoObjs.length > 0) {
            List listMap = DynamicObjectUtil.dynamicObjects2ListMap((DynamicObject[])redInfoObjs, (boolean)true);
            listMap.forEach(red -> {
                red.put("billno", BillIssueResultTabCustomEventUtil.getBillNo(Long.parseLong(String.valueOf(red.get("id"))), "sim_red_info"));
                red.put("result", ResManager.loadKDString((String)"\u4fe1\u606f\u5df2\u4fdd\u5b58\u81f3\u5f00\u7968\u7ba1\u7406\u2192\u7ea2\u5b57\u4fe1\u606f\u8868\u9875\u9762\uff0c\u8bf7\u5728\u8be5\u9875\u9762\u8fdb\u884c\u4e0a\u4f20\u53ca\u7ea2\u51b2\u3002", (String)"BillIssueResultTabCustomEventUtil_0", (String)"imc-sim-service", (Object[])new Object[0]));
            });
            allList.addAll(listMap);
        }
        int paperInvoice = 0;
        int issueCount = 0;
        int printCount = 0;
        if (!allList.isEmpty()) {
            List<Object> redIdList = Lists.newArrayListWithCapacity((int)8);
            if (StringUtils.isNotBlank((CharSequence)redinvoiceid)) {
                redIdList = Arrays.asList(redinvoiceid.split(","));
            }
            for (Map invoiceMap : allList) {
                String issuestatus = (String)invoiceMap.get("issuestatus");
                invoiceMap.put("issuestatus", issuestatus);
                invoiceMap.put("invoicetype", String.valueOf(invoiceMap.get("invoicetype")));
                if (!redIdList.isEmpty() && redIdList.contains(invoiceMap.get("id"))) {
                    double totalAmount = new BigDecimal(String.valueOf(invoiceMap.get("totalamount"))).doubleValue();
                    String invType = String.valueOf(invoiceMap.get("invoicetype"));
                    if (totalAmount < 0.0 && (InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode().equals(invType) || InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode().equals(invType))) {
                        invoiceMap.put("issuestatus", "-9999");
                    }
                }
                issuestatus = (String)invoiceMap.get("issuestatus");
                if (IssueStatusEnum.ok.getCode().equals(issuestatus) || IssueStatusEnum.failed.getCode().equals(issuestatus) || "-9999".equals(issuestatus)) {
                    ++issueCount;
                }
                if (InvoiceUtils.isPaperInvoice((String)invoiceMap.get("invoicetype").toString())) {
                    ++paperInvoice;
                }
                if (!"1".equals(invoiceMap.get("printflag"))) continue;
                ++printCount;
            }
            Collections.reverse(allList);
        }
        HashMap rMap = Maps.newHashMap();
        String taskFlag = paramsJSON.getString(DOTASKFLAG);
        if (INVOICEPRINT.equals(taskFlag)) {
            rMap.put("isComplete", paperInvoice == printCount);
        } else {
            rMap.put("isComplete", issueCount == allList.size());
        }
        rMap.put(DOTASKFLAG, taskFlag);
        rMap.put("result", allList);
        if (StringUtils.isNotBlank((CharSequence)currentSalerTaxNo)) {
            rMap.put("creditQuota", CacheHelper.get((String)("creditQuota_" + currentSalerTaxNo)));
        }
        return rMap;
    }

    public static String getBillNo(Long id, String table) {
        QFilter filter = new QFilter("tbillid", "=", (Object)id).and("ttable", "=", (Object)table).and("isdelete", "!=", (Object)"Y");
        DynamicObject[] relationObjs = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)"sbillid", (QFilter[])filter.toArray());
        if (relationObjs.length > 0) {
            QFilter sfilter;
            DynamicObject[] load;
            ArrayList idList = Lists.newArrayList();
            Arrays.stream(relationObjs).forEach(r -> idList.add(r.getLong("sbillid")));
            if (!idList.isEmpty() && null != (load = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)"billno", (QFilter[])(sfilter = new QFilter("id", "in", (Object)idList)).toArray())) && load.length > 0) {
                ArrayList billNos = new ArrayList(load.length);
                Arrays.stream(load).forEach(b -> billNos.add(b.getString("billno")));
                return String.join((CharSequence)",", billNos);
            }
        }
        return "";
    }
}

