/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.helper.issueinvoice.IssueInvoiceMqHelper;
import kd.imc.sim.formplugin.bill.originalbill.util.BillIssueResultTabCustomEventUtil;

public class BillSplitIssueResultTabCustomEventUtil {
    private static Log LOGGER = LogFactory.getLog(BillSplitIssueResultTabCustomEventUtil.class);

    public static void resendIssus(String params) {
        DynamicObject[] invObjs = BillSplitIssueResultTabCustomEventUtil.getInvObjsByInvId(params);
        IssueInvoiceMqHelper.submitInvoice2MQ((DynamicObject[])invObjs);
    }

    public static DynamicObject[] getInvObjsByInvId(String params) {
        List array = JSONArray.parseArray((String)JSON.parseArray((String)params).toJSONString(), Long.class);
        QFilter filter = new QFilter("id", "in", (Object)array);
        String selFields = PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true);
        return BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)selFields, (QFilter[])filter.toArray());
    }

    public static Map<String, Object> workBenchSplitBuildResult(String currentSalerTaxNo, String params) {
        JSONObject paramsJSON = JSONObject.parseObject((String)params);
        Long invoiceid = paramsJSON.getLong("invoiceid");
        ArrayList allList = Lists.newArrayList();
        if (null != invoiceid) {
            ArrayList<Long> objects = new ArrayList<Long>();
            objects.add(invoiceid);
            DynamicObject[] load = BusinessDataServiceHelper.load((Object[])objects.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice"));
            List listMap = DynamicObjectUtil.dynamicObjects2ListMap((DynamicObject[])load, (boolean)true);
            listMap.forEach(inv -> inv.put("billno", BillIssueResultTabCustomEventUtil.getBillNo(Long.parseLong(String.valueOf(inv.get("id"))), "sim_vatinvoice")));
            allList.addAll(listMap);
        } else {
            List array = JSONArray.parseArray((String)paramsJSON.getJSONArray("billpks").toJSONString(), Long.class);
            QFilter rFilter = new QFilter("sbillid", "in", (Object)array).and("isdelete", "!=", (Object)"Y");
            String selFields = "tbillid".concat(",").concat("ttable").concat(",").concat("sbillid").concat(",").concat("sbillno");
            DynamicObject[] relationObjs = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)selFields, (QFilter[])rFilter.toArray());
            if (null == relationObjs || relationObjs.length <= 0) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info(String.format("\u6839\u636e\u539f\u59cb\u5355\u636eID\u83b7\u53d6\u53d1\u7968\u6570\u636e\u5f02\u5e38:%s", JSON.toJSONString((Object)array)));
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u539f\u59cb\u5355\u636e\u672a\u627e\u5230\u5bf9\u5e94\u5173\u7cfb", (String)"BillSplitIssueResultTabCustomEventUtil_0", (String)"imc-sim-service", (Object[])new Object[0]));
            }
            List<DynamicObject> invObjList = Arrays.stream(relationObjs).filter(r -> "sim_vatinvoice".equals(r.getString("ttable"))).collect(Collectors.toList());
            String selectFields = "id,invoiceno,invoicecode,totalamount,invoicetype,buyername,result";
            if (!invObjList.isEmpty()) {
                ArrayList invIdList = new ArrayList(invObjList.size());
                invObjList.forEach(inv -> invIdList.add(inv.getLong("tbillid")));
                QFilter filter = new QFilter("id", "in", invIdList);
                DynamicObject[] invObjs = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)selectFields.concat(",issuestatus").concat(",result"), (QFilter[])filter.toArray());
                if (null != invObjs && invObjs.length > 0) {
                    List listMap = DynamicObjectUtil.dynamicObjects2ListMap((DynamicObject[])invObjs, (boolean)true);
                    listMap.forEach(inv -> inv.put("billno", BillIssueResultTabCustomEventUtil.getBillNo(Long.parseLong(String.valueOf(inv.get("id"))), "sim_vatinvoice")));
                    allList.addAll(listMap);
                }
            }
        }
        int count = 0;
        if (!allList.isEmpty()) {
            for (Map invoiceMap : allList) {
                String issuestatus = (String)invoiceMap.get("issuestatus");
                double totalAmount = new BigDecimal(String.valueOf(invoiceMap.get("totalamount"))).doubleValue();
                String invType = String.valueOf(invoiceMap.get("invoicetype"));
                invoiceMap.put("issuestatus", issuestatus);
                if (totalAmount < 0.0 && (InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode().equals(invType) || InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode().equals(invType))) {
                    invoiceMap.put("issuestatus", "-9999");
                }
                issuestatus = (String)invoiceMap.get("issuestatus");
                invoiceMap.put("invoicetype", String.valueOf(invoiceMap.get("invoicetype")));
                if (!IssueStatusEnum.ok.getCode().equals(issuestatus) && !IssueStatusEnum.failed.getCode().equals(issuestatus) && !"-9999".equals(issuestatus)) continue;
                ++count;
            }
            Collections.reverse(allList);
        }
        HashMap rMap = Maps.newHashMap();
        if (count == allList.size()) {
            rMap.put("isComplete", Boolean.TRUE);
        } else {
            rMap.put("isComplete", Boolean.FALSE);
        }
        rMap.put("result", allList);
        rMap.put("creditQuota", CacheHelper.get((String)("creditQuota_" + currentSalerTaxNo)));
        return rMap;
    }
}

