/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill.workbench.alleevent;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.container.Tab;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.imc.bdm.common.dto.BillRelationDTO;
import kd.imc.bdm.common.dto.split.LimitAmountsDTO;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.constant.BillComprehensiveStatusEnum;
import kd.imc.sim.common.constant.InvoiceConstant;
import kd.imc.sim.common.dto.bill.workbench.SplitOrMergeRuleDTO;
import kd.imc.sim.formplugin.bill.originalbill.workbench.alleevent.AbstractAllEBillWorkbenchCustomEvent;
import kd.imc.sim.formplugin.bill.originalbill.workbench.alleevent.AllEBillIssueResultTabCustomEvent;
import kd.imc.sim.formplugin.bill.originalbill.workbench.alleevent.AllEBillTabCustomEvent;
import kd.imc.sim.formplugin.bill.originalbill.workbench.event.BillCommonCustomEvent;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class AllEBillCommonCustomEvent
extends AbstractAllEBillWorkbenchCustomEvent {
    @Override
    public void customEvent(AbstractFormPlugin that, CustomEventArgs e) {
        String event = e.getEventName();
        String param = e.getEventArgs();
        switch (event) {
            case "common/tip": {
                that.getView().showTipNotification(param);
                break;
            }
            case "init": {
                this.initData(that);
                break;
            }
            case "common/changeTab": {
                this.changeTab(that, param);
            }
        }
    }

    private void initData(AbstractFormPlugin that) {
        try {
            Map customParams = that.getView().getFormShowParameter().getCustomParams();
            AllEBillCommonCustomEvent.putPageCache(that, "workbenchtype", "invoicealleworkbench");
            this.tempSavePreview(that, customParams);
            if (customParams.get("pk") != null) {
                this.repeatInit(that, customParams);
                return;
            }
            JSONArray pkValues = (JSONArray)customParams.get("pks");
            List<Long> billIds = pkValues.stream().map(pk -> Long.parseLong(String.valueOf(pk))).collect(Collectors.toList());
            DynamicObjectCollection bills = this.queryBill(that, billIds, (BigDecimal)customParams.get("totalamount"), (Integer)customParams.get("itemcount"));
            Map<String, Object> map = this.createBillProcessMap(that, bills);
            map.put("pageIndex", 1);
            map.put("pageSize", 100);
            map.put("total", pkValues.size());
            map.put("totalPage", (pkValues.size() - 1) / 100 + 1);
            AllEBillCommonCustomEvent.updateCustomControl(that, map, "init");
        }
        catch (Exception e) {
            LOGGER.error("\u8fdb\u5165\u5de5\u4f5c\u53f0\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
            AllEBillCommonCustomEvent.handleExcepiton(that, e);
            AllEBillCommonCustomEvent.updateCustomControlError(that, null, "init");
        }
    }

    private void tempSavePreview(AbstractFormPlugin that, Map<String, Object> customParams) {
        boolean tempSavePreview = customParams.get("tempSavePreview") != null && (Boolean)customParams.get("tempSavePreview") != false;
        AllEBillCommonCustomEvent.putPageCache(that, "tempSavePreview", tempSavePreview ? "1" : "0");
        if (tempSavePreview) {
            that.getView().setVisible(Boolean.FALSE, new String[]{"issue_positive"});
        }
    }

    private DynamicObjectCollection queryBill(AbstractFormPlugin that, List<Long> pkList, BigDecimal totalAmount, int itemCount) {
        DynamicObjectCollection bills = QueryServiceHelper.query((String)"sim_original_bill", (String)String.join((CharSequence)",", FIRST_PAGE_SELECT_FIELD, "mergerule.name as mergerulename"), (QFilter[])new QFilter("id", "in", (Object)pkList.stream().limit(100L).toArray()).toArray(), (String)"originbillseq desc");
        AllEBillCommonCustomEvent.putPageCache(that, "pks", pkList.stream().map(Object::toString).collect(Collectors.joining(",")));
        this.setBillCountLabel(that);
        AllEBillCommonCustomEvent.putPageCache(that, "totalamountlabel", totalAmount.setScale(2, 4).toString());
        this.setTotalAmountLabel(that);
        AllEBillCommonCustomEvent.putPageCache(that, "itemcountlabel", String.valueOf(itemCount));
        this.setItemCountLabel(that);
        return bills;
    }

    private void repeatInit(AbstractFormPlugin that, Map<String, Object> customParams) {
        DynamicObjectCollection positveOrNegativeBills;
        Long pk = (Long)customParams.get("pk");
        DynamicObject originalBill = QueryServiceHelper.queryOne((String)"sim_original_bill", (String)String.join((CharSequence)",", "comprehensivestatus", "orgid", "salertaxno", "operatebatch"), (QFilter[])new QFilter("id", "=", (Object)pk).toArray());
        String operateBatch = (String)customParams.get("operatebatch");
        String billOperateBatch = originalBill.getString("operatebatch");
        AllEBillCommonCustomEvent.putPageCache(that, "operatebatch", billOperateBatch.substring(0, billOperateBatch.lastIndexOf(95) + 1));
        boolean isMatchBill = true;
        if (StringUtils.isNotBlank((String)operateBatch)) {
            if (operateBatch.endsWith("red")) {
                positveOrNegativeBills = QueryServiceHelper.query((String)"sim_match_bill", (String)"id", (QFilter[])new QFilter("matchbatch", "=", (Object)operateBatch).toArray());
            } else {
                isMatchBill = false;
                positveOrNegativeBills = QueryServiceHelper.query((String)"sim_merge_bill", (String)"id", (QFilter[])new QFilter("originbillseq", "=", (Object)operateBatch).toArray());
            }
        } else {
            DynamicObjectCollection relations = QueryServiceHelper.query((String)"sim_matchbill_relation", (String)"tbillid", (QFilter[])new QFilter("sbillid", "=", (Object)pk).toArray());
            if (CollectionUtils.isNotEmpty((Collection)relations)) {
                positveOrNegativeBills = QueryServiceHelper.query((String)"sim_match_bill", (String)"id", (QFilter[])new QFilter("matchbatch", "=", (Object)billOperateBatch).and("id", "in", (Object)relations.stream().map(relation -> relation.getLong("tbillid")).distinct().toArray()).toArray());
            } else {
                isMatchBill = false;
                relations = QueryServiceHelper.query((String)"sim_mergebill_relation", (String)"tbillid", (QFilter[])new QFilter("sbillid", "=", (Object)pk).toArray());
                positveOrNegativeBills = QueryServiceHelper.query((String)"sim_merge_bill", (String)"id", (QFilter[])new QFilter("originbillseq", "=", (Object)billOperateBatch).and("id", "in", (Object)relations.stream().map(relation -> relation.getLong("tbillid")).distinct().toArray()).toArray());
            }
        }
        if (CollectionUtils.isEmpty((Collection)positveOrNegativeBills)) {
            that.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u6570\u636e!", (String)"AllEBillCommonCustomEvent_0", (String)"imc-sim-service", (Object[])new Object[0]));
            AllEBillCommonCustomEvent.updateCustomControlError(that, null, "repeatInit");
            return;
        }
        List<Long> mergeOrMatchPks = positveOrNegativeBills.stream().map(bill -> bill.getLong("id")).collect(Collectors.toList());
        long currentOrgId = originalBill.getLong("orgid");
        AllEBillCommonCustomEvent.putPageCache(that, "currentOrg", String.valueOf(currentOrgId));
        AllEBillCommonCustomEvent.putPageCache(that, "currentSalerTaxNo", originalBill.getString("salertaxno"));
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("repeatInit", "repeatInit");
        AllEBillCommonCustomEvent.putPageCache(that, "repeatInit", "repeatInit");
        new BillCommonCustomEvent().initAccount(originalBill.getString("salertaxno"), map);
        map.put("taxequipment", InvoiceConstant.DIFFF_06);
        map.put("limitAmounts", new LimitAmountsDTO(true));
        map.put("creditQuota", CacheHelper.get((String)("creditQuota_" + originalBill.getString("salertaxno"))));
        map.put("splitrule", new ArrayList(1));
        map.put("redConfirmmatchrule", new ArrayList(1));
        map.put("matchrule", new ArrayList(1));
        map.put("bills", new ArrayList(1));
        map.put("mergerule", this.getMergeRules(currentOrgId));
        map.put("billTotal", mergeOrMatchPks.size());
        if (isMatchBill) {
            map.put("redConfirmmatchrule", this.getRedConfirmMatchRules(currentOrgId));
            map.put("matchrule", this.getMatchRules(currentOrgId));
            map.put("currentTab", "negative");
            this.createMatchBillRepeat(that, map, mergeOrMatchPks);
            return;
        }
        map.put("currentTab", "positive");
        map.put("splitrule", new BillCommonCustomEvent().getSplitRules(currentOrgId));
        this.createMergeBillBillRepeat(that, map, mergeOrMatchPks);
    }

    private void createMatchBillRepeat(AbstractFormPlugin that, Map<String, Object> map, List<Long> pks) {
        DynamicObjectCollection mergeRelations = QueryServiceHelper.query((String)"sim_matchbill_relation", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_matchbill_relation"), (QFilter[])new QFilter("tbillid", "in", pks).toArray());
        List<Long> billIds = mergeRelations.stream().map(relation -> relation.getLong("sbillid")).distinct().collect(Collectors.toList());
        DynamicObjectCollection bills = QueryServiceHelper.query((String)"sim_original_bill", (String)String.join((CharSequence)",", "comprehensivestatus"), (QFilter[])new QFilter("id", "in", billIds).toArray());
        if (bills.stream().allMatch(bill -> "09".equals(bill.getString("comprehensivestatus")))) {
            DynamicObjectCollection splitRelations = QueryServiceHelper.query((String)"sim_match_inv_relation", (String)"tbillid", (QFilter[])new QFilter("sbillid", "in", pks).toArray());
            if (CollectionUtils.isEmpty((Collection)splitRelations)) {
                return;
            }
            DynamicObjectCollection redConfirms = QueryServiceHelper.query((String)"sim_red_confirm_bill", (String)"orderno", (QFilter[])new QFilter("id", "in", (Object)splitRelations.stream().map(relation -> relation.getLong("tbillid")).toArray()).toArray());
            if (CollectionUtils.isEmpty((Collection)redConfirms)) {
                return;
            }
            DynamicObjectCollection invoices = QueryServiceHelper.query((String)"sim_vatinvoice", (String)"id", (QFilter[])new QFilter("orderno", "in", (Object)redConfirms.stream().map(redConfirm -> redConfirm.getString("orderno")).toArray()).toArray());
            if (CollectionUtils.isEmpty((Collection)invoices)) {
                return;
            }
            List invoiceIds = invoices.stream().map(invoice -> String.valueOf(invoice.getLong("id"))).distinct().collect(Collectors.toList());
            AllEBillCommonCustomEvent.putPageCache(that, "redInvoiceIdPks", String.join((CharSequence)",", invoiceIds));
            AllEBillCommonCustomEvent.putPageCache(that, "redInvoiceCount", String.valueOf(invoiceIds.size()));
            AllEBillCommonCustomEvent.setCurrentDisplay(that, Boolean.FALSE, 3, false);
            new AllEBillIssueResultTabCustomEvent().showDetail(that, "result/negative/showDetail", map);
            return;
        }
        if (CollectionUtils.isNotEmpty((Collection)mergeRelations)) {
            DynamicObjectCollection originalBillList = QueryServiceHelper.query((String)"sim_original_bill", (String)String.join((CharSequence)",", "invoiceamount", "itemcount"), (QFilter[])new QFilter("id", "in", billIds).toArray());
            BigDecimal invoiceAmount = BigDecimal.ZERO;
            int itemCount = 0;
            for (Object bill2 : originalBillList) {
                invoiceAmount = invoiceAmount.add(bill2.getBigDecimal("invoiceamount"));
                itemCount += bill2.getInt("itemcount");
            }
            DynamicObjectCollection originalBills = this.queryBill(that, billIds, invoiceAmount, itemCount);
            map.put("bills", DynamicObjectUtil.dynamicObjects2ListMap((List)originalBills, (boolean)true));
        }
        HashMap<String, Object> returnMap = new HashMap<String, Object>(4);
        DynamicObject[] matchBills = BusinessDataServiceHelper.load((Object[])pks.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_match_bill"));
        new AllEBillTabCustomEvent().createNegativeReturn(that, returnMap, Arrays.stream(matchBills).collect(Collectors.toList()));
        String matchBillIds = Arrays.stream(matchBills).map(matchBill -> String.valueOf(matchBill.getLong("id"))).distinct().collect(Collectors.joining(","));
        ArrayList<Object> mergeRelationList = new ArrayList<Object>(mergeRelations.size());
        for (DynamicObject mergeRelation : mergeRelations) {
            mergeRelationList.add(DynamicObjectUtil.dynamicObject2Bean(BillRelationDTO.class, (DynamicObject)mergeRelation));
        }
        AllEBillCommonCustomEvent.putPageCache(that, "mergeRelations", SerializationUtils.toJsonString(mergeRelationList));
        AllEBillCommonCustomEvent.putPageCache(that, "matchbillPks", matchBillIds);
        AllEBillCommonCustomEvent.putPageCache(that, "save_matchbillPks", matchBillIds);
        AllEBillCommonCustomEvent.putPageCache(that, "currentTab", "negative");
        int curIndex = bills.stream().anyMatch(bill -> BillComprehensiveStatusEnum.SECOND_NEGATIVE_PAGE_STATUS.contains((Object)bill.getString("comprehensivestatus"))) ? 1 : 2;
        AllEBillCommonCustomEvent.setCurrentDisplay(that, Boolean.FALSE, curIndex, false);
        Map<String, Object> currenMap = AllEBillCommonCustomEvent.getCurrentPageParams(AllEBillCommonCustomEvent.getPageCacheVal(that, "currentTab"), curIndex);
        map.putAll(currenMap);
        AllEBillCommonCustomEvent.updateCustomControl(that, map, "setCurrentDisplay");
    }

    private void createMergeBillBillRepeat(AbstractFormPlugin that, Map<String, Object> map, List<Long> pks) {
        DynamicObjectCollection relations = QueryServiceHelper.query((String)"sim_merge_inv_relation", (String)String.join((CharSequence)",", "tbillid", "sbillid"), (QFilter[])new QFilter("sbillid", "in", pks).toArray());
        List invoiceIds = relations.stream().map(relation -> String.valueOf(relation.getLong("tbillid"))).distinct().collect(Collectors.toList());
        AllEBillCommonCustomEvent.putPageCache(that, "invoiceIdPks", String.join((CharSequence)",", invoiceIds));
        AllEBillCommonCustomEvent.putPageCache(that, "blueInvoiceCount", String.valueOf(invoiceIds.size()));
        AllEBillCommonCustomEvent.putPageCache(that, "currentTab", "positive");
        DynamicObjectCollection invoices = QueryServiceHelper.query((String)"sim_vatinvoice", (String)"issuestatus", (QFilter[])new QFilter("id", "in", (Object)invoiceIds.stream().map(Long::parseLong).toArray()).toArray());
        if (invoices.stream().noneMatch(invoice -> IssueStatusEnum.none.getCode().equals(invoice.getString("issuestatus")))) {
            AllEBillCommonCustomEvent.setCurrentDisplay(that, Boolean.TRUE, 3, false);
            new AllEBillIssueResultTabCustomEvent().showDetail(that, "result/positive/showDetail", map);
            return;
        }
        HashMap<String, Object> positiveBill = new HashMap<String, Object>(4);
        positiveBill.put("pageIndex", 1);
        positiveBill.put("pageSize", 10);
        List<Long> subIdList = this.getSubIdList(pks, JSONObject.parseObject((String)SerializationUtils.toJsonString(positiveBill)));
        DynamicObject[] positiveBillArr = BusinessDataServiceHelper.load((Object[])subIdList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_merge_bill"));
        positiveBill.put("total", positiveBillArr.length);
        positiveBill.put("totalPage", (pks.size() - 1) / 10 + 1);
        positiveBill.put("positiveBillList", this.getHandlerList(Arrays.stream(positiveBillArr).collect(Collectors.toList())));
        AllEBillCommonCustomEvent.putPageCache(that, "mergebillPks", pks.stream().map(String::valueOf).collect(Collectors.joining(",")));
        AllEBillCommonCustomEvent.setCurrentDisplay(that, Boolean.TRUE, 2, true);
        map.put("positive", positiveBill);
        map.put("invoicecount", String.valueOf(invoiceIds.size()));
        AllEBillCommonCustomEvent.updateCustomControl(that, map, "preview/positive/repeatInit");
    }

    private Map<String, Object> createBillProcessMap(AbstractFormPlugin that, DynamicObjectCollection bills) {
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("currentDisplay", 0);
        map.put("bills", DynamicObjectUtil.dynamicObjects2ListMap((List)bills, (boolean)true));
        long currentDataOrgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)((DynamicObject)bills.get(0)).get("orgid"));
        AllEBillCommonCustomEvent.putPageCache(that, "currentOrg", String.valueOf(currentDataOrgId));
        AllEBillCommonCustomEvent.putPageCache(that, "currentSalerTaxNo", ((DynamicObject)bills.get(0)).getString("salertaxno"));
        new BillCommonCustomEvent().initAccount(((DynamicObject)bills.get(0)).getString("salertaxno"), map);
        map.put("taxequipment", InvoiceConstant.DIFFF_06);
        map.put("limitAmounts", new LimitAmountsDTO(true));
        map.put("splitrule", new BillCommonCustomEvent().getSplitRules(currentDataOrgId));
        map.put("mergerule", this.getMergeRules(currentDataOrgId));
        map.put("redConfirmmatchrule", this.getRedConfirmMatchRules(currentDataOrgId));
        map.put("matchrule", this.getMatchRules(currentDataOrgId, true));
        map.put("currentDataOrgId", currentDataOrgId);
        map.put("creditQuota", CacheHelper.get((String)("creditQuota_" + ((DynamicObject)bills.get(0)).getString("salertaxno"))));
        return map;
    }

    public void changeTab(AbstractFormPlugin that, String param) {
        String isAllIssue;
        int curIndex;
        JSONObject json = JSONObject.parseObject((String)param);
        boolean isPositive = "positive".equals(json.getString("tab"));
        Tab tab = (Tab)that.getView().getControl("tabap");
        if (isPositive) {
            if (StringUtils.isBlank((String)AllEBillCommonCustomEvent.getPageCacheVal(that, "mergebillPks"))) {
                AllEBillCommonCustomEvent.updateCustomControlError(that, new HashMap<String, Object>((Map<String, Object>)json), "common/changeTab");
                return;
            }
        } else if (StringUtils.isBlank((String)AllEBillCommonCustomEvent.getPageCacheVal(that, "matchbillPks"))) {
            AllEBillCommonCustomEvent.updateCustomControlError(that, new HashMap<String, Object>((Map<String, Object>)json), "common/changeTab");
            return;
        }
        if ((curIndex = json.getInteger("currentDisplay").intValue()) == 3 && "0".equals(isAllIssue = AllEBillCommonCustomEvent.getPageCacheVal(that, isPositive ? "result/negative/showDetail" : "result/positive/showDetail"))) {
            that.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5f85\u5f00\u6570\u636e\u672a\u5f00\u5177\u5b8c\u6210\uff0c\u8bf7\u7a0d\u540e\u5207\u6362\u3002", (String)"OriginalBillAllEWorkbenchPlugin_11", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        int maxIndex = Integer.parseInt(AllEBillCommonCustomEvent.getPageCacheVal(that, json.getString("tab") + "MaxIndex"));
        AllEBillCommonCustomEvent.putPageCache(that, "currentTab", json.getString("tab"));
        json.put("currentDisplay", (Object)maxIndex);
        that.getView().setVisible(Boolean.valueOf(!isPositive), new String[]{"flex_negative_" + maxIndex});
        that.getView().setVisible(Boolean.valueOf(isPositive), new String[]{"flex_positive_" + maxIndex});
        tab.activeTab("tab_" + maxIndex);
        AllEBillCommonCustomEvent.updateCustomControl(that, new HashMap<String, Object>((Map<String, Object>)json), "common/changeTab");
    }

    private List<SplitOrMergeRuleDTO> getMergeRules(long orgId) {
        return this.getRules("bdm_merge_rule_strategy", orgId);
    }

    private List<SplitOrMergeRuleDTO> getMatchRules(long orgId) {
        return this.getMatchRules(orgId, false);
    }

    private List<SplitOrMergeRuleDTO> getMatchRules(long orgId, boolean addDefaultSetting) {
        return this.getRules("bdm_match_ori_inv_setting", orgId, addDefaultSetting);
    }

    private List<SplitOrMergeRuleDTO> getRedConfirmMatchRules(long orgId) {
        return this.getRules("bdm_match_redconfirm", orgId);
    }

    private List<SplitOrMergeRuleDTO> getRules(String tableId, long orgId) {
        return this.getRules(tableId, orgId, false);
    }

    private List<SplitOrMergeRuleDTO> getRules(String tableId, long orgId, boolean addDefaultSetting) {
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)tableId, (Long)DynamicObjectUtil.getDynamicObjectLongValue((Object)orgId));
        baseDataFilter.and("enable", "=", (Object)"1");
        if ("bdm_match_ori_inv_setting".equals(tableId) && !"1".equals(ImcConfigUtil.getValue((String)"bdm_match_ori_inv_setting", (String)"ignore_workbench_filter"))) {
            baseDataFilter.and("matchstandard", "!=", (Object)"2");
        }
        DynamicObjectCollection rules = QueryServiceHelper.query((String)tableId, (String)String.join((CharSequence)",", "id", "name"), (QFilter[])baseDataFilter.toArray());
        ArrayList<SplitOrMergeRuleDTO> list = new ArrayList<SplitOrMergeRuleDTO>(rules.size());
        if (addDefaultSetting) {
            list.add(new SplitOrMergeRuleDTO("systemDefaultMatchByRedReasonCode", ResManager.loadKDString((String)"\u6309\u7ea2\u51b2\u539f\u56e0\u81ea\u52a8\u5339\u914d", (String)"AllEBillCommonCustomEvent_1", (String)"imc-sim-service", (Object[])new Object[0])));
        }
        for (DynamicObject rule : rules) {
            list.add(new SplitOrMergeRuleDTO(String.valueOf(rule.getLong("id")), rule.getString("name")));
        }
        return list;
    }
}

