/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill.workbench.alleevent;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.imc.bdm.common.constant.OperationConstant;
import kd.imc.bdm.common.dto.BillRelationDTO;
import kd.imc.bdm.common.helper.BotpHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.SystemParameterHelper;
import kd.imc.bdm.common.util.CallbackHelperUtil;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.constant.RedConfirmBillRedReasonEnum;
import kd.imc.sim.common.constant.table.MatchBillConstant;
import kd.imc.sim.common.dto.minusbill.MatchBillRequest;
import kd.imc.sim.common.utils.BillOperationLockUtil;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.formplugin.bill.originalbill.workbench.alleevent.AbstractAllEBillWorkbenchCustomEvent;
import kd.imc.sim.formplugin.bill.originalbill.workbench.alleevent.AllEBillProcessPositiveTabCustomEvent;
import kd.imc.sim.formplugin.bill.originalbill.workbench.alleevent.AllEBillWorkbenchCacheHelper;
import kd.imc.sim.formplugin.bill.originalbill.workbench.event.AbstractBillWorkbenchCustomEvent;
import kd.imc.sim.formplugin.bill.originalbill.workbench.task.AutoBillMatchTask;
import kd.imc.sim.formplugin.match.BillComprehensiveStatusHelper;
import kd.imc.sim.formplugin.match.MatchBillRedHelper;
import kd.imc.sim.formplugin.match.MinusBillMatchHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class AllEBillProcessNegativeTabCustomEvent
extends AbstractAllEBillWorkbenchCustomEvent {
    @Override
    public void customEvent(AbstractFormPlugin that, CustomEventArgs e) {
        String event = e.getEventName();
        String param = e.getEventArgs();
        try {
            switch (event) {
                case "process/negative/queryNegativeBill": {
                    new AllEBillProcessPositiveTabCustomEvent().queryPositiveOrNegativeBill(that, param, "negative", "process/negative/queryNegativeBill");
                    break;
                }
                case "process/negative/invSpecify": {
                    this.checkBillIsOtherCanceld(that, param);
                    this.checkBillIsOtherMatched(that, param);
                    this.openInvoiceSpecifyPage(that, param);
                    break;
                }
                case "process/negative/autoMatch": {
                    this.checkBillIsOtherCanceld(that, param);
                    this.checkBillIsOtherMatched(that, param);
                    this.negativeAutoMatch(that, param);
                    break;
                }
                case "process/negative/cancelMatch": {
                    this.checkBillIsOtherCanceld(that, param);
                    this.beforeCancelMatch(that, param);
                    break;
                }
                case "process/negative/modifyMatchBill": {
                    this.modifyMatchBill(that, param);
                    break;
                }
                case "process/negative/selectAll": {
                    this.negativeSelectAll(that, param);
                }
            }
        }
        catch (KDBizException ex) {
            that.getView().showTipNotification(ex.getMessage());
        }
    }

    private void checkBillIsOtherMatched(AbstractFormPlugin that, String param) {
        Set<Long> matchBillIdSet = this.getSelectMatchBill(that, param);
        if (matchBillIdSet.size() == 0) {
            return;
        }
        List<BillRelationDTO> mergeRelations = AllEBillWorkbenchCacheHelper.getCacheMatchBillRelations(that);
        List<String> saveIdList = AllEBillWorkbenchCacheHelper.getSavedMatchBillIdList(that);
        for (Long matchBillId : matchBillIdSet) {
            if (saveIdList.contains(String.valueOf(matchBillId))) continue;
            this.checkBillIsOtherMatched(that, matchBillId, mergeRelations);
        }
    }

    private void checkBillIsOtherMatched(AbstractFormPlugin that, Long matchBillId, List<BillRelationDTO> mergeRelations) {
        List billNos = mergeRelations.stream().filter(relation -> matchBillId.equals(relation.gettBillId())).map(BillRelationDTO::getsBillNo).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(billNos)) {
            return;
        }
        QFilter qFilter = new QFilter("orgid", "=", (Object)AllEBillWorkbenchCacheHelper.getCurrentOrg(that)).and("billno", "in", billNos).and("confirmstate", "!=", (Object)"0");
        DynamicObjectCollection originalBill = QueryServiceHelper.query((String)"sim_original_bill", (String)"billno", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isNotEmpty((Collection)originalBill)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e%s\u5df2\u88ab\u5176\u4ed6\u7528\u6237\u5339\u914d\uff0c\u65e0\u6cd5\u518d\u6b21\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u8fdb\u5165\u5de5\u4f5c\u53f0\u5904\u7406", (String)"AllEBillProcessNegativeTabCustomEvent_20", (String)"imc-sim-service", (Object[])new Object[0]), originalBill.stream().map(bill -> bill.getString("billno")).collect(Collectors.joining(","))));
        }
    }

    private void checkBillIsOtherCanceld(AbstractFormPlugin that, String param) {
        Set<Long> matchBillIdSet = this.getSelectMatchBill(that, param);
        this.checkBillIsOtherCanceld(that, matchBillIdSet);
    }

    public void checkBillIsOtherCanceld(AbstractFormPlugin that, Set<Long> matchBillIdSet) {
        if (matchBillIdSet.size() == 0) {
            return;
        }
        DynamicObjectCollection matchBills = QueryServiceHelper.query((String)"sim_match_bill", (String)String.join((CharSequence)",", "id", "matchstatus", "matchtime", "billno"), (QFilter[])new QFilter("id", "in", matchBillIdSet).toArray());
        Map<Long, DynamicObject> dbMatchBillMap = matchBills.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v, (v1, v2) -> v1));
        for (Long matchBillId : matchBillIdSet) {
            DynamicObject dbMatchBill = dbMatchBillMap.get(matchBillId);
            DynamicObject cacheMatchBill = AllEBillWorkbenchCacheHelper.getCacheMatchBillById(that, matchBillId);
            if (dbMatchBill != null) {
                if (!dbMatchBill.getString("matchstatus").equals(cacheMatchBill.getString("matchstatus"))) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u5df2\u7ecf\u88ab\u5176\u4ed6\u7528\u6237\u5339\u914d\u6216\u53d6\u6d88\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u8fdb\u5165\u5de5\u4f5c\u53f0\u5904\u7406", (String)"AllEBillProcessNegativeTabCustomEvent_19", (String)"imc-sim-service", (Object[])new Object[0]), cacheMatchBill.getString("billno")));
                }
                Date dbMatchTime = dbMatchBill.getDate("matchtime");
                Date workbenchMatchTime = cacheMatchBill.getDate("matchtime");
                if (dbMatchTime != null && workbenchMatchTime != null && DateUtils.format((Date)dbMatchTime, (String)"yyyy-MM-dd HH:mm:ss").equals(DateUtils.format((Date)workbenchMatchTime, (String)"yyyy-MM-dd HH:mm:ss"))) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u5df2\u7ecf\u88ab\u5176\u4ed6\u7528\u6237\u5339\u914d\u6216\u53d6\u6d88\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u8fdb\u5165\u5de5\u4f5c\u53f0\u5904\u7406", (String)"AllEBillProcessNegativeTabCustomEvent_19", (String)"imc-sim-service", (Object[])new Object[0]), cacheMatchBill.getString("billno")));
            }
            if (!StringUtils.isNotBlank((CharSequence)cacheMatchBill.getString("matchstatus"))) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u5df2\u7ecf\u88ab\u53d6\u6d88\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u8fdb\u5165\u5de5\u4f5c\u53f0\u8fdb\u884c\u5904\u7406", (String)"AllEBillProcessNegativeTabCustomEvent_18", (String)"imc-sim-service", (Object[])new Object[0]), cacheMatchBill.getString("billno")));
        }
    }

    private void negativeAutoMatch(AbstractFormPlugin that, String param) {
        Set<Long> matchBillIdSet = this.getSelectMatchBill(that, param);
        if (matchBillIdSet.size() == 0) {
            that.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u52fe\u9009\u4e00\u6761\u5355\u636e\u3002", (String)"AllEBillProcessNegativeTabCustomEvent_3", (String)"imc-sim-service", (Object[])new Object[0]));
            return;
        }
        ArrayList matchBillListStr = Lists.newArrayListWithCapacity((int)0);
        int manuallySize = 0;
        HashSet redReasonEmptySet = Sets.newHashSetWithExpectedSize((int)0);
        for (Long id : matchBillIdSet) {
            String matchBillStr = AbstractBillWorkbenchCustomEvent.getPageCacheVal(that, String.valueOf(id));
            DynamicObject matchBill = BusinessDataServiceHelper.newDynamicObject((String)"sim_match_bill");
            DynamicObjectUtil.json2DynamicObjectContainItems((JSONObject)JSONObject.parseObject((String)matchBillStr), (DynamicObject)matchBill, (boolean)true);
            String systemSource = matchBill.getString("systemsource");
            if (CallbackHelperUtil.isSystemSourceFi((String)systemSource) && !BotpHelper.isFromAr((Object)systemSource)) {
                that.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u4e0a\u6e38\u63a8\u9001\u7684\u5355\u636e\u6267\u884c\u81ea\u52a8\u5339\u914d\uff0c\u8bf7\u624b\u52a8\u6307\u5b9a\u7ea2\u5b57\u786e\u8ba4\u5355\u6216\u84dd\u7968\u3002", (String)"AllEBillPreviewNegativeTabCustomEvent_16", (String)"imc-sim-service", (Object[])new Object[0]));
                return;
            }
            String matchTarget = matchBill.getString("matchtarget");
            if ("2".equals(matchTarget) || "3".equals(matchTarget)) {
                ++manuallySize;
                continue;
            }
            if (StringUtils.isEmpty((CharSequence)matchBill.getString("redreason"))) {
                redReasonEmptySet.add(id);
            }
            matchBillListStr.add(matchBillStr);
        }
        if (matchBillListStr.size() == 0) {
            that.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u53ef\u81ea\u52a8\u5339\u914d\u7684\u6570\u636e\u3002", (String)"AllEBillPreviewNegativeTabCustomEvent_14", (String)"imc-sim-service", (Object[])new Object[0]));
            return;
        }
        HashMap params = Maps.newHashMapWithExpectedSize((int)0);
        params.put("matchBills", matchBillListStr);
        JSONObject configObject = JSONObject.parseObject((String)param);
        params.put("blueConfig", configObject.getString("blueconfig"));
        params.put("redConfig", configObject.getString("redconfig"));
        params.put("redReasonEmptySet", redReasonEmptySet);
        params.put("manuallySize", manuallySize);
        params.put("currentDataOrgId", AllEBillProcessNegativeTabCustomEvent.getPageCacheVal(that, "currentOrg"));
        params.put("allSize", matchBillIdSet.size());
        if (redReasonEmptySet.size() != 0) {
            ViewUtil.openDialog((AbstractFormPlugin)that, (String)"", (Map)params, (String)"sim_choose_matchconfig", (String)"chooseRedReason");
            return;
        }
        if (manuallySize != 0) {
            that.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5df2\u624b\u5de5\u6307\u5b9a%1$s\u6761\u6570\u636e\uff0c\u53ef\u81ea\u52a8\u5339\u914d%2$s\u6761\u3002", (String)"AllEBillPreviewNegativeTabCustomEvent_15", (String)"imc-sim-service", (Object[])new Object[0]), manuallySize, matchBillIdSet.size() - manuallySize));
        }
        new AutoBillMatchTask().formDispatchTaskFromSim(that, params, ResManager.loadKDString((String)"\u81ea\u52a8\u5339\u914d", (String)"OriginalBillAllEWorkbenchProcessPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]), AutoBillMatchTask.class.getName());
    }

    private void beforeCancelMatch(AbstractFormPlugin that, String param) {
        Set<Long> matchBillIdSet = this.getSelectMatchBill(that, param);
        if (matchBillIdSet.size() == 0) {
            that.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u52fe\u9009\u4e00\u6761\u5355\u636e\u3002", (String)"AllEBillProcessNegativeTabCustomEvent_3", (String)"imc-sim-service", (Object[])new Object[0]));
            return;
        }
        boolean isContainsMatch = false;
        for (Long matchBillId : matchBillIdSet) {
            DynamicObject matchBill = AllEBillWorkbenchCacheHelper.getCacheMatchBillById(that, matchBillId);
            String matchStatus = matchBill.getString("matchstatus");
            if (!MatchBillConstant.MatchStatusEnum.MATCH_SUCCESS.getCode().equals(matchStatus) && !MatchBillConstant.MatchStatusEnum.MATCH_PART_SUCCESS.getCode().equals(matchStatus) && !MatchBillConstant.MatchStatusEnum.MATCH_FAIL.getCode().equals(matchStatus)) continue;
            isContainsMatch = true;
            break;
        }
        if (!isContainsMatch && QueryServiceHelper.exists((String)"sim_match_bill", (QFilter[])new QFilter("id", "in", matchBillIdSet).toArray())) {
            isContainsMatch = true;
        }
        if (!isContainsMatch) {
            that.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u5df2\u5339\u914d\u5355\u636e\uff0c\u65e0\u6cd5\u53d6\u6d88\u5339\u914d\u3002", (String)"AllEBillProcessNegativeTabCustomEvent_21", (String)"imc-sim-service", (Object[])new Object[0]));
            return;
        }
        AllEBillProcessNegativeTabCustomEvent.putPageCache(that, "cancelIds", matchBillIdSet.stream().map(String::valueOf).collect(Collectors.joining(",")));
        ViewUtil.openNormalConfirm((AbstractFormPlugin)that, (String)ResManager.loadKDString((String)"\u786e\u8ba4\u53d6\u6d88\u5355\u636e\u4e0e\u84dd\u5b57\u53d1\u7968\u6216\u7ea2\u5b57\u786e\u8ba4\u5355\u5173\u8054\uff1f", (String)"AllEBillProcessNegativeTabCustomEvent_4", (String)"imc-sim-service", (Object[])new Object[0]), (String)"cancel_match");
    }

    public void cancelMatch(AbstractFormPlugin that) {
        OperationResult operationResult;
        String cancelIds = AllEBillProcessNegativeTabCustomEvent.getPageCacheVal(that, "cancelIds");
        Set matchBillIdSet = Splitter.on((String)",").trimResults().splitToList((CharSequence)cancelIds).stream().map(Long::parseLong).collect(Collectors.toSet());
        DynamicObjectCollection matchBills = QueryServiceHelper.query((String)"sim_match_bill", (String)String.join((CharSequence)",", "id", "matchtarget"), (QFilter[])new QFilter("id", "in", matchBillIdSet).toArray());
        if (matchBills.size() != 0 && !(operationResult = OperationServiceHelper.executeOperate((String)"cancel_match", (String)"sim_match_bill", (Object[])matchBills.stream().map(matchBill -> matchBill.getLong("id")).toArray(), null)).isSuccess()) {
            LOGGER.info("\u8d1f\u6570\u5f00\u7968\u7533\u8bf7\u5355\u53d6\u6d88\u5339\u914d" + OperationConstant.getErrorMsg((OperationResult)operationResult));
            that.getView().showErrorNotification(OperationConstant.getErrorMsg((OperationResult)operationResult));
            return;
        }
        List<Long> allMatchBillIds = AllEBillWorkbenchCacheHelper.getCacheMatchBillIdList(that).stream().map(Long::parseLong).collect(Collectors.toList());
        DynamicObjectCollection existsMatchBills = QueryServiceHelper.query((String)"sim_match_bill", (String)"id", (QFilter[])new QFilter("id", "in", allMatchBillIds).toArray());
        if (CollectionUtils.isNotEmpty((Collection)existsMatchBills)) {
            DynamicObject[] bills = BusinessDataServiceHelper.load((Object[])existsMatchBills.stream().map(bill -> bill.getLong("id")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_match_bill"));
            for (DynamicObject bill2 : bills) {
                AllEBillProcessNegativeTabCustomEvent.putPageCache(that, String.valueOf(bill2.getLong("id")), SerializationUtils.toJsonString((Object)bill2));
            }
        }
        allMatchBillIds.removeAll(existsMatchBills.stream().map(bill -> bill.getLong("id")).collect(Collectors.toList()));
        List<BillRelationDTO> matchRelationList = AllEBillWorkbenchCacheHelper.getCacheMatchBillRelations(that);
        for (Long allMatchBillId : allMatchBillIds) {
            this.notExsitMatchBillCancel(that, matchRelationList, allMatchBillId);
        }
        String savedMatchBillIds = AllEBillProcessNegativeTabCustomEvent.getPageCacheVal(that, "save_matchbillPks");
        if (StringUtils.isNotBlank((CharSequence)savedMatchBillIds)) {
            Set savedMatchBillIdList = Splitter.on((String)",").splitToStream((CharSequence)savedMatchBillIds).map(Long::parseLong).collect(Collectors.toSet());
            allMatchBillIds.forEach(savedMatchBillIdList::remove);
            AllEBillProcessNegativeTabCustomEvent.putPageCache(that, "save_matchbillPks", savedMatchBillIdList.stream().map(Object::toString).collect(Collectors.joining(",")));
        }
        AllEBillProcessNegativeTabCustomEvent.updateCustomControl(that, null, "process/negative/invSpecify/return");
        that.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u5339\u914d\u7ed3\u679c\u6210\u529f\u3002", (String)"AllEBillProcessNegativeTabCustomEvent_2", (String)"imc-sim-service", (Object[])new Object[0]));
    }

    public void notExsitMatchBillCancel(AbstractFormPlugin that, List<BillRelationDTO> matchRelationList, Long matchBillId) {
        DynamicObject bill;
        DynamicObject matchBill = AllEBillWorkbenchCacheHelper.getCacheMatchBillById(that, matchBillId);
        DynamicObjectCollection items = matchBill.getDynamicObjectCollection("sim_original_bill_item");
        for (DynamicObject item : items) {
            item.getDynamicObjectCollection("subentryentity").clear();
            item.getDynamicObjectCollection("confirmsubentryentity").clear();
            item.set("itemmatchstatus", (Object)MatchBillConstant.MatchStatusEnum.UN_PROCESS.getCode());
        }
        matchBill.set("pushdownstatus", (Object)"0");
        matchBill.set("matchamount", (Object)BigDecimal.ZERO);
        matchBill.set("matchtax", (Object)BigDecimal.ZERO);
        matchBill.set("matchtotalamount", (Object)BigDecimal.ZERO);
        matchBill.set("matchinvoicenum", (Object)BigDecimal.ZERO);
        matchBill.set("matchrule", (Object)0L);
        matchBill.set("matchconfig", (Object)0L);
        matchBill.set("matchtype", (Object)"");
        matchBill.set("matchtarget", (Object)"");
        matchBill.set("matchstatus", (Object)"");
        matchBill.set("matchtime", null);
        String redReason = matchBill.getString("redreason");
        matchBill.set("redreason", (Object)"");
        List relations = matchRelationList.stream().filter(relation -> relation.gettBillId().equals(matchBillId)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(relations) && (bill = QueryServiceHelper.queryOne((String)"sim_original_bill", (String)"redreason", (QFilter[])new QFilter("id", "=", (Object)((BillRelationDTO)relations.get(0)).getsBillId()).toArray())) != null && StringUtils.isNotBlank((CharSequence)bill.getString("redreason"))) {
            matchBill.set("redreason", (Object)redReason);
        }
        AllEBillProcessNegativeTabCustomEvent.putPageCache(that, String.valueOf(matchBillId), SerializationUtils.toJsonString((Object)matchBill));
    }

    private void modifyMatchBill(AbstractFormPlugin that, String pk) {
        if (StringUtils.isBlank((CharSequence)pk)) {
            that.getView().showTipNotification(ResManager.loadKDString((String)"\u4f20\u5165\u6570\u636e\u4e3a\u7a7a\u3002", (String)"AllEBillProcessNegativeTabCustomEvent_0", (String)"imc-sim-service", (Object[])new Object[0]));
            return;
        }
        if (!QueryServiceHelper.exists((String)"sim_match_bill", (Object)Long.valueOf(pk))) {
            that.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u624b\u5de5\u6307\u5b9a\u6216\u81ea\u52a8\u5339\u914d\uff0c\u8bf7\u5148\u64cd\u4f5c\u3002", (String)"AllEBillProcessNegativeTabCustomEvent_1", (String)"imc-sim-service", (Object[])new Object[0]));
            return;
        }
        HashSet<Long> ids = new HashSet<Long>(4);
        ids.add(Long.parseLong(pk));
        this.checkBillIsOtherCanceld(that, ids);
        DynamicObject matchBill = AllEBillWorkbenchCacheHelper.getCacheMatchBillById(that, Long.parseLong(pk));
        String systemSource = matchBill.getString("systemsource");
        if (CallbackHelperUtil.isSystemSourceFi((String)systemSource) && !BotpHelper.isFromAr((Object)systemSource)) {
            that.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u4e0a\u6e38\u63a8\u9001\u7684\u5355\u636e\u7f16\u8f91\uff0c\u8bf7\u624b\u52a8\u6307\u5b9a\u7ea2\u5b57\u786e\u8ba4\u5355\u6216\u84dd\u7968\u3002", (String)"AllEBillPreviewNegativeTabCustomEvent_17", (String)"imc-sim-service", (Object[])new Object[0]));
            return;
        }
        AllEBillProcessNegativeTabCustomEvent.putPageCache(that, "modifyId", pk);
        BillShowParameter listParam = new BillShowParameter();
        listParam.setPkId((Object)pk);
        listParam.setStatus(OperationStatus.EDIT);
        listParam.getOpenStyle().setShowType(ShowType.Modal);
        listParam.setFormId("sim_match_bill");
        listParam.setCloseCallBack(new CloseCallBack((IFormPlugin)that, "process/negative/modifyMatchBill"));
        listParam.setCustomParam("source", (Object)"workbench");
        that.getView().showForm((FormShowParameter)listParam);
    }

    private void openInvoiceSpecifyPage(AbstractFormPlugin that, String param) {
        Set<Long> matchBillIdSet = this.getSelectMatchBill(that, param);
        if (matchBillIdSet.size() == 0) {
            that.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u52fe\u9009\u4e00\u6761\u5355\u636e\u3002", (String)"AllEBillProcessNegativeTabCustomEvent_3", (String)"imc-sim-service", (Object[])new Object[0]));
            return;
        }
        ArrayList<DynamicObject> matchBillList = new ArrayList<DynamicObject>(matchBillIdSet.size());
        int autoMatchSize = 0;
        for (Long matchBillId : matchBillIdSet) {
            DynamicObject matchBill = AllEBillWorkbenchCacheHelper.getCacheMatchBillById(that, matchBillId);
            String matchTarget = matchBill.getString("matchtarget");
            if ("0".equals(matchTarget) || "1".equals(matchTarget)) {
                ++autoMatchSize;
                continue;
            }
            if ("2".equals(matchTarget) || "3".equals(matchTarget)) continue;
            matchBillList.add(matchBill);
        }
        if (matchBillList.size() == 0) {
            that.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u53ef\u624b\u5de5\u6307\u5b9a\u7684\u6570\u636e\u3002", (String)"AllEBillPreviewNegativeTabCustomEvent_12", (String)"imc-sim-service", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Serializable> params = new HashMap<String, Serializable>(4);
        params.put("orgid", AllEBillWorkbenchCacheHelper.getCurrentOrg(that));
        params.put("data", matchBillList);
        ViewUtil.openDialog((AbstractFormPlugin)that, null, params, (String)"sim_invoice_specify", (String)"specify", (boolean)true);
        if (autoMatchSize != 0) {
            that.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5df2\u81ea\u52a8\u5339\u914d%1$s\u6761\u6570\u636e\uff0c\u53ef\u624b\u5de5\u6307\u5b9a%2$s\u6761\u3002", (String)"AllEBillPreviewNegativeTabCustomEvent_13", (String)"imc-sim-service", (Object[])new Object[0]), autoMatchSize, matchBillIdSet.size() - autoMatchSize));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveMatchInvioce(AbstractFormPlugin that, List<DynamicObject> matchRedConfirmList, boolean isSaveAndClose) {
        block18: {
            if (StringUtils.isNotBlank((CharSequence)AllEBillProcessNegativeTabCustomEvent.getPageCacheVal(that, "matchBill_begin_save"))) {
                that.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u7968\u5355\u6b63\u5728\u63d0\u4ea4\u5f00\u7968\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"BillPreviewTabCustomEvent_2", (String)"imc-sim-service", (Object[])new Object[0]));
                return;
            }
            AllEBillProcessNegativeTabCustomEvent.putPageCache(that, "matchBill_begin_save", "matchBill_begin_save");
            List<BillRelationDTO> mergeRelations = AllEBillWorkbenchCacheHelper.getCacheMatchBillRelations(that);
            List billNos = mergeRelations.stream().map(BillRelationDTO::getsBillNo).distinct().collect(Collectors.toList());
            try (TXHandle tx = TX.required();){
                try {
                    BillOperationLockUtil.getBillsLock(billNos, (boolean)true, (long)AllEBillWorkbenchCacheHelper.getCurrentOrg(that));
                    this.saveMatchBill(that, mergeRelations, matchRedConfirmList, isSaveAndClose);
                    AllEBillProcessNegativeTabCustomEvent.putPageCache(that, "matchamountlabel", BigDecimal.ZERO.setScale(2, 4).toString());
                    AllEBillProcessNegativeTabCustomEvent.putPageCache(that, "unmatchamountlabel", BigDecimal.ZERO.setScale(2, 4).toString());
                    this.setMatchBillMatchAmount(that);
                    this.setMatchBillUnMatchAmount(that);
                }
                catch (Throwable e) {
                    try {
                        LOGGER.error("\u63d0\u4ea4\u5f00\u7968\u5f02\u5e38", e);
                        that.getView().showErrorNotification(e.getMessage());
                        tx.markRollback();
                        break block18;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        that.getPageCache().remove("matchBill_begin_save");
                        BillOperationLockUtil.unOperationLook((String)AllEBillWorkbenchCacheHelper.getCurrentOrg(that).toString(), billNos);
                    }
                }
                that.getPageCache().remove("matchBill_begin_save");
                BillOperationLockUtil.unOperationLook((String)AllEBillWorkbenchCacheHelper.getCurrentOrg(that).toString(), billNos);
            }
        }
    }

    private void saveMatchBill(AbstractFormPlugin that, List<BillRelationDTO> mergeRelations, List<DynamicObject> matchBillList, boolean isSaveAndClose) {
        Object originalBills;
        List matchBillIdList = AllEBillWorkbenchCacheHelper.getCacheMatchBillIdList(that).stream().map(Long::valueOf).collect(Collectors.toList());
        HashMap<Long, String> matchBillStatus = new HashMap<Long, String>(matchBillIdList.size());
        if (matchBillList == null || matchBillList.size() == 0) {
            return;
        }
        List<String> saveIdList = AllEBillWorkbenchCacheHelper.getSavedMatchBillIdList(that);
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(matchBillList.size());
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(matchBillList.size());
        for (DynamicObject matchBill2 : matchBillList) {
            matchBillIdList.remove(matchBill2.getLong("id"));
            matchBillStatus.put(matchBill2.getLong("id"), matchBill2.getString("matchstatus"));
            if (StringUtils.isBlank((CharSequence)matchBill2.getString("redreason"))) {
                matchBill2.set("redreason", (Object)RedConfirmBillRedReasonEnum.INVOICE_ERR.getBillCode());
            }
            if (saveIdList.contains(String.valueOf(matchBill2.getLong("id")))) {
                if (!isSaveAndClose) {
                    updateList.add(matchBill2);
                }
            } else {
                this.checkBillIsOtherMatched(that, matchBill2.getLong("id"), mergeRelations);
                if (matchBill2.getDate("matchtime") == null) {
                    matchBill2.set("matchtime", (Object)MinusBillMatchHelper.getMatchTime());
                }
                saveList.add(matchBill2);
            }
            AllEBillProcessNegativeTabCustomEvent.putPageCache(that, String.valueOf(matchBill2.getLong("id")), SerializationUtils.toJsonString((Object)matchBill2));
        }
        if (CollectionUtils.isNotEmpty(saveList)) {
            MinusBillMatchHelper matchHelper = new MinusBillMatchHelper();
            MatchBillRequest matchBillRequest = new MatchBillRequest();
            List saveIdSet = saveList.stream().map(matchBill -> matchBill.getLong("id")).collect(Collectors.toList());
            originalBills = BusinessDataServiceHelper.load((Object[])mergeRelations.stream().filter(relation -> saveIdSet.contains(relation.gettBillId())).map(BillRelationDTO::getsBillId).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_original_bill"));
            matchBillRequest.setNoMatchOriginalBills(Arrays.stream(originalBills).collect(Collectors.toList()));
            matchBillRequest.setRelations(mergeRelations.stream().filter(relation -> saveIdSet.contains(relation.gettBillId())).collect(Collectors.toList()));
            String string = AllEBillProcessNegativeTabCustomEvent.getPageCacheVal(that, "operatebatch") + "red";
            for (DynamicObject bill : matchBillRequest.getNoMatchOriginalBills()) {
                bill.set("operatebatch", (Object)string);
            }
            matchHelper.saveCreateMatchBills(saveList, matchBillRequest, matchBillStatus);
            ImcSaveServiceHelper.save((DynamicObject[])originalBills);
            saveIdList.addAll(saveIdSet.stream().map(String::valueOf).collect(Collectors.toList()));
            AllEBillProcessNegativeTabCustomEvent.putPageCache(that, "save_matchbillPks", saveIdList.stream().distinct().collect(Collectors.joining(",")));
        }
        if (CollectionUtils.isNotEmpty(updateList)) {
            Set updateIds = updateList.stream().map(matchBill -> matchBill.getLong("id")).collect(Collectors.toSet());
            Set relations = mergeRelations.stream().filter(relation -> updateIds.contains(relation.gettBillId())).collect(Collectors.toSet());
            HashMap<Long, Set> matchBill2Bill = new HashMap<Long, Set>(relations.size());
            originalBills = relations.iterator();
            while (originalBills.hasNext()) {
                BillRelationDTO billRelationDTO = (BillRelationDTO)originalBills.next();
                Set billIds = matchBill2Bill.computeIfAbsent(billRelationDTO.gettBillId(), k -> new HashSet());
                billIds.add(billRelationDTO.getsBillId());
            }
            for (Object bill : originalBills = BusinessDataServiceHelper.load((Object[])relations.stream().map(BillRelationDTO::getsBillId).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_original_bill"))) {
                bill.set("confirmstate", (Object)"2");
                bill.set("confirmamount", bill.get("1".equals(bill.getString("hsbz")) ? "totalamount" : "invoiceamount"));
                DynamicObjectCollection items = bill.getDynamicObjectCollection("sim_original_bill_item");
                for (DynamicObject item : items) {
                    item.set("remainvalidamount", (Object)BigDecimal.ZERO);
                    item.set("remainvalidtax", (Object)BigDecimal.ZERO);
                    item.set("remainvalidnum", (Object)BigDecimal.ZERO);
                }
            }
            Map<Long, DynamicObject> map = Arrays.stream(originalBills).collect(Collectors.toMap(k -> k.getLong("id"), v -> v, (v1, v2) -> v1));
            Set entries = matchBill2Bill.entrySet();
            BillComprehensiveStatusHelper billComprehensiveStatusHelper = new BillComprehensiveStatusHelper();
            for (Map.Entry entry : entries) {
                DynamicObject matchBill3 = AllEBillWorkbenchCacheHelper.getCacheMatchBillById(that, (Long)entry.getKey());
                Set billIds = (Set)entry.getValue();
                ArrayList<DynamicObject> bills = new ArrayList<DynamicObject>(billIds.size());
                for (Long billId : billIds) {
                    bills.add(map.get(billId));
                }
                for (DynamicObject bill : bills) {
                    bill.set("matchstatus", matchBill3.get("matchstatus"));
                }
                if (!CollectionUtils.isNotEmpty(bills)) continue;
                billComprehensiveStatusHelper.setBillsComprehensiveStatusByMatchBill(matchBill3, bills.toArray(new DynamicObject[0]));
            }
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"sim_match_bill"), (Object[])updateIds.toArray());
            ImcSaveServiceHelper.save(updateList);
            ImcSaveServiceHelper.save((DynamicObject[])originalBills);
        }
    }

    @Deprecated
    public void nextStep(AbstractFormPlugin that) {
        this.nextStep(that, true);
    }

    public void nextStep(AbstractFormPlugin that, boolean autoUploadRedConfirm) {
        List<String> idList = AllEBillWorkbenchCacheHelper.getCacheMatchBillIdList(that);
        List<String> savedIdList = AllEBillWorkbenchCacheHelper.getSavedMatchBillIdList(that);
        if (idList.size() != savedIdList.size()) {
            that.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u624b\u5de5\u6307\u5b9a\u6216\u81ea\u52a8\u5339\u914d\uff0c\u8bf7\u5148\u64cd\u4f5c\u3002", (String)"AllEBillProcessNegativeTabCustomEvent_1", (String)"imc-sim-service", (Object[])new Object[0]));
            return;
        }
        DynamicObject[] matchBills = BusinessDataServiceHelper.load((Object[])idList.stream().map(Long::parseLong).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_match_bill"));
        if (matchBills.length != savedIdList.size()) {
            List dbMatchBILLIds = Arrays.stream(matchBills).map(matchBill -> String.valueOf(matchBill.getPkValue())).collect(Collectors.toList());
            savedIdList.removeIf(dbMatchBILLIds::contains);
            String cancelBillNos = savedIdList.stream().map(matchBillId -> AllEBillWorkbenchCacheHelper.getCacheMatchBillById(that, Long.parseLong(matchBillId)).getString("billno")).collect(Collectors.joining(","));
            that.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u5df2\u7ecf\u88ab\u53d6\u6d88\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u8fdb\u5165\u5de5\u4f5c\u53f0\u8fdb\u884c\u5904\u7406", (String)"AllEBillProcessNegativeTabCustomEvent_18", (String)"imc-sim-service", (Object[])new Object[0]), cancelBillNos));
            return;
        }
        boolean noMatch = Arrays.stream(matchBills).noneMatch(matchBill -> MatchBillConstant.MatchStatusEnum.MATCH_SUCCESS.getCode().equals(matchBill.getString("matchstatus")) || MatchBillConstant.MatchStatusEnum.MATCH_PART_SUCCESS.getCode().equals(matchBill.getString("matchstatus")));
        if (noMatch) {
            that.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u5df2\u5339\u914d\u6570\u636e\uff0c\u8bf7\u5339\u914d\u540e\u518d\u8fdb\u5165\u4e0b\u4e00\u6b65\u3002", (String)"AllEBillProcessNegativeTabCustomEvent_5", (String)"imc-sim-service", (Object[])new Object[0]));
            return;
        }
        ArrayList<DynamicObject> redConfirms = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> redInvoice = new ArrayList<DynamicObject>(1);
        MatchBillRedHelper matchBillRedHelper = new MatchBillRedHelper();
        try (TXHandle tx = TX.requiresNew();){
            try {
                for (DynamicObject matchBill2 : matchBills) {
                    redConfirms.addAll(matchBillRedHelper.matchBillRed(matchBill2, redInvoice, AllEBillProcessNegativeTabCustomEvent.getPageCacheVal(that, "currentAccount"), null));
                }
            }
            catch (KDBizException e) {
                that.getView().showTipNotification(e.getMessage());
                tx.markRollback();
                if (tx != null) {
                    if (var11_13 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var11_13.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
                return;
            }
        }
        BigDecimal negativeBillDiff = SystemParameterHelper.getSimParameterBigDecimal((long)DynamicObjectUtil.getDynamicObjectLongValue((Object)matchBills[0].get("org")), (String)"negativebilldiff");
        if (!MathUtils.isZero((BigDecimal)negativeBillDiff)) {
            if (StringUtils.isEmpty((CharSequence)that.getPageCache().get("negativeBillDiffAllE"))) {
                ArrayList<String> objects = new ArrayList<String>();
                StringBuilder stringBuilder = new StringBuilder();
                DynamicObject[] dynamicObjectArray = matchBills;
                int n = dynamicObjectArray.length;
                for (int matchBill2 = 0; matchBill2 < n; ++matchBill2) {
                    BigDecimal redConfirmDiff;
                    DynamicObject matchBill3 = dynamicObjectArray[matchBill2];
                    objects.clear();
                    DynamicObjectCollection simOriginalBillItem = matchBill3.getDynamicObjectCollection("sim_original_bill_item");
                    for (DynamicObject dynamicObject : simOriginalBillItem) {
                        DynamicObjectCollection confirmsubentryentity = dynamicObject.getDynamicObjectCollection("confirmsubentryentity");
                        for (DynamicObject[] redConfirmItem : confirmsubentryentity) {
                            objects.add(redConfirmItem.getString("confirminfocode"));
                        }
                    }
                    BigDecimal matchTax = matchBill3.getBigDecimal("matchtax");
                    QFilter qFilter = new QFilter("number", "in", objects);
                    DynamicObject[] redConfirmList = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)"totaltax", (QFilter[])qFilter.toArray());
                    if (redConfirmList.length <= 0) continue;
                    BigDecimal totalRedAmount = BigDecimal.ZERO;
                    for (DynamicObject redConfirm : redConfirmList) {
                        BigDecimal redTax = redConfirm.getBigDecimal("totaltax");
                        totalRedAmount = totalRedAmount.add(redTax);
                    }
                    BigDecimal configDiff = negativeBillDiff.abs();
                    if (configDiff.subtract(redConfirmDiff = totalRedAmount.abs().subtract(matchTax.abs()).abs()).compareTo(BigDecimal.ZERO) < 0) {
                        String error = String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s,\u5408\u8ba1\u7a0e\u989d\u4e0e\u7ea2\u5b57\u786e\u8ba4\u5355\u7a0e\u989d\u5dee\u5f02\u5df2\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u5b58\u5728\u7a0e\u989d\u5dee\u5f02\u4e3a%2$s,\u5141\u8bb8\u5bb9\u5dee\u8303\u56f4\u00b1%3$s,\u5355\u636e\u7a0e\u989d%4$s,\u7ea2\u5b57\u786e\u8ba4\u5355\u7a0e\u989d%5$s", (String)"BillHelper_13", (String)"imc-sim-common", (Object[])new Object[0]), matchBill3.getString("billno"), redConfirmDiff.stripTrailingZeros().toPlainString(), configDiff, matchTax.stripTrailingZeros().toPlainString(), totalRedAmount.stripTrailingZeros().toPlainString());
                        throw new KDBizException(error);
                    }
                    if (redConfirmDiff.compareTo(BigDecimal.ZERO) == 0) continue;
                    String error = String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s,\u5408\u8ba1\u7a0e\u989d\u4e0e\u7ea2\u5b57\u786e\u8ba4\u5355\u5b58\u5728\u7a0e\u989d\u5dee\u5f02\u4e3a%2$s,\u5141\u8bb8\u5bb9\u5dee\u8303\u56f4\u00b1%3$s,\u5355\u636e\u7a0e\u989d%4$s,\u7ea2\u5b57\u786e\u8ba4\u5355\u7a0e\u989d%5$s", (String)"BillHelper_12", (String)"imc-sim-common", (Object[])new Object[0]), matchBill3.getString("billno"), redConfirmDiff.stripTrailingZeros().toPlainString(), configDiff.stripTrailingZeros().toPlainString(), matchTax.stripTrailingZeros().toPlainString(), totalRedAmount.stripTrailingZeros().toPlainString());
                    stringBuilder.append(error).append("\n");
                }
                if (stringBuilder.length() > 0) {
                    ViewUtil.openConfirm((String)"negativeBillDiffAllE", (String)ResManager.loadKDString((String)"\u4ee5\u4e0b\u5f00\u7968\u7533\u8bf7\u5355\u4e0e\u7ea2\u5b57\u786e\u8ba4\u5355\u5b58\u5728\u7a0e\u989d\u5c3e\u5dee\uff0c\u662f\u5426\u7ee7\u7eed?", (String)"InvoiceOriginalBillCallBack_10", (String)"imc-sim-formplugin", (Object[])new Object[0]), (AbstractFormPlugin)that, (String)ResManager.loadKDString((String)"\u53d6\u6d88", (String)"InvoiceBatchPlugin_27", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u786e\u8ba4", (String)"InvoiceBatchPlugin_28", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)stringBuilder.toString());
                    return;
                }
            } else {
                that.getPageCache().remove("negativeBillDiffAllE");
            }
        }
        AllEBillProcessNegativeTabCustomEvent.setCurrentDisplay(that, Boolean.FALSE, 2);
        AllEBillProcessNegativeTabCustomEvent.putPageCache(that, "nextstep_negative_1_submit", "1");
        if (autoUploadRedConfirm) {
            this.submitAndWriteInfoCode2MatchBill(that, redConfirms);
        } else {
            BillComprehensiveStatusHelper billComprehensiveStatusHelper = new BillComprehensiveStatusHelper();
            for (DynamicObject matchBill4 : matchBills) {
                billComprehensiveStatusHelper.setBillComprehensiveStatusByMatchBill(matchBill4);
                AllEBillProcessNegativeTabCustomEvent.putPageCache(that, String.valueOf(matchBill4.getLong("id")), SerializationUtils.toJsonString((Object)matchBill4));
            }
        }
    }
}

