/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill.workbench.event;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.AllEleServiceHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.helper.ItemMerge2OneHelper;
import kd.imc.sim.common.utils.BillOperationLockUtil;
import kd.imc.sim.formplugin.bill.originalbill.workbench.event.AbstractBillWorkbenchCustomEvent;
import kd.imc.sim.formplugin.bill.originalbill.workbench.pluginworkutils.BillProcessTabUtil;
import kd.imc.sim.formplugin.issuing.control.BatchInvoiceControl;

public class BillPreviewTabCustomEvent
extends AbstractBillWorkbenchCustomEvent {
    private static final String SAVE_DATA = "preview/save_data";
    public static final String CONFIRM_ISSUES = "preview/confirm_issues";
    public static final String PREVIEW_STATISTICS = "preview/statistics";
    private static final String PREVIEWBACK = "preview/previewback";
    private static final Log LOGGER = LogFactory.getLog(BillPreviewTabCustomEvent.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void customEvent(AbstractFormPlugin that, CustomEventArgs eventKey) {
        String event = eventKey.getEventName();
        String ars = eventKey.getEventArgs();
        JSONObject jsonArs = JSONObject.parseObject((String)ars);
        String isBeingSave = BillPreviewTabCustomEvent.getPageCacheVal(that, "being_save_bill");
        String isBeingOpenIssue = BillPreviewTabCustomEvent.getPageCacheVal(that, "being_open_issue");
        switch (event) {
            case "preview/previewback": {
                Boolean previewDataSave = jsonArs.getBoolean("previewDataSave");
                if (!previewDataSave.booleanValue()) break;
                HashMap<String, String> costom = new HashMap<String, String>(2);
                costom.put("data", ResManager.loadKDString((String)"\u6570\u636e\u5df2\u88ab\u4fdd\u5b58\uff0c\u6570\u636e\u4e0d\u53ef\u8fd4\u56de\u4e0a\u4e00\u6b65\u8fdb\u884c\u4fee\u6539\u3002", (String)"BillPreviewTabCustomEvent_0", (String)"imc-sim-service", (Object[])new Object[0]));
                ViewUtil.openDialog((AbstractFormPlugin)that, costom, (String)"sim_buyerinfo_err_tip", (String)"sim_buyerinfo_err_tip");
                break;
            }
            case "preview/save_data": {
                if (StringUtils.isNotBlank((CharSequence)isBeingSave)) {
                    that.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u7968\u5355\u6b63\u5728\u4fdd\u5b58\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"BillPreviewTabCustomEvent_1", (String)"imc-sim-service", (Object[])new Object[0]));
                    return;
                }
                if (StringUtils.isNotBlank((CharSequence)isBeingOpenIssue)) {
                    that.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u7968\u5355\u6b63\u5728\u63d0\u4ea4\u5f00\u7968\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"BillPreviewTabCustomEvent_2", (String)"imc-sim-service", (Object[])new Object[0]));
                    return;
                }
                this.dealWithInvoiceJson(jsonArs);
                this.removeApplyPreviewReason(jsonArs);
                BillPreviewTabCustomEvent.putPageCache(that, "being_save_bill", "1");
                BillPreviewTabCustomEvent.putPageCache(that, "saveDataJsonArs", jsonArs.toJSONString());
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("data_save", (IFormPlugin)that);
                HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
                btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4\u4fdd\u5b58", (String)"BillPreviewTabCustomEvent_3", (String)"imc-sim-service", (Object[])new Object[0]));
                btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"BillPreviewTabCustomEvent_4", (String)"imc-sim-service", (Object[])new Object[0]));
                that.getView().showConfirm(ResManager.loadKDString((String)"\u4fdd\u5b58\u6570\u636e\u540e\u4e0d\u53ef\u4fee\u6539\uff0c\u662f\u5426\u4fdd\u5b58\uff1f", (String)"BillPreviewTabCustomEvent_5", (String)"imc-sim-service", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
                break;
            }
            case "preview/confirm_issues": {
                List collect;
                boolean isInvoice;
                Map<String, List<DynamicObject>> stringListMap;
                if (StringUtils.isNotBlank((CharSequence)isBeingSave)) {
                    that.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u7968\u5355\u6b63\u5728\u4fdd\u5b58\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"BillPreviewTabCustomEvent_1", (String)"imc-sim-service", (Object[])new Object[0]));
                    return;
                }
                if (StringUtils.isNotBlank((CharSequence)isBeingOpenIssue)) {
                    that.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u7968\u5355\u6b63\u5728\u63d0\u4ea4\u5f00\u7968\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"BillPreviewTabCustomEvent_2", (String)"imc-sim-service", (Object[])new Object[0]));
                    return;
                }
                BillPreviewTabCustomEvent.putPageCache(that, "being_open_issue", "1");
                this.dealWithInvoiceJson(jsonArs);
                this.removeApplyPreviewReason(jsonArs);
                List<String> billNos = BillPreviewTabCustomEvent.getBillNoList(jsonArs);
                Throwable throwable = null;
                try (TXHandle tx = TX.required();){
                    try {
                        long billOrg = BillPreviewTabCustomEvent.getBillOrg(jsonArs);
                        LOGGER.info("BillPreviewTabCustomEvent CONFIRM_ISSUES Look" + billNos);
                        BillOperationLockUtil.getBillsLock(billNos, (boolean)jsonArs.getBoolean("previewDataSave"), (long)billOrg);
                        stringListMap = BillProcessTabUtil.json2Array(that, jsonArs);
                        BillProcessTabUtil.saveInvoiceData(stringListMap);
                        List<DynamicObject> updateDy = BillProcessTabUtil.updateSplitUseCount(jsonArs.getString("treatmentShowBillList"), jsonArs.getString("splitrule"), billOrg);
                        ImcSaveServiceHelper.save(updateDy);
                    }
                    catch (Throwable e2) {
                        try {
                            LOGGER.error("\u63d0\u4ea4\u5f00\u7968\u5f02\u5e38", e2);
                            that.getView().showErrorNotification(e2.getMessage());
                            tx.markRollback();
                            BillPreviewTabCustomEvent.updateCustomControlError(that, null, CONFIRM_ISSUES);
                        }
                        catch (Throwable throwable2) {
                            try {
                                that.getPageCache().remove("being_open_issue");
                                BillOperationLockUtil.unOperationLook((String)BillPreviewTabCustomEvent.getPageCacheVal(that, "currentOrg"), billNos);
                                LOGGER.info("\u91ca\u653e\u9501" + billNos);
                                throw throwable2;
                            }
                            catch (Throwable e2) {
                                throwable = e2;
                                throw e2;
                            }
                            catch (Throwable throwable3) {
                                throw throwable3;
                            }
                        }
                        that.getPageCache().remove("being_open_issue");
                        BillOperationLockUtil.unOperationLook((String)BillPreviewTabCustomEvent.getPageCacheVal(that, "currentOrg"), billNos);
                        LOGGER.info("\u91ca\u653e\u9501" + billNos);
                        if (tx != null) {
                            if (throwable != null) {
                                try {
                                    tx.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                            } else {
                                tx.close();
                            }
                        }
                        return;
                    }
                    that.getPageCache().remove("being_open_issue");
                    BillOperationLockUtil.unOperationLook((String)BillPreviewTabCustomEvent.getPageCacheVal(that, "currentOrg"), billNos);
                    LOGGER.info("\u91ca\u653e\u9501" + billNos);
                }
                List<DynamicObject> invoiceList = stringListMap.get("invoiceList");
                List<DynamicObject> redInfoList = stringListMap.get("redInfoList");
                DynamicObject[] dealArray = redInfoList.toArray(new DynamicObject[0]);
                boolean bl = isInvoice = invoiceList.size() > 0;
                if (isInvoice) {
                    dealArray = invoiceList.toArray(new DynamicObject[0]);
                }
                ItemMerge2OneHelper.dealOriginalBillNumDifference((DynamicObject[])dealArray);
                if (!redInfoList.isEmpty() && !(collect = redInfoList.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getString("infocode"))).collect(Collectors.toList())).isEmpty()) {
                    Iterator<DynamicObject> iterator = redInfoList.iterator();
                    while (iterator.hasNext()) {
                        DynamicObject next = iterator.next();
                        if (!StringUtils.isNotBlank((CharSequence)next.getString("infocode"))) continue;
                        QFilter filter = new QFilter("infocode", "=", (Object)next.getString("infocode"));
                        filter.and("invoicestatus", "not in", (Object)new String[]{"3", "6"}).and("issuestatus", "=", (Object)"2");
                        DynamicObject[] load = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])filter.toArray());
                        invoiceList.addAll(Arrays.asList(load));
                        iterator.remove();
                    }
                }
                DynamicObject[] invoiceArr = new DynamicObject[invoiceList.size()];
                ArrayList invoiceIds = Lists.newArrayListWithExpectedSize((int)invoiceArr.length);
                for (int i = 0; i < invoiceList.size(); ++i) {
                    invoiceArr[i] = invoiceList.get(i);
                    invoiceIds.add(invoiceList.get(i).getLong("id"));
                }
                HashMap<String, Object> coustmMap = new HashMap<String, Object>(4);
                String blueinvoiceid = invoiceList.stream().map(o -> o.getString("id")).collect(Collectors.joining(","));
                String redinvoiceid = redInfoList.stream().map(o -> o.getString("id")).collect(Collectors.joining(","));
                coustmMap.put("blueinvoiceid", blueinvoiceid);
                coustmMap.put("redinvoiceid", redinvoiceid);
                if (invoiceList.size() > 0) {
                    String invoiceType = invoiceList.get(0).getString("invoicetype");
                    Object isElePaper = invoiceList.get(0).get("iselepaper");
                    coustmMap.put("invoiceIds", invoiceIds);
                    coustmMap.put("salertaxno", invoiceList.get(0).getString("salertaxno"));
                    coustmMap.put("account", jsonArs.getString("currentAccount"));
                    if ((InvoiceUtils.isAllEInvoice((Object)invoiceType) || AllEleAuthHelper.isElePaper((Object)isElePaper)) && AllEleServiceHelper.isNeedLogin((AbstractFormPlugin)that, coustmMap)) {
                        return;
                    }
                    BatchInvoiceControl.doBatchInvoice(jsonArs.getString("jqbh"), jsonArs.getString("terminalno"), invoiceArr);
                }
                BillPreviewTabCustomEvent.updateCustomControl(that, coustmMap, CONFIRM_ISSUES);
                break;
            }
            case "preview/change_saler_address": {
                BillPreviewTabCustomEvent.openSalerAddress(that, jsonArs);
                break;
            }
            case "preview/statistics": {
                BillPreviewTabCustomEvent.openPreviewStatisticsPage(that);
            }
        }
    }

    private void removeApplyPreviewReason(JSONObject jsonArs) {
        Object invoices = jsonArs.get((Object)"invoices");
        if (null != invoices) {
            JSONObject invoiceJson = (JSONObject)invoices;
            for (String key : invoiceJson.keySet()) {
                JSONArray jsonArray = invoiceJson.getJSONArray(key);
                for (Object obj : jsonArray) {
                    JSONObject oneInvoice = (JSONObject)obj;
                    String previewReason = oneInvoice.getString("addPreviewApplyReason");
                    String previewRemark = oneInvoice.getString("addPreviewApplyReason");
                    String applyreason = oneInvoice.getString("applyreason");
                    String remark = oneInvoice.getString("remark");
                    if (null != applyreason && StringUtils.isNotBlank((CharSequence)previewReason)) {
                        String replacedReason = applyreason.replace(previewReason, "");
                        oneInvoice.put("applyreason", (Object)replacedReason);
                    }
                    if (null == remark || !StringUtils.isNotBlank((CharSequence)previewRemark)) continue;
                    oneInvoice.put("remark", (Object)remark.replace(previewRemark, ""));
                }
            }
        }
    }

    private void dealWithInvoiceJson(JSONObject invoiceJson) {
        JSONObject invoices = invoiceJson.getJSONObject("invoices");
        invoices.forEach((key, value) -> {
            JSONArray invoiceArr = (JSONArray)value;
            for (Object o : invoiceArr) {
                JSONObject invoice = (JSONObject)o;
                if (!InvoiceUtils.isSpecialInvoice((String)invoice.getString("invoicetype")) || invoice.getBigDecimal("totalamount").compareTo(BigDecimal.ZERO) >= 0) continue;
                JSONArray items = invoice.getJSONArray("items");
                BigDecimal amount = items.stream().map(p -> ((JSONObject)p).getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal tax = items.stream().map(p -> ((JSONObject)p).getBigDecimal("tax")).reduce(BigDecimal.ZERO, BigDecimal::add);
                invoice.put("invoiceamount", (Object)amount);
                invoice.put("totaltax", (Object)tax);
            }
        });
    }

    public static List<String> getBillNoList(JSONObject jsonArs) {
        JSONArray invBills = jsonArs.getJSONArray("invBill");
        ArrayList billNos = Lists.newArrayListWithCapacity((int)invBills.size());
        for (int i = 0; i < invBills.size(); ++i) {
            JSONObject inv = invBills.getJSONObject(i);
            billNos.add(inv.getString("billno"));
        }
        return billNos;
    }

    public static long getBillOrg(JSONObject jsonArs) {
        JSONArray invBills = jsonArs.getJSONArray("invBill");
        if (invBills.size() > 0) {
            JSONObject bill = invBills.getJSONObject(0);
            return Long.parseLong(bill.getString("orgid"));
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5355\u636e\u7ec4\u7ec7\u5931\u8d25", (String)"BillPreviewTabCustomEvent_6", (String)"imc-sim-service", (Object[])new Object[0]));
    }

    public static void openSalerAddress(AbstractFormPlugin that, JSONObject jsonArs) {
        String taxNo = jsonArs.getString("salertaxno");
        QFilter qFilter = new QFilter("taxno", "=", (Object)taxNo);
        ViewUtil.openListPage((AbstractFormPlugin)that, (QFilter)qFilter, (String)"sim_invoice_setting", (String)"preview/change_saler_address");
    }
}

