/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill.workbench.event;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.constant.InvoiceStatus;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.constant.table.RedInfoConstant;
import kd.imc.bdm.common.dto.BillRelationDTO;
import kd.imc.bdm.common.dto.merge.MergeResponseDTO;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.EquipmentHelper;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.helper.RedConfirmHelper;
import kd.imc.bdm.common.helper.bill.HSAmountSplitHelper;
import kd.imc.bdm.common.helper.invoice.RemarkTemplateHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.model.invoice.InvoiceSpecialType;
import kd.imc.sim.common.model.invoice.TaxedTypeEnum;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.common.utils.ZeroTaxRateShowHelper;
import kd.imc.sim.formplugin.bill.originalbill.util.OriginalBillFormEditUtil;
import kd.imc.sim.formplugin.bill.originalbill.workbench.alleevent.AbstractAllEBillWorkbenchCustomEvent;
import kd.imc.sim.formplugin.bill.originalbill.workbench.alleevent.AllEBillWorkbenchCacheHelper;
import kd.imc.sim.formplugin.bill.originalbill.workbench.event.AbstractBillWorkbenchCustomEvent;
import kd.imc.sim.formplugin.bill.originalbill.workbench.pluginworkutils.BillProcessTabUtil;

public class BillProcessTabCustomEvent
extends AbstractBillWorkbenchCustomEvent {
    private static final Log LOGGER = LogFactory.getLog(BillProcessTabCustomEvent.class);

    @Override
    public void customEvent(AbstractFormPlugin that, CustomEventArgs eventKey) {
        String event = eventKey.getEventName();
        String ars = eventKey.getEventArgs();
        switch (event) {
            case "process/openbuyerlist": {
                this.openBuyerList(that, ars);
                break;
            }
            case "process/processnextstep": {
                Map<String, Object> processnextstep = BillProcessTabUtil.processnextstep(that, JSONObject.parseObject((String)ars));
                this.chechBillDetailSpecialCodeRemark(that, processnextstep, ars);
                break;
            }
            case "process/openredinfolist": {
                this.openRedInfoPage(that, ars);
                break;
            }
            case "process/openblueinfolist": {
                this.openBlueInfoPage(that, ars);
                break;
            }
            case "process/changeSplitRule": {
                this.changeSplitRule(that, ars, "process/changeSplitRule");
                break;
            }
            case "process/prestep": {
                this.clearWorkbenchCache(ars);
                this.clearInfoCodeChoose(that);
                BillProcessTabCustomEvent.updateCustomControl(that, new HashMap<String, Object>(4), "process/prestep");
                break;
            }
            case "process/queryinfocode": {
                this.queryInfoCodeExist(that, ars);
                break;
            }
            case "process/invoicecontent": {
                BillProcessTabCustomEvent.changeInvoiceContent(that, ars);
                break;
            }
            case "process/openFixedQuantity": {
                ViewUtil.openDialog((AbstractFormPlugin)that, null, (String)"sim_bill_fixed_quantity", (String)"sim_bill_fixed_quantity");
                break;
            }
            case "process/queryMergeDeviation": {
                this.queryMergeDeviation(that, ars, "process/queryMergeDeviation");
                break;
            }
            case "process/queryredconfirmbill": {
                this.openRedConfirmBillList(that, ars);
                break;
            }
            case "process/queryPlace": {
                this.openQueryPlaceList(that, ars);
            }
        }
    }

    private void openQueryPlaceList(AbstractFormPlugin that, String ars) {
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"bdm_admindivision", (boolean)false, (int)2, (boolean)true);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)that, "process/queryPlace"));
        that.getPageCache().put(that.getView().getPageId() + "queryPlace", ars);
        that.getView().showForm((FormShowParameter)showParameter);
    }

    void openBuyerList(AbstractFormPlugin that, String params) {
        BillProcessTabCustomEvent.putPageCache(that, "process/openbuyerlist", params);
        QFilter filter = ImcBaseDataHelper.getInvTitleFilter((Object)Long.parseLong(BillProcessTabCustomEvent.getPageCacheVal(that, "currentOrg")));
        ViewUtil.openListPage((AbstractFormPlugin)that, (QFilter)filter, (String)"bdm_invice_title_strate", (String)"process/openbuyerlist");
    }

    private void openRedConfirmBillList(AbstractFormPlugin that, String ars) {
        BillProcessTabCustomEvent.putPageCache(that, "workbenchOpenRedConfirmBillList", ars);
        JSONObject arsJson = JSONObject.parseObject((String)ars);
        JSONObject invoice = arsJson.getJSONObject("invoice");
        String buyerName = invoice.getString("buyername");
        String specialType = invoice.getString("specialtype");
        String sellerTaxNo = invoice.getString("salertaxno");
        QFilter filter = new QFilter("confirmstatus", "in", (Object)new String[]{"01", "04"});
        if (StringUtils.isNotBlank((CharSequence)buyerName)) {
            filter = "E12".equals(specialType) ? filter.and("salername", "=", (Object)buyerName) : filter.and("buyername", "=", (Object)buyerName);
        }
        Object totalAmount = invoice.get((Object)"totalamount");
        QFilter totalAmountFilter = new QFilter("totalamount", "=", this.getNumberValue(totalAmount));
        Object totalTax = invoice.get((Object)"totaltax");
        QFilter totalTaxFilter = new QFilter("totaltax", "=", this.getNumberValue(totalTax));
        Object orgId = invoice.get((Object)"orgid");
        String invoiceType = (String)invoice.get((Object)"invoicetype");
        String isElePaper = invoice.getString("iselepaper");
        QFilter invoiceTypeFilter = AllEleAuthHelper.isElePaper((Object)isElePaper) ? (InvoiceUtils.isNormalInvoice((String)invoiceType) ? new QFilter("originalinvoicetype", "in", (Object)new String[]{"026", "007"}) : new QFilter("originalinvoicetype", "in", (Object)new String[]{"028", "004"})) : (InvoiceUtils.isNormalInvoice((String)invoiceType) || InvoiceType.ALL_E_NORMAL.getTypeCode().equals(invoiceType) ? new QFilter("originalinvoicetype", "in", (Object)new String[]{"026", "007", "10xdp"}) : new QFilter("originalinvoicetype", "in", (Object)new String[]{"028", "004", "08xdp"}));
        QFilter taxNoFilter = "E12".equals(specialType) ? new QFilter("buyertaxno", "=", (Object)sellerTaxNo) : new QFilter("salertaxno", "=", (Object)sellerTaxNo);
        QFilter baseDataFilter = ImcBaseDataHelper.getRedConfirmFilter((Object)orgId);
        QFilter normalFilter = RedConfirmHelper.getNormalUsefulFilter();
        QFilter usedFilter = RedConfirmHelper.getBillUsedFilter();
        QFilter allFilter = filter.and(totalAmountFilter).and(totalTaxFilter).and(invoiceTypeFilter).and(baseDataFilter).and(normalFilter).and(taxNoFilter).and(usedFilter);
        ViewUtil.openListPage((AbstractFormPlugin)that, (QFilter)allFilter, (String)"sim_red_confirm_bill", (String)"queryRedConfirmBill", (boolean)true, (boolean)false, null);
    }

    private Object getNumberValue(Object value) {
        if (value instanceof String) {
            return new BigDecimal((String)value);
        }
        return value;
    }

    private void clearInfoCodeChoose(AbstractFormPlugin that) {
        String selectedInfoCodes = BillProcessTabCustomEvent.getPageCacheVal(that, "selectedInfoCodes");
        if (StringUtils.isBlank((CharSequence)selectedInfoCodes)) {
            return;
        }
        JSONObject cacheJson = JSONObject.parseObject((String)selectedInfoCodes);
        Set entries = cacheJson.entrySet();
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            Map.Entry next = (Map.Entry)iterator.next();
            Boolean isWorkbenchFillIn = (Boolean)next.getValue();
            if (isWorkbenchFillIn == null || !isWorkbenchFillIn.booleanValue()) continue;
            iterator.remove();
        }
        BillProcessTabCustomEvent.putPageCache(that, "selectedInfoCodes", cacheJson.toJSONString());
    }

    public static void changeInvoiceContent(AbstractFormPlugin that, String ars) {
        JSONObject params = JSONObject.parseObject((String)ars);
        String invoiceContent = params.getString("invoiceContent");
        String mergeBillId = params.getString("mergeBillId");
        JSONObject invoiceListMap = params.getJSONObject("billInvoiceList");
        JSONObject mergeBillJson = JSONObject.parseObject((String)BillProcessTabCustomEvent.getPageCacheVal(that, mergeBillId));
        String invoiceContentChange = mergeBillJson.getString("mergekey");
        JSONObject invoice = invoiceListMap.getJSONArray(mergeBillId).getJSONObject(0);
        switch (invoiceContentChange) {
            case "1": {
                invoice.clear();
                invoice.putAll((Map)JSONObject.parseObject((String)BillProcessTabCustomEvent.getPageCacheVal(that, mergeBillId + "invoiceContent" + invoiceContent)));
                invoice.put("invoiceContent", (Object)invoiceContent);
                break;
            }
            case "-1": {
                if ("1".equals(invoiceContent)) {
                    invoice.put("items", (Object)new JSONArray());
                    invoice.put("invoiceContent", (Object)invoiceContent);
                    that.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5355\u636e%s\u5bf9\u5e94\u7684\u7ea2\u5b57\u4fe1\u606f\u8868\u5728\u53d1\u7968\u4e91\u4e0d\u5b58\u5728\uff0c\u4ec5\u652f\u6301\u6309\u8d1f\u6570\u5355\u636e\u5f00\u7968\u3002", (String)"BillProcessTabCustomEvent_0", (String)"imc-sim-service", (Object[])new Object[0]), mergeBillJson.getString("billno")));
                    break;
                }
                invoice.clear();
                invoice.putAll((Map)JSONObject.parseObject((String)BillProcessTabCustomEvent.getPageCacheVal(that, mergeBillId + "invoiceContent" + invoiceContent)));
                invoice.put("invoiceContent", (Object)invoiceContent);
                break;
            }
            case "0": {
                invoice.put("invoiceContent", (Object)invoiceContent);
            }
        }
        HashMap<String, Object> returnMap = new HashMap<String, Object>(4);
        returnMap.put("invoiceList", invoiceListMap);
        returnMap.put("invoiceRelationMap", new JSONObject());
        BillProcessTabCustomEvent.updateCustomControl(that, returnMap, "process/invoicecontent");
    }

    public static void billProcessNext(AbstractFormPlugin that, Map<String, Object> processnextstep) {
        if (!processnextstep.isEmpty()) {
            BillProcessTabCustomEvent.openPreviewStatistics(that);
            ViewUtil.bindDataToHtml((AbstractFormPlugin)that, processnextstep, (String)"workbench");
        }
    }

    public void chechBillDetailSpecialCodeRemark(AbstractFormPlugin that, Map<String, Object> map, String ars) {
        if (CollectionUtils.isEmpty(map)) {
            return;
        }
        JSONObject dataArr = (JSONObject)map.get("treatmentInvoiceList");
        ZeroTaxRateShowHelper.dealItem((JSONObject)dataArr);
        LOGGER.info("ZeroTaxRateShowHelper.dataArr" + JSONObject.toJSONString((Object)dataArr));
        if (!this.checkIsRedSpecial(that, map)) {
            return;
        }
        BillProcessTabCustomEvent.billProcessNext(that, map);
    }

    public void queryInfoCodeExist(AbstractFormPlugin that, String params) {
        try {
            if (StringUtils.isBlank((CharSequence)params)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u4e3a\u7a7a", (String)"BillProcessTabCustomEvent_4", (String)"imc-sim-service", (Object[])new Object[0]));
            }
            BillProcessTabCustomEvent.putPageCache(that, "workbenchIssueContent", params);
            JSONObject req = JSONObject.parseObject((String)params);
            String infoCode = req.getString("infoCode");
            String mergeBillId = req.getString("mergeBillId");
            Map<String, Object> returnMap = new HashMap<String, Object>(16);
            if (StringUtils.isBlank((CharSequence)infoCode)) {
                JSONObject billIdInvoiceMap = req.getJSONObject("billIdInvoiceMap");
                JSONObject invoice = billIdInvoiceMap.getJSONArray(mergeBillId).getJSONObject(0);
                invoice.put("originalinvoiceno", (Object)"");
                invoice.put("originalinvoicecode", (Object)"");
                invoice.put("originalissuetime", (Object)"");
                invoice.put("invoiceContent", (Object)"1");
                returnMap.put("invoiceList", billIdInvoiceMap);
                returnMap.put("invoiceRelationMap", new JSONObject());
                BillProcessTabCustomEvent.updateCustomControl(that, returnMap, "process/invoicecontent");
                return;
            }
            String mergeBillStr = BillProcessTabCustomEvent.getPageCacheVal(that, mergeBillId);
            Map billMap = (Map)SerializationUtils.fromJsonString((String)mergeBillStr, Map.class);
            String billno = (String)billMap.get("billno");
            String checkResult = this.checkInfocodeIsRight(infoCode);
            if (StringUtils.isNotBlank((CharSequence)checkResult)) {
                throw new KDBizException(checkResult);
            }
            String result = OriginalBillFormEditUtil.checkInfoCode(infoCode, billno, req.getString("infocodefrombill"), DynamicObjectUtil.getDynamicObjectLongValue(billMap.get("orgid")));
            if (StringUtils.isNotBlank((CharSequence)result)) {
                throw new KDBizException(result);
            }
            String selectedInfoCodes = BillProcessTabCustomEvent.getPageCacheVal(that, "selectedInfoCodes");
            if (StringUtils.isNotBlank((CharSequence)selectedInfoCodes) && JSONObject.parseObject((String)selectedInfoCodes).containsKey((Object)infoCode)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u7ea2\u5b57\u4fe1\u606f\u8868\u5df2\u5173\u8054\u5176\u4ed6\u5355\u636e", (String)"BillProcessTabCustomEvent_5", (String)"imc-sim-service", (Object[])new Object[0]));
            }
            returnMap = BillProcessTabUtil.dealWithInfoCodeByHand(that, infoCode);
            AbstractBillWorkbenchCustomEvent.updateCustomControl(that, returnMap, "process/openredinfolist");
        }
        catch (Exception e) {
            LOGGER.error("queryInfoCodeExist:" + e.getMessage(), (Throwable)e);
            BillProcessTabCustomEvent.handleExcepiton(that, e);
            BillProcessTabCustomEvent.updateCustomControlError(that, null, "process/queryinfocode");
        }
    }

    private String checkInfocodeIsRight(String infocode) {
        String result = "";
        if (infocode.length() != 16) {
            return ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u957f\u5ea6\u5e94\u8be5\u4e3a16\u4f4d\u6570\u5b57\u3002", (String)"BillProcessTabCustomEvent_6", (String)"imc-sim-service", (Object[])new Object[0]);
        }
        char[] chars = infocode.toCharArray();
        int sum = 0;
        for (int i = 0; i < chars.length - 1; ++i) {
            sum += Integer.parseInt(String.valueOf(chars[i]));
        }
        String sumStr = String.valueOf(sum);
        if (!sumStr.substring(sumStr.length() - 1).equals(String.valueOf(chars[chars.length - 1]))) {
            result = ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u683c\u5f0f\u9519\u8bef\uff0c\u524d15\u4f4d\u6570\u5b57\u4e4b\u548c\u7684\u4e2a\u4f4d\u6570\u4e0d\u7b49\u4e8e\u7b2c16\u4f4d\u6570\u3002", (String)"BillProcessTabCustomEvent_7", (String)"imc-sim-service", (Object[])new Object[0]);
        }
        return result;
    }

    public boolean checkIsRedSpecial(AbstractFormPlugin that, Map<String, Object> map) {
        JSONObject billInvoiceList = (JSONObject)map.get("treatmentInvoiceList");
        HashMap infocodes = Maps.newHashMapWithExpectedSize((int)billInvoiceList.size());
        Set billInvoiceEntries = billInvoiceList.entrySet();
        for (Map.Entry billInvoiceEntry : billInvoiceEntries) {
            JSONArray invoiceArray = (JSONArray)billInvoiceEntry.getValue();
            for (Object invoice : invoiceArray) {
                JSONObject jSONObject = (JSONObject)invoice;
                JSONArray invoiceItems = jSONObject.getJSONArray("items");
                if (CollectionUtils.isEmpty((Collection)invoiceItems)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\u5bf9\u5e94\u53d1\u7968\u660e\u7ec6\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4", (String)"BillProcessTabCustomEvent_8", (String)"imc-sim-service", (Object[])new Object[0]), jSONObject.getString("batchbelong")));
                }
                if (!this.isRedSpecial(jSONObject).booleanValue()) continue;
                String infocode = jSONObject.getString("infocode");
                this.addRedRemark((JSONObject)invoice, jSONObject, infocode);
                if (StringUtils.isBlank((CharSequence)infocode)) continue;
                infocodes.put(jSONObject.getString("batchbelong"), infocode);
            }
        }
        ArrayList billnoList = Lists.newArrayListWithCapacity((int)infocodes.size());
        if (CollectionUtils.isEmpty((Map)infocodes)) {
            return true;
        }
        long currentOrgid = Long.parseLong(BillProcessTabCustomEvent.getPageCacheVal(that, "currentOrg"));
        Set infoCodeEntries = infocodes.entrySet();
        for (Map.Entry entry : infoCodeEntries) {
            if (BillProcessTabCustomEvent.checkInfocodeExist((String)entry.getValue(), currentOrgid)) continue;
            billnoList.add(entry.getValue());
        }
        if (CollectionUtils.isEmpty((Collection)billnoList)) {
            return true;
        }
        BillProcessTabCustomEvent.putPageCache(that, "isWorkBenchExsit", JSONObject.toJSONString(map));
        String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%s", (String)"BillProcessTabCustomEvent_25", (String)"imc-sim-service", (Object[])new Object[0]), String.join((CharSequence)",", billnoList));
        ViewUtil.openConfirm((String)"isWorkBenchExsit", (String)ResManager.loadKDString((String)"\u4ee5\u4e0b\u5355\u636e\u5bf9\u5e94\u7684\u7ea2\u5b57\u4fe1\u606f\u8868\u5728\u53d1\u7968\u4e91\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u6821\u9a8c\u53ef\u7ea2\u51b2\u91d1\u989d\uff0c\u662f\u5426\u7ee7\u7eed\u5f00\u7968\uff1f", (String)"BillProcessTabCustomEvent_10", (String)"imc-sim-service", (Object[])new Object[0]), (AbstractFormPlugin)that, (String)ResManager.loadKDString((String)"\u53d6\u6d88", (String)"BillProcessTabCustomEvent_26", (String)"imc-sim-service", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u7ee7\u7eed\u5f00\u7968", (String)"BillProcessTabCustomEvent_27", (String)"imc-sim-service", (Object[])new Object[0]), (String)msg);
        return false;
    }

    private void addRedRemark(JSONObject invoice, JSONObject invoiceJson, String infocode) {
        String applyreason;
        String string = applyreason = invoiceJson.get((Object)"applyreason") == null ? "" : (String)invoiceJson.get((Object)"applyreason");
        if (!applyreason.contains("\u5bf9\u5e94\u6b63\u6570\u53d1\u7968\u4ee3\u7801")) {
            String infoSerialNo;
            QFilter filter;
            DynamicObject[] infoArray;
            String oriInvoiceCode = invoice.getString("originalinvoicecode");
            String oriInvoiceNo = invoice.getString("originalinvoiceno");
            if (!(StringUtils.isNotBlank((CharSequence)oriInvoiceCode) && StringUtils.isNotBlank((CharSequence)oriInvoiceNo) || !StringUtils.isNotBlank((CharSequence)infocode) || (infoArray = BusinessDataServiceHelper.load((String)"sim_red_info", (String)"invoicecode,invoiceno,originalinvoicecode,originalinvoiceno", (QFilter[])(filter = new QFilter("infoserialno", "=", (Object)(infoSerialNo = invoice.getString("infoserialno"))).and("infosource", "!=", (Object)"6").and("infocode", "=", (Object)infocode)).toArray())).length <= 0)) {
                oriInvoiceCode = infoArray[0].getString("originalinvoicecode");
                oriInvoiceNo = infoArray[0].getString("originalinvoiceno");
            }
            if (StringUtils.isNotBlank((CharSequence)oriInvoiceCode) && StringUtils.isNotBlank((CharSequence)oriInvoiceNo)) {
                String redRemark = RemarkTemplateHelper.getRedInvoiceRemarkTemplate((String)oriInvoiceCode, (String)oriInvoiceNo);
                invoiceJson.put("applyreason", (Object)(applyreason + redRemark));
                invoiceJson.put("addPreviewApplyReason", (Object)redRemark);
            }
        }
    }

    private static boolean checkInfocodeExist(String infocodes, long orgId) {
        QFilter filter = new QFilter("infocode", "=", (Object)infocodes).and("status", "=", (Object)"3").and("org", "=", (Object)orgId);
        return QueryServiceHelper.exists((String)"sim_red_info", (QFilter[])filter.toArray());
    }

    private Boolean isRedSpecial(JSONObject invoice) {
        Boolean result = Boolean.FALSE;
        if (invoice.getBigDecimal("totalamount").compareTo(BigDecimal.ZERO) < 0 && InvoiceUtils.isSpecialInvoice((String)invoice.getString("invoicetype")) && !AllEleAuthHelper.isElePaper((Object)invoice.getString("iselepaper"))) {
            result = Boolean.TRUE;
        }
        return result;
    }

    public void changeSplitRule(AbstractFormPlugin that, String ars, String eventKey) {
        try {
            JSONObject json = JSONObject.parseObject((String)ars);
            String billStr = BillProcessTabCustomEvent.getPageCacheVal(that, json.getString("id"));
            LOGGER.info(String.format("changeSplitRule: %s", billStr));
            String ruleCode = json.getString("ruleCode");
            if (StringUtils.isBlank((CharSequence)ruleCode)) {
                that.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u62c6\u5206\u89c4\u5219", (String)"BillProcessTabCustomEvent_13", (String)"imc-sim-service", (Object[])new Object[0]));
                BillProcessTabCustomEvent.updateCustomControlError(that, null, eventKey);
                return;
            }
            Map billMap = (Map)SerializationUtils.fromJsonString((String)billStr, Map.class);
            DynamicObject bill = BusinessDataServiceHelper.newDynamicObject((String)"sim_original_bill");
            DynamicObjectUtil.map2DynamicObject((Map)billMap, (DynamicObject)bill);
            bill.set("splitrule", (Object)json.getString("ruleCode"));
            if (!"imc_no_split".equals(ruleCode)) {
                if (bill.getBigDecimal("invoiceamount").compareTo(BigDecimal.ZERO) < 0) {
                    that.getView().showTipNotification(ResManager.loadKDString((String)"\u7ea2\u7968\u4e0d\u80fd\u62c6\u5206", (String)"BillProcessTabCustomEvent_14", (String)"imc-sim-service", (Object[])new Object[0]));
                    BillProcessTabCustomEvent.updateCustomControlError(that, null, eventKey);
                    return;
                }
                if (InvoiceUtils.isAllEInvoice((Object)bill.getString("invoicetype")) || AllEleAuthHelper.isElePaper((Object)bill.getString("iselepaper"))) {
                    String taxationStyle;
                    if (InvoiceSpecialType.allEleSpecialType((String)bill.getString("specialtype"))) {
                        if (InvoiceSpecialType.allEleSpecialSplit((String)bill.getString("specialtype"))) {
                            if ("E14".equals(bill.getString("specialtype")) && !"imc_split_by_detail".equals(ruleCode)) {
                                that.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u5177\u673a\u52a8\u8f66\u589e\u503c\u7a0e\u53d1\u7968\u4e0d\u652f\u6301\u62c6\u5206\u3002", (String)"BillProcessTabCustomEvent_28", (String)"imc-sim-service", (Object[])new Object[0]));
                                BillProcessTabCustomEvent.updateCustomControlError(that, null, eventKey);
                                return;
                            }
                        } else {
                            that.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u7535\u7968\u7279\u6b8a\u884c\u4e1a\u53ea\u652f\u6301\u4e0d\u62c6\u5206", (String)"BillProcessTabCustomEvent_15", (String)"imc-sim-service", (Object[])new Object[0]));
                            BillProcessTabCustomEvent.updateCustomControlError(that, null, eventKey);
                            return;
                        }
                    }
                    if (TaxedTypeEnum.alleTaxedTypeDeduction((String)(taxationStyle = bill.getString("taxationstyle")))) {
                        that.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u7535\u7968\u5dee\u989d\u5f00\u7968\u53ea\u652f\u6301\u4e0d\u62c6\u5206", (String)"BillProcessTabCustomEvent_16", (String)"imc-sim-service", (Object[])new Object[0]));
                        BillProcessTabCustomEvent.updateCustomControlError(that, null, eventKey);
                        return;
                    }
                }
                if (bill.getBigDecimal("deduction").compareTo(BigDecimal.ZERO) != 0 && !"imc_deduction_split".equals(ruleCode)) {
                    that.getView().showTipNotification(ResManager.loadKDString((String)"\u5dee\u989d\u5355\u636e\u53ea\u652f\u6301\u4e0d\u62c6\u5206\u6216\u5dee\u989d\u62c6\u5206", (String)"BillProcessTabCustomEvent_17", (String)"imc-sim-service", (Object[])new Object[0]));
                    BillProcessTabCustomEvent.updateCustomControlError(that, null, eventKey);
                    return;
                }
            }
            if ("imc_deduction_split".equals(ruleCode) && MathUtils.isNullOrZero((BigDecimal)bill.getBigDecimal("deduction"))) {
                that.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u5dee\u989d\u5f81\u7a0e\u4e0d\u80fd\u4f7f\u7528\u5dee\u989d\u62c6\u5206", (String)"BillProcessTabCustomEvent_18", (String)"imc-sim-service", (Object[])new Object[0]));
                BillProcessTabCustomEvent.updateCustomControlError(that, null, eventKey);
                return;
            }
            if ("process/positive/changeSplitRule".equals(eventKey)) {
                json.put("billNoMap", (Object)AllEBillWorkbenchCacheHelper.getCacheBillNoMap(that));
            }
            if ("imc_split_by_invoice_quantity".equals(ruleCode)) {
                ViewUtil.openDialog((AbstractFormPlugin)that, (Map)json, (String)"sim_bill_split_quantity", (String)"sim_bill_split_quantity");
                return;
            }
            List billRelationList = JSONObject.parseArray((String)BillProcessTabCustomEvent.getPageCacheVal(that, "mergeRelations"), BillRelationDTO.class);
            if ("imc_split_by_amount".equals(ruleCode)) {
                this.splitByAmount(that, json, billStr, billRelationList);
                return;
            }
            if ("imc_split_by_detail".equals(ruleCode)) {
                HashMap<String, Object> map = new HashMap<String, Object>(2);
                map.put("ruleCode", json.getString("ruleCode"));
                BillProcessTabCustomEvent.updateCustomControl(that, map, eventKey);
                return;
            }
            MergeResponseDTO mergeResponse = new MergeResponseDTO();
            mergeResponse.setBillNoMap((Map)SerializationUtils.fromJsonString((String)json.getString("billNoMap"), Map.class));
            mergeResponse.setBills(Collections.singletonList(bill));
            mergeResponse.setRelations(billRelationList);
            Map<String, Object> map = "process/positive/changeSplitRule".equals(eventKey) ? AbstractAllEBillWorkbenchCustomEvent.splitCacheAllEBill(that, mergeResponse) : BillProcessTabCustomEvent.splitCacheBill(that, mergeResponse, json.getString("jqbh"), null);
            map.put("ruleCode", json.getString("ruleCode"));
            that.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u672c\u5355\u636e\u5df2\u5207\u6362\u6210%s\uff0c\u8bf7\u5728\u53f3\u4fa7\u67e5\u770b\u5355\u636e\u5bf9\u5e94\u53d1\u7968", (String)"BillProcessTabCustomEvent_19", (String)"imc-sim-service", (Object[])new Object[0]), json.getString("ruleName")));
            BillProcessTabCustomEvent.updateCustomControl(that, map, eventKey);
        }
        catch (Exception e) {
            LOGGER.error("\u5207\u6362\u62c6\u5206\u89c4\u5219\u5931\u8d25", (Throwable)e);
            BillProcessTabCustomEvent.handleExcepiton(that, e);
            BillProcessTabCustomEvent.updateCustomControlError(that, null, "bill/mergebill");
        }
    }

    private void splitByAmount(AbstractFormPlugin formPlugin, JSONObject json, String billStr, List<BillRelationDTO> billRelations) {
        BigDecimal equipmentLimitAmount;
        JSONObject billJson = JSON.parseObject((String)billStr);
        String invoiceType = billJson.getString("invoicetype");
        String isElePaper = billJson.getString("iselepaper");
        if (!InvoiceUtils.isAllEInvoice((Object)invoiceType) && !AllEleAuthHelper.isElePaper((Object)isElePaper) && MathUtils.isZero((BigDecimal)(equipmentLimitAmount = EquipmentHelper.getDevLimitAmountByInvoiceType((String)billJson.getString("invoicetype"), (String)json.getString("jqbh")).setScale(2, RoundingMode.HALF_UP)))) {
            formPlugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f00\u7968\u8bbe\u5907\u672a\u540c\u6b65\u9650\u989d\uff0c\u8bf7\u524d\u5f80 '\u57fa\u7840\u8d44\u6599-\u4f01\u4e1a\u7ba1\u7406-\u8bbe\u5907\u4fe1\u606f' \u914d\u7f6e\u8bbe\u5907\u9650\u989d", (String)"BillProcessTabCustomEvent_20", (String)"imc-sim-service", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("cacheBill", billStr);
        customParams.put("requestJson", json.toJSONString());
        customParams.put("billRelations", billRelations);
        long orgID = BillProcessTabCustomEvent.getCacheBillOrgId(billJson);
        DynamicObject hsSplitConfigDO = HSAmountSplitHelper.getHSAmountSplitConfigDynamicObject((long)orgID);
        if (hsSplitConfigDO == null || !hsSplitConfigDO.getBoolean("hssplitamountenable")) {
            ViewUtil.openDialog((AbstractFormPlugin)formPlugin, customParams, (String)"sim_bill_split_by_amount", (String)"sim_process_custom_split_amount");
            return;
        }
        BigDecimal hsLimit = HSAmountSplitHelper.getUserSetHSAmountLimitByInvoiceType((DynamicObject)hsSplitConfigDO, (String)invoiceType);
        if (MathUtils.isZero((BigDecimal)hsLimit)) {
            customParams.put("tips", String.format(ResManager.loadKDString((String)"%s \u672a\u8bbe\u7f6e\u542b\u7a0e\u91d1\u989d\u62c6\u5206\u9650\u989d", (String)"BillProcessTabCustomEvent_21", (String)"imc-sim-service", (Object[])new Object[0]), InvoiceType.getInvoiceDescription((String)invoiceType)));
            ViewUtil.openDialog((AbstractFormPlugin)formPlugin, customParams, (String)"sim_bill_split_by_amount", (String)"sim_process_custom_split_amount");
            return;
        }
        BigDecimal originBillTotalAmount = billJson.getBigDecimal("totalamount").setScale(2, RoundingMode.HALF_UP);
        if (originBillTotalAmount.compareTo(hsLimit) <= 0) {
            ViewUtil.openDialog((AbstractFormPlugin)formPlugin, customParams, (String)"sim_bill_split_by_amount", (String)"sim_process_custom_split_amount");
        } else {
            ViewUtil.openDialog((AbstractFormPlugin)formPlugin, customParams, (String)"sim_split_amount_auto", (String)"sim_process_custom_split_amount");
        }
    }

    public static long getCacheBillOrgId(JSONObject billJson) {
        long orgID = billJson.get((Object)"orgid") instanceof Long ? billJson.getLong("orgid") : (billJson.get((Object)"orgid") instanceof Integer ? (long)billJson.getInteger("orgid").intValue() : billJson.getJSONObject("orgid").getLong("id"));
        return orgID;
    }

    private void openRedInfoPage(AbstractFormPlugin that, String ars) {
        try {
            BillProcessTabCustomEvent.putPageCache(that, "workbenchIssueContent", ars);
            JSONObject arsJson = JSONObject.parseObject((String)ars);
            if (!arsJson.getBoolean("disabled").booleanValue()) {
                String applicant = arsJson.getString("applicant");
                String buyerTaxNo = arsJson.getString("buyertaxno");
                if (StringUtils.isBlank((CharSequence)applicant)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7533\u8bf7\u65b9\u7c7b\u578b", (String)"BillProcessTabCustomEvent_22", (String)"imc-sim-service", (Object[])new Object[0]));
                }
                if (StringUtils.isBlank((CharSequence)buyerTaxNo)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8d2d\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillProcessTabCustomEvent_23", (String)"imc-sim-service", (Object[])new Object[0]));
                }
                long currentOrgid = Long.parseLong(BillProcessTabCustomEvent.getPageCacheVal(that, "currentOrg"));
                QFilter redFilter = new QFilter("status", "=", (Object)"3").and("infosource", "!=", (Object)"5").and("org", "=", (Object)currentOrgid).and("buyertaxno", "=", (Object)buyerTaxNo);
                if (applicant.equals(RedInfoConstant.ApplicantEnum.SALER.getCode())) {
                    redFilter.and("applicant", "=", (Object)applicant);
                } else {
                    redFilter.and("applicant", "in", (Object)new String[]{RedInfoConstant.ApplicantEnum.BUYERNODEDUCTED.getCode(), RedInfoConstant.ApplicantEnum.BUYERDEDUCTED.getCode()});
                }
                String selectedInfoCodes = BillProcessTabCustomEvent.getPageCacheVal(that, "selectedInfoCodes");
                if (StringUtils.isNotBlank((CharSequence)selectedInfoCodes)) {
                    redFilter.and("infocode", "not in", (Object)JSONObject.parseObject((String)selectedInfoCodes).keySet());
                }
                String infocode = arsJson.getString("infoCode");
                String[] codeArr = null;
                if (StringUtils.isNotBlank((CharSequence)infocode)) {
                    String[] infos = infocode.split(",");
                    QFilter filter = new QFilter("infocode", "in", (Object)infos).and("org", "=", (Object)currentOrgid);
                    DynamicObject[] ids = BusinessDataServiceHelper.load((String)"sim_red_info", (String)"id", (QFilter[])filter.toArray());
                    codeArr = new String[ids.length];
                    for (int i = 0; i < ids.length; ++i) {
                        codeArr[i] = ids[i].getPkValue().toString();
                    }
                }
                ViewUtil.openListPage((AbstractFormPlugin)that, (QFilter)redFilter, (String)"sim_red_info", (String)"sim_red_info", (boolean)true, (boolean)true, codeArr);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u9009\u62e9\u7ea2\u5b57\u4fe1\u606f\u8868\u5931\u8d25", (Throwable)e);
            BillProcessTabCustomEvent.handleExcepiton(that, e);
        }
    }

    private void openBlueInfoPage(AbstractFormPlugin that, String ars) {
        JSONObject arsJson = JSONObject.parseObject((String)ars);
        if (!arsJson.getBoolean("disabled").booleanValue()) {
            BillProcessTabCustomEvent.putPageCache(that, "workbenchIssueContent", ars);
            String buyertaxno = arsJson.getString("buyertaxno");
            String invoicetype = arsJson.getString("invoicetype");
            String buyerProperty = arsJson.getString("buyerproperty");
            long currentOrgId = Long.parseLong(BillProcessTabCustomEvent.getPageCacheVal(that, "currentOrg"));
            QFilter blueFilter = new QFilter("invoicestatus", "in", (Object)InvoiceStatus.NormalStatusArray).and("orgid", "=", (Object)currentOrgId);
            if ("1".equals(buyerProperty)) {
                blueFilter.and("invoicetype", "in", (Object)InvoiceUtils.getNormalInvoiceType());
                ViewUtil.openListPage((AbstractFormPlugin)that, (QFilter)blueFilter, (String)"sim_choose_vatinvoice", (String)"blueinvoicecode", (String)"\u9009\u62e9\u84dd\u7968");
                return;
            }
            if (StringUtils.isNotBlank((CharSequence)buyertaxno)) {
                Set specialInvoiceType = InvoiceUtils.isSpecialInvoice((String)invoicetype) ? InvoiceUtils.getSpecialInvoiceType() : InvoiceUtils.getNormalInvoiceType();
                blueFilter.and("invoicetype", "in", (Object)specialInvoiceType);
                blueFilter.and("buyertaxno", "=", (Object)buyertaxno);
                ImmutableSet integerImmutableSet = ImmutableSet.of((Object)"8", (Object)"9", (Object)"10");
                blueFilter.and("buyertype", "not in", (Object)integerImmutableSet);
                blueFilter.and("issuetype", "=", (Object)IssueType.BLUE_INVOICE.getTypeCode());
                ViewUtil.openListPage((AbstractFormPlugin)that, (QFilter)blueFilter, (String)"sim_choose_vatinvoice", (String)"blueinvoicecode", (String)"\u9009\u62e9\u84dd\u7968");
                return;
            }
            that.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d2d\u65b9\u4fe1\u606f", (String)"BillProcessTabCustomEvent_24", (String)"imc-sim-service", (Object[])new Object[0]));
        }
    }

    public void queryMergeDeviation(AbstractFormPlugin that, String mergeBillId, String eventKey) {
        String mergeBillStr = BillProcessTabCustomEvent.getPageCacheVal(that, mergeBillId);
        Map billMap = (Map)SerializationUtils.fromJsonString((String)mergeBillStr, Map.class);
        DynamicObject bill = BusinessDataServiceHelper.newDynamicObject((String)"sim_original_bill");
        DynamicObjectUtil.map2DynamicObject((Map)billMap, (DynamicObject)bill);
        BillProcessTabCustomEvent.updateCustomControl(that, BillProcessTabCustomEvent.queryMergeDeviation(bill), eventKey);
    }
}

