/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill.workbench.task;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.sim.common.constant.RedConfirmBillRedReasonEnum;
import kd.imc.sim.common.constant.table.MatchBillConstant;
import kd.imc.sim.common.dto.minusbill.MinusBillDTO;
import kd.imc.sim.common.dto.minusbill.MinusBillMatchConfig;
import kd.imc.sim.formplugin.bill.originalbill.workbench.task.AbstractJobTask;
import kd.imc.sim.formplugin.match.BillMatchHelper;
import kd.imc.sim.formplugin.match.MinusBillMatchHelper;
import kd.imc.sim.formplugin.match.RedConfirmMatchHelper;

public class AutoBillMatchTask
extends AbstractJobTask {
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.feedbackProgress(0, ResManager.loadKDString((String)"\u5f00\u59cb\u81ea\u52a8\u5339\u914d", (String)"AutoBillMatchTask_0", (String)"imc-sim-formplugin", (Object[])new Object[0]), null);
        Map request = (Map)map.get("request");
        try (DLock lock = DLock.create((String)("AutoMatchLock" + RequestContext.get().getOrgId()));){
            if (!lock.tryLock(1000L)) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("success", Boolean.FALSE);
                result.put("errMsg", String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%s\u6b63\u5728\u81ea\u52a8\u5339\u914d\uff0c\u8bf7\u5339\u914d\u5b8c\u6210\u540e\u518d\u8fdb\u884c\u64cd\u4f5c", (String)"AutoBillMatchTask_1", (String)"imc-sim-formplugin", (Object[])new Object[0]), RequestContext.get().getOrgId()));
                this.feedbackCustomdata(result);
                return;
            }
            HashMap blueConfigMap = Maps.newHashMapWithExpectedSize((int)3);
            Object redPK = request.get("redConfig");
            Object bluePK = request.get("blueConfig");
            if (StringUtils.isBlank(redPK) || StringUtils.isBlank(bluePK)) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("success", Boolean.FALSE);
                result.put("errMsg", String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5339\u914d\u84dd\u7968/\u5339\u914d\u7ea2\u5b57\u786e\u8ba4\u5355\u89c4\u5219\uff0c\u8bf7\u5148\u914d\u7f6e", (String)"AutoBillMatchTask_5", (String)"imc-sim-formplugin", (Object[])new Object[0]), RequestContext.get().getOrgId()));
                this.feedbackCustomdata(result);
                return;
            }
            DynamicObject blueConfig = null;
            boolean isBlueConfigMap = false;
            if ("systemDefaultMatchByRedReasonCode".equals(bluePK.toString())) {
                long currentDataOrgId = Long.parseLong(request.get("currentDataOrgId").toString());
                blueConfigMap.put("1", BillMatchHelper.checkCtrlConfig("1", currentDataOrgId));
                blueConfigMap.put("3", BillMatchHelper.checkCtrlConfig("3", currentDataOrgId));
                blueConfigMap.put("4", BillMatchHelper.checkCtrlConfig("4", currentDataOrgId));
                isBlueConfigMap = true;
            } else {
                blueConfig = BusinessDataServiceHelper.loadSingle(bluePK, (String)"bdm_match_ori_inv_setting");
            }
            DynamicObject redConfig = BusinessDataServiceHelper.loadSingle(redPK, (String)"bdm_match_redconfirm");
            String redReason = (String)request.get("redReason");
            List matchBillListStr = (List)request.get("matchBills");
            ArrayList matchBillList = Lists.newArrayListWithCapacity((int)0);
            for (String matchBillStr : matchBillListStr) {
                DynamicObject matchBill = BusinessDataServiceHelper.newDynamicObject((String)"sim_match_bill");
                DynamicObjectUtil.json2DynamicObjectContainItems((JSONObject)JSONObject.parseObject((String)matchBillStr), (DynamicObject)matchBill, (boolean)true);
                if (MatchBillConstant.MatchStatusEnum.MATCH_SUCCESS.getCode().equals(matchBill.getString("matchstatus"))) continue;
                matchBillList.add(matchBill);
            }
            if (matchBillList.size() == 0) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("success", Boolean.FALSE);
                result.put("errMsg", String.format(ResManager.loadKDString((String)"\u5339\u914d\u5b8c\u6210\uff0c\u65e0\u9700\u518d\u6b21\u5339\u914d", (String)"AutoBillMatchTask_4", (String)"imc-sim-formplugin", (Object[])new Object[0]), RequestContext.get().getOrgId()));
                this.feedbackCustomdata(result);
                return;
            }
            this.autoMatchDataFormat(redConfig, blueConfig, redReason, matchBillList, blueConfigMap, isBlueConfigMap, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void autoMatchDataFormat(DynamicObject redConfig, DynamicObject blueConfig, String redReason, List<DynamicObject> matchBillList, Map<String, DynamicObject> blueConfigMap, boolean isBlueConfigMap, List<DynamicObject> matchBillLogList) {
        int num = 1;
        this.feedbackProgress(this.calculateProcess(num, matchBillList.size()), String.format(ResManager.loadKDString((String)"\u5171%1$s\u4e2a\u5355\u636e\uff0c\u7b2c%2$s\u4e2a\u5355\u636e", (String)"AutoBillMatchTask_2", (String)"imc-sim-formplugin", (Object[])new Object[0]), matchBillList.size(), num), null);
        ArrayList matchBillBlueList = Lists.newArrayListWithCapacity((int)0);
        ArrayList matchBillRedList = Lists.newArrayListWithCapacity((int)0);
        ArrayList matchBillSuccessList = Lists.newArrayListWithCapacity((int)0);
        for (DynamicObject dynamicObject : matchBillList) {
            dynamicObject.set("matchConfig", (Object)redConfig);
            if (!StringUtils.isEmpty((CharSequence)dynamicObject.getString("redreason"))) continue;
            dynamicObject.set("redreason", (Object)redReason);
        }
        for (DynamicObject dynamicObject : matchBillList) {
            if (RedConfirmBillRedReasonEnum.INVOICE_ERR.getBillCode().equals(dynamicObject.getString("redreason"))) {
                dynamicObject.set("matchstatus", (Object)MatchBillConstant.MatchStatusEnum.MATCH_FAIL.getCode());
                dynamicObject.set("matchtarget", (Object)"0");
                dynamicObject.set("matchtype", (Object)"1");
                matchBillSuccessList.add(dynamicObject);
                continue;
            }
            if (MatchBillConstant.MatchStatusEnum.MATCH_PART_SUCCESS.getCode().equals(dynamicObject.getString("matchstatus")) && "0".equals(dynamicObject.getString("matchtarget"))) {
                matchBillBlueList.add(dynamicObject);
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)dynamicObject.getString("blueinvoiceno"))) {
                matchBillBlueList.add(dynamicObject);
                continue;
            }
            matchBillRedList.add(dynamicObject);
        }
        if (redConfig != null) {
            RedConfirmMatchHelper redConfirmMatchHelper = new RedConfirmMatchHelper();
            redConfirmMatchHelper.matchRedConfirm(matchBillRedList);
            for (DynamicObject matchBill : matchBillRedList) {
                if (MatchBillConstant.MatchStatusEnum.MATCH_PART_SUCCESS.getCode().equals(matchBill.getString("matchstatus")) || MatchBillConstant.MatchStatusEnum.MATCH_SUCCESS.getCode().equals(matchBill.getString("matchstatus"))) {
                    matchBillSuccessList.add(matchBill);
                    continue;
                }
                matchBillBlueList.add(matchBill);
            }
        } else {
            for (DynamicObject dynamicObject : matchBillList) {
                if (MatchBillConstant.MatchStatusEnum.MATCH_PART_SUCCESS.getCode().equals(dynamicObject.getString("matchstatus")) && "1".equals(dynamicObject.getString("matchtarget"))) continue;
                matchBillBlueList.add(dynamicObject);
            }
        }
        if (matchBillSuccessList.size() != 0) {
            num = matchBillSuccessList.size();
            this.feedbackProgress(this.calculateProcess(num, matchBillList.size()), String.format(ResManager.loadKDString((String)"\u5171%1$s\u4e2a\u5355\u636e\uff0c\u7b2c%2$s\u4e2a\u5355\u636e", (String)"AutoBillMatchTask_2", (String)"imc-sim-formplugin", (Object[])new Object[0]), matchBillList.size(), num), null);
        }
        if (blueConfig != null || isBlueConfigMap) {
            MinusBillMatchHelper minusBillMatchHelper = new MinusBillMatchHelper();
            Object var13_20 = null;
            if (!isBlueConfigMap) {
                MinusBillMatchConfig minusBillMatchConfig = AutoBillMatchTask.buildMatchConfigByDynamicObject(blueConfig);
            }
            HashSet<Long> oriInvoiceIdSet = new HashSet<Long>(matchBillBlueList.size());
            List<String> isvExtFieldList = minusBillMatchHelper.getIsvExtFieldList();
            for (DynamicObject matchBillDynamic : matchBillBlueList) {
                void var13_23;
                this.feedbackProgress(this.calculateProcess(num, matchBillList.size()), String.format(ResManager.loadKDString((String)"\u5171%1$s\u4e2a\u5355\u636e\uff0c\u7b2c%2$s\u4e2a\u5355\u636e", (String)"AutoBillMatchTask_2", (String)"imc-sim-formplugin", (Object[])new Object[0]), matchBillList.size(), num), null);
                ++num;
                if (isBlueConfigMap) {
                    DynamicObject config = blueConfigMap.get(matchBillDynamic.getString("redreason"));
                    if (config == null) continue;
                    MinusBillMatchConfig minusBillMatchConfig = AutoBillMatchTask.buildMatchConfigByDynamicObject(config);
                }
                MinusBillDTO minusBillDTO = minusBillMatchHelper.createMinusBillByMatchBill((MinusBillMatchConfig)var13_23, matchBillDynamic);
                minusBillDTO.setMergebillId(Long.valueOf(matchBillDynamic.getLong("id")));
                minusBillDTO.setConfig((MinusBillMatchConfig)var13_23);
                if (StringUtils.isEmpty((CharSequence)minusBillDTO.getRedreason())) {
                    minusBillDTO.setRedreason(matchBillDynamic.getString("redreason"));
                }
                minusBillDTO.setMatchInvoiceIds(oriInvoiceIdSet);
                minusBillMatchHelper.match(minusBillDTO);
                matchBillDynamic.set("matchtarget", (Object)"0");
                matchBillDynamic.set("matchtype", (Object)"1");
                minusBillMatchHelper.updateMatchBill(isvExtFieldList, minusBillDTO, matchBillDynamic, oriInvoiceIdSet);
                matchBillSuccessList.add(matchBillDynamic);
            }
            if (!CollectionUtils.isEmpty(oriInvoiceIdSet)) {
                minusBillMatchHelper.updateInvoiceOccupyStatus(oriInvoiceIdSet, "1", "sim_vatinvoice");
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>(3);
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)0);
        for (DynamicObject dynamicObject : matchBillSuccessList) {
            arrayList.add(SerializationUtils.toJsonString((Object)dynamicObject));
        }
        result.put("success", Boolean.TRUE);
        result.put("matchBillList", arrayList);
        result.put("errMsg", ResManager.loadKDString((String)"\u5339\u914d\u5b8c\u6210", (String)"AutoBillMatchTask_3", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        this.feedbackCustomdata(result);
    }

    private int calculateProcess(int num, int size) {
        return num * 100 / size;
    }

    public static MinusBillMatchConfig buildMatchConfigByDynamicObject(DynamicObject matchConfig) {
        MinusBillMatchConfig config = new MinusBillMatchConfig();
        config.setId(Long.valueOf(matchConfig.getLong("id")));
        config.setStart(matchConfig.getInt("starttime"));
        config.setEnd(matchConfig.getInt("endtime"));
        config.setTimeType(matchConfig.getString("timerange"));
        config.setUnitPriceAffectType(matchConfig.getString("deviationtype"));
        config.setUnitPriceAffect(matchConfig.getBigDecimal("deviation"));
        config.setBlueOrder(matchConfig.getString("redrule"));
        config.setMatchSkp(Boolean.valueOf(matchConfig.getBoolean("canredtaxcontrol")));
        config.setIgnorePrice(Boolean.valueOf(matchConfig.getBoolean("ignoreprice")));
        config.setDiscountMatchPrice(Boolean.valueOf(matchConfig.getBoolean("discountmatchprice")));
        config.setMatchMultiRow(Boolean.valueOf(matchConfig.getBoolean("matchmulti")));
        config.setQuantityLimit(Integer.valueOf(matchConfig.getInt("quantitylimit")));
        config.setHeadField(matchConfig.getString("invoicematchkey"));
        config.setItemField(matchConfig.getString("itemmatchkey"));
        config.setAmountStandard(Boolean.valueOf(!"2".equals(matchConfig.getString("matchstandard"))));
        config.setMatchAmountField(StringUtils.isBlank((CharSequence)matchConfig.getString("discountmatchamount")) ? "itemremainredamount" : matchConfig.getString("discountmatchamount"));
        config.setMatchPriceField(StringUtils.isBlank((CharSequence)matchConfig.getString("matchpricetype")) ? "unitprice" : matchConfig.getString("matchpricetype"));
        config.setMatchValueAddedTaxuses(matchConfig.getString("valueaddedtaxuses"));
        config.setMatchCreditingStatus(matchConfig.getString("creditingstatus"));
        config.setMatchExciseTaxPurposes(matchConfig.getString("excisetaxpurposes"));
        config.setBlueItemCanMatchMultiRow(Boolean.valueOf(matchConfig.getBoolean("matchmultinega")));
        return config;
    }
}

