/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.splitMerge.helper;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.sim.common.constant.InvoiceConstant;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.common.utils.TaxCalcUtil;

public class BillCalcMethod {
    public static BigDecimal getTaxDeviation(DynamicObject tObj, DynamicObject item, BigDecimal taxAmount, BigDecimal tax) {
        return tax.subtract(TaxCalcUtil.calTax((BigDecimal)taxAmount.subtract(tax), (BigDecimal)BillCalcMethod.getDeduction(tObj, item), (String)item.getString("taxrate"), (boolean)false, (int)6));
    }

    public static BigDecimal getDeduction(DynamicObject tObj, DynamicObject item) {
        BigDecimal deduction = tObj.getBigDecimal("deduction");
        if (item.getBigDecimal("itemdeduction").compareTo(BigDecimal.ZERO) != 0) {
            deduction = item.getBigDecimal("itemdeduction");
        }
        return deduction;
    }

    public static void calcPrice(DynamicObject item, boolean isAllEle) {
        BigDecimal num = item.getBigDecimal("remainvalidnum");
        if (MathUtils.isNullOrZero((BigDecimal)num)) {
            item.set("taxunitprice", (Object)BigDecimal.ZERO);
            item.set("unitprice", (Object)BigDecimal.ZERO);
            return;
        }
        BigDecimal unitPrice = item.getBigDecimal("unitprice");
        int unitPriceLength = unitPrice.stripTrailingZeros().toPlainString().length();
        BigDecimal amount = item.getBigDecimal("remainvalidamount").subtract(item.getBigDecimal("remainvalidtax"));
        int priceMaxLength = 16;
        if (isAllEle) {
            priceMaxLength = 25;
        }
        if (BigDecimalUtil.compare((BigDecimal)BigDecimalUtil.multiply((BigDecimal)num, (BigDecimal)unitPrice), (BigDecimal)amount, (BigDecimal)InvoiceConstant.DIFF_01) || unitPriceLength > priceMaxLength) {
            item.set("unitprice", (Object)PriceHelper.calcPriceOrNum((BigDecimal)amount, (BigDecimal)num, (boolean)isAllEle));
        }
        BigDecimal taxUnitPrice = item.getBigDecimal("taxunitprice");
        int taxUnitPriceLength = taxUnitPrice.stripTrailingZeros().toPlainString().length();
        if (BigDecimalUtil.compare((BigDecimal)BigDecimalUtil.multiply((BigDecimal)num, (BigDecimal)taxUnitPrice), (BigDecimal)item.getBigDecimal("remainvalidamount"), (BigDecimal)InvoiceConstant.DIFF_01) || taxUnitPriceLength > priceMaxLength) {
            item.set("taxunitprice", (Object)PriceHelper.calcPriceOrNum((BigDecimal)item.getBigDecimal("remainvalidamount"), (BigDecimal)num, (boolean)isAllEle));
        }
    }

    @Deprecated
    public static BigDecimal calcBillTax(BigDecimal itemTaxAmount, BigDecimal tax, BigDecimal deduction, String taxRate, int calcCount) {
        return BillCalcMethod.calcBillTax(itemTaxAmount, tax, deduction, taxRate, calcCount, InvoiceConstant.DIFFF_06);
    }

    static BigDecimal calcBillTax(BigDecimal itemTaxAmount, BigDecimal tax, BigDecimal deduction, String taxRate, int calcCount, BigDecimal singleDiff) {
        if (calcCount > 5) {
            return TaxCalcUtil.calTax((BigDecimal)itemTaxAmount, (BigDecimal)deduction, (String)taxRate, (boolean)true, (int)2);
        }
        BigDecimal calcTax = TaxCalcUtil.calTax((BigDecimal)itemTaxAmount.subtract(tax), (BigDecimal)deduction, (String)taxRate, (boolean)false, (int)2);
        BigDecimal calcTaxRepeat = TaxCalcUtil.calTax((BigDecimal)itemTaxAmount.subtract(calcTax), (BigDecimal)deduction, (String)taxRate, (boolean)false, (int)6);
        if (BigDecimalUtil.compare((BigDecimal)calcTaxRepeat, (BigDecimal)calcTax, (BigDecimal)singleDiff)) {
            return BillCalcMethod.calcBillTax(itemTaxAmount, calcTax, deduction, taxRate, calcCount + 1, singleDiff);
        }
        return calcTax;
    }
}

