/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.splitMerge.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.orm.util.CollectionUtils;
import kd.imc.bdm.common.dto.BillRelationDTO;
import kd.imc.bdm.common.util.BigDecimalUtil;

public class BillInvoiceRelationHelper {
    public static List<BillRelationDTO> mergeRelation(List<BillRelationDTO> billRelations, List<BillRelationDTO> invRelations) {
        Map<Long, List<BillRelationDTO>> billRelationMap = billRelations.stream().collect(Collectors.groupingBy(BillRelationDTO::gettDetailId));
        ArrayList<BillRelationDTO> relationList = new ArrayList<BillRelationDTO>(invRelations.size());
        for (BillRelationDTO invRelation : invRelations) {
            if ("-1".equals(invRelation.getPushType())) {
                Map<Long, List<BillRelationDTO>> billInvRelationMap = billRelations.stream().collect(Collectors.groupingBy(BillRelationDTO::gettBillId));
                List<BillRelationDTO> relatePush = billInvRelationMap.get(invRelation.getsBillId());
                for (BillRelationDTO push : relatePush) {
                    if (!relationList.stream().noneMatch(relation -> relation.gettBillId().equals(invRelation.gettBillId()) && relation.getsBillId().equals(push.getsBillId()))) continue;
                    BillInvoiceRelationHelper.handleSingleRelation(invRelation, push, relationList);
                }
                continue;
            }
            List<BillRelationDTO> billRelationlist = billRelationMap.get(invRelation.getsDetailId());
            if (billRelationlist.size() == 1) {
                BillInvoiceRelationHelper.handleSingleRelation(invRelation, billRelationlist.get(0), relationList);
                continue;
            }
            BillInvoiceRelationHelper.handleMergeRelation(invRelation, billRelationlist, relationList);
        }
        BillInvoiceRelationHelper.handleZeroPushRelation(billRelations, invRelations, relationList);
        return relationList;
    }

    private static void handleSingleRelation(BillRelationDTO relation, BillRelationDTO billRelationDTO, List<BillRelationDTO> relationList) {
        BillRelationDTO newRelation = new BillRelationDTO(billRelationDTO.getsBillId(), billRelationDTO.getsBillNo(), billRelationDTO.getsDetailId(), relation.gettBillId(), relation.gettBillNo(), relation.gettDetailId(), relation.getAmount(), relation.getTax(), relation.getNum(), relation.getPrice(), relation.gettTable(), relation.getPushType(), billRelationDTO.getOrgId().longValue());
        relationList.add(newRelation);
        BillInvoiceRelationHelper.calcRelation(billRelationDTO, relation);
    }

    private static void handleMergeRelation(BillRelationDTO invRelation, List<BillRelationDTO> billRelationlist, List<BillRelationDTO> relationList) {
        boolean isPositiveAndNegative = billRelationlist.stream().anyMatch(o -> o.getAmount().compareTo(BigDecimal.ZERO) > 0) && billRelationlist.stream().anyMatch(o -> o.getAmount().compareTo(BigDecimal.ZERO) < 0);
        BigDecimal amount = BigDecimal.ZERO;
        if (isPositiveAndNegative) {
            amount = billRelationlist.stream().map(BillRelationDTO::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        for (BillRelationDTO billRelation : billRelationlist) {
            if (billRelation.getAmount().compareTo(BigDecimal.ZERO) == 0) continue;
            if (!isPositiveAndNegative) {
                if (!BillInvoiceRelationHelper.handleMergeCommonRelation(billRelation, invRelation, relationList)) continue;
                break;
            }
            BillInvoiceRelationHelper.handleMergePositiveAndNegativeRelation(billRelationlist, relationList, billRelation, invRelation, amount.compareTo(BigDecimal.ZERO) > 0);
        }
    }

    private static void handleZeroPushRelation(List<BillRelationDTO> billRelations, List<BillRelationDTO> invRelations, List<BillRelationDTO> relationList) {
        List zeroRelations = billRelations.stream().filter(BillRelationDTO::isPushZero).collect(Collectors.toList());
        for (BillRelationDTO zeroRelation : zeroRelations) {
            List relations;
            if (zeroRelation.gettDetailId() == 0L) {
                List relations2 = invRelations.stream().filter(relation -> relation.getsBillId().equals(zeroRelation.gettBillId())).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(relations2)) continue;
                BillInvoiceRelationHelper.addZeroRelation(zeroRelation, (BillRelationDTO)relations2.get(0), relationList);
                continue;
            }
            List notZeroRelations = billRelations.stream().filter(relation -> relation.gettDetailId().equals(zeroRelation.gettDetailId()) && !relation.isPushZero()).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(notZeroRelations) || CollectionUtils.isEmpty(relations = relationList.stream().filter(relation -> relation.getsDetailId().equals(((BillRelationDTO)notZeroRelations.get(0)).getsDetailId())).collect(Collectors.toList()))) continue;
            BillInvoiceRelationHelper.addZeroRelation(zeroRelation, (BillRelationDTO)relations.get(0), relationList);
        }
    }

    private static void addZeroRelation(BillRelationDTO zeroRelation, BillRelationDTO relation, List<BillRelationDTO> relationList) {
        BillRelationDTO newRelation = new BillRelationDTO(zeroRelation.getsBillId(), zeroRelation.getsBillNo(), zeroRelation.getsDetailId(), relation.gettBillId(), relation.gettBillNo(), relation.gettDetailId(), zeroRelation.getAmount(), zeroRelation.getTax(), zeroRelation.getNum(), zeroRelation.getPrice(), relation.gettTable(), relation.getPushType(), zeroRelation.getOrgId().longValue());
        relationList.add(newRelation);
    }

    private static void handleMergePositiveAndNegativeRelation(List<BillRelationDTO> billRelationlist, List<BillRelationDTO> relationList, BillRelationDTO billRelation, BillRelationDTO invRelation, boolean isPositive) {
        BigDecimal negetiveOrPositiveAmounts = BigDecimal.ZERO;
        BigDecimal negetiveOrPositiveNums = BigDecimal.ZERO;
        BigDecimal negetiveOrPositiveTaxs = BigDecimal.ZERO;
        ArrayList<BillRelationDTO> negetiveOrPositiveList = new ArrayList<BillRelationDTO>(billRelationlist.size());
        for (BillRelationDTO billRelationDTO : billRelationlist) {
            if ((!isPositive || billRelationDTO.getAmount().compareTo(BigDecimal.ZERO) >= 0) && (isPositive || billRelationDTO.getAmount().compareTo(BigDecimal.ZERO) <= 0)) continue;
            negetiveOrPositiveAmounts = BigDecimalUtil.add((BigDecimal)negetiveOrPositiveAmounts, (BigDecimal)billRelationDTO.getAmount());
            negetiveOrPositiveNums = BigDecimalUtil.add((BigDecimal)negetiveOrPositiveNums, (BigDecimal)billRelationDTO.getNum());
            negetiveOrPositiveTaxs = BigDecimalUtil.add((BigDecimal)negetiveOrPositiveTaxs, (BigDecimal)billRelationDTO.getTax());
            negetiveOrPositiveList.add(billRelationDTO);
        }
        for (BillRelationDTO billRelationDTO : negetiveOrPositiveList) {
            BillRelationDTO newRelation = new BillRelationDTO(billRelationDTO.getsBillId(), billRelationDTO.getsBillNo(), billRelationDTO.getsDetailId(), invRelation.gettBillId(), invRelation.gettBillNo(), invRelation.gettDetailId(), billRelationDTO.getAmount(), billRelationDTO.getTax(), billRelationDTO.getNum(), billRelationDTO.getPrice(), invRelation.gettTable(), invRelation.getPushType(), billRelationDTO.getOrgId().longValue());
            billRelationDTO.setAmount(BigDecimal.ZERO);
            billRelationDTO.setTax(BigDecimal.ZERO);
            billRelationDTO.setNum(BigDecimal.ZERO);
            relationList.add(newRelation);
        }
        List positiveOrNegetiveList = isPositive ? billRelationlist.stream().filter(relation -> relation.getAmount().compareTo(BigDecimal.ZERO) > 0).sorted(Comparator.comparing(BillRelationDTO::getAmount).reversed()).collect(Collectors.toList()) : billRelationlist.stream().filter(relation -> relation.getAmount().compareTo(BigDecimal.ZERO) < 0).sorted(Comparator.comparing(BillRelationDTO::getAmount)).collect(Collectors.toList());
        for (BillRelationDTO billRelationDTO : positiveOrNegetiveList) {
            BillRelationDTO newRelation;
            if (billRelationDTO.getAmount().compareTo(BigDecimal.ZERO) == 0 || negetiveOrPositiveAmounts.compareTo(BigDecimal.ZERO) == 0) continue;
            if (negetiveOrPositiveAmounts.abs().compareTo(billRelationDTO.getAmount().abs()) <= 0) {
                newRelation = new BillRelationDTO(billRelationDTO.getsBillId(), billRelationDTO.getsBillNo(), billRelationDTO.getsDetailId(), invRelation.gettBillId(), invRelation.gettBillNo(), invRelation.gettDetailId(), negetiveOrPositiveAmounts.negate(), negetiveOrPositiveTaxs.negate(), negetiveOrPositiveNums.negate(), billRelationDTO.getPrice(), invRelation.gettTable(), invRelation.getPushType(), billRelationDTO.getOrgId().longValue());
                billRelationDTO.setAmount(BigDecimalUtil.add((BigDecimal)billRelationDTO.getAmount(), (BigDecimal)negetiveOrPositiveAmounts));
                billRelationDTO.setTax(BigDecimalUtil.add((BigDecimal)billRelationDTO.getTax(), (BigDecimal)negetiveOrPositiveTaxs));
                billRelationDTO.setNum(BigDecimalUtil.add((BigDecimal)billRelationDTO.getNum(), (BigDecimal)negetiveOrPositiveNums));
                relationList.add(newRelation);
                break;
            }
            newRelation = new BillRelationDTO(billRelationDTO.getsBillId(), billRelationDTO.getsBillNo(), billRelationDTO.getsDetailId(), invRelation.gettBillId(), invRelation.gettBillNo(), invRelation.gettDetailId(), billRelationDTO.getAmount(), billRelationDTO.getTax(), billRelationDTO.getNum(), billRelationDTO.getPrice(), invRelation.gettTable(), invRelation.getPushType(), billRelationDTO.getOrgId().longValue());
            negetiveOrPositiveAmounts = BigDecimalUtil.add((BigDecimal)negetiveOrPositiveAmounts, (BigDecimal)billRelationDTO.getAmount());
            negetiveOrPositiveTaxs = BigDecimalUtil.add((BigDecimal)negetiveOrPositiveTaxs, (BigDecimal)billRelationDTO.getTax());
            negetiveOrPositiveNums = BigDecimalUtil.add((BigDecimal)negetiveOrPositiveNums, (BigDecimal)billRelationDTO.getNum());
            billRelationDTO.setTax(BigDecimal.ZERO);
            billRelationDTO.setAmount(BigDecimal.ZERO);
            billRelationDTO.setNum(BigDecimal.ZERO);
            relationList.add(newRelation);
        }
        BillInvoiceRelationHelper.handleMergeCommonRelation(billRelation, invRelation, relationList);
    }

    private static boolean handleMergeCommonRelation(BillRelationDTO billRelation, BillRelationDTO invRelation, List<BillRelationDTO> relationList) {
        if (billRelation.getAmount().compareTo(BigDecimal.ZERO) == 0) {
            return true;
        }
        if (billRelation.getAmount().abs().compareTo(invRelation.getAmount().abs()) >= 0) {
            BillRelationDTO newRelation = new BillRelationDTO(billRelation.getsBillId(), billRelation.getsBillNo(), billRelation.getsDetailId(), invRelation.gettBillId(), invRelation.gettBillNo(), invRelation.gettDetailId(), invRelation.getAmount(), invRelation.getTax(), invRelation.getNum(), invRelation.getPrice(), invRelation.gettTable(), invRelation.getPushType(), billRelation.getOrgId().longValue());
            relationList.add(newRelation);
            BillInvoiceRelationHelper.calcRelation(billRelation, invRelation);
            return true;
        }
        BillRelationDTO newRelation = new BillRelationDTO(billRelation.getsBillId(), billRelation.getsBillNo(), billRelation.getsDetailId(), invRelation.gettBillId(), invRelation.gettBillNo(), invRelation.gettDetailId(), billRelation.getAmount(), billRelation.getTax(), billRelation.getNum(), billRelation.getPrice(), invRelation.gettTable(), invRelation.getPushType(), billRelation.getOrgId().longValue());
        relationList.add(newRelation);
        BillInvoiceRelationHelper.calcRelation(invRelation, billRelation);
        return false;
    }

    private static void calcRelation(BillRelationDTO relation, BillRelationDTO subRelation) {
        relation.setAmount(BigDecimalUtil.subtract((BigDecimal)relation.getAmount(), (BigDecimal)subRelation.getAmount()));
        relation.setTax(BigDecimalUtil.subtract((BigDecimal)relation.getTax(), (BigDecimal)subRelation.getTax()));
        relation.setNum(relation.getNum().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : BigDecimalUtil.subtract((BigDecimal)relation.getNum(), (BigDecimal)subRelation.getNum()));
        subRelation.setAmount(BigDecimal.ZERO);
        subRelation.setTax(BigDecimal.ZERO);
        subRelation.setNum(BigDecimal.ZERO);
    }
}

