/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.splitMerge.helper;

import com.google.common.base.Splitter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.imc.bdm.common.dto.BillRelationDTO;
import kd.imc.bdm.common.dto.merge.MergeRemoveBillDTO;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.formplugin.bill.splitMerge.helper.BillCheckMethod;
import kd.imc.sim.formplugin.bill.splitMerge.helper.BillMergeMethod;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class BillNegativeOffsetMethod {
    static MergeRemoveBillDTO differentGoodsItemsMerge(List<BillRelationDTO> relations, Map<Long, DynamicObject> detailId2BillMap, DynamicObject bill, DynamicObject rule, boolean positiveIssue) {
        DynamicObjectCollection items;
        List negativeItems;
        BillCheckMethod.checkPartApply(detailId2BillMap, bill, relations);
        Pair<List<DynamicObject>, Map<String, List<DynamicObject>>> pair = BillNegativeOffsetMethod.buildOffsetMap(rule, bill);
        if (((List)pair.getKey()).size() == 0) {
            return null;
        }
        if (positiveIssue && bill.getBigDecimal("totalamount").compareTo(BigDecimal.ZERO) <= 0 && CollectionUtils.isNotEmpty(negativeItems = (items = bill.getDynamicObjectCollection("sim_original_bill_item")).stream().filter(item -> "2".equals(item.getString("rowtype")) && item.getBigDecimal("remainvalidamount").compareTo(BigDecimal.ZERO) < 0).sorted(Comparator.comparing(item -> item.getBigDecimal("remainvalidamount"))).collect(Collectors.toList()))) {
            return BillNegativeOffsetMethod.findMaxRemoveNegativeBill((DynamicObject)negativeItems.get(0), relations, detailId2BillMap);
        }
        boolean isNumAdd = "3".equals(rule.getString("negativeoffset")) || "2".equals(rule.getString("negativenumtype"));
        boolean isFollowDetailMerge = "3".equals(rule.getString("negativeoffset"));
        Map beOffsetItemMaps = (Map)pair.getValue();
        Stream<Object> offsetingStream = ((List)pair.getKey()).stream();
        if (positiveIssue) {
            offsetingStream = offsetingStream.sorted(Comparator.comparing(item -> item.getBigDecimal("remainvalidamount"), Comparator.reverseOrder()));
        }
        List offsettingItemList = offsetingStream.collect(Collectors.toList());
        for (DynamicObject offsettingItem : offsettingItemList) {
            List<DynamicObject> beOffsetItemList;
            List beOffsetItems;
            String mapKey = isFollowDetailMerge ? BillMergeMethod.getMergeBillDetailKey(offsettingItem, bill.getString("hsbz"), rule, false) : offsettingItem.getString("taxrate");
            List list = beOffsetItems = beOffsetItemMaps.get(mapKey) == null ? new ArrayList() : (List)beOffsetItemMaps.get(mapKey);
            if (isNumAdd) {
                Stream<Object> stream = beOffsetItems.stream();
                stream = offsettingItem.getBigDecimal("remainvalidnum").compareTo(BigDecimal.ZERO) != 0 ? stream.filter(item -> item.getBigDecimal("remainvalidnum").compareTo(BigDecimal.ZERO) != 0).filter(item -> BillNegativeOffsetMethod.amountAndNumIsAllBigOrAllSmall(item, offsettingItem)).sorted(Comparator.comparing(o -> o.getBigDecimal("remainvalidnum").abs(), Comparator.reverseOrder())) : stream.sorted(Comparator.comparing(o -> o.getBigDecimal("remainvalidamount").abs(), Comparator.reverseOrder()));
                beOffsetItemList = stream.collect(Collectors.toList());
            } else {
                beOffsetItemList = beOffsetItems.stream().sorted(Comparator.comparing(o -> o.getBigDecimal("remainvalidamount").add(o.getBigDecimal("discountamount")).abs(), Comparator.reverseOrder())).collect(Collectors.toList());
            }
            if ("2".equals(rule.getString("negativeoffset")) && "2".equals(rule.getString("priceoffsettype"))) {
                beOffsetItemList = BillNegativeOffsetMethod.checkPriceDeviationOffset(offsettingItem, beOffsetItemList, rule);
            }
            boolean isRepeatOffset = BillNegativeOffsetMethod.executeOffset(offsettingItem, beOffsetItemList, bill, rule, relations, positiveIssue);
            if (!positiveIssue || !isRepeatOffset) continue;
            return BillNegativeOffsetMethod.findMaxRemoveNegativeBill(offsettingItem, relations, detailId2BillMap);
        }
        return null;
    }

    private static MergeRemoveBillDTO findMaxRemoveNegativeBill(DynamicObject offsettingItem, List<BillRelationDTO> relations, Map<Long, DynamicObject> detailId2BillMap) {
        List mergeRelationList = relations.stream().filter(relation -> relation.gettDetailId().longValue() == offsettingItem.getLong("id")).filter(relation -> relation.getAmount().compareTo(BigDecimal.ZERO) < 0).sorted(Comparator.comparing(BillRelationDTO::getAmount)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(mergeRelationList)) {
            MergeRemoveBillDTO mergeRemoveBill = new MergeRemoveBillDTO();
            DynamicObject sBill = detailId2BillMap.get(((BillRelationDTO)mergeRelationList.get(0)).getsDetailId());
            mergeRemoveBill.setBillId(Long.valueOf(sBill.getLong("id")));
            mergeRemoveBill.setBillNo(sBill.getString("billno"));
            mergeRemoveBill.setTotalAmount(sBill.getBigDecimal("totalamount"));
            return mergeRemoveBill;
        }
        return null;
    }

    static void removeNegativeBill(MergeRemoveBillDTO removeBill, List<BillRelationDTO> relations, DynamicObject bill) {
        String billNo = bill.getString("billno");
        ArrayList billNoList = new ArrayList(Splitter.on((String)",").splitToList((CharSequence)billNo));
        billNoList.remove(removeBill.getBillNo());
        bill.set("billno", (Object)String.join((CharSequence)",", billNoList));
        List removeRelationList = relations.stream().filter(relation -> relation.getsBillId().equals(removeBill.getBillId())).collect(Collectors.toList());
        DynamicObjectCollection items = bill.getDynamicObjectCollection("sim_original_bill_item");
        Map<Long, DynamicObject> itemMap = items.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v, (v1, v2) -> v1));
        for (BillRelationDTO relation2 : removeRelationList) {
            DynamicObject item = itemMap.get(relation2.gettDetailId());
            if (item == null) continue;
            item.set("remainvalidamount", (Object)item.getBigDecimal("remainvalidamount").subtract(relation2.getAmount()).subtract(relation2.getTax()));
            item.set("remainvalidtax", (Object)item.getBigDecimal("remainvalidtax").subtract(relation2.getTax()));
            item.set("remainvalidnum", (Object)item.getBigDecimal("remainvalidnum").subtract(relation2.getNum()));
            if (item.getBigDecimal("remainvalidamount").compareTo(BigDecimal.ZERO) != 0) continue;
            items.remove((Object)item);
        }
        BillMergeMethod.calcBillHeadAmount(bill);
        relations.removeAll(removeRelationList);
    }

    private static boolean amountAndNumIsAllBigOrAllSmall(DynamicObject item, DynamicObject offsettingItem) {
        int amountCompareValue = item.getBigDecimal("remainvalidamount").add(item.getBigDecimal("discountamount")).abs().compareTo(offsettingItem.getBigDecimal("remainvalidamount").abs());
        int numCompareValue = offsettingItem.getBigDecimal("remainvalidnum").compareTo(BigDecimal.ZERO) == 0 ? 1 : item.getBigDecimal("remainvalidnum").abs().compareTo(offsettingItem.getBigDecimal("remainvalidnum").abs());
        return amountCompareValue * numCompareValue > 0;
    }

    private static void checkCanOffsetItems(List<DynamicObject> canOffsetItemList, DynamicObject bill, boolean positiveIssue) {
        if (positiveIssue) {
            return;
        }
        if (CollectionUtils.isEmpty(canOffsetItemList)) {
            if (bill.getBigDecimal("totalamount").compareTo(BigDecimal.ZERO) > 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5408\u5e76\u5931\u8d25\uff0c\u8d1f\u6570\u5546\u54c1\u51b2\u62b5\u4e0d\u4e86,\u5f00\u7968\u7533\u8bf7\u5355\u7f16\u53f7%s\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u9700\u8981\u5408\u5e76\u7684\u5355\u636e\uff01", (String)"BillNegativeOffsetMethod_1", (String)"imc-sim-service", (Object[])new Object[0]), bill.getString("billno")));
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5408\u5e76\u5931\u8d25\uff0c\u6b63\u6570\u5546\u54c1\u51b2\u62b5\u4e0d\u4e86,\u5f00\u7968\u7533\u8bf7\u5355\u7f16\u53f7%s\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u9700\u8981\u5408\u5e76\u7684\u5355\u636e\uff01", (String)"BillNegativeOffsetMethod_2", (String)"imc-sim-service", (Object[])new Object[0]), bill.getString("billno")));
        }
    }

    private static List<DynamicObject> checkPriceDeviationOffset(DynamicObject offsettingItem, List<DynamicObject> orderOffsetItemList, DynamicObject rule) {
        ArrayList<DynamicObject> canOffsetItems = new ArrayList<DynamicObject>(orderOffsetItemList.size());
        for (DynamicObject offsetItem : orderOffsetItemList) {
            BigDecimal rightPrice;
            BigDecimal offsettingUnitPrice = offsettingItem.getBigDecimal("unitprice");
            BigDecimal offsetUnitPrice = offsetItem.getBigDecimal("unitprice");
            if (MathUtils.isNullOrZero((BigDecimal)offsettingUnitPrice)) {
                if (!MathUtils.isNullOrZero((BigDecimal)offsetUnitPrice)) continue;
                canOffsetItems.add(offsetItem);
                continue;
            }
            BigDecimal leftPrice = offsettingUnitPrice.multiply(BigDecimal.ONE.add(rule.getBigDecimal("deviationleft").divide(new BigDecimal(100), 5, 4)));
            if (offsetUnitPrice.compareTo(leftPrice) < 0 || offsetUnitPrice.compareTo(rightPrice = offsettingUnitPrice.multiply(BigDecimal.ONE.add(rule.getBigDecimal("deviationright").divide(new BigDecimal(100), 5, 4)))) > 0) continue;
            canOffsetItems.add(offsetItem);
        }
        return canOffsetItems;
    }

    private static boolean executeOffset(DynamicObject offsettingItem, List<DynamicObject> beOffsetItemList, DynamicObject bill, DynamicObject rule, List<BillRelationDTO> relations, boolean positiveIssue) {
        int compare;
        DynamicObject canOffsetItem;
        BillNegativeOffsetMethod.checkCanOffsetItems(beOffsetItemList, bill, positiveIssue);
        boolean isNumAdd = "3".equals(rule.getString("negativeoffset")) || "2".equals(rule.getString("negativenumtype"));
        DynamicObjectCollection mergeItems = bill.getDynamicObjectCollection("sim_original_bill_item");
        Iterator<DynamicObject> iterator = beOffsetItemList.iterator();
        while (iterator.hasNext()) {
            canOffsetItem = iterator.next();
            if (isNumAdd && !BillNegativeOffsetMethod.amountAndNumIsAllBigOrAllSmall(canOffsetItem, offsettingItem)) continue;
            compare = canOffsetItem.getBigDecimal("remainvalidamount").add(canOffsetItem.getBigDecimal("discountamount")).abs().compareTo(offsettingItem.getBigDecimal("remainvalidamount").abs());
            if (compare > 0) {
                relations.stream().filter(relation -> relation.gettDetailId().equals(offsettingItem.getLong("id"))).forEach(relation -> relation.settDetailId(Long.valueOf(canOffsetItem.getLong("id"))));
                BillNegativeOffsetMethod.calcOffset(mergeItems, canOffsetItem, offsettingItem);
                return false;
            }
            if (canOffsetItem.getBigDecimal("discountamount").compareTo(BigDecimal.ZERO) != 0) continue;
            if (compare == 0) {
                iterator.remove();
                if (beOffsetItemList.size() == 0) {
                    BillNegativeOffsetMethod.checkCanOffsetItems(new ArrayList<DynamicObject>(1), bill, positiveIssue);
                    return true;
                }
                relations.stream().filter(relation -> relation.gettDetailId().equals(canOffsetItem.getLong("id"))).forEach(relation -> relation.settDetailId(Long.valueOf(((DynamicObject)beOffsetItemList.get(0)).getLong("id"))));
                mergeItems.remove((Object)canOffsetItem);
                relations.stream().filter(relation -> relation.gettDetailId().equals(offsettingItem.getLong("id"))).forEach(relation -> relation.settDetailId(Long.valueOf(((DynamicObject)beOffsetItemList.get(0)).getLong("id"))));
                mergeItems.remove((Object)offsettingItem);
                return false;
            }
            BillNegativeOffsetMethod.calcOffset(mergeItems, offsettingItem, canOffsetItem);
            if (beOffsetItemList.size() != 0) {
                iterator.remove();
                if (beOffsetItemList.size() == 0) {
                    BillNegativeOffsetMethod.checkCanOffsetItems(new ArrayList<DynamicObject>(1), bill, positiveIssue);
                    return true;
                }
                relations.stream().filter(relation -> relation.gettDetailId().equals(canOffsetItem.getLong("id"))).forEach(relation -> relation.settDetailId(Long.valueOf(offsettingItem.getLong("id"))));
                continue;
            }
            BillNegativeOffsetMethod.checkCanOffsetItems(new ArrayList<DynamicObject>(1), bill, positiveIssue);
            return true;
        }
        if (offsettingItem.getBigDecimal("remainvalidamount").compareTo(BigDecimal.ZERO) != 0 && beOffsetItemList.size() > 0 && (compare = (canOffsetItem = beOffsetItemList.get(0)).getBigDecimal("remainvalidamount").add(canOffsetItem.getBigDecimal("discountamount")).abs().compareTo(offsettingItem.getBigDecimal("remainvalidamount").abs())) > 0 && (!isNumAdd || BillNegativeOffsetMethod.amountAndNumIsAllBigOrAllSmall(canOffsetItem, offsettingItem))) {
            relations.stream().filter(relation -> relation.gettDetailId().equals(offsettingItem.getLong("id"))).forEach(relation -> relation.settDetailId(Long.valueOf(canOffsetItem.getLong("id"))));
            BillNegativeOffsetMethod.calcOffset(mergeItems, canOffsetItem, offsettingItem);
        }
        if (offsettingItem.getBigDecimal("remainvalidamount").compareTo(BigDecimal.ZERO) != 0) {
            BillNegativeOffsetMethod.checkCanOffsetItems(new ArrayList<DynamicObject>(1), bill, positiveIssue);
            return true;
        }
        return false;
    }

    private static void calcOffset(DynamicObjectCollection mergeItems, DynamicObject item, DynamicObject removeItem) {
        mergeItems.remove((Object)removeItem);
        item.set("remainvalidamount", (Object)item.getBigDecimal("remainvalidamount").add(removeItem.getBigDecimal("remainvalidamount")));
        item.set("remainvalidtax", (Object)item.getBigDecimal("remainvalidtax").add(removeItem.getBigDecimal("remainvalidtax")));
        item.set("remainvalidnum", (Object)item.getBigDecimal("remainvalidnum").add(removeItem.getBigDecimal("remainvalidnum")));
        removeItem.set("remainvalidamount", (Object)BigDecimal.ZERO);
        removeItem.set("remainvalidnum", (Object)BigDecimal.ZERO);
        removeItem.set("remainvalidtax", (Object)BigDecimal.ZERO);
    }

    private static Pair<List<DynamicObject>, Map<String, List<DynamicObject>>> buildOffsetMap(DynamicObject rule, DynamicObject bill) {
        boolean isFollowDetailMerge = "3".equals(rule.getString("negativeoffset"));
        boolean isAmountBiggerThanZero = bill.getBigDecimal("totalamount").compareTo(BigDecimal.ZERO) > 0;
        DynamicObjectCollection mergeItems = bill.getDynamicObjectCollection("sim_original_bill_item");
        ArrayList<DynamicObject> offsetItemList = new ArrayList<DynamicObject>(mergeItems.size());
        HashMap<String, List> beOffsetItemMap = new HashMap<String, List>(mergeItems.size());
        for (int i = 0; i < mergeItems.size(); ++i) {
            DynamicObject mergeItem = (DynamicObject)mergeItems.get(i);
            if ("1".equals(mergeItem.getString("rowtype"))) continue;
            BigDecimal discountAmount = BigDecimal.ZERO;
            if (i != mergeItems.size() - 1 && "1".equals(((DynamicObject)mergeItems.get(i + 1)).getString("rowtype"))) {
                discountAmount = ((DynamicObject)mergeItems.get(i + 1)).getBigDecimal("remainvalidamount");
            }
            mergeItem.set("discountamount", (Object)discountAmount);
            if (bill.getBigDecimal("totalamount").multiply(mergeItem.getBigDecimal("remainvalidamount")).compareTo(BigDecimal.ZERO) > 0) {
                String mapKey = isFollowDetailMerge ? BillMergeMethod.getMergeBillDetailKey(mergeItem, bill.getString("hsbz"), rule, false) : mergeItem.getString("taxrate");
                List list = beOffsetItemMap.computeIfAbsent(mapKey, k -> new ArrayList());
                list.add(mergeItem);
                continue;
            }
            if (i != mergeItems.size() - 1 && "1".equals(((DynamicObject)mergeItems.get(i + 1)).getString("rowtype")) && !isAmountBiggerThanZero) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u88ab\u6298\u6263\u884c\u51b2\u62b5\u8d1f\u6570\u884c", (String)"BillNegativeOffsetMethod_4", (String)"imc-sim-service", (Object[])new Object[0]), bill.getString("billno")));
            }
            offsetItemList.add(mergeItem);
        }
        return Pair.of(offsetItemList, beOffsetItemMap);
    }

    static void handleNumZero(DynamicObject mergeRule, boolean isMergeDetail, DynamicObject tObj, List<BillRelationDTO> relations) {
        List numZeroItems;
        if (!isMergeDetail) {
            return;
        }
        if (!"1".equals(mergeRule.getString("samerowtypemerge")) || !"2".equals(mergeRule.getString("numzerohandletype"))) {
            return;
        }
        DynamicObjectCollection mergeItems = tObj.getDynamicObjectCollection("sim_original_bill_item");
        HashMap<String, List> taxRateMap = new HashMap<String, List>(mergeItems.size());
        HashMap<Object, List> numZeroItemsMap = new HashMap<Object, List>(mergeItems.size());
        for (int i = 0; i < mergeItems.size(); ++i) {
            DynamicObject mergeItem = (DynamicObject)mergeItems.get(i);
            if ("1".equals(mergeItem.getString("rowtype"))) continue;
            if (MathUtils.isNullOrZero((BigDecimal)mergeItem.getBigDecimal("remainvalidnum"))) {
                DynamicObject nextItem;
                boolean hasNum = relations.stream().filter(relation -> relation.gettDetailId().equals(mergeItem.getLong("id"))).anyMatch(relation -> !MathUtils.isNullOrZero((BigDecimal)relation.getNum()));
                if (!hasNum) continue;
                numZeroItems = numZeroItemsMap.computeIfAbsent(mergeItem.get("id"), k -> new ArrayList());
                numZeroItems.add(mergeItem);
                if (i == mergeItems.size() - 1 || !"1".equals((nextItem = (DynamicObject)mergeItems.get(i + 1)).getString("rowtype"))) continue;
                numZeroItems.add(mergeItems.get(i + 1));
                ++i;
                continue;
            }
            List taxRateGroup = taxRateMap.computeIfAbsent(mergeItem.getString("taxrate"), k -> new ArrayList());
            taxRateGroup.add(mergeItem);
        }
        if (numZeroItemsMap.size() == 0) {
            return;
        }
        Set entries = numZeroItemsMap.entrySet();
        for (Map.Entry entry : entries) {
            numZeroItems = (List)entry.getValue();
            DynamicObject numZeroItem = (DynamicObject)numZeroItems.get(0);
            List sameRateList = (List)taxRateMap.get(numZeroItem.getString("taxrate"));
            if (CollectionUtils.isEmpty((Collection)sameRateList)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5546\u54c1\u884c\u5206\u644a\u4e0d\u4e86,\u5f00\u7968\u7533\u8bf7\u5355\u7f16\u53f7%1$s\uff0c\u5546\u54c1\u540d\u79f0%2$s\uff0c\u5546\u54c1\u7a0e\u7387%3$s\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u9700\u8981\u5408\u5e76\u7684\u5355\u636e\uff01", (String)"BillNegativeOffsetMethod_3", (String)"imc-sim-service", (Object[])new Object[0]), tObj.getString("billno"), numZeroItem.getString("goodsname"), numZeroItem.getString("taxrate")));
            }
            sameRateList.sort((k1, k2) -> k2.getBigDecimal("remainvalidamount").compareTo(k1.getBigDecimal("remainvalidamount")));
            DynamicObject maxSameRate = (DynamicObject)sameRateList.get(0);
            BillNegativeOffsetMethod.mergeNumZeroRow2MaxRow(maxSameRate, numZeroItem, relations, mergeItems);
            if (numZeroItems.size() != 2) continue;
            DynamicObject numZeroDiscountItem = (DynamicObject)numZeroItems.get(1);
            DynamicObject maxSameRateDiscount = BillNegativeOffsetMethod.getMaxSameRateDiscount(mergeItems, maxSameRate);
            if (maxSameRateDiscount == null) {
                DynamicObject remove = mergeItems.remove(mergeItems.indexOf((Object)numZeroDiscountItem));
                mergeItems.add(mergeItems.indexOf((Object)maxSameRate) + 1, remove);
                numZeroDiscountItem.set("goodsname", maxSameRate.get("goodsname"));
                continue;
            }
            BillNegativeOffsetMethod.mergeNumZeroRow2MaxRow(maxSameRateDiscount, numZeroDiscountItem, relations, mergeItems);
        }
    }

    private static void mergeNumZeroRow2MaxRow(DynamicObject maxSameRate, DynamicObject numZeroItem, List<BillRelationDTO> relations, DynamicObjectCollection mergeItems) {
        maxSameRate.set("remainvalidamount", (Object)maxSameRate.getBigDecimal("remainvalidamount").add(numZeroItem.getBigDecimal("remainvalidamount")));
        maxSameRate.set("remainvalidtax", (Object)maxSameRate.getBigDecimal("remainvalidtax").add(numZeroItem.getBigDecimal("remainvalidtax")));
        relations.stream().filter(relation -> relation.gettDetailId().equals(numZeroItem.getLong("id"))).forEach(relation -> relation.settDetailId(Long.valueOf(maxSameRate.getLong("id"))));
        mergeItems.remove((Object)numZeroItem);
    }

    private static DynamicObject getMaxSameRateDiscount(DynamicObjectCollection mergeItems, DynamicObject maxSameRate) {
        int maxSameRateIndex = mergeItems.indexOf((Object)maxSameRate);
        if (maxSameRateIndex == mergeItems.size() - 1) {
            return null;
        }
        DynamicObject nextRow = (DynamicObject)mergeItems.get(maxSameRateIndex + 1);
        if ("1".equals(nextRow.getString("rowtype"))) {
            return nextRow;
        }
        return null;
    }
}

